<?php
/**
 * View for display comment
 *
 * This file is part of Zoph.
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @package Zoph
 * @author Jeroen Roos
 */

namespace comment\view;

use template\block;
use template\template;

use comment;
use user;

/**
 * This view displays a comment
 */
class display extends view implements \view {

    /**
     * Get actionlinks
     * @return array actionlinks
     */
    protected function getActionlinks() : array {
        $user=user::getCurrent();
        $actionlinks=array(
            "return"    =>  "photo.php?photo_id=" . $this->object->getPhoto()->getId()
        );

        if ($user->isAdmin() || $this->object->isOwner($user)) {
            $actionlinks = array_merge($actionlinks, array(
                "edit"      =>  "comment.php?_action=edit&amp;comment_id=" . $this->object->getId(),
                "delete"    =>  "comment.php?_action=delete&amp;comment_id=" . $this->object->getId(),
            ));
        }
        return $actionlinks;
    }


    /**
     * Output view
     */
    public function view() : block {
        $user=user::getCurrent();

        $tpl=new block("main", array(
            "title"             => $this->getTitle(),
        ));

        $tpl->addActionlinks($this->getActionlinks());
        $tpl->addBlock($this->object->getPhoto()->getImageTag(MID_PREFIX));

        $tpl->addBlock(new block("definitionlist", array(
            "class" => "display comment",
            "dl"    => $this->object->getDisplayArray()
        )));

        return $tpl;
    }
}
