
package ONVIF::PTZ::Elements::ContinuousMove;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver20/ptz/wsdl' }

__PACKAGE__->__set_name('ContinuousMove');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ProfileToken_of :ATTR(:get<ProfileToken>);
my %Velocity_of :ATTR(:get<Velocity>);
my %Timeout_of :ATTR(:get<Timeout>);

__PACKAGE__->_factory(
    [ qw(        ProfileToken
        Velocity
        Timeout

    ) ],
    {
        'ProfileToken' => \%ProfileToken_of,
        'Velocity' => \%Velocity_of,
        'Timeout' => \%Timeout_of,
    },
    {
        'ProfileToken' => 'ONVIF::PTZ::Types::ReferenceToken',
        'Velocity' => 'ONVIF::PTZ::Types::PTZSpeed',
        'Timeout' => 'SOAP::WSDL::XSD::Typelib::Builtin::duration',
    },
    {

        'ProfileToken' => 'ProfileToken',
        'Velocity' => 'Velocity',
        'Timeout' => 'Timeout',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::PTZ::Elements::ContinuousMove

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
ContinuousMove from the namespace http://www.onvif.org/ver20/ptz/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ProfileToken

 $element->set_ProfileToken($data);
 $element->get_ProfileToken();




=item * Velocity

 $element->set_Velocity($data);
 $element->get_Velocity();




=item * Timeout

 $element->set_Timeout($data);
 $element->get_Timeout();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::PTZ::Elements::ContinuousMove->new($data);

Constructor. The following data structure may be passed to new():

 {
   ProfileToken => $some_value, # ReferenceToken
   Velocity =>  { # ONVIF::PTZ::Types::PTZSpeed
     PanTilt => ,
     Zoom => ,
   },
   Timeout =>  $some_value, # duration
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

