/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.Constant;
import org.javia.arity.Declaration;
import org.javia.arity.DeclarationParser;
import org.javia.arity.Function;
import org.javia.arity.FunctionAndName;
import org.javia.arity.Lexer;
import org.javia.arity.OptCodeGen;
import org.javia.arity.RPN;
import org.javia.arity.SimpleCodeGen;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;

class Compiler {
    private final SyntaxException exception = new SyntaxException();
    private final Lexer lexer = new Lexer(this.exception);
    private final RPN rpn = new RPN(this.exception);
    private final DeclarationParser declParser = new DeclarationParser(this.exception);
    private final OptCodeGen codeGen = new OptCodeGen(this.exception);
    private final SimpleCodeGen simpleCodeGen = new SimpleCodeGen(this.exception);
    private final Declaration decl = new Declaration();

    Compiler() {
    }

    double eval(Symbols symbols, String string) throws SyntaxException {
        this.rpn.setConsumer(this.simpleCodeGen.setSymbols(symbols));
        this.lexer.scan(string, this.rpn);
        return this.simpleCodeGen.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionAndName compile(Symbols symbols, String string) throws SyntaxException {
        Function function;
        block8: {
            function = null;
            this.decl.parse(string, this.lexer, this.declParser);
            if (this.decl.arity == -2) {
                try {
                    double d = this.eval(symbols, this.decl.expression);
                    function = new Constant(d);
                }
                catch (SyntaxException syntaxException) {
                    if (syntaxException == SimpleCodeGen.HAS_ARGUMENTS) break block8;
                    throw syntaxException;
                }
            }
        }
        if (function == null) {
            symbols.pushFrame();
            symbols.addArguments(this.decl.args);
            try {
                this.rpn.setConsumer(this.codeGen.setSymbols(symbols));
                this.lexer.scan(this.decl.expression, this.rpn);
            }
            finally {
                symbols.popFrame();
            }
            int n = this.decl.arity;
            if (n == -2) {
                n = this.codeGen.intrinsicArity;
            }
            function = this.codeGen.getFun(n);
        }
        return new FunctionAndName(function, this.decl.name);
    }
}

