#
# This module is provided as CTNLIB_USE_FILE by CTNLIBConfig.cmake.
# It can be INCLUDEd in a project to load the needed compiler and linker
# settings to use CTNLIB:
#   FIND_PACKAGE(CTNLIB REQUIRED)
#   INCLUDE(${CTNLIB_USE_FILE})

IF(NOT CTNLIB_USE_FILE_INCLUDED)
  SET(CTNLIB_USE_FILE_INCLUDED 1)

  # Load the compiler settings used for CTNLIB.
  IF(CTNLIB_BUILD_SETTINGS_FILE)
    INCLUDE(${CMAKE_ROOT}/Modules/CMakeImportBuildSettings.cmake)
    CMAKE_IMPORT_BUILD_SETTINGS(${CTNLIB_BUILD_SETTINGS_FILE})
  ENDIF(CTNLIB_BUILD_SETTINGS_FILE)

  # Add compiler flags needed to use CTNLIB.
  SET(CMAKE_C_FLAGS
    "${CMAKE_C_FLAGS} ${CTNLIB_REQUIRED_C_FLAGS}")
  SET(CMAKE_CXX_FLAGS
    "${CMAKE_CXX_FLAGS} ${CTNLIB_REQUIRED_CXX_FLAGS}")
  SET(CMAKE_EXE_LINKER_FLAGS
    "${CMAKE_EXE_LINKER_FLAGS} ${CTNLIB_REQUIRED_EXE_LINKER_FLAGS}")
  SET(CMAKE_SHARED_LINKER_FLAGS
    "${CMAKE_SHARED_LINKER_FLAGS} ${CTNLIB_REQUIRED_SHARED_LINKER_FLAGS}")
  SET(CMAKE_MODULE_LINKER_FLAGS
    "${CMAKE_MODULE_LINKER_FLAGS} ${CTNLIB_REQUIRED_MODULE_LINKER_FLAGS}")

  # Add include directories needed to use CTNLIB.
  INCLUDE_DIRECTORIES(${CTNLIB_INCLUDE_DIRS})

  # Add link directories needed to use CTNLIB.
  LINK_DIRECTORIES(${CTNLIB_LIBRARY_DIRS})

  # Add cmake module path.
  SET(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} "${CTNLIB_CMAKE_DIR}")

ENDIF(NOT CTNLIB_USE_FILE_INCLUDED)
