% umoci(1) # umoci - umoci modifies Open Container images
% Aleksa Sarai
% SEPTEMBER 2018
# NAME
umoci - umoci modifies Open Container images

# SYNOPSIS
**umoci**
[**--help**|**-h**]
[**--version**|**-v**]
[**--log**={*debug*|*info*|*warn*|*error*|*fatal*}]
[**--verbose**]
*command* [*args*]

# DESCRIPTION
**umoci** is a tool that allows for high-level modification of an OCI image
layout and its tagged images. While **umoci** attempts to abstract the OCI
image specification specifics, it is recommended that users of this tool read
through [the specification][1] to make sure they understand the rough idea.

**umoci** is unique in that it is, at the time of writing, the first tool to
allow for arbitrary modification of an OCI image in a high-level fashion (where
all of the different blobs in an OCI image are all managed by **umoci** when
doing a high-level operation such as **umoci-repack**(1)).

# GLOBAL OPTIONS

**--help, -h**
  Print usage statement.

**--version, -v**
  Print the version.

**--log**={*debug*|*info*|*warn*|*error*|*fatal*}
  Set the logging level. The default is "warn".

**--verbose**
  Alias for **--log=info**.

# COMMANDS

**init**
  Create a new OCI layout. See **umoci-init**(1) for more detailed usage
  information.

**new**
  Creates a blank tagged OCI image. See **umoci-new**(1) for more detailed
  usage information.

**unpack**
  Unpacks a tagged image into an OCI runtime bundle. See **umoci-unpack**(1)
  for more detailed usage information.

**repack**
  Repacks an OCI runtime bundle into a tagged image. See **umoci-repack**(1)
  for more detailed usage information.

**config**
  Modifies the image configuration of an OCI image. See **umoci-config**(1) for
  more detailed usage information.

**stat**
  Displays status information of an image manifest. See **umoci-stat**(1) for
  more detailed usage information.

**tag**
  Creates a new tag in an OCI image. See **umoci-tag**(1) for more detailed
  usage information.

**remove, rm**
  Removes a tag from an OCI image. See **umoci-remove**(1) for more detailed
  usage information.

**list, ls**
  Lists the set of tags in an OCI image. See **umoci-list**(1) for more
  detailed usage information.

**gc**
  Garbage collects all unreferenced OCI image blobs. See **umoci-gc**(1) for
  more detailed usage information.

# SEE ALSO
**umoci-init**(1),
**umoci-new**(1),
**umoci-unpack**(1),
**umoci-repack**(1),
**umoci-config**(1),
**umoci-stat**(1),
**umoci-tag**(1),
**umoci-remove**(1),
**umoci-list**(1),
**umoci-gc**(1),
**skopeo**(1)

[1]: https://github.com/opencontainers/image-spec
