/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef STATUSDIALOG_H
#define STATUSDIALOG_H

#include <QObject>
#include <QDialog>
#include <QLabel>
#include <QPushButton>

#include "fixlabel.h"

const QString vTen        = "v10";
const QString vTenEnhance = "v10.1";
const QString vFour = "v4";

#define THEME_STYLE_SCHEMA "org.ukui.style"
#define STYLE_NAME_KEY "style-name"
#define CONTAIN_STYLE_NAME_KEY "styleName"
#define UKUI_DEFAULT "ukui-default"
#define UKUI_DARK "ukui-dark"

class StatusDialog : public QDialog
{
    Q_OBJECT
public:
    StatusDialog(QWidget *parent = nullptr);
    ~StatusDialog();

private:
    void initUI();
    void getActivationCode();

public:
    QLabel *mLogoLabel;
    QLabel *mVersionLabel_1;
    FixLabel *mVersionLabel_2;
    FixLabel *mStatusLabel_1;
    QLabel *mStatusLabel_2;
    QLabel *mSerialLabel_1;
    FixLabel *mSerialLabel_2;
    FixLabel *mTimeLabel_1;
    QLabel *mTimeLabel_2;
    FixLabel *mActivationCodeLabel_1;
    FixLabel *mActivationCodeLabel_2;
    QPushButton *mExtentBtn;

private:
    QFrame *mVersionFrame;
    QFrame *mStatusFrame;
    QFrame *mSerialFrame;
    QFrame *mTimeFrame;
    QFrame *mActivationFrame;
};

#endif // STATUSDIALOG_H
