/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CHANGEUSERGROUP_H
#define CHANGEUSERGROUP_H

#include <QDialog>
#include <QFrame>
#include <QLabel>
#include <QPushButton>
#include <QHBoxLayout>
#include <QListWidget>
#include <QScrollArea>
#include <QLineEdit>
#include <QDBusInterface>
#include <QDBusArgument>
#include <QDBusReply>
#include <QList>
#include <QDebug>
#include <QScrollBar>
#include <polkit-qt5-1/polkitqt1-authority.h>
#include <QCoreApplication>
#include <QCheckBox>
#include <QTableView>
#include <QHeaderView>
#include <QStandardItemModel>
#include <QTableWidget>

#include "creategroupdialog.h"
#include "qtdbus/systemdbusdispatcher.h"
#include "userinfo.h"


struct custom_struct
{
    QString groupname;
    QString passphrase;
    QString groupid;
    QString usergroup;

    friend QDBusArgument &operator<<(QDBusArgument &argument, const custom_struct&mystruct)
    {
        argument.beginStructure();
        argument << mystruct.groupname << mystruct.passphrase << mystruct.groupid << mystruct.usergroup;
        argument.endStructure();
        return argument;
    }

    friend const QDBusArgument &operator>>(const QDBusArgument &argument, custom_struct&mystruct)
    {
        argument.beginStructure();
        argument >> mystruct.groupname >> mystruct.passphrase >> mystruct.groupid >> mystruct.usergroup;
        argument.endStructure();
        return argument;
    }

};
Q_DECLARE_METATYPE(custom_struct)

typedef struct _UserInfomations {
    QString objpath;
    QString username;
    QString iconfile;
    QString passwd;
    int accounttype;
    int passwdtype;
    bool current;
    bool logined;
    bool autologin;
    bool noPwdLogin;
    qint64 uid;
}UserInfomations;

class changeUserGroup : public QDialog
{
    Q_OBJECT

public:
    changeUserGroup(QWidget *parent = nullptr);
    ~changeUserGroup();

    QFrame* myLine();
    void initUI();
    void initStatus();
    void initConnect();
    bool polkitEdit();

public:
    QList<custom_struct *>  *groupList;

private:
    QVBoxLayout *vlayout = nullptr;

    QFrame *mUserGroupListFrame;
    QFrame *mAddOrDelUserGroupFrame;
    QFrame *mUserGroupInfoFrame;
    QFrame *mCancelAndConfirmFrame;
    QFrame *mUserGroupTableFrame;

    QPushButton *mAddUserGroupButton;
    QPushButton *mDelUserGroupButton;

    QFrame *mUserGroupFrame;
    QFrame *mUserGroupIdFrame;
    QFrame *mUserGroupNumbersFrame;

    QLabel *mUserGroupLabel;
    QLabel *mUserGroupIdLabel;
    QLabel *mUserGroupNumbersLabel;

    QLineEdit *mUserGroupLineEdit;
    QLineEdit *mUserGroupIdLineEdit;

    QFrame *mUserGroupNumbersListFrame;

    QPushButton *mCancelButton;
    QPushButton *mConfirmButton;

    QDBusInterface *serviceInterface;

    QList<custom_struct *>  *passwdList;

    SystemDbusDispatcher * sysdispatcher;
    QMap<QString, UserInfomations> allUserInfoMap;
    QTableView *allUserGroupTableView = nullptr;
    QStandardItemModel *mAllUserGroupModel = nullptr;
    QTableView *mUserGroupNumbersTableView = nullptr;
    QStandardItemModel *mUserGroupNumbersModel = nullptr;

    int currentRow = 0;
    bool _nameHasModified;
    bool _idHasModified;
    bool _boxModified;
    bool _deleteable = false;
    bool _addable = false;
    bool _editable;
    bool _deleted = false;

private:
    void connectToServer();
    void loadGroupInfo();
    void loadPasswdInfo();
    void loadAllGroup();
    void getUsersList(QString usergroup, QString groupName);
    UserInfomations _acquireUserInfo(QString objpath);
    void refreshCertainBtnStatus();
    void limitInput();
    void nameSetEnabled(bool isEnable);
    void idSetEnabled(bool idSetEnable);
    void refreshList();
    bool setTextDynamic(QLineEdit *lineEdit, QString string);
    void refreshDetialPage();

    void addUserGroupSlot();
    void delUserGroupSlot();
    void cancelUserGroupSlot();
    void saveUserGroupInfoSlot();
    void editUserGroupInfoSlot();
    void needRefreshSlot();

Q_SIGNALS:
    void needRefresh();
    void showDialog();
};
#endif // CHANGEUSERGROUP_H
