/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef THEMEWIDGET_H
#define THEMEWIDGET_H

#include <QWidget>
#include <QMouseEvent>
#include <QList>
#include <QPixmap>
#include <QRadioButton>
#include <QFrame>
#include <QGSettings>
#include "fixlabel.h"

#define THEME_QT_SCHEMA  "org.ukui.style"

class QLabel;

class ThemeWidget : public QFrame
{
    Q_OBJECT

public:
    explicit ThemeWidget(QSize iSize, QString name, QStringList iStringList , QWidget *parent = 0);
    explicit ThemeWidget(QSize iSize, QString name, const QList<QPixmap> &listMap , QWidget *parent = 0);
    ~ThemeWidget();

public:
    void setSelectedStatus(bool status);
    void setValue(QString value);
    QPixmap pixmapToRound(const QString &filePath, const QSize &scaledSize);
    QPixmap pixmapToRound(const QPixmap &pixmap, const QSize &scaledSize);
    QString getValue();

public:
    QLabel * placeHolderLabel;
    QLabel * selectedLabel;

protected:
    virtual void paintEvent(QPaintEvent * event);
    virtual void mousePressEvent(QMouseEvent * event);

private:
    QString pValue;
    QList<QPixmap> listMap;
    bool isCursor;

Q_SIGNALS:
    void clicked();

};

#endif // THEMEWIDGET_H
