/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef NUMBERSBUTTONINTEL_H
#define NUMBERSBUTTONINTEL_H

#include <QWidget>
#include <QPushButton>
#include <QGSettings/QGSettings>
#include "picturetowhite.h"

#define UKUI_QT_STYLE                      "org.ukui.style"
#define UKUI_STYLE_KEY                     "style-name"

class NumbersButtonIntel : public QWidget
{
    Q_OBJECT

public:
    NumbersButtonIntel(QWidget *parent = nullptr);
    ~NumbersButtonIntel();

Q_SIGNALS:
    void numbersButtonPress(int btn_id);

private:
    void initUI();
    void initConnect();
    void setQSS();

private:
    QPushButton *m_pNumerPressBT[12]; // 0~9 是数字按键 10是删除键 11是清空
    PictureToWhite *m_pPictureToWhite;
    QGSettings *m_style = nullptr;
};

#endif // NUMBERSBUTTONINTEL_H
