// $Id: Ds2401ToIeeeEui64C.nc,v 1.2 2010-06-29 22:07:45 scipio Exp $
/*
 * Copyright (c) 2007, Vanderbilt University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the copyright holders nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Janos Sallai
 */

#include "Ds2401.h"
#include "IeeeEui64.h"
#include "PlatformIeeeEui64.h"

/**
 * Convert silicon serial ID to IEEE EUI 64, according to Application Note
 * 186 - Creating Global Identifiers Using 1-Wire Devices from Dallas/Maxim.
 */
module Ds2401ToIeeeEui64C {
  uses interface HplDs2401 as Hpl;
  provides interface LocalIeeeEui64;
} implementation {

  command ieee_eui64_t LocalIeeeEui64.getId() {
    ds2401_serial_t rom;
    ieee_eui64_t eui;
    
    atomic {
      call Hpl.read(&rom);
    }

    // company ID
    eui.data[0] = IEEE_EUI64_COMPANY_ID_0;
    eui.data[1] = IEEE_EUI64_COMPANY_ID_1;
    eui.data[2] = IEEE_EUI64_COMPANY_ID_2;

    // 16 bits of the ID is generated by software
    // could be used for hardware model id and revision, for example
    eui.data[3] = IEEE_EUI64_SERIAL_ID_0;
    eui.data[4] = IEEE_EUI64_SERIAL_ID_1;

    // 24 least significant bits of the serial ID read from the DS2401
    eui.data[5] = rom.data[3];
    eui.data[6] = rom.data[2];
    eui.data[7] = rom.data[1];

    return eui;
  }
}
