/*
  Teem: Tools to process and visualize scientific data and images             .
  Copyright (C) 2011, 2010, 2009, 2008 Thomas Schultz
  Copyright (C) 2010, 2009, 2008 Gordon Kindlmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License
  (LGPL) as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  The terms of redistributing and/or modifying this software also
  include exceptions to the LGPL that facilitate static linking.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/* The idea is that you will #define TIJK_TABLE_TYPE to 0 (double) or 1 (float),
 * and then #include this file.
 * The issue here is that having separate double and float versions turned
 * out to give a 3-4fold speedup when computing with float.
 */

/* conversion matrices computed in Mathematica, stored in double precision */
#if TIJK_TABLE_TYPE == 0
static const double _tijk_sym2esh_o2_d[6*6] ={
#else
static const float _tijk_sym2esh_o2_f[6*6] ={
#endif
  1.1816359006036771806, 0, 0, 1.1816359006036771806, 0, 1.1816359006036771806,
  0.9152912328637688999, 0, 0, -0.9152912328637688999, 0, 0,
  0, 0, -1.8305824657275377998, 0, 0, 0,
  -0.52844363968080143579, 0, 0, -0.52844363968080143579, 0, 1.0568872793616028716,
  0, 0, 0, 0, -1.8305824657275377998, 0,
  0, 1.8305824657275377998, 0, 0, 0, 0
};
#if TIJK_TABLE_TYPE == 0
static const double _tijk_esh2sym_o2_d[6*6] ={
#else
static const float _tijk_esh2sym_o2_f[6*6] ={
#endif
  0.28209479177387819515, 0.54627421529603958916, 0, -0.31539156525252004526, 0, 0,
  0, 0, 0, 0, 0, 0.54627421529603958916,
  0, 0, -0.54627421529603958916, 0, 0, 0,
  0.28209479177387819515, -0.54627421529603958916, 0, -0.31539156525252004526, 0, 0,
  0, 0, 0, 0, -0.54627421529603958916, 0,
  0.28209479177387819515, 0, 0, 0.63078313050504009052, 0, 0
};
#if TIJK_TABLE_TYPE == 0
static const double _tijk_sym2esh_o4_d[15*15] ={
#else
static const float _tijk_sym2esh_o4_f[15*15] ={
#endif
  0.70898154036220639718, 0, 0, 1.4179630807244127944, 0, 1.4179630807244127944, 0, 0, 0, 0, 0.70898154036220639718, 0, 1.4179630807244127944, 0, 0.70898154036220639718,
  0.78453534245465905705, 0, 0, 0, 0, 0.78453534245465905705, 0, 0, 0, 0, -0.78453534245465905705, 0, -0.78453534245465905705, 0, 0,
  0, 0, -1.5690706849093181141, 0, 0, 0, 0, -1.5690706849093181141, 0, -1.5690706849093181141, 0, 0, 0, 0, 0,
  -0.45295169115497263546, 0, 0, -0.90590338230994527091, 0, 0.45295169115497263546, 0, 0, 0, 0, -0.45295169115497263546, 0, 0.45295169115497263546, 0, 0.90590338230994527091,
  0, 0, 0, 0, -1.5690706849093181141, 0, 0, 0, 0, 0, 0, -1.5690706849093181141, 0, -1.5690706849093181141, 0,
  0, 1.5690706849093181141, 0, 0, 0, 0, 1.5690706849093181141, 0, 1.5690706849093181141, 0, 0, 0, 0, 0, 0,
  0.1997329217870320861, 0, 0, -1.1983975307221925721, 0, 0, 0, 0, 0, 0, 0.1997329217870320861, 0, 0, 0, 0,
  0, 0, -0.56493001368725082045, 0, 0, 0, 0, 1.6947900410617524614, 0, 0, 0, 0, 0, 0, 0,
  -0.15098389705165754515, 0, 0, 0, 0, 0.90590338230994538193, 0, 0, 0, 0, 0.15098389705165754515, 0, -0.90590338230994538193, 0, 0,
  0, 0, 0.64057042473119185644, 0, 0, 0, 0, 0.64057042473119185644, 0, -0.85409389964158910491, 0, 0, 0, 0, 0,
  0.10128307719460090397, 0, 0, 0.20256615438920180794, 0, -0.81026461755680723176, 0, 0, 0, 0, 0.10128307719460090397, 0, -0.81026461755680723176, 0, 0.27008820585226911426,
  0, 0, 0, 0, 0.64057042473119185644, 0, 0, 0, 0, 0, 0, 0.64057042473119185644, 0, -0.85409389964158910491, 0,
  0, -0.3019677941033150903, 0, 0, 0, 0, -0.3019677941033150903, 0, 1.8118067646198907639, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, -1.6947900410617524614, 0, 0, 0, 0, 0, 0, 0.56493001368725082045, 0, 0, 0,
  0, 0.79893168714812834441, 0, 0, 0, 0, -0.79893168714812834441, 0, 0, 0, 0, 0, 0, 0, 0
};
#if TIJK_TABLE_TYPE == 0
static const double _tijk_esh2sym_o4_d[15*15] ={
#else
static const float _tijk_esh2sym_o4_f[15*15] ={
#endif
  0.28209479177387819515, 0.54627421529603970018, 0, -0.31539156525252004526, 0, 0, 0.62583573544917614484, 0, -0.47308734787878004013, 0, 0.31735664074561298342, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0.27313710764801985009, 0, 0, 0, 0, 0, 0, -0.23654367393939002007, 0, 0.62583573544917614484,
  0, 0, -0.27313710764801979458, 0, 0, 0, 0, -0.44253269244498261159, 0, 0.50178490766796690625, 0, 0, 0, 0, 0,
  0.094031597257959328995, -2.6239092990136782376e-17, 0, -0.10513052175084000583, 0, 0, -0.62583573544917614484, 0, -1.1695830935687379082e-17, 0, 0.10578554691520429543, 0, 0, 0, 0,
  0, 0, 0, 0, -0.091045702549339968535, 0, 0, 0, 0, 0, 0, 0.16726163588932230208, 0, -0.44253269244498261159, 0,
  0.094031597257959398384, 0.091045702549339926901, 0, 0.052565260875419995978, 0, 0, 9.2621981986301462932e-18, 0, 0.47308734787878004013, 0, -0.42314218766081729273, 0, 0, 0, 0,
  -0, -0, -0, -0, -0, 0.27313710764801979458, -0, -0, 0, 0, 0, 0, -0.23654367393939002007, 0, -0.62583573544917614484,
  0, 0, -0.091045702549339954657, 0, 0, 0, 0, 0.44253269244498261159, 0, 0.16726163588932227433, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0.091045702549339926901, 0, 0, 0, 0, 0, 0, 0.47308734787878004013, 0, 0,
  0, 0, -0.27313710764801979458, 0, 0, 0, 0, 0, 0, -0.66904654355728920834, 0, 0, 0, 0, 0,
  0.28209479177387819515, -0.54627421529603958916, 0, -0.31539156525252004526, 0, 0, 0.62583573544917614484, 0, 0.47308734787878004013, 0, 0.31735664074561298342, 0, 0, 0, 0,
  0, 0, 0, 0, -0.27313710764801979458, 0, 0, 0, 0, 0, 0, 0.50178490766796690625, 0, 0.44253269244498261159, 0,
  0.094031597257959370628, -0.091045702549339926901, 0, 0.052565260875420016795, 0, 0, 9.262198198630141671e-18, 0, -0.47308734787878004013, 0, -0.42314218766081729273, 0, 0, 0, 0,
  -0, -0, -0, -0, -0.27313710764801979458, -0, -0, -0, 0, 0, 0, -0.66904654355728920834, 0, 0, 0,
  0.28209479177387819515, 4.5022398477899912361e-18, -0, 0.63078313050504009052, -0, 0, 2.7789509525674121332e-17, -0, 2.3394324492700281759e-17, 0, 0.84628437532163458545, 0, 0, 0, 0
};
#if TIJK_TABLE_TYPE == 0
static const double _tijk_sym2esh_o6_d[28*28] ={
#else
static const float _tijk_sym2esh_o6_f[28*28] ={
#endif
  0.50641538597300450597, 0, 0, 1.5192461579190135179, 0, 1.5192461579190135179, 0, 0, 0, 0, 1.5192461579190135179, 0, 3.0384923158380270358, 0, 1.5192461579190135179, 0, 0, 0, 0, 0, 0, 0.50641538597300450597, 0, 1.5192461579190135179, 0, 1.5192461579190135179, 0, 0.50641538597300450597,
  0.65377945204554921421, 0, 0, 0.65377945204554921421, 0, 1.3075589040910984284, 0, 0, 0, 0, -0.65377945204554921421, 0, 0, 0, 0.65377945204554921421, 0, 0, 0, 0, 0, 0, -0.65377945204554921421, 0, -1.3075589040910984284, 0, -0.65377945204554921421, 0, 0,
  0, 0, -1.3075589040910984284, 0, 0, 0, 0, -2.6151178081821968568, 0, -2.6151178081821968568, 0, 0, 0, 0, 0, 0, -1.3075589040910984284, 0, -2.6151178081821968568, 0, -1.3075589040910984284, 0, 0, 0, 0, 0, 0, 0,
  -0.37745974262914383512, 0, 0, -1.1323792278874316164, 0, 0, 0, 0, 0, 0, -1.1323792278874316164, 0, 0, 0, 1.1323792278874316164, 0, 0, 0, 0, 0, 0, -0.37745974262914383512, 0, 0, 0, 1.1323792278874316164, 0, 0.75491948525828767025,
  0, 0, 0, 0, -1.3075589040910984284, 0, 0, 0, 0, 0, 0, -2.6151178081821968568, 0, -2.6151178081821968568, 0, 0, 0, 0, 0, 0, 0, 0, -1.3075589040910984284, 0, -2.6151178081821968568, 0, -1.3075589040910984284, 0,
  0, 1.3075589040910984284, 0, 0, 0, 0, 2.6151178081821968568, 0, 2.6151178081821968568, 0, 0, 0, 0, 0, 0, 1.3075589040910984284, 0, 2.6151178081821968568, 0, 1.3075589040910984284, 0, 0, 0, 0, 0, 0, 0, 0,
  0.27236307516413466034, 0, 0, -1.3618153758206730242, 0, 0.27236307516413466034, 0, 0, 0, 0, -1.3618153758206730242, 0, -1.634178450984807851, 0, 0, 0, 0, 0, 0, 0, 0, 0.27236307516413466034, 0, 0.27236307516413466034, 0, 0, 0, 0,
  0, 0, -0.77035910957352382589, 0, 0, 0, 0, 1.5407182191470476518, 0, -0.77035910957352382589, 0, 0, 0, 0, 0, 0, 2.3110773287205716997, 0, 2.3110773287205716997, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  -0.20588713234316941003, 0, 0, -0.20588713234316941003, 0, 1.0294356617158468836, 0, 0, 0, 0, 0.20588713234316941003, 0, 0, 0, 1.2353227940590163492, 0, 0, 0, 0, 0, 0, 0.20588713234316941003, 0, -1.0294356617158468836, 0, -1.2353227940590163492, 0, 0,
  0, 0, 0.8735051246334434305, 0, 0, 0, 0, 1.747010249266886861, 0, -0.29116837487781449534, 0, 0, 0, 0, 0, 0, 0.8735051246334434305, 0, -0.29116837487781449534, 0, -1.1646734995112579814, 0, 0, 0, 0, 0, 0, 0,
  0.13811328708354669859, 0, 0, 0.41433986125064004025, 0, -0.96679300958482672357, 0, 0, 0, 0, 0.41433986125064004025, 0, -1.9335860191696534471, 0, -0.73660419777891572579, 0, 0, 0, 0, 0, 0, 0.13811328708354669859, 0, -0.96679300958482672357, 0, -0.73660419777891572579, 0, 0.3683020988894578629,
  0, 0, 0, 0, 0.8735051246334434305, 0, 0, 0, 0, 0, 0, 1.747010249266886861, 0, -0.29116837487781449534, 0, 0, 0, 0, 0, 0, 0, 0, 0.8735051246334434305, 0, -0.29116837487781449534, 0, -1.1646734995112579814, 0,
  0, -0.41177426468633882006, 0, 0, 0, 0, -0.82354852937267764013, 0, 2.0588713234316937672, 0, 0, 0, 0, 0, 0, -0.41177426468633882006, 0, 2.0588713234316937672, 0, 2.4706455881180326983, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, -2.3110773287205716997, 0, 0, 0, 0, 0, 0, -1.5407182191470476518, 0, -2.3110773287205716997, 0, 0, 0, 0, 0, 0, 0, 0, 0.77035910957352382589, 0, 0.77035910957352382589, 0, 0, 0,
  0, 1.0894523006565386414, 0, 0, 0, 0, 0, 0, 1.0894523006565386414, 0, 0, 0, 0, 0, 0, -1.0894523006565386414, 0, -1.0894523006565386414, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0.045741696509788543068, 0, 0, -0.68612544764682814602, 0, 0, 0, 0, 0, 0, 0.68612544764682814602, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.045741696509788543068, 0, 0, 0, 0, 0, 0,
  0, 0, -0.15845388475869950917, 0, 0, 0, 0, 1.5845388475869950362, 0, 0, 0, 0, 0, 0, 0, 0, -0.7922694237934975181, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  -0.033782481739884073768, 0, 0, 0.16891240869942036884, 0, 0.33782481739884073768, 0, 0, 0, 0, 0.16891240869942036884, 0, -2.0269489043930444261, 0, 0, 0, 0, 0, 0, 0, 0, -0.033782481739884073768, 0, 0.33782481739884073768, 0, 0, 0, 0,
  0, 0, 0.18503427297440877553, 0, 0, 0, 0, -0.37006854594881755105, 0, -0.49342472793175679024, 0, 0, 0, 0, 0, 0, -0.5551028189232264376, 0, 1.4802741837952702042, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0.03083904549573479939, 0, 0, 0.03083904549573479939, 0, -0.49342472793175679024, 0, 0, 0, 0, -0.03083904549573479939, 0, 0, 0, 0.49342472793175679024, 0, 0, 0, 0, 0, 0, -0.03083904549573479939, 0, 0.49342472793175679024, 0, -0.49342472793175679024, 0, 0,
  0, 0, -0.19504324926415683716, 0, 0, 0, 0, -0.39008649852831367433, 0, 0.78017299705662734866, 0, 0, 0, 0, 0, 0, -0.19504324926415683716, 0, 0.78017299705662734866, 0, -0.31206919882265093946, 0, 0, 0, 0, 0, 0, 0,
  -0.021280963179598540863, 0, 0, -0.063842889538795632998, 0, 0.38305733723277379799, 0, 0, 0, 0, -0.063842889538795632998, 0, 0.76611467446554759597, 0, -0.51074311631036506398, 0, 0, 0, 0, 0, 0, -0.021280963179598540863, 0, 0.38305733723277379799, 0, -0.51074311631036506398, 0, 0.068099082174715330762,
  0, 0, 0, 0, -0.19504324926415683716, 0, 0, 0, 0, 0, 0, -0.39008649852831367433, 0, 0.78017299705662734866, 0, 0, 0, 0, 0, 0, 0, 0, -0.19504324926415683716, 0, 0.78017299705662734866, 0, -0.31206919882265093946, 0,
  0, 0.061678090991469598781, 0, 0, 0, 0, 0.12335618198293919756, 0, -0.98684945586351358049, 0, 0, 0, 0, 0, 0, 0.061678090991469598781, 0, -0.98684945586351358049, 0, 0.98684945586351358049, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0.5551028189232264376, 0, 0, 0, 0, 0, 0, 0.37006854594881755105, 0, -1.4802741837952702042, 0, 0, 0, 0, 0, 0, 0, 0, -0.18503427297440877553, 0, 0.49342472793175679024, 0, 0, 0,
  0, -0.13512992695953629507, 0, 0, 0, 0, 0, 0, 1.3512992695953629507, 0, 0, 0, 0, 0, 0, 0.13512992695953629507, 0, -1.3512992695953629507, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, -0.7922694237934975181, 0, 0, 0, 0, 0, 0, 1.5845388475869950362, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.15845388475869950917, 0, 0, 0, 0, 0,
  0, 0.27445017905873125841, 0, 0, 0, 0, -0.91483393019577097238, 0, 0, 0, 0, 0, 0, 0, 0, 0.27445017905873125841, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
#if TIJK_TABLE_TYPE == 0
static const double _tijk_esh2sym_o6_d[28*28] ={
#else
static const float _tijk_esh2sym_o6_f[28*28] ={
#endif
  0.28209479177387813964, 0.54627421529603947814, -0, -0.31539156525252010077, 0, 0, 0.62583573544917625586, 0, -0.47308734787877981809, 0, 0.31735664074561292791, 0, 0, 0, 0, 0.68318410519191441477, -0, -0.50456490072872428598, -0, 0.46060262975746169012, -0, -0.3178460113381422758, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0.1820914050986798538, 0, 0, 0, 0, 0, 0, -0.15769578262626005039, 0, 0.41722382363278409656, 0, 0, 0, 0, 0, 0, 0, 0, 0.15353420991915392446, 0, -0.33637660048581613514, 0, 0.68318410519191441477,
  0, 0, -0.1820914050986798538, 0, 0, 0, 0, -0.29502179496332175956, 0, 0.33452327177864454866, 0, 0, 0, 0, 0, 0, -0.39443652703862541742, 0, 0.46060262975746169012, 0, -0.48551780209894301876, 0, 0, 0, 0, 0, 0, 0,
  0.056418958354775637642, 0.03641828101973600823, 0, -0.063078313050504070114, 0, 0, -0.20861191181639207604, 0, -0.031539156525252097507, 0, 0.063471328149122610562, 0, 0, 0, 0, -0.68318410519191441477, 0, 0.16818830024290809533, 0, 0.030706841983830814036, 0, -0.063569202267628480141, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, -0.036418281019735959658, 0, 0, 0, 0, 0, 0, 0.066904654355728898629, 0, -0.17701307697799306684, 0, 0, 0, 0, 0, 0, 0, 0, -0.097103560419788570446, 0, 0.27636157785447712509, 0, -0.3944365270386253064, 0,
  0.056418958354775700093, 0.072836562039471974828, 0, 8.9555099447302666249e-17, 0, 0, 0.041722382363278368023, 0, 0.15769578262625988385, 0, -0.14809976568128604968, 0, 0, 0, 0, 8.2399365108898336985e-18, 0, 0.33637660048581619066, 0, -0.49130947174129246946, 0, 0.38141521360577063104, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0.10925484305920790673, 0, 0, 0, 0, 0, 0, -0.094617469575755980271, 0, 9.9611074597105719874e-19, 0, 0, 0, 0, 0, 0, 0, 0, 0.092120525951492338024, 0, 8.0230960763927328117e-18, 0, -0.68318410519191441477,
  0, 0, -0.036418281019735994353, 0, 0, 0, 0, 0.059004358992664346362, 0, 0.066904654355728898629, 0, 0, 0, 0, 0, 0, 0.3944365270386253064, 0, -0.092120525951492393535, 0, -0.097103560419788514935, 0, 0, 0, 0, 0, 0, 0,
  0, 0, -0, 0, 0, 0.036418281019735987414, 0, 0, 0, 0, 0, 0, 0.078847891313130025193, 0, 0.041722382363278409656, 0, -0, 0, -0, 0, -0, 0, 0, -0.24565473587064623473, 0, 0.33637660048581613514, 0, 0,
  0, 0, -0.10925484305920793449, 0, 0, 0, 0, -0.088506538488996491787, 0, -0.033452327177864449315, 0, 0, 0, 0, 0, 0, 2.6319007737085620136e-17, 0, -0.36848210380596935209, 0, 0.5826213625187315337, 0, 0, 0, 0, 0, 0, 0,
  0.056418958354775637642, -0.03641828101973600823, 0, -0.063078313050504000725, 0, 0, -0.20861191181639210379, 0, 0.031539156525251986485, 0, 0.063471328149122596685, 0, 0, 0, 0, 0.68318410519191441477, 0, 0.16818830024290809533, 0, -0.030706841983830793219, 0, -0.063569202267628466263, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, -0.036418281019736042925, 0, 0, 0, 0, 0, 0, 0.06690465435572895414, 0, -0.059004358992664346362, 0, 0, 0, 0, 0, 0, 0, 0, -0.097103560419788625957, 0, 0.092120525951492338024, 0, 0.3944365270386253064, 0,
  0.018806319451591866493, 1.0110185258427328847e-17, 0, -1.3230654636112171296e-17, 0, 0, -0.0417223823632783819, 0, 1.3002294553532411925e-16, 0, -0.049366588560428713295, 0, 0, 0, 0, -1.3356015512305807746e-17, 0, -0.33637660048581619066, 0, -1.5700602710305711085e-17, 0, 0.12713840453525690477, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, -0.036418281019735904147, 0, 0, 0, 0, 0, 0, -0.011150775725954853446, 0, -0.088506538488996519543, 0, 0, 0, 0, 0, 0, 0, 0, 0.19420712083957714089, 0, -0.36848210380596946312, 0, 2.1900883884207189567e-17, 0,
  0.056418958354775637642, 0.036418281019735987414, 0, 0.063078313050504000725, 0, 0, -3.4196600136376111153e-18, 0, 0.1892349391515119883, 0, -0.11283791670955127528, 0, 0, 0, 0, -2.5949050786116869342e-18, 0, 2.7570180441496557009e-18, 0, 0.49130947174129246946, 0, -0.50855361814102739704, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0.1820914050986798538, 0, 0, 0, 0, 0, 0, -0.15769578262626005039, 0, -0.41722382363278409656, 0, 0, 0, 0, 0, 0, 0, 0, 0.15353420991915392446, 0, 0.33637660048581613514, 0, 0.68318410519191441477,
  -0, 0, -0.036418281019735987414, 0, 0, 0, -0, 0.17701307697799303909, -0, 0.066904654355728884751, -0, 0, 0, 0, 0, 0, -0.3944365270386253064, 0, -0.27636157785447706958, 0, -0.097103560419788570446, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0.036418281019735959658, 0, 0, 0, 0, 0, 0, 0.078847891313130025193, 0, -0.041722382363278409656, 0, 0, 0, 0, 0, 0, 0, 0, -0.24565473587064623473, 0, -0.33637660048581613514, 0, 0,
  0, 0, -0.036418281019735924964, 0, 0, 0, 0, 0.08850653848899653342, 0, -0.011150775725954797934, 0, 0, 0, 0, 0, 0, -1.1722935989999516693e-17, 0, 0.36848210380596940761, 0, 0.19420712083957716865, 0, 0, 0, 0, 0, 0, 0,
  -0, -0, -0, -0, -0, 0.036418281019735966597, -0, -0, -0, -0, -0, -0, 0.18923493915151196054, -0, -1.9913267072906534227e-18, -0, -0, -0, -0, -0, -0, -0, -0, 0.49130947174129246946, 0, -1.6054589175247916872e-17, 0, 0,
  0, 0, -0.1820914050986798538, 0, 0, 0, 0, -6.4878668978875960741e-17, 0, -0.44603102903819275005, 0, 0, 0, 0, 0, 0, 1.3271784590120033334e-17, 0, 3.4095831958807153212e-17, 0, -0.77682848335830878561, 0, 0, 0, 0, 0, 0, 0,
  0.28209479177387813964, -0.54627421529603947814, -0, -0.31539156525252015628, -0, -0, 0.62583573544917625586, -0, 0.47308734787878015116, -0, 0.31735664074561292791, -0, -0, -0, -0, -0.68318410519191441477, -0, -0.50456490072872428598, -0, -0.46060262975746169012, -0, -0.3178460113381422758, -0, -0, 0, 0, 0, 0,
  -0, -0, -0, -0, -0.18209140509867988156, -0, -0, -0, -0, -0, -0, 0.33452327177864449315, 0, 0.29502179496332175956, 0, -0, -0, -0, -0, -0, -0, -0, -0.48551780209894290774, -0, -0.46060262975746180114, 0, -0.3944365270386253064, 0,
  0.056418958354775693154, -0.072836562039471988705, 0, 8.9555099447302666249e-17, 0, 0, 0.0417223823632783819, 0, -0.15769578262626013365, 0, -0.14809976568128604968, 0, 0, 0, 0, 1.4203048459560108085e-17, 0, 0.33637660048581613514, 0, 0.49130947174129246946, 0, 0.38141521360577063104, 0, 0, 0, 0, 0, 0,
  0, 0, -0, 0, -0.10925484305920793449, 0, 0, 0, 0, 0, 0, -0.033452327177864449315, 0, 0.088506538488996519543, 0, 0, -0, 0, -0, 0, -0, 0, 0.5826213625187315337, 0, 0.36848210380596946312, 0, -2.1900883884207189567e-17, 0,
  0.056418958354775637642, -0.036418281019735987414, 0, 0.063078313050503986847, 0, 0, -3.4113257779765173673e-18, 0, -0.1892349391515119883, 0, -0.11283791670955127528, 0, 0, 0, 0, -1.4522307270911557893e-17, 0, 2.7502987685461758766e-18, 0, -0.49130947174129246946, 0, -0.50855361814102739704, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, -0.18209140509867982605, -0, 0, 0, 0, 0, 0, -0.44603102903819269454, -0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.77682848335830867459, -0, 0, 0, 0, 0,
  0.28209479177387813964, 2.9630111695848276965e-22, 0, 0.63078313050504009052, 0, 0, -4.080980515248682738e-17, 0, 1.5216940301200840144e-17, 0, 0.84628437532163458545, 0, 0, 0, 0, 6.4189546310712161745e-17, 0, 3.2901916779719101699e-17, 0, 3.1736161082457363656e-17, 0, 1.017107236282054572, 0, 0, 0, 0, 0, 0
};
#if TIJK_TABLE_TYPE == 0
static const double _tijk_sym2esh_o8_d[45*45] ={
#else
static const float _tijk_sym2esh_o8_f[45*45] ={
#endif
  0.3938786335345590417, 0, 0, 1.5755145341382361668, 0, 1.5755145341382361668, 0, 0, 0, 0, 2.3632718012073543612, 0, 4.7265436024147087224, 0, 2.3632718012073543612, 0, 0, 0, 0, 0, 0, 1.5755145341382361668, 0, 4.7265436024147087224, 0, 4.7265436024147087224, 0, 1.5755145341382361668, 0, 0, 0, 0, 0, 0, 0, 0, 0.3938786335345590417, 0, 1.5755145341382361668, 0, 2.3632718012073543612, 0, 1.5755145341382361668, 0, 0.3938786335345590417,
0.5547219593113751346, 0, 0, 1.1094439186227502692, 0, 1.6641658779341255148, 0, 0, 0, 0, 0, 0, 1.6641658779341255148, 0, 1.6641658779341255148, 0, 0, 0, 0, 0, 0, -1.1094439186227502692, 0, -1.6641658779341255148, 0, 0, 0, 0.5547219593113751346, 0, 0, 0, 0, 0, 0, 0, 0, -0.5547219593113751346, 0, -1.6641658779341255148, 0, -1.6641658779341255148, 0, -0.5547219593113751346, 0, 0,
0, 0, -1.1094439186227502692, 0, 0, 0, 0, -3.3283317558682510295, 0, -3.3283317558682510295, 0, 0, 0, 0, 0, 0, -3.3283317558682510295, 0, -6.6566635117365020591, 0, -3.3283317558682510295, 0, 0, 0, 0, 0, 0, 0, 0, -1.1094439186227502692, 0, -3.3283317558682510295, 0, -3.3283317558682510295, 0, -1.1094439186227502692, 0, 0, 0, 0, 0, 0, 0, 0, 0,
-0.3202688725338190823, 0, 0, -1.2810754901352763291, 0, -0.3202688725338190823, 0, 0, 0, 0, -1.9216132352029144936, 0, -0.9608066176014572468, 0, 0.9608066176014572468, 0, 0, 0, 0, 0, 0, -1.2810754901352763291, 0, -0.9608066176014572468, 0, 1.9216132352029144936, 0, 1.6013443626690953003, 0, 0, 0, 0, 0, 0, 0, 0, -0.3202688725338190823, 0, -0.3202688725338190823, 0, 0.9608066176014572468, 0, 1.6013443626690953003, 0, 0.6405377450676381645,
0, 0, 0, 0, -1.1094439186227502692, 0, 0, 0, 0, 0, 0, -3.3283317558682510295, 0, -3.3283317558682510295, 0, 0, 0, 0, 0, 0, 0, 0, -3.3283317558682510295, 0, -6.6566635117365020591, 0, -3.3283317558682510295, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.1094439186227502692, 0, -3.3283317558682510295, 0, -3.3283317558682510295, 0, -1.1094439186227502692, 0,
0, 1.1094439186227502692, 0, 0, 0, 0, 3.3283317558682510295, 0, 3.3283317558682510295, 0, 0, 0, 0, 0, 0, 3.3283317558682510295, 0, 6.6566635117365020591, 0, 3.3283317558682510295, 0, 0, 0, 0, 0, 0, 0, 0, 1.1094439186227502692, 0, 3.3283317558682510295, 0, 3.3283317558682510295, 0, 1.1094439186227502692, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.2933140809459911513, 0, 0, -1.1732563237839646053, 0, 0.5866281618919823027, 0, 0, 0, 0, -2.9331408094599118463, 0, -2.9331408094599118463, 0, 0.2933140809459911513, 0, 0, 0, 0, 0, 0, -1.1732563237839646053, 0, -2.9331408094599118463, 0, -1.7598844856759472410, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.2933140809459911513, 0, 0.5866281618919823027, 0, 0.2933140809459911513, 0, 0, 0, 0,
0, 0, -0.8296175026176411116, 0, 0, 0, 0, 0.8296175026176411116, 0, -1.6592350052352822232, 0, 0, 0, 0, 0, 0, 4.1480875130882060020, 0, 3.3184700104705644463, 0, -0.8296175026176411116, 0, 0, 0, 0, 0, 0, 0, 0, 2.4888525078529233348, 0, 4.9777050157058466695, 0, 2.4888525078529233348, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
-0.2217246040618747471, 0, 0, -0.4434492081237494943, 0, 0.8868984162474989885, 0, 0, 0, 0, 0, 0, 0.8868984162474989885, 0, 2.4389706446806220796, 0, 0, 0, 0, 0, 0, 0.4434492081237494943, 0, -0.8868984162474989885, 0, 0, 0, 1.3303476243712484273, 0, 0, 0, 0, 0, 0, 0, 0, 0.2217246040618747471, 0, -0.8868984162474989885, 0, -2.4389706446806220796, 0, -1.3303476243712484273, 0, 0,
0, 0, 0.9406978265283237883, 0, 0, 0, 0, 2.8220934795849714760, 0, 0.6271318843522157849, 0, 0, 0, 0, 0, 0, 2.8220934795849714760, 0, 1.2542637687044315697, 0, -1.5678297108805396842, 0, 0, 0, 0, 0, 0, 0, 0, 0.9406978265283237883, 0, 0.6271318843522157849, 0, -1.5678297108805396842, 0, -1.2542637687044315697, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.1487373860899733613, 0, 0, 0.5949495443598934452, 0, -0.8924243165398402233, 0, 0, 0, 0, 0.8924243165398402233, 0, -2.6772729496195202259, 0, -1.8344277617763382615, 0, 0, 0, 0, 0, 0, 0.5949495443598934452, 0, -2.6772729496195202259, 0, -3.6688555235526765230, 0, -0.3966330295732622968, 0, 0, 0, 0, 0, 0, 0, 0, 0.1487373860899733613, 0, -0.8924243165398402233, 0, -1.8344277617763382615, 0, -0.3966330295732622968, 0, 0.3966330295732622968,
0, 0, 0, 0, 0.9406978265283237883, 0, 0, 0, 0, 0, 0, 2.8220934795849714760, 0, 0.6271318843522157849, 0, 0, 0, 0, 0, 0, 0, 0, 2.8220934795849714760, 0, 1.2542637687044315697, 0, -1.5678297108805396842, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.9406978265283237883, 0, 0.6271318843522157849, 0, -1.5678297108805396842, 0, -1.2542637687044315697, 0,
0, -0.4434492081237494943, 0, 0, 0, 0, -1.3303476243712484273, 0, 1.7737968324949979770, 0, 0, 0, 0, 0, 0, -1.3303476243712484273, 0, 3.5475936649899959541, 0, 4.8779412893612441593, 0, 0, 0, 0, 0, 0, 0, 0, -0.4434492081237494943, 0, 1.7737968324949979770, 0, 4.8779412893612441593, 0, 2.6606952487424968545, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -2.4888525078529233348, 0, 0, 0, 0, 0, 0, -4.1480875130882060020, 0, -4.9777050157058466695, 0, 0, 0, 0, 0, 0, 0, 0, -0.8296175026176411116, 0, -3.3184700104705644463, 0, -2.4888525078529233348, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.8296175026176411116, 0, 1.6592350052352822232, 0, 0.8296175026176411116, 0, 0, 0,
0, 1.1732563237839646053, 0, 0, 0, 0, 1.1732563237839646053, 0, 2.3465126475679292106, 0, 0, 0, 0, 0, 0, -1.1732563237839646053, 0, 0, 0, 1.1732563237839646053, 0, 0, 0, 0, 0, 0, 0, 0, -1.1732563237839646053, 0, -2.3465126475679292106, 0, -1.1732563237839646053, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.0853845001516052859, 0, 0, -1.1953830021224738367, 0, 0.0853845001516052859, 0, 0, 0, 0, 0, 0, -1.2807675022740792059, 0, 0, 0, 0, 0, 0, 0, 0, 1.1953830021224738367, 0, 1.2807675022740792059, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.0853845001516052859, 0, -0.0853845001516052859, 0, 0, 0, 0, 0, 0,
0, 0, -0.2957805848829057060, 0, 0, 0, 0, 2.6620252639461514654, 0, -0.2957805848829057060, 0, 0, 0, 0, 0, 0, 1.4789029244145286413, 0, 2.9578058488290572825, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.4789029244145286413, 0, -1.4789029244145286413, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
-0.0630606325811169377, 0, 0, 0.2522425303244677508, 0, 0.5675456932300524393, 0, 0, 0, 0, 0.6306063258111693770, 0, -2.8377284661502617524, 0, 0.6306063258111693770, 0, 0, 0, 0, 0, 0, 0.2522425303244677508, 0, -2.8377284661502617524, 0, -3.7836379548670162620, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.0630606325811169377, 0, 0.5675456932300524393, 0, 0.6306063258111693770, 0, 0, 0, 0,
0, 0, 0.3453973095522297476, 0, 0, 0, 0, -0.3453973095522297476, 0, -0.5756621825870495979, 0, 0, 0, 0, 0, 0, -1.7269865477611487936, 0, 1.1513243651740991957, 0, -0.9210594921392794010, 0, 0, 0, 0, 0, 0, 0, 0, -1.0361919286566891873, 0, 1.7269865477611487936, 0, 2.7631784764178379810, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.0575662182587049626, 0, 0, 0.1151324365174099251, 0, -0.8634932738805743968, 0, 0, 0, 0, 0, 0, -0.8634932738805743968, 0, 0, 0, 0, 0, 0, 0, 0, -0.1151324365174099251, 0, 0.8634932738805743968, 0, 0, 0, 0.9210594921392794010, 0, 0, 0, 0, 0, 0, 0, 0, -0.0575662182587049626, 0, 0.8634932738805743968, 0, 0, 0, -0.9210594921392794010, 0, 0,
0, 0, -0.3640807319597594849, 0, 0, 0, 0, -1.0922421958792785102, 0, 1.0922421958792785102, 0, 0, 0, 0, 0, 0, -1.0922421958792785102, 0, 2.1844843917585570203, 0, 0.8737937567034227415, 0, 0, 0, 0, 0, 0, 0, 0, -0.3640807319597594849, 0, 1.0922421958792785102, 0, 0.8737937567034227415, 0, -0.5825291711356151980, 0, 0, 0, 0, 0, 0, 0, 0, 0,
-0.0397244646019172878, 0, 0, -0.1588978584076691514, 0, 0.6753158982325937476, 0, 0, 0, 0, -0.2383467876115037132, 0, 2.0259476946977814649, 0, -0.2383467876115037132, 0, 0, 0, 0, 0, 0, -0.1588978584076691514, 0, 2.0259476946977814649, 0, -0.4766935752230074264, 0, -0.8262688637198795094, 0, 0, 0, 0, 0, 0, 0, 0, -0.0397244646019172878, 0, 0.6753158982325937476, 0, -0.2383467876115037132, 0, -0.8262688637198795094, 0, 0.1271182867261353155,
0, 0, 0, 0, -0.3640807319597594849, 0, 0, 0, 0, 0, 0, -1.0922421958792785102, 0, 1.0922421958792785102, 0, 0, 0, 0, 0, 0, 0, 0, -1.0922421958792785102, 0, 2.1844843917585570203, 0, 0.8737937567034227415, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.3640807319597594849, 0, 1.0922421958792785102, 0, 0.8737937567034227415, 0, -0.5825291711356151980, 0,
0, 0.1151324365174099251, 0, 0, 0, 0, 0.3453973095522297476, 0, -1.7269865477611487936, 0, 0, 0, 0, 0, 0, 0.3453973095522297476, 0, -3.4539730955222975872, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.1151324365174099251, 0, -1.7269865477611487936, 0, 0, 0, 1.8421189842785588020, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 1.0361919286566891873, 0, 0, 0, 0, 0, 0, 1.7269865477611487936, 0, -1.7269865477611487936, 0, 0, 0, 0, 0, 0, 0, 0, 0.3453973095522297476, 0, -1.1513243651740991957, 0, -2.7631784764178379810, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.3453973095522297476, 0, 0.5756621825870495979, 0, 0.9210594921392794010, 0, 0, 0,
0, -0.2522425303244677508, 0, 0, 0, 0, -0.2522425303244677508, 0, 2.2701827729202097572, 0, 0, 0, 0, 0, 0, 0.2522425303244677508, 0, 0, 0, 2.5224253032446775080, 0, 0, 0, 0, 0, 0, 0, 0, 0.2522425303244677508, 0, -2.2701827729202097572, 0, -2.5224253032446775080, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -1.4789029244145286413, 0, 0, 0, 0, 0, 0, 1.4789029244145286413, 0, -1.4789029244145286413, 0, 0, 0, 0, 0, 0, 0, 0, 2.6620252639461514654, 0, 2.9578058488290572825, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.2957805848829057060, 0, -0.2957805848829057060, 0, 0, 0, 0, 0,
0, 0.5123070009096316602, 0, 0, 0, 0, -1.1953830021224738367, 0, 0.5123070009096316602, 0, 0, 0, 0, 0, 0, -1.1953830021224738367, 0, -1.7076900030321056079, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5123070009096316602, 0, 0.5123070009096316602, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.0107178135014655736, 0, 0, -0.3000987780410361294, 0, 0, 0, 0, 0, 0, 0.7502469451025902680, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.3000987780410361294, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0107178135014655736, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, -0.0428712540058622943, 0, 0, 0, 0, 0.9002963341231082772, 0, 0, 0, 0, 0, 0, 0, 0, -1.5004938902051805361, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.3000987780410361294, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
-0.0078271842958481646, 0, 0, 0.1095805801418743008, 0, 0.1095805801418743008, 0, 0, 0, 0, 0, 0, -1.6437087021281144850, 0, 0, 0, 0, 0, 0, 0, 0, -0.1095805801418743008, 0, 1.6437087021281144850, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0078271842958481646, 0, -0.1095805801418743008, 0, 0, 0, 0, 0, 0,
0, 0, 0.0507259518200420742, 0, 0, 0, 0, -0.4565335663803786748, 0, -0.2029038072801682968, 0, 0, 0, 0, 0, 0, -0.2536297591002103502, 0, 2.0290380728016828016, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.2536297591002103502, 0, -1.0145190364008414008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.0070344238570722133, 0, 0, -0.0281376954282888531, 0, -0.1688261725697331461, 0, 0, 0, 0, -0.0703442385707221396, 0, 0.8441308628486656751, 0, 0.2813769542828885584, 0, 0, 0, 0, 0, 0, -0.0281376954282888531, 0, 0.8441308628486656751, 0, -1.6882617256973313502, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0070344238570722133, 0, -0.1688261725697331461, 0, 0.2813769542828885584, 0, 0, 0, 0,
0, 0, -0.0544884128972096607, 0, 0, 0, 0, 0.0544884128972096607, 0, 0.3632560859813976362, 0, 0, 0, 0, 0, 0, 0.2724420644860482410, 0, -0.7265121719627952723, 0, -0.2906048687851181533, 0, 0, 0, 0, 0, 0, 0, 0, 0.1634652386916289613, 0, -1.0897682579441929640, 0, 0.8718146063553545710, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
-0.0067070599846150393, 0, 0, -0.0134141199692300785, 0, 0.2012117995384511693, 0, 0, 0, 0, 0, 0, 0.2012117995384511693, 0, -0.5365647987692031551, 0, 0, 0, 0, 0, 0, 0.0134141199692300785, 0, -0.2012117995384511693, 0, 0, 0, 0.2146259195076812565, 0, 0, 0, 0, 0, 0, 0, 0, 0.0067070599846150393, 0, -0.2012117995384511693, 0, 0.5365647987692031551, 0, -0.2146259195076812565, 0, 0,
0, 0, 0.0561152898469365544, 0, 0, 0, 0, 0.1683458695408096562, 0, -0.4489223187754924349, 0, 0, 0, 0, 0, 0, 0.1683458695408096562, 0, -0.8978446375509848698, 0, 0.5387067825305910107, 0, 0, 0, 0, 0, 0, 0, 0, 0.0561152898469365544, 0, -0.4489223187754924349, 0, 0.5387067825305910107, 0, -0.1026108157201125609, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.0046762741539113795, 0, 0, 0.0187050966156455181, 0, -0.1496407729251641450, 0, 0, 0, 0, 0.0280576449234682772, 0, -0.4489223187754924349, 0, 0.4489223187754924349, 0, 0, 0, 0, 0, 0, 0.0187050966156455181, 0, -0.4489223187754924349, 0, 0.8978446375509848698, 0, -0.2394252366802626375, 0, 0, 0, 0, 0, 0, 0, 0, 0.0046762741539113795, 0, -0.1496407729251641450, 0, 0.4489223187754924349, 0, -0.2394252366802626375, 0, 0.0171018026200187613,
0, 0, 0, 0, 0.0561152898469365544, 0, 0, 0, 0, 0, 0, 0.1683458695408096562, 0, -0.4489223187754924349, 0, 0, 0, 0, 0, 0, 0, 0, 0.1683458695408096562, 0, -0.8978446375509848698, 0, 0.5387067825305910107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0561152898469365544, 0, -0.4489223187754924349, 0, 0.5387067825305910107, 0, -0.1026108157201125609, 0,
0, -0.0134141199692300785, 0, 0, 0, 0, -0.0402423599076902339, 0, 0.4024235990769023386, 0, 0, 0, 0, 0, 0, -0.0402423599076902339, 0, 0.8048471981538046771, 0, -1.0731295975384063102, 0, 0, 0, 0, 0, 0, 0, 0, -0.0134141199692300785, 0, 0.4024235990769023386, 0, -1.0731295975384063102, 0, 0.4292518390153625130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.1634652386916289613, 0, 0, 0, 0, 0, 0, -0.2724420644860482410, 0, 1.0897682579441929640, 0, 0, 0, 0, 0, 0, 0, 0, -0.0544884128972096607, 0, 0.7265121719627952723, 0, -0.8718146063553545710, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0544884128972096607, 0, -0.3632560859813976362, 0, 0.2906048687851181533, 0, 0, 0,
0, 0.0281376954282888531, 0, 0, 0, 0, 0.0281376954282888531, 0, -0.6753046902789325845, 0, 0, 0, 0, 0, 0, -0.0281376954282888531, 0, 0, 0, 1.1255078171315542335, 0, 0, 0, 0, 0, 0, 0, 0, -0.0281376954282888531, 0, 0.6753046902789325845, 0, -1.1255078171315542335, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0.2536297591002103502, 0, 0, 0, 0, 0, 0, -0.2536297591002103502, 0, -1.0145190364008414008, 0, 0, 0, 0, 0, 0, 0, 0, -0.4565335663803786748, 0, 2.0290380728016828016, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0507259518200420742, 0, -0.2029038072801682968, 0, 0, 0, 0, 0,
0, -0.0469631057750889910, 0, 0, 0, 0, 0.1095805801418743008, 0, 0.6574834808512457496, 0, 0, 0, 0, 0, 0, 0.1095805801418743008, 0, -2.1916116028374861280, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.0469631057750889910, 0, 0.6574834808512457496, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.3000987780410361294, 0, 0, 0, 0, 0, 0, 1.5004938902051805361, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.9002963341231082772, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0428712540058622943, 0, 0, 0, 0, 0, 0, 0,
0, 0.0857425080117245886, 0, 0, 0, 0, -0.6001975560820722588, 0, 0, 0, 0, 0, 0, 0, 0, 0.6001975560820722588, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.0857425080117245886, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
#if TIJK_TABLE_TYPE == 0
static const double _tijk_esh2sym_o8_d[45*45] ={
#else
static const float _tijk_esh2sym_o8_f[45*45] ={
#endif
0.2820947917738783062, 0.5462742152960393671, 0, -0.3153915652525198787, 0, 0, 0.6258357354491760338, 0, -0.4730873478787803732, 0, 0.3173566407456129279, 0, 0, 0, 0, 0.6831841051919145258, 0, -0.5045649007287240639, 0, 0.4606026297574616346, 0, -0.3178460113381420538, 0, 0, 0, 0, 0, 0, 0.7289266601748296548, 0, -0.5323327660595424948, 0, 0.4784165247593306636, 0, -0.4561522584349099185, 0, 0.3180369672047742569, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.1365685538240098695, 0, 0, 0, 0, 0, 0, -0.1182718369696949268, 0, 0.3129178677245880724, 0, 0, 0, 0, 0, 0, 0, 0, 0.1151506574393653948, 0, -0.2522824503643620875, 0, 0.5123880788939360054, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.1140380646087272576, 0, 0.2392082623796658314, 0, -0.3992495745446568156, 0, 0.7289266601748292107,
0, 0, -0.1365685538240099806, 0, 0, 0, 0, -0.2212663462224912780, 0, 0.2508924538339833976, 0, 0, 0, 0, 0, 0, -0.2958273952789691186, 0, 0.3454519723180963231, 0, -0.3641383515742072086, 0, 0, 0, 0, 0, 0, 0, 0, -0.3644633300874148829, 0, 0.4312388277622636323, 0, -0.4632248082358288999, 0, 0.4770554508071623845, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.0402992559676969356, 0.0390195868068598586, 0, -0.0450559378932172336, 0, 0, -0.0894051050641678779, 0, -0.0337919534199127569, 0, 0.0453366629636590412, 0, 0, 0, 0, -0.3415920525959573739, 0, 0.0720807001041033624, 0, 0.0329001878398185940, 0, -0.0454065730483060453, 0, 0, 0, 0, 0, 0, -0.7289266601748296548, 0, 0.2661663830297712474, 0, -0.0683452178227613449, 0, -0.0325823041739216890, 0, 0.0454338524578253994, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.0195097934034299814, 0, 0, 0, 0, 0, 0, 0.0358417791191404933, 0, -0.0948284340953533256, 0, 0, 0, 0, 0, 0, 0, 0, -0.0520197645106010090, 0, 0.1480508452791841623, 0, -0.2113052823421207871, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0681507786867375787, 0, -0.1985249178153554173, 0, 0.3080277341159026183, 0, -0.3644633300874147719, 0,
0.0402992559676968176, 0.0585293802102899718, 0, -0.0112639844733044003, 0, 0, 0.0447025525320839945, 0, 0.0675839068398257081, 0, -0.0680049944454885757, 0, 0, 0, 0, 0.0243994323282826740, 0, 0.1621815752342328221, 0, -0.2467514087986400761, 0, 0.1929779354553007309, 0, 0, 0, 0, 0, 0, -0.0000000000000000083, 0, 0.2661663830297713584, 0, -0.4100713069365690688, 0, 0.4887345626088321904, 0, -0.3634708196625991428, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.0585293802102899094, 0, 0, 0, 0, 0, 0, -0.0506879301298692603, 0, 0.0447025525320840708, 0, 0, 0, 0, 0, 0, 0, 0, 0.0493502817597281027, 0, -0.0360403500520517089, 0, -0.1707960262979787147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.0488734562608832898, 0, 0.0341726089113805059, 0, 0.1330831915148854849, 0, -0.7289266601748296548,
0, 0, -0.0195097934034299848, 0, 0, 0, 0, 0.0105364926772614741, 0, 0.0358417791191404655, 0, 0, 0, 0, 0, 0, 0.1267831694052724278, 0, -0.0164500939199093248, 0, -0.0520197645106009882, 0, 0, 0, 0, 0, 0, 0, 0, 0.3644633300874148829, 0, -0.1848166404695416043, 0, 0.0220583242017060796, 0, 0.0681507786867374815, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.0195097934034299848, 0, 0, 0, 0, 0, 0, 0.0225279689466085474, 0, 0.0298017016880559905, 0, 0, 0, 0, 0, 0, 0, 0, -0.0822504695995468216, 0, 0.1081210501561551129, 0, 0.0243994323282826706, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.1629115208696105821, 0, -0.2733808712910460459, 0, 0.2661663830297714139, 0, 0.0000000000000000048,
0, 0, -0.0585293802102899163, 0, 0, 0, 0, -0.0632189560635689624, 0, 0.0238945194127604121, 0, 0, 0, 0, 0, 0, -0.0422610564684241588, 0, -0.0822504695995467661, 0, 0.1560592935318031449, 0, 0, 0, 0, 0, 0, 0, 0, -0.0000000000000000093, 0, -0.2464221872927218893, 0, 0.4411664840341230076, 0, -0.5452062294938996301, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.0241795535806180080, 0.0000000000000001414, 0, -0.0270335627359302930, 0, 0, -0.0894051050641681139, 0, 0.0000000000000000117, 0, 0.0272019977781953783, 0, 0, 0, 0, 0.0000000000000000469, 0, 0.0720807001041035289, 0, 0.0000000000000001514, 0, -0.0272439438289834787, 0, 0, 0, 0, 0, 0, 0.7289266601748297658, 0, -0.0000000000000000097, 0, -0.0683452178227615809, 0, -0.0000000000000001077, 0, 0.0272603114746949211, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.0117058760420579878, 0, 0, 0, 0, 0, 0, 0.0215050674714842988, 0, -0.0316094780317844465, 0, 0, 0, 0, 0, 0, 0, 0, -0.0312118587063606109, 0, 0.0493502817597280610, 0, 0.0422610564684241310, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0408904672120424598, 0, -0.0661749726051184539, 0, -0.0616055468231805556, 0, 0.3644633300874148274, 0,
0.0080598511935393580, 0.0039019586806860237, 0, -0.0022527968946608450, 0, 0, -0.0149008508440280161, 0, 0.0045055937893217646, 0, -0.0136009988890976180, 0, 0, 0, 0, -0.0243994323282826567, 0, -0.0540605250780776467, 0, -0.0164500939199094080, 0, 0.0385955870910601531, 0, 0, 0, 0, 0, 0, -0.0000000000000000016, 0, -0.2661663830297713029, 0, 0.1366904356455231062, 0, 0.0325823041739220845, 0, -0.0726941639325199285, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.0117058760420579843, 0, 0, 0, 0, 0, 0, 0.0047789038825520637, 0, -0.0379313736381413774, 0, 0, 0, 0, 0, 0, 0, 0, 0.0312118587063606040, 0, -0.0493502817597280818, 0, -0.0422610564684241588, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.1090412458987799343, 0, 0.2646998904204737046, 0, -0.2464221872927220558, 0, -0.0000000000000000017, 0,
0.0241795535806180392, 0.0234117520841159929, 0, 0.0135167813679649557, 0, 0, 0.0089405105064168100, 0, 0.0743422975238083317, 0, -0.0559152176551795943, 0, 0, 0, 0, 0.0000000000000000039, 0, 0.0720807001041034734, 0, 0.0000000000000001283, 0, -0.0272439438289837077, 0, 0, 0, 0, 0, 0, 0.0000000000000000034, 0, -0.0000000000000000071, 0, 0.2733808712910461014, 0, -0.5213168667827535740, 0, 0.4361649835951196819, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.0585293802102899996, 0, 0, 0, 0, 0, 0, -0.0506879301298693019, 0, -0.0447025525320840847, 0, 0, 0, 0, 0, 0, 0, 0, 0.0493502817597280402, 0, 0.0360403500520517228, 0, -0.1707960262979785204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.0488734562608831649, 0, -0.0341726089113807349, 0, 0.1330831915148857070, 0, 0.7289266601748297658,
0, 0, -0.0117058760420580034, 0, 0, 0, 0, 0.0316094780317845020, 0, 0.0215050674714842988, 0, 0, 0, 0, 0, 0, 0.0422610564684241241, 0, -0.0493502817597280333, 0, -0.0312118587063606109, 0, 0, 0, 0, 0, 0, 0, 0, -0.3644633300874148829, 0, -0.0616055468231805001, 0, 0.0661749726051184400, 0, 0.0408904672120424528, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.0117058760420579878, 0, 0, 0, 0, 0, 0, 0.0135167813679651361, 0, 0.0000000000000000009, 0, 0, 0, 0, 0, 0, 0, 0, -0.0493502817597280402, 0, 0.0000000000000000194, 0, -0.0243994323282826601, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0977469125217662743, 0, -0.0000000000000000244, 0, -0.2661663830297713584, 0, 0.0000000000000000139,
0, 0, -0.0117058760420579930, 0, 0, 0, 0, 0.0126437912127137994, 0, 0.0047789038825520672, 0, 0, 0, 0, 0, 0, 0.0422610564684241449, 0, 0.0164500939199093595, 0, 0.0312118587063606318, 0, 0, 0, 0, 0, 0, 0, 0, 0.0000000000000000102, 0, 0.2464221872927219725, 0, -0.0882332968068246654, 0, -0.1090412458987799343, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.0117058760420579947, 0, 0, 0, 0, 0, 0, 0.0371711487619041658, 0, 0.0089405105064168013, 0, 0, 0, 0, 0, 0, 0, 0, 0.0000000000000000278, 0, 0.0720807001041034595, 0, 0.0000000000000000033, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.2606584333913767870, 0, 0.2733808712910461569, 0, 0.0000000000000000168, 0, 0.0000000000000000070,
0, 0, -0.0585293802102899718, 0, 0, 0, 0, -0.0316094780317844812, 0, -0.0597362985319008916, 0, 0, 0, 0, 0, 0, 0.0000000000000000051, 0, -0.1316007513592747924, 0, 0.1248474348254423050, 0, 0, 0, 0, 0, 0, 0, 0, 0.0000000000000000025, 0, -0.0000000000000000292, 0, -0.3529331872272983839, 0, 0.6542474753926794673, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.0402992559676970882, -0.0390195868068601917, 0, -0.0450559378932170809, 0, 0, -0.0894051050641678502, 0, 0.0337919534199128332, 0, 0.0453366629636590968, 0, 0, 0, 0, 0.3415920525959571519, 0, 0.0720807001041034456, 0, -0.0329001878398188230, 0, -0.0454065730483060037, 0, 0, 0, 0, 0, 0, -0.7289266601748298768, 0, -0.2661663830297711919, 0, -0.0683452178227612200, 0, 0.0325823041739225980, 0, 0.0454338524578254827, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.0195097934034299744, 0, 0, 0, 0, 0, 0, 0.0358417791191405002, 0, -0.0105364926772614949, 0, 0, 0, 0, 0, 0, 0, 0, -0.0520197645106010020, 0, 0.0164500939199093248, 0, 0.1267831694052724278, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0681507786867374676, 0, -0.0220583242017061421, 0, -0.1848166404695414655, 0, -0.3644633300874148274, 0,
0.0080598511935393892, -0.0039019586806860198, 0, -0.0022527968946608728, 0, 0, -0.0149008508440279831, 0, -0.0045055937893217187, 0, -0.0136009988890977290, 0, 0, 0, 0, 0.0243994323282826428, 0, -0.0540605250780775218, 0, 0.0164500939199095086, 0, 0.0385955870910602294, 0, 0, 0, 0, 0, 0, -0.0000000000000000045, 0, 0.2661663830297711364, 0, 0.1366904356455228564, 0, -0.0325823041739222719, 0, -0.0726941639325201089, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.0117058760420579930, 0, 0, 0, 0, 0, 0, 0.0047789038825520533, 0, -0.0126437912127138011, 0, 0, 0, 0, 0, 0, 0, 0, 0.0312118587063605901, 0, -0.0164500939199093664, 0, 0.0422610564684241588, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.1090412458987799760, 0, 0.0882332968068245682, 0, 0.2464221872927220280, 0, -0.0000000000000000139, 0,
0.0080598511935393961, -0.0000000000000000059, 0, 0.0045055937893217456, 0, 0, -0.0089405105064168065, 0, -0.0000000000000000416, 0, -0.0186384058850598139, 0, 0, 0, 0, 0.0000000000000000015, 0, -0.0720807001041034456, 0, -0.0000000000000000757, 0, -0.0090813146096612660, 0, 0, 0, 0, 0, 0, -0.0000000000000000064, 0, 0.0000000000000000030, 0, -0.2733808712910460459, 0, -0.0000000000000000148, 0, 0.1453883278650399125, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.0195097934034299814, 0, 0, 0, 0, 0, 0, -0.0199120995106335935, 0, -0.0316094780317844742, 0, 0, 0, 0, 0, 0, 0, 0, 0.0416158116084808377, 0, -0.1316007513592747924, 0, -0.0000000000000000017, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.2180824917975599520, 0, -0.3529331872272983284, 0, -0.0000000000000000139, 0, 0.0000000000000000035, 0,
0.0402992559676969009, 0.0195097934034299675, 0, 0.0563199223665214743, 0, 0, -0.0000000000000000017, 0, 0.1013758602597385344, 0, -0.0302244419757725646, 0, 0, 0, 0, 0.0000000000000000117, 0, 0.0000000000000000278, 0, 0.2632015027185496403, 0, -0.2361141798511910417, 0, 0, 0, 0, 0, 0, -0.0000000000000000020, 0, 0.0000000000000000331, 0, 0.0000000000000000172, 0, 0.5213168667827536851, 0, -0.5815533114601594278, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.1365685538240098695, 0, 0, 0, 0, 0, 0, -0.1182718369696950378, 0, -0.3129178677245881279, 0, 0, 0, 0, 0, 0, 0, 0, 0.1151506574393654087, 0, 0.2522824503643621430, 0, 0.5123880788939357833, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.1140380646087272715, 0, -0.2392082623796652485, 0, -0.3992495745446570377, 0, -0.7289266601748297658,
0, 0, -0.0195097934034300091, 0, 0, 0, 0, 0.0948284340953534088, 0, 0.0358417791191404655, 0, 0, 0, 0, 0, 0, -0.2113052823421207038, 0, -0.1480508452791841345, 0, -0.0520197645106010437, 0, 0, 0, 0, 0, 0, 0, 0, 0.3644633300874149384, 0, 0.3080277341159025073, 0, 0.1985249178153552230, 0, 0.0681507786867373566, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.0195097934034299814, 0, 0, 0, 0, 0, 0, 0.0225279689466085682, 0, -0.0298017016880560114, 0, 0, 0, 0, 0, 0, 0, 0, -0.0822504695995467522, 0, -0.1081210501561551962, 0, 0.0243994323282826636, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.1629115208696104433, 0, 0.2733808712910460459, 0, 0.2661663830297713029, 0, 0.0000000000000000048,
0, 0, -0.0117058760420579808, 0, 0, 0, 0, 0.0379313736381413635, 0, 0.0047789038825520741, 0, 0, 0, 0, 0, 0, -0.0422610564684241519, 0, 0.0493502817597280333, 0, 0.0312118587063606318, 0, 0, 0, 0, 0, 0, 0, 0, -0.0000000000000000256, 0, -0.2464221872927220003, 0, -0.2646998904204737602, 0, -0.1090412458987798788, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.0117058760420579791, 0, 0, 0, 0, 0, 0, 0.0371711487619041242, 0, -0.0089405105064167961, 0, 0, 0, 0, 0, 0, 0, 0, 0.0000000000000000278, 0, -0.0720807001041034456, 0, 0.0000000000000000002, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.2606584333913767315, 0, -0.2733808712910461014, 0, -0.0000000000000000168, 0, 0.0000000000000000070,
0, 0, -0.0195097934034300056, 0, 0, 0, 0, 0.0316094780317844881, 0, -0.0199120995106336213, 0, 0, 0, 0, 0, 0, -0.0000000000000000052, 0, 0.1316007513592748202, 0, 0.0416158116084807961, 0, 0, 0, 0, 0, 0, 0, 0, -0.0000000000000000048, 0, 0.0000000000000000159, 0, 0.3529331872272984394, 0, 0.2180824917975598409, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0.0195097934034299744, 0, 0, 0, 0, 0, 0, 0.1013758602597385483, 0, 0.0000000000000000035, 0, 0, 0, 0, 0, 0, 0, 0, 0.2632015027185495293, 0, 0.0000000000000000083, 0, 0.0000000000000000016, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5213168667827535740, 0, 0.0000000000000000316, 0, -0.0000000000000000165, 0, 0.0000000000000000126,
0, 0, -0.1365685538240098418, 0, 0, 0, 0, -0.0000000000000000118, 0, -0.3345232717786444931, 0, 0, 0, 0, 0, 0, 0.0000000000000000048, 0, -0.0000000000000000659, 0, -0.5826213625187313117, 0, 0, 0, 0, 0, 0, 0, 0, 0.0000000000000000192, 0, -0.0000000000000000636, 0, -0.0000000000000001025, 0, -0.8723299671902394747, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0.2820947917738782507, -0.5462742152960395892, 0, -0.3153915652525199897, 0, 0, 0.6258357354491761448, 0, 0.4730873478787797071, 0, 0.3173566407456127614, 0, 0, 0, 0, -0.6831841051919145258, 0, -0.5045649007287241750, 0, -0.4606026297574615791, 0, -0.3178460113381420538, 0, 0, 0, 0, 0, 0, 0.7289266601748299879, 0, 0.5323327660595423838, 0, 0.4784165247593303860, 0, 0.4561522584349090859, 0, 0.3180369672047743679, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.1365685538240098418, 0, 0, 0, 0, 0, 0, 0.2508924538339835086, 0, 0.2212663462224912780, 0, 0, 0, 0, 0, 0, 0, 0, -0.3641383515742071530, 0, -0.3454519723180963786, 0, -0.2958273952789690076, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.4770554508071619959, 0, 0.4632248082358287888, 0, 0.4312388277622635768, 0, 0.3644633300874149384, 0,
0.0402992559676968592, -0.0585293802102898955, 0, -0.0112639844733042546, 0, 0, 0.0447025525320839806, 0, -0.0675839068398256110, 0, -0.0680049944454883815, 0, 0, 0, 0, -0.0243994323282826289, 0, 0.1621815752342327666, 0, 0.2467514087986401872, 0, 0.1929779354553006476, 0, 0, 0, 0, 0, 0, -0.0000000000000000346, 0, -0.2661663830297711919, 0, -0.4100713069365691243, 0, -0.4887345626088315798, 0, -0.3634708196625995869, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.0585293802102899510, 0, 0, 0, 0, 0, 0, 0.0238945194127603011, 0, 0.0632189560635689485, 0, 0, 0, 0, 0, 0, 0, 0, 0.1560592935318029784, 0, 0.0822504695995467522, 0, -0.0422610564684241657, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.5452062294938998521, 0, -0.4411664840341228966, 0, -0.2464221872927220558, 0, 0.0000000000000000139, 0,
0.0241795535806181086, -0.0234117520841159790, 0, 0.0135167813679650944, 0, 0, 0.0089405105064167996, 0, -0.0743422975238082762, 0, -0.0559152176551794833, 0, 0, 0, 0, 0.0000000000000000048, 0, 0.0720807001041034595, 0, 0.0000000000000000173, 0, -0.0272439438289836799, 0, 0, 0, 0, 0, 0, -0.0000000000000000019, 0, 0.0000000000000000149, 0, 0.2733808712910461014, 0, 0.5213168667827537961, 0, 0.4361649835951196819, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.0585293802102899510, 0, 0, 0, 0, 0, 0, -0.0597362985319007944, 0, 0.0316094780317844742, 0, 0, 0, 0, 0, 0, 0, 0, 0.1248474348254425270, 0, 0.1316007513592747924, 0, -0.0000000000000000087, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.6542474753926799114, 0, 0.3529331872272983284, 0, -0.0000000000000000278, 0, -0.0000000000000000139, 0,
0.0402992559676969356, -0.0195097934034299883, 0, 0.0563199223665215437, 0, 0, -0.0000000000000000182, 0, -0.1013758602597386038, 0, -0.0302244419757725646, 0, 0, 0, 0, 0.0000000000000000043, 0, -0.0000000000000000416, 0, -0.2632015027185496958, 0, -0.2361141798511912915, 0, 0, 0, 0, 0, 0, 0.0000000000000000051, 0, 0.0000000000000000310, 0, 0.0000000000000000414, 0, -0.5213168667827539071, 0, -0.5815533114601596498, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, -0.1365685538240098695, 0, 0, 0, 0, 0, 0, -0.3345232717786446042, 0, -0.0000000000000000069, 0, 0, 0, 0, 0, 0, 0, 0, -0.5826213625187316447, 0, 0, 0, 0.0000000000000000104, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.8723299671902401409, 0, -0.0000000000000001110, 0, 0.0000000000000001110, 0, -0.0000000000000000208, 0,
0.2820947917738780841, 0.0000000000000000746, 0, 0.6307831305050397575, 0, 0, -0.0000000000000000312, 0, 0.0000000000000000555, 0, 0.8462843753216341414, 0, 0, 0, 0, 0.0000000000000000165, 0, 0.0000000000000000555, 0, -0.0000000000000000656, 0, 1.0171072362820543500, 0, 0, 0, 0, 0, 0, -0.0000000000000000985, 0, -0.0000000000000002266, 0, -0.0000000000000000735, 0, 0.0000000000000003443, 0, 1.1631066229203190776, 0, 0, 0, 0, 0, 0, 0, 0
};
