アップグレードガイド
=========

このドキュメントについて
--

tDiaryは、バージョン番号の2桁目が偶数のもの(1.0.x、1.2.x...)がリリースバージョン、奇数のもの(0.9.xx、1.1.x...)が開発バージョンとなっています。このドキュメントでは、リリースバージョン間の変更点について解説します。開発バージョンを使っている場合は、ChangeLogファイルを参照してください。

2.2と3.0の違い
-----

2.2系から3.0への最大の変更点は、「UTF-8化」と「ruby 1.9対応」です。いずれも大きな変更になりますので、以下の注意をよく読んでからアップデートを行って下さい。すでに2.3系で運用している場合は特に大きな問題はでないでしょう。

### アップデートに関する注意点■

#### 文字コードのUTF-8化

tDiary 3.0では日記データのファイルのエンコードをEUC-JPからUTF-8へと変更しています。この変更により複数の言語で日記を書けるようになりました。

tDiary 3.0にバージョンアップすることで、自動的に新しく書いた日記はエンコーディングがUTF-8で作成され、過去の日記データも表示する際にEUC-JPからUTF-8に自動的に変換されます。

いちどUTF-8に変換された日記データは、基本的にはEUC-JPへは戻せません。かならずバックアップをとってからアップデート作業をしてください。

#### ruby 1.9.2 への対応

tDiary 3.0ではrubyを1.9.2にバージョンアップするだけで移行できるようになっていますが、 tDiaryが生成するキャッシュファイルは互換性の問題でまれにエラーになることがあります。

エラーになった場合のもっとも簡単な対処は、データディレクトリにあるcacheディレクトリを丸ごと削除する方法です。ただし、counter.rbの情報が消えるとカウンタが巻き戻ってしまうので、初期値を控えておくなどの対処が必要です。また makerss.rbやrecent_comment.rbが生成するキャッシュが消えるため、しばらくは寂しい状況になるかも知れませんが、これらは時間が解決してくれます:-) すべてのキャッシュを削除するのが困難な場合は、個別のファイルごとに対処してください。

また、カテゴリに関する情報も、同様な理由でエラーを起こすことがあります。この場合は、categoryプラグインの設定画面で「カテゴリインデックスの作成」を実行してください。

いちどruby 1.9.2上で動作させた日記データは、基本的には1.8へは戻せません。かならずバックアップをとってからアップデート作業をしてください。

#### tDiary 3.0とruby 1.9.2を同時にアップデートしない

ruby 1.8.* で動かしているtDiary 2.2系をtDiary 3.0とruby 1.9.2の環境へ同時にアップデートすることは避けるべきでしょう。日記データが壊れることはないはずですが、キャッシュデータが壊れてしまう可能性があります。

どうしてもtDiaryとrubyの両方をバージョンアップしたい場合は以下の手順でバージョンアップして下さい。

 1. tDiaryをまず3.0にバージョンアップし、ruby 1.8の状態でブラウザから日記を表示します。この際に日記データと利用しているプラグインのキャッシュデータがUTF-8へと変換されます。
 2. 利用しているプラグインの動作を全て確認後にruby 1.9.2へとアップデートします。
 3. 利用しているプラグインによっては、上記の手順で完全に変換が実行されない可能性もあります。

不安な場合は<tdiary-devel@sourceforge.net>まで相談してください。

2.0と2.2の違い
-----

### 2.0から2.2移行時の注意

#### いくつかのファイル名が変更になっています。

 - plugin/01sp.rb → plugin/50sp.rb
 - plugin/ja/01sp.rb → plugin/ja/50sp.rb
 - plugin/en/01sp.rb → plugin/en/50sp.rb
 - plugin/zh/01sp.rb → plugin/zh/50sp.rb

2.2へのアップデートをする前に、上記のファイルをあらかじめ削除しておいてください。残っていると誤動作する場合があります。

#### リンク元の記録方法が変更になっています。

リンク元は従来、月単位に記録していましたが、2.2からは日単位の記録になっています。このため、データディレクトリには自動的にYYYYMMDD.tdrというファイルが生成され、元のYYYYMM.tdrはYYYYMM.tdr~にリネームされて残されます。ディスク容量に余裕がない場合には、古いファイルは削除してかまいません。

#### 2.0から2.2への主な変更点

[tDiary.orgのリリース](http://www.tdiary.org/20071216.html)を参照してください。

プラグインの中にも廃止・統合されたファイルがあります。

1.4と2.0の違い
-----

### 1.4から2.0移行時の注意

#### データ形式が変更になっています。

1.4系ではバイナリ形式でしたが、2.0からは標準でテキスト形式になっています。保存形式は差し替え可能になっていますが、テキスト形式に変換することをお勧めします。詳しくは[tDiary.orgのページ](http://www.tdiary.org/20021121.html)を参照してください。

#### プラグインのインストール方法が変わっています。

tDiaryインストールディレクトリのmisc/pluginにプラグインファイルを入れておくと、設定画面から有効にするプラグインを選択できます。従来の方法でもインストールできますが、プラグインファイルが本体と言語リソースに分離されたこともあり、今後はこちらを推奨します。

#### ツッコミのメール通知を、本体内蔵からプラグインにしました。

comment_mail-smtp.rb 他のプラグインを使うようにしてください。

### 1.4から2.0への主な変更点

 1. 「長年日記」機能
 2. カテゴリ機能追加(http://www.tdiary.org/20030224.html)
 3. スタイル機能で記述形式を選択可能に(http://www.tdiary.org/20030225.html)
 4. 更新前に内容を確認できるプレビュー機能
 5. 設定画面の大幅機能拡張で絵日記などが可能に
 6. ツッコミやリンク元を制限できるフィルタ機能
 7. 更新画面に機能を追加できるプラグイン拡張
 8. 国際化機能。標準でja(日本語)、en(英語)、zh(中国語繁字体)に対応
 9. 各種ウェブログ機能(TrackBack、ping、RSS)対応(プラグイン併用)

1.2と1.4の違い
----

### 1.2から1.4移行時の注意

#### *.rhtml、*.rconf、*.rtxtが、ディレクトリskelに移動しています。

これら以前のファイルは削除してかまいません。

#### ページ最上部に出ていたナビゲーションボタンが、プラグインとして独立し、自由な場所に配置できるようになりました。

この副作用で、ヘッダ(@header)に「<%=navi%>」という文字列を含めないとナビゲーションボタンが出てきません。移行後にブラウザからupdate.rbを開いて、ヘッダを変更してください。

### 1.2から1.4への主な変更点

 1. プラグインによる拡張機能
 2. 最新表示で月をまたいだ表示
 3. キャッシュによる高速化
 4. 複数日記の運用が簡単に
 5. 検索インデックス作成用squeeze.rbによる静的HTML生成
 6. モバイルモード対象機種を充実
 7. 特定の日付を隠せるようになった

1.0と1.2の違い
-----

### 1.0から1.2移行時の注意

#### CSSがthemeディレクトリへ移動になっています。

ここに*.cssを入れておくと、設定画面から対話式にテーマを切り替えることができます。従来のデフォルトCSSは、default.cssとしてthemeディレクトリに再録されています。

#### tdiary.confのフォーマットが少し変更になっています。

1.1以前のtDiaryから移行する場合には、以下の2行をtdiary.confの末尾に追加する必要があります。これを加えないと後述する対話式の設定変更機能が使えません。

```
@secure = false 
load_cgi_conf 
```

#### ヘッダやフッタにeRuby書式を許可したのに伴い、カレンダーの挿入位置を自由にできるようにしました。

このため、デフォルトではカレンダーは表示されません。従来のヘッダ(@header)、もしくはフッタ(@footer)に、「<%=calendar%>」という文字列を挿入して下さい。

#### CGIによる対話式設定が可能になりました。

従来tdiary.confで設定していた変数の多くはCGI経由で設定できます。しかし、いくつかの変数を除いて、一度CGI上で設定を変更してしまうと旧来のtdiary.confよりも優先されてしまいます。tdiary.conf.sampleにそのあたりの説明があるので、良く読んでください。

### 1.0から1.2への主な変更点

  1. CSSを使ったテーマに対応
  2. ヘッダ(@header)とフッタ(@footer)にeRuby書式の記述が可能になった
  3. カレンダーの挿入位置をヘッダとフッタ内で自由に指定可能になった
  4. @multi_userで簡易マルチユーザモードを設定可能になった
  5. @date_formatで、日付の表示形式をカスタマイズ可能になった
  6. ブラウザ上で設定の変更ができるようになった
  7. 用語の変更(Referer→リンク元、段落→セクション) 
  8. 新しいツッコミを入れやすいようにリンクを追加
  9. 設定以上のツッコミがある場合に「More...」を表示
 10. mod_ruby対応
 11. 携帯端末の対応を拡充(各社携帯電話、ザウルス、Windows CE機) 
 12. *.rbをCGIとして設定できないサーバ上への設置に対応(@index、@update)
 13. 任意のツッコミを非表示にできるようになった
 14. ドキュメントの充実
 15. 多数のバグFIX 
