// GENERATED FILE - DO NOT EDIT.
// Generated by generate_tests.py
//
// Copyright (c) 2022 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "../diff_test_utils.h"

#include "gtest/gtest.h"

namespace spvtools {
namespace diff {
namespace {

// Test where src and dst have a few large functions with small differences.
constexpr char kSrc[] = R"(               OpCapability Shader
          %1 = OpExtInstImport "GLSL.std.450"
               OpMemoryModel Logical GLSL450
               OpEntryPoint GLCompute %4 "main" %15
               OpExecutionMode %4 LocalSize 1 1 1
               OpSource ESSL 310
               OpName %4 "main"
               OpName %6 "f1("
               OpName %8 "f2("
               OpName %12 "x"
               OpName %15 "gl_LocalInvocationID"
               OpName %20 "y"
               OpName %27 "image"
               OpName %44 "sum"
               OpName %46 "i"
               OpName %56 "j"
               OpName %80 "BufferOut"
               OpMemberName %80 0 "o_uv4"
               OpMemberName %80 1 "o_v3"
               OpMemberName %80 2 "o_i"
               OpName %82 ""
               OpName %88 "BufferIn"
               OpMemberName %88 0 "i_u"
               OpMemberName %88 1 "i_v4"
               OpMemberName %88 2 "i_f"
               OpName %90 ""
               OpName %101 "i"
               OpDecorate %15 BuiltIn LocalInvocationId
               OpDecorate %27 DescriptorSet 0
               OpDecorate %27 Binding 2
               OpMemberDecorate %80 0 Offset 0
               OpMemberDecorate %80 1 Offset 16
               OpMemberDecorate %80 2 Offset 28
               OpDecorate %80 BufferBlock
               OpDecorate %82 DescriptorSet 0
               OpDecorate %82 Binding 1
               OpMemberDecorate %88 0 Offset 0
               OpMemberDecorate %88 1 RowMajor
               OpMemberDecorate %88 1 Offset 16
               OpMemberDecorate %88 1 MatrixStride 16
               OpMemberDecorate %88 2 Offset 80
               OpDecorate %88 Block
               OpDecorate %90 DescriptorSet 0
               OpDecorate %90 Binding 0
          %2 = OpTypeVoid
          %3 = OpTypeFunction %2
         %10 = OpTypeInt 32 0
         %11 = OpTypePointer Function %10
         %13 = OpTypeVector %10 3
         %14 = OpTypePointer Input %13
         %15 = OpVariable %14 Input
         %16 = OpConstant %10 0
         %17 = OpTypePointer Input %10
         %21 = OpConstant %10 1
         %24 = OpTypeInt 32 1
         %25 = OpTypeImage %24 2D 0 0 0 2 R32i
         %26 = OpTypePointer UniformConstant %25
         %27 = OpVariable %26 UniformConstant
         %29 = OpTypeVector %10 2
         %32 = OpTypeVector %24 2
         %38 = OpTypeVector %24 4
         %40 = OpConstant %10 2
         %41 = OpConstant %10 3400
         %42 = OpConstant %10 264
         %43 = OpTypePointer Function %24
         %45 = OpConstant %24 0
         %53 = OpConstant %24 2
         %54 = OpTypeBool
         %73 = OpConstant %24 1
         %77 = OpTypeVector %10 4
         %78 = OpTypeFloat 32
         %79 = OpTypeVector %78 3
         %80 = OpTypeStruct %77 %79 %24
         %81 = OpTypePointer Uniform %80
         %82 = OpVariable %81 Uniform
         %84 = OpTypePointer Uniform %24
         %86 = OpTypeVector %78 4
         %87 = OpTypeMatrix %86 4
         %88 = OpTypeStruct %10 %87 %78
         %89 = OpTypePointer Uniform %88
         %90 = OpVariable %89 Uniform
         %91 = OpTypePointer Uniform %87
         %94 = OpTypePointer Uniform %77
        %108 = OpConstant %24 3
        %110 = OpTypePointer Uniform %79
        %113 = OpTypePointer Uniform %78
        %129 = OpConstantComposite %32 %45 %45
          %4 = OpFunction %2 None %3
          %5 = OpLabel
        %135 = OpFunctionCall %2 %6
        %136 = OpFunctionCall %2 %8
               OpReturn
               OpFunctionEnd
          %6 = OpFunction %2 None %3
          %7 = OpLabel
         %12 = OpVariable %11 Function
         %20 = OpVariable %11 Function
         %44 = OpVariable %43 Function
         %46 = OpVariable %43 Function
         %56 = OpVariable %43 Function
         %18 = OpAccessChain %17 %15 %16
         %19 = OpLoad %10 %18
               OpStore %12 %19
         %22 = OpAccessChain %17 %15 %21
         %23 = OpLoad %10 %22
               OpStore %20 %23
         %28 = OpLoad %25 %27
         %30 = OpLoad %13 %15
         %31 = OpVectorShuffle %29 %30 %30 0 1
         %33 = OpBitcast %32 %31
         %34 = OpLoad %10 %12
         %35 = OpLoad %10 %20
         %36 = OpIAdd %10 %34 %35
         %37 = OpBitcast %24 %36
         %39 = OpCompositeConstruct %38 %37 %37 %37 %37
               OpImageWrite %28 %33 %39
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
               OpStore %44 %45
               OpStore %46 %45
               OpBranch %47
         %47 = OpLabel
               OpLoopMerge %49 %50 None
               OpBranch %51
         %51 = OpLabel
         %52 = OpLoad %24 %46
         %55 = OpSLessThan %54 %52 %53
               OpBranchConditional %55 %48 %49
         %48 = OpLabel
               OpStore %56 %45
               OpBranch %57
         %57 = OpLabel
               OpLoopMerge %59 %60 None
               OpBranch %61
         %61 = OpLabel
         %62 = OpLoad %24 %56
         %63 = OpSLessThan %54 %62 %53
               OpBranchConditional %63 %58 %59
         %58 = OpLabel
         %64 = OpLoad %25 %27
         %65 = OpLoad %24 %46
         %66 = OpLoad %24 %56
         %67 = OpCompositeConstruct %32 %65 %66
         %68 = OpImageRead %38 %64 %67
         %69 = OpCompositeExtract %24 %68 0
         %70 = OpLoad %24 %44
         %71 = OpIAdd %24 %70 %69
               OpStore %44 %71
               OpBranch %60
         %60 = OpLabel
         %72 = OpLoad %24 %56
         %74 = OpIAdd %24 %72 %73
               OpStore %56 %74
               OpBranch %57
         %59 = OpLabel
               OpBranch %50
         %50 = OpLabel
         %75 = OpLoad %24 %46
         %76 = OpIAdd %24 %75 %73
               OpStore %46 %76
               OpBranch %47
         %49 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
         %83 = OpLoad %24 %44
         %85 = OpAccessChain %84 %82 %53
               OpStore %85 %83
               OpReturn
               OpFunctionEnd
          %8 = OpFunction %2 None %3
          %9 = OpLabel
        %101 = OpVariable %43 Function
         %92 = OpAccessChain %91 %90 %73
         %93 = OpLoad %87 %92
         %95 = OpAccessChain %94 %82 %45
         %96 = OpLoad %77 %95
         %97 = OpConvertUToF %86 %96
         %98 = OpMatrixTimesVector %86 %93 %97
         %99 = OpConvertFToU %77 %98
        %100 = OpAccessChain %94 %82 %45
               OpStore %100 %99
               OpStore %101 %45
               OpBranch %102
        %102 = OpLabel
               OpLoopMerge %104 %105 None
               OpBranch %106
        %106 = OpLabel
        %107 = OpLoad %24 %101
        %109 = OpSLessThan %54 %107 %108
               OpBranchConditional %109 %103 %104
        %103 = OpLabel
        %111 = OpAccessChain %110 %82 %73
        %112 = OpLoad %79 %111
        %114 = OpAccessChain %113 %90 %53
        %115 = OpLoad %78 %114
        %116 = OpVectorTimesScalar %79 %112 %115
        %117 = OpConvertFToU %13 %116
        %118 = OpCompositeExtract %10 %117 0
        %119 = OpCompositeExtract %10 %117 1
        %120 = OpCompositeExtract %10 %117 2
        %121 = OpCompositeConstruct %77 %118 %119 %120 %16
        %122 = OpAccessChain %94 %82 %45
        %123 = OpLoad %77 %122
        %124 = OpIAdd %77 %123 %121
        %125 = OpAccessChain %94 %82 %45
               OpStore %125 %124
               OpBranch %105
        %105 = OpLabel
        %126 = OpLoad %24 %101
        %127 = OpIAdd %24 %126 %73
               OpStore %101 %127
               OpBranch %102
        %104 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
        %128 = OpLoad %25 %27
        %130 = OpImageRead %38 %128 %129
        %131 = OpCompositeExtract %24 %130 0
        %132 = OpConvertSToF %78 %131
        %133 = OpCompositeConstruct %79 %132 %132 %132
        %134 = OpAccessChain %110 %82 %73
               OpStore %134 %133
               OpReturn
               OpFunctionEnd
)";
constexpr char kDst[] = R"(               OpCapability Shader
          %1 = OpExtInstImport "GLSL.std.450"
               OpMemoryModel Logical GLSL450
               OpEntryPoint GLCompute %4 "main" %15
               OpExecutionMode %4 LocalSize 1 1 1
               OpSource ESSL 310
               OpName %4 "main"
               OpName %6 "f1("
               OpName %8 "f2("
               OpName %12 "x"
               OpName %15 "gl_LocalInvocationID"
               OpName %20 "y"
               OpName %27 "image"
               OpName %44 "sum"
               OpName %46 "i"
               OpName %56 "j"
               OpName %80 "BufferOut"
               OpMemberName %80 0 "o_uv4"
               OpMemberName %80 1 "o_v3"
               OpMemberName %80 2 "o_i"
               OpName %82 ""
               OpName %88 "BufferIn"
               OpMemberName %88 0 "i_u"
               OpMemberName %88 1 "i_v4"
               OpMemberName %88 2 "i_f"
               OpName %90 ""
               OpName %101 "i"
               OpName %128 "image2"
               OpDecorate %15 BuiltIn LocalInvocationId
               OpDecorate %27 DescriptorSet 0
               OpDecorate %27 Binding 2
               OpMemberDecorate %80 0 Offset 0
               OpMemberDecorate %80 1 Offset 16
               OpMemberDecorate %80 2 Offset 28
               OpDecorate %80 BufferBlock
               OpDecorate %82 DescriptorSet 0
               OpDecorate %82 Binding 1
               OpMemberDecorate %88 0 Offset 0
               OpMemberDecorate %88 1 RowMajor
               OpMemberDecorate %88 1 Offset 16
               OpMemberDecorate %88 1 MatrixStride 16
               OpMemberDecorate %88 2 Offset 80
               OpDecorate %88 Block
               OpDecorate %90 DescriptorSet 0
               OpDecorate %90 Binding 0
               OpDecorate %128 DescriptorSet 0
               OpDecorate %128 Binding 3
          %2 = OpTypeVoid
          %3 = OpTypeFunction %2
         %10 = OpTypeInt 32 0
         %11 = OpTypePointer Function %10
         %13 = OpTypeVector %10 3
         %14 = OpTypePointer Input %13
         %15 = OpVariable %14 Input
         %16 = OpConstant %10 0
         %17 = OpTypePointer Input %10
         %21 = OpConstant %10 1
         %24 = OpTypeInt 32 1
         %25 = OpTypeImage %24 2D 0 0 0 2 R32i
         %26 = OpTypePointer UniformConstant %25
         %27 = OpVariable %26 UniformConstant
         %29 = OpTypeVector %10 2
         %32 = OpTypeVector %24 2
         %38 = OpTypeVector %24 4
         %40 = OpConstant %10 2
         %41 = OpConstant %10 3400
         %42 = OpConstant %10 264
         %43 = OpTypePointer Function %24
         %45 = OpConstant %24 0
         %53 = OpConstant %24 2
         %54 = OpTypeBool
         %73 = OpConstant %24 1
         %77 = OpTypeVector %10 4
         %78 = OpTypeFloat 32
         %79 = OpTypeVector %78 3
         %80 = OpTypeStruct %77 %79 %24
         %81 = OpTypePointer Uniform %80
         %82 = OpVariable %81 Uniform
         %84 = OpTypePointer Uniform %24
         %86 = OpTypeVector %78 4
         %87 = OpTypeMatrix %86 4
         %88 = OpTypeStruct %10 %87 %78
         %89 = OpTypePointer Uniform %88
         %90 = OpVariable %89 Uniform
         %91 = OpTypePointer Uniform %87
         %94 = OpTypePointer Uniform %77
        %108 = OpConstant %24 3
        %110 = OpTypePointer Uniform %79
        %113 = OpTypePointer Uniform %78
        %128 = OpVariable %26 UniformConstant
        %130 = OpConstantComposite %32 %45 %45
          %4 = OpFunction %2 None %3
          %5 = OpLabel
        %136 = OpFunctionCall %2 %6
        %137 = OpFunctionCall %2 %8
               OpReturn
               OpFunctionEnd
          %6 = OpFunction %2 None %3
          %7 = OpLabel
         %12 = OpVariable %11 Function
         %20 = OpVariable %11 Function
         %44 = OpVariable %43 Function
         %46 = OpVariable %43 Function
         %56 = OpVariable %43 Function
         %18 = OpAccessChain %17 %15 %16
         %19 = OpLoad %10 %18
               OpStore %12 %19
         %22 = OpAccessChain %17 %15 %21
         %23 = OpLoad %10 %22
               OpStore %20 %23
         %28 = OpLoad %25 %27
         %30 = OpLoad %13 %15
         %31 = OpVectorShuffle %29 %30 %30 0 1
         %33 = OpBitcast %32 %31
         %34 = OpLoad %10 %12
         %35 = OpLoad %10 %20
         %36 = OpIAdd %10 %34 %35
         %37 = OpBitcast %24 %36
         %39 = OpCompositeConstruct %38 %37 %37 %37 %37
               OpImageWrite %28 %33 %39
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
               OpStore %44 %45
               OpStore %46 %45
               OpBranch %47
         %47 = OpLabel
               OpLoopMerge %49 %50 None
               OpBranch %51
         %51 = OpLabel
         %52 = OpLoad %24 %46
         %55 = OpSLessThan %54 %52 %53
               OpBranchConditional %55 %48 %49
         %48 = OpLabel
               OpStore %56 %45
               OpBranch %57
         %57 = OpLabel
               OpLoopMerge %59 %60 None
               OpBranch %61
         %61 = OpLabel
         %62 = OpLoad %24 %56
         %63 = OpSLessThan %54 %62 %53
               OpBranchConditional %63 %58 %59
         %58 = OpLabel
         %64 = OpLoad %25 %27
         %65 = OpLoad %24 %46
         %66 = OpLoad %24 %56
         %67 = OpCompositeConstruct %32 %65 %66
         %68 = OpImageRead %38 %64 %67
         %69 = OpCompositeExtract %24 %68 0
         %70 = OpLoad %24 %44
         %71 = OpIMul %24 %70 %69
               OpStore %44 %71
               OpBranch %60
         %60 = OpLabel
         %72 = OpLoad %24 %56
         %74 = OpIAdd %24 %72 %73
               OpStore %56 %74
               OpBranch %57
         %59 = OpLabel
               OpBranch %50
         %50 = OpLabel
         %75 = OpLoad %24 %46
         %76 = OpIAdd %24 %75 %73
               OpStore %46 %76
               OpBranch %47
         %49 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
         %83 = OpLoad %24 %44
         %85 = OpAccessChain %84 %82 %53
               OpStore %85 %83
               OpReturn
               OpFunctionEnd
          %8 = OpFunction %2 None %3
          %9 = OpLabel
        %101 = OpVariable %43 Function
         %92 = OpAccessChain %91 %90 %73
         %93 = OpLoad %87 %92
         %95 = OpAccessChain %94 %82 %45
         %96 = OpLoad %77 %95
         %97 = OpConvertUToF %86 %96
         %98 = OpMatrixTimesVector %86 %93 %97
         %99 = OpConvertFToU %77 %98
        %100 = OpAccessChain %94 %82 %45
               OpStore %100 %99
               OpStore %101 %45
               OpBranch %102
        %102 = OpLabel
               OpLoopMerge %104 %105 None
               OpBranch %106
        %106 = OpLabel
        %107 = OpLoad %24 %101
        %109 = OpSLessThan %54 %107 %108
               OpBranchConditional %109 %103 %104
        %103 = OpLabel
        %111 = OpAccessChain %110 %82 %73
        %112 = OpLoad %79 %111
        %114 = OpAccessChain %113 %90 %53
        %115 = OpLoad %78 %114
        %116 = OpVectorTimesScalar %79 %112 %115
        %117 = OpConvertFToU %13 %116
        %118 = OpCompositeExtract %10 %117 0
        %119 = OpCompositeExtract %10 %117 1
        %120 = OpCompositeExtract %10 %117 2
        %121 = OpCompositeConstruct %77 %118 %119 %120 %16
        %122 = OpAccessChain %94 %82 %45
        %123 = OpLoad %77 %122
        %124 = OpIAdd %77 %123 %121
        %125 = OpAccessChain %94 %82 %45
               OpStore %125 %124
               OpBranch %105
        %105 = OpLabel
        %126 = OpLoad %24 %101
        %127 = OpIAdd %24 %126 %73
               OpStore %101 %127
               OpBranch %102
        %104 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
        %129 = OpLoad %25 %128
        %131 = OpImageRead %38 %129 %130
        %132 = OpCompositeExtract %24 %131 0
        %133 = OpConvertSToF %78 %132
        %134 = OpCompositeConstruct %79 %133 %133 %133
        %135 = OpAccessChain %110 %82 %73
               OpStore %135 %134
               OpReturn
               OpFunctionEnd

)";

TEST(DiffTest, LargeFunctionsSmallDiffs) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 137
+; Bound: 140
 ; Schema: 0
 OpCapability Shader
 %1 = OpExtInstImport "GLSL.std.450"
 OpMemoryModel Logical GLSL450
 OpEntryPoint GLCompute %4 "main" %15
 OpExecutionMode %4 LocalSize 1 1 1
 OpSource ESSL 310
 OpName %4 "main"
 OpName %6 "f1("
 OpName %8 "f2("
 OpName %12 "x"
 OpName %15 "gl_LocalInvocationID"
 OpName %20 "y"
 OpName %27 "image"
 OpName %44 "sum"
 OpName %46 "i"
 OpName %56 "j"
 OpName %80 "BufferOut"
 OpMemberName %80 0 "o_uv4"
 OpMemberName %80 1 "o_v3"
 OpMemberName %80 2 "o_i"
 OpName %82 ""
 OpName %88 "BufferIn"
 OpMemberName %88 0 "i_u"
 OpMemberName %88 1 "i_v4"
 OpMemberName %88 2 "i_f"
 OpName %90 ""
 OpName %101 "i"
+OpName %138 "image2"
 OpDecorate %15 BuiltIn LocalInvocationId
 OpDecorate %27 DescriptorSet 0
 OpDecorate %27 Binding 2
 OpMemberDecorate %80 0 Offset 0
 OpMemberDecorate %80 1 Offset 16
 OpMemberDecorate %80 2 Offset 28
 OpDecorate %80 BufferBlock
 OpDecorate %82 DescriptorSet 0
 OpDecorate %82 Binding 1
 OpMemberDecorate %88 0 Offset 0
 OpMemberDecorate %88 1 RowMajor
 OpMemberDecorate %88 1 Offset 16
 OpMemberDecorate %88 1 MatrixStride 16
 OpMemberDecorate %88 2 Offset 80
 OpDecorate %88 Block
 OpDecorate %90 DescriptorSet 0
 OpDecorate %90 Binding 0
+OpDecorate %138 DescriptorSet 0
+OpDecorate %138 Binding 3
 %2 = OpTypeVoid
 %3 = OpTypeFunction %2
 %10 = OpTypeInt 32 0
 %11 = OpTypePointer Function %10
 %13 = OpTypeVector %10 3
 %14 = OpTypePointer Input %13
 %15 = OpVariable %14 Input
 %16 = OpConstant %10 0
 %17 = OpTypePointer Input %10
 %21 = OpConstant %10 1
 %24 = OpTypeInt 32 1
 %25 = OpTypeImage %24 2D 0 0 0 2 R32i
 %26 = OpTypePointer UniformConstant %25
 %27 = OpVariable %26 UniformConstant
 %29 = OpTypeVector %10 2
 %32 = OpTypeVector %24 2
 %38 = OpTypeVector %24 4
 %40 = OpConstant %10 2
 %41 = OpConstant %10 3400
 %42 = OpConstant %10 264
 %43 = OpTypePointer Function %24
 %45 = OpConstant %24 0
 %53 = OpConstant %24 2
 %54 = OpTypeBool
 %73 = OpConstant %24 1
 %77 = OpTypeVector %10 4
 %78 = OpTypeFloat 32
 %79 = OpTypeVector %78 3
 %80 = OpTypeStruct %77 %79 %24
 %81 = OpTypePointer Uniform %80
 %82 = OpVariable %81 Uniform
 %84 = OpTypePointer Uniform %24
 %86 = OpTypeVector %78 4
 %87 = OpTypeMatrix %86 4
 %88 = OpTypeStruct %10 %87 %78
 %89 = OpTypePointer Uniform %88
 %90 = OpVariable %89 Uniform
 %91 = OpTypePointer Uniform %87
 %94 = OpTypePointer Uniform %77
 %108 = OpConstant %24 3
 %110 = OpTypePointer Uniform %79
 %113 = OpTypePointer Uniform %78
+%138 = OpVariable %26 UniformConstant
 %129 = OpConstantComposite %32 %45 %45
 %4 = OpFunction %2 None %3
 %5 = OpLabel
 %135 = OpFunctionCall %2 %6
 %136 = OpFunctionCall %2 %8
 OpReturn
 OpFunctionEnd
 %6 = OpFunction %2 None %3
 %7 = OpLabel
 %12 = OpVariable %11 Function
 %20 = OpVariable %11 Function
 %44 = OpVariable %43 Function
 %46 = OpVariable %43 Function
 %56 = OpVariable %43 Function
 %18 = OpAccessChain %17 %15 %16
 %19 = OpLoad %10 %18
 OpStore %12 %19
 %22 = OpAccessChain %17 %15 %21
 %23 = OpLoad %10 %22
 OpStore %20 %23
 %28 = OpLoad %25 %27
 %30 = OpLoad %13 %15
 %31 = OpVectorShuffle %29 %30 %30 0 1
 %33 = OpBitcast %32 %31
 %34 = OpLoad %10 %12
 %35 = OpLoad %10 %20
 %36 = OpIAdd %10 %34 %35
 %37 = OpBitcast %24 %36
 %39 = OpCompositeConstruct %38 %37 %37 %37 %37
 OpImageWrite %28 %33 %39
 OpMemoryBarrier %40 %41
 OpControlBarrier %40 %40 %42
 OpStore %44 %45
 OpStore %46 %45
 OpBranch %47
 %47 = OpLabel
 OpLoopMerge %49 %50 None
 OpBranch %51
 %51 = OpLabel
 %52 = OpLoad %24 %46
 %55 = OpSLessThan %54 %52 %53
 OpBranchConditional %55 %48 %49
 %48 = OpLabel
 OpStore %56 %45
 OpBranch %57
 %57 = OpLabel
 OpLoopMerge %59 %60 None
 OpBranch %61
 %61 = OpLabel
 %62 = OpLoad %24 %56
 %63 = OpSLessThan %54 %62 %53
 OpBranchConditional %63 %58 %59
 %58 = OpLabel
 %64 = OpLoad %25 %27
 %65 = OpLoad %24 %46
 %66 = OpLoad %24 %56
 %67 = OpCompositeConstruct %32 %65 %66
 %68 = OpImageRead %38 %64 %67
 %69 = OpCompositeExtract %24 %68 0
 %70 = OpLoad %24 %44
-%71 = OpIAdd %24 %70 %69
+%137 = OpIMul %24 %70 %69
-OpStore %44 %71
+OpStore %44 %137
 OpBranch %60
 %60 = OpLabel
 %72 = OpLoad %24 %56
 %74 = OpIAdd %24 %72 %73
 OpStore %56 %74
 OpBranch %57
 %59 = OpLabel
 OpBranch %50
 %50 = OpLabel
 %75 = OpLoad %24 %46
 %76 = OpIAdd %24 %75 %73
 OpStore %46 %76
 OpBranch %47
 %49 = OpLabel
 OpMemoryBarrier %40 %41
 OpControlBarrier %40 %40 %42
 %83 = OpLoad %24 %44
 %85 = OpAccessChain %84 %82 %53
 OpStore %85 %83
 OpReturn
 OpFunctionEnd
 %8 = OpFunction %2 None %3
 %9 = OpLabel
 %101 = OpVariable %43 Function
 %92 = OpAccessChain %91 %90 %73
 %93 = OpLoad %87 %92
 %95 = OpAccessChain %94 %82 %45
 %96 = OpLoad %77 %95
 %97 = OpConvertUToF %86 %96
 %98 = OpMatrixTimesVector %86 %93 %97
 %99 = OpConvertFToU %77 %98
 %100 = OpAccessChain %94 %82 %45
 OpStore %100 %99
 OpStore %101 %45
 OpBranch %102
 %102 = OpLabel
 OpLoopMerge %104 %105 None
 OpBranch %106
 %106 = OpLabel
 %107 = OpLoad %24 %101
 %109 = OpSLessThan %54 %107 %108
 OpBranchConditional %109 %103 %104
 %103 = OpLabel
 %111 = OpAccessChain %110 %82 %73
 %112 = OpLoad %79 %111
 %114 = OpAccessChain %113 %90 %53
 %115 = OpLoad %78 %114
 %116 = OpVectorTimesScalar %79 %112 %115
 %117 = OpConvertFToU %13 %116
 %118 = OpCompositeExtract %10 %117 0
 %119 = OpCompositeExtract %10 %117 1
 %120 = OpCompositeExtract %10 %117 2
 %121 = OpCompositeConstruct %77 %118 %119 %120 %16
 %122 = OpAccessChain %94 %82 %45
 %123 = OpLoad %77 %122
 %124 = OpIAdd %77 %123 %121
 %125 = OpAccessChain %94 %82 %45
 OpStore %125 %124
 OpBranch %105
 %105 = OpLabel
 %126 = OpLoad %24 %101
 %127 = OpIAdd %24 %126 %73
 OpStore %101 %127
 OpBranch %102
 %104 = OpLabel
 OpMemoryBarrier %40 %41
 OpControlBarrier %40 %40 %42
-%128 = OpLoad %25 %27
+%139 = OpLoad %25 %138
-%130 = OpImageRead %38 %128 %129
+%130 = OpImageRead %38 %139 %129
 %131 = OpCompositeExtract %24 %130 0
 %132 = OpConvertSToF %78 %131
 %133 = OpCompositeConstruct %79 %132 %132 %132
 %134 = OpAccessChain %110 %82 %73
 OpStore %134 %133
 OpReturn
 OpFunctionEnd
)";
  Options options;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

TEST(DiffTest, LargeFunctionsSmallDiffsNoDebug) {
  constexpr char kSrcNoDebug[] = R"(               OpCapability Shader
          %1 = OpExtInstImport "GLSL.std.450"
               OpMemoryModel Logical GLSL450
               OpEntryPoint GLCompute %4 "main" %15
               OpExecutionMode %4 LocalSize 1 1 1
               OpSource ESSL 310
               OpDecorate %15 BuiltIn LocalInvocationId
               OpDecorate %27 DescriptorSet 0
               OpDecorate %27 Binding 2
               OpMemberDecorate %80 0 Offset 0
               OpMemberDecorate %80 1 Offset 16
               OpMemberDecorate %80 2 Offset 28
               OpDecorate %80 BufferBlock
               OpDecorate %82 DescriptorSet 0
               OpDecorate %82 Binding 1
               OpMemberDecorate %88 0 Offset 0
               OpMemberDecorate %88 1 RowMajor
               OpMemberDecorate %88 1 Offset 16
               OpMemberDecorate %88 1 MatrixStride 16
               OpMemberDecorate %88 2 Offset 80
               OpDecorate %88 Block
               OpDecorate %90 DescriptorSet 0
               OpDecorate %90 Binding 0
          %2 = OpTypeVoid
          %3 = OpTypeFunction %2
         %10 = OpTypeInt 32 0
         %11 = OpTypePointer Function %10
         %13 = OpTypeVector %10 3
         %14 = OpTypePointer Input %13
         %15 = OpVariable %14 Input
         %16 = OpConstant %10 0
         %17 = OpTypePointer Input %10
         %21 = OpConstant %10 1
         %24 = OpTypeInt 32 1
         %25 = OpTypeImage %24 2D 0 0 0 2 R32i
         %26 = OpTypePointer UniformConstant %25
         %27 = OpVariable %26 UniformConstant
         %29 = OpTypeVector %10 2
         %32 = OpTypeVector %24 2
         %38 = OpTypeVector %24 4
         %40 = OpConstant %10 2
         %41 = OpConstant %10 3400
         %42 = OpConstant %10 264
         %43 = OpTypePointer Function %24
         %45 = OpConstant %24 0
         %53 = OpConstant %24 2
         %54 = OpTypeBool
         %73 = OpConstant %24 1
         %77 = OpTypeVector %10 4
         %78 = OpTypeFloat 32
         %79 = OpTypeVector %78 3
         %80 = OpTypeStruct %77 %79 %24
         %81 = OpTypePointer Uniform %80
         %82 = OpVariable %81 Uniform
         %84 = OpTypePointer Uniform %24
         %86 = OpTypeVector %78 4
         %87 = OpTypeMatrix %86 4
         %88 = OpTypeStruct %10 %87 %78
         %89 = OpTypePointer Uniform %88
         %90 = OpVariable %89 Uniform
         %91 = OpTypePointer Uniform %87
         %94 = OpTypePointer Uniform %77
        %108 = OpConstant %24 3
        %110 = OpTypePointer Uniform %79
        %113 = OpTypePointer Uniform %78
        %129 = OpConstantComposite %32 %45 %45
          %4 = OpFunction %2 None %3
          %5 = OpLabel
        %135 = OpFunctionCall %2 %6
        %136 = OpFunctionCall %2 %8
               OpReturn
               OpFunctionEnd
          %6 = OpFunction %2 None %3
          %7 = OpLabel
         %12 = OpVariable %11 Function
         %20 = OpVariable %11 Function
         %44 = OpVariable %43 Function
         %46 = OpVariable %43 Function
         %56 = OpVariable %43 Function
         %18 = OpAccessChain %17 %15 %16
         %19 = OpLoad %10 %18
               OpStore %12 %19
         %22 = OpAccessChain %17 %15 %21
         %23 = OpLoad %10 %22
               OpStore %20 %23
         %28 = OpLoad %25 %27
         %30 = OpLoad %13 %15
         %31 = OpVectorShuffle %29 %30 %30 0 1
         %33 = OpBitcast %32 %31
         %34 = OpLoad %10 %12
         %35 = OpLoad %10 %20
         %36 = OpIAdd %10 %34 %35
         %37 = OpBitcast %24 %36
         %39 = OpCompositeConstruct %38 %37 %37 %37 %37
               OpImageWrite %28 %33 %39
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
               OpStore %44 %45
               OpStore %46 %45
               OpBranch %47
         %47 = OpLabel
               OpLoopMerge %49 %50 None
               OpBranch %51
         %51 = OpLabel
         %52 = OpLoad %24 %46
         %55 = OpSLessThan %54 %52 %53
               OpBranchConditional %55 %48 %49
         %48 = OpLabel
               OpStore %56 %45
               OpBranch %57
         %57 = OpLabel
               OpLoopMerge %59 %60 None
               OpBranch %61
         %61 = OpLabel
         %62 = OpLoad %24 %56
         %63 = OpSLessThan %54 %62 %53
               OpBranchConditional %63 %58 %59
         %58 = OpLabel
         %64 = OpLoad %25 %27
         %65 = OpLoad %24 %46
         %66 = OpLoad %24 %56
         %67 = OpCompositeConstruct %32 %65 %66
         %68 = OpImageRead %38 %64 %67
         %69 = OpCompositeExtract %24 %68 0
         %70 = OpLoad %24 %44
         %71 = OpIAdd %24 %70 %69
               OpStore %44 %71
               OpBranch %60
         %60 = OpLabel
         %72 = OpLoad %24 %56
         %74 = OpIAdd %24 %72 %73
               OpStore %56 %74
               OpBranch %57
         %59 = OpLabel
               OpBranch %50
         %50 = OpLabel
         %75 = OpLoad %24 %46
         %76 = OpIAdd %24 %75 %73
               OpStore %46 %76
               OpBranch %47
         %49 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
         %83 = OpLoad %24 %44
         %85 = OpAccessChain %84 %82 %53
               OpStore %85 %83
               OpReturn
               OpFunctionEnd
          %8 = OpFunction %2 None %3
          %9 = OpLabel
        %101 = OpVariable %43 Function
         %92 = OpAccessChain %91 %90 %73
         %93 = OpLoad %87 %92
         %95 = OpAccessChain %94 %82 %45
         %96 = OpLoad %77 %95
         %97 = OpConvertUToF %86 %96
         %98 = OpMatrixTimesVector %86 %93 %97
         %99 = OpConvertFToU %77 %98
        %100 = OpAccessChain %94 %82 %45
               OpStore %100 %99
               OpStore %101 %45
               OpBranch %102
        %102 = OpLabel
               OpLoopMerge %104 %105 None
               OpBranch %106
        %106 = OpLabel
        %107 = OpLoad %24 %101
        %109 = OpSLessThan %54 %107 %108
               OpBranchConditional %109 %103 %104
        %103 = OpLabel
        %111 = OpAccessChain %110 %82 %73
        %112 = OpLoad %79 %111
        %114 = OpAccessChain %113 %90 %53
        %115 = OpLoad %78 %114
        %116 = OpVectorTimesScalar %79 %112 %115
        %117 = OpConvertFToU %13 %116
        %118 = OpCompositeExtract %10 %117 0
        %119 = OpCompositeExtract %10 %117 1
        %120 = OpCompositeExtract %10 %117 2
        %121 = OpCompositeConstruct %77 %118 %119 %120 %16
        %122 = OpAccessChain %94 %82 %45
        %123 = OpLoad %77 %122
        %124 = OpIAdd %77 %123 %121
        %125 = OpAccessChain %94 %82 %45
               OpStore %125 %124
               OpBranch %105
        %105 = OpLabel
        %126 = OpLoad %24 %101
        %127 = OpIAdd %24 %126 %73
               OpStore %101 %127
               OpBranch %102
        %104 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
        %128 = OpLoad %25 %27
        %130 = OpImageRead %38 %128 %129
        %131 = OpCompositeExtract %24 %130 0
        %132 = OpConvertSToF %78 %131
        %133 = OpCompositeConstruct %79 %132 %132 %132
        %134 = OpAccessChain %110 %82 %73
               OpStore %134 %133
               OpReturn
               OpFunctionEnd

)";
  constexpr char kDstNoDebug[] = R"(               OpCapability Shader
          %1 = OpExtInstImport "GLSL.std.450"
               OpMemoryModel Logical GLSL450
               OpEntryPoint GLCompute %4 "main" %15
               OpExecutionMode %4 LocalSize 1 1 1
               OpSource ESSL 310
               OpDecorate %15 BuiltIn LocalInvocationId
               OpDecorate %27 DescriptorSet 0
               OpDecorate %27 Binding 2
               OpMemberDecorate %80 0 Offset 0
               OpMemberDecorate %80 1 Offset 16
               OpMemberDecorate %80 2 Offset 28
               OpDecorate %80 BufferBlock
               OpDecorate %82 DescriptorSet 0
               OpDecorate %82 Binding 1
               OpMemberDecorate %88 0 Offset 0
               OpMemberDecorate %88 1 RowMajor
               OpMemberDecorate %88 1 Offset 16
               OpMemberDecorate %88 1 MatrixStride 16
               OpMemberDecorate %88 2 Offset 80
               OpDecorate %88 Block
               OpDecorate %90 DescriptorSet 0
               OpDecorate %90 Binding 0
               OpDecorate %128 DescriptorSet 0
               OpDecorate %128 Binding 3
          %2 = OpTypeVoid
          %3 = OpTypeFunction %2
         %10 = OpTypeInt 32 0
         %11 = OpTypePointer Function %10
         %13 = OpTypeVector %10 3
         %14 = OpTypePointer Input %13
         %15 = OpVariable %14 Input
         %16 = OpConstant %10 0
         %17 = OpTypePointer Input %10
         %21 = OpConstant %10 1
         %24 = OpTypeInt 32 1
         %25 = OpTypeImage %24 2D 0 0 0 2 R32i
         %26 = OpTypePointer UniformConstant %25
         %27 = OpVariable %26 UniformConstant
         %29 = OpTypeVector %10 2
         %32 = OpTypeVector %24 2
         %38 = OpTypeVector %24 4
         %40 = OpConstant %10 2
         %41 = OpConstant %10 3400
         %42 = OpConstant %10 264
         %43 = OpTypePointer Function %24
         %45 = OpConstant %24 0
         %53 = OpConstant %24 2
         %54 = OpTypeBool
         %73 = OpConstant %24 1
         %77 = OpTypeVector %10 4
         %78 = OpTypeFloat 32
         %79 = OpTypeVector %78 3
         %80 = OpTypeStruct %77 %79 %24
         %81 = OpTypePointer Uniform %80
         %82 = OpVariable %81 Uniform
         %84 = OpTypePointer Uniform %24
         %86 = OpTypeVector %78 4
         %87 = OpTypeMatrix %86 4
         %88 = OpTypeStruct %10 %87 %78
         %89 = OpTypePointer Uniform %88
         %90 = OpVariable %89 Uniform
         %91 = OpTypePointer Uniform %87
         %94 = OpTypePointer Uniform %77
        %108 = OpConstant %24 3
        %110 = OpTypePointer Uniform %79
        %113 = OpTypePointer Uniform %78
        %128 = OpVariable %26 UniformConstant
        %130 = OpConstantComposite %32 %45 %45
          %4 = OpFunction %2 None %3
          %5 = OpLabel
        %136 = OpFunctionCall %2 %6
        %137 = OpFunctionCall %2 %8
               OpReturn
               OpFunctionEnd
          %6 = OpFunction %2 None %3
          %7 = OpLabel
         %12 = OpVariable %11 Function
         %20 = OpVariable %11 Function
         %44 = OpVariable %43 Function
         %46 = OpVariable %43 Function
         %56 = OpVariable %43 Function
         %18 = OpAccessChain %17 %15 %16
         %19 = OpLoad %10 %18
               OpStore %12 %19
         %22 = OpAccessChain %17 %15 %21
         %23 = OpLoad %10 %22
               OpStore %20 %23
         %28 = OpLoad %25 %27
         %30 = OpLoad %13 %15
         %31 = OpVectorShuffle %29 %30 %30 0 1
         %33 = OpBitcast %32 %31
         %34 = OpLoad %10 %12
         %35 = OpLoad %10 %20
         %36 = OpIAdd %10 %34 %35
         %37 = OpBitcast %24 %36
         %39 = OpCompositeConstruct %38 %37 %37 %37 %37
               OpImageWrite %28 %33 %39
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
               OpStore %44 %45
               OpStore %46 %45
               OpBranch %47
         %47 = OpLabel
               OpLoopMerge %49 %50 None
               OpBranch %51
         %51 = OpLabel
         %52 = OpLoad %24 %46
         %55 = OpSLessThan %54 %52 %53
               OpBranchConditional %55 %48 %49
         %48 = OpLabel
               OpStore %56 %45
               OpBranch %57
         %57 = OpLabel
               OpLoopMerge %59 %60 None
               OpBranch %61
         %61 = OpLabel
         %62 = OpLoad %24 %56
         %63 = OpSLessThan %54 %62 %53
               OpBranchConditional %63 %58 %59
         %58 = OpLabel
         %64 = OpLoad %25 %27
         %65 = OpLoad %24 %46
         %66 = OpLoad %24 %56
         %67 = OpCompositeConstruct %32 %65 %66
         %68 = OpImageRead %38 %64 %67
         %69 = OpCompositeExtract %24 %68 0
         %70 = OpLoad %24 %44
         %71 = OpIMul %24 %70 %69
               OpStore %44 %71
               OpBranch %60
         %60 = OpLabel
         %72 = OpLoad %24 %56
         %74 = OpIAdd %24 %72 %73
               OpStore %56 %74
               OpBranch %57
         %59 = OpLabel
               OpBranch %50
         %50 = OpLabel
         %75 = OpLoad %24 %46
         %76 = OpIAdd %24 %75 %73
               OpStore %46 %76
               OpBranch %47
         %49 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
         %83 = OpLoad %24 %44
         %85 = OpAccessChain %84 %82 %53
               OpStore %85 %83
               OpReturn
               OpFunctionEnd
          %8 = OpFunction %2 None %3
          %9 = OpLabel
        %101 = OpVariable %43 Function
         %92 = OpAccessChain %91 %90 %73
         %93 = OpLoad %87 %92
         %95 = OpAccessChain %94 %82 %45
         %96 = OpLoad %77 %95
         %97 = OpConvertUToF %86 %96
         %98 = OpMatrixTimesVector %86 %93 %97
         %99 = OpConvertFToU %77 %98
        %100 = OpAccessChain %94 %82 %45
               OpStore %100 %99
               OpStore %101 %45
               OpBranch %102
        %102 = OpLabel
               OpLoopMerge %104 %105 None
               OpBranch %106
        %106 = OpLabel
        %107 = OpLoad %24 %101
        %109 = OpSLessThan %54 %107 %108
               OpBranchConditional %109 %103 %104
        %103 = OpLabel
        %111 = OpAccessChain %110 %82 %73
        %112 = OpLoad %79 %111
        %114 = OpAccessChain %113 %90 %53
        %115 = OpLoad %78 %114
        %116 = OpVectorTimesScalar %79 %112 %115
        %117 = OpConvertFToU %13 %116
        %118 = OpCompositeExtract %10 %117 0
        %119 = OpCompositeExtract %10 %117 1
        %120 = OpCompositeExtract %10 %117 2
        %121 = OpCompositeConstruct %77 %118 %119 %120 %16
        %122 = OpAccessChain %94 %82 %45
        %123 = OpLoad %77 %122
        %124 = OpIAdd %77 %123 %121
        %125 = OpAccessChain %94 %82 %45
               OpStore %125 %124
               OpBranch %105
        %105 = OpLabel
        %126 = OpLoad %24 %101
        %127 = OpIAdd %24 %126 %73
               OpStore %101 %127
               OpBranch %102
        %104 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
        %129 = OpLoad %25 %128
        %131 = OpImageRead %38 %129 %130
        %132 = OpCompositeExtract %24 %131 0
        %133 = OpConvertSToF %78 %132
        %134 = OpCompositeConstruct %79 %133 %133 %133
        %135 = OpAccessChain %110 %82 %73
               OpStore %135 %134
               OpReturn
               OpFunctionEnd

)";
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 137
+; Bound: 140
 ; Schema: 0
 OpCapability Shader
 %1 = OpExtInstImport "GLSL.std.450"
 OpMemoryModel Logical GLSL450
 OpEntryPoint GLCompute %4 "main" %15
 OpExecutionMode %4 LocalSize 1 1 1
 OpSource ESSL 310
 OpDecorate %15 BuiltIn LocalInvocationId
 OpDecorate %27 DescriptorSet 0
 OpDecorate %27 Binding 2
 OpMemberDecorate %80 0 Offset 0
 OpMemberDecorate %80 1 Offset 16
 OpMemberDecorate %80 2 Offset 28
 OpDecorate %80 BufferBlock
 OpDecorate %82 DescriptorSet 0
 OpDecorate %82 Binding 1
 OpMemberDecorate %88 0 Offset 0
 OpMemberDecorate %88 1 RowMajor
 OpMemberDecorate %88 1 Offset 16
 OpMemberDecorate %88 1 MatrixStride 16
 OpMemberDecorate %88 2 Offset 80
 OpDecorate %88 Block
 OpDecorate %90 DescriptorSet 0
 OpDecorate %90 Binding 0
+OpDecorate %138 DescriptorSet 0
+OpDecorate %138 Binding 3
 %2 = OpTypeVoid
 %3 = OpTypeFunction %2
 %10 = OpTypeInt 32 0
 %11 = OpTypePointer Function %10
 %13 = OpTypeVector %10 3
 %14 = OpTypePointer Input %13
 %15 = OpVariable %14 Input
 %16 = OpConstant %10 0
 %17 = OpTypePointer Input %10
 %21 = OpConstant %10 1
 %24 = OpTypeInt 32 1
 %25 = OpTypeImage %24 2D 0 0 0 2 R32i
 %26 = OpTypePointer UniformConstant %25
 %27 = OpVariable %26 UniformConstant
 %29 = OpTypeVector %10 2
 %32 = OpTypeVector %24 2
 %38 = OpTypeVector %24 4
 %40 = OpConstant %10 2
 %41 = OpConstant %10 3400
 %42 = OpConstant %10 264
 %43 = OpTypePointer Function %24
 %45 = OpConstant %24 0
 %53 = OpConstant %24 2
 %54 = OpTypeBool
 %73 = OpConstant %24 1
 %77 = OpTypeVector %10 4
 %78 = OpTypeFloat 32
 %79 = OpTypeVector %78 3
 %80 = OpTypeStruct %77 %79 %24
 %81 = OpTypePointer Uniform %80
 %82 = OpVariable %81 Uniform
 %84 = OpTypePointer Uniform %24
 %86 = OpTypeVector %78 4
 %87 = OpTypeMatrix %86 4
 %88 = OpTypeStruct %10 %87 %78
 %89 = OpTypePointer Uniform %88
 %90 = OpVariable %89 Uniform
 %91 = OpTypePointer Uniform %87
 %94 = OpTypePointer Uniform %77
 %108 = OpConstant %24 3
 %110 = OpTypePointer Uniform %79
 %113 = OpTypePointer Uniform %78
+%138 = OpVariable %26 UniformConstant
 %129 = OpConstantComposite %32 %45 %45
 %4 = OpFunction %2 None %3
 %5 = OpLabel
 %135 = OpFunctionCall %2 %6
 %136 = OpFunctionCall %2 %8
 OpReturn
 OpFunctionEnd
 %6 = OpFunction %2 None %3
 %7 = OpLabel
 %12 = OpVariable %11 Function
 %20 = OpVariable %11 Function
 %44 = OpVariable %43 Function
 %46 = OpVariable %43 Function
 %56 = OpVariable %43 Function
 %18 = OpAccessChain %17 %15 %16
 %19 = OpLoad %10 %18
 OpStore %12 %19
 %22 = OpAccessChain %17 %15 %21
 %23 = OpLoad %10 %22
 OpStore %20 %23
 %28 = OpLoad %25 %27
 %30 = OpLoad %13 %15
 %31 = OpVectorShuffle %29 %30 %30 0 1
 %33 = OpBitcast %32 %31
 %34 = OpLoad %10 %12
 %35 = OpLoad %10 %20
 %36 = OpIAdd %10 %34 %35
 %37 = OpBitcast %24 %36
 %39 = OpCompositeConstruct %38 %37 %37 %37 %37
 OpImageWrite %28 %33 %39
 OpMemoryBarrier %40 %41
 OpControlBarrier %40 %40 %42
 OpStore %44 %45
 OpStore %46 %45
 OpBranch %47
 %47 = OpLabel
 OpLoopMerge %49 %50 None
 OpBranch %51
 %51 = OpLabel
 %52 = OpLoad %24 %46
 %55 = OpSLessThan %54 %52 %53
 OpBranchConditional %55 %48 %49
 %48 = OpLabel
 OpStore %56 %45
 OpBranch %57
 %57 = OpLabel
 OpLoopMerge %59 %60 None
 OpBranch %61
 %61 = OpLabel
 %62 = OpLoad %24 %56
 %63 = OpSLessThan %54 %62 %53
 OpBranchConditional %63 %58 %59
 %58 = OpLabel
 %64 = OpLoad %25 %27
 %65 = OpLoad %24 %46
 %66 = OpLoad %24 %56
 %67 = OpCompositeConstruct %32 %65 %66
 %68 = OpImageRead %38 %64 %67
 %69 = OpCompositeExtract %24 %68 0
 %70 = OpLoad %24 %44
-%71 = OpIAdd %24 %70 %69
+%137 = OpIMul %24 %70 %69
-OpStore %44 %71
+OpStore %44 %137
 OpBranch %60
 %60 = OpLabel
 %72 = OpLoad %24 %56
 %74 = OpIAdd %24 %72 %73
 OpStore %56 %74
 OpBranch %57
 %59 = OpLabel
 OpBranch %50
 %50 = OpLabel
 %75 = OpLoad %24 %46
 %76 = OpIAdd %24 %75 %73
 OpStore %46 %76
 OpBranch %47
 %49 = OpLabel
 OpMemoryBarrier %40 %41
 OpControlBarrier %40 %40 %42
 %83 = OpLoad %24 %44
 %85 = OpAccessChain %84 %82 %53
 OpStore %85 %83
 OpReturn
 OpFunctionEnd
 %8 = OpFunction %2 None %3
 %9 = OpLabel
 %101 = OpVariable %43 Function
 %92 = OpAccessChain %91 %90 %73
 %93 = OpLoad %87 %92
 %95 = OpAccessChain %94 %82 %45
 %96 = OpLoad %77 %95
 %97 = OpConvertUToF %86 %96
 %98 = OpMatrixTimesVector %86 %93 %97
 %99 = OpConvertFToU %77 %98
 %100 = OpAccessChain %94 %82 %45
 OpStore %100 %99
 OpStore %101 %45
 OpBranch %102
 %102 = OpLabel
 OpLoopMerge %104 %105 None
 OpBranch %106
 %106 = OpLabel
 %107 = OpLoad %24 %101
 %109 = OpSLessThan %54 %107 %108
 OpBranchConditional %109 %103 %104
 %103 = OpLabel
 %111 = OpAccessChain %110 %82 %73
 %112 = OpLoad %79 %111
 %114 = OpAccessChain %113 %90 %53
 %115 = OpLoad %78 %114
 %116 = OpVectorTimesScalar %79 %112 %115
 %117 = OpConvertFToU %13 %116
 %118 = OpCompositeExtract %10 %117 0
 %119 = OpCompositeExtract %10 %117 1
 %120 = OpCompositeExtract %10 %117 2
 %121 = OpCompositeConstruct %77 %118 %119 %120 %16
 %122 = OpAccessChain %94 %82 %45
 %123 = OpLoad %77 %122
 %124 = OpIAdd %77 %123 %121
 %125 = OpAccessChain %94 %82 %45
 OpStore %125 %124
 OpBranch %105
 %105 = OpLabel
 %126 = OpLoad %24 %101
 %127 = OpIAdd %24 %126 %73
 OpStore %101 %127
 OpBranch %102
 %104 = OpLabel
 OpMemoryBarrier %40 %41
 OpControlBarrier %40 %40 %42
-%128 = OpLoad %25 %27
+%139 = OpLoad %25 %138
-%130 = OpImageRead %38 %128 %129
+%130 = OpImageRead %38 %139 %129
 %131 = OpCompositeExtract %24 %130 0
 %132 = OpConvertSToF %78 %131
 %133 = OpCompositeConstruct %79 %132 %132 %132
 %134 = OpAccessChain %110 %82 %73
 OpStore %134 %133
 OpReturn
 OpFunctionEnd
)";
  Options options;
  DoStringDiffTest(kSrcNoDebug, kDstNoDebug, kDiff, options);
}

}  // namespace
}  // namespace diff
}  // namespace spvtools
