; RUN: llvm-as %s -o %t.bc
; RUN: llvm-spirv %t.bc -spirv-text -o - | FileCheck %s
; RUN: llvm-spirv %t.bc -o %t.spv
; RUN: spirv-val %t.spv

target datalayout = "e-p:32:32-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024"
target triple = "spir"

; CHECK: ExtInst {{[0-9]+}} {{[0-9]+}} {{[0-9]+}} rint

; Function Attrs: nounwind readnone
define dso_local spir_func float @foo(float %x) local_unnamed_addr #0 {
entry:
  %0 = tail call float @llvm.nearbyint.f32(float %x)
  ret float %0
}

; Function Attrs: nounwind readnone speculatable willreturn
declare float @llvm.nearbyint.f32(float) #1

attributes #0 = { nounwind readnone "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #1 = { nounwind readnone speculatable willreturn }

!llvm.module.flags = !{!0}
!llvm.ident = !{!1}

!0 = !{i32 1, !"wchar_size", i32 4}
!1 = !{!"clang version 12.0.0 (https://github.com/llvm/llvm-project.git 68e1a8d20795802077987529e1268c184d749564)"}