9.3 Boucles multiples en 'live'

# Boucles multiples en "live"

Considérez la boucle en "live" suivante :

```
live_loop :foo do
  play 50
  sleep 1
end
```

Vous pouvez vous être demandé pourquoi elle avait besoin du nom `:foo`.
Ce nom est important parce qu'il signifie que cette boucle est 
différente des autres boucles en "live".

*Il ne peut y avoir deux boucles en "live" en cours d'exécution avec le 
même nom* 

Ce qui signifie que si nous voulons de multiples boucles en "live" 
s'exécutant en simultané, nous devons simplement leur donner des 
noms différents :

```
live_loop :foo do
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end

live_loop :bar do
  sample :bd_haus
  sleep 0.5
end
```

Vous pouvez maintenant modifier et changer chaque boucle indépendamment 
et simplement tout fonctionne.

## Synchronisation des boucles en "live"

Une chose que vous pourriez avoir déjà remarqué est que ces boucles 
en "live" fonctionnent automatiquement avec le mécanisme de thread que 
nous avons exploré précédemment. Chaque fois qu'une "live loop" 
boucle, elle génère un nouvel événement `cue` avec le même nom que 
la boucle. Par conséquent, nous pouvons nous `sync` sur ces cues pour 
garantir que ces boucles soient synchronisées sans avoir à arrêter 
quoi que ce soit.

Considérez ce code mal synchronisé :

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.4
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

Voyons si nous pouvons corriger le timing et synchroniser sans arrêter 
l'exécution. Corrigeons la boucle `:foo` pour l'aligner sur le facteur 
de sleep de 1 - quelque chose comme `0.5` fera l'affaire :

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

Cependant, nous n'avons pas encore tout à fait fini - vous remarquerez 
que les temps ne battent pas ensemble correctement. C'est parce que les 
boucles sont *déphasées*. Corrigeons cela en les synchronisant :

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sync :foo
  sample :bd_haus
  sleep 1
end
```

Wow, tout est maintenant parfaitement en phase - tout cela sans arrêter.

Maintenant, allez de l'avant et codez en "live" avec des "live loops" !
