use crate::descriptor::types::descriptor_proto::ExtensionRange;
use crate::descriptor::types::descriptor_proto::ReservedRange;
use crate::descriptor::types::field_descriptor_proto::Label::*;
use crate::descriptor::types::field_descriptor_proto::Type::*;
use crate::descriptor::types::DescriptorProto;
use crate::descriptor::types::EnumDescriptorProto;
use crate::descriptor::types::EnumValueDescriptorProto;
use crate::descriptor::types::FieldDescriptorProto;
use crate::descriptor::types::FieldOptions;
use crate::descriptor::types::FileDescriptorProto;
use crate::descriptor::types::FileDescriptorSet;
use crate::descriptor::types::FileOptions;
use crate::descriptor::types::MessageOptions;
use crate::descriptor::types::OneofDescriptorProto;
use crate::descriptor::types::Options;
use crate::prost_types::file_options::OptimizeMode::Speed;
use crate::DescriptorError;
use crate::{DescriptorPool, MessageDescriptor, ReflectMessage};

#[allow(deprecated)]
fn make_descriptor() -> FileDescriptorSet {
    FileDescriptorSet {
        file: vec![
            FileDescriptorProto {
                name: Some("google/protobuf/any.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![DescriptorProto {
                    name: Some("Any".into()),
                    field: vec![
                        FieldDescriptorProto {
                            name: Some("type_url".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(String.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("typeUrl".into()),
                            options: None,
                            proto3_optional: None,
                        },
                        FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(2),
                            label: Some(Optional.into()),
                            r#type: Some(Bytes.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        },
                    ],
                    extension: vec![],
                    nested_type: vec![],
                    enum_type: vec![],
                    extension_range: vec![],
                    oneof_decl: vec![],
                    options: None,
                    reserved_range: vec![],
                    reserved_name: vec![],
                }],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("AnyProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/anypb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: None,
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/source_context.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![DescriptorProto {
                    name: Some("SourceContext".into()),
                    field: vec![FieldDescriptorProto {
                        name: Some("file_name".into()),
                        number: Some(1),
                        label: Some(Optional.into()),
                        r#type: Some(String.into()),
                        type_name: None,
                        extendee: None,
                        default_value: None,
                        oneof_index: None,
                        json_name: Some("fileName".into()),
                        options: None,
                        proto3_optional: None,
                    }],
                    extension: vec![],
                    nested_type: vec![],
                    enum_type: vec![],
                    extension_range: vec![],
                    oneof_decl: vec![],
                    options: None,
                    reserved_range: vec![],
                    reserved_name: vec![],
                }],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("SourceContextProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some(
                        "google.golang.org/protobuf/types/known/sourcecontextpb".into(),
                    ),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: None,
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/type.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![
                    "google/protobuf/any.proto".into(),
                    "google/protobuf/source_context.proto".into(),
                ],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![
                    DescriptorProto {
                        name: Some("Type".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("fields".into()),
                                number: Some(2),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Field".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("fields".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("oneofs".into()),
                                number: Some(3),
                                label: Some(Repeated.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("oneofs".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(4),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Option".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("source_context".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.SourceContext".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("sourceContext".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("syntax".into()),
                                number: Some(6),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.Syntax".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("syntax".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("Field".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("kind".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.Field.Kind".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("kind".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("cardinality".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.Field.Cardinality".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("cardinality".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("number".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("number".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("type_url".into()),
                                number: Some(6),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("typeUrl".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("oneof_index".into()),
                                number: Some(7),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("oneofIndex".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("packed".into()),
                                number: Some(8),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("packed".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(9),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Option".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("json_name".into()),
                                number: Some(10),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("jsonName".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("default_value".into()),
                                number: Some(11),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("defaultValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![
                            EnumDescriptorProto {
                                name: Some("Kind".into()),
                                value: vec![
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_UNKNOWN".into()),
                                        number: Some(0),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_DOUBLE".into()),
                                        number: Some(1),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_FLOAT".into()),
                                        number: Some(2),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_INT64".into()),
                                        number: Some(3),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_UINT64".into()),
                                        number: Some(4),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_INT32".into()),
                                        number: Some(5),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_FIXED64".into()),
                                        number: Some(6),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_FIXED32".into()),
                                        number: Some(7),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_BOOL".into()),
                                        number: Some(8),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_STRING".into()),
                                        number: Some(9),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_GROUP".into()),
                                        number: Some(10),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_MESSAGE".into()),
                                        number: Some(11),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_BYTES".into()),
                                        number: Some(12),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_UINT32".into()),
                                        number: Some(13),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_ENUM".into()),
                                        number: Some(14),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_SFIXED32".into()),
                                        number: Some(15),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_SFIXED64".into()),
                                        number: Some(16),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_SINT32".into()),
                                        number: Some(17),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_SINT64".into()),
                                        number: Some(18),
                                        options: None,
                                    },
                                ],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            },
                            EnumDescriptorProto {
                                name: Some("Cardinality".into()),
                                value: vec![
                                    EnumValueDescriptorProto {
                                        name: Some("CARDINALITY_UNKNOWN".into()),
                                        number: Some(0),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("CARDINALITY_OPTIONAL".into()),
                                        number: Some(1),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("CARDINALITY_REQUIRED".into()),
                                        number: Some(2),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("CARDINALITY_REPEATED".into()),
                                        number: Some(3),
                                        options: None,
                                    },
                                ],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            },
                        ],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("Enum".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("enumvalue".into()),
                                number: Some(2),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.EnumValue".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("enumvalue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(3),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Option".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("source_context".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.SourceContext".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("sourceContext".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("syntax".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.Syntax".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("syntax".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("EnumValue".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("number".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("number".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(3),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Option".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("Option".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("value".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Any".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("value".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                ],
                enum_type: vec![EnumDescriptorProto {
                    name: Some("Syntax".into()),
                    value: vec![
                        EnumValueDescriptorProto {
                            name: Some("SYNTAX_PROTO2".into()),
                            number: Some(0),
                            options: None,
                        },
                        EnumValueDescriptorProto {
                            name: Some("SYNTAX_PROTO3".into()),
                            number: Some(1),
                            options: None,
                        },
                    ],
                    options: None,
                    reserved_range: vec![],
                    reserved_name: vec![],
                }],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("TypeProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/typepb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: Some(true),
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/api.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![
                    "google/protobuf/source_context.proto".into(),
                    "google/protobuf/type.proto".into(),
                ],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![
                    DescriptorProto {
                        name: Some("Api".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("methods".into()),
                                number: Some(2),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Method".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("methods".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(3),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Option".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("version".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("version".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("source_context".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.SourceContext".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("sourceContext".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("mixins".into()),
                                number: Some(6),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Mixin".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("mixins".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("syntax".into()),
                                number: Some(7),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.Syntax".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("syntax".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("Method".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("request_type_url".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("requestTypeUrl".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("request_streaming".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("requestStreaming".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("response_type_url".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("responseTypeUrl".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("response_streaming".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("responseStreaming".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(6),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Option".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("syntax".into()),
                                number: Some(7),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.Syntax".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("syntax".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("Mixin".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("root".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("root".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                ],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("ApiProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/apipb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: None,
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/descriptor.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![
                    DescriptorProto {
                        name: Some("FileDescriptorSet".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("file".into()),
                            number: Some(1),
                            label: Some(Repeated.into()),
                            r#type: Some(Message.into()),
                            type_name: Some(".google.protobuf.FileDescriptorProto".into()),
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("file".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("FileDescriptorProto".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("package".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("package".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("dependency".into()),
                                number: Some(3),
                                label: Some(Repeated.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("dependency".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("public_dependency".into()),
                                number: Some(10),
                                label: Some(Repeated.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("publicDependency".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("weak_dependency".into()),
                                number: Some(11),
                                label: Some(Repeated.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("weakDependency".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("message_type".into()),
                                number: Some(4),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.DescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("messageType".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("enum_type".into()),
                                number: Some(5),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.EnumDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("enumType".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("service".into()),
                                number: Some(6),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.ServiceDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("service".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("extension".into()),
                                number: Some(7),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.FieldDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("extension".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(8),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.FileOptions".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("source_code_info".into()),
                                number: Some(9),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.SourceCodeInfo".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("sourceCodeInfo".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("syntax".into()),
                                number: Some(12),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("syntax".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("edition".into()),
                                number: Some(13),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("edition".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("DescriptorProto".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("field".into()),
                                number: Some(2),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.FieldDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("field".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("extension".into()),
                                number: Some(6),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.FieldDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("extension".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("nested_type".into()),
                                number: Some(3),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.DescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("nestedType".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("enum_type".into()),
                                number: Some(4),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.EnumDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("enumType".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("extension_range".into()),
                                number: Some(5),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(
                                    ".google.protobuf.DescriptorProto.ExtensionRange".into(),
                                ),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("extensionRange".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("oneof_decl".into()),
                                number: Some(8),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.OneofDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("oneofDecl".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(7),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.MessageOptions".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("reserved_range".into()),
                                number: Some(9),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(
                                    ".google.protobuf.DescriptorProto.ReservedRange".into(),
                                ),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("reservedRange".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("reserved_name".into()),
                                number: Some(10),
                                label: Some(Repeated.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("reservedName".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![
                            DescriptorProto {
                                name: Some("ExtensionRange".into()),
                                field: vec![
                                    FieldDescriptorProto {
                                        name: Some("start".into()),
                                        number: Some(1),
                                        label: Some(Optional.into()),
                                        r#type: Some(Int32.into()),
                                        type_name: None,
                                        extendee: None,
                                        default_value: None,
                                        oneof_index: None,
                                        json_name: Some("start".into()),
                                        options: None,
                                        proto3_optional: None,
                                    },
                                    FieldDescriptorProto {
                                        name: Some("end".into()),
                                        number: Some(2),
                                        label: Some(Optional.into()),
                                        r#type: Some(Int32.into()),
                                        type_name: None,
                                        extendee: None,
                                        default_value: None,
                                        oneof_index: None,
                                        json_name: Some("end".into()),
                                        options: None,
                                        proto3_optional: None,
                                    },
                                    FieldDescriptorProto {
                                        name: Some("options".into()),
                                        number: Some(3),
                                        label: Some(Optional.into()),
                                        r#type: Some(Message.into()),
                                        type_name: Some(
                                            ".google.protobuf.ExtensionRangeOptions".into(),
                                        ),
                                        extendee: None,
                                        default_value: None,
                                        oneof_index: None,
                                        json_name: Some("options".into()),
                                        options: None,
                                        proto3_optional: None,
                                    },
                                ],
                                extension: vec![],
                                nested_type: vec![],
                                enum_type: vec![],
                                extension_range: vec![],
                                oneof_decl: vec![],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            },
                            DescriptorProto {
                                name: Some("ReservedRange".into()),
                                field: vec![
                                    FieldDescriptorProto {
                                        name: Some("start".into()),
                                        number: Some(1),
                                        label: Some(Optional.into()),
                                        r#type: Some(Int32.into()),
                                        type_name: None,
                                        extendee: None,
                                        default_value: None,
                                        oneof_index: None,
                                        json_name: Some("start".into()),
                                        options: None,
                                        proto3_optional: None,
                                    },
                                    FieldDescriptorProto {
                                        name: Some("end".into()),
                                        number: Some(2),
                                        label: Some(Optional.into()),
                                        r#type: Some(Int32.into()),
                                        type_name: None,
                                        extendee: None,
                                        default_value: None,
                                        oneof_index: None,
                                        json_name: Some("end".into()),
                                        options: None,
                                        proto3_optional: None,
                                    },
                                ],
                                extension: vec![],
                                nested_type: vec![],
                                enum_type: vec![],
                                extension_range: vec![],
                                oneof_decl: vec![],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            },
                        ],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("ExtensionRangeOptions".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("uninterpreted_option".into()),
                            number: Some(999),
                            label: Some(Repeated.into()),
                            r#type: Some(Message.into()),
                            type_name: Some(".google.protobuf.UninterpretedOption".into()),
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("uninterpretedOption".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("FieldDescriptorProto".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("number".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("number".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("label".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(
                                    ".google.protobuf.FieldDescriptorProto.Label".into(),
                                ),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("label".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("type".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(
                                    ".google.protobuf.FieldDescriptorProto.Type".into(),
                                ),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("type".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("type_name".into()),
                                number: Some(6),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("typeName".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("extendee".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("extendee".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("default_value".into()),
                                number: Some(7),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("defaultValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("oneof_index".into()),
                                number: Some(9),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("oneofIndex".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("json_name".into()),
                                number: Some(10),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("jsonName".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(8),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.FieldOptions".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("proto3_optional".into()),
                                number: Some(17),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("proto3Optional".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![
                            EnumDescriptorProto {
                                name: Some("Type".into()),
                                value: vec![
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_DOUBLE".into()),
                                        number: Some(1),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_FLOAT".into()),
                                        number: Some(2),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_INT64".into()),
                                        number: Some(3),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_UINT64".into()),
                                        number: Some(4),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_INT32".into()),
                                        number: Some(5),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_FIXED64".into()),
                                        number: Some(6),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_FIXED32".into()),
                                        number: Some(7),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_BOOL".into()),
                                        number: Some(8),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_STRING".into()),
                                        number: Some(9),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_GROUP".into()),
                                        number: Some(10),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_MESSAGE".into()),
                                        number: Some(11),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_BYTES".into()),
                                        number: Some(12),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_UINT32".into()),
                                        number: Some(13),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_ENUM".into()),
                                        number: Some(14),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_SFIXED32".into()),
                                        number: Some(15),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_SFIXED64".into()),
                                        number: Some(16),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_SINT32".into()),
                                        number: Some(17),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("TYPE_SINT64".into()),
                                        number: Some(18),
                                        options: None,
                                    },
                                ],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            },
                            EnumDescriptorProto {
                                name: Some("Label".into()),
                                value: vec![
                                    EnumValueDescriptorProto {
                                        name: Some("LABEL_OPTIONAL".into()),
                                        number: Some(1),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("LABEL_REQUIRED".into()),
                                        number: Some(2),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("LABEL_REPEATED".into()),
                                        number: Some(3),
                                        options: None,
                                    },
                                ],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            },
                        ],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("OneofDescriptorProto".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.OneofOptions".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("EnumDescriptorProto".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("value".into()),
                                number: Some(2),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.EnumValueDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("value".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.EnumOptions".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("reserved_range".into()),
                                number: Some(4),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(
                                    ".google.protobuf.EnumDescriptorProto.EnumReservedRange".into(),
                                ),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("reservedRange".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("reserved_name".into()),
                                number: Some(5),
                                label: Some(Repeated.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("reservedName".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![DescriptorProto {
                            name: Some("EnumReservedRange".into()),
                            field: vec![
                                FieldDescriptorProto {
                                    name: Some("start".into()),
                                    number: Some(1),
                                    label: Some(Optional.into()),
                                    r#type: Some(Int32.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("start".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("end".into()),
                                    number: Some(2),
                                    label: Some(Optional.into()),
                                    r#type: Some(Int32.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("end".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                            ],
                            extension: vec![],
                            nested_type: vec![],
                            enum_type: vec![],
                            extension_range: vec![],
                            oneof_decl: vec![],
                            options: None,
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("EnumValueDescriptorProto".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("number".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("number".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.EnumValueOptions".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("ServiceDescriptorProto".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("method".into()),
                                number: Some(2),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.MethodDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("method".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.ServiceOptions".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("MethodDescriptorProto".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("input_type".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("inputType".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("output_type".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("outputType".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("options".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.MethodOptions".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("options".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("client_streaming".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("clientStreaming".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("server_streaming".into()),
                                number: Some(6),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("serverStreaming".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("FileOptions".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("java_package".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("javaPackage".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("java_outer_classname".into()),
                                number: Some(8),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("javaOuterClassname".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("java_multiple_files".into()),
                                number: Some(10),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("javaMultipleFiles".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("java_generate_equals_and_hash".into()),
                                number: Some(20),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("javaGenerateEqualsAndHash".into()),
                                options: Some(Options::from_prost(FieldOptions {
                                    ctype: None,
                                    packed: None,
                                    jstype: None,
                                    lazy: None,
                                    deprecated: Some(true),
                                    weak: None,
                                    uninterpreted_option: vec![],
                                })),
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("java_string_check_utf8".into()),
                                number: Some(27),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("javaStringCheckUtf8".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("optimize_for".into()),
                                number: Some(9),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.FileOptions.OptimizeMode".into()),
                                extendee: None,
                                default_value: Some("SPEED".into()),
                                oneof_index: None,
                                json_name: Some("optimizeFor".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("go_package".into()),
                                number: Some(11),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("goPackage".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("cc_generic_services".into()),
                                number: Some(16),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("ccGenericServices".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("java_generic_services".into()),
                                number: Some(17),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("javaGenericServices".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("py_generic_services".into()),
                                number: Some(18),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("pyGenericServices".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("php_generic_services".into()),
                                number: Some(42),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("phpGenericServices".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("deprecated".into()),
                                number: Some(23),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("deprecated".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("cc_enable_arenas".into()),
                                number: Some(31),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("true".into()),
                                oneof_index: None,
                                json_name: Some("ccEnableArenas".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("objc_class_prefix".into()),
                                number: Some(36),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("objcClassPrefix".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("csharp_namespace".into()),
                                number: Some(37),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("csharpNamespace".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("swift_prefix".into()),
                                number: Some(39),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("swiftPrefix".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("php_class_prefix".into()),
                                number: Some(40),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("phpClassPrefix".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("php_namespace".into()),
                                number: Some(41),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("phpNamespace".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("php_metadata_namespace".into()),
                                number: Some(44),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("phpMetadataNamespace".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("ruby_package".into()),
                                number: Some(45),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("rubyPackage".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("uninterpreted_option".into()),
                                number: Some(999),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.UninterpretedOption".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("uninterpretedOption".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![EnumDescriptorProto {
                            name: Some("OptimizeMode".into()),
                            value: vec![
                                EnumValueDescriptorProto {
                                    name: Some("SPEED".into()),
                                    number: Some(1),
                                    options: None,
                                },
                                EnumValueDescriptorProto {
                                    name: Some("CODE_SIZE".into()),
                                    number: Some(2),
                                    options: None,
                                },
                                EnumValueDescriptorProto {
                                    name: Some("LITE_RUNTIME".into()),
                                    number: Some(3),
                                    options: None,
                                },
                            ],
                            options: None,
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![ReservedRange {
                            start: Some(38),
                            end: Some(39),
                        }],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("MessageOptions".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("message_set_wire_format".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("messageSetWireFormat".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("no_standard_descriptor_accessor".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("noStandardDescriptorAccessor".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("deprecated".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("deprecated".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("map_entry".into()),
                                number: Some(7),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("mapEntry".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("uninterpreted_option".into()),
                                number: Some(999),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.UninterpretedOption".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("uninterpretedOption".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![
                            ReservedRange {
                                start: Some(4),
                                end: Some(5),
                            },
                            ReservedRange {
                                start: Some(5),
                                end: Some(6),
                            },
                            ReservedRange {
                                start: Some(6),
                                end: Some(7),
                            },
                            ReservedRange {
                                start: Some(8),
                                end: Some(9),
                            },
                            ReservedRange {
                                start: Some(9),
                                end: Some(10),
                            },
                        ],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("FieldOptions".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("ctype".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.FieldOptions.CType".into()),
                                extendee: None,
                                default_value: Some("STRING".into()),
                                oneof_index: None,
                                json_name: Some("ctype".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("packed".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("packed".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("jstype".into()),
                                number: Some(6),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.FieldOptions.JSType".into()),
                                extendee: None,
                                default_value: Some("JS_NORMAL".into()),
                                oneof_index: None,
                                json_name: Some("jstype".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("lazy".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("lazy".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("unverified_lazy".into()),
                                number: Some(15),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("unverifiedLazy".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("deprecated".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("deprecated".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("weak".into()),
                                number: Some(10),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("weak".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("uninterpreted_option".into()),
                                number: Some(999),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.UninterpretedOption".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("uninterpretedOption".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![
                            EnumDescriptorProto {
                                name: Some("CType".into()),
                                value: vec![
                                    EnumValueDescriptorProto {
                                        name: Some("STRING".into()),
                                        number: Some(0),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("CORD".into()),
                                        number: Some(1),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("STRING_PIECE".into()),
                                        number: Some(2),
                                        options: None,
                                    },
                                ],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            },
                            EnumDescriptorProto {
                                name: Some("JSType".into()),
                                value: vec![
                                    EnumValueDescriptorProto {
                                        name: Some("JS_NORMAL".into()),
                                        number: Some(0),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("JS_STRING".into()),
                                        number: Some(1),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("JS_NUMBER".into()),
                                        number: Some(2),
                                        options: None,
                                    },
                                ],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            },
                        ],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![ReservedRange {
                            start: Some(4),
                            end: Some(5),
                        }],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("OneofOptions".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("uninterpreted_option".into()),
                            number: Some(999),
                            label: Some(Repeated.into()),
                            r#type: Some(Message.into()),
                            type_name: Some(".google.protobuf.UninterpretedOption".into()),
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("uninterpretedOption".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("EnumOptions".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("allow_alias".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("allowAlias".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("deprecated".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("deprecated".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("uninterpreted_option".into()),
                                number: Some(999),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.UninterpretedOption".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("uninterpretedOption".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![ReservedRange {
                            start: Some(5),
                            end: Some(6),
                        }],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("EnumValueOptions".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("deprecated".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("deprecated".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("uninterpreted_option".into()),
                                number: Some(999),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.UninterpretedOption".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("uninterpretedOption".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("ServiceOptions".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("deprecated".into()),
                                number: Some(33),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("deprecated".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("uninterpreted_option".into()),
                                number: Some(999),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.UninterpretedOption".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("uninterpretedOption".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("MethodOptions".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("deprecated".into()),
                                number: Some(33),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: Some("false".into()),
                                oneof_index: None,
                                json_name: Some("deprecated".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("idempotency_level".into()),
                                number: Some(34),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(
                                    ".google.protobuf.MethodOptions.IdempotencyLevel".into(),
                                ),
                                extendee: None,
                                default_value: Some("IDEMPOTENCY_UNKNOWN".into()),
                                oneof_index: None,
                                json_name: Some("idempotencyLevel".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("uninterpreted_option".into()),
                                number: Some(999),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.UninterpretedOption".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("uninterpretedOption".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![EnumDescriptorProto {
                            name: Some("IdempotencyLevel".into()),
                            value: vec![
                                EnumValueDescriptorProto {
                                    name: Some("IDEMPOTENCY_UNKNOWN".into()),
                                    number: Some(0),
                                    options: None,
                                },
                                EnumValueDescriptorProto {
                                    name: Some("NO_SIDE_EFFECTS".into()),
                                    number: Some(1),
                                    options: None,
                                },
                                EnumValueDescriptorProto {
                                    name: Some("IDEMPOTENT".into()),
                                    number: Some(2),
                                    options: None,
                                },
                            ],
                            options: None,
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        extension_range: vec![ExtensionRange {
                            start: Some(1000),
                            end: Some(536870912),
                            options: None,
                        }],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("UninterpretedOption".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("name".into()),
                                number: Some(2),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(
                                    ".google.protobuf.UninterpretedOption.NamePart".into(),
                                ),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("name".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("identifier_value".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("identifierValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("positive_int_value".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(Uint64.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("positiveIntValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("negative_int_value".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Int64.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("negativeIntValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("double_value".into()),
                                number: Some(6),
                                label: Some(Optional.into()),
                                r#type: Some(Double.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("doubleValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("string_value".into()),
                                number: Some(7),
                                label: Some(Optional.into()),
                                r#type: Some(Bytes.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("stringValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("aggregate_value".into()),
                                number: Some(8),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("aggregateValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![DescriptorProto {
                            name: Some("NamePart".into()),
                            field: vec![
                                FieldDescriptorProto {
                                    name: Some("name_part".into()),
                                    number: Some(1),
                                    label: Some(Required.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("namePart".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("is_extension".into()),
                                    number: Some(2),
                                    label: Some(Required.into()),
                                    r#type: Some(Bool.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("isExtension".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                            ],
                            extension: vec![],
                            nested_type: vec![],
                            enum_type: vec![],
                            extension_range: vec![],
                            oneof_decl: vec![],
                            options: None,
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("SourceCodeInfo".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("location".into()),
                            number: Some(1),
                            label: Some(Repeated.into()),
                            r#type: Some(Message.into()),
                            type_name: Some(".google.protobuf.SourceCodeInfo.Location".into()),
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("location".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![DescriptorProto {
                            name: Some("Location".into()),
                            field: vec![
                                FieldDescriptorProto {
                                    name: Some("path".into()),
                                    number: Some(1),
                                    label: Some(Repeated.into()),
                                    r#type: Some(Int32.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("path".into()),
                                    options: Some(Options::from_prost(FieldOptions {
                                        ctype: None,
                                        packed: Some(true),
                                        jstype: None,
                                        lazy: None,
                                        deprecated: None,
                                        weak: None,
                                        uninterpreted_option: vec![],
                                    })),
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("span".into()),
                                    number: Some(2),
                                    label: Some(Repeated.into()),
                                    r#type: Some(Int32.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("span".into()),
                                    options: Some(Options::from_prost(FieldOptions {
                                        ctype: None,
                                        packed: Some(true),
                                        jstype: None,
                                        lazy: None,
                                        deprecated: None,
                                        weak: None,
                                        uninterpreted_option: vec![],
                                    })),
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("leading_comments".into()),
                                    number: Some(3),
                                    label: Some(Optional.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("leadingComments".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("trailing_comments".into()),
                                    number: Some(4),
                                    label: Some(Optional.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("trailingComments".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("leading_detached_comments".into()),
                                    number: Some(6),
                                    label: Some(Repeated.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("leadingDetachedComments".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                            ],
                            extension: vec![],
                            nested_type: vec![],
                            enum_type: vec![],
                            extension_range: vec![],
                            oneof_decl: vec![],
                            options: None,
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("GeneratedCodeInfo".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("annotation".into()),
                            number: Some(1),
                            label: Some(Repeated.into()),
                            r#type: Some(Message.into()),
                            type_name: Some(".google.protobuf.GeneratedCodeInfo.Annotation".into()),
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("annotation".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![DescriptorProto {
                            name: Some("Annotation".into()),
                            field: vec![
                                FieldDescriptorProto {
                                    name: Some("path".into()),
                                    number: Some(1),
                                    label: Some(Repeated.into()),
                                    r#type: Some(Int32.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("path".into()),
                                    options: Some(Options::from_prost(FieldOptions {
                                        ctype: None,
                                        packed: Some(true),
                                        jstype: None,
                                        lazy: None,
                                        deprecated: None,
                                        weak: None,
                                        uninterpreted_option: vec![],
                                    })),
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("source_file".into()),
                                    number: Some(2),
                                    label: Some(Optional.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("sourceFile".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("begin".into()),
                                    number: Some(3),
                                    label: Some(Optional.into()),
                                    r#type: Some(Int32.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("begin".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("end".into()),
                                    number: Some(4),
                                    label: Some(Optional.into()),
                                    r#type: Some(Int32.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("end".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("semantic".into()),
                                    number: Some(5),
                                    label: Some(Optional.into()),
                                    r#type: Some(Enum.into()),
                                    type_name: Some(
                                        ".google.protobuf.GeneratedCodeInfo.Annotation.Semantic"
                                            .into(),
                                    ),
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("semantic".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                            ],
                            extension: vec![],
                            nested_type: vec![],
                            enum_type: vec![EnumDescriptorProto {
                                name: Some("Semantic".into()),
                                value: vec![
                                    EnumValueDescriptorProto {
                                        name: Some("NONE".into()),
                                        number: Some(0),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("SET".into()),
                                        number: Some(1),
                                        options: None,
                                    },
                                    EnumValueDescriptorProto {
                                        name: Some("ALIAS".into()),
                                        number: Some(2),
                                        options: None,
                                    },
                                ],
                                options: None,
                                reserved_range: vec![],
                                reserved_name: vec![],
                            }],
                            extension_range: vec![],
                            oneof_decl: vec![],
                            options: None,
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                ],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("DescriptorProtos".into()),
                    java_multiple_files: None,
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: Some(Speed.into()),
                    go_package: Some("google.golang.org/protobuf/types/descriptorpb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: Some(true),
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.Reflection".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: None,
            },
            FileDescriptorProto {
                name: Some("google/protobuf/duration.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![DescriptorProto {
                    name: Some("Duration".into()),
                    field: vec![
                        FieldDescriptorProto {
                            name: Some("seconds".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Int64.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("seconds".into()),
                            options: None,
                            proto3_optional: None,
                        },
                        FieldDescriptorProto {
                            name: Some("nanos".into()),
                            number: Some(2),
                            label: Some(Optional.into()),
                            r#type: Some(Int32.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("nanos".into()),
                            options: None,
                            proto3_optional: None,
                        },
                    ],
                    extension: vec![],
                    nested_type: vec![],
                    enum_type: vec![],
                    extension_range: vec![],
                    oneof_decl: vec![],
                    options: None,
                    reserved_range: vec![],
                    reserved_name: vec![],
                }],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("DurationProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/durationpb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: Some(true),
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/empty.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![DescriptorProto {
                    name: Some("Empty".into()),
                    field: vec![],
                    extension: vec![],
                    nested_type: vec![],
                    enum_type: vec![],
                    extension_range: vec![],
                    oneof_decl: vec![],
                    options: None,
                    reserved_range: vec![],
                    reserved_name: vec![],
                }],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("EmptyProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/emptypb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: Some(true),
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/field_mask.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![DescriptorProto {
                    name: Some("FieldMask".into()),
                    field: vec![FieldDescriptorProto {
                        name: Some("paths".into()),
                        number: Some(1),
                        label: Some(Repeated.into()),
                        r#type: Some(String.into()),
                        type_name: None,
                        extendee: None,
                        default_value: None,
                        oneof_index: None,
                        json_name: Some("paths".into()),
                        options: None,
                        proto3_optional: None,
                    }],
                    extension: vec![],
                    nested_type: vec![],
                    enum_type: vec![],
                    extension_range: vec![],
                    oneof_decl: vec![],
                    options: None,
                    reserved_range: vec![],
                    reserved_name: vec![],
                }],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("FieldMaskProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/fieldmaskpb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: Some(true),
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/struct.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![
                    DescriptorProto {
                        name: Some("Struct".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("fields".into()),
                            number: Some(1),
                            label: Some(Repeated.into()),
                            r#type: Some(Message.into()),
                            type_name: Some(".google.protobuf.Struct.FieldsEntry".into()),
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("fields".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![DescriptorProto {
                            name: Some("FieldsEntry".into()),
                            field: vec![
                                FieldDescriptorProto {
                                    name: Some("key".into()),
                                    number: Some(1),
                                    label: Some(Optional.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("key".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("value".into()),
                                    number: Some(2),
                                    label: Some(Optional.into()),
                                    r#type: Some(Message.into()),
                                    type_name: Some(".google.protobuf.Value".into()),
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("value".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                            ],
                            extension: vec![],
                            nested_type: vec![],
                            enum_type: vec![],
                            extension_range: vec![],
                            oneof_decl: vec![],
                            options: Some(Options::from_prost(MessageOptions {
                                message_set_wire_format: None,
                                no_standard_descriptor_accessor: None,
                                deprecated: None,
                                map_entry: Some(true),
                                uninterpreted_option: vec![],
                            })),
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("Value".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("null_value".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(Enum.into()),
                                type_name: Some(".google.protobuf.NullValue".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: Some(0),
                                json_name: Some("nullValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("number_value".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Double.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: Some(0),
                                json_name: Some("numberValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("string_value".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: Some(0),
                                json_name: Some("stringValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("bool_value".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(Bool.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: Some(0),
                                json_name: Some("boolValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("struct_value".into()),
                                number: Some(5),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.Struct".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: Some(0),
                                json_name: Some("structValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("list_value".into()),
                                number: Some(6),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.ListValue".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: Some(0),
                                json_name: Some("listValue".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![OneofDescriptorProto {
                            name: Some("kind".into()),
                            options: None,
                        }],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("ListValue".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("values".into()),
                            number: Some(1),
                            label: Some(Repeated.into()),
                            r#type: Some(Message.into()),
                            type_name: Some(".google.protobuf.Value".into()),
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("values".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                ],
                enum_type: vec![EnumDescriptorProto {
                    name: Some("NullValue".into()),
                    value: vec![EnumValueDescriptorProto {
                        name: Some("NULL_VALUE".into()),
                        number: Some(0),
                        options: None,
                    }],
                    options: None,
                    reserved_range: vec![],
                    reserved_name: vec![],
                }],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("StructProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/structpb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: Some(true),
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/timestamp.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![DescriptorProto {
                    name: Some("Timestamp".into()),
                    field: vec![
                        FieldDescriptorProto {
                            name: Some("seconds".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Int64.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("seconds".into()),
                            options: None,
                            proto3_optional: None,
                        },
                        FieldDescriptorProto {
                            name: Some("nanos".into()),
                            number: Some(2),
                            label: Some(Optional.into()),
                            r#type: Some(Int32.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("nanos".into()),
                            options: None,
                            proto3_optional: None,
                        },
                    ],
                    extension: vec![],
                    nested_type: vec![],
                    enum_type: vec![],
                    extension_range: vec![],
                    oneof_decl: vec![],
                    options: None,
                    reserved_range: vec![],
                    reserved_name: vec![],
                }],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("TimestampProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/timestamppb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: Some(true),
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/wrappers.proto".into()),
                package: Some("google.protobuf".into()),
                dependency: vec![],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![
                    DescriptorProto {
                        name: Some("DoubleValue".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Double.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("FloatValue".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Float.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("Int64Value".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Int64.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("UInt64Value".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Uint64.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("Int32Value".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Int32.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("UInt32Value".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Uint32.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("BoolValue".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Bool.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("StringValue".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(String.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("BytesValue".into()),
                        field: vec![FieldDescriptorProto {
                            name: Some("value".into()),
                            number: Some(1),
                            label: Some(Optional.into()),
                            r#type: Some(Bytes.into()),
                            type_name: None,
                            extendee: None,
                            default_value: None,
                            oneof_index: None,
                            json_name: Some("value".into()),
                            options: None,
                            proto3_optional: None,
                        }],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                ],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf".into()),
                    java_outer_classname: Some("WrappersProto".into()),
                    java_multiple_files: Some(true),
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/known/wrapperspb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: Some(true),
                    objc_class_prefix: Some("GPB".into()),
                    csharp_namespace: Some("Google.Protobuf.WellKnownTypes".into()),
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: Some("proto3".into()),
            },
            FileDescriptorProto {
                name: Some("google/protobuf/compiler/plugin.proto".into()),
                package: Some("google.protobuf.compiler".into()),
                dependency: vec!["google/protobuf/descriptor.proto".into()],
                public_dependency: vec![],
                weak_dependency: vec![],
                message_type: vec![
                    DescriptorProto {
                        name: Some("Version".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("major".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("major".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("minor".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("minor".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("patch".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Int32.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("patch".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("suffix".into()),
                                number: Some(4),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("suffix".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("CodeGeneratorRequest".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("file_to_generate".into()),
                                number: Some(1),
                                label: Some(Repeated.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("fileToGenerate".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("parameter".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("parameter".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("proto_file".into()),
                                number: Some(15),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.FileDescriptorProto".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("protoFile".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("compiler_version".into()),
                                number: Some(3),
                                label: Some(Optional.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(".google.protobuf.compiler.Version".into()),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("compilerVersion".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![],
                        enum_type: vec![],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                    DescriptorProto {
                        name: Some("CodeGeneratorResponse".into()),
                        field: vec![
                            FieldDescriptorProto {
                                name: Some("error".into()),
                                number: Some(1),
                                label: Some(Optional.into()),
                                r#type: Some(String.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("error".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("supported_features".into()),
                                number: Some(2),
                                label: Some(Optional.into()),
                                r#type: Some(Uint64.into()),
                                type_name: None,
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("supportedFeatures".into()),
                                options: None,
                                proto3_optional: None,
                            },
                            FieldDescriptorProto {
                                name: Some("file".into()),
                                number: Some(15),
                                label: Some(Repeated.into()),
                                r#type: Some(Message.into()),
                                type_name: Some(
                                    ".google.protobuf.compiler.CodeGeneratorResponse.File".into(),
                                ),
                                extendee: None,
                                default_value: None,
                                oneof_index: None,
                                json_name: Some("file".into()),
                                options: None,
                                proto3_optional: None,
                            },
                        ],
                        extension: vec![],
                        nested_type: vec![DescriptorProto {
                            name: Some("File".into()),
                            field: vec![
                                FieldDescriptorProto {
                                    name: Some("name".into()),
                                    number: Some(1),
                                    label: Some(Optional.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("name".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("insertion_point".into()),
                                    number: Some(2),
                                    label: Some(Optional.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("insertionPoint".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("content".into()),
                                    number: Some(15),
                                    label: Some(Optional.into()),
                                    r#type: Some(String.into()),
                                    type_name: None,
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("content".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                                FieldDescriptorProto {
                                    name: Some("generated_code_info".into()),
                                    number: Some(16),
                                    label: Some(Optional.into()),
                                    r#type: Some(Message.into()),
                                    type_name: Some(".google.protobuf.GeneratedCodeInfo".into()),
                                    extendee: None,
                                    default_value: None,
                                    oneof_index: None,
                                    json_name: Some("generatedCodeInfo".into()),
                                    options: None,
                                    proto3_optional: None,
                                },
                            ],
                            extension: vec![],
                            nested_type: vec![],
                            enum_type: vec![],
                            extension_range: vec![],
                            oneof_decl: vec![],
                            options: None,
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        enum_type: vec![EnumDescriptorProto {
                            name: Some("Feature".into()),
                            value: vec![
                                EnumValueDescriptorProto {
                                    name: Some("FEATURE_NONE".into()),
                                    number: Some(0),
                                    options: None,
                                },
                                EnumValueDescriptorProto {
                                    name: Some("FEATURE_PROTO3_OPTIONAL".into()),
                                    number: Some(1),
                                    options: None,
                                },
                            ],
                            options: None,
                            reserved_range: vec![],
                            reserved_name: vec![],
                        }],
                        extension_range: vec![],
                        oneof_decl: vec![],
                        options: None,
                        reserved_range: vec![],
                        reserved_name: vec![],
                    },
                ],
                enum_type: vec![],
                service: vec![],
                extension: vec![],
                options: Some(Options::from_prost(FileOptions {
                    java_package: Some("com.google.protobuf.compiler".into()),
                    java_outer_classname: Some("PluginProtos".into()),
                    java_multiple_files: None,
                    java_generate_equals_and_hash: None,
                    java_string_check_utf8: None,
                    optimize_for: None,
                    go_package: Some("google.golang.org/protobuf/types/pluginpb".into()),
                    cc_generic_services: None,
                    java_generic_services: None,
                    py_generic_services: None,
                    php_generic_services: None,
                    deprecated: None,
                    cc_enable_arenas: None,
                    objc_class_prefix: None,
                    csharp_namespace: None,
                    swift_prefix: None,
                    php_class_prefix: None,
                    php_namespace: None,
                    php_metadata_namespace: None,
                    ruby_package: None,
                    uninterpreted_option: vec![],
                })),
                source_code_info: None,
                syntax: None,
            },
        ],
    }
}

pub fn make_wkt_descriptor_pool() -> Result<DescriptorPool, DescriptorError> {
    let file_descriptor_set = make_descriptor();
    let mut pool = DescriptorPool::new();
    pool.build_files(file_descriptor_set.file.into_iter())?;
    Ok(pool)
}

macro_rules! impl_reflect_message {
    ($($ty:ty => $name:literal;)*) => {
        $(
            impl ReflectMessage for $ty {
                #[doc = concat!("Returns a descriptor for the `", $name, "` message type.")]
                fn descriptor(&self) -> MessageDescriptor {
                    match DescriptorPool::global().get_message_by_name($name) {
                        Some(desc) => desc,
                        None => panic!("descriptor for well-known type `{}` not found", $name),
                    }
                }
            }
        )*

        #[test]
        fn test_reflect_message_impls() {
            $(
                assert_eq!(<$ty>::default().descriptor().full_name(), $name);
            )*
        }
    };
}

impl_reflect_message! {
    () => "google.protobuf.Empty";
    bool => "google.protobuf.BoolValue";
    f32 => "google.protobuf.FloatValue";
    f64 => "google.protobuf.DoubleValue";
    i32 => "google.protobuf.Int32Value";
    i64 => "google.protobuf.Int64Value";
    std::string::String => "google.protobuf.StringValue";
    u32 => "google.protobuf.UInt32Value";
    u64 => "google.protobuf.UInt64Value";
    Vec<u8> => "google.protobuf.BytesValue";
    prost_types::Any => "google.protobuf.Any";
    prost_types::Api => "google.protobuf.Api";
    prost_types::compiler::CodeGeneratorRequest => "google.protobuf.compiler.CodeGeneratorRequest";
    prost_types::compiler::CodeGeneratorResponse => "google.protobuf.compiler.CodeGeneratorResponse";
    prost_types::compiler::code_generator_response::File => "google.protobuf.compiler.CodeGeneratorResponse.File";
    prost_types::compiler::Version => "google.protobuf.compiler.Version";
    prost_types::DescriptorProto => "google.protobuf.DescriptorProto";
    prost_types::descriptor_proto::ExtensionRange => "google.protobuf.DescriptorProto.ExtensionRange";
    prost_types::descriptor_proto::ReservedRange => "google.protobuf.DescriptorProto.ReservedRange";
    prost_types::Duration => "google.protobuf.Duration";
    prost_types::Enum => "google.protobuf.Enum";
    prost_types::EnumDescriptorProto => "google.protobuf.EnumDescriptorProto";
    prost_types::enum_descriptor_proto::EnumReservedRange => "google.protobuf.EnumDescriptorProto.EnumReservedRange";
    prost_types::EnumOptions => "google.protobuf.EnumOptions";
    prost_types::EnumValue => "google.protobuf.EnumValue";
    prost_types::EnumValueDescriptorProto => "google.protobuf.EnumValueDescriptorProto";
    prost_types::EnumValueOptions => "google.protobuf.EnumValueOptions";
    prost_types::ExtensionRangeOptions => "google.protobuf.ExtensionRangeOptions";
    prost_types::Field => "google.protobuf.Field";
    prost_types::FieldDescriptorProto => "google.protobuf.FieldDescriptorProto";
    prost_types::FieldMask => "google.protobuf.FieldMask";
    prost_types::FieldOptions => "google.protobuf.FieldOptions";
    prost_types::FileDescriptorProto => "google.protobuf.FileDescriptorProto";
    prost_types::FileDescriptorSet => "google.protobuf.FileDescriptorSet";
    prost_types::FileOptions => "google.protobuf.FileOptions";
    prost_types::GeneratedCodeInfo => "google.protobuf.GeneratedCodeInfo";
    prost_types::generated_code_info::Annotation => "google.protobuf.GeneratedCodeInfo.Annotation";
    prost_types::ListValue => "google.protobuf.ListValue";
    prost_types::MessageOptions => "google.protobuf.MessageOptions";
    prost_types::Method => "google.protobuf.Method";
    prost_types::MethodDescriptorProto => "google.protobuf.MethodDescriptorProto";
    prost_types::MethodOptions => "google.protobuf.MethodOptions";
    prost_types::Mixin => "google.protobuf.Mixin";
    prost_types::OneofDescriptorProto => "google.protobuf.OneofDescriptorProto";
    prost_types::OneofOptions => "google.protobuf.OneofOptions";
    prost_types::Option => "google.protobuf.Option";
    prost_types::ServiceDescriptorProto => "google.protobuf.ServiceDescriptorProto";
    prost_types::ServiceOptions => "google.protobuf.ServiceOptions";
    prost_types::SourceCodeInfo => "google.protobuf.SourceCodeInfo";
    prost_types::source_code_info::Location => "google.protobuf.SourceCodeInfo.Location";
    prost_types::SourceContext => "google.protobuf.SourceContext";
    prost_types::Struct => "google.protobuf.Struct";
    prost_types::Timestamp => "google.protobuf.Timestamp";
    prost_types::Type => "google.protobuf.Type";
    prost_types::UninterpretedOption => "google.protobuf.UninterpretedOption";
    prost_types::uninterpreted_option::NamePart => "google.protobuf.UninterpretedOption.NamePart";
    prost_types::Value => "google.protobuf.Value";
    prost::bytes::Bytes => "google.protobuf.BytesValue";
}
