// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{Layer, Location, Viewport};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "ShumatePathLayer")]
    pub struct PathLayer(Object<ffi::ShumatePathLayer, ffi::ShumatePathLayerClass>) @extends Layer, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::shumate_path_layer_get_type(),
    }
}

impl PathLayer {
    #[doc(alias = "shumate_path_layer_new")]
    pub fn new(viewport: &Viewport) -> PathLayer {
        skip_assert_initialized!();
        unsafe { from_glib_none(ffi::shumate_path_layer_new(viewport.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`PathLayer`] objects.
    ///
    /// This method returns an instance of [`PathLayerBuilder`](crate::builders::PathLayerBuilder) which can be used to create [`PathLayer`] objects.
    pub fn builder() -> PathLayerBuilder {
        PathLayerBuilder::new()
    }

    #[doc(alias = "shumate_path_layer_add_node")]
    pub fn add_node(&self, location: &impl IsA<Location>) {
        unsafe {
            ffi::shumate_path_layer_add_node(
                self.to_glib_none().0,
                location.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_path_layer_get_closed")]
    #[doc(alias = "get_closed")]
    pub fn is_closed(&self) -> bool {
        unsafe { from_glib(ffi::shumate_path_layer_get_closed(self.to_glib_none().0)) }
    }

    //#[doc(alias = "shumate_path_layer_get_dash")]
    //#[doc(alias = "get_dash")]
    //pub fn dash(&self) -> /*Unimplemented*/Option<List TypeId { ns_id: 0, id: 15 }> {
    //    unsafe { TODO: call ffi:shumate_path_layer_get_dash() }
    //}

    #[doc(alias = "shumate_path_layer_get_fill")]
    #[doc(alias = "get_fill")]
    pub fn fills(&self) -> bool {
        unsafe { from_glib(ffi::shumate_path_layer_get_fill(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_path_layer_get_fill_color")]
    #[doc(alias = "get_fill_color")]
    pub fn fill_color(&self) -> Option<gdk::RGBA> {
        unsafe {
            from_glib_full(ffi::shumate_path_layer_get_fill_color(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_path_layer_get_nodes")]
    #[doc(alias = "get_nodes")]
    pub fn nodes(&self) -> Vec<Location> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::shumate_path_layer_get_nodes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_path_layer_get_outline_color")]
    #[doc(alias = "get_outline_color")]
    pub fn outline_color(&self) -> Option<gdk::RGBA> {
        unsafe {
            from_glib_full(ffi::shumate_path_layer_get_outline_color(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_path_layer_get_outline_width")]
    #[doc(alias = "get_outline_width")]
    pub fn outline_width(&self) -> f64 {
        unsafe { ffi::shumate_path_layer_get_outline_width(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_path_layer_get_stroke")]
    #[doc(alias = "get_stroke")]
    pub fn is_stroke(&self) -> bool {
        unsafe { from_glib(ffi::shumate_path_layer_get_stroke(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_path_layer_get_stroke_color")]
    #[doc(alias = "get_stroke_color")]
    pub fn stroke_color(&self) -> Option<gdk::RGBA> {
        unsafe {
            from_glib_full(ffi::shumate_path_layer_get_stroke_color(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_path_layer_get_stroke_width")]
    #[doc(alias = "get_stroke_width")]
    pub fn stroke_width(&self) -> f64 {
        unsafe { ffi::shumate_path_layer_get_stroke_width(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_path_layer_insert_node")]
    pub fn insert_node(&self, location: &impl IsA<Location>, position: u32) {
        unsafe {
            ffi::shumate_path_layer_insert_node(
                self.to_glib_none().0,
                location.as_ref().to_glib_none().0,
                position,
            );
        }
    }

    #[doc(alias = "shumate_path_layer_remove_all")]
    pub fn remove_all(&self) {
        unsafe {
            ffi::shumate_path_layer_remove_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_path_layer_remove_node")]
    pub fn remove_node(&self, location: &impl IsA<Location>) {
        unsafe {
            ffi::shumate_path_layer_remove_node(
                self.to_glib_none().0,
                location.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_path_layer_set_closed")]
    pub fn set_closed(&self, value: bool) {
        unsafe {
            ffi::shumate_path_layer_set_closed(self.to_glib_none().0, value.into_glib());
        }
    }

    //#[doc(alias = "shumate_path_layer_set_dash")]
    //pub fn set_dash(&self, dash_pattern: /*Unimplemented*/&List TypeId { ns_id: 0, id: 15 }) {
    //    unsafe { TODO: call ffi:shumate_path_layer_set_dash() }
    //}

    #[doc(alias = "shumate_path_layer_set_fill")]
    pub fn set_fill(&self, value: bool) {
        unsafe {
            ffi::shumate_path_layer_set_fill(self.to_glib_none().0, value.into_glib());
        }
    }

    #[doc(alias = "shumate_path_layer_set_fill_color")]
    pub fn set_fill_color(&self, color: Option<&gdk::RGBA>) {
        unsafe {
            ffi::shumate_path_layer_set_fill_color(self.to_glib_none().0, color.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_path_layer_set_outline_color")]
    pub fn set_outline_color(&self, color: Option<&gdk::RGBA>) {
        unsafe {
            ffi::shumate_path_layer_set_outline_color(
                self.to_glib_none().0,
                color.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_path_layer_set_outline_width")]
    pub fn set_outline_width(&self, value: f64) {
        unsafe {
            ffi::shumate_path_layer_set_outline_width(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "shumate_path_layer_set_stroke")]
    pub fn set_stroke(&self, value: bool) {
        unsafe {
            ffi::shumate_path_layer_set_stroke(self.to_glib_none().0, value.into_glib());
        }
    }

    #[doc(alias = "shumate_path_layer_set_stroke_color")]
    pub fn set_stroke_color(&self, color: Option<&gdk::RGBA>) {
        unsafe {
            ffi::shumate_path_layer_set_stroke_color(self.to_glib_none().0, color.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_path_layer_set_stroke_width")]
    pub fn set_stroke_width(&self, value: f64) {
        unsafe {
            ffi::shumate_path_layer_set_stroke_width(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "closed")]
    pub fn connect_closed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_closed_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::closed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_closed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "fill")]
    pub fn connect_fill_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fill_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fill\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_fill_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "fill-color")]
    pub fn connect_fill_color_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fill_color_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fill-color\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_fill_color_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "outline-color")]
    pub fn connect_outline_color_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_outline_color_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::outline-color\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_outline_color_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "outline-width")]
    pub fn connect_outline_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_outline_width_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::outline-width\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_outline_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stroke")]
    pub fn connect_stroke_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stroke_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stroke\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_stroke_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stroke-color")]
    pub fn connect_stroke_color_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stroke_color_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stroke-color\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_stroke_color_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stroke-width")]
    pub fn connect_stroke_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stroke_width_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stroke-width\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_stroke_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for PathLayer {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`PathLayer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct PathLayerBuilder {
    builder: glib::object::ObjectBuilder<'static, PathLayer>,
}

impl PathLayerBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn closed(self, closed: bool) -> Self {
        Self {
            builder: self.builder.property("closed", closed),
        }
    }

    pub fn fill(self, fill: bool) -> Self {
        Self {
            builder: self.builder.property("fill", fill),
        }
    }

    pub fn fill_color(self, fill_color: &gdk::RGBA) -> Self {
        Self {
            builder: self.builder.property("fill-color", fill_color),
        }
    }

    pub fn outline_color(self, outline_color: &gdk::RGBA) -> Self {
        Self {
            builder: self.builder.property("outline-color", outline_color),
        }
    }

    pub fn outline_width(self, outline_width: f64) -> Self {
        Self {
            builder: self.builder.property("outline-width", outline_width),
        }
    }

    pub fn stroke(self, stroke: bool) -> Self {
        Self {
            builder: self.builder.property("stroke", stroke),
        }
    }

    pub fn stroke_color(self, stroke_color: &gdk::RGBA) -> Self {
        Self {
            builder: self.builder.property("stroke-color", stroke_color),
        }
    }

    pub fn stroke_width(self, stroke_width: f64) -> Self {
        Self {
            builder: self.builder.property("stroke-width", stroke_width),
        }
    }

    pub fn viewport(self, viewport: &Viewport) -> Self {
        Self {
            builder: self.builder.property("viewport", viewport.clone()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`PathLayer`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> PathLayer {
        self.builder.build()
    }
}
