/*
*  file: manager.h
*  
*
*  Copyright (C) 2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __PLUGIN_MANAGER_H
#define __PLUGIN_MANAGER_H

#include <glib.h>
#include <glib-object.h>

#include "plugin.h"


#define R_PLUGIN_MANAGER_TYPE             (r_plugin_manager_get_type())

#define R_PLUGIN_MANAGER(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj),  \
                                           R_PLUGIN_MANAGER_TYPE,             \
                                           RPluginManager))

#define R_PLUGIN_MANAGER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass),   \
                                           R_PLUGIN_MANAGER_TYPE,             \
                                           RPluginManagerClass))

#define R_IS_PLUGIN_MANAGER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj),  \
                                           R_PLUGIN_MANAGER_TYPE))

#define R_IS_PLUGIN_MANAGER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE((klass),   \
                                           R_PLUGIN_MANAGER_TYPE))

#define R_PLUGIN_MANAGER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS((obj),   \
				           R_PLUGIN_MANAGER_TYPE,             \
                                           RPluginManagerClass))


typedef struct _RPluginManager          RPluginManager;
typedef struct _RPluginManagerClass     RPluginManagerClass;
typedef struct _RPluginManagerPrivate   RPluginManagerPrivate;


struct _RPluginManager 
{
  GObject parent;

  RPluginManagerPrivate* priv; 
};


struct _RPluginManagerClass
{
  GObjectClass parent;
};


GType           r_plugin_manager_get_type        (void);


RPluginManager* r_plugin_manager_new             (void);
void            r_plugin_manager_free            (RPluginManager* manager);

void            r_plugin_manager_scan_directory  (RPluginManager* manager, 
						  gchar* dir);
gboolean        r_manager_load_plugin            (RPlugin* plugin, 
						  gchar* file);

gint            r_plugin_manager_how_many        (RPluginManager* manager);
RPlugin*        r_plugin_manager_get_plugin      (RPluginManager* manager, 
						  const gchar* name);
RPlugin*        r_plugin_manager_get_nth_plugin  (RPluginManager* manager, 
						  gint n);
GList*          r_plugin_manager_get_all_filters (RPluginManager* manager);


#endif
