% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed.R
\name{with_seed}
\alias{with_seed}
\alias{local_seed}
\alias{with_preserve_seed}
\alias{local_preserve_seed}
\title{Random seed}
\usage{
with_seed(
  seed,
  code,
  .rng_kind = NULL,
  .rng_normal_kind = NULL,
  .rng_sample_kind = NULL
)

local_seed(
  seed,
  .local_envir = parent.frame(),
  .rng_kind = NULL,
  .rng_normal_kind = NULL,
  .rng_sample_kind = NULL
)

with_preserve_seed(code)

local_preserve_seed(.local_envir = parent.frame())
}
\arguments{
\item{seed}{\verb{[integer(1)]}\cr The random seed to use to evaluate the code.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.rng_kind, .rng_normal_kind, .rng_sample_kind}{\verb{[character(1)]}\cr Kind of RNG to use. Passed as the \code{kind},
\code{normal.kind}, and \code{sample.kind} arguments of \code{\link[=RNGkind]{RNGkind()}}.}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
\code{with_seed()} runs code with a specific random seed and resets it afterwards.

\code{with_preserve_seed()} runs code with the current random seed and resets it
afterwards.
}
\examples{
# Same random values:
with_preserve_seed(runif(5))
with_preserve_seed(runif(5))

# Use a pseudorandom value as seed to advance the RNG and pick a different
# value for the next call:
with_seed(seed <- sample.int(.Machine$integer.max, 1L), runif(5))
with_seed(seed, runif(5))
with_seed(seed <- sample.int(.Machine$integer.max, 1L), runif(5))
}
\seealso{
\code{\link{withr}} for examples
}
