% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{st_intersects.stars}
\alias{st_intersects.stars}
\title{spatial intersect predicate for stars and sfc object}
\usage{
\method{st_intersects}{stars}(x, y, sparse = TRUE, ..., as_points = NA,
  transpose = FALSE)
}
\arguments{
\item{x}{object of class stars}

\item{y}{object that has an `st_geometry` method: of class `sf` or `sfc`, or `stars` object with an `sfc` dimension}

\item{sparse}{logical; if TRUE, return the a sparse logical matrix (object of class `sgbp`), if FALSE, return a logical matrix}

\item{...}{ignored, or passed on to `st_intersects.sf` for curvilinear grids}

\item{as_points}{logical, should grid cells be considered as points (TRUE) or polygons (FALSE)? Default: FALSE and warning emitted}

\item{transpose}{logical; should the transpose of the `sgbp` object be returned?}
}
\value{
`sgbp` object if sparse = TRUE, logical matrix otherwise
}
\description{
spatial intersect predicate for stars and sfc object
}
\details{
curvilinear grids are always converted to polygons, so points on grid boundaries may intersect with two cells touched; for other grids each cell boundary or corner belongs only to one cell.
}
