% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rows.R
\name{rows_insert.tbl_lazy}
\alias{rows_insert.tbl_lazy}
\alias{rows_append.tbl_lazy}
\alias{rows_update.tbl_lazy}
\alias{rows_patch.tbl_lazy}
\alias{rows_upsert.tbl_lazy}
\alias{rows_delete.tbl_lazy}
\title{Edit individual rows in the underlying database table}
\usage{
\method{rows_insert}{tbl_lazy}(
  x,
  y,
  by = NULL,
  ...,
  conflict = c("error", "ignore"),
  copy = FALSE,
  in_place = FALSE,
  returning = NULL,
  method = NULL
)

\method{rows_append}{tbl_lazy}(x, y, ..., copy = FALSE, in_place = FALSE, returning = NULL)

\method{rows_update}{tbl_lazy}(
  x,
  y,
  by = NULL,
  ...,
  unmatched = c("error", "ignore"),
  copy = FALSE,
  in_place = FALSE,
  returning = NULL
)

\method{rows_patch}{tbl_lazy}(
  x,
  y,
  by = NULL,
  ...,
  unmatched = c("error", "ignore"),
  copy = FALSE,
  in_place = FALSE,
  returning = NULL
)

\method{rows_upsert}{tbl_lazy}(
  x,
  y,
  by = NULL,
  ...,
  copy = FALSE,
  in_place = FALSE,
  returning = NULL,
  method = NULL
)

\method{rows_delete}{tbl_lazy}(
  x,
  y,
  by = NULL,
  ...,
  unmatched = c("error", "ignore"),
  copy = FALSE,
  in_place = FALSE,
  returning = NULL
)
}
\arguments{
\item{x}{A lazy table.
For \code{in_place = TRUE}, this must be a table instantiated with \code{\link[=tbl]{tbl()}} or
\code{\link[=compute]{compute()}}, not to a lazy query. The \code{\link[=remote_name]{remote_name()}} function is used to
determine the name of the table to be updated.}

\item{y}{A lazy table, data frame, or data frame extensions (e.g. a tibble).}

\item{by}{An unnamed character vector giving the key columns. The key columns
must exist in both \code{x} and \code{y}. Keys typically uniquely identify each row,
but this is only enforced for the key values of \code{y} when \code{rows_update()},
\code{rows_patch()}, or \code{rows_upsert()} are used.

By default, we use the first column in \code{y}, since the first column is
a reasonable place to put an identifier variable.}

\item{...}{Other parameters passed onto methods.}

\item{conflict}{For \code{rows_insert()}, how should keys in \code{y} that conflict
with keys in \code{x} be handled? A conflict arises if there is a key in \code{y}
that already exists in \code{x}.

One of:
\itemize{
\item \code{"error"}, the default, is not supported for database tables. To get the
same behaviour add a unique index on the \code{by} columns and use
\code{rows_append()}.
\item \code{"ignore"} will ignore rows in \code{y} with keys that conflict with keys in
\code{x}.
}}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{in_place}{Should \code{x} be modified in place? If \code{FALSE} will
generate a \code{SELECT} query that returns the modified table; if \code{TRUE}
will modify the underlying table using a DML operation (\code{INSERT}, \code{UPDATE},
\code{DELETE} or similar).}

\item{returning}{Columns to return. See \code{\link[=get_returned_rows]{get_returned_rows()}} for details.}

\item{method}{A string specifying the method to use. This is only relevant for
\code{in_place = TRUE}.}

\item{unmatched}{For \code{rows_update()}, \code{rows_patch()}, and \code{rows_delete()},
how should keys in \code{y} that are unmatched by the keys in \code{x} be handled?

One of:
\itemize{
\item \code{"error"}, the default, is not supported for database tables. Add a
foreign key constraint on the \code{by} columns of \code{y} to let the database
check this behaviour for you.
\item \code{"ignore"} will ignore rows in \code{y} with keys that are unmatched by the
keys in \code{x}.
}}
}
\value{
A new \code{tbl_lazy} of the modified data.
With \code{in_place = FALSE}, the result is a lazy query that prints visibly,
because the purpose of this operation is to preview the results.
With \code{in_place = TRUE}, \code{x} is returned invisibly,
because the purpose of this operation is the side effect of modifying rows
in the table behind \code{x}.
}
\description{
These are methods for the dplyr \code{\link[=rows_insert]{rows_insert()}}, \code{\link[=rows_append]{rows_append()}},
\code{\link[=rows_update]{rows_update()}}, \code{\link[=rows_patch]{rows_patch()}}, \code{\link[=rows_upsert]{rows_upsert()}}, and \code{\link[=rows_delete]{rows_delete()}}
generics.

When \code{in_place = TRUE} these verbs do not generate \code{SELECT} queries, but
instead directly modify the underlying data using \code{INSERT}, \code{UPDATE}, or
\code{DELETE} operators. This will require that you have write access to
the database: the connection needs permission to insert, modify or delete
rows, but not to alter the structure of the table.

The default, \code{in_place = FALSE}, generates equivalent lazy tables (using
\code{SELECT} queries) that allow previewing the result without actually
modifying the underlying table on the database.
}
\examples{
library(dplyr)

con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbExecute(con, "CREATE TABLE Ponies (
   id INTEGER PRIMARY KEY AUTOINCREMENT,
   name TEXT,
   cutie_mark TEXT
)")

ponies <- tbl(con, "Ponies")

applejack <- copy_inline(con, data.frame(
  name = "Apple Jack",
  cutie_mark = "three apples"
))

# The default behavior is to generate a SELECT query
rows_insert(ponies, applejack, conflict = "ignore")
# And the original table is left unchanged:
ponies

# You can also choose to modify the table with in_place = TRUE:
rows_insert(ponies, applejack, conflict = "ignore", in_place = TRUE)
# In this case `rows_insert()` returns nothing and the underlying
# data is modified
ponies
}
