% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\alias{newcache}
\alias{jamcache}
\alias{setcache}
\alias{getcache}
\alias{remcache}
\alias{print.cache}
\title{Atomic Caching}
\usage{
newcache(x)

jamcache(x)

cache(x)

setcache(x, which, value)

getcache(x, which)

remcache(x)

\method{print}{cache}(x, all.names = FALSE, pattern, ...)
}
\arguments{
\item{x}{an integer64 vector (or a cache object in case of \code{print.cache})}

\item{which}{A character naming the object to be retrieved from the cache or to be stored in the cache}

\item{value}{An object to be stored in the cache}

\item{all.names, pattern}{passed to \code{\link[=ls]{ls()}} when listing the cache content}

\item{...}{ignored}
}
\value{
See details
}
\description{
Functions for caching results attached to atomic objects
}
\details{
A \code{cache} is an \code{\link{environment}} attached to an atomic object with the
\code{\link[=attr]{attribute}} name 'cache'. It contains at least a reference to the
atomic object that carries the cache. This is used when accessing
the cache to detect whether the object carrying the cache has been
modified meanwhile.
}
\section{Functions}{
\itemize{
\item \code{newcache()}: creates a new cache referencing  \code{x}

\item \code{jamcache()}: forces \code{x} to have a cache

\item \code{cache()}: returns the cache attached to \code{x} if it is not
found to be outdated

\item \code{setcache()}: assigns a value into the cache of \code{x}

\item \code{getcache()}: gets cache value 'which' from \code{x}

\item \code{remcache()}: removes the cache from \code{x}

}}
\examples{
  x <- as.integer64(sample(c(rep(NA, 9), 1:9), 32, TRUE))
  y <- x
  still.identical(x,y)
  y[1] <- NA
  still.identical(x,y)
  mycache <- newcache(x)
  ls(mycache)
  mycache
  rm(mycache)
  jamcache(x)
  cache(x)
  x[1] <- NA
  cache(x)
  getcache(x, "abc")
  setcache(x, "abc", 1)
  getcache(x, "abc")
  remcache(x)
  cache(x)
}
\seealso{
\code{\link[bit:still.identical]{bit::still.identical()}} for testing whether to symbols point to the same RAM.

Functions that get and set small cache-content automatically when a cache is present:
\code{\link[bit:Metadata]{bit::na.count()}}, \code{\link[bit:Metadata]{bit::nvalid()}}, \code{\link[bit:Metadata]{bit::is.sorted()}}, \code{\link[bit:Metadata]{bit::nunique()}} and
\code{\link[bit:Metadata]{bit::nties()}}

Setting big caches with a relevant memory footprint requires a conscious decision
of the user: \code{\link{hashcache}}, \code{\link{sortcache}}, \code{\link{ordercache}}, \code{\link{sortordercache}}

Functions that use big caches: \code{\link[=match.integer64]{match.integer64()}}, \code{\link{\%in\%.integer64}},
\code{\link[=duplicated.integer64]{duplicated.integer64()}}, \code{\link[=unique.integer64]{unique.integer64()}}, \code{\link[=unipos]{unipos()}}, \code{\link[=table.integer64]{table.integer64()}},
\code{\link[=keypos]{keypos()}}, \code{\link[=tiepos]{tiepos()}}, \code{\link[=rank.integer64]{rank.integer64()}}, \code{\link[=prank]{prank()}}, \code{\link[=qtile]{qtile()}},
\code{\link[=quantile.integer64]{quantile.integer64()}}, \code{\link[=median.integer64]{median.integer64()}}, and \code{\link[=summary.integer64]{summary.integer64()}}
}
\keyword{environment}
