% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMethods.R
\name{getCovariates}
\alias{getCovariates}
\title{getCovariates}
\usage{
getCovariates(object, covariate)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{covariate}{names of the covariate}
}
\value{
a vector containing the covariate
}
\description{
This function extracts covariates from the \code{colData}
 in the input \code{MultiAssayExperiment} object. \cr
Note that if you did not use \code{MultiAssayExperiment} to create
 your \code{\link{createMOFAobject}}, this function will not work.
}
\examples{
# Example on the CLL data
library(MultiAssayExperiment)
data("CLL_data", package = "MOFAdata")
data("CLL_covariates", package = "MOFAdata")
# Create MultiAssayExperiment object 
mae_CLL <- MultiAssayExperiment(CLL_data, colData=CLL_covariates)
MOFAobject  <- createMOFAobject(mae_CLL)
# Extract covariates from the colData of a MultiAssayExperiment
gender <- getCovariates(MOFAobject, "Gender")
diagnosis <- getCovariates(MOFAobject, "Diagnosis")
# Example on the scMT data
data("scMT_data", package = "MOFAdata")
MOFAobject  <- createMOFAobject(scMT_data)
# Extract covariates from the colData of a MultiAssayExperiment
culture <- getCovariates(MOFAobject, "culture")
# Extract covariates from the phenoData of the RNA assay
cdr <- getCovariates(MOFAobject, "cellular_detection_rate")
}
