% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tatami-utils.R
\name{tatami-utils}
\alias{tatami-utils}
\alias{tatami.bind}
\alias{tatami.transpose}
\alias{tatami.subset}
\alias{tatami.arith}
\alias{tatami.compare}
\alias{tatami.logic}
\alias{tatami.round}
\alias{tatami.log}
\alias{tatami.math}
\alias{tatami.not}
\alias{tatami.binary}
\alias{tatami.dim}
\alias{tatami.row}
\alias{tatami.column}
\alias{tatami.row.sums}
\alias{tatami.column.sums}
\alias{tatami.is.sparse}
\alias{tatami.prefer.rows}
\alias{tatami.realize}
\alias{tatami.multiply}
\title{Tatami utilities}
\usage{
tatami.bind(xs, by.row)

tatami.transpose(x)

tatami.subset(x, subset, by.row)

tatami.arith(x, op, val, by.row, right)

tatami.compare(x, op, val, by.row, right)

tatami.logic(x, op, val, by.row)

tatami.round(x)

tatami.log(x, base)

tatami.math(x, op)

tatami.not(x)

tatami.binary(x, y, op)

tatami.dim(x)

tatami.row(x, i)

tatami.column(x, i)

tatami.row.sums(x, num.threads)

tatami.column.sums(x, num.threads)

tatami.is.sparse(x)

tatami.prefer.rows(x)

tatami.realize(x, num.threads)

tatami.multiply(x, val, right, num.threads)
}
\arguments{
\item{xs}{A list of pointers produced by \code{\link{initializeCpp}}.
All matrices should have the same number of rows (if \code{by.row=FALSE}) or columns (otherwise).}

\item{by.row}{Logical scalar indicating whether to apply the operation on the rows.
\itemize{
\item For \code{tatami.bind}, this will combine the matrices by rows,
i.e., the output matrix has a number of rows equal to the sum of the number of rows in \code{xs}.
\item For \code{tatami.subset}, this will subset the matrix by row.
\item For \code{tatami.arith}, \code{tatami.compare} and \code{tatami.logic} with a vector \code{val},
the vector should have length equal to the number of rows.k
}}

\item{x}{A pointer produced by \code{\link{initializeCpp}}.}

\item{subset}{Integer vector containing the subset of interest.
These should be 1-based row or column indices depending on \code{by.row}.}

\item{op}{String specifying the operation to perform.
\itemize{
\item For \code{tatami.arith}, this should be one of the operations in \link{Arith}.
\item For \code{tatami.compare}, this should be one of the operations in \link{Compare}.
\item For \code{tatami.logic}, this should be one of the operations in \link{Logic}.
\item For \code{tatami.math}, this should be one of the operations in \link{Math}.
\item For \code{tatami.binary}, this may be any operation in \link{Arith}, \link{Compare} or \link{Logic}.
}}

\item{val}{For \code{tatami.arith}, \code{tatami.compare} and \code{tatami.logic}, the value to be used in the operation specified by \code{op}. 
This may be a:
\itemize{
\item Numeric scalar, which is used in the operation for all entries of the matrix.
\item Numeric vector of length equal to the number of rows, where each value is used in the operation with the corresponding row when \code{by.row=TRUE}.
\item Numeric vector of length equal to the number of column, where each value is used with the corresponding column when \code{by.row=FALSE}.
}

For \code{tatami.multiply}, the value to be used in the matrix multiplication.
This may be a:
\itemize{
\item Numeric vector of length equal to the number of columns of \code{x} (if \code{right=FALSE}) or rows (otherwise).
\item Numeric matrix with number of rows equal to the number of columns of \code{x} (if \code{right=FALSE}) or rows (otherwise).
\item Pointer produced by \code{\link{initializeCpp}}, 
referencing a matrix with number of rows equal to the number of columns of \code{x} (if \code{right=FALSE}) or rows (otherwise).
}}

\item{right}{For \code{tatami.arith} and \code{tatami.compare}, 
a logical scalar indicating that \code{val} is on the right-hand side of the operation.

For \code{tatami.multiply}, a logical scalar indicating that \code{val} is on the right-hand side of the multiplication.}

\item{base}{Numeric scalar specifying the base of the log-transformation.}

\item{y}{A pointer produced by \code{\link{initializeCpp}},
referencing a matrix of the same dimensions as \code{x}.}

\item{i}{Integer scalar containing the 1-based index of the row (for \code{tatami.row}) or column (for \code{tatami.column}) of interest.}

\item{num.threads}{Integer scalar specifying the number of threads to use.}
}
\value{
For \code{tatami.dim}, an integer vector containing the dimensions of the matrix.

For \code{tatami.is.sparse}, a logical scalar indicating whether the matrix is sparse.

For \code{tatami.prefer.rows}, a logical scalar indicating whether the matrix prefers iteration by row.

For \code{tatami.row} or \code{tatami.column}, a numeric vector containing the contents of row or column \code{i}, respectively.

For \code{tatami.row.sums} or \code{tatami.column.sums}, a numeric vector containing the row or column sums, respectively.

For \code{tatami.realize}, a numeric matrix or \linkS4class{dgCMatrix} with the matrix contents.
The exact class depends on whether \code{x} refers to a sparse matrix. 

For \code{tatami.multiply}, a numeric matrix containing the matrix product of \code{x} and \code{other}.

For all other functions, a new pointer to a matrix with the requested operations applied to \code{x} or \code{xs}.
}
\description{
Utility functions that directly operate on the pointers produced by \code{\link{initializeCpp}}.
Some of these are used internally by \code{initializeCpp} methods operating on \pkg{DelayedArray} classes.
}
\examples{
x <- Matrix::rsparsematrix(1000, 100, 0.1)
ptr <- initializeCpp(x)
tatami.dim(ptr)
tatami.row(ptr, 1)

rounded <- tatami.round(ptr)
tatami.row(rounded, 1)

}
\author{
Aaron Lun
}
