# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserUpdateParameters(Model):
    """User update parameters.

    :param state: Account state. Specifies whether the user is active or not.
     Blocked users are unable to sign into the developer portal or call any
     APIs of subscribed products. Default state is Active. Possible values
     include: 'active', 'blocked', 'pending', 'deleted'. Default value:
     "active" .
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities:
     list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    :param email: Email address. Must not be empty and must be unique within
     the service instance.
    :type email: str
    :param password: User Password.
    :type password: str
    :param first_name: First name.
    :type first_name: str
    :param last_name: Last name.
    :type last_name: str
    """

    _validation = {
        'email': {'max_length': 254, 'min_length': 1},
        'first_name': {'max_length': 100, 'min_length': 1},
        'last_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'properties.state', 'type': 'str'},
        'note': {'key': 'properties.note', 'type': 'str'},
        'identities': {'key': 'properties.identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'first_name': {'key': 'properties.firstName', 'type': 'str'},
        'last_name': {'key': 'properties.lastName', 'type': 'str'},
    }

    def __init__(self, *, state="active", note: str=None, identities=None, email: str=None, password: str=None, first_name: str=None, last_name: str=None, **kwargs) -> None:
        super(UserUpdateParameters, self).__init__(**kwargs)
        self.state = state
        self.note = note
        self.identities = identities
        self.email = email
        self.password = password
        self.first_name = first_name
        self.last_name = last_name
