/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.Wildcard;
import com.tonicsystems.jarjar.asm.Type;
import com.tonicsystems.jarjar.asm.commons.Remapper;
import java.util.HashMap;
import java.util.List;

class PackageRemapper
extends Remapper {
    private static final String RESOURCE_SUFFIX = "RESOURCE";
    private final Wildcard[] wildcards;
    private final HashMap typeCache = new HashMap();
    private final HashMap pathCache = new HashMap();
    private final HashMap valueCache = new HashMap();
    private final HashMap cache = new HashMap();
    private final boolean verbose;

    public PackageRemapper(List ruleList, boolean verbose) {
        this.verbose = verbose;
        this.wildcards = PatternElement.createWildcards(ruleList);
    }

    static boolean isArrayForName(String value) {
        if (value.startsWith("[") && value.endsWith(";")) {
            try {
                Type.getType(value.replace('.', '/'));
                return true;
            }
            catch (Exception e) {
                System.err.println("not array for name: " + value);
            }
        }
        return false;
    }

    protected String map(String key) {
        String s = (String)this.typeCache.get(key);
        if (s == null) {
            s = this.replaceHelper(key);
            if (key.equals(s)) {
                s = null;
            }
            this.typeCache.put(key, s);
        }
        return s;
    }

    public String mapPath(String path) {
        String s = (String)this.pathCache.get(path);
        if (s == null) {
            String after;
            String end;
            s = path;
            int slash = s.lastIndexOf(47);
            if (slash < 0) {
                end = s;
                s = RESOURCE_SUFFIX;
            } else {
                end = s.substring(slash + 1);
                s = s.substring(0, slash + 1) + RESOURCE_SUFFIX;
            }
            boolean absolute = s.startsWith("/");
            if (absolute) {
                s = s.substring(1);
            }
            s = after = this.mapType(s);
            if (absolute) {
                s = "/" + s;
            }
            s = s.substring(0, s.length() - RESOURCE_SUFFIX.length()) + end;
            this.pathCache.put(path, s);
        }
        return s;
    }

    public Object mapValue(Object value) {
        if (value instanceof String) {
            String s = (String)this.valueCache.get(value);
            if (s == null) {
                String desc1;
                String desc2;
                s = (String)value;
                if (PackageRemapper.isArrayForName(s) && !(desc2 = this.mapDesc(desc1 = s.replace('.', '/'))).equals(desc1)) {
                    return desc2.replace('/', '.');
                }
                if (s.equals(value)) {
                    s = this.mapPath(s);
                }
                if (s.equals(value)) {
                    boolean hasSlash;
                    boolean hasDot = s.indexOf(46) >= 0;
                    boolean bl = hasSlash = s.indexOf(47) >= 0;
                    if (!hasDot || !hasSlash) {
                        s = hasDot ? this.replaceHelper(s.replace('.', '/')).replace('/', '.') : this.replaceHelper(s);
                    }
                }
                this.valueCache.put(value, s);
            }
            if (this.verbose && !s.equals(value)) {
                System.err.println("Changed \"" + value + "\" -> \"" + s + "\"");
            }
            return s;
        }
        return super.mapValue(value);
    }

    private String replaceHelper(String value) {
        for (int i = 0; i < this.wildcards.length; ++i) {
            String test = this.wildcards[i].replace(value);
            if (test == null) continue;
            return test;
        }
        return value;
    }
}

