.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_RESULT" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_result \- get information about a command result

.SH SYNOPSIS

.nf
pg_result \fIresultHandle\fR \fIresultOption\fR
.fi
.SH "DESCRIPTION"
.PP
\fBpg_result\fR returns information about a command
result created by a prior \fBpg_exec\fR\&.
.PP
You can keep a command result around for as long as you need it,
but when you are done with it, be sure to free it by executing
\fBpg_result -clear\fR\&.  Otherwise, you have a
memory leak, and \fBpgtcl\fR will eventually start
complaining that you have created too many command result objects.
.SH "ARGUMENTS"
.TP
\fB\fIresultHandle\fB\fR
The handle of the command result.
.TP
\fB\fIresultOption\fB\fR
One of the following options, specifying which piece of result
information to return:
.RS
.TP
\fB-status\fR
The status of the result.
.TP
\fB-error [\fIdiagCode\fB]\fR
The error message, if the status indicates an error,
otherwise an empty string.

\fIdiagCode\fR, if specified, requests data
for a specific diagnostic code:
.RS
.TP
\fBseverity\fR
The severity; the field contents are ERROR,
FATAL, or PANIC, in
an error message, or WARNING,
NOTICE, DEBUG,
INFO, or LOG,
in a notice message, or a localized translation of one of
these.
.TP
\fBsqlstate\fR
The SQLSTATE code for the error.
(See PostgreSQL manual Appendix A).
.TP
\fBprimary\fR
The primary human-readable error message (typically one line).
.TP
\fBdetail\fR
An optional secondary error message carrying more detail
abhout the problem, which may run to multiple lines.
.TP
\fBhint\fR
An optional suggestion about what to do about the problem.
This is intended to differ from detail in that it offers
advice (potentially inappropriate) rather than hard facts.

The result may run to multiple lines.
.TP
\fBposition\fR
A string containing a decimal integer indicating an error 
cursor position as an index into the original statement string.

The first character has index 1, and 
positions are measured in characters not bytes. 
.TP
\fBinternal_position\fR
This is the same as "position", but it is used when the cursor
position refers to an internally generated command rather than
the one submitted by the client.

The first character has index 1, and 
positions are measured in characters not bytes. 
.TP
\fBinternal_query\fR
This is the text of a failed internally generated command.
This could be, for example, a SQL query issued by a
PL/pgSQL function.
.TP
\fBcontext\fR
An indication of the context in which the error occurred. 
Presently this includes a call stack traceback of active PL 
functions. The trace is one entry per line, most recent first. 
.TP
\fBfile\fR
The filename of the source code location where the error
was reported.
.TP
\fBline\fR
The line number of the source code location where the error
was reported.
.TP
\fBfunction\fR
The name of the source code function reporting the error.
.RE
.TP
\fB-foreach \fIarrayName\fB \fItclCode\fB\fR
Iterates through each row of the result, filling
\fIarrayName\fR with the columns and their values and
executing \fItclCode\fR for each row in turn.
Null columns will be not be present in the array.
.TP
\fB-conn\fR
The connection that produced the result.
.TP
\fB-oid\fR
If the command was an \fBINSERT\fR, the OID of
the inserted row, otherwise 0.
.TP
\fB-numTuples\fR
The number of rows (tuples) returned by the query.
.TP
\fB-cmdTuples\fR
The number of rows (tuples) affected by the command.
(This is similar to \fB-numTuples\fR but
relevant to \fBINSERT\fR and
\fBUPDATE\fR commands.)
.TP
\fB-numAttrs\fR
The number of columns (attributes) in each row.
.TP
\fB-assign \fIarrayName\fB\fR
Assign the results to an array, using subscripts of the form
(rowNumber, columnName)\&.
.TP
\fB-foreach \fIarrayName\fB \fIcode\fB\fR
For each resulting row assigns the results to the named array, using
subscripts matching the column names, then executes the code body.
.TP
\fB-assignbyidx \fIarrayName\fB [\fIappendstr\fB]\fR
Assign the results to an array using the values of the
first column and the names of the remaining column as keys.
If \fIappendstr\fR is given then it is appended to
each key.  In short, all but the first column of each row
are stored into the array, using subscripts of the form
(firstColumnValue, columnNameAppendStr)\&.
.TP
\fB-getTuple \fIrowNumber\fB\fR
Returns the columns of the indicated row in a list.  Row
numbers start at zero.
.TP
\fB-tupleArray \fIrowNumber\fB \fIarrayName\fB\fR
Stores the columns of the row in array
\fIarrayName\fR, indexed by column names.
Row numbers start at zero.  If a field's value is null,
sets an empty string or the default string, if a default
string has been defined.
.TP
\fB-tupleArrayWithoutNulls \fIrowNumber\fB \fIarrayName\fB\fR
Stores the columns of the row in array
\fIarrayName\fR, indexed by column names.
Row numbers start at zero.  If a field's value is null,
unsets the column from the array.
.TP
\fB-attributes\fR
Returns a list of the names of the columns in the result.
.TP
\fB-lAttributes\fR
Returns a list of sublists, {name typeOid
typeSize} for each column.
.TP
\fB-list\fR
Returns one list containing all the data
returned by the query.
.TP
\fB-llist\fR
Returns a list of lists, where each embedded list represents
a tuple in the result.
.TP
\fB-dict\fR
Returns a dict object with the results. This needs to have dictionary
support built into Tcl (Tcl 8.5), and is experimental right now, since 
Tcl 8.5 has not been release yet, and the API could change. In
order to enable this, you need to add -DHAVE_TCL_NEWDICTOBJ
to the Makefile in the DEFS variable.
.TP
\fB-null_value_string [\fIstring\fB]\fR
Defines or retrieves the string that will be returned for null values in query results.  Defaults to whatever was set by \fBpg_null_value_string\fR but can be set here and, in this case, affects only this query result.
.TP
\fB-clear\fR
Clear the command result object.
.RE
.SH "RETURN VALUE"
.PP
The result depends on the selected option, as described above.
