/*
   ____    _ __           ____               __    ____
  / __/___(_) /  ___ ____/ __ \__ _____ ___ / /_  /  _/__  ____
 _\ \/ __/ / _ \/ -_) __/ /_/ / // / -_|_-</ __/ _/ // _ \/ __/
/___/\__/_/_.__/\__/_/  \___\_\_,_/\__/___/\__/ /___/_//_/\__(_)

Copyright 2012 SciberQuest Inc.
*/
#include "pqSQTensorGlyph.h"

#include <QCheckBox>
#include <QWidget>
#include <QLabel>
#include <QtDebug>

//-----------------------------------------------------------------------------
pqSQTensorGlyph::pqSQTensorGlyph(pqProxy *prox, QWidget *par)
        :
    pqAutoGeneratedObjectPanel(prox,par)
{
  QCheckBox *ColorGlyphsWidget;
  QCheckBox *LimitScalingByEigenvaluesWidget;
  QWidget *ColorModeWidget;
  QLabel *ColorModeLabel;
  QWidget *MaxScaleFactorWidget;
  QLabel *MaxScaleFactorLabel;

  ColorGlyphsWidget = this->findChild<QCheckBox*>("ColorGlyphs");
  if (! ColorGlyphsWidget)
    {
    qWarning() << "Failed to locate ColorGlyphs widget.";
    return;
    }

  // disable "color by" dropdown box if ColorGlyphs is not set
  ColorModeWidget = this->findChild<QWidget*>("ColorMode");
  if (ColorModeWidget)
    {
    QObject::connect(
        ColorGlyphsWidget,
        SIGNAL(toggled(bool)),
        ColorModeWidget,
        SLOT(setEnabled(bool)));
    }

  ColorModeLabel = this->findChild<QLabel*>("_labelForColorMode");
  if (ColorModeLabel)
    {
    QObject::connect(
        ColorGlyphsWidget,
        SIGNAL(toggled(bool)),
        ColorModeLabel,
        SLOT(setEnabled(bool)));
    }

  ColorGlyphsWidget->toggle();
  ColorGlyphsWidget->toggle();


  // disable "MaxScaleFactor" textbox if LimitScaling is not set
  LimitScalingByEigenvaluesWidget
    = this->findChild<QCheckBox*>("LimitScalingByEigenvalues");

  if (! LimitScalingByEigenvaluesWidget)
    {
    qWarning() << "Failed to locate LimitScalingByEigenvalues widget.";
    return;
    }

  MaxScaleFactorWidget = this->findChild<QWidget*>("MaxScaleFactor");
  if (MaxScaleFactorWidget)
    {
    QObject::connect(
        LimitScalingByEigenvaluesWidget,
        SIGNAL(toggled(bool)),
        MaxScaleFactorWidget,
        SLOT(setEnabled(bool)));
    }

  MaxScaleFactorLabel = this->findChild<QLabel*>("_labelForMaxScaleFactor");
  if (MaxScaleFactorLabel)
    {
    QObject::connect(
        LimitScalingByEigenvaluesWidget,
        SIGNAL(toggled(bool)),
        MaxScaleFactorLabel,
        SLOT(setEnabled(bool)));
    }

  LimitScalingByEigenvaluesWidget->toggle();
  LimitScalingByEigenvaluesWidget->toggle();

  return;
}
