/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.loaders;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import org.j3d.loaders.stl.STLFileReader;

public class STLLoader
extends LoaderBase {
    private final Component itsParentComponent;
    private boolean itsShowProgress = false;

    public STLLoader() {
        this.itsParentComponent = null;
    }

    public STLLoader(Component component) {
        this.itsParentComponent = component;
        this.itsShowProgress = true;
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        try {
            return this.load(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException();
        }
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        STLFileReader sTLFileReader = null;
        try {
            sTLFileReader = this.itsShowProgress ? new STLFileReader(uRL, this.itsParentComponent) : new STLFileReader(uRL);
            return STLLoader.createScene(sTLFileReader);
        }
        catch (InterruptedIOException interruptedIOException) {
            return null;
        }
        catch (IOException iOException) {
            throw new IncorrectFormatException(iOException.toString());
        }
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        return null;
    }

    public static Scene createScene(STLFileReader sTLFileReader) throws IncorrectFormatException, ParsingErrorException {
        try {
            SceneBase sceneBase = new SceneBase();
            BranchGroup branchGroup = new BranchGroup();
            int n = sTLFileReader.getNumOfObjects();
            int[] nArray = sTLFileReader.getNumOfFacets();
            String[] stringArray = sTLFileReader.getObjectNames();
            double[] dArray = new double[3];
            float[] fArray = new float[3];
            double[][] dArray2 = new double[3][3];
            for (int i = 0; i < n; ++i) {
                TriangleArray triangleArray = new TriangleArray(3 * nArray[i], 3);
                int n2 = 0;
                for (int j = 0; j < nArray[i]; ++j) {
                    boolean bl = sTLFileReader.getNextFacet(dArray, dArray2);
                    if (bl) {
                        fArray[0] = (float)dArray[0];
                        fArray[1] = (float)dArray[1];
                        fArray[2] = (float)dArray[2];
                        for (int k = 0; k < 3; ++k) {
                            triangleArray.setNormal(n2, fArray);
                            triangleArray.setCoordinate(n2, dArray2[k]);
                            ++n2;
                        }
                        continue;
                    }
                    throw new ParsingErrorException();
                }
                Shape3D shape3D = new Shape3D((Geometry)triangleArray);
                branchGroup.addChild((Node)shape3D);
                String string = stringArray[i];
                if (string == null) {
                    string = new String("Unknown_" + i);
                }
                sceneBase.addNamedObject(string, (Object)shape3D);
            }
            sceneBase.setSceneGroup(branchGroup);
            SceneBase sceneBase2 = sceneBase;
            return sceneBase2;
        }
        catch (InterruptedIOException interruptedIOException) {
            Scene scene = null;
            return scene;
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.toString());
        }
        finally {
            try {
                sTLFileReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

