//
//   Copyright 2020 Pixar
//
//   Licensed under the Apache License, Version 2.0 (the "Apache License")
//   with the following modification; you may not use this file except in
//   compliance with the Apache License and the following modification to it:
//   Section 6. Trademarks. is deleted and replaced with:
//
//   6. Trademarks. This License does not grant permission to use the trade
//      names, trademarks, service marks, or product names of the Licensor
//      and its affiliates, except as required to comply with Section 4(c) of
//      the License and to reproduce the content of the NOTICE file.
//
//   You may obtain a copy of the Apache License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the Apache License with the above modification is
//   distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
//   KIND, either express or implied. See the Apache License for the specific
//   language governing permissions and limitations under the Apache License.
//

#include "glApi.h"

#ifdef _WIN32
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
    #include <windows.h>
#endif
#else
    #include <dlfcn.h>
#endif

#include <cstring>
#include <cstdlib>
#include <cassert>
#include <vector>

#ifdef _WIN32
#define GLAPIENTRY __stdcall
#else
#define GLAPIENTRY
#endif


namespace OpenSubdiv {
namespace internal {
namespace GLApi {


bool GLAPILOADER_GL_VERSION_1_0 = false;
bool GLAPILOADER_GL_VERSION_1_1 = false;
bool GLAPILOADER_GL_VERSION_1_2 = false;
bool GLAPILOADER_GL_VERSION_1_3 = false;
bool GLAPILOADER_GL_VERSION_1_4 = false;
bool GLAPILOADER_GL_VERSION_1_5 = false;
bool GLAPILOADER_GL_VERSION_2_0 = false;
bool GLAPILOADER_GL_VERSION_2_1 = false;
bool GLAPILOADER_GL_VERSION_3_0 = false;
bool GLAPILOADER_GL_VERSION_3_1 = false;
bool GLAPILOADER_GL_VERSION_3_2 = false;
bool GLAPILOADER_GL_VERSION_3_3 = false;
bool GLAPILOADER_GL_VERSION_4_0 = false;
bool GLAPILOADER_GL_VERSION_4_1 = false;
bool GLAPILOADER_GL_VERSION_4_2 = false;
bool GLAPILOADER_GL_VERSION_4_3 = false;
bool GLAPILOADER_GL_VERSION_4_4 = false;
bool GLAPILOADER_GL_VERSION_4_5 = false;
bool GLAPILOADER_GL_VERSION_4_6 = false;


bool GLAPILOADER_GL_AMD_blend_minmax_factor = false;
bool GLAPILOADER_GL_AMD_conservative_depth = false;
bool GLAPILOADER_GL_AMD_debug_output = false;
bool GLAPILOADER_GL_AMD_depth_clamp_separate = false;
bool GLAPILOADER_GL_AMD_draw_buffers_blend = false;
bool GLAPILOADER_GL_AMD_framebuffer_multisample_advanced = false;
bool GLAPILOADER_GL_AMD_framebuffer_sample_positions = false;
bool GLAPILOADER_GL_AMD_gcn_shader = false;
bool GLAPILOADER_GL_AMD_gpu_shader_half_float = false;
bool GLAPILOADER_GL_AMD_gpu_shader_int16 = false;
bool GLAPILOADER_GL_AMD_gpu_shader_int64 = false;
bool GLAPILOADER_GL_AMD_interleaved_elements = false;
bool GLAPILOADER_GL_AMD_multi_draw_indirect = false;
bool GLAPILOADER_GL_AMD_name_gen_delete = false;
bool GLAPILOADER_GL_AMD_occlusion_query_event = false;
bool GLAPILOADER_GL_AMD_performance_monitor = false;
bool GLAPILOADER_GL_AMD_pinned_memory = false;
bool GLAPILOADER_GL_AMD_query_buffer_object = false;
bool GLAPILOADER_GL_AMD_sample_positions = false;
bool GLAPILOADER_GL_AMD_seamless_cubemap_per_texture = false;
bool GLAPILOADER_GL_AMD_shader_atomic_counter_ops = false;
bool GLAPILOADER_GL_AMD_shader_ballot = false;
bool GLAPILOADER_GL_AMD_shader_gpu_shader_half_float_fetch = false;
bool GLAPILOADER_GL_AMD_shader_image_load_store_lod = false;
bool GLAPILOADER_GL_AMD_shader_stencil_export = false;
bool GLAPILOADER_GL_AMD_shader_trinary_minmax = false;
bool GLAPILOADER_GL_AMD_shader_explicit_vertex_parameter = false;
bool GLAPILOADER_GL_AMD_sparse_texture = false;
bool GLAPILOADER_GL_AMD_stencil_operation_extended = false;
bool GLAPILOADER_GL_AMD_texture_gather_bias_lod = false;
bool GLAPILOADER_GL_AMD_texture_texture4 = false;
bool GLAPILOADER_GL_AMD_transform_feedback3_lines_triangles = false;
bool GLAPILOADER_GL_AMD_transform_feedback4 = false;
bool GLAPILOADER_GL_AMD_vertex_shader_layer = false;
bool GLAPILOADER_GL_AMD_vertex_shader_tessellator = false;
bool GLAPILOADER_GL_AMD_vertex_shader_viewport_index = false;
bool GLAPILOADER_GL_APPLE_aux_depth_stencil = false;
bool GLAPILOADER_GL_APPLE_client_storage = false;
bool GLAPILOADER_GL_APPLE_element_array = false;
bool GLAPILOADER_GL_APPLE_fence = false;
bool GLAPILOADER_GL_APPLE_float_pixels = false;
bool GLAPILOADER_GL_APPLE_flush_buffer_range = false;
bool GLAPILOADER_GL_APPLE_object_purgeable = false;
bool GLAPILOADER_GL_APPLE_rgb_422 = false;
bool GLAPILOADER_GL_APPLE_row_bytes = false;
bool GLAPILOADER_GL_APPLE_specular_vector = false;
bool GLAPILOADER_GL_APPLE_texture_range = false;
bool GLAPILOADER_GL_APPLE_transform_hint = false;
bool GLAPILOADER_GL_APPLE_vertex_array_object = false;
bool GLAPILOADER_GL_APPLE_vertex_array_range = false;
bool GLAPILOADER_GL_APPLE_vertex_program_evaluators = false;
bool GLAPILOADER_GL_APPLE_ycbcr_422 = false;
bool GLAPILOADER_GL_ARB_ES2_compatibility = false;
bool GLAPILOADER_GL_ARB_ES3_1_compatibility = false;
bool GLAPILOADER_GL_ARB_ES3_2_compatibility = false;
bool GLAPILOADER_GL_ARB_ES3_compatibility = false;
bool GLAPILOADER_GL_ARB_arrays_of_arrays = false;
bool GLAPILOADER_GL_ARB_base_instance = false;
bool GLAPILOADER_GL_ARB_bindless_texture = false;
bool GLAPILOADER_GL_ARB_blend_func_extended = false;
bool GLAPILOADER_GL_ARB_buffer_storage = false;
bool GLAPILOADER_GL_ARB_cl_event = false;
bool GLAPILOADER_GL_ARB_clear_buffer_object = false;
bool GLAPILOADER_GL_ARB_clear_texture = false;
bool GLAPILOADER_GL_ARB_clip_control = false;
bool GLAPILOADER_GL_ARB_color_buffer_float = false;
bool GLAPILOADER_GL_ARB_compatibility = false;
bool GLAPILOADER_GL_ARB_compressed_texture_pixel_storage = false;
bool GLAPILOADER_GL_ARB_compute_shader = false;
bool GLAPILOADER_GL_ARB_compute_variable_group_size = false;
bool GLAPILOADER_GL_ARB_conditional_render_inverted = false;
bool GLAPILOADER_GL_ARB_conservative_depth = false;
bool GLAPILOADER_GL_ARB_copy_buffer = false;
bool GLAPILOADER_GL_ARB_copy_image = false;
bool GLAPILOADER_GL_ARB_cull_distance = false;
bool GLAPILOADER_GL_ARB_debug_output = false;
bool GLAPILOADER_GL_ARB_depth_buffer_float = false;
bool GLAPILOADER_GL_ARB_depth_clamp = false;
bool GLAPILOADER_GL_ARB_depth_texture = false;
bool GLAPILOADER_GL_ARB_derivative_control = false;
bool GLAPILOADER_GL_ARB_direct_state_access = false;
bool GLAPILOADER_GL_ARB_draw_buffers = false;
bool GLAPILOADER_GL_ARB_draw_buffers_blend = false;
bool GLAPILOADER_GL_ARB_draw_elements_base_vertex = false;
bool GLAPILOADER_GL_ARB_draw_indirect = false;
bool GLAPILOADER_GL_ARB_draw_instanced = false;
bool GLAPILOADER_GL_ARB_enhanced_layouts = false;
bool GLAPILOADER_GL_ARB_explicit_attrib_location = false;
bool GLAPILOADER_GL_ARB_explicit_uniform_location = false;
bool GLAPILOADER_GL_ARB_fragment_coord_conventions = false;
bool GLAPILOADER_GL_ARB_fragment_layer_viewport = false;
bool GLAPILOADER_GL_ARB_fragment_program = false;
bool GLAPILOADER_GL_ARB_fragment_program_shadow = false;
bool GLAPILOADER_GL_ARB_fragment_shader = false;
bool GLAPILOADER_GL_ARB_fragment_shader_interlock = false;
bool GLAPILOADER_GL_ARB_framebuffer_no_attachments = false;
bool GLAPILOADER_GL_ARB_framebuffer_object = false;
bool GLAPILOADER_GL_ARB_framebuffer_sRGB = false;
bool GLAPILOADER_GL_ARB_geometry_shader4 = false;
bool GLAPILOADER_GL_ARB_get_program_binary = false;
bool GLAPILOADER_GL_ARB_get_texture_sub_image = false;
bool GLAPILOADER_GL_ARB_gl_spirv = false;
bool GLAPILOADER_GL_ARB_gpu_shader5 = false;
bool GLAPILOADER_GL_ARB_gpu_shader_fp64 = false;
bool GLAPILOADER_GL_ARB_gpu_shader_int64 = false;
bool GLAPILOADER_GL_ARB_half_float_pixel = false;
bool GLAPILOADER_GL_ARB_half_float_vertex = false;
bool GLAPILOADER_GL_ARB_imaging = false;
bool GLAPILOADER_GL_ARB_indirect_parameters = false;
bool GLAPILOADER_GL_ARB_instanced_arrays = false;
bool GLAPILOADER_GL_ARB_internalformat_query = false;
bool GLAPILOADER_GL_ARB_internalformat_query2 = false;
bool GLAPILOADER_GL_ARB_invalidate_subdata = false;
bool GLAPILOADER_GL_ARB_map_buffer_alignment = false;
bool GLAPILOADER_GL_ARB_map_buffer_range = false;
bool GLAPILOADER_GL_ARB_matrix_palette = false;
bool GLAPILOADER_GL_ARB_multi_bind = false;
bool GLAPILOADER_GL_ARB_multi_draw_indirect = false;
bool GLAPILOADER_GL_ARB_multisample = false;
bool GLAPILOADER_GL_ARB_multitexture = false;
bool GLAPILOADER_GL_ARB_occlusion_query = false;
bool GLAPILOADER_GL_ARB_occlusion_query2 = false;
bool GLAPILOADER_GL_ARB_parallel_shader_compile = false;
bool GLAPILOADER_GL_ARB_pipeline_statistics_query = false;
bool GLAPILOADER_GL_ARB_pixel_buffer_object = false;
bool GLAPILOADER_GL_ARB_point_parameters = false;
bool GLAPILOADER_GL_ARB_point_sprite = false;
bool GLAPILOADER_GL_ARB_polygon_offset_clamp = false;
bool GLAPILOADER_GL_ARB_post_depth_coverage = false;
bool GLAPILOADER_GL_ARB_program_interface_query = false;
bool GLAPILOADER_GL_ARB_provoking_vertex = false;
bool GLAPILOADER_GL_ARB_query_buffer_object = false;
bool GLAPILOADER_GL_ARB_robust_buffer_access_behavior = false;
bool GLAPILOADER_GL_ARB_robustness = false;
bool GLAPILOADER_GL_ARB_robustness_isolation = false;
bool GLAPILOADER_GL_ARB_sample_locations = false;
bool GLAPILOADER_GL_ARB_sample_shading = false;
bool GLAPILOADER_GL_ARB_sampler_objects = false;
bool GLAPILOADER_GL_ARB_seamless_cube_map = false;
bool GLAPILOADER_GL_ARB_seamless_cubemap_per_texture = false;
bool GLAPILOADER_GL_ARB_separate_shader_objects = false;
bool GLAPILOADER_GL_ARB_shader_atomic_counter_ops = false;
bool GLAPILOADER_GL_ARB_shader_atomic_counters = false;
bool GLAPILOADER_GL_ARB_shader_ballot = false;
bool GLAPILOADER_GL_ARB_shader_bit_encoding = false;
bool GLAPILOADER_GL_ARB_shader_clock = false;
bool GLAPILOADER_GL_ARB_shader_draw_parameters = false;
bool GLAPILOADER_GL_ARB_shader_group_vote = false;
bool GLAPILOADER_GL_ARB_shader_image_load_store = false;
bool GLAPILOADER_GL_ARB_shader_image_size = false;
bool GLAPILOADER_GL_ARB_shader_objects = false;
bool GLAPILOADER_GL_ARB_shader_precision = false;
bool GLAPILOADER_GL_ARB_shader_stencil_export = false;
bool GLAPILOADER_GL_ARB_shader_storage_buffer_object = false;
bool GLAPILOADER_GL_ARB_shader_subroutine = false;
bool GLAPILOADER_GL_ARB_shader_texture_image_samples = false;
bool GLAPILOADER_GL_ARB_shader_texture_lod = false;
bool GLAPILOADER_GL_ARB_shader_viewport_layer_array = false;
bool GLAPILOADER_GL_ARB_shading_language_100 = false;
bool GLAPILOADER_GL_ARB_shading_language_420pack = false;
bool GLAPILOADER_GL_ARB_shading_language_include = false;
bool GLAPILOADER_GL_ARB_shading_language_packing = false;
bool GLAPILOADER_GL_ARB_shadow = false;
bool GLAPILOADER_GL_ARB_shadow_ambient = false;
bool GLAPILOADER_GL_ARB_sparse_buffer = false;
bool GLAPILOADER_GL_ARB_sparse_texture = false;
bool GLAPILOADER_GL_ARB_sparse_texture2 = false;
bool GLAPILOADER_GL_ARB_sparse_texture_clamp = false;
bool GLAPILOADER_GL_ARB_spirv_extensions = false;
bool GLAPILOADER_GL_ARB_stencil_texturing = false;
bool GLAPILOADER_GL_ARB_sync = false;
bool GLAPILOADER_GL_ARB_tessellation_shader = false;
bool GLAPILOADER_GL_ARB_texture_barrier = false;
bool GLAPILOADER_GL_ARB_texture_border_clamp = false;
bool GLAPILOADER_GL_ARB_texture_buffer_object = false;
bool GLAPILOADER_GL_ARB_texture_buffer_object_rgb32 = false;
bool GLAPILOADER_GL_ARB_texture_buffer_range = false;
bool GLAPILOADER_GL_ARB_texture_compression = false;
bool GLAPILOADER_GL_ARB_texture_compression_bptc = false;
bool GLAPILOADER_GL_ARB_texture_compression_rgtc = false;
bool GLAPILOADER_GL_ARB_texture_cube_map = false;
bool GLAPILOADER_GL_ARB_texture_cube_map_array = false;
bool GLAPILOADER_GL_ARB_texture_env_add = false;
bool GLAPILOADER_GL_ARB_texture_env_combine = false;
bool GLAPILOADER_GL_ARB_texture_env_crossbar = false;
bool GLAPILOADER_GL_ARB_texture_env_dot3 = false;
bool GLAPILOADER_GL_ARB_texture_filter_anisotropic = false;
bool GLAPILOADER_GL_ARB_texture_filter_minmax = false;
bool GLAPILOADER_GL_ARB_texture_float = false;
bool GLAPILOADER_GL_ARB_texture_gather = false;
bool GLAPILOADER_GL_ARB_texture_mirror_clamp_to_edge = false;
bool GLAPILOADER_GL_ARB_texture_mirrored_repeat = false;
bool GLAPILOADER_GL_ARB_texture_multisample = false;
bool GLAPILOADER_GL_ARB_texture_non_power_of_two = false;
bool GLAPILOADER_GL_ARB_texture_query_levels = false;
bool GLAPILOADER_GL_ARB_texture_query_lod = false;
bool GLAPILOADER_GL_ARB_texture_rectangle = false;
bool GLAPILOADER_GL_ARB_texture_rg = false;
bool GLAPILOADER_GL_ARB_texture_rgb10_a2ui = false;
bool GLAPILOADER_GL_ARB_texture_stencil8 = false;
bool GLAPILOADER_GL_ARB_texture_storage = false;
bool GLAPILOADER_GL_ARB_texture_storage_multisample = false;
bool GLAPILOADER_GL_ARB_texture_swizzle = false;
bool GLAPILOADER_GL_ARB_texture_view = false;
bool GLAPILOADER_GL_ARB_timer_query = false;
bool GLAPILOADER_GL_ARB_transform_feedback2 = false;
bool GLAPILOADER_GL_ARB_transform_feedback3 = false;
bool GLAPILOADER_GL_ARB_transform_feedback_instanced = false;
bool GLAPILOADER_GL_ARB_transform_feedback_overflow_query = false;
bool GLAPILOADER_GL_ARB_transpose_matrix = false;
bool GLAPILOADER_GL_ARB_uniform_buffer_object = false;
bool GLAPILOADER_GL_ARB_vertex_array_bgra = false;
bool GLAPILOADER_GL_ARB_vertex_array_object = false;
bool GLAPILOADER_GL_ARB_vertex_attrib_64bit = false;
bool GLAPILOADER_GL_ARB_vertex_attrib_binding = false;
bool GLAPILOADER_GL_ARB_vertex_blend = false;
bool GLAPILOADER_GL_ARB_vertex_buffer_object = false;
bool GLAPILOADER_GL_ARB_vertex_program = false;
bool GLAPILOADER_GL_ARB_vertex_shader = false;
bool GLAPILOADER_GL_ARB_vertex_type_10f_11f_11f_rev = false;
bool GLAPILOADER_GL_ARB_vertex_type_2_10_10_10_rev = false;
bool GLAPILOADER_GL_ARB_viewport_array = false;
bool GLAPILOADER_GL_ARB_window_pos = false;
bool GLAPILOADER_GL_EXT_422_pixels = false;
bool GLAPILOADER_GL_EXT_EGL_image_storage = false;
bool GLAPILOADER_GL_EXT_EGL_sync = false;
bool GLAPILOADER_GL_EXT_abgr = false;
bool GLAPILOADER_GL_EXT_bgra = false;
bool GLAPILOADER_GL_EXT_bindable_uniform = false;
bool GLAPILOADER_GL_EXT_blend_color = false;
bool GLAPILOADER_GL_EXT_blend_equation_separate = false;
bool GLAPILOADER_GL_EXT_blend_func_separate = false;
bool GLAPILOADER_GL_EXT_blend_logic_op = false;
bool GLAPILOADER_GL_EXT_blend_minmax = false;
bool GLAPILOADER_GL_EXT_blend_subtract = false;
bool GLAPILOADER_GL_EXT_clip_volume_hint = false;
bool GLAPILOADER_GL_EXT_cmyka = false;
bool GLAPILOADER_GL_EXT_color_subtable = false;
bool GLAPILOADER_GL_EXT_compiled_vertex_array = false;
bool GLAPILOADER_GL_EXT_convolution = false;
bool GLAPILOADER_GL_EXT_coordinate_frame = false;
bool GLAPILOADER_GL_EXT_copy_texture = false;
bool GLAPILOADER_GL_EXT_cull_vertex = false;
bool GLAPILOADER_GL_EXT_debug_label = false;
bool GLAPILOADER_GL_EXT_debug_marker = false;
bool GLAPILOADER_GL_EXT_depth_bounds_test = false;
bool GLAPILOADER_GL_EXT_direct_state_access = false;
bool GLAPILOADER_GL_EXT_draw_buffers2 = false;
bool GLAPILOADER_GL_EXT_draw_instanced = false;
bool GLAPILOADER_GL_EXT_draw_range_elements = false;
bool GLAPILOADER_GL_EXT_external_buffer = false;
bool GLAPILOADER_GL_EXT_fog_coord = false;
bool GLAPILOADER_GL_EXT_framebuffer_blit = false;
bool GLAPILOADER_GL_EXT_framebuffer_multisample = false;
bool GLAPILOADER_GL_EXT_framebuffer_multisample_blit_scaled = false;
bool GLAPILOADER_GL_EXT_framebuffer_object = false;
bool GLAPILOADER_GL_EXT_framebuffer_sRGB = false;
bool GLAPILOADER_GL_EXT_geometry_shader4 = false;
bool GLAPILOADER_GL_EXT_gpu_program_parameters = false;
bool GLAPILOADER_GL_EXT_gpu_shader4 = false;
bool GLAPILOADER_GL_EXT_histogram = false;
bool GLAPILOADER_GL_EXT_index_array_formats = false;
bool GLAPILOADER_GL_EXT_index_func = false;
bool GLAPILOADER_GL_EXT_index_material = false;
bool GLAPILOADER_GL_EXT_index_texture = false;
bool GLAPILOADER_GL_EXT_light_texture = false;
bool GLAPILOADER_GL_EXT_memory_object = false;
bool GLAPILOADER_GL_EXT_memory_object_fd = false;
bool GLAPILOADER_GL_EXT_memory_object_win32 = false;
bool GLAPILOADER_GL_EXT_misc_attribute = false;
bool GLAPILOADER_GL_EXT_multi_draw_arrays = false;
bool GLAPILOADER_GL_EXT_multisample = false;
bool GLAPILOADER_GL_EXT_multiview_tessellation_geometry_shader = false;
bool GLAPILOADER_GL_EXT_multiview_texture_multisample = false;
bool GLAPILOADER_GL_EXT_multiview_timer_query = false;
bool GLAPILOADER_GL_EXT_packed_depth_stencil = false;
bool GLAPILOADER_GL_EXT_packed_float = false;
bool GLAPILOADER_GL_EXT_packed_pixels = false;
bool GLAPILOADER_GL_EXT_paletted_texture = false;
bool GLAPILOADER_GL_EXT_pixel_buffer_object = false;
bool GLAPILOADER_GL_EXT_pixel_transform = false;
bool GLAPILOADER_GL_EXT_pixel_transform_color_table = false;
bool GLAPILOADER_GL_EXT_point_parameters = false;
bool GLAPILOADER_GL_EXT_polygon_offset = false;
bool GLAPILOADER_GL_EXT_polygon_offset_clamp = false;
bool GLAPILOADER_GL_EXT_post_depth_coverage = false;
bool GLAPILOADER_GL_EXT_provoking_vertex = false;
bool GLAPILOADER_GL_EXT_raster_multisample = false;
bool GLAPILOADER_GL_EXT_rescale_normal = false;
bool GLAPILOADER_GL_EXT_semaphore = false;
bool GLAPILOADER_GL_EXT_semaphore_fd = false;
bool GLAPILOADER_GL_EXT_semaphore_win32 = false;
bool GLAPILOADER_GL_EXT_secondary_color = false;
bool GLAPILOADER_GL_EXT_separate_shader_objects = false;
bool GLAPILOADER_GL_EXT_separate_specular_color = false;
bool GLAPILOADER_GL_EXT_shader_framebuffer_fetch = false;
bool GLAPILOADER_GL_EXT_shader_framebuffer_fetch_non_coherent = false;
bool GLAPILOADER_GL_EXT_shader_image_load_formatted = false;
bool GLAPILOADER_GL_EXT_shader_image_load_store = false;
bool GLAPILOADER_GL_EXT_shader_integer_mix = false;
bool GLAPILOADER_GL_EXT_shadow_funcs = false;
bool GLAPILOADER_GL_EXT_shared_texture_palette = false;
bool GLAPILOADER_GL_EXT_sparse_texture2 = false;
bool GLAPILOADER_GL_EXT_stencil_clear_tag = false;
bool GLAPILOADER_GL_EXT_stencil_two_side = false;
bool GLAPILOADER_GL_EXT_stencil_wrap = false;
bool GLAPILOADER_GL_EXT_subtexture = false;
bool GLAPILOADER_GL_EXT_texture = false;
bool GLAPILOADER_GL_EXT_texture3D = false;
bool GLAPILOADER_GL_EXT_texture_array = false;
bool GLAPILOADER_GL_EXT_texture_buffer_object = false;
bool GLAPILOADER_GL_EXT_texture_compression_latc = false;
bool GLAPILOADER_GL_EXT_texture_compression_rgtc = false;
bool GLAPILOADER_GL_EXT_texture_compression_s3tc = false;
bool GLAPILOADER_GL_EXT_texture_cube_map = false;
bool GLAPILOADER_GL_EXT_texture_env_add = false;
bool GLAPILOADER_GL_EXT_texture_env_combine = false;
bool GLAPILOADER_GL_EXT_texture_env_dot3 = false;
bool GLAPILOADER_GL_EXT_texture_filter_anisotropic = false;
bool GLAPILOADER_GL_EXT_texture_filter_minmax = false;
bool GLAPILOADER_GL_EXT_texture_integer = false;
bool GLAPILOADER_GL_EXT_texture_lod_bias = false;
bool GLAPILOADER_GL_EXT_texture_mirror_clamp = false;
bool GLAPILOADER_GL_EXT_texture_object = false;
bool GLAPILOADER_GL_EXT_texture_perturb_normal = false;
bool GLAPILOADER_GL_EXT_texture_sRGB = false;
bool GLAPILOADER_GL_EXT_texture_sRGB_R8 = false;
bool GLAPILOADER_GL_EXT_texture_sRGB_decode = false;
bool GLAPILOADER_GL_EXT_texture_shared_exponent = false;
bool GLAPILOADER_GL_EXT_texture_snorm = false;
bool GLAPILOADER_GL_EXT_texture_swizzle = false;
bool GLAPILOADER_GL_EXT_timer_query = false;
bool GLAPILOADER_GL_EXT_transform_feedback = false;
bool GLAPILOADER_GL_EXT_vertex_array = false;
bool GLAPILOADER_GL_EXT_vertex_array_bgra = false;
bool GLAPILOADER_GL_EXT_vertex_attrib_64bit = false;
bool GLAPILOADER_GL_EXT_vertex_shader = false;
bool GLAPILOADER_GL_EXT_vertex_weighting = false;
bool GLAPILOADER_GL_EXT_win32_keyed_mutex = false;
bool GLAPILOADER_GL_EXT_window_rectangles = false;
bool GLAPILOADER_GL_EXT_x11_sync_object = false;
bool GLAPILOADER_GL_INTEL_conservative_rasterization = false;
bool GLAPILOADER_GL_INTEL_fragment_shader_ordering = false;
bool GLAPILOADER_GL_INTEL_framebuffer_CMAA = false;
bool GLAPILOADER_GL_INTEL_map_texture = false;
bool GLAPILOADER_GL_INTEL_blackhole_render = false;
bool GLAPILOADER_GL_INTEL_parallel_arrays = false;
bool GLAPILOADER_GL_INTEL_performance_query = false;
bool GLAPILOADER_GL_KHR_blend_equation_advanced = false;
bool GLAPILOADER_GL_KHR_blend_equation_advanced_coherent = false;
bool GLAPILOADER_GL_KHR_context_flush_control = false;
bool GLAPILOADER_GL_KHR_debug = false;
bool GLAPILOADER_GL_KHR_no_error = false;
bool GLAPILOADER_GL_KHR_robust_buffer_access_behavior = false;
bool GLAPILOADER_GL_KHR_robustness = false;
bool GLAPILOADER_GL_KHR_shader_subgroup = false;
bool GLAPILOADER_GL_KHR_texture_compression_astc_hdr = false;
bool GLAPILOADER_GL_KHR_texture_compression_astc_ldr = false;
bool GLAPILOADER_GL_KHR_texture_compression_astc_sliced_3d = false;
bool GLAPILOADER_GL_KHR_parallel_shader_compile = false;
bool GLAPILOADER_GL_NV_alpha_to_coverage_dither_control = false;
bool GLAPILOADER_GL_NV_bindless_multi_draw_indirect = false;
bool GLAPILOADER_GL_NV_bindless_multi_draw_indirect_count = false;
bool GLAPILOADER_GL_NV_bindless_texture = false;
bool GLAPILOADER_GL_NV_blend_equation_advanced = false;
bool GLAPILOADER_GL_NV_blend_equation_advanced_coherent = false;
bool GLAPILOADER_GL_NV_blend_minmax_factor = false;
bool GLAPILOADER_GL_NV_blend_square = false;
bool GLAPILOADER_GL_NV_clip_space_w_scaling = false;
bool GLAPILOADER_GL_NV_command_list = false;
bool GLAPILOADER_GL_NV_compute_program5 = false;
bool GLAPILOADER_GL_NV_compute_shader_derivatives = false;
bool GLAPILOADER_GL_NV_conditional_render = false;
bool GLAPILOADER_GL_NV_conservative_raster = false;
bool GLAPILOADER_GL_NV_conservative_raster_dilate = false;
bool GLAPILOADER_GL_NV_conservative_raster_pre_snap = false;
bool GLAPILOADER_GL_NV_conservative_raster_pre_snap_triangles = false;
bool GLAPILOADER_GL_NV_conservative_raster_underestimation = false;
bool GLAPILOADER_GL_NV_copy_depth_to_color = false;
bool GLAPILOADER_GL_NV_copy_image = false;
bool GLAPILOADER_GL_NV_deep_texture3D = false;
bool GLAPILOADER_GL_NV_depth_buffer_float = false;
bool GLAPILOADER_GL_NV_depth_clamp = false;
bool GLAPILOADER_GL_NV_draw_texture = false;
bool GLAPILOADER_GL_NV_draw_vulkan_image = false;
bool GLAPILOADER_GL_NV_evaluators = false;
bool GLAPILOADER_GL_NV_explicit_multisample = false;
bool GLAPILOADER_GL_NV_fence = false;
bool GLAPILOADER_GL_NV_fill_rectangle = false;
bool GLAPILOADER_GL_NV_float_buffer = false;
bool GLAPILOADER_GL_NV_fog_distance = false;
bool GLAPILOADER_GL_NV_fragment_coverage_to_color = false;
bool GLAPILOADER_GL_NV_fragment_program = false;
bool GLAPILOADER_GL_NV_fragment_program2 = false;
bool GLAPILOADER_GL_NV_fragment_program4 = false;
bool GLAPILOADER_GL_NV_fragment_program_option = false;
bool GLAPILOADER_GL_NV_fragment_shader_barycentric = false;
bool GLAPILOADER_GL_NV_fragment_shader_interlock = false;
bool GLAPILOADER_GL_NV_framebuffer_mixed_samples = false;
bool GLAPILOADER_GL_NV_framebuffer_multisample_coverage = false;
bool GLAPILOADER_GL_NV_geometry_program4 = false;
bool GLAPILOADER_GL_NV_geometry_shader4 = false;
bool GLAPILOADER_GL_NV_geometry_shader_passthrough = false;
bool GLAPILOADER_GL_NV_gpu_program4 = false;
bool GLAPILOADER_GL_NV_gpu_program5 = false;
bool GLAPILOADER_GL_NV_gpu_program5_mem_extended = false;
bool GLAPILOADER_GL_NV_gpu_shader5 = false;
bool GLAPILOADER_GL_NV_half_float = false;
bool GLAPILOADER_GL_NV_internalformat_sample_query = false;
bool GLAPILOADER_GL_NV_light_max_exponent = false;
bool GLAPILOADER_GL_NV_gpu_multicast = false;
bool GLAPILOADER_GL_NV_memory_attachment = false;
bool GLAPILOADER_GL_NV_mesh_shader = false;
bool GLAPILOADER_GL_NV_multisample_coverage = false;
bool GLAPILOADER_GL_NV_multisample_filter_hint = false;
bool GLAPILOADER_GL_NV_occlusion_query = false;
bool GLAPILOADER_GL_NV_packed_depth_stencil = false;
bool GLAPILOADER_GL_NV_parameter_buffer_object = false;
bool GLAPILOADER_GL_NV_parameter_buffer_object2 = false;
bool GLAPILOADER_GL_NV_path_rendering = false;
bool GLAPILOADER_GL_NV_path_rendering_shared_edge = false;
bool GLAPILOADER_GL_NV_pixel_data_range = false;
bool GLAPILOADER_GL_NV_point_sprite = false;
bool GLAPILOADER_GL_NV_present_video = false;
bool GLAPILOADER_GL_NV_primitive_restart = false;
bool GLAPILOADER_GL_NV_query_resource = false;
bool GLAPILOADER_GL_NV_query_resource_tag = false;
bool GLAPILOADER_GL_NV_register_combiners = false;
bool GLAPILOADER_GL_NV_register_combiners2 = false;
bool GLAPILOADER_GL_NV_representative_fragment_test = false;
bool GLAPILOADER_GL_NV_robustness_video_memory_purge = false;
bool GLAPILOADER_GL_NV_sample_locations = false;
bool GLAPILOADER_GL_NV_sample_mask_override_coverage = false;
bool GLAPILOADER_GL_NV_scissor_exclusive = false;
bool GLAPILOADER_GL_NV_shader_atomic_counters = false;
bool GLAPILOADER_GL_NV_shader_atomic_float = false;
bool GLAPILOADER_GL_NV_shader_atomic_float64 = false;
bool GLAPILOADER_GL_NV_shader_atomic_fp16_vector = false;
bool GLAPILOADER_GL_NV_shader_atomic_int64 = false;
bool GLAPILOADER_GL_NV_shader_buffer_load = false;
bool GLAPILOADER_GL_NV_shader_buffer_store = false;
bool GLAPILOADER_GL_NV_shader_storage_buffer_object = false;
bool GLAPILOADER_GL_NV_shader_subgroup_partitioned = false;
bool GLAPILOADER_GL_NV_shader_texture_footprint = false;
bool GLAPILOADER_GL_NV_shader_thread_group = false;
bool GLAPILOADER_GL_NV_shader_thread_shuffle = false;
bool GLAPILOADER_GL_NV_shading_rate_image = false;
bool GLAPILOADER_GL_NV_stereo_view_rendering = false;
bool GLAPILOADER_GL_NV_tessellation_program5 = false;
bool GLAPILOADER_GL_NV_texgen_emboss = false;
bool GLAPILOADER_GL_NV_texgen_reflection = false;
bool GLAPILOADER_GL_NV_texture_barrier = false;
bool GLAPILOADER_GL_NV_texture_compression_vtc = false;
bool GLAPILOADER_GL_NV_texture_env_combine4 = false;
bool GLAPILOADER_GL_NV_texture_expand_normal = false;
bool GLAPILOADER_GL_NV_texture_multisample = false;
bool GLAPILOADER_GL_NV_texture_rectangle = false;
bool GLAPILOADER_GL_NV_texture_rectangle_compressed = false;
bool GLAPILOADER_GL_NV_texture_shader = false;
bool GLAPILOADER_GL_NV_texture_shader2 = false;
bool GLAPILOADER_GL_NV_texture_shader3 = false;
bool GLAPILOADER_GL_NV_transform_feedback = false;
bool GLAPILOADER_GL_NV_transform_feedback2 = false;
bool GLAPILOADER_GL_NV_uniform_buffer_unified_memory = false;
bool GLAPILOADER_GL_NV_vdpau_interop = false;
bool GLAPILOADER_GL_NV_vdpau_interop2 = false;
bool GLAPILOADER_GL_NV_vertex_array_range = false;
bool GLAPILOADER_GL_NV_vertex_array_range2 = false;
bool GLAPILOADER_GL_NV_vertex_attrib_integer_64bit = false;
bool GLAPILOADER_GL_NV_vertex_buffer_unified_memory = false;
bool GLAPILOADER_GL_NV_vertex_program = false;
bool GLAPILOADER_GL_NV_vertex_program1_1 = false;
bool GLAPILOADER_GL_NV_vertex_program2 = false;
bool GLAPILOADER_GL_NV_vertex_program2_option = false;
bool GLAPILOADER_GL_NV_vertex_program3 = false;
bool GLAPILOADER_GL_NV_vertex_program4 = false;
bool GLAPILOADER_GL_NV_video_capture = false;
bool GLAPILOADER_GL_NV_viewport_array2 = false;
bool GLAPILOADER_GL_NV_viewport_swizzle = false;
bool GLAPILOADER_GL_EXT_texture_shadow_lod = false;


void (GLAPIENTRY *glAccum) (GLenum  op, GLfloat  value) = NULL;
void (GLAPIENTRY *glActiveProgramEXT) (GLuint  program) = NULL;
void (GLAPIENTRY *glActiveShaderProgram) (GLuint  pipeline, GLuint  program) = NULL;
void (GLAPIENTRY *glActiveShaderProgramEXT) (GLuint  pipeline, GLuint  program) = NULL;
void (GLAPIENTRY *glActiveStencilFaceEXT) (GLenum  face) = NULL;
void (GLAPIENTRY *glActiveTexture) (GLenum  texture) = NULL;
void (GLAPIENTRY *glActiveTextureARB) (GLenum  texture) = NULL;
void (GLAPIENTRY *glActiveVaryingNV) (GLuint  program, const GLchar * name) = NULL;
void (GLAPIENTRY *glAlphaFunc) (GLenum  func, GLfloat  ref) = NULL;
void (GLAPIENTRY *glAlphaToCoverageDitherControlNV) (GLenum  mode) = NULL;
void (GLAPIENTRY *glApplyFramebufferAttachmentCMAAINTEL) () = NULL;
void (GLAPIENTRY *glApplyTextureEXT) (GLenum  mode) = NULL;
GLboolean (GLAPIENTRY *glAcquireKeyedMutexWin32EXT) (GLuint  memory, GLuint64  key, GLuint  timeout) = NULL;
GLboolean (GLAPIENTRY *glAreProgramsResidentNV) (GLsizei  n, const GLuint * programs, GLboolean * residences) = NULL;
GLboolean (GLAPIENTRY *glAreTexturesResident) (GLsizei  n, const GLuint * textures, GLboolean * residences) = NULL;
GLboolean (GLAPIENTRY *glAreTexturesResidentEXT) (GLsizei  n, const GLuint * textures, GLboolean * residences) = NULL;
void (GLAPIENTRY *glArrayElement) (GLint  i) = NULL;
void (GLAPIENTRY *glArrayElementEXT) (GLint  i) = NULL;
void (GLAPIENTRY *glAttachObjectARB) (GLhandleARB  containerObj, GLhandleARB  obj) = NULL;
void (GLAPIENTRY *glAttachShader) (GLuint  program, GLuint  shader) = NULL;
void (GLAPIENTRY *glBegin) (GLenum  mode) = NULL;
void (GLAPIENTRY *glBeginConditionalRender) (GLuint  id, GLenum  mode) = NULL;
void (GLAPIENTRY *glBeginConditionalRenderNV) (GLuint  id, GLenum  mode) = NULL;
void (GLAPIENTRY *glBeginOcclusionQueryNV) (GLuint  id) = NULL;
void (GLAPIENTRY *glBeginPerfMonitorAMD) (GLuint  monitor) = NULL;
void (GLAPIENTRY *glBeginPerfQueryINTEL) (GLuint  queryHandle) = NULL;
void (GLAPIENTRY *glBeginQuery) (GLenum  target, GLuint  id) = NULL;
void (GLAPIENTRY *glBeginQueryARB) (GLenum  target, GLuint  id) = NULL;
void (GLAPIENTRY *glBeginQueryIndexed) (GLenum  target, GLuint  index, GLuint  id) = NULL;
void (GLAPIENTRY *glBeginTransformFeedback) (GLenum  primitiveMode) = NULL;
void (GLAPIENTRY *glBeginTransformFeedbackEXT) (GLenum  primitiveMode) = NULL;
void (GLAPIENTRY *glBeginTransformFeedbackNV) (GLenum  primitiveMode) = NULL;
void (GLAPIENTRY *glBeginVertexShaderEXT) () = NULL;
void (GLAPIENTRY *glBeginVideoCaptureNV) (GLuint  video_capture_slot) = NULL;
void (GLAPIENTRY *glBindAttribLocation) (GLuint  program, GLuint  index, const GLchar * name) = NULL;
void (GLAPIENTRY *glBindAttribLocationARB) (GLhandleARB  programObj, GLuint  index, const GLcharARB * name) = NULL;
void (GLAPIENTRY *glBindBuffer) (GLenum  target, GLuint  buffer) = NULL;
void (GLAPIENTRY *glBindBufferARB) (GLenum  target, GLuint  buffer) = NULL;
void (GLAPIENTRY *glBindBufferBase) (GLenum  target, GLuint  index, GLuint  buffer) = NULL;
void (GLAPIENTRY *glBindBufferBaseEXT) (GLenum  target, GLuint  index, GLuint  buffer) = NULL;
void (GLAPIENTRY *glBindBufferBaseNV) (GLenum  target, GLuint  index, GLuint  buffer) = NULL;
void (GLAPIENTRY *glBindBufferOffsetEXT) (GLenum  target, GLuint  index, GLuint  buffer, GLintptr  offset) = NULL;
void (GLAPIENTRY *glBindBufferOffsetNV) (GLenum  target, GLuint  index, GLuint  buffer, GLintptr  offset) = NULL;
void (GLAPIENTRY *glBindBufferRange) (GLenum  target, GLuint  index, GLuint  buffer, GLintptr  offset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glBindBufferRangeEXT) (GLenum  target, GLuint  index, GLuint  buffer, GLintptr  offset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glBindBufferRangeNV) (GLenum  target, GLuint  index, GLuint  buffer, GLintptr  offset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glBindBuffersBase) (GLenum  target, GLuint  first, GLsizei  count, const GLuint * buffers) = NULL;
void (GLAPIENTRY *glBindBuffersRange) (GLenum  target, GLuint  first, GLsizei  count, const GLuint * buffers, const GLintptr * offsets, const GLsizeiptr * sizes) = NULL;
void (GLAPIENTRY *glBindFragDataLocation) (GLuint  program, GLuint  color, const GLchar * name) = NULL;
void (GLAPIENTRY *glBindFragDataLocationEXT) (GLuint  program, GLuint  color, const GLchar * name) = NULL;
void (GLAPIENTRY *glBindFragDataLocationIndexed) (GLuint  program, GLuint  colorNumber, GLuint  index, const GLchar * name) = NULL;
void (GLAPIENTRY *glBindFramebuffer) (GLenum  target, GLuint  framebuffer) = NULL;
void (GLAPIENTRY *glBindFramebufferEXT) (GLenum  target, GLuint  framebuffer) = NULL;
void (GLAPIENTRY *glBindImageTexture) (GLuint  unit, GLuint  texture, GLint  level, GLboolean  layered, GLint  layer, GLenum  access, GLenum  format) = NULL;
void (GLAPIENTRY *glBindImageTextureEXT) (GLuint  index, GLuint  texture, GLint  level, GLboolean  layered, GLint  layer, GLenum  access, GLint  format) = NULL;
void (GLAPIENTRY *glBindImageTextures) (GLuint  first, GLsizei  count, const GLuint * textures) = NULL;
GLuint (GLAPIENTRY *glBindLightParameterEXT) (GLenum  light, GLenum  value) = NULL;
GLuint (GLAPIENTRY *glBindMaterialParameterEXT) (GLenum  face, GLenum  value) = NULL;
void (GLAPIENTRY *glBindMultiTextureEXT) (GLenum  texunit, GLenum  target, GLuint  texture) = NULL;
GLuint (GLAPIENTRY *glBindParameterEXT) (GLenum  value) = NULL;
void (GLAPIENTRY *glBindProgramARB) (GLenum  target, GLuint  program) = NULL;
void (GLAPIENTRY *glBindProgramNV) (GLenum  target, GLuint  id) = NULL;
void (GLAPIENTRY *glBindProgramPipeline) (GLuint  pipeline) = NULL;
void (GLAPIENTRY *glBindProgramPipelineEXT) (GLuint  pipeline) = NULL;
void (GLAPIENTRY *glBindRenderbuffer) (GLenum  target, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glBindRenderbufferEXT) (GLenum  target, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glBindSampler) (GLuint  unit, GLuint  sampler) = NULL;
void (GLAPIENTRY *glBindSamplers) (GLuint  first, GLsizei  count, const GLuint * samplers) = NULL;
void (GLAPIENTRY *glBindShadingRateImageNV) (GLuint  texture) = NULL;
GLuint (GLAPIENTRY *glBindTexGenParameterEXT) (GLenum  unit, GLenum  coord, GLenum  value) = NULL;
void (GLAPIENTRY *glBindTexture) (GLenum  target, GLuint  texture) = NULL;
void (GLAPIENTRY *glBindTextureEXT) (GLenum  target, GLuint  texture) = NULL;
void (GLAPIENTRY *glBindTextureUnit) (GLuint  unit, GLuint  texture) = NULL;
GLuint (GLAPIENTRY *glBindTextureUnitParameterEXT) (GLenum  unit, GLenum  value) = NULL;
void (GLAPIENTRY *glBindTextures) (GLuint  first, GLsizei  count, const GLuint * textures) = NULL;
void (GLAPIENTRY *glBindTransformFeedback) (GLenum  target, GLuint  id) = NULL;
void (GLAPIENTRY *glBindTransformFeedbackNV) (GLenum  target, GLuint  id) = NULL;
void (GLAPIENTRY *glBindVertexArray) (GLuint  array) = NULL;
void (GLAPIENTRY *glBindVertexArrayAPPLE) (GLuint  array) = NULL;
void (GLAPIENTRY *glBindVertexBuffer) (GLuint  bindingindex, GLuint  buffer, GLintptr  offset, GLsizei  stride) = NULL;
void (GLAPIENTRY *glBindVertexBuffers) (GLuint  first, GLsizei  count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides) = NULL;
void (GLAPIENTRY *glBindVertexShaderEXT) (GLuint  id) = NULL;
void (GLAPIENTRY *glBindVideoCaptureStreamBufferNV) (GLuint  video_capture_slot, GLuint  stream, GLenum  frame_region, GLintptrARB  offset) = NULL;
void (GLAPIENTRY *glBindVideoCaptureStreamTextureNV) (GLuint  video_capture_slot, GLuint  stream, GLenum  frame_region, GLenum  target, GLuint  texture) = NULL;
void (GLAPIENTRY *glBinormal3bEXT) (GLbyte  bx, GLbyte  by, GLbyte  bz) = NULL;
void (GLAPIENTRY *glBinormal3bvEXT) (const GLbyte * v) = NULL;
void (GLAPIENTRY *glBinormal3dEXT) (GLdouble  bx, GLdouble  by, GLdouble  bz) = NULL;
void (GLAPIENTRY *glBinormal3dvEXT) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glBinormal3fEXT) (GLfloat  bx, GLfloat  by, GLfloat  bz) = NULL;
void (GLAPIENTRY *glBinormal3fvEXT) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glBinormal3iEXT) (GLint  bx, GLint  by, GLint  bz) = NULL;
void (GLAPIENTRY *glBinormal3ivEXT) (const GLint * v) = NULL;
void (GLAPIENTRY *glBinormal3sEXT) (GLshort  bx, GLshort  by, GLshort  bz) = NULL;
void (GLAPIENTRY *glBinormal3svEXT) (const GLshort * v) = NULL;
void (GLAPIENTRY *glBinormalPointerEXT) (GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glBitmap) (GLsizei  width, GLsizei  height, GLfloat  xorig, GLfloat  yorig, GLfloat  xmove, GLfloat  ymove, const GLubyte * bitmap) = NULL;
void (GLAPIENTRY *glBlendBarrierKHR) () = NULL;
void (GLAPIENTRY *glBlendBarrierNV) () = NULL;
void (GLAPIENTRY *glBlendColor) (GLfloat  red, GLfloat  green, GLfloat  blue, GLfloat  alpha) = NULL;
void (GLAPIENTRY *glBlendColorEXT) (GLfloat  red, GLfloat  green, GLfloat  blue, GLfloat  alpha) = NULL;
void (GLAPIENTRY *glBlendEquation) (GLenum  mode) = NULL;
void (GLAPIENTRY *glBlendEquationEXT) (GLenum  mode) = NULL;
void (GLAPIENTRY *glBlendEquationIndexedAMD) (GLuint  buf, GLenum  mode) = NULL;
void (GLAPIENTRY *glBlendEquationSeparate) (GLenum  modeRGB, GLenum  modeAlpha) = NULL;
void (GLAPIENTRY *glBlendEquationSeparateEXT) (GLenum  modeRGB, GLenum  modeAlpha) = NULL;
void (GLAPIENTRY *glBlendEquationSeparateIndexedAMD) (GLuint  buf, GLenum  modeRGB, GLenum  modeAlpha) = NULL;
void (GLAPIENTRY *glBlendEquationSeparatei) (GLuint  buf, GLenum  modeRGB, GLenum  modeAlpha) = NULL;
void (GLAPIENTRY *glBlendEquationSeparateiARB) (GLuint  buf, GLenum  modeRGB, GLenum  modeAlpha) = NULL;
void (GLAPIENTRY *glBlendEquationi) (GLuint  buf, GLenum  mode) = NULL;
void (GLAPIENTRY *glBlendEquationiARB) (GLuint  buf, GLenum  mode) = NULL;
void (GLAPIENTRY *glBlendFunc) (GLenum  sfactor, GLenum  dfactor) = NULL;
void (GLAPIENTRY *glBlendFuncIndexedAMD) (GLuint  buf, GLenum  src, GLenum  dst) = NULL;
void (GLAPIENTRY *glBlendFuncSeparate) (GLenum  sfactorRGB, GLenum  dfactorRGB, GLenum  sfactorAlpha, GLenum  dfactorAlpha) = NULL;
void (GLAPIENTRY *glBlendFuncSeparateEXT) (GLenum  sfactorRGB, GLenum  dfactorRGB, GLenum  sfactorAlpha, GLenum  dfactorAlpha) = NULL;
void (GLAPIENTRY *glBlendFuncSeparateIndexedAMD) (GLuint  buf, GLenum  srcRGB, GLenum  dstRGB, GLenum  srcAlpha, GLenum  dstAlpha) = NULL;
void (GLAPIENTRY *glBlendFuncSeparatei) (GLuint  buf, GLenum  srcRGB, GLenum  dstRGB, GLenum  srcAlpha, GLenum  dstAlpha) = NULL;
void (GLAPIENTRY *glBlendFuncSeparateiARB) (GLuint  buf, GLenum  srcRGB, GLenum  dstRGB, GLenum  srcAlpha, GLenum  dstAlpha) = NULL;
void (GLAPIENTRY *glBlendFunci) (GLuint  buf, GLenum  src, GLenum  dst) = NULL;
void (GLAPIENTRY *glBlendFunciARB) (GLuint  buf, GLenum  src, GLenum  dst) = NULL;
void (GLAPIENTRY *glBlendParameteriNV) (GLenum  pname, GLint  value) = NULL;
void (GLAPIENTRY *glBlitFramebuffer) (GLint  srcX0, GLint  srcY0, GLint  srcX1, GLint  srcY1, GLint  dstX0, GLint  dstY0, GLint  dstX1, GLint  dstY1, GLbitfield  mask, GLenum  filter) = NULL;
void (GLAPIENTRY *glBlitFramebufferEXT) (GLint  srcX0, GLint  srcY0, GLint  srcX1, GLint  srcY1, GLint  dstX0, GLint  dstY0, GLint  dstX1, GLint  dstY1, GLbitfield  mask, GLenum  filter) = NULL;
void (GLAPIENTRY *glBlitNamedFramebuffer) (GLuint  readFramebuffer, GLuint  drawFramebuffer, GLint  srcX0, GLint  srcY0, GLint  srcX1, GLint  srcY1, GLint  dstX0, GLint  dstY0, GLint  dstX1, GLint  dstY1, GLbitfield  mask, GLenum  filter) = NULL;
void (GLAPIENTRY *glBufferAddressRangeNV) (GLenum  pname, GLuint  index, GLuint64EXT  address, GLsizeiptr  length) = NULL;
void (GLAPIENTRY *glBufferAttachMemoryNV) (GLenum  target, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glBufferData) (GLenum  target, GLsizeiptr  size, const void * data, GLenum  usage) = NULL;
void (GLAPIENTRY *glBufferDataARB) (GLenum  target, GLsizeiptrARB  size, const void * data, GLenum  usage) = NULL;
void (GLAPIENTRY *glBufferPageCommitmentARB) (GLenum  target, GLintptr  offset, GLsizeiptr  size, GLboolean  commit) = NULL;
void (GLAPIENTRY *glBufferParameteriAPPLE) (GLenum  target, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glBufferStorage) (GLenum  target, GLsizeiptr  size, const void * data, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glBufferStorageExternalEXT) (GLenum  target, GLintptr  offset, GLsizeiptr  size, GLeglClientBufferEXT  clientBuffer, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glBufferStorageMemEXT) (GLenum  target, GLsizeiptr  size, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glBufferSubData) (GLenum  target, GLintptr  offset, GLsizeiptr  size, const void * data) = NULL;
void (GLAPIENTRY *glBufferSubDataARB) (GLenum  target, GLintptrARB  offset, GLsizeiptrARB  size, const void * data) = NULL;
void (GLAPIENTRY *glCallCommandListNV) (GLuint  list) = NULL;
void (GLAPIENTRY *glCallList) (GLuint  list) = NULL;
void (GLAPIENTRY *glCallLists) (GLsizei  n, GLenum  type, const void * lists) = NULL;
GLenum (GLAPIENTRY *glCheckFramebufferStatus) (GLenum  target) = NULL;
GLenum (GLAPIENTRY *glCheckFramebufferStatusEXT) (GLenum  target) = NULL;
GLenum (GLAPIENTRY *glCheckNamedFramebufferStatus) (GLuint  framebuffer, GLenum  target) = NULL;
GLenum (GLAPIENTRY *glCheckNamedFramebufferStatusEXT) (GLuint  framebuffer, GLenum  target) = NULL;
void (GLAPIENTRY *glClampColor) (GLenum  target, GLenum  clamp) = NULL;
void (GLAPIENTRY *glClampColorARB) (GLenum  target, GLenum  clamp) = NULL;
void (GLAPIENTRY *glClear) (GLbitfield  mask) = NULL;
void (GLAPIENTRY *glClearAccum) (GLfloat  red, GLfloat  green, GLfloat  blue, GLfloat  alpha) = NULL;
void (GLAPIENTRY *glClearBufferData) (GLenum  target, GLenum  internalformat, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glClearBufferSubData) (GLenum  target, GLenum  internalformat, GLintptr  offset, GLsizeiptr  size, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glClearBufferfi) (GLenum  buffer, GLint  drawbuffer, GLfloat  depth, GLint  stencil) = NULL;
void (GLAPIENTRY *glClearBufferfv) (GLenum  buffer, GLint  drawbuffer, const GLfloat * value) = NULL;
void (GLAPIENTRY *glClearBufferiv) (GLenum  buffer, GLint  drawbuffer, const GLint * value) = NULL;
void (GLAPIENTRY *glClearBufferuiv) (GLenum  buffer, GLint  drawbuffer, const GLuint * value) = NULL;
void (GLAPIENTRY *glClearColor) (GLfloat  red, GLfloat  green, GLfloat  blue, GLfloat  alpha) = NULL;
void (GLAPIENTRY *glClearColorIiEXT) (GLint  red, GLint  green, GLint  blue, GLint  alpha) = NULL;
void (GLAPIENTRY *glClearColorIuiEXT) (GLuint  red, GLuint  green, GLuint  blue, GLuint  alpha) = NULL;
void (GLAPIENTRY *glClearDepth) (GLdouble  depth) = NULL;
void (GLAPIENTRY *glClearDepthdNV) (GLdouble  depth) = NULL;
void (GLAPIENTRY *glClearDepthf) (GLfloat  d) = NULL;
void (GLAPIENTRY *glClearIndex) (GLfloat  c) = NULL;
void (GLAPIENTRY *glClearNamedBufferData) (GLuint  buffer, GLenum  internalformat, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glClearNamedBufferDataEXT) (GLuint  buffer, GLenum  internalformat, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glClearNamedBufferSubData) (GLuint  buffer, GLenum  internalformat, GLintptr  offset, GLsizeiptr  size, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glClearNamedBufferSubDataEXT) (GLuint  buffer, GLenum  internalformat, GLsizeiptr  offset, GLsizeiptr  size, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glClearNamedFramebufferfi) (GLuint  framebuffer, GLenum  buffer, GLint  drawbuffer, GLfloat  depth, GLint  stencil) = NULL;
void (GLAPIENTRY *glClearNamedFramebufferfv) (GLuint  framebuffer, GLenum  buffer, GLint  drawbuffer, const GLfloat * value) = NULL;
void (GLAPIENTRY *glClearNamedFramebufferiv) (GLuint  framebuffer, GLenum  buffer, GLint  drawbuffer, const GLint * value) = NULL;
void (GLAPIENTRY *glClearNamedFramebufferuiv) (GLuint  framebuffer, GLenum  buffer, GLint  drawbuffer, const GLuint * value) = NULL;
void (GLAPIENTRY *glClearStencil) (GLint  s) = NULL;
void (GLAPIENTRY *glClearTexImage) (GLuint  texture, GLint  level, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glClearTexSubImage) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glClientActiveTexture) (GLenum  texture) = NULL;
void (GLAPIENTRY *glClientActiveTextureARB) (GLenum  texture) = NULL;
void (GLAPIENTRY *glClientAttribDefaultEXT) (GLbitfield  mask) = NULL;
GLenum (GLAPIENTRY *glClientWaitSync) (GLsync  sync, GLbitfield  flags, GLuint64  timeout) = NULL;
void (GLAPIENTRY *glClipControl) (GLenum  origin, GLenum  depth) = NULL;
void (GLAPIENTRY *glClipPlane) (GLenum  plane, const GLdouble * equation) = NULL;
void (GLAPIENTRY *glColor3b) (GLbyte  red, GLbyte  green, GLbyte  blue) = NULL;
void (GLAPIENTRY *glColor3bv) (const GLbyte * v) = NULL;
void (GLAPIENTRY *glColor3d) (GLdouble  red, GLdouble  green, GLdouble  blue) = NULL;
void (GLAPIENTRY *glColor3dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glColor3f) (GLfloat  red, GLfloat  green, GLfloat  blue) = NULL;
void (GLAPIENTRY *glColor3fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glColor3hNV) (GLhalfNV  red, GLhalfNV  green, GLhalfNV  blue) = NULL;
void (GLAPIENTRY *glColor3hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glColor3i) (GLint  red, GLint  green, GLint  blue) = NULL;
void (GLAPIENTRY *glColor3iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glColor3s) (GLshort  red, GLshort  green, GLshort  blue) = NULL;
void (GLAPIENTRY *glColor3sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glColor3ub) (GLubyte  red, GLubyte  green, GLubyte  blue) = NULL;
void (GLAPIENTRY *glColor3ubv) (const GLubyte * v) = NULL;
void (GLAPIENTRY *glColor3ui) (GLuint  red, GLuint  green, GLuint  blue) = NULL;
void (GLAPIENTRY *glColor3uiv) (const GLuint * v) = NULL;
void (GLAPIENTRY *glColor3us) (GLushort  red, GLushort  green, GLushort  blue) = NULL;
void (GLAPIENTRY *glColor3usv) (const GLushort * v) = NULL;
void (GLAPIENTRY *glColor4b) (GLbyte  red, GLbyte  green, GLbyte  blue, GLbyte  alpha) = NULL;
void (GLAPIENTRY *glColor4bv) (const GLbyte * v) = NULL;
void (GLAPIENTRY *glColor4d) (GLdouble  red, GLdouble  green, GLdouble  blue, GLdouble  alpha) = NULL;
void (GLAPIENTRY *glColor4dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glColor4f) (GLfloat  red, GLfloat  green, GLfloat  blue, GLfloat  alpha) = NULL;
void (GLAPIENTRY *glColor4fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glColor4hNV) (GLhalfNV  red, GLhalfNV  green, GLhalfNV  blue, GLhalfNV  alpha) = NULL;
void (GLAPIENTRY *glColor4hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glColor4i) (GLint  red, GLint  green, GLint  blue, GLint  alpha) = NULL;
void (GLAPIENTRY *glColor4iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glColor4s) (GLshort  red, GLshort  green, GLshort  blue, GLshort  alpha) = NULL;
void (GLAPIENTRY *glColor4sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glColor4ub) (GLubyte  red, GLubyte  green, GLubyte  blue, GLubyte  alpha) = NULL;
void (GLAPIENTRY *glColor4ubv) (const GLubyte * v) = NULL;
void (GLAPIENTRY *glColor4ui) (GLuint  red, GLuint  green, GLuint  blue, GLuint  alpha) = NULL;
void (GLAPIENTRY *glColor4uiv) (const GLuint * v) = NULL;
void (GLAPIENTRY *glColor4us) (GLushort  red, GLushort  green, GLushort  blue, GLushort  alpha) = NULL;
void (GLAPIENTRY *glColor4usv) (const GLushort * v) = NULL;
void (GLAPIENTRY *glColorFormatNV) (GLint  size, GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glColorMask) (GLboolean  red, GLboolean  green, GLboolean  blue, GLboolean  alpha) = NULL;
void (GLAPIENTRY *glColorMaskIndexedEXT) (GLuint  index, GLboolean  r, GLboolean  g, GLboolean  b, GLboolean  a) = NULL;
void (GLAPIENTRY *glColorMaski) (GLuint  index, GLboolean  r, GLboolean  g, GLboolean  b, GLboolean  a) = NULL;
void (GLAPIENTRY *glColorMaterial) (GLenum  face, GLenum  mode) = NULL;
void (GLAPIENTRY *glColorP3ui) (GLenum  type, GLuint  color) = NULL;
void (GLAPIENTRY *glColorP3uiv) (GLenum  type, const GLuint * color) = NULL;
void (GLAPIENTRY *glColorP4ui) (GLenum  type, GLuint  color) = NULL;
void (GLAPIENTRY *glColorP4uiv) (GLenum  type, const GLuint * color) = NULL;
void (GLAPIENTRY *glColorPointer) (GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glColorPointerEXT) (GLint  size, GLenum  type, GLsizei  stride, GLsizei  count, const void * pointer) = NULL;
void (GLAPIENTRY *glColorPointervINTEL) (GLint  size, GLenum  type, const void ** pointer) = NULL;
void (GLAPIENTRY *glColorSubTable) (GLenum  target, GLsizei  start, GLsizei  count, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glColorSubTableEXT) (GLenum  target, GLsizei  start, GLsizei  count, GLenum  format, GLenum  type, const void * data) = NULL;
void (GLAPIENTRY *glColorTable) (GLenum  target, GLenum  internalformat, GLsizei  width, GLenum  format, GLenum  type, const void * table) = NULL;
void (GLAPIENTRY *glColorTableEXT) (GLenum  target, GLenum  internalFormat, GLsizei  width, GLenum  format, GLenum  type, const void * table) = NULL;
void (GLAPIENTRY *glColorTableParameterfv) (GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glColorTableParameteriv) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glCombinerInputNV) (GLenum  stage, GLenum  portion, GLenum  variable, GLenum  input, GLenum  mapping, GLenum  componentUsage) = NULL;
void (GLAPIENTRY *glCombinerOutputNV) (GLenum  stage, GLenum  portion, GLenum  abOutput, GLenum  cdOutput, GLenum  sumOutput, GLenum  scale, GLenum  bias, GLboolean  abDotProduct, GLboolean  cdDotProduct, GLboolean  muxSum) = NULL;
void (GLAPIENTRY *glCombinerParameterfNV) (GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glCombinerParameterfvNV) (GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glCombinerParameteriNV) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glCombinerParameterivNV) (GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glCombinerStageParameterfvNV) (GLenum  stage, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glCommandListSegmentsNV) (GLuint  list, GLuint  segments) = NULL;
void (GLAPIENTRY *glCompileCommandListNV) (GLuint  list) = NULL;
void (GLAPIENTRY *glCompileShader) (GLuint  shader) = NULL;
void (GLAPIENTRY *glCompileShaderARB) (GLhandleARB  shaderObj) = NULL;
void (GLAPIENTRY *glCompileShaderIncludeARB) (GLuint  shader, GLsizei  count, const GLchar *const* path, const GLint * length) = NULL;
void (GLAPIENTRY *glCompressedMultiTexImage1DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLint  border, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedMultiTexImage2DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLint  border, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedMultiTexImage3DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLint  border, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedMultiTexSubImage1DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedMultiTexSubImage2DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedMultiTexSubImage3DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedTexImage1D) (GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLint  border, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexImage1DARB) (GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLint  border, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexImage2D) (GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLint  border, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexImage2DARB) (GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLint  border, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexImage3D) (GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLint  border, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexImage3DARB) (GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLint  border, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexSubImage1D) (GLenum  target, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexSubImage1DARB) (GLenum  target, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexSubImage2D) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexSubImage2DARB) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexSubImage3D) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTexSubImage3DARB) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTextureImage1DEXT) (GLuint  texture, GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLint  border, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedTextureImage2DEXT) (GLuint  texture, GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLint  border, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedTextureImage3DEXT) (GLuint  texture, GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLint  border, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedTextureSubImage1D) (GLuint  texture, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTextureSubImage1DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedTextureSubImage2D) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTextureSubImage2DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glCompressedTextureSubImage3D) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLsizei  imageSize, const void * data) = NULL;
void (GLAPIENTRY *glCompressedTextureSubImage3DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLsizei  imageSize, const void * bits) = NULL;
void (GLAPIENTRY *glConservativeRasterParameterfNV) (GLenum  pname, GLfloat  value) = NULL;
void (GLAPIENTRY *glConservativeRasterParameteriNV) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glConvolutionFilter1D) (GLenum  target, GLenum  internalformat, GLsizei  width, GLenum  format, GLenum  type, const void * image) = NULL;
void (GLAPIENTRY *glConvolutionFilter1DEXT) (GLenum  target, GLenum  internalformat, GLsizei  width, GLenum  format, GLenum  type, const void * image) = NULL;
void (GLAPIENTRY *glConvolutionFilter2D) (GLenum  target, GLenum  internalformat, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * image) = NULL;
void (GLAPIENTRY *glConvolutionFilter2DEXT) (GLenum  target, GLenum  internalformat, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * image) = NULL;
void (GLAPIENTRY *glConvolutionParameterf) (GLenum  target, GLenum  pname, GLfloat  params) = NULL;
void (GLAPIENTRY *glConvolutionParameterfEXT) (GLenum  target, GLenum  pname, GLfloat  params) = NULL;
void (GLAPIENTRY *glConvolutionParameterfv) (GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glConvolutionParameterfvEXT) (GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glConvolutionParameteri) (GLenum  target, GLenum  pname, GLint  params) = NULL;
void (GLAPIENTRY *glConvolutionParameteriEXT) (GLenum  target, GLenum  pname, GLint  params) = NULL;
void (GLAPIENTRY *glConvolutionParameteriv) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glConvolutionParameterivEXT) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glCopyBufferSubData) (GLenum  readTarget, GLenum  writeTarget, GLintptr  readOffset, GLintptr  writeOffset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glCopyColorSubTable) (GLenum  target, GLsizei  start, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyColorSubTableEXT) (GLenum  target, GLsizei  start, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyColorTable) (GLenum  target, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyConvolutionFilter1D) (GLenum  target, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyConvolutionFilter1DEXT) (GLenum  target, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyConvolutionFilter2D) (GLenum  target, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyConvolutionFilter2DEXT) (GLenum  target, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyImageSubData) (GLuint  srcName, GLenum  srcTarget, GLint  srcLevel, GLint  srcX, GLint  srcY, GLint  srcZ, GLuint  dstName, GLenum  dstTarget, GLint  dstLevel, GLint  dstX, GLint  dstY, GLint  dstZ, GLsizei  srcWidth, GLsizei  srcHeight, GLsizei  srcDepth) = NULL;
void (GLAPIENTRY *glCopyImageSubDataNV) (GLuint  srcName, GLenum  srcTarget, GLint  srcLevel, GLint  srcX, GLint  srcY, GLint  srcZ, GLuint  dstName, GLenum  dstTarget, GLint  dstLevel, GLint  dstX, GLint  dstY, GLint  dstZ, GLsizei  width, GLsizei  height, GLsizei  depth) = NULL;
void (GLAPIENTRY *glCopyMultiTexImage1DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLint  border) = NULL;
void (GLAPIENTRY *glCopyMultiTexImage2DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLint  border) = NULL;
void (GLAPIENTRY *glCopyMultiTexSubImage1DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyMultiTexSubImage2DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyMultiTexSubImage3DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyNamedBufferSubData) (GLuint  readBuffer, GLuint  writeBuffer, GLintptr  readOffset, GLintptr  writeOffset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glCopyPathNV) (GLuint  resultPath, GLuint  srcPath) = NULL;
void (GLAPIENTRY *glCopyPixels) (GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLenum  type) = NULL;
void (GLAPIENTRY *glCopyTexImage1D) (GLenum  target, GLint  level, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLint  border) = NULL;
void (GLAPIENTRY *glCopyTexImage1DEXT) (GLenum  target, GLint  level, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLint  border) = NULL;
void (GLAPIENTRY *glCopyTexImage2D) (GLenum  target, GLint  level, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLint  border) = NULL;
void (GLAPIENTRY *glCopyTexImage2DEXT) (GLenum  target, GLint  level, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLint  border) = NULL;
void (GLAPIENTRY *glCopyTexSubImage1D) (GLenum  target, GLint  level, GLint  xoffset, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyTexSubImage1DEXT) (GLenum  target, GLint  level, GLint  xoffset, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyTexSubImage2D) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyTexSubImage2DEXT) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyTexSubImage3D) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyTexSubImage3DEXT) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyTextureImage1DEXT) (GLuint  texture, GLenum  target, GLint  level, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLint  border) = NULL;
void (GLAPIENTRY *glCopyTextureImage2DEXT) (GLuint  texture, GLenum  target, GLint  level, GLenum  internalformat, GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLint  border) = NULL;
void (GLAPIENTRY *glCopyTextureSubImage1D) (GLuint  texture, GLint  level, GLint  xoffset, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyTextureSubImage1DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLint  x, GLint  y, GLsizei  width) = NULL;
void (GLAPIENTRY *glCopyTextureSubImage2D) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyTextureSubImage2DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyTextureSubImage3D) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCopyTextureSubImage3DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glCoverFillPathInstancedNV) (GLsizei  numPaths, GLenum  pathNameType, const void * paths, GLuint  pathBase, GLenum  coverMode, GLenum  transformType, const GLfloat * transformValues) = NULL;
void (GLAPIENTRY *glCoverFillPathNV) (GLuint  path, GLenum  coverMode) = NULL;
void (GLAPIENTRY *glCoverStrokePathInstancedNV) (GLsizei  numPaths, GLenum  pathNameType, const void * paths, GLuint  pathBase, GLenum  coverMode, GLenum  transformType, const GLfloat * transformValues) = NULL;
void (GLAPIENTRY *glCoverStrokePathNV) (GLuint  path, GLenum  coverMode) = NULL;
void (GLAPIENTRY *glCoverageModulationNV) (GLenum  components) = NULL;
void (GLAPIENTRY *glCoverageModulationTableNV) (GLsizei  n, const GLfloat * v) = NULL;
void (GLAPIENTRY *glCreateBuffers) (GLsizei  n, GLuint * buffers) = NULL;
void (GLAPIENTRY *glCreateCommandListsNV) (GLsizei  n, GLuint * lists) = NULL;
void (GLAPIENTRY *glCreateFramebuffers) (GLsizei  n, GLuint * framebuffers) = NULL;
void (GLAPIENTRY *glCreateMemoryObjectsEXT) (GLsizei  n, GLuint * memoryObjects) = NULL;
void (GLAPIENTRY *glCreatePerfQueryINTEL) (GLuint  queryId, GLuint * queryHandle) = NULL;
GLuint (GLAPIENTRY *glCreateProgram) () = NULL;
GLhandleARB (GLAPIENTRY *glCreateProgramObjectARB) () = NULL;
void (GLAPIENTRY *glCreateProgramPipelines) (GLsizei  n, GLuint * pipelines) = NULL;
void (GLAPIENTRY *glCreateQueries) (GLenum  target, GLsizei  n, GLuint * ids) = NULL;
void (GLAPIENTRY *glCreateRenderbuffers) (GLsizei  n, GLuint * renderbuffers) = NULL;
void (GLAPIENTRY *glCreateSamplers) (GLsizei  n, GLuint * samplers) = NULL;
GLuint (GLAPIENTRY *glCreateShader) (GLenum  type) = NULL;
GLhandleARB (GLAPIENTRY *glCreateShaderObjectARB) (GLenum  shaderType) = NULL;
GLuint (GLAPIENTRY *glCreateShaderProgramEXT) (GLenum  type, const GLchar * string) = NULL;
GLuint (GLAPIENTRY *glCreateShaderProgramv) (GLenum  type, GLsizei  count, const GLchar *const* strings) = NULL;
GLuint (GLAPIENTRY *glCreateShaderProgramvEXT) (GLenum  type, GLsizei  count, const GLchar ** strings) = NULL;
void (GLAPIENTRY *glCreateStatesNV) (GLsizei  n, GLuint * states) = NULL;
GLsync (GLAPIENTRY *glCreateSyncFromCLeventARB) (struct _cl_context * context, struct _cl_event * event, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glCreateTextures) (GLenum  target, GLsizei  n, GLuint * textures) = NULL;
void (GLAPIENTRY *glCreateTransformFeedbacks) (GLsizei  n, GLuint * ids) = NULL;
void (GLAPIENTRY *glCreateVertexArrays) (GLsizei  n, GLuint * arrays) = NULL;
void (GLAPIENTRY *glCullFace) (GLenum  mode) = NULL;
void (GLAPIENTRY *glCullParameterdvEXT) (GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glCullParameterfvEXT) (GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glCurrentPaletteMatrixARB) (GLint  index) = NULL;
void (GLAPIENTRY *glDebugMessageCallback) (GLDEBUGPROC  callback, const void * userParam) = NULL;
void (GLAPIENTRY *glDebugMessageCallbackAMD) (GLDEBUGPROCAMD  callback, void * userParam) = NULL;
void (GLAPIENTRY *glDebugMessageCallbackARB) (GLDEBUGPROCARB  callback, const void * userParam) = NULL;
void (GLAPIENTRY *glDebugMessageCallbackKHR) (GLDEBUGPROCKHR  callback, const void * userParam) = NULL;
void (GLAPIENTRY *glDebugMessageControl) (GLenum  source, GLenum  type, GLenum  severity, GLsizei  count, const GLuint * ids, GLboolean  enabled) = NULL;
void (GLAPIENTRY *glDebugMessageControlARB) (GLenum  source, GLenum  type, GLenum  severity, GLsizei  count, const GLuint * ids, GLboolean  enabled) = NULL;
void (GLAPIENTRY *glDebugMessageControlKHR) (GLenum  source, GLenum  type, GLenum  severity, GLsizei  count, const GLuint * ids, GLboolean  enabled) = NULL;
void (GLAPIENTRY *glDebugMessageEnableAMD) (GLenum  category, GLenum  severity, GLsizei  count, const GLuint * ids, GLboolean  enabled) = NULL;
void (GLAPIENTRY *glDebugMessageInsert) (GLenum  source, GLenum  type, GLuint  id, GLenum  severity, GLsizei  length, const GLchar * buf) = NULL;
void (GLAPIENTRY *glDebugMessageInsertAMD) (GLenum  category, GLenum  severity, GLuint  id, GLsizei  length, const GLchar * buf) = NULL;
void (GLAPIENTRY *glDebugMessageInsertARB) (GLenum  source, GLenum  type, GLuint  id, GLenum  severity, GLsizei  length, const GLchar * buf) = NULL;
void (GLAPIENTRY *glDebugMessageInsertKHR) (GLenum  source, GLenum  type, GLuint  id, GLenum  severity, GLsizei  length, const GLchar * buf) = NULL;
void (GLAPIENTRY *glDeleteBuffers) (GLsizei  n, const GLuint * buffers) = NULL;
void (GLAPIENTRY *glDeleteBuffersARB) (GLsizei  n, const GLuint * buffers) = NULL;
void (GLAPIENTRY *glDeleteCommandListsNV) (GLsizei  n, const GLuint * lists) = NULL;
void (GLAPIENTRY *glDeleteFencesAPPLE) (GLsizei  n, const GLuint * fences) = NULL;
void (GLAPIENTRY *glDeleteFencesNV) (GLsizei  n, const GLuint * fences) = NULL;
void (GLAPIENTRY *glDeleteFramebuffers) (GLsizei  n, const GLuint * framebuffers) = NULL;
void (GLAPIENTRY *glDeleteFramebuffersEXT) (GLsizei  n, const GLuint * framebuffers) = NULL;
void (GLAPIENTRY *glDeleteLists) (GLuint  list, GLsizei  range) = NULL;
void (GLAPIENTRY *glDeleteMemoryObjectsEXT) (GLsizei  n, const GLuint * memoryObjects) = NULL;
void (GLAPIENTRY *glDeleteNamedStringARB) (GLint  namelen, const GLchar * name) = NULL;
void (GLAPIENTRY *glDeleteNamesAMD) (GLenum  identifier, GLuint  num, const GLuint * names) = NULL;
void (GLAPIENTRY *glDeleteObjectARB) (GLhandleARB  obj) = NULL;
void (GLAPIENTRY *glDeleteOcclusionQueriesNV) (GLsizei  n, const GLuint * ids) = NULL;
void (GLAPIENTRY *glDeletePathsNV) (GLuint  path, GLsizei  range) = NULL;
void (GLAPIENTRY *glDeletePerfMonitorsAMD) (GLsizei  n, GLuint * monitors) = NULL;
void (GLAPIENTRY *glDeletePerfQueryINTEL) (GLuint  queryHandle) = NULL;
void (GLAPIENTRY *glDeleteProgram) (GLuint  program) = NULL;
void (GLAPIENTRY *glDeleteProgramPipelines) (GLsizei  n, const GLuint * pipelines) = NULL;
void (GLAPIENTRY *glDeleteProgramPipelinesEXT) (GLsizei  n, const GLuint * pipelines) = NULL;
void (GLAPIENTRY *glDeleteProgramsARB) (GLsizei  n, const GLuint * programs) = NULL;
void (GLAPIENTRY *glDeleteProgramsNV) (GLsizei  n, const GLuint * programs) = NULL;
void (GLAPIENTRY *glDeleteQueries) (GLsizei  n, const GLuint * ids) = NULL;
void (GLAPIENTRY *glDeleteQueriesARB) (GLsizei  n, const GLuint * ids) = NULL;
void (GLAPIENTRY *glDeleteQueryResourceTagNV) (GLsizei  n, const GLint * tagIds) = NULL;
void (GLAPIENTRY *glDeleteRenderbuffers) (GLsizei  n, const GLuint * renderbuffers) = NULL;
void (GLAPIENTRY *glDeleteRenderbuffersEXT) (GLsizei  n, const GLuint * renderbuffers) = NULL;
void (GLAPIENTRY *glDeleteSamplers) (GLsizei  count, const GLuint * samplers) = NULL;
void (GLAPIENTRY *glDeleteSemaphoresEXT) (GLsizei  n, const GLuint * semaphores) = NULL;
void (GLAPIENTRY *glDeleteShader) (GLuint  shader) = NULL;
void (GLAPIENTRY *glDeleteStatesNV) (GLsizei  n, const GLuint * states) = NULL;
void (GLAPIENTRY *glDeleteSync) (GLsync  sync) = NULL;
void (GLAPIENTRY *glDeleteTextures) (GLsizei  n, const GLuint * textures) = NULL;
void (GLAPIENTRY *glDeleteTexturesEXT) (GLsizei  n, const GLuint * textures) = NULL;
void (GLAPIENTRY *glDeleteTransformFeedbacks) (GLsizei  n, const GLuint * ids) = NULL;
void (GLAPIENTRY *glDeleteTransformFeedbacksNV) (GLsizei  n, const GLuint * ids) = NULL;
void (GLAPIENTRY *glDeleteVertexArrays) (GLsizei  n, const GLuint * arrays) = NULL;
void (GLAPIENTRY *glDeleteVertexArraysAPPLE) (GLsizei  n, const GLuint * arrays) = NULL;
void (GLAPIENTRY *glDeleteVertexShaderEXT) (GLuint  id) = NULL;
void (GLAPIENTRY *glDepthBoundsEXT) (GLclampd  zmin, GLclampd  zmax) = NULL;
void (GLAPIENTRY *glDepthBoundsdNV) (GLdouble  zmin, GLdouble  zmax) = NULL;
void (GLAPIENTRY *glDepthFunc) (GLenum  func) = NULL;
void (GLAPIENTRY *glDepthMask) (GLboolean  flag) = NULL;
void (GLAPIENTRY *glDepthRange) (GLdouble  n, GLdouble  f) = NULL;
void (GLAPIENTRY *glDepthRangeArraydvNV) (GLuint  first, GLsizei  count, const GLdouble * v) = NULL;
void (GLAPIENTRY *glDepthRangeArrayv) (GLuint  first, GLsizei  count, const GLdouble * v) = NULL;
void (GLAPIENTRY *glDepthRangeIndexed) (GLuint  index, GLdouble  n, GLdouble  f) = NULL;
void (GLAPIENTRY *glDepthRangeIndexeddNV) (GLuint  index, GLdouble  n, GLdouble  f) = NULL;
void (GLAPIENTRY *glDepthRangedNV) (GLdouble  zNear, GLdouble  zFar) = NULL;
void (GLAPIENTRY *glDepthRangef) (GLfloat  n, GLfloat  f) = NULL;
void (GLAPIENTRY *glDetachObjectARB) (GLhandleARB  containerObj, GLhandleARB  attachedObj) = NULL;
void (GLAPIENTRY *glDetachShader) (GLuint  program, GLuint  shader) = NULL;
void (GLAPIENTRY *glDisable) (GLenum  cap) = NULL;
void (GLAPIENTRY *glDisableClientState) (GLenum  array) = NULL;
void (GLAPIENTRY *glDisableClientStateIndexedEXT) (GLenum  array, GLuint  index) = NULL;
void (GLAPIENTRY *glDisableClientStateiEXT) (GLenum  array, GLuint  index) = NULL;
void (GLAPIENTRY *glDisableIndexedEXT) (GLenum  target, GLuint  index) = NULL;
void (GLAPIENTRY *glDisableVariantClientStateEXT) (GLuint  id) = NULL;
void (GLAPIENTRY *glDisableVertexArrayAttrib) (GLuint  vaobj, GLuint  index) = NULL;
void (GLAPIENTRY *glDisableVertexArrayAttribEXT) (GLuint  vaobj, GLuint  index) = NULL;
void (GLAPIENTRY *glDisableVertexArrayEXT) (GLuint  vaobj, GLenum  array) = NULL;
void (GLAPIENTRY *glDisableVertexAttribAPPLE) (GLuint  index, GLenum  pname) = NULL;
void (GLAPIENTRY *glDisableVertexAttribArray) (GLuint  index) = NULL;
void (GLAPIENTRY *glDisableVertexAttribArrayARB) (GLuint  index) = NULL;
void (GLAPIENTRY *glDisablei) (GLenum  target, GLuint  index) = NULL;
void (GLAPIENTRY *glDispatchCompute) (GLuint  num_groups_x, GLuint  num_groups_y, GLuint  num_groups_z) = NULL;
void (GLAPIENTRY *glDispatchComputeGroupSizeARB) (GLuint  num_groups_x, GLuint  num_groups_y, GLuint  num_groups_z, GLuint  group_size_x, GLuint  group_size_y, GLuint  group_size_z) = NULL;
void (GLAPIENTRY *glDispatchComputeIndirect) (GLintptr  indirect) = NULL;
void (GLAPIENTRY *glDrawArrays) (GLenum  mode, GLint  first, GLsizei  count) = NULL;
void (GLAPIENTRY *glDrawArraysEXT) (GLenum  mode, GLint  first, GLsizei  count) = NULL;
void (GLAPIENTRY *glDrawArraysIndirect) (GLenum  mode, const void * indirect) = NULL;
void (GLAPIENTRY *glDrawArraysInstanced) (GLenum  mode, GLint  first, GLsizei  count, GLsizei  instancecount) = NULL;
void (GLAPIENTRY *glDrawArraysInstancedARB) (GLenum  mode, GLint  first, GLsizei  count, GLsizei  primcount) = NULL;
void (GLAPIENTRY *glDrawArraysInstancedBaseInstance) (GLenum  mode, GLint  first, GLsizei  count, GLsizei  instancecount, GLuint  baseinstance) = NULL;
void (GLAPIENTRY *glDrawArraysInstancedEXT) (GLenum  mode, GLint  start, GLsizei  count, GLsizei  primcount) = NULL;
void (GLAPIENTRY *glDrawBuffer) (GLenum  buf) = NULL;
void (GLAPIENTRY *glDrawBuffers) (GLsizei  n, const GLenum * bufs) = NULL;
void (GLAPIENTRY *glDrawBuffersARB) (GLsizei  n, const GLenum * bufs) = NULL;
void (GLAPIENTRY *glDrawCommandsAddressNV) (GLenum  primitiveMode, const GLuint64 * indirects, const GLsizei * sizes, GLuint  count) = NULL;
void (GLAPIENTRY *glDrawCommandsNV) (GLenum  primitiveMode, GLuint  buffer, const GLintptr * indirects, const GLsizei * sizes, GLuint  count) = NULL;
void (GLAPIENTRY *glDrawCommandsStatesAddressNV) (const GLuint64 * indirects, const GLsizei * sizes, const GLuint * states, const GLuint * fbos, GLuint  count) = NULL;
void (GLAPIENTRY *glDrawCommandsStatesNV) (GLuint  buffer, const GLintptr * indirects, const GLsizei * sizes, const GLuint * states, const GLuint * fbos, GLuint  count) = NULL;
void (GLAPIENTRY *glDrawElementArrayAPPLE) (GLenum  mode, GLint  first, GLsizei  count) = NULL;
void (GLAPIENTRY *glDrawElements) (GLenum  mode, GLsizei  count, GLenum  type, const void * indices) = NULL;
void (GLAPIENTRY *glDrawElementsBaseVertex) (GLenum  mode, GLsizei  count, GLenum  type, const void * indices, GLint  basevertex) = NULL;
void (GLAPIENTRY *glDrawElementsIndirect) (GLenum  mode, GLenum  type, const void * indirect) = NULL;
void (GLAPIENTRY *glDrawElementsInstanced) (GLenum  mode, GLsizei  count, GLenum  type, const void * indices, GLsizei  instancecount) = NULL;
void (GLAPIENTRY *glDrawElementsInstancedARB) (GLenum  mode, GLsizei  count, GLenum  type, const void * indices, GLsizei  primcount) = NULL;
void (GLAPIENTRY *glDrawElementsInstancedBaseInstance) (GLenum  mode, GLsizei  count, GLenum  type, const void * indices, GLsizei  instancecount, GLuint  baseinstance) = NULL;
void (GLAPIENTRY *glDrawElementsInstancedBaseVertex) (GLenum  mode, GLsizei  count, GLenum  type, const void * indices, GLsizei  instancecount, GLint  basevertex) = NULL;
void (GLAPIENTRY *glDrawElementsInstancedBaseVertexBaseInstance) (GLenum  mode, GLsizei  count, GLenum  type, const void * indices, GLsizei  instancecount, GLint  basevertex, GLuint  baseinstance) = NULL;
void (GLAPIENTRY *glDrawElementsInstancedEXT) (GLenum  mode, GLsizei  count, GLenum  type, const void * indices, GLsizei  primcount) = NULL;
void (GLAPIENTRY *glDrawMeshTasksNV) (GLuint  first, GLuint  count) = NULL;
void (GLAPIENTRY *glDrawMeshTasksIndirectNV) (GLintptr  indirect) = NULL;
void (GLAPIENTRY *glDrawPixels) (GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glDrawRangeElementArrayAPPLE) (GLenum  mode, GLuint  start, GLuint  end, GLint  first, GLsizei  count) = NULL;
void (GLAPIENTRY *glDrawRangeElements) (GLenum  mode, GLuint  start, GLuint  end, GLsizei  count, GLenum  type, const void * indices) = NULL;
void (GLAPIENTRY *glDrawRangeElementsBaseVertex) (GLenum  mode, GLuint  start, GLuint  end, GLsizei  count, GLenum  type, const void * indices, GLint  basevertex) = NULL;
void (GLAPIENTRY *glDrawRangeElementsEXT) (GLenum  mode, GLuint  start, GLuint  end, GLsizei  count, GLenum  type, const void * indices) = NULL;
void (GLAPIENTRY *glDrawTextureNV) (GLuint  texture, GLuint  sampler, GLfloat  x0, GLfloat  y0, GLfloat  x1, GLfloat  y1, GLfloat  z, GLfloat  s0, GLfloat  t0, GLfloat  s1, GLfloat  t1) = NULL;
void (GLAPIENTRY *glDrawTransformFeedback) (GLenum  mode, GLuint  id) = NULL;
void (GLAPIENTRY *glDrawTransformFeedbackInstanced) (GLenum  mode, GLuint  id, GLsizei  instancecount) = NULL;
void (GLAPIENTRY *glDrawTransformFeedbackNV) (GLenum  mode, GLuint  id) = NULL;
void (GLAPIENTRY *glDrawTransformFeedbackStream) (GLenum  mode, GLuint  id, GLuint  stream) = NULL;
void (GLAPIENTRY *glDrawTransformFeedbackStreamInstanced) (GLenum  mode, GLuint  id, GLuint  stream, GLsizei  instancecount) = NULL;
void (GLAPIENTRY *glEGLImageTargetTexStorageEXT) (GLenum  target, GLeglImageOES  image, const GLint*  attrib_list) = NULL;
void (GLAPIENTRY *glEGLImageTargetTextureStorageEXT) (GLuint  texture, GLeglImageOES  image, const GLint*  attrib_list) = NULL;
void (GLAPIENTRY *glEdgeFlag) (GLboolean  flag) = NULL;
void (GLAPIENTRY *glEdgeFlagFormatNV) (GLsizei  stride) = NULL;
void (GLAPIENTRY *glEdgeFlagPointer) (GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glEdgeFlagPointerEXT) (GLsizei  stride, GLsizei  count, const GLboolean * pointer) = NULL;
void (GLAPIENTRY *glEdgeFlagv) (const GLboolean * flag) = NULL;
void (GLAPIENTRY *glElementPointerAPPLE) (GLenum  type, const void * pointer) = NULL;
void (GLAPIENTRY *glEnable) (GLenum  cap) = NULL;
void (GLAPIENTRY *glEnableClientState) (GLenum  array) = NULL;
void (GLAPIENTRY *glEnableClientStateIndexedEXT) (GLenum  array, GLuint  index) = NULL;
void (GLAPIENTRY *glEnableClientStateiEXT) (GLenum  array, GLuint  index) = NULL;
void (GLAPIENTRY *glEnableIndexedEXT) (GLenum  target, GLuint  index) = NULL;
void (GLAPIENTRY *glEnableVariantClientStateEXT) (GLuint  id) = NULL;
void (GLAPIENTRY *glEnableVertexArrayAttrib) (GLuint  vaobj, GLuint  index) = NULL;
void (GLAPIENTRY *glEnableVertexArrayAttribEXT) (GLuint  vaobj, GLuint  index) = NULL;
void (GLAPIENTRY *glEnableVertexArrayEXT) (GLuint  vaobj, GLenum  array) = NULL;
void (GLAPIENTRY *glEnableVertexAttribAPPLE) (GLuint  index, GLenum  pname) = NULL;
void (GLAPIENTRY *glEnableVertexAttribArray) (GLuint  index) = NULL;
void (GLAPIENTRY *glEnableVertexAttribArrayARB) (GLuint  index) = NULL;
void (GLAPIENTRY *glEnablei) (GLenum  target, GLuint  index) = NULL;
void (GLAPIENTRY *glEnd) () = NULL;
void (GLAPIENTRY *glEndConditionalRender) () = NULL;
void (GLAPIENTRY *glEndConditionalRenderNV) () = NULL;
void (GLAPIENTRY *glEndList) () = NULL;
void (GLAPIENTRY *glEndOcclusionQueryNV) () = NULL;
void (GLAPIENTRY *glEndPerfMonitorAMD) (GLuint  monitor) = NULL;
void (GLAPIENTRY *glEndPerfQueryINTEL) (GLuint  queryHandle) = NULL;
void (GLAPIENTRY *glEndQuery) (GLenum  target) = NULL;
void (GLAPIENTRY *glEndQueryARB) (GLenum  target) = NULL;
void (GLAPIENTRY *glEndQueryIndexed) (GLenum  target, GLuint  index) = NULL;
void (GLAPIENTRY *glEndTransformFeedback) () = NULL;
void (GLAPIENTRY *glEndTransformFeedbackEXT) () = NULL;
void (GLAPIENTRY *glEndTransformFeedbackNV) () = NULL;
void (GLAPIENTRY *glEndVertexShaderEXT) () = NULL;
void (GLAPIENTRY *glEndVideoCaptureNV) (GLuint  video_capture_slot) = NULL;
void (GLAPIENTRY *glEvalCoord1d) (GLdouble  u) = NULL;
void (GLAPIENTRY *glEvalCoord1dv) (const GLdouble * u) = NULL;
void (GLAPIENTRY *glEvalCoord1f) (GLfloat  u) = NULL;
void (GLAPIENTRY *glEvalCoord1fv) (const GLfloat * u) = NULL;
void (GLAPIENTRY *glEvalCoord2d) (GLdouble  u, GLdouble  v) = NULL;
void (GLAPIENTRY *glEvalCoord2dv) (const GLdouble * u) = NULL;
void (GLAPIENTRY *glEvalCoord2f) (GLfloat  u, GLfloat  v) = NULL;
void (GLAPIENTRY *glEvalCoord2fv) (const GLfloat * u) = NULL;
void (GLAPIENTRY *glEvalMapsNV) (GLenum  target, GLenum  mode) = NULL;
void (GLAPIENTRY *glEvalMesh1) (GLenum  mode, GLint  i1, GLint  i2) = NULL;
void (GLAPIENTRY *glEvalMesh2) (GLenum  mode, GLint  i1, GLint  i2, GLint  j1, GLint  j2) = NULL;
void (GLAPIENTRY *glEvalPoint1) (GLint  i) = NULL;
void (GLAPIENTRY *glEvalPoint2) (GLint  i, GLint  j) = NULL;
void (GLAPIENTRY *glEvaluateDepthValuesARB) () = NULL;
void (GLAPIENTRY *glExecuteProgramNV) (GLenum  target, GLuint  id, const GLfloat * params) = NULL;
void (GLAPIENTRY *glExtractComponentEXT) (GLuint  res, GLuint  src, GLuint  num) = NULL;
void (GLAPIENTRY *glFeedbackBuffer) (GLsizei  size, GLenum  type, GLfloat * buffer) = NULL;
GLsync (GLAPIENTRY *glFenceSync) (GLenum  condition, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glFinalCombinerInputNV) (GLenum  variable, GLenum  input, GLenum  mapping, GLenum  componentUsage) = NULL;
void (GLAPIENTRY *glFinish) () = NULL;
void (GLAPIENTRY *glFinishFenceAPPLE) (GLuint  fence) = NULL;
void (GLAPIENTRY *glFinishFenceNV) (GLuint  fence) = NULL;
void (GLAPIENTRY *glFinishObjectAPPLE) (GLenum  object, GLint  name) = NULL;
void (GLAPIENTRY *glFlush) () = NULL;
void (GLAPIENTRY *glFlushMappedBufferRange) (GLenum  target, GLintptr  offset, GLsizeiptr  length) = NULL;
void (GLAPIENTRY *glFlushMappedBufferRangeAPPLE) (GLenum  target, GLintptr  offset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glFlushMappedNamedBufferRange) (GLuint  buffer, GLintptr  offset, GLsizeiptr  length) = NULL;
void (GLAPIENTRY *glFlushMappedNamedBufferRangeEXT) (GLuint  buffer, GLintptr  offset, GLsizeiptr  length) = NULL;
void (GLAPIENTRY *glFlushPixelDataRangeNV) (GLenum  target) = NULL;
void (GLAPIENTRY *glFlushVertexArrayRangeAPPLE) (GLsizei  length, void * pointer) = NULL;
void (GLAPIENTRY *glFlushVertexArrayRangeNV) () = NULL;
void (GLAPIENTRY *glFogCoordFormatNV) (GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glFogCoordPointer) (GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glFogCoordPointerEXT) (GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glFogCoordd) (GLdouble  coord) = NULL;
void (GLAPIENTRY *glFogCoorddEXT) (GLdouble  coord) = NULL;
void (GLAPIENTRY *glFogCoorddv) (const GLdouble * coord) = NULL;
void (GLAPIENTRY *glFogCoorddvEXT) (const GLdouble * coord) = NULL;
void (GLAPIENTRY *glFogCoordf) (GLfloat  coord) = NULL;
void (GLAPIENTRY *glFogCoordfEXT) (GLfloat  coord) = NULL;
void (GLAPIENTRY *glFogCoordfv) (const GLfloat * coord) = NULL;
void (GLAPIENTRY *glFogCoordfvEXT) (const GLfloat * coord) = NULL;
void (GLAPIENTRY *glFogCoordhNV) (GLhalfNV  fog) = NULL;
void (GLAPIENTRY *glFogCoordhvNV) (const GLhalfNV * fog) = NULL;
void (GLAPIENTRY *glFogf) (GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glFogfv) (GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glFogi) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glFogiv) (GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glFragmentCoverageColorNV) (GLuint  color) = NULL;
void (GLAPIENTRY *glFramebufferDrawBufferEXT) (GLuint  framebuffer, GLenum  mode) = NULL;
void (GLAPIENTRY *glFramebufferDrawBuffersEXT) (GLuint  framebuffer, GLsizei  n, const GLenum * bufs) = NULL;
void (GLAPIENTRY *glFramebufferFetchBarrierEXT) () = NULL;
void (GLAPIENTRY *glFramebufferParameteri) (GLenum  target, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glFramebufferReadBufferEXT) (GLuint  framebuffer, GLenum  mode) = NULL;
void (GLAPIENTRY *glFramebufferRenderbuffer) (GLenum  target, GLenum  attachment, GLenum  renderbuffertarget, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glFramebufferRenderbufferEXT) (GLenum  target, GLenum  attachment, GLenum  renderbuffertarget, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glFramebufferSampleLocationsfvARB) (GLenum  target, GLuint  start, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glFramebufferSampleLocationsfvNV) (GLenum  target, GLuint  start, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glFramebufferSamplePositionsfvAMD) (GLenum  target, GLuint  numsamples, GLuint  pixelindex, const GLfloat * values) = NULL;
void (GLAPIENTRY *glFramebufferTexture) (GLenum  target, GLenum  attachment, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glFramebufferTexture1D) (GLenum  target, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glFramebufferTexture1DEXT) (GLenum  target, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glFramebufferTexture2D) (GLenum  target, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glFramebufferTexture2DEXT) (GLenum  target, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glFramebufferTexture3D) (GLenum  target, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level, GLint  zoffset) = NULL;
void (GLAPIENTRY *glFramebufferTexture3DEXT) (GLenum  target, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level, GLint  zoffset) = NULL;
void (GLAPIENTRY *glFramebufferTextureARB) (GLenum  target, GLenum  attachment, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glFramebufferTextureEXT) (GLenum  target, GLenum  attachment, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glFramebufferTextureFaceARB) (GLenum  target, GLenum  attachment, GLuint  texture, GLint  level, GLenum  face) = NULL;
void (GLAPIENTRY *glFramebufferTextureFaceEXT) (GLenum  target, GLenum  attachment, GLuint  texture, GLint  level, GLenum  face) = NULL;
void (GLAPIENTRY *glFramebufferTextureLayer) (GLenum  target, GLenum  attachment, GLuint  texture, GLint  level, GLint  layer) = NULL;
void (GLAPIENTRY *glFramebufferTextureLayerARB) (GLenum  target, GLenum  attachment, GLuint  texture, GLint  level, GLint  layer) = NULL;
void (GLAPIENTRY *glFramebufferTextureLayerEXT) (GLenum  target, GLenum  attachment, GLuint  texture, GLint  level, GLint  layer) = NULL;
void (GLAPIENTRY *glFrontFace) (GLenum  mode) = NULL;
void (GLAPIENTRY *glFrustum) (GLdouble  left, GLdouble  right, GLdouble  bottom, GLdouble  top, GLdouble  zNear, GLdouble  zFar) = NULL;
void (GLAPIENTRY *glGenBuffers) (GLsizei  n, GLuint * buffers) = NULL;
void (GLAPIENTRY *glGenBuffersARB) (GLsizei  n, GLuint * buffers) = NULL;
void (GLAPIENTRY *glGenFencesAPPLE) (GLsizei  n, GLuint * fences) = NULL;
void (GLAPIENTRY *glGenFencesNV) (GLsizei  n, GLuint * fences) = NULL;
void (GLAPIENTRY *glGenFramebuffers) (GLsizei  n, GLuint * framebuffers) = NULL;
void (GLAPIENTRY *glGenFramebuffersEXT) (GLsizei  n, GLuint * framebuffers) = NULL;
GLuint (GLAPIENTRY *glGenLists) (GLsizei  range) = NULL;
void (GLAPIENTRY *glGenNamesAMD) (GLenum  identifier, GLuint  num, GLuint * names) = NULL;
void (GLAPIENTRY *glGenOcclusionQueriesNV) (GLsizei  n, GLuint * ids) = NULL;
GLuint (GLAPIENTRY *glGenPathsNV) (GLsizei  range) = NULL;
void (GLAPIENTRY *glGenPerfMonitorsAMD) (GLsizei  n, GLuint * monitors) = NULL;
void (GLAPIENTRY *glGenProgramPipelines) (GLsizei  n, GLuint * pipelines) = NULL;
void (GLAPIENTRY *glGenProgramPipelinesEXT) (GLsizei  n, GLuint * pipelines) = NULL;
void (GLAPIENTRY *glGenProgramsARB) (GLsizei  n, GLuint * programs) = NULL;
void (GLAPIENTRY *glGenProgramsNV) (GLsizei  n, GLuint * programs) = NULL;
void (GLAPIENTRY *glGenQueries) (GLsizei  n, GLuint * ids) = NULL;
void (GLAPIENTRY *glGenQueriesARB) (GLsizei  n, GLuint * ids) = NULL;
void (GLAPIENTRY *glGenQueryResourceTagNV) (GLsizei  n, GLint * tagIds) = NULL;
void (GLAPIENTRY *glGenRenderbuffers) (GLsizei  n, GLuint * renderbuffers) = NULL;
void (GLAPIENTRY *glGenRenderbuffersEXT) (GLsizei  n, GLuint * renderbuffers) = NULL;
void (GLAPIENTRY *glGenSamplers) (GLsizei  count, GLuint * samplers) = NULL;
void (GLAPIENTRY *glGenSemaphoresEXT) (GLsizei  n, GLuint * semaphores) = NULL;
GLuint (GLAPIENTRY *glGenSymbolsEXT) (GLenum  datatype, GLenum  storagetype, GLenum  range, GLuint  components) = NULL;
void (GLAPIENTRY *glGenTextures) (GLsizei  n, GLuint * textures) = NULL;
void (GLAPIENTRY *glGenTexturesEXT) (GLsizei  n, GLuint * textures) = NULL;
void (GLAPIENTRY *glGenTransformFeedbacks) (GLsizei  n, GLuint * ids) = NULL;
void (GLAPIENTRY *glGenTransformFeedbacksNV) (GLsizei  n, GLuint * ids) = NULL;
void (GLAPIENTRY *glGenVertexArrays) (GLsizei  n, GLuint * arrays) = NULL;
void (GLAPIENTRY *glGenVertexArraysAPPLE) (GLsizei  n, GLuint * arrays) = NULL;
GLuint (GLAPIENTRY *glGenVertexShadersEXT) (GLuint  range) = NULL;
void (GLAPIENTRY *glGenerateMipmap) (GLenum  target) = NULL;
void (GLAPIENTRY *glGenerateMipmapEXT) (GLenum  target) = NULL;
void (GLAPIENTRY *glGenerateMultiTexMipmapEXT) (GLenum  texunit, GLenum  target) = NULL;
void (GLAPIENTRY *glGenerateTextureMipmap) (GLuint  texture) = NULL;
void (GLAPIENTRY *glGenerateTextureMipmapEXT) (GLuint  texture, GLenum  target) = NULL;
void (GLAPIENTRY *glGetActiveAtomicCounterBufferiv) (GLuint  program, GLuint  bufferIndex, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetActiveAttrib) (GLuint  program, GLuint  index, GLsizei  bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) = NULL;
void (GLAPIENTRY *glGetActiveAttribARB) (GLhandleARB  programObj, GLuint  index, GLsizei  maxLength, GLsizei * length, GLint * size, GLenum * type, GLcharARB * name) = NULL;
void (GLAPIENTRY *glGetActiveSubroutineName) (GLuint  program, GLenum  shadertype, GLuint  index, GLsizei  bufSize, GLsizei * length, GLchar * name) = NULL;
void (GLAPIENTRY *glGetActiveSubroutineUniformName) (GLuint  program, GLenum  shadertype, GLuint  index, GLsizei  bufSize, GLsizei * length, GLchar * name) = NULL;
void (GLAPIENTRY *glGetActiveSubroutineUniformiv) (GLuint  program, GLenum  shadertype, GLuint  index, GLenum  pname, GLint * values) = NULL;
void (GLAPIENTRY *glGetActiveUniform) (GLuint  program, GLuint  index, GLsizei  bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) = NULL;
void (GLAPIENTRY *glGetActiveUniformARB) (GLhandleARB  programObj, GLuint  index, GLsizei  maxLength, GLsizei * length, GLint * size, GLenum * type, GLcharARB * name) = NULL;
void (GLAPIENTRY *glGetActiveUniformBlockName) (GLuint  program, GLuint  uniformBlockIndex, GLsizei  bufSize, GLsizei * length, GLchar * uniformBlockName) = NULL;
void (GLAPIENTRY *glGetActiveUniformBlockiv) (GLuint  program, GLuint  uniformBlockIndex, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetActiveUniformName) (GLuint  program, GLuint  uniformIndex, GLsizei  bufSize, GLsizei * length, GLchar * uniformName) = NULL;
void (GLAPIENTRY *glGetActiveUniformsiv) (GLuint  program, GLsizei  uniformCount, const GLuint * uniformIndices, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetActiveVaryingNV) (GLuint  program, GLuint  index, GLsizei  bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name) = NULL;
void (GLAPIENTRY *glGetAttachedObjectsARB) (GLhandleARB  containerObj, GLsizei  maxCount, GLsizei * count, GLhandleARB * obj) = NULL;
void (GLAPIENTRY *glGetAttachedShaders) (GLuint  program, GLsizei  maxCount, GLsizei * count, GLuint * shaders) = NULL;
GLint (GLAPIENTRY *glGetAttribLocation) (GLuint  program, const GLchar * name) = NULL;
GLint (GLAPIENTRY *glGetAttribLocationARB) (GLhandleARB  programObj, const GLcharARB * name) = NULL;
void (GLAPIENTRY *glGetBooleanIndexedvEXT) (GLenum  target, GLuint  index, GLboolean * data) = NULL;
void (GLAPIENTRY *glGetBooleani_v) (GLenum  target, GLuint  index, GLboolean * data) = NULL;
void (GLAPIENTRY *glGetBooleanv) (GLenum  pname, GLboolean * data) = NULL;
void (GLAPIENTRY *glGetBufferParameteri64v) (GLenum  target, GLenum  pname, GLint64 * params) = NULL;
void (GLAPIENTRY *glGetBufferParameteriv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetBufferParameterivARB) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetBufferParameterui64vNV) (GLenum  target, GLenum  pname, GLuint64EXT * params) = NULL;
void (GLAPIENTRY *glGetBufferPointerv) (GLenum  target, GLenum  pname, void ** params) = NULL;
void (GLAPIENTRY *glGetBufferPointervARB) (GLenum  target, GLenum  pname, void ** params) = NULL;
void (GLAPIENTRY *glGetBufferSubData) (GLenum  target, GLintptr  offset, GLsizeiptr  size, void * data) = NULL;
void (GLAPIENTRY *glGetBufferSubDataARB) (GLenum  target, GLintptrARB  offset, GLsizeiptrARB  size, void * data) = NULL;
void (GLAPIENTRY *glGetClipPlane) (GLenum  plane, GLdouble * equation) = NULL;
void (GLAPIENTRY *glGetColorTable) (GLenum  target, GLenum  format, GLenum  type, void * table) = NULL;
void (GLAPIENTRY *glGetColorTableEXT) (GLenum  target, GLenum  format, GLenum  type, void * data) = NULL;
void (GLAPIENTRY *glGetColorTableParameterfv) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetColorTableParameterfvEXT) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetColorTableParameteriv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetColorTableParameterivEXT) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetCombinerInputParameterfvNV) (GLenum  stage, GLenum  portion, GLenum  variable, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetCombinerInputParameterivNV) (GLenum  stage, GLenum  portion, GLenum  variable, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetCombinerOutputParameterfvNV) (GLenum  stage, GLenum  portion, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetCombinerOutputParameterivNV) (GLenum  stage, GLenum  portion, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetCombinerStageParameterfvNV) (GLenum  stage, GLenum  pname, GLfloat * params) = NULL;
GLuint (GLAPIENTRY *glGetCommandHeaderNV) (GLenum  tokenID, GLuint  size) = NULL;
void (GLAPIENTRY *glGetCompressedMultiTexImageEXT) (GLenum  texunit, GLenum  target, GLint  lod, void * img) = NULL;
void (GLAPIENTRY *glGetCompressedTexImage) (GLenum  target, GLint  level, void * img) = NULL;
void (GLAPIENTRY *glGetCompressedTexImageARB) (GLenum  target, GLint  level, void * img) = NULL;
void (GLAPIENTRY *glGetCompressedTextureImage) (GLuint  texture, GLint  level, GLsizei  bufSize, void * pixels) = NULL;
void (GLAPIENTRY *glGetCompressedTextureImageEXT) (GLuint  texture, GLenum  target, GLint  lod, void * img) = NULL;
void (GLAPIENTRY *glGetCompressedTextureSubImage) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLsizei  bufSize, void * pixels) = NULL;
void (GLAPIENTRY *glGetConvolutionFilter) (GLenum  target, GLenum  format, GLenum  type, void * image) = NULL;
void (GLAPIENTRY *glGetConvolutionFilterEXT) (GLenum  target, GLenum  format, GLenum  type, void * image) = NULL;
void (GLAPIENTRY *glGetConvolutionParameterfv) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetConvolutionParameterfvEXT) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetConvolutionParameteriv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetConvolutionParameterivEXT) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetCoverageModulationTableNV) (GLsizei  bufSize, GLfloat * v) = NULL;
GLuint (GLAPIENTRY *glGetDebugMessageLog) (GLuint  count, GLsizei  bufSize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog) = NULL;
GLuint (GLAPIENTRY *glGetDebugMessageLogAMD) (GLuint  count, GLsizei  bufSize, GLenum * categories, GLuint * severities, GLuint * ids, GLsizei * lengths, GLchar * message) = NULL;
GLuint (GLAPIENTRY *glGetDebugMessageLogARB) (GLuint  count, GLsizei  bufSize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog) = NULL;
GLuint (GLAPIENTRY *glGetDebugMessageLogKHR) (GLuint  count, GLsizei  bufSize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog) = NULL;
void (GLAPIENTRY *glGetDoubleIndexedvEXT) (GLenum  target, GLuint  index, GLdouble * data) = NULL;
void (GLAPIENTRY *glGetDoublei_v) (GLenum  target, GLuint  index, GLdouble * data) = NULL;
void (GLAPIENTRY *glGetDoublei_vEXT) (GLenum  pname, GLuint  index, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetDoublev) (GLenum  pname, GLdouble * data) = NULL;
GLenum (GLAPIENTRY *glGetError) () = NULL;
void (GLAPIENTRY *glGetFenceivNV) (GLuint  fence, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetFinalCombinerInputParameterfvNV) (GLenum  variable, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetFinalCombinerInputParameterivNV) (GLenum  variable, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetFirstPerfQueryIdINTEL) (GLuint * queryId) = NULL;
void (GLAPIENTRY *glGetFloatIndexedvEXT) (GLenum  target, GLuint  index, GLfloat * data) = NULL;
void (GLAPIENTRY *glGetFloati_v) (GLenum  target, GLuint  index, GLfloat * data) = NULL;
void (GLAPIENTRY *glGetFloati_vEXT) (GLenum  pname, GLuint  index, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetFloatv) (GLenum  pname, GLfloat * data) = NULL;
GLint (GLAPIENTRY *glGetFragDataIndex) (GLuint  program, const GLchar * name) = NULL;
GLint (GLAPIENTRY *glGetFragDataLocation) (GLuint  program, const GLchar * name) = NULL;
GLint (GLAPIENTRY *glGetFragDataLocationEXT) (GLuint  program, const GLchar * name) = NULL;
void (GLAPIENTRY *glGetFramebufferAttachmentParameteriv) (GLenum  target, GLenum  attachment, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetFramebufferAttachmentParameterivEXT) (GLenum  target, GLenum  attachment, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetFramebufferParameterfvAMD) (GLenum  target, GLenum  pname, GLuint  numsamples, GLuint  pixelindex, GLsizei  size, GLfloat * values) = NULL;
void (GLAPIENTRY *glGetFramebufferParameteriv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetFramebufferParameterivEXT) (GLuint  framebuffer, GLenum  pname, GLint * params) = NULL;
GLenum (GLAPIENTRY *glGetGraphicsResetStatus) () = NULL;
GLenum (GLAPIENTRY *glGetGraphicsResetStatusARB) () = NULL;
GLenum (GLAPIENTRY *glGetGraphicsResetStatusKHR) () = NULL;
GLhandleARB (GLAPIENTRY *glGetHandleARB) (GLenum  pname) = NULL;
void (GLAPIENTRY *glGetHistogram) (GLenum  target, GLboolean  reset, GLenum  format, GLenum  type, void * values) = NULL;
void (GLAPIENTRY *glGetHistogramEXT) (GLenum  target, GLboolean  reset, GLenum  format, GLenum  type, void * values) = NULL;
void (GLAPIENTRY *glGetHistogramParameterfv) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetHistogramParameterfvEXT) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetHistogramParameteriv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetHistogramParameterivEXT) (GLenum  target, GLenum  pname, GLint * params) = NULL;
GLuint64 (GLAPIENTRY *glGetImageHandleARB) (GLuint  texture, GLint  level, GLboolean  layered, GLint  layer, GLenum  format) = NULL;
GLuint64 (GLAPIENTRY *glGetImageHandleNV) (GLuint  texture, GLint  level, GLboolean  layered, GLint  layer, GLenum  format) = NULL;
void (GLAPIENTRY *glGetInfoLogARB) (GLhandleARB  obj, GLsizei  maxLength, GLsizei * length, GLcharARB * infoLog) = NULL;
void (GLAPIENTRY *glGetInteger64i_v) (GLenum  target, GLuint  index, GLint64 * data) = NULL;
void (GLAPIENTRY *glGetInteger64v) (GLenum  pname, GLint64 * data) = NULL;
void (GLAPIENTRY *glGetIntegerIndexedvEXT) (GLenum  target, GLuint  index, GLint * data) = NULL;
void (GLAPIENTRY *glGetIntegeri_v) (GLenum  target, GLuint  index, GLint * data) = NULL;
void (GLAPIENTRY *glGetIntegerui64i_vNV) (GLenum  value, GLuint  index, GLuint64EXT * result) = NULL;
void (GLAPIENTRY *glGetIntegerui64vNV) (GLenum  value, GLuint64EXT * result) = NULL;
void (GLAPIENTRY *glGetIntegerv) (GLenum  pname, GLint * data) = NULL;
void (GLAPIENTRY *glGetInternalformatSampleivNV) (GLenum  target, GLenum  internalformat, GLsizei  samples, GLenum  pname, GLsizei  count, GLint * params) = NULL;
void (GLAPIENTRY *glGetInternalformati64v) (GLenum  target, GLenum  internalformat, GLenum  pname, GLsizei  count, GLint64 * params) = NULL;
void (GLAPIENTRY *glGetInternalformativ) (GLenum  target, GLenum  internalformat, GLenum  pname, GLsizei  count, GLint * params) = NULL;
void (GLAPIENTRY *glGetInvariantBooleanvEXT) (GLuint  id, GLenum  value, GLboolean * data) = NULL;
void (GLAPIENTRY *glGetInvariantFloatvEXT) (GLuint  id, GLenum  value, GLfloat * data) = NULL;
void (GLAPIENTRY *glGetInvariantIntegervEXT) (GLuint  id, GLenum  value, GLint * data) = NULL;
void (GLAPIENTRY *glGetLightfv) (GLenum  light, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetLightiv) (GLenum  light, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetLocalConstantBooleanvEXT) (GLuint  id, GLenum  value, GLboolean * data) = NULL;
void (GLAPIENTRY *glGetLocalConstantFloatvEXT) (GLuint  id, GLenum  value, GLfloat * data) = NULL;
void (GLAPIENTRY *glGetLocalConstantIntegervEXT) (GLuint  id, GLenum  value, GLint * data) = NULL;
void (GLAPIENTRY *glGetMapAttribParameterfvNV) (GLenum  target, GLuint  index, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMapAttribParameterivNV) (GLenum  target, GLuint  index, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMapControlPointsNV) (GLenum  target, GLuint  index, GLenum  type, GLsizei  ustride, GLsizei  vstride, GLboolean  packed, void * points) = NULL;
void (GLAPIENTRY *glGetMapParameterfvNV) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMapParameterivNV) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMapdv) (GLenum  target, GLenum  query, GLdouble * v) = NULL;
void (GLAPIENTRY *glGetMapfv) (GLenum  target, GLenum  query, GLfloat * v) = NULL;
void (GLAPIENTRY *glGetMapiv) (GLenum  target, GLenum  query, GLint * v) = NULL;
void (GLAPIENTRY *glGetMaterialfv) (GLenum  face, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMaterialiv) (GLenum  face, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMemoryObjectDetachedResourcesuivNV) (GLuint  memory, GLenum  pname, GLint  first, GLsizei  count, GLuint * params) = NULL;
void (GLAPIENTRY *glGetMemoryObjectParameterivEXT) (GLuint  memoryObject, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMinmax) (GLenum  target, GLboolean  reset, GLenum  format, GLenum  type, void * values) = NULL;
void (GLAPIENTRY *glGetMinmaxEXT) (GLenum  target, GLboolean  reset, GLenum  format, GLenum  type, void * values) = NULL;
void (GLAPIENTRY *glGetMinmaxParameterfv) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMinmaxParameterfvEXT) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMinmaxParameteriv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMinmaxParameterivEXT) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMultiTexEnvfvEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMultiTexEnvivEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMultiTexGendvEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetMultiTexGenfvEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMultiTexGenivEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMultiTexImageEXT) (GLenum  texunit, GLenum  target, GLint  level, GLenum  format, GLenum  type, void * pixels) = NULL;
void (GLAPIENTRY *glGetMultiTexLevelParameterfvEXT) (GLenum  texunit, GLenum  target, GLint  level, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMultiTexLevelParameterivEXT) (GLenum  texunit, GLenum  target, GLint  level, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMultiTexParameterIivEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMultiTexParameterIuivEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetMultiTexParameterfvEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetMultiTexParameterivEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetMultisamplefv) (GLenum  pname, GLuint  index, GLfloat * val) = NULL;
void (GLAPIENTRY *glGetMultisamplefvNV) (GLenum  pname, GLuint  index, GLfloat * val) = NULL;
void (GLAPIENTRY *glGetNamedBufferParameteri64v) (GLuint  buffer, GLenum  pname, GLint64 * params) = NULL;
void (GLAPIENTRY *glGetNamedBufferParameteriv) (GLuint  buffer, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedBufferParameterivEXT) (GLuint  buffer, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedBufferParameterui64vNV) (GLuint  buffer, GLenum  pname, GLuint64EXT * params) = NULL;
void (GLAPIENTRY *glGetNamedBufferPointerv) (GLuint  buffer, GLenum  pname, void ** params) = NULL;
void (GLAPIENTRY *glGetNamedBufferPointervEXT) (GLuint  buffer, GLenum  pname, void ** params) = NULL;
void (GLAPIENTRY *glGetNamedBufferSubData) (GLuint  buffer, GLintptr  offset, GLsizeiptr  size, void * data) = NULL;
void (GLAPIENTRY *glGetNamedBufferSubDataEXT) (GLuint  buffer, GLintptr  offset, GLsizeiptr  size, void * data) = NULL;
void (GLAPIENTRY *glGetNamedFramebufferParameterfvAMD) (GLuint  framebuffer, GLenum  pname, GLuint  numsamples, GLuint  pixelindex, GLsizei  size, GLfloat * values) = NULL;
void (GLAPIENTRY *glGetNamedFramebufferAttachmentParameteriv) (GLuint  framebuffer, GLenum  attachment, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedFramebufferAttachmentParameterivEXT) (GLuint  framebuffer, GLenum  attachment, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedFramebufferParameteriv) (GLuint  framebuffer, GLenum  pname, GLint * param) = NULL;
void (GLAPIENTRY *glGetNamedFramebufferParameterivEXT) (GLuint  framebuffer, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedProgramLocalParameterIivEXT) (GLuint  program, GLenum  target, GLuint  index, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedProgramLocalParameterIuivEXT) (GLuint  program, GLenum  target, GLuint  index, GLuint * params) = NULL;
void (GLAPIENTRY *glGetNamedProgramLocalParameterdvEXT) (GLuint  program, GLenum  target, GLuint  index, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetNamedProgramLocalParameterfvEXT) (GLuint  program, GLenum  target, GLuint  index, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetNamedProgramStringEXT) (GLuint  program, GLenum  target, GLenum  pname, void * string) = NULL;
void (GLAPIENTRY *glGetNamedProgramivEXT) (GLuint  program, GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedRenderbufferParameteriv) (GLuint  renderbuffer, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedRenderbufferParameterivEXT) (GLuint  renderbuffer, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNamedStringARB) (GLint  namelen, const GLchar * name, GLsizei  bufSize, GLint * stringlen, GLchar * string) = NULL;
void (GLAPIENTRY *glGetNamedStringivARB) (GLint  namelen, const GLchar * name, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetNextPerfQueryIdINTEL) (GLuint  queryId, GLuint * nextQueryId) = NULL;
void (GLAPIENTRY *glGetObjectLabel) (GLenum  identifier, GLuint  name, GLsizei  bufSize, GLsizei * length, GLchar * label) = NULL;
void (GLAPIENTRY *glGetObjectLabelEXT) (GLenum  type, GLuint  object, GLsizei  bufSize, GLsizei * length, GLchar * label) = NULL;
void (GLAPIENTRY *glGetObjectLabelKHR) (GLenum  identifier, GLuint  name, GLsizei  bufSize, GLsizei * length, GLchar * label) = NULL;
void (GLAPIENTRY *glGetObjectParameterfvARB) (GLhandleARB  obj, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetObjectParameterivAPPLE) (GLenum  objectType, GLuint  name, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetObjectParameterivARB) (GLhandleARB  obj, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetObjectPtrLabel) (const void * ptr, GLsizei  bufSize, GLsizei * length, GLchar * label) = NULL;
void (GLAPIENTRY *glGetObjectPtrLabelKHR) (const void * ptr, GLsizei  bufSize, GLsizei * length, GLchar * label) = NULL;
void (GLAPIENTRY *glGetOcclusionQueryivNV) (GLuint  id, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetOcclusionQueryuivNV) (GLuint  id, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetPathColorGenfvNV) (GLenum  color, GLenum  pname, GLfloat * value) = NULL;
void (GLAPIENTRY *glGetPathColorGenivNV) (GLenum  color, GLenum  pname, GLint * value) = NULL;
void (GLAPIENTRY *glGetPathCommandsNV) (GLuint  path, GLubyte * commands) = NULL;
void (GLAPIENTRY *glGetPathCoordsNV) (GLuint  path, GLfloat * coords) = NULL;
void (GLAPIENTRY *glGetPathDashArrayNV) (GLuint  path, GLfloat * dashArray) = NULL;
GLfloat (GLAPIENTRY *glGetPathLengthNV) (GLuint  path, GLsizei  startSegment, GLsizei  numSegments) = NULL;
void (GLAPIENTRY *glGetPathMetricRangeNV) (GLbitfield  metricQueryMask, GLuint  firstPathName, GLsizei  numPaths, GLsizei  stride, GLfloat * metrics) = NULL;
void (GLAPIENTRY *glGetPathMetricsNV) (GLbitfield  metricQueryMask, GLsizei  numPaths, GLenum  pathNameType, const void * paths, GLuint  pathBase, GLsizei  stride, GLfloat * metrics) = NULL;
void (GLAPIENTRY *glGetPathParameterfvNV) (GLuint  path, GLenum  pname, GLfloat * value) = NULL;
void (GLAPIENTRY *glGetPathParameterivNV) (GLuint  path, GLenum  pname, GLint * value) = NULL;
void (GLAPIENTRY *glGetPathSpacingNV) (GLenum  pathListMode, GLsizei  numPaths, GLenum  pathNameType, const void * paths, GLuint  pathBase, GLfloat  advanceScale, GLfloat  kerningScale, GLenum  transformType, GLfloat * returnedSpacing) = NULL;
void (GLAPIENTRY *glGetPathTexGenfvNV) (GLenum  texCoordSet, GLenum  pname, GLfloat * value) = NULL;
void (GLAPIENTRY *glGetPathTexGenivNV) (GLenum  texCoordSet, GLenum  pname, GLint * value) = NULL;
void (GLAPIENTRY *glGetPerfCounterInfoINTEL) (GLuint  queryId, GLuint  counterId, GLuint  counterNameLength, GLchar * counterName, GLuint  counterDescLength, GLchar * counterDesc, GLuint * counterOffset, GLuint * counterDataSize, GLuint * counterTypeEnum, GLuint * counterDataTypeEnum, GLuint64 * rawCounterMaxValue) = NULL;
void (GLAPIENTRY *glGetPerfMonitorCounterDataAMD) (GLuint  monitor, GLenum  pname, GLsizei  dataSize, GLuint * data, GLint * bytesWritten) = NULL;
void (GLAPIENTRY *glGetPerfMonitorCounterInfoAMD) (GLuint  group, GLuint  counter, GLenum  pname, void * data) = NULL;
void (GLAPIENTRY *glGetPerfMonitorCounterStringAMD) (GLuint  group, GLuint  counter, GLsizei  bufSize, GLsizei * length, GLchar * counterString) = NULL;
void (GLAPIENTRY *glGetPerfMonitorCountersAMD) (GLuint  group, GLint * numCounters, GLint * maxActiveCounters, GLsizei  counterSize, GLuint * counters) = NULL;
void (GLAPIENTRY *glGetPerfMonitorGroupStringAMD) (GLuint  group, GLsizei  bufSize, GLsizei * length, GLchar * groupString) = NULL;
void (GLAPIENTRY *glGetPerfMonitorGroupsAMD) (GLint * numGroups, GLsizei  groupsSize, GLuint * groups) = NULL;
void (GLAPIENTRY *glGetPerfQueryDataINTEL) (GLuint  queryHandle, GLuint  flags, GLsizei  dataSize, void * data, GLuint * bytesWritten) = NULL;
void (GLAPIENTRY *glGetPerfQueryIdByNameINTEL) (GLchar * queryName, GLuint * queryId) = NULL;
void (GLAPIENTRY *glGetPerfQueryInfoINTEL) (GLuint  queryId, GLuint  queryNameLength, GLchar * queryName, GLuint * dataSize, GLuint * noCounters, GLuint * noInstances, GLuint * capsMask) = NULL;
void (GLAPIENTRY *glGetPixelMapfv) (GLenum  map, GLfloat * values) = NULL;
void (GLAPIENTRY *glGetPixelMapuiv) (GLenum  map, GLuint * values) = NULL;
void (GLAPIENTRY *glGetPixelMapusv) (GLenum  map, GLushort * values) = NULL;
void (GLAPIENTRY *glGetPixelTransformParameterfvEXT) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetPixelTransformParameterivEXT) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetPointerIndexedvEXT) (GLenum  target, GLuint  index, void ** data) = NULL;
void (GLAPIENTRY *glGetPointeri_vEXT) (GLenum  pname, GLuint  index, void ** params) = NULL;
void (GLAPIENTRY *glGetPointerv) (GLenum  pname, void ** params) = NULL;
void (GLAPIENTRY *glGetPointervEXT) (GLenum  pname, void ** params) = NULL;
void (GLAPIENTRY *glGetPointervKHR) (GLenum  pname, void ** params) = NULL;
void (GLAPIENTRY *glGetPolygonStipple) (GLubyte * mask) = NULL;
void (GLAPIENTRY *glGetProgramBinary) (GLuint  program, GLsizei  bufSize, GLsizei * length, GLenum * binaryFormat, void * binary) = NULL;
void (GLAPIENTRY *glGetProgramEnvParameterIivNV) (GLenum  target, GLuint  index, GLint * params) = NULL;
void (GLAPIENTRY *glGetProgramEnvParameterIuivNV) (GLenum  target, GLuint  index, GLuint * params) = NULL;
void (GLAPIENTRY *glGetProgramEnvParameterdvARB) (GLenum  target, GLuint  index, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetProgramEnvParameterfvARB) (GLenum  target, GLuint  index, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetProgramInfoLog) (GLuint  program, GLsizei  bufSize, GLsizei * length, GLchar * infoLog) = NULL;
void (GLAPIENTRY *glGetProgramInterfaceiv) (GLuint  program, GLenum  programInterface, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetProgramLocalParameterIivNV) (GLenum  target, GLuint  index, GLint * params) = NULL;
void (GLAPIENTRY *glGetProgramLocalParameterIuivNV) (GLenum  target, GLuint  index, GLuint * params) = NULL;
void (GLAPIENTRY *glGetProgramLocalParameterdvARB) (GLenum  target, GLuint  index, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetProgramLocalParameterfvARB) (GLenum  target, GLuint  index, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetProgramNamedParameterdvNV) (GLuint  id, GLsizei  len, const GLubyte * name, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetProgramNamedParameterfvNV) (GLuint  id, GLsizei  len, const GLubyte * name, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetProgramParameterdvNV) (GLenum  target, GLuint  index, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetProgramParameterfvNV) (GLenum  target, GLuint  index, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetProgramPipelineInfoLog) (GLuint  pipeline, GLsizei  bufSize, GLsizei * length, GLchar * infoLog) = NULL;
void (GLAPIENTRY *glGetProgramPipelineInfoLogEXT) (GLuint  pipeline, GLsizei  bufSize, GLsizei * length, GLchar * infoLog) = NULL;
void (GLAPIENTRY *glGetProgramPipelineiv) (GLuint  pipeline, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetProgramPipelineivEXT) (GLuint  pipeline, GLenum  pname, GLint * params) = NULL;
GLuint (GLAPIENTRY *glGetProgramResourceIndex) (GLuint  program, GLenum  programInterface, const GLchar * name) = NULL;
GLint (GLAPIENTRY *glGetProgramResourceLocation) (GLuint  program, GLenum  programInterface, const GLchar * name) = NULL;
GLint (GLAPIENTRY *glGetProgramResourceLocationIndex) (GLuint  program, GLenum  programInterface, const GLchar * name) = NULL;
void (GLAPIENTRY *glGetProgramResourceName) (GLuint  program, GLenum  programInterface, GLuint  index, GLsizei  bufSize, GLsizei * length, GLchar * name) = NULL;
void (GLAPIENTRY *glGetProgramResourcefvNV) (GLuint  program, GLenum  programInterface, GLuint  index, GLsizei  propCount, const GLenum * props, GLsizei  count, GLsizei * length, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetProgramResourceiv) (GLuint  program, GLenum  programInterface, GLuint  index, GLsizei  propCount, const GLenum * props, GLsizei  count, GLsizei * length, GLint * params) = NULL;
void (GLAPIENTRY *glGetProgramStageiv) (GLuint  program, GLenum  shadertype, GLenum  pname, GLint * values) = NULL;
void (GLAPIENTRY *glGetProgramStringARB) (GLenum  target, GLenum  pname, void * string) = NULL;
void (GLAPIENTRY *glGetProgramStringNV) (GLuint  id, GLenum  pname, GLubyte * program) = NULL;
void (GLAPIENTRY *glGetProgramSubroutineParameteruivNV) (GLenum  target, GLuint  index, GLuint * param) = NULL;
void (GLAPIENTRY *glGetProgramiv) (GLuint  program, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetProgramivARB) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetProgramivNV) (GLuint  id, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetQueryBufferObjecti64v) (GLuint  id, GLuint  buffer, GLenum  pname, GLintptr  offset) = NULL;
void (GLAPIENTRY *glGetQueryBufferObjectiv) (GLuint  id, GLuint  buffer, GLenum  pname, GLintptr  offset) = NULL;
void (GLAPIENTRY *glGetQueryBufferObjectui64v) (GLuint  id, GLuint  buffer, GLenum  pname, GLintptr  offset) = NULL;
void (GLAPIENTRY *glGetQueryBufferObjectuiv) (GLuint  id, GLuint  buffer, GLenum  pname, GLintptr  offset) = NULL;
void (GLAPIENTRY *glGetQueryIndexediv) (GLenum  target, GLuint  index, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetQueryObjecti64v) (GLuint  id, GLenum  pname, GLint64 * params) = NULL;
void (GLAPIENTRY *glGetQueryObjecti64vEXT) (GLuint  id, GLenum  pname, GLint64 * params) = NULL;
void (GLAPIENTRY *glGetQueryObjectiv) (GLuint  id, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetQueryObjectivARB) (GLuint  id, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetQueryObjectui64v) (GLuint  id, GLenum  pname, GLuint64 * params) = NULL;
void (GLAPIENTRY *glGetQueryObjectui64vEXT) (GLuint  id, GLenum  pname, GLuint64 * params) = NULL;
void (GLAPIENTRY *glGetQueryObjectuiv) (GLuint  id, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetQueryObjectuivARB) (GLuint  id, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetQueryiv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetQueryivARB) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetRenderbufferParameteriv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetRenderbufferParameterivEXT) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetSamplerParameterIiv) (GLuint  sampler, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetSamplerParameterIuiv) (GLuint  sampler, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetSamplerParameterfv) (GLuint  sampler, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetSamplerParameteriv) (GLuint  sampler, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetSemaphoreParameterui64vEXT) (GLuint  semaphore, GLenum  pname, GLuint64 * params) = NULL;
void (GLAPIENTRY *glGetSeparableFilter) (GLenum  target, GLenum  format, GLenum  type, void * row, void * column, void * span) = NULL;
void (GLAPIENTRY *glGetSeparableFilterEXT) (GLenum  target, GLenum  format, GLenum  type, void * row, void * column, void * span) = NULL;
void (GLAPIENTRY *glGetShaderInfoLog) (GLuint  shader, GLsizei  bufSize, GLsizei * length, GLchar * infoLog) = NULL;
void (GLAPIENTRY *glGetShaderPrecisionFormat) (GLenum  shadertype, GLenum  precisiontype, GLint * range, GLint * precision) = NULL;
void (GLAPIENTRY *glGetShaderSource) (GLuint  shader, GLsizei  bufSize, GLsizei * length, GLchar * source) = NULL;
void (GLAPIENTRY *glGetShaderSourceARB) (GLhandleARB  obj, GLsizei  maxLength, GLsizei * length, GLcharARB * source) = NULL;
void (GLAPIENTRY *glGetShaderiv) (GLuint  shader, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetShadingRateImagePaletteNV) (GLuint  viewport, GLuint  entry, GLenum * rate) = NULL;
void (GLAPIENTRY *glGetShadingRateSampleLocationivNV) (GLenum  rate, GLuint  samples, GLuint  index, GLint * location) = NULL;
GLushort (GLAPIENTRY *glGetStageIndexNV) (GLenum  shadertype) = NULL;
const GLubyte *(GLAPIENTRY *glGetString) (GLenum  name) = NULL;
const GLubyte *(GLAPIENTRY *glGetStringi) (GLenum  name, GLuint  index) = NULL;
GLuint (GLAPIENTRY *glGetSubroutineIndex) (GLuint  program, GLenum  shadertype, const GLchar * name) = NULL;
GLint (GLAPIENTRY *glGetSubroutineUniformLocation) (GLuint  program, GLenum  shadertype, const GLchar * name) = NULL;
void (GLAPIENTRY *glGetSynciv) (GLsync  sync, GLenum  pname, GLsizei  count, GLsizei * length, GLint * values) = NULL;
void (GLAPIENTRY *glGetTexEnvfv) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetTexEnviv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTexGendv) (GLenum  coord, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetTexGenfv) (GLenum  coord, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetTexGeniv) (GLenum  coord, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTexImage) (GLenum  target, GLint  level, GLenum  format, GLenum  type, void * pixels) = NULL;
void (GLAPIENTRY *glGetTexLevelParameterfv) (GLenum  target, GLint  level, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetTexLevelParameteriv) (GLenum  target, GLint  level, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTexParameterIiv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTexParameterIivEXT) (GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTexParameterIuiv) (GLenum  target, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetTexParameterIuivEXT) (GLenum  target, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetTexParameterPointervAPPLE) (GLenum  target, GLenum  pname, void ** params) = NULL;
void (GLAPIENTRY *glGetTexParameterfv) (GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetTexParameteriv) (GLenum  target, GLenum  pname, GLint * params) = NULL;
GLuint64 (GLAPIENTRY *glGetTextureHandleARB) (GLuint  texture) = NULL;
GLuint64 (GLAPIENTRY *glGetTextureHandleNV) (GLuint  texture) = NULL;
void (GLAPIENTRY *glGetTextureImage) (GLuint  texture, GLint  level, GLenum  format, GLenum  type, GLsizei  bufSize, void * pixels) = NULL;
void (GLAPIENTRY *glGetTextureImageEXT) (GLuint  texture, GLenum  target, GLint  level, GLenum  format, GLenum  type, void * pixels) = NULL;
void (GLAPIENTRY *glGetTextureLevelParameterfv) (GLuint  texture, GLint  level, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetTextureLevelParameterfvEXT) (GLuint  texture, GLenum  target, GLint  level, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetTextureLevelParameteriv) (GLuint  texture, GLint  level, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTextureLevelParameterivEXT) (GLuint  texture, GLenum  target, GLint  level, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTextureParameterIiv) (GLuint  texture, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTextureParameterIivEXT) (GLuint  texture, GLenum  target, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTextureParameterIuiv) (GLuint  texture, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetTextureParameterIuivEXT) (GLuint  texture, GLenum  target, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetTextureParameterfv) (GLuint  texture, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetTextureParameterfvEXT) (GLuint  texture, GLenum  target, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetTextureParameteriv) (GLuint  texture, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTextureParameterivEXT) (GLuint  texture, GLenum  target, GLenum  pname, GLint * params) = NULL;
GLuint64 (GLAPIENTRY *glGetTextureSamplerHandleARB) (GLuint  texture, GLuint  sampler) = NULL;
GLuint64 (GLAPIENTRY *glGetTextureSamplerHandleNV) (GLuint  texture, GLuint  sampler) = NULL;
void (GLAPIENTRY *glGetTextureSubImage) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLenum  type, GLsizei  bufSize, void * pixels) = NULL;
void (GLAPIENTRY *glGetTrackMatrixivNV) (GLenum  target, GLuint  address, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetTransformFeedbackVarying) (GLuint  program, GLuint  index, GLsizei  bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name) = NULL;
void (GLAPIENTRY *glGetTransformFeedbackVaryingEXT) (GLuint  program, GLuint  index, GLsizei  bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name) = NULL;
void (GLAPIENTRY *glGetTransformFeedbackVaryingNV) (GLuint  program, GLuint  index, GLint * location) = NULL;
void (GLAPIENTRY *glGetTransformFeedbacki64_v) (GLuint  xfb, GLenum  pname, GLuint  index, GLint64 * param) = NULL;
void (GLAPIENTRY *glGetTransformFeedbacki_v) (GLuint  xfb, GLenum  pname, GLuint  index, GLint * param) = NULL;
void (GLAPIENTRY *glGetTransformFeedbackiv) (GLuint  xfb, GLenum  pname, GLint * param) = NULL;
GLuint (GLAPIENTRY *glGetUniformBlockIndex) (GLuint  program, const GLchar * uniformBlockName) = NULL;
GLint (GLAPIENTRY *glGetUniformBufferSizeEXT) (GLuint  program, GLint  location) = NULL;
void (GLAPIENTRY *glGetUniformIndices) (GLuint  program, GLsizei  uniformCount, const GLchar *const* uniformNames, GLuint * uniformIndices) = NULL;
GLint (GLAPIENTRY *glGetUniformLocation) (GLuint  program, const GLchar * name) = NULL;
GLint (GLAPIENTRY *glGetUniformLocationARB) (GLhandleARB  programObj, const GLcharARB * name) = NULL;
GLintptr (GLAPIENTRY *glGetUniformOffsetEXT) (GLuint  program, GLint  location) = NULL;
void (GLAPIENTRY *glGetUniformSubroutineuiv) (GLenum  shadertype, GLint  location, GLuint * params) = NULL;
void (GLAPIENTRY *glGetUniformdv) (GLuint  program, GLint  location, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetUniformfv) (GLuint  program, GLint  location, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetUniformfvARB) (GLhandleARB  programObj, GLint  location, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetUniformi64vARB) (GLuint  program, GLint  location, GLint64 * params) = NULL;
void (GLAPIENTRY *glGetUniformi64vNV) (GLuint  program, GLint  location, GLint64EXT * params) = NULL;
void (GLAPIENTRY *glGetUniformiv) (GLuint  program, GLint  location, GLint * params) = NULL;
void (GLAPIENTRY *glGetUniformivARB) (GLhandleARB  programObj, GLint  location, GLint * params) = NULL;
void (GLAPIENTRY *glGetUniformui64vARB) (GLuint  program, GLint  location, GLuint64 * params) = NULL;
void (GLAPIENTRY *glGetUniformui64vNV) (GLuint  program, GLint  location, GLuint64EXT * params) = NULL;
void (GLAPIENTRY *glGetUniformuiv) (GLuint  program, GLint  location, GLuint * params) = NULL;
void (GLAPIENTRY *glGetUniformuivEXT) (GLuint  program, GLint  location, GLuint * params) = NULL;
void (GLAPIENTRY *glGetUnsignedBytevEXT) (GLenum  pname, GLubyte * data) = NULL;
void (GLAPIENTRY *glGetUnsignedBytei_vEXT) (GLenum  target, GLuint  index, GLubyte * data) = NULL;
void (GLAPIENTRY *glGetVariantBooleanvEXT) (GLuint  id, GLenum  value, GLboolean * data) = NULL;
void (GLAPIENTRY *glGetVariantFloatvEXT) (GLuint  id, GLenum  value, GLfloat * data) = NULL;
void (GLAPIENTRY *glGetVariantIntegervEXT) (GLuint  id, GLenum  value, GLint * data) = NULL;
void (GLAPIENTRY *glGetVariantPointervEXT) (GLuint  id, GLenum  value, void ** data) = NULL;
GLint (GLAPIENTRY *glGetVaryingLocationNV) (GLuint  program, const GLchar * name) = NULL;
void (GLAPIENTRY *glGetVertexArrayIndexed64iv) (GLuint  vaobj, GLuint  index, GLenum  pname, GLint64 * param) = NULL;
void (GLAPIENTRY *glGetVertexArrayIndexediv) (GLuint  vaobj, GLuint  index, GLenum  pname, GLint * param) = NULL;
void (GLAPIENTRY *glGetVertexArrayIntegeri_vEXT) (GLuint  vaobj, GLuint  index, GLenum  pname, GLint * param) = NULL;
void (GLAPIENTRY *glGetVertexArrayIntegervEXT) (GLuint  vaobj, GLenum  pname, GLint * param) = NULL;
void (GLAPIENTRY *glGetVertexArrayPointeri_vEXT) (GLuint  vaobj, GLuint  index, GLenum  pname, void ** param) = NULL;
void (GLAPIENTRY *glGetVertexArrayPointervEXT) (GLuint  vaobj, GLenum  pname, void ** param) = NULL;
void (GLAPIENTRY *glGetVertexArrayiv) (GLuint  vaobj, GLenum  pname, GLint * param) = NULL;
void (GLAPIENTRY *glGetVertexAttribIiv) (GLuint  index, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribIivEXT) (GLuint  index, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribIuiv) (GLuint  index, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribIuivEXT) (GLuint  index, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribLdv) (GLuint  index, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribLdvEXT) (GLuint  index, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribLi64vNV) (GLuint  index, GLenum  pname, GLint64EXT * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribLui64vARB) (GLuint  index, GLenum  pname, GLuint64EXT * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribLui64vNV) (GLuint  index, GLenum  pname, GLuint64EXT * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribPointerv) (GLuint  index, GLenum  pname, void ** pointer) = NULL;
void (GLAPIENTRY *glGetVertexAttribPointervARB) (GLuint  index, GLenum  pname, void ** pointer) = NULL;
void (GLAPIENTRY *glGetVertexAttribPointervNV) (GLuint  index, GLenum  pname, void ** pointer) = NULL;
void (GLAPIENTRY *glGetVertexAttribdv) (GLuint  index, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribdvARB) (GLuint  index, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribdvNV) (GLuint  index, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribfv) (GLuint  index, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribfvARB) (GLuint  index, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribfvNV) (GLuint  index, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribiv) (GLuint  index, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribivARB) (GLuint  index, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetVertexAttribivNV) (GLuint  index, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetVideoCaptureStreamdvNV) (GLuint  video_capture_slot, GLuint  stream, GLenum  pname, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetVideoCaptureStreamfvNV) (GLuint  video_capture_slot, GLuint  stream, GLenum  pname, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetVideoCaptureStreamivNV) (GLuint  video_capture_slot, GLuint  stream, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetVideoCaptureivNV) (GLuint  video_capture_slot, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetVideoi64vNV) (GLuint  video_slot, GLenum  pname, GLint64EXT * params) = NULL;
void (GLAPIENTRY *glGetVideoivNV) (GLuint  video_slot, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glGetVideoui64vNV) (GLuint  video_slot, GLenum  pname, GLuint64EXT * params) = NULL;
void (GLAPIENTRY *glGetVideouivNV) (GLuint  video_slot, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glGetnColorTable) (GLenum  target, GLenum  format, GLenum  type, GLsizei  bufSize, void * table) = NULL;
void (GLAPIENTRY *glGetnColorTableARB) (GLenum  target, GLenum  format, GLenum  type, GLsizei  bufSize, void * table) = NULL;
void (GLAPIENTRY *glGetnCompressedTexImage) (GLenum  target, GLint  lod, GLsizei  bufSize, void * pixels) = NULL;
void (GLAPIENTRY *glGetnCompressedTexImageARB) (GLenum  target, GLint  lod, GLsizei  bufSize, void * img) = NULL;
void (GLAPIENTRY *glGetnConvolutionFilter) (GLenum  target, GLenum  format, GLenum  type, GLsizei  bufSize, void * image) = NULL;
void (GLAPIENTRY *glGetnConvolutionFilterARB) (GLenum  target, GLenum  format, GLenum  type, GLsizei  bufSize, void * image) = NULL;
void (GLAPIENTRY *glGetnHistogram) (GLenum  target, GLboolean  reset, GLenum  format, GLenum  type, GLsizei  bufSize, void * values) = NULL;
void (GLAPIENTRY *glGetnHistogramARB) (GLenum  target, GLboolean  reset, GLenum  format, GLenum  type, GLsizei  bufSize, void * values) = NULL;
void (GLAPIENTRY *glGetnMapdv) (GLenum  target, GLenum  query, GLsizei  bufSize, GLdouble * v) = NULL;
void (GLAPIENTRY *glGetnMapdvARB) (GLenum  target, GLenum  query, GLsizei  bufSize, GLdouble * v) = NULL;
void (GLAPIENTRY *glGetnMapfv) (GLenum  target, GLenum  query, GLsizei  bufSize, GLfloat * v) = NULL;
void (GLAPIENTRY *glGetnMapfvARB) (GLenum  target, GLenum  query, GLsizei  bufSize, GLfloat * v) = NULL;
void (GLAPIENTRY *glGetnMapiv) (GLenum  target, GLenum  query, GLsizei  bufSize, GLint * v) = NULL;
void (GLAPIENTRY *glGetnMapivARB) (GLenum  target, GLenum  query, GLsizei  bufSize, GLint * v) = NULL;
void (GLAPIENTRY *glGetnMinmax) (GLenum  target, GLboolean  reset, GLenum  format, GLenum  type, GLsizei  bufSize, void * values) = NULL;
void (GLAPIENTRY *glGetnMinmaxARB) (GLenum  target, GLboolean  reset, GLenum  format, GLenum  type, GLsizei  bufSize, void * values) = NULL;
void (GLAPIENTRY *glGetnPixelMapfv) (GLenum  map, GLsizei  bufSize, GLfloat * values) = NULL;
void (GLAPIENTRY *glGetnPixelMapfvARB) (GLenum  map, GLsizei  bufSize, GLfloat * values) = NULL;
void (GLAPIENTRY *glGetnPixelMapuiv) (GLenum  map, GLsizei  bufSize, GLuint * values) = NULL;
void (GLAPIENTRY *glGetnPixelMapuivARB) (GLenum  map, GLsizei  bufSize, GLuint * values) = NULL;
void (GLAPIENTRY *glGetnPixelMapusv) (GLenum  map, GLsizei  bufSize, GLushort * values) = NULL;
void (GLAPIENTRY *glGetnPixelMapusvARB) (GLenum  map, GLsizei  bufSize, GLushort * values) = NULL;
void (GLAPIENTRY *glGetnPolygonStipple) (GLsizei  bufSize, GLubyte * pattern) = NULL;
void (GLAPIENTRY *glGetnPolygonStippleARB) (GLsizei  bufSize, GLubyte * pattern) = NULL;
void (GLAPIENTRY *glGetnSeparableFilter) (GLenum  target, GLenum  format, GLenum  type, GLsizei  rowBufSize, void * row, GLsizei  columnBufSize, void * column, void * span) = NULL;
void (GLAPIENTRY *glGetnSeparableFilterARB) (GLenum  target, GLenum  format, GLenum  type, GLsizei  rowBufSize, void * row, GLsizei  columnBufSize, void * column, void * span) = NULL;
void (GLAPIENTRY *glGetnTexImage) (GLenum  target, GLint  level, GLenum  format, GLenum  type, GLsizei  bufSize, void * pixels) = NULL;
void (GLAPIENTRY *glGetnTexImageARB) (GLenum  target, GLint  level, GLenum  format, GLenum  type, GLsizei  bufSize, void * img) = NULL;
void (GLAPIENTRY *glGetnUniformdv) (GLuint  program, GLint  location, GLsizei  bufSize, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetnUniformdvARB) (GLuint  program, GLint  location, GLsizei  bufSize, GLdouble * params) = NULL;
void (GLAPIENTRY *glGetnUniformfv) (GLuint  program, GLint  location, GLsizei  bufSize, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetnUniformfvARB) (GLuint  program, GLint  location, GLsizei  bufSize, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetnUniformfvKHR) (GLuint  program, GLint  location, GLsizei  bufSize, GLfloat * params) = NULL;
void (GLAPIENTRY *glGetnUniformi64vARB) (GLuint  program, GLint  location, GLsizei  bufSize, GLint64 * params) = NULL;
void (GLAPIENTRY *glGetnUniformiv) (GLuint  program, GLint  location, GLsizei  bufSize, GLint * params) = NULL;
void (GLAPIENTRY *glGetnUniformivARB) (GLuint  program, GLint  location, GLsizei  bufSize, GLint * params) = NULL;
void (GLAPIENTRY *glGetnUniformivKHR) (GLuint  program, GLint  location, GLsizei  bufSize, GLint * params) = NULL;
void (GLAPIENTRY *glGetnUniformui64vARB) (GLuint  program, GLint  location, GLsizei  bufSize, GLuint64 * params) = NULL;
void (GLAPIENTRY *glGetnUniformuiv) (GLuint  program, GLint  location, GLsizei  bufSize, GLuint * params) = NULL;
void (GLAPIENTRY *glGetnUniformuivARB) (GLuint  program, GLint  location, GLsizei  bufSize, GLuint * params) = NULL;
void (GLAPIENTRY *glGetnUniformuivKHR) (GLuint  program, GLint  location, GLsizei  bufSize, GLuint * params) = NULL;
void (GLAPIENTRY *glHint) (GLenum  target, GLenum  mode) = NULL;
void (GLAPIENTRY *glHistogram) (GLenum  target, GLsizei  width, GLenum  internalformat, GLboolean  sink) = NULL;
void (GLAPIENTRY *glHistogramEXT) (GLenum  target, GLsizei  width, GLenum  internalformat, GLboolean  sink) = NULL;
void (GLAPIENTRY *glImportMemoryFdEXT) (GLuint  memory, GLuint64  size, GLenum  handleType, GLint  fd) = NULL;
void (GLAPIENTRY *glImportMemoryWin32HandleEXT) (GLuint  memory, GLuint64  size, GLenum  handleType, void * handle) = NULL;
void (GLAPIENTRY *glImportMemoryWin32NameEXT) (GLuint  memory, GLuint64  size, GLenum  handleType, const void * name) = NULL;
void (GLAPIENTRY *glImportSemaphoreFdEXT) (GLuint  semaphore, GLenum  handleType, GLint  fd) = NULL;
void (GLAPIENTRY *glImportSemaphoreWin32HandleEXT) (GLuint  semaphore, GLenum  handleType, void * handle) = NULL;
void (GLAPIENTRY *glImportSemaphoreWin32NameEXT) (GLuint  semaphore, GLenum  handleType, const void * name) = NULL;
GLsync (GLAPIENTRY *glImportSyncEXT) (GLenum  external_sync_type, GLintptr  external_sync, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glIndexFormatNV) (GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glIndexFuncEXT) (GLenum  func, GLclampf  ref) = NULL;
void (GLAPIENTRY *glIndexMask) (GLuint  mask) = NULL;
void (GLAPIENTRY *glIndexMaterialEXT) (GLenum  face, GLenum  mode) = NULL;
void (GLAPIENTRY *glIndexPointer) (GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glIndexPointerEXT) (GLenum  type, GLsizei  stride, GLsizei  count, const void * pointer) = NULL;
void (GLAPIENTRY *glIndexd) (GLdouble  c) = NULL;
void (GLAPIENTRY *glIndexdv) (const GLdouble * c) = NULL;
void (GLAPIENTRY *glIndexf) (GLfloat  c) = NULL;
void (GLAPIENTRY *glIndexfv) (const GLfloat * c) = NULL;
void (GLAPIENTRY *glIndexi) (GLint  c) = NULL;
void (GLAPIENTRY *glIndexiv) (const GLint * c) = NULL;
void (GLAPIENTRY *glIndexs) (GLshort  c) = NULL;
void (GLAPIENTRY *glIndexsv) (const GLshort * c) = NULL;
void (GLAPIENTRY *glIndexub) (GLubyte  c) = NULL;
void (GLAPIENTRY *glIndexubv) (const GLubyte * c) = NULL;
void (GLAPIENTRY *glInitNames) () = NULL;
void (GLAPIENTRY *glInsertComponentEXT) (GLuint  res, GLuint  src, GLuint  num) = NULL;
void (GLAPIENTRY *glInsertEventMarkerEXT) (GLsizei  length, const GLchar * marker) = NULL;
void (GLAPIENTRY *glInterleavedArrays) (GLenum  format, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glInterpolatePathsNV) (GLuint  resultPath, GLuint  pathA, GLuint  pathB, GLfloat  weight) = NULL;
void (GLAPIENTRY *glInvalidateBufferData) (GLuint  buffer) = NULL;
void (GLAPIENTRY *glInvalidateBufferSubData) (GLuint  buffer, GLintptr  offset, GLsizeiptr  length) = NULL;
void (GLAPIENTRY *glInvalidateFramebuffer) (GLenum  target, GLsizei  numAttachments, const GLenum * attachments) = NULL;
void (GLAPIENTRY *glInvalidateNamedFramebufferData) (GLuint  framebuffer, GLsizei  numAttachments, const GLenum * attachments) = NULL;
void (GLAPIENTRY *glInvalidateNamedFramebufferSubData) (GLuint  framebuffer, GLsizei  numAttachments, const GLenum * attachments, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glInvalidateSubFramebuffer) (GLenum  target, GLsizei  numAttachments, const GLenum * attachments, GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glInvalidateTexImage) (GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glInvalidateTexSubImage) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth) = NULL;
GLboolean (GLAPIENTRY *glIsBuffer) (GLuint  buffer) = NULL;
GLboolean (GLAPIENTRY *glIsBufferARB) (GLuint  buffer) = NULL;
GLboolean (GLAPIENTRY *glIsBufferResidentNV) (GLenum  target) = NULL;
GLboolean (GLAPIENTRY *glIsCommandListNV) (GLuint  list) = NULL;
GLboolean (GLAPIENTRY *glIsEnabled) (GLenum  cap) = NULL;
GLboolean (GLAPIENTRY *glIsEnabledIndexedEXT) (GLenum  target, GLuint  index) = NULL;
GLboolean (GLAPIENTRY *glIsEnabledi) (GLenum  target, GLuint  index) = NULL;
GLboolean (GLAPIENTRY *glIsFenceAPPLE) (GLuint  fence) = NULL;
GLboolean (GLAPIENTRY *glIsFenceNV) (GLuint  fence) = NULL;
GLboolean (GLAPIENTRY *glIsFramebuffer) (GLuint  framebuffer) = NULL;
GLboolean (GLAPIENTRY *glIsFramebufferEXT) (GLuint  framebuffer) = NULL;
GLboolean (GLAPIENTRY *glIsImageHandleResidentARB) (GLuint64  handle) = NULL;
GLboolean (GLAPIENTRY *glIsImageHandleResidentNV) (GLuint64  handle) = NULL;
GLboolean (GLAPIENTRY *glIsList) (GLuint  list) = NULL;
GLboolean (GLAPIENTRY *glIsMemoryObjectEXT) (GLuint  memoryObject) = NULL;
GLboolean (GLAPIENTRY *glIsNameAMD) (GLenum  identifier, GLuint  name) = NULL;
GLboolean (GLAPIENTRY *glIsNamedBufferResidentNV) (GLuint  buffer) = NULL;
GLboolean (GLAPIENTRY *glIsNamedStringARB) (GLint  namelen, const GLchar * name) = NULL;
GLboolean (GLAPIENTRY *glIsOcclusionQueryNV) (GLuint  id) = NULL;
GLboolean (GLAPIENTRY *glIsPathNV) (GLuint  path) = NULL;
GLboolean (GLAPIENTRY *glIsPointInFillPathNV) (GLuint  path, GLuint  mask, GLfloat  x, GLfloat  y) = NULL;
GLboolean (GLAPIENTRY *glIsPointInStrokePathNV) (GLuint  path, GLfloat  x, GLfloat  y) = NULL;
GLboolean (GLAPIENTRY *glIsProgram) (GLuint  program) = NULL;
GLboolean (GLAPIENTRY *glIsProgramARB) (GLuint  program) = NULL;
GLboolean (GLAPIENTRY *glIsProgramNV) (GLuint  id) = NULL;
GLboolean (GLAPIENTRY *glIsProgramPipeline) (GLuint  pipeline) = NULL;
GLboolean (GLAPIENTRY *glIsProgramPipelineEXT) (GLuint  pipeline) = NULL;
GLboolean (GLAPIENTRY *glIsQuery) (GLuint  id) = NULL;
GLboolean (GLAPIENTRY *glIsQueryARB) (GLuint  id) = NULL;
GLboolean (GLAPIENTRY *glIsRenderbuffer) (GLuint  renderbuffer) = NULL;
GLboolean (GLAPIENTRY *glIsRenderbufferEXT) (GLuint  renderbuffer) = NULL;
GLboolean (GLAPIENTRY *glIsSemaphoreEXT) (GLuint  semaphore) = NULL;
GLboolean (GLAPIENTRY *glIsSampler) (GLuint  sampler) = NULL;
GLboolean (GLAPIENTRY *glIsShader) (GLuint  shader) = NULL;
GLboolean (GLAPIENTRY *glIsStateNV) (GLuint  state) = NULL;
GLboolean (GLAPIENTRY *glIsSync) (GLsync  sync) = NULL;
GLboolean (GLAPIENTRY *glIsTexture) (GLuint  texture) = NULL;
GLboolean (GLAPIENTRY *glIsTextureEXT) (GLuint  texture) = NULL;
GLboolean (GLAPIENTRY *glIsTextureHandleResidentARB) (GLuint64  handle) = NULL;
GLboolean (GLAPIENTRY *glIsTextureHandleResidentNV) (GLuint64  handle) = NULL;
GLboolean (GLAPIENTRY *glIsTransformFeedback) (GLuint  id) = NULL;
GLboolean (GLAPIENTRY *glIsTransformFeedbackNV) (GLuint  id) = NULL;
GLboolean (GLAPIENTRY *glIsVariantEnabledEXT) (GLuint  id, GLenum  cap) = NULL;
GLboolean (GLAPIENTRY *glIsVertexArray) (GLuint  array) = NULL;
GLboolean (GLAPIENTRY *glIsVertexArrayAPPLE) (GLuint  array) = NULL;
GLboolean (GLAPIENTRY *glIsVertexAttribEnabledAPPLE) (GLuint  index, GLenum  pname) = NULL;
void (GLAPIENTRY *glLabelObjectEXT) (GLenum  type, GLuint  object, GLsizei  length, const GLchar * label) = NULL;
void (GLAPIENTRY *glLightModelf) (GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glLightModelfv) (GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glLightModeli) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glLightModeliv) (GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glLightf) (GLenum  light, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glLightfv) (GLenum  light, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glLighti) (GLenum  light, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glLightiv) (GLenum  light, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glLineStipple) (GLint  factor, GLushort  pattern) = NULL;
void (GLAPIENTRY *glLineWidth) (GLfloat  width) = NULL;
void (GLAPIENTRY *glLinkProgram) (GLuint  program) = NULL;
void (GLAPIENTRY *glLinkProgramARB) (GLhandleARB  programObj) = NULL;
void (GLAPIENTRY *glListBase) (GLuint  base) = NULL;
void (GLAPIENTRY *glListDrawCommandsStatesClientNV) (GLuint  list, GLuint  segment, const void ** indirects, const GLsizei * sizes, const GLuint * states, const GLuint * fbos, GLuint  count) = NULL;
void (GLAPIENTRY *glLoadIdentity) () = NULL;
void (GLAPIENTRY *glLoadMatrixd) (const GLdouble * m) = NULL;
void (GLAPIENTRY *glLoadMatrixf) (const GLfloat * m) = NULL;
void (GLAPIENTRY *glLoadName) (GLuint  name) = NULL;
void (GLAPIENTRY *glLoadProgramNV) (GLenum  target, GLuint  id, GLsizei  len, const GLubyte * program) = NULL;
void (GLAPIENTRY *glLoadTransposeMatrixd) (const GLdouble * m) = NULL;
void (GLAPIENTRY *glLoadTransposeMatrixdARB) (const GLdouble * m) = NULL;
void (GLAPIENTRY *glLoadTransposeMatrixf) (const GLfloat * m) = NULL;
void (GLAPIENTRY *glLoadTransposeMatrixfARB) (const GLfloat * m) = NULL;
void (GLAPIENTRY *glLockArraysEXT) (GLint  first, GLsizei  count) = NULL;
void (GLAPIENTRY *glLogicOp) (GLenum  opcode) = NULL;
void (GLAPIENTRY *glMakeBufferNonResidentNV) (GLenum  target) = NULL;
void (GLAPIENTRY *glMakeBufferResidentNV) (GLenum  target, GLenum  access) = NULL;
void (GLAPIENTRY *glMakeImageHandleNonResidentARB) (GLuint64  handle) = NULL;
void (GLAPIENTRY *glMakeImageHandleNonResidentNV) (GLuint64  handle) = NULL;
void (GLAPIENTRY *glMakeImageHandleResidentARB) (GLuint64  handle, GLenum  access) = NULL;
void (GLAPIENTRY *glMakeImageHandleResidentNV) (GLuint64  handle, GLenum  access) = NULL;
void (GLAPIENTRY *glMakeNamedBufferNonResidentNV) (GLuint  buffer) = NULL;
void (GLAPIENTRY *glMakeNamedBufferResidentNV) (GLuint  buffer, GLenum  access) = NULL;
void (GLAPIENTRY *glMakeTextureHandleNonResidentARB) (GLuint64  handle) = NULL;
void (GLAPIENTRY *glMakeTextureHandleNonResidentNV) (GLuint64  handle) = NULL;
void (GLAPIENTRY *glMakeTextureHandleResidentARB) (GLuint64  handle) = NULL;
void (GLAPIENTRY *glMakeTextureHandleResidentNV) (GLuint64  handle) = NULL;
void (GLAPIENTRY *glMap1d) (GLenum  target, GLdouble  u1, GLdouble  u2, GLint  stride, GLint  order, const GLdouble * points) = NULL;
void (GLAPIENTRY *glMap1f) (GLenum  target, GLfloat  u1, GLfloat  u2, GLint  stride, GLint  order, const GLfloat * points) = NULL;
void (GLAPIENTRY *glMap2d) (GLenum  target, GLdouble  u1, GLdouble  u2, GLint  ustride, GLint  uorder, GLdouble  v1, GLdouble  v2, GLint  vstride, GLint  vorder, const GLdouble * points) = NULL;
void (GLAPIENTRY *glMap2f) (GLenum  target, GLfloat  u1, GLfloat  u2, GLint  ustride, GLint  uorder, GLfloat  v1, GLfloat  v2, GLint  vstride, GLint  vorder, const GLfloat * points) = NULL;
void *(GLAPIENTRY *glMapBuffer) (GLenum  target, GLenum  access) = NULL;
void *(GLAPIENTRY *glMapBufferARB) (GLenum  target, GLenum  access) = NULL;
void *(GLAPIENTRY *glMapBufferRange) (GLenum  target, GLintptr  offset, GLsizeiptr  length, GLbitfield  access) = NULL;
void (GLAPIENTRY *glMapControlPointsNV) (GLenum  target, GLuint  index, GLenum  type, GLsizei  ustride, GLsizei  vstride, GLint  uorder, GLint  vorder, GLboolean  packed, const void * points) = NULL;
void (GLAPIENTRY *glMapGrid1d) (GLint  un, GLdouble  u1, GLdouble  u2) = NULL;
void (GLAPIENTRY *glMapGrid1f) (GLint  un, GLfloat  u1, GLfloat  u2) = NULL;
void (GLAPIENTRY *glMapGrid2d) (GLint  un, GLdouble  u1, GLdouble  u2, GLint  vn, GLdouble  v1, GLdouble  v2) = NULL;
void (GLAPIENTRY *glMapGrid2f) (GLint  un, GLfloat  u1, GLfloat  u2, GLint  vn, GLfloat  v1, GLfloat  v2) = NULL;
void *(GLAPIENTRY *glMapNamedBuffer) (GLuint  buffer, GLenum  access) = NULL;
void *(GLAPIENTRY *glMapNamedBufferEXT) (GLuint  buffer, GLenum  access) = NULL;
void *(GLAPIENTRY *glMapNamedBufferRange) (GLuint  buffer, GLintptr  offset, GLsizeiptr  length, GLbitfield  access) = NULL;
void *(GLAPIENTRY *glMapNamedBufferRangeEXT) (GLuint  buffer, GLintptr  offset, GLsizeiptr  length, GLbitfield  access) = NULL;
void (GLAPIENTRY *glMapParameterfvNV) (GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glMapParameterivNV) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void *(GLAPIENTRY *glMapTexture2DINTEL) (GLuint  texture, GLint  level, GLbitfield  access, GLint * stride, GLenum * layout) = NULL;
void (GLAPIENTRY *glMapVertexAttrib1dAPPLE) (GLuint  index, GLuint  size, GLdouble  u1, GLdouble  u2, GLint  stride, GLint  order, const GLdouble * points) = NULL;
void (GLAPIENTRY *glMapVertexAttrib1fAPPLE) (GLuint  index, GLuint  size, GLfloat  u1, GLfloat  u2, GLint  stride, GLint  order, const GLfloat * points) = NULL;
void (GLAPIENTRY *glMapVertexAttrib2dAPPLE) (GLuint  index, GLuint  size, GLdouble  u1, GLdouble  u2, GLint  ustride, GLint  uorder, GLdouble  v1, GLdouble  v2, GLint  vstride, GLint  vorder, const GLdouble * points) = NULL;
void (GLAPIENTRY *glMapVertexAttrib2fAPPLE) (GLuint  index, GLuint  size, GLfloat  u1, GLfloat  u2, GLint  ustride, GLint  uorder, GLfloat  v1, GLfloat  v2, GLint  vstride, GLint  vorder, const GLfloat * points) = NULL;
void (GLAPIENTRY *glMaterialf) (GLenum  face, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glMaterialfv) (GLenum  face, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glMateriali) (GLenum  face, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glMaterialiv) (GLenum  face, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glMatrixFrustumEXT) (GLenum  mode, GLdouble  left, GLdouble  right, GLdouble  bottom, GLdouble  top, GLdouble  zNear, GLdouble  zFar) = NULL;
void (GLAPIENTRY *glMatrixIndexPointerARB) (GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glMatrixIndexubvARB) (GLint  size, const GLubyte * indices) = NULL;
void (GLAPIENTRY *glMatrixIndexuivARB) (GLint  size, const GLuint * indices) = NULL;
void (GLAPIENTRY *glMatrixIndexusvARB) (GLint  size, const GLushort * indices) = NULL;
void (GLAPIENTRY *glMatrixLoad3x2fNV) (GLenum  matrixMode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixLoad3x3fNV) (GLenum  matrixMode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixLoadIdentityEXT) (GLenum  mode) = NULL;
void (GLAPIENTRY *glMatrixLoadTranspose3x3fNV) (GLenum  matrixMode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixLoadTransposedEXT) (GLenum  mode, const GLdouble * m) = NULL;
void (GLAPIENTRY *glMatrixLoadTransposefEXT) (GLenum  mode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixLoaddEXT) (GLenum  mode, const GLdouble * m) = NULL;
void (GLAPIENTRY *glMatrixLoadfEXT) (GLenum  mode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixMode) (GLenum  mode) = NULL;
void (GLAPIENTRY *glMatrixMult3x2fNV) (GLenum  matrixMode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixMult3x3fNV) (GLenum  matrixMode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixMultTranspose3x3fNV) (GLenum  matrixMode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixMultTransposedEXT) (GLenum  mode, const GLdouble * m) = NULL;
void (GLAPIENTRY *glMatrixMultTransposefEXT) (GLenum  mode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixMultdEXT) (GLenum  mode, const GLdouble * m) = NULL;
void (GLAPIENTRY *glMatrixMultfEXT) (GLenum  mode, const GLfloat * m) = NULL;
void (GLAPIENTRY *glMatrixOrthoEXT) (GLenum  mode, GLdouble  left, GLdouble  right, GLdouble  bottom, GLdouble  top, GLdouble  zNear, GLdouble  zFar) = NULL;
void (GLAPIENTRY *glMatrixPopEXT) (GLenum  mode) = NULL;
void (GLAPIENTRY *glMatrixPushEXT) (GLenum  mode) = NULL;
void (GLAPIENTRY *glMatrixRotatedEXT) (GLenum  mode, GLdouble  angle, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glMatrixRotatefEXT) (GLenum  mode, GLfloat  angle, GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glMatrixScaledEXT) (GLenum  mode, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glMatrixScalefEXT) (GLenum  mode, GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glMatrixTranslatedEXT) (GLenum  mode, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glMatrixTranslatefEXT) (GLenum  mode, GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glMaxShaderCompilerThreadsKHR) (GLuint  count) = NULL;
void (GLAPIENTRY *glMaxShaderCompilerThreadsARB) (GLuint  count) = NULL;
void (GLAPIENTRY *glMemoryBarrier) (GLbitfield  barriers) = NULL;
void (GLAPIENTRY *glMemoryBarrierByRegion) (GLbitfield  barriers) = NULL;
void (GLAPIENTRY *glMemoryBarrierEXT) (GLbitfield  barriers) = NULL;
void (GLAPIENTRY *glMemoryObjectParameterivEXT) (GLuint  memoryObject, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glMinSampleShading) (GLfloat  value) = NULL;
void (GLAPIENTRY *glMinSampleShadingARB) (GLfloat  value) = NULL;
void (GLAPIENTRY *glMinmax) (GLenum  target, GLenum  internalformat, GLboolean  sink) = NULL;
void (GLAPIENTRY *glMinmaxEXT) (GLenum  target, GLenum  internalformat, GLboolean  sink) = NULL;
void (GLAPIENTRY *glMultMatrixd) (const GLdouble * m) = NULL;
void (GLAPIENTRY *glMultMatrixf) (const GLfloat * m) = NULL;
void (GLAPIENTRY *glMultTransposeMatrixd) (const GLdouble * m) = NULL;
void (GLAPIENTRY *glMultTransposeMatrixdARB) (const GLdouble * m) = NULL;
void (GLAPIENTRY *glMultTransposeMatrixf) (const GLfloat * m) = NULL;
void (GLAPIENTRY *glMultTransposeMatrixfARB) (const GLfloat * m) = NULL;
void (GLAPIENTRY *glMultiDrawArrays) (GLenum  mode, const GLint * first, const GLsizei * count, GLsizei  drawcount) = NULL;
void (GLAPIENTRY *glMultiDrawArraysEXT) (GLenum  mode, const GLint * first, const GLsizei * count, GLsizei  primcount) = NULL;
void (GLAPIENTRY *glMultiDrawArraysIndirect) (GLenum  mode, const void * indirect, GLsizei  drawcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawArraysIndirectAMD) (GLenum  mode, const void * indirect, GLsizei  primcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawArraysIndirectBindlessCountNV) (GLenum  mode, const void * indirect, GLsizei  drawCount, GLsizei  maxDrawCount, GLsizei  stride, GLint  vertexBufferCount) = NULL;
void (GLAPIENTRY *glMultiDrawArraysIndirectBindlessNV) (GLenum  mode, const void * indirect, GLsizei  drawCount, GLsizei  stride, GLint  vertexBufferCount) = NULL;
void (GLAPIENTRY *glMultiDrawArraysIndirectCount) (GLenum  mode, const void * indirect, GLintptr  drawcount, GLsizei  maxdrawcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawArraysIndirectCountARB) (GLenum  mode, const void * indirect, GLintptr  drawcount, GLsizei  maxdrawcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawElementArrayAPPLE) (GLenum  mode, const GLint * first, const GLsizei * count, GLsizei  primcount) = NULL;
void (GLAPIENTRY *glMultiDrawElements) (GLenum  mode, const GLsizei * count, GLenum  type, const void *const* indices, GLsizei  drawcount) = NULL;
void (GLAPIENTRY *glMultiDrawElementsBaseVertex) (GLenum  mode, const GLsizei * count, GLenum  type, const void *const* indices, GLsizei  drawcount, const GLint * basevertex) = NULL;
void (GLAPIENTRY *glMultiDrawElementsEXT) (GLenum  mode, const GLsizei * count, GLenum  type, const void *const* indices, GLsizei  primcount) = NULL;
void (GLAPIENTRY *glMultiDrawElementsIndirect) (GLenum  mode, GLenum  type, const void * indirect, GLsizei  drawcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawElementsIndirectAMD) (GLenum  mode, GLenum  type, const void * indirect, GLsizei  primcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawElementsIndirectBindlessCountNV) (GLenum  mode, GLenum  type, const void * indirect, GLsizei  drawCount, GLsizei  maxDrawCount, GLsizei  stride, GLint  vertexBufferCount) = NULL;
void (GLAPIENTRY *glMultiDrawElementsIndirectBindlessNV) (GLenum  mode, GLenum  type, const void * indirect, GLsizei  drawCount, GLsizei  stride, GLint  vertexBufferCount) = NULL;
void (GLAPIENTRY *glMultiDrawElementsIndirectCount) (GLenum  mode, GLenum  type, const void * indirect, GLintptr  drawcount, GLsizei  maxdrawcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawElementsIndirectCountARB) (GLenum  mode, GLenum  type, const void * indirect, GLintptr  drawcount, GLsizei  maxdrawcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawMeshTasksIndirectNV) (GLintptr  indirect, GLsizei  drawcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawMeshTasksIndirectCountNV) (GLintptr  indirect, GLintptr  drawcount, GLsizei  maxdrawcount, GLsizei  stride) = NULL;
void (GLAPIENTRY *glMultiDrawRangeElementArrayAPPLE) (GLenum  mode, GLuint  start, GLuint  end, const GLint * first, const GLsizei * count, GLsizei  primcount) = NULL;
void (GLAPIENTRY *glMultiTexBufferEXT) (GLenum  texunit, GLenum  target, GLenum  internalformat, GLuint  buffer) = NULL;
void (GLAPIENTRY *glMultiTexCoord1d) (GLenum  target, GLdouble  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1dARB) (GLenum  target, GLdouble  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1dv) (GLenum  target, const GLdouble * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord1dvARB) (GLenum  target, const GLdouble * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord1f) (GLenum  target, GLfloat  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1fARB) (GLenum  target, GLfloat  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1fv) (GLenum  target, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord1fvARB) (GLenum  target, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord1hNV) (GLenum  target, GLhalfNV  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1hvNV) (GLenum  target, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord1i) (GLenum  target, GLint  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1iARB) (GLenum  target, GLint  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1iv) (GLenum  target, const GLint * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord1ivARB) (GLenum  target, const GLint * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord1s) (GLenum  target, GLshort  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1sARB) (GLenum  target, GLshort  s) = NULL;
void (GLAPIENTRY *glMultiTexCoord1sv) (GLenum  target, const GLshort * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord1svARB) (GLenum  target, const GLshort * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2d) (GLenum  target, GLdouble  s, GLdouble  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2dARB) (GLenum  target, GLdouble  s, GLdouble  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2dv) (GLenum  target, const GLdouble * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2dvARB) (GLenum  target, const GLdouble * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2f) (GLenum  target, GLfloat  s, GLfloat  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2fARB) (GLenum  target, GLfloat  s, GLfloat  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2fv) (GLenum  target, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2fvARB) (GLenum  target, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2hNV) (GLenum  target, GLhalfNV  s, GLhalfNV  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2hvNV) (GLenum  target, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2i) (GLenum  target, GLint  s, GLint  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2iARB) (GLenum  target, GLint  s, GLint  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2iv) (GLenum  target, const GLint * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2ivARB) (GLenum  target, const GLint * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2s) (GLenum  target, GLshort  s, GLshort  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2sARB) (GLenum  target, GLshort  s, GLshort  t) = NULL;
void (GLAPIENTRY *glMultiTexCoord2sv) (GLenum  target, const GLshort * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord2svARB) (GLenum  target, const GLshort * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3d) (GLenum  target, GLdouble  s, GLdouble  t, GLdouble  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3dARB) (GLenum  target, GLdouble  s, GLdouble  t, GLdouble  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3dv) (GLenum  target, const GLdouble * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3dvARB) (GLenum  target, const GLdouble * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3f) (GLenum  target, GLfloat  s, GLfloat  t, GLfloat  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3fARB) (GLenum  target, GLfloat  s, GLfloat  t, GLfloat  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3fv) (GLenum  target, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3fvARB) (GLenum  target, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3hNV) (GLenum  target, GLhalfNV  s, GLhalfNV  t, GLhalfNV  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3hvNV) (GLenum  target, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3i) (GLenum  target, GLint  s, GLint  t, GLint  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3iARB) (GLenum  target, GLint  s, GLint  t, GLint  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3iv) (GLenum  target, const GLint * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3ivARB) (GLenum  target, const GLint * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3s) (GLenum  target, GLshort  s, GLshort  t, GLshort  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3sARB) (GLenum  target, GLshort  s, GLshort  t, GLshort  r) = NULL;
void (GLAPIENTRY *glMultiTexCoord3sv) (GLenum  target, const GLshort * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord3svARB) (GLenum  target, const GLshort * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4d) (GLenum  target, GLdouble  s, GLdouble  t, GLdouble  r, GLdouble  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4dARB) (GLenum  target, GLdouble  s, GLdouble  t, GLdouble  r, GLdouble  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4dv) (GLenum  target, const GLdouble * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4dvARB) (GLenum  target, const GLdouble * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4f) (GLenum  target, GLfloat  s, GLfloat  t, GLfloat  r, GLfloat  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4fARB) (GLenum  target, GLfloat  s, GLfloat  t, GLfloat  r, GLfloat  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4fv) (GLenum  target, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4fvARB) (GLenum  target, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4hNV) (GLenum  target, GLhalfNV  s, GLhalfNV  t, GLhalfNV  r, GLhalfNV  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4hvNV) (GLenum  target, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4i) (GLenum  target, GLint  s, GLint  t, GLint  r, GLint  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4iARB) (GLenum  target, GLint  s, GLint  t, GLint  r, GLint  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4iv) (GLenum  target, const GLint * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4ivARB) (GLenum  target, const GLint * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4s) (GLenum  target, GLshort  s, GLshort  t, GLshort  r, GLshort  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4sARB) (GLenum  target, GLshort  s, GLshort  t, GLshort  r, GLshort  q) = NULL;
void (GLAPIENTRY *glMultiTexCoord4sv) (GLenum  target, const GLshort * v) = NULL;
void (GLAPIENTRY *glMultiTexCoord4svARB) (GLenum  target, const GLshort * v) = NULL;
void (GLAPIENTRY *glMultiTexCoordP1ui) (GLenum  texture, GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glMultiTexCoordP1uiv) (GLenum  texture, GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glMultiTexCoordP2ui) (GLenum  texture, GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glMultiTexCoordP2uiv) (GLenum  texture, GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glMultiTexCoordP3ui) (GLenum  texture, GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glMultiTexCoordP3uiv) (GLenum  texture, GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glMultiTexCoordP4ui) (GLenum  texture, GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glMultiTexCoordP4uiv) (GLenum  texture, GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glMultiTexCoordPointerEXT) (GLenum  texunit, GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glMultiTexEnvfEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glMultiTexEnvfvEXT) (GLenum  texunit, GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glMultiTexEnviEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glMultiTexEnvivEXT) (GLenum  texunit, GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glMultiTexGendEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, GLdouble  param) = NULL;
void (GLAPIENTRY *glMultiTexGendvEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, const GLdouble * params) = NULL;
void (GLAPIENTRY *glMultiTexGenfEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glMultiTexGenfvEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glMultiTexGeniEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glMultiTexGenivEXT) (GLenum  texunit, GLenum  coord, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glMultiTexImage1DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glMultiTexImage2DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLsizei  height, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glMultiTexImage3DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glMultiTexParameterIivEXT) (GLenum  texunit, GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glMultiTexParameterIuivEXT) (GLenum  texunit, GLenum  target, GLenum  pname, const GLuint * params) = NULL;
void (GLAPIENTRY *glMultiTexParameterfEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glMultiTexParameterfvEXT) (GLenum  texunit, GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glMultiTexParameteriEXT) (GLenum  texunit, GLenum  target, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glMultiTexParameterivEXT) (GLenum  texunit, GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glMultiTexRenderbufferEXT) (GLenum  texunit, GLenum  target, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glMultiTexSubImage1DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glMultiTexSubImage2DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glMultiTexSubImage3DEXT) (GLenum  texunit, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glMulticastBarrierNV) () = NULL;
void (GLAPIENTRY *glMulticastBlitFramebufferNV) (GLuint  srcGpu, GLuint  dstGpu, GLint  srcX0, GLint  srcY0, GLint  srcX1, GLint  srcY1, GLint  dstX0, GLint  dstY0, GLint  dstX1, GLint  dstY1, GLbitfield  mask, GLenum  filter) = NULL;
void (GLAPIENTRY *glMulticastBufferSubDataNV) (GLbitfield  gpuMask, GLuint  buffer, GLintptr  offset, GLsizeiptr  size, const void * data) = NULL;
void (GLAPIENTRY *glMulticastCopyBufferSubDataNV) (GLuint  readGpu, GLbitfield  writeGpuMask, GLuint  readBuffer, GLuint  writeBuffer, GLintptr  readOffset, GLintptr  writeOffset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glMulticastCopyImageSubDataNV) (GLuint  srcGpu, GLbitfield  dstGpuMask, GLuint  srcName, GLenum  srcTarget, GLint  srcLevel, GLint  srcX, GLint  srcY, GLint  srcZ, GLuint  dstName, GLenum  dstTarget, GLint  dstLevel, GLint  dstX, GLint  dstY, GLint  dstZ, GLsizei  srcWidth, GLsizei  srcHeight, GLsizei  srcDepth) = NULL;
void (GLAPIENTRY *glMulticastFramebufferSampleLocationsfvNV) (GLuint  gpu, GLuint  framebuffer, GLuint  start, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glMulticastGetQueryObjecti64vNV) (GLuint  gpu, GLuint  id, GLenum  pname, GLint64 * params) = NULL;
void (GLAPIENTRY *glMulticastGetQueryObjectivNV) (GLuint  gpu, GLuint  id, GLenum  pname, GLint * params) = NULL;
void (GLAPIENTRY *glMulticastGetQueryObjectui64vNV) (GLuint  gpu, GLuint  id, GLenum  pname, GLuint64 * params) = NULL;
void (GLAPIENTRY *glMulticastGetQueryObjectuivNV) (GLuint  gpu, GLuint  id, GLenum  pname, GLuint * params) = NULL;
void (GLAPIENTRY *glMulticastWaitSyncNV) (GLuint  signalGpu, GLbitfield  waitGpuMask) = NULL;
void (GLAPIENTRY *glNamedBufferAttachMemoryNV) (GLuint  buffer, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glNamedBufferData) (GLuint  buffer, GLsizeiptr  size, const void * data, GLenum  usage) = NULL;
void (GLAPIENTRY *glNamedBufferDataEXT) (GLuint  buffer, GLsizeiptr  size, const void * data, GLenum  usage) = NULL;
void (GLAPIENTRY *glNamedBufferPageCommitmentARB) (GLuint  buffer, GLintptr  offset, GLsizeiptr  size, GLboolean  commit) = NULL;
void (GLAPIENTRY *glNamedBufferPageCommitmentEXT) (GLuint  buffer, GLintptr  offset, GLsizeiptr  size, GLboolean  commit) = NULL;
void (GLAPIENTRY *glNamedBufferStorage) (GLuint  buffer, GLsizeiptr  size, const void * data, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glNamedBufferStorageExternalEXT) (GLuint  buffer, GLintptr  offset, GLsizeiptr  size, GLeglClientBufferEXT  clientBuffer, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glNamedBufferStorageEXT) (GLuint  buffer, GLsizeiptr  size, const void * data, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glNamedBufferStorageMemEXT) (GLuint  buffer, GLsizeiptr  size, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glNamedBufferSubData) (GLuint  buffer, GLintptr  offset, GLsizeiptr  size, const void * data) = NULL;
void (GLAPIENTRY *glNamedBufferSubDataEXT) (GLuint  buffer, GLintptr  offset, GLsizeiptr  size, const void * data) = NULL;
void (GLAPIENTRY *glNamedCopyBufferSubDataEXT) (GLuint  readBuffer, GLuint  writeBuffer, GLintptr  readOffset, GLintptr  writeOffset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glNamedFramebufferDrawBuffer) (GLuint  framebuffer, GLenum  buf) = NULL;
void (GLAPIENTRY *glNamedFramebufferDrawBuffers) (GLuint  framebuffer, GLsizei  n, const GLenum * bufs) = NULL;
void (GLAPIENTRY *glNamedFramebufferParameteri) (GLuint  framebuffer, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glNamedFramebufferParameteriEXT) (GLuint  framebuffer, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glNamedFramebufferReadBuffer) (GLuint  framebuffer, GLenum  src) = NULL;
void (GLAPIENTRY *glNamedFramebufferRenderbuffer) (GLuint  framebuffer, GLenum  attachment, GLenum  renderbuffertarget, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glNamedFramebufferRenderbufferEXT) (GLuint  framebuffer, GLenum  attachment, GLenum  renderbuffertarget, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glNamedFramebufferSampleLocationsfvARB) (GLuint  framebuffer, GLuint  start, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glNamedFramebufferSampleLocationsfvNV) (GLuint  framebuffer, GLuint  start, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glNamedFramebufferTexture) (GLuint  framebuffer, GLenum  attachment, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glNamedFramebufferSamplePositionsfvAMD) (GLuint  framebuffer, GLuint  numsamples, GLuint  pixelindex, const GLfloat * values) = NULL;
void (GLAPIENTRY *glNamedFramebufferTexture1DEXT) (GLuint  framebuffer, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glNamedFramebufferTexture2DEXT) (GLuint  framebuffer, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glNamedFramebufferTexture3DEXT) (GLuint  framebuffer, GLenum  attachment, GLenum  textarget, GLuint  texture, GLint  level, GLint  zoffset) = NULL;
void (GLAPIENTRY *glNamedFramebufferTextureEXT) (GLuint  framebuffer, GLenum  attachment, GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glNamedFramebufferTextureFaceEXT) (GLuint  framebuffer, GLenum  attachment, GLuint  texture, GLint  level, GLenum  face) = NULL;
void (GLAPIENTRY *glNamedFramebufferTextureLayer) (GLuint  framebuffer, GLenum  attachment, GLuint  texture, GLint  level, GLint  layer) = NULL;
void (GLAPIENTRY *glNamedFramebufferTextureLayerEXT) (GLuint  framebuffer, GLenum  attachment, GLuint  texture, GLint  level, GLint  layer) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameter4dEXT) (GLuint  program, GLenum  target, GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameter4dvEXT) (GLuint  program, GLenum  target, GLuint  index, const GLdouble * params) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameter4fEXT) (GLuint  program, GLenum  target, GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameter4fvEXT) (GLuint  program, GLenum  target, GLuint  index, const GLfloat * params) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameterI4iEXT) (GLuint  program, GLenum  target, GLuint  index, GLint  x, GLint  y, GLint  z, GLint  w) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameterI4ivEXT) (GLuint  program, GLenum  target, GLuint  index, const GLint * params) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameterI4uiEXT) (GLuint  program, GLenum  target, GLuint  index, GLuint  x, GLuint  y, GLuint  z, GLuint  w) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameterI4uivEXT) (GLuint  program, GLenum  target, GLuint  index, const GLuint * params) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParameters4fvEXT) (GLuint  program, GLenum  target, GLuint  index, GLsizei  count, const GLfloat * params) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParametersI4ivEXT) (GLuint  program, GLenum  target, GLuint  index, GLsizei  count, const GLint * params) = NULL;
void (GLAPIENTRY *glNamedProgramLocalParametersI4uivEXT) (GLuint  program, GLenum  target, GLuint  index, GLsizei  count, const GLuint * params) = NULL;
void (GLAPIENTRY *glNamedProgramStringEXT) (GLuint  program, GLenum  target, GLenum  format, GLsizei  len, const void * string) = NULL;
void (GLAPIENTRY *glNamedRenderbufferStorage) (GLuint  renderbuffer, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glNamedRenderbufferStorageEXT) (GLuint  renderbuffer, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glNamedRenderbufferStorageMultisample) (GLuint  renderbuffer, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glNamedRenderbufferStorageMultisampleAdvancedAMD) (GLuint  renderbuffer, GLsizei  samples, GLsizei  storageSamples, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glNamedRenderbufferStorageMultisampleCoverageEXT) (GLuint  renderbuffer, GLsizei  coverageSamples, GLsizei  colorSamples, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glNamedRenderbufferStorageMultisampleEXT) (GLuint  renderbuffer, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glNamedStringARB) (GLenum  type, GLint  namelen, const GLchar * name, GLint  stringlen, const GLchar * string) = NULL;
void (GLAPIENTRY *glNewList) (GLuint  list, GLenum  mode) = NULL;
void (GLAPIENTRY *glNormal3b) (GLbyte  nx, GLbyte  ny, GLbyte  nz) = NULL;
void (GLAPIENTRY *glNormal3bv) (const GLbyte * v) = NULL;
void (GLAPIENTRY *glNormal3d) (GLdouble  nx, GLdouble  ny, GLdouble  nz) = NULL;
void (GLAPIENTRY *glNormal3dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glNormal3f) (GLfloat  nx, GLfloat  ny, GLfloat  nz) = NULL;
void (GLAPIENTRY *glNormal3fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glNormal3hNV) (GLhalfNV  nx, GLhalfNV  ny, GLhalfNV  nz) = NULL;
void (GLAPIENTRY *glNormal3hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glNormal3i) (GLint  nx, GLint  ny, GLint  nz) = NULL;
void (GLAPIENTRY *glNormal3iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glNormal3s) (GLshort  nx, GLshort  ny, GLshort  nz) = NULL;
void (GLAPIENTRY *glNormal3sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glNormalFormatNV) (GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glNormalP3ui) (GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glNormalP3uiv) (GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glNormalPointer) (GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glNormalPointerEXT) (GLenum  type, GLsizei  stride, GLsizei  count, const void * pointer) = NULL;
void (GLAPIENTRY *glNormalPointervINTEL) (GLenum  type, const void ** pointer) = NULL;
void (GLAPIENTRY *glObjectLabel) (GLenum  identifier, GLuint  name, GLsizei  length, const GLchar * label) = NULL;
void (GLAPIENTRY *glObjectLabelKHR) (GLenum  identifier, GLuint  name, GLsizei  length, const GLchar * label) = NULL;
void (GLAPIENTRY *glObjectPtrLabel) (const void * ptr, GLsizei  length, const GLchar * label) = NULL;
void (GLAPIENTRY *glObjectPtrLabelKHR) (const void * ptr, GLsizei  length, const GLchar * label) = NULL;
GLenum (GLAPIENTRY *glObjectPurgeableAPPLE) (GLenum  objectType, GLuint  name, GLenum  option) = NULL;
GLenum (GLAPIENTRY *glObjectUnpurgeableAPPLE) (GLenum  objectType, GLuint  name, GLenum  option) = NULL;
void (GLAPIENTRY *glOrtho) (GLdouble  left, GLdouble  right, GLdouble  bottom, GLdouble  top, GLdouble  zNear, GLdouble  zFar) = NULL;
void (GLAPIENTRY *glPassThrough) (GLfloat  token) = NULL;
void (GLAPIENTRY *glPatchParameterfv) (GLenum  pname, const GLfloat * values) = NULL;
void (GLAPIENTRY *glPatchParameteri) (GLenum  pname, GLint  value) = NULL;
void (GLAPIENTRY *glPathColorGenNV) (GLenum  color, GLenum  genMode, GLenum  colorFormat, const GLfloat * coeffs) = NULL;
void (GLAPIENTRY *glPathCommandsNV) (GLuint  path, GLsizei  numCommands, const GLubyte * commands, GLsizei  numCoords, GLenum  coordType, const void * coords) = NULL;
void (GLAPIENTRY *glPathCoordsNV) (GLuint  path, GLsizei  numCoords, GLenum  coordType, const void * coords) = NULL;
void (GLAPIENTRY *glPathCoverDepthFuncNV) (GLenum  func) = NULL;
void (GLAPIENTRY *glPathDashArrayNV) (GLuint  path, GLsizei  dashCount, const GLfloat * dashArray) = NULL;
void (GLAPIENTRY *glPathFogGenNV) (GLenum  genMode) = NULL;
GLenum (GLAPIENTRY *glPathGlyphIndexArrayNV) (GLuint  firstPathName, GLenum  fontTarget, const void * fontName, GLbitfield  fontStyle, GLuint  firstGlyphIndex, GLsizei  numGlyphs, GLuint  pathParameterTemplate, GLfloat  emScale) = NULL;
GLenum (GLAPIENTRY *glPathGlyphIndexRangeNV) (GLenum  fontTarget, const void * fontName, GLbitfield  fontStyle, GLuint  pathParameterTemplate, GLfloat  emScale, GLuint  baseAndCount) = NULL;
void (GLAPIENTRY *glPathGlyphRangeNV) (GLuint  firstPathName, GLenum  fontTarget, const void * fontName, GLbitfield  fontStyle, GLuint  firstGlyph, GLsizei  numGlyphs, GLenum  handleMissingGlyphs, GLuint  pathParameterTemplate, GLfloat  emScale) = NULL;
void (GLAPIENTRY *glPathGlyphsNV) (GLuint  firstPathName, GLenum  fontTarget, const void * fontName, GLbitfield  fontStyle, GLsizei  numGlyphs, GLenum  type, const void * charcodes, GLenum  handleMissingGlyphs, GLuint  pathParameterTemplate, GLfloat  emScale) = NULL;
GLenum (GLAPIENTRY *glPathMemoryGlyphIndexArrayNV) (GLuint  firstPathName, GLenum  fontTarget, GLsizeiptr  fontSize, const void * fontData, GLsizei  faceIndex, GLuint  firstGlyphIndex, GLsizei  numGlyphs, GLuint  pathParameterTemplate, GLfloat  emScale) = NULL;
void (GLAPIENTRY *glPathParameterfNV) (GLuint  path, GLenum  pname, GLfloat  value) = NULL;
void (GLAPIENTRY *glPathParameterfvNV) (GLuint  path, GLenum  pname, const GLfloat * value) = NULL;
void (GLAPIENTRY *glPathParameteriNV) (GLuint  path, GLenum  pname, GLint  value) = NULL;
void (GLAPIENTRY *glPathParameterivNV) (GLuint  path, GLenum  pname, const GLint * value) = NULL;
void (GLAPIENTRY *glPathStencilDepthOffsetNV) (GLfloat  factor, GLfloat  units) = NULL;
void (GLAPIENTRY *glPathStencilFuncNV) (GLenum  func, GLint  ref, GLuint  mask) = NULL;
void (GLAPIENTRY *glPathStringNV) (GLuint  path, GLenum  format, GLsizei  length, const void * pathString) = NULL;
void (GLAPIENTRY *glPathSubCommandsNV) (GLuint  path, GLsizei  commandStart, GLsizei  commandsToDelete, GLsizei  numCommands, const GLubyte * commands, GLsizei  numCoords, GLenum  coordType, const void * coords) = NULL;
void (GLAPIENTRY *glPathSubCoordsNV) (GLuint  path, GLsizei  coordStart, GLsizei  numCoords, GLenum  coordType, const void * coords) = NULL;
void (GLAPIENTRY *glPathTexGenNV) (GLenum  texCoordSet, GLenum  genMode, GLint  components, const GLfloat * coeffs) = NULL;
void (GLAPIENTRY *glPauseTransformFeedback) () = NULL;
void (GLAPIENTRY *glPauseTransformFeedbackNV) () = NULL;
void (GLAPIENTRY *glPixelDataRangeNV) (GLenum  target, GLsizei  length, const void * pointer) = NULL;
void (GLAPIENTRY *glPixelMapfv) (GLenum  map, GLsizei  mapsize, const GLfloat * values) = NULL;
void (GLAPIENTRY *glPixelMapuiv) (GLenum  map, GLsizei  mapsize, const GLuint * values) = NULL;
void (GLAPIENTRY *glPixelMapusv) (GLenum  map, GLsizei  mapsize, const GLushort * values) = NULL;
void (GLAPIENTRY *glPixelStoref) (GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glPixelStorei) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glPixelTransferf) (GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glPixelTransferi) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glPixelTransformParameterfEXT) (GLenum  target, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glPixelTransformParameterfvEXT) (GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glPixelTransformParameteriEXT) (GLenum  target, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glPixelTransformParameterivEXT) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glPixelZoom) (GLfloat  xfactor, GLfloat  yfactor) = NULL;
GLboolean (GLAPIENTRY *glPointAlongPathNV) (GLuint  path, GLsizei  startSegment, GLsizei  numSegments, GLfloat  distance, GLfloat * x, GLfloat * y, GLfloat * tangentX, GLfloat * tangentY) = NULL;
void (GLAPIENTRY *glPointParameterf) (GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glPointParameterfARB) (GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glPointParameterfEXT) (GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glPointParameterfv) (GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glPointParameterfvARB) (GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glPointParameterfvEXT) (GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glPointParameteri) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glPointParameteriNV) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glPointParameteriv) (GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glPointParameterivNV) (GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glPointSize) (GLfloat  size) = NULL;
void (GLAPIENTRY *glPolygonMode) (GLenum  face, GLenum  mode) = NULL;
void (GLAPIENTRY *glPolygonOffset) (GLfloat  factor, GLfloat  units) = NULL;
void (GLAPIENTRY *glPolygonOffsetClamp) (GLfloat  factor, GLfloat  units, GLfloat  clamp) = NULL;
void (GLAPIENTRY *glPolygonOffsetClampEXT) (GLfloat  factor, GLfloat  units, GLfloat  clamp) = NULL;
void (GLAPIENTRY *glPolygonOffsetEXT) (GLfloat  factor, GLfloat  bias) = NULL;
void (GLAPIENTRY *glPolygonStipple) (const GLubyte * mask) = NULL;
void (GLAPIENTRY *glPopAttrib) () = NULL;
void (GLAPIENTRY *glPopClientAttrib) () = NULL;
void (GLAPIENTRY *glPopDebugGroup) () = NULL;
void (GLAPIENTRY *glPopDebugGroupKHR) () = NULL;
void (GLAPIENTRY *glPopGroupMarkerEXT) () = NULL;
void (GLAPIENTRY *glPopMatrix) () = NULL;
void (GLAPIENTRY *glPopName) () = NULL;
void (GLAPIENTRY *glPresentFrameDualFillNV) (GLuint  video_slot, GLuint64EXT  minPresentTime, GLuint  beginPresentTimeId, GLuint  presentDurationId, GLenum  type, GLenum  target0, GLuint  fill0, GLenum  target1, GLuint  fill1, GLenum  target2, GLuint  fill2, GLenum  target3, GLuint  fill3) = NULL;
void (GLAPIENTRY *glPresentFrameKeyedNV) (GLuint  video_slot, GLuint64EXT  minPresentTime, GLuint  beginPresentTimeId, GLuint  presentDurationId, GLenum  type, GLenum  target0, GLuint  fill0, GLuint  key0, GLenum  target1, GLuint  fill1, GLuint  key1) = NULL;
void (GLAPIENTRY *glPrimitiveBoundingBoxARB) (GLfloat  minX, GLfloat  minY, GLfloat  minZ, GLfloat  minW, GLfloat  maxX, GLfloat  maxY, GLfloat  maxZ, GLfloat  maxW) = NULL;
void (GLAPIENTRY *glPrimitiveRestartIndex) (GLuint  index) = NULL;
void (GLAPIENTRY *glPrimitiveRestartIndexNV) (GLuint  index) = NULL;
void (GLAPIENTRY *glPrimitiveRestartNV) () = NULL;
void (GLAPIENTRY *glPrioritizeTextures) (GLsizei  n, const GLuint * textures, const GLfloat * priorities) = NULL;
void (GLAPIENTRY *glPrioritizeTexturesEXT) (GLsizei  n, const GLuint * textures, const GLclampf * priorities) = NULL;
void (GLAPIENTRY *glProgramBinary) (GLuint  program, GLenum  binaryFormat, const void * binary, GLsizei  length) = NULL;
void (GLAPIENTRY *glProgramBufferParametersIivNV) (GLenum  target, GLuint  bindingIndex, GLuint  wordIndex, GLsizei  count, const GLint * params) = NULL;
void (GLAPIENTRY *glProgramBufferParametersIuivNV) (GLenum  target, GLuint  bindingIndex, GLuint  wordIndex, GLsizei  count, const GLuint * params) = NULL;
void (GLAPIENTRY *glProgramBufferParametersfvNV) (GLenum  target, GLuint  bindingIndex, GLuint  wordIndex, GLsizei  count, const GLfloat * params) = NULL;
void (GLAPIENTRY *glProgramEnvParameter4dARB) (GLenum  target, GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glProgramEnvParameter4dvARB) (GLenum  target, GLuint  index, const GLdouble * params) = NULL;
void (GLAPIENTRY *glProgramEnvParameter4fARB) (GLenum  target, GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glProgramEnvParameter4fvARB) (GLenum  target, GLuint  index, const GLfloat * params) = NULL;
void (GLAPIENTRY *glProgramEnvParameterI4iNV) (GLenum  target, GLuint  index, GLint  x, GLint  y, GLint  z, GLint  w) = NULL;
void (GLAPIENTRY *glProgramEnvParameterI4ivNV) (GLenum  target, GLuint  index, const GLint * params) = NULL;
void (GLAPIENTRY *glProgramEnvParameterI4uiNV) (GLenum  target, GLuint  index, GLuint  x, GLuint  y, GLuint  z, GLuint  w) = NULL;
void (GLAPIENTRY *glProgramEnvParameterI4uivNV) (GLenum  target, GLuint  index, const GLuint * params) = NULL;
void (GLAPIENTRY *glProgramEnvParameters4fvEXT) (GLenum  target, GLuint  index, GLsizei  count, const GLfloat * params) = NULL;
void (GLAPIENTRY *glProgramEnvParametersI4ivNV) (GLenum  target, GLuint  index, GLsizei  count, const GLint * params) = NULL;
void (GLAPIENTRY *glProgramEnvParametersI4uivNV) (GLenum  target, GLuint  index, GLsizei  count, const GLuint * params) = NULL;
void (GLAPIENTRY *glProgramLocalParameter4dARB) (GLenum  target, GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glProgramLocalParameter4dvARB) (GLenum  target, GLuint  index, const GLdouble * params) = NULL;
void (GLAPIENTRY *glProgramLocalParameter4fARB) (GLenum  target, GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glProgramLocalParameter4fvARB) (GLenum  target, GLuint  index, const GLfloat * params) = NULL;
void (GLAPIENTRY *glProgramLocalParameterI4iNV) (GLenum  target, GLuint  index, GLint  x, GLint  y, GLint  z, GLint  w) = NULL;
void (GLAPIENTRY *glProgramLocalParameterI4ivNV) (GLenum  target, GLuint  index, const GLint * params) = NULL;
void (GLAPIENTRY *glProgramLocalParameterI4uiNV) (GLenum  target, GLuint  index, GLuint  x, GLuint  y, GLuint  z, GLuint  w) = NULL;
void (GLAPIENTRY *glProgramLocalParameterI4uivNV) (GLenum  target, GLuint  index, const GLuint * params) = NULL;
void (GLAPIENTRY *glProgramLocalParameters4fvEXT) (GLenum  target, GLuint  index, GLsizei  count, const GLfloat * params) = NULL;
void (GLAPIENTRY *glProgramLocalParametersI4ivNV) (GLenum  target, GLuint  index, GLsizei  count, const GLint * params) = NULL;
void (GLAPIENTRY *glProgramLocalParametersI4uivNV) (GLenum  target, GLuint  index, GLsizei  count, const GLuint * params) = NULL;
void (GLAPIENTRY *glProgramNamedParameter4dNV) (GLuint  id, GLsizei  len, const GLubyte * name, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glProgramNamedParameter4dvNV) (GLuint  id, GLsizei  len, const GLubyte * name, const GLdouble * v) = NULL;
void (GLAPIENTRY *glProgramNamedParameter4fNV) (GLuint  id, GLsizei  len, const GLubyte * name, GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glProgramNamedParameter4fvNV) (GLuint  id, GLsizei  len, const GLubyte * name, const GLfloat * v) = NULL;
void (GLAPIENTRY *glProgramParameter4dNV) (GLenum  target, GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glProgramParameter4dvNV) (GLenum  target, GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glProgramParameter4fNV) (GLenum  target, GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glProgramParameter4fvNV) (GLenum  target, GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glProgramParameteri) (GLuint  program, GLenum  pname, GLint  value) = NULL;
void (GLAPIENTRY *glProgramParameteriARB) (GLuint  program, GLenum  pname, GLint  value) = NULL;
void (GLAPIENTRY *glProgramParameteriEXT) (GLuint  program, GLenum  pname, GLint  value) = NULL;
void (GLAPIENTRY *glProgramParameters4dvNV) (GLenum  target, GLuint  index, GLsizei  count, const GLdouble * v) = NULL;
void (GLAPIENTRY *glProgramParameters4fvNV) (GLenum  target, GLuint  index, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glProgramPathFragmentInputGenNV) (GLuint  program, GLint  location, GLenum  genMode, GLint  components, const GLfloat * coeffs) = NULL;
void (GLAPIENTRY *glProgramStringARB) (GLenum  target, GLenum  format, GLsizei  len, const void * string) = NULL;
void (GLAPIENTRY *glProgramSubroutineParametersuivNV) (GLenum  target, GLsizei  count, const GLuint * params) = NULL;
void (GLAPIENTRY *glProgramUniform1d) (GLuint  program, GLint  location, GLdouble  v0) = NULL;
void (GLAPIENTRY *glProgramUniform1dEXT) (GLuint  program, GLint  location, GLdouble  x) = NULL;
void (GLAPIENTRY *glProgramUniform1dv) (GLuint  program, GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniform1dvEXT) (GLuint  program, GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniform1f) (GLuint  program, GLint  location, GLfloat  v0) = NULL;
void (GLAPIENTRY *glProgramUniform1fEXT) (GLuint  program, GLint  location, GLfloat  v0) = NULL;
void (GLAPIENTRY *glProgramUniform1fv) (GLuint  program, GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniform1fvEXT) (GLuint  program, GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniform1i) (GLuint  program, GLint  location, GLint  v0) = NULL;
void (GLAPIENTRY *glProgramUniform1i64ARB) (GLuint  program, GLint  location, GLint64  x) = NULL;
void (GLAPIENTRY *glProgramUniform1i64NV) (GLuint  program, GLint  location, GLint64EXT  x) = NULL;
void (GLAPIENTRY *glProgramUniform1i64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLint64 * value) = NULL;
void (GLAPIENTRY *glProgramUniform1i64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramUniform1iEXT) (GLuint  program, GLint  location, GLint  v0) = NULL;
void (GLAPIENTRY *glProgramUniform1iv) (GLuint  program, GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glProgramUniform1ivEXT) (GLuint  program, GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glProgramUniform1ui) (GLuint  program, GLint  location, GLuint  v0) = NULL;
void (GLAPIENTRY *glProgramUniform1ui64ARB) (GLuint  program, GLint  location, GLuint64  x) = NULL;
void (GLAPIENTRY *glProgramUniform1ui64NV) (GLuint  program, GLint  location, GLuint64EXT  x) = NULL;
void (GLAPIENTRY *glProgramUniform1ui64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glProgramUniform1ui64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramUniform1uiEXT) (GLuint  program, GLint  location, GLuint  v0) = NULL;
void (GLAPIENTRY *glProgramUniform1uiv) (GLuint  program, GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glProgramUniform1uivEXT) (GLuint  program, GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glProgramUniform2d) (GLuint  program, GLint  location, GLdouble  v0, GLdouble  v1) = NULL;
void (GLAPIENTRY *glProgramUniform2dEXT) (GLuint  program, GLint  location, GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glProgramUniform2dv) (GLuint  program, GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniform2dvEXT) (GLuint  program, GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniform2f) (GLuint  program, GLint  location, GLfloat  v0, GLfloat  v1) = NULL;
void (GLAPIENTRY *glProgramUniform2fEXT) (GLuint  program, GLint  location, GLfloat  v0, GLfloat  v1) = NULL;
void (GLAPIENTRY *glProgramUniform2fv) (GLuint  program, GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniform2fvEXT) (GLuint  program, GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniform2i) (GLuint  program, GLint  location, GLint  v0, GLint  v1) = NULL;
void (GLAPIENTRY *glProgramUniform2i64ARB) (GLuint  program, GLint  location, GLint64  x, GLint64  y) = NULL;
void (GLAPIENTRY *glProgramUniform2i64NV) (GLuint  program, GLint  location, GLint64EXT  x, GLint64EXT  y) = NULL;
void (GLAPIENTRY *glProgramUniform2i64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLint64 * value) = NULL;
void (GLAPIENTRY *glProgramUniform2i64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramUniform2iEXT) (GLuint  program, GLint  location, GLint  v0, GLint  v1) = NULL;
void (GLAPIENTRY *glProgramUniform2iv) (GLuint  program, GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glProgramUniform2ivEXT) (GLuint  program, GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glProgramUniform2ui) (GLuint  program, GLint  location, GLuint  v0, GLuint  v1) = NULL;
void (GLAPIENTRY *glProgramUniform2ui64ARB) (GLuint  program, GLint  location, GLuint64  x, GLuint64  y) = NULL;
void (GLAPIENTRY *glProgramUniform2ui64NV) (GLuint  program, GLint  location, GLuint64EXT  x, GLuint64EXT  y) = NULL;
void (GLAPIENTRY *glProgramUniform2ui64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glProgramUniform2ui64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramUniform2uiEXT) (GLuint  program, GLint  location, GLuint  v0, GLuint  v1) = NULL;
void (GLAPIENTRY *glProgramUniform2uiv) (GLuint  program, GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glProgramUniform2uivEXT) (GLuint  program, GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glProgramUniform3d) (GLuint  program, GLint  location, GLdouble  v0, GLdouble  v1, GLdouble  v2) = NULL;
void (GLAPIENTRY *glProgramUniform3dEXT) (GLuint  program, GLint  location, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glProgramUniform3dv) (GLuint  program, GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniform3dvEXT) (GLuint  program, GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniform3f) (GLuint  program, GLint  location, GLfloat  v0, GLfloat  v1, GLfloat  v2) = NULL;
void (GLAPIENTRY *glProgramUniform3fEXT) (GLuint  program, GLint  location, GLfloat  v0, GLfloat  v1, GLfloat  v2) = NULL;
void (GLAPIENTRY *glProgramUniform3fv) (GLuint  program, GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniform3fvEXT) (GLuint  program, GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniform3i) (GLuint  program, GLint  location, GLint  v0, GLint  v1, GLint  v2) = NULL;
void (GLAPIENTRY *glProgramUniform3i64ARB) (GLuint  program, GLint  location, GLint64  x, GLint64  y, GLint64  z) = NULL;
void (GLAPIENTRY *glProgramUniform3i64NV) (GLuint  program, GLint  location, GLint64EXT  x, GLint64EXT  y, GLint64EXT  z) = NULL;
void (GLAPIENTRY *glProgramUniform3i64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLint64 * value) = NULL;
void (GLAPIENTRY *glProgramUniform3i64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramUniform3iEXT) (GLuint  program, GLint  location, GLint  v0, GLint  v1, GLint  v2) = NULL;
void (GLAPIENTRY *glProgramUniform3iv) (GLuint  program, GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glProgramUniform3ivEXT) (GLuint  program, GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glProgramUniform3ui) (GLuint  program, GLint  location, GLuint  v0, GLuint  v1, GLuint  v2) = NULL;
void (GLAPIENTRY *glProgramUniform3ui64ARB) (GLuint  program, GLint  location, GLuint64  x, GLuint64  y, GLuint64  z) = NULL;
void (GLAPIENTRY *glProgramUniform3ui64NV) (GLuint  program, GLint  location, GLuint64EXT  x, GLuint64EXT  y, GLuint64EXT  z) = NULL;
void (GLAPIENTRY *glProgramUniform3ui64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glProgramUniform3ui64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramUniform3uiEXT) (GLuint  program, GLint  location, GLuint  v0, GLuint  v1, GLuint  v2) = NULL;
void (GLAPIENTRY *glProgramUniform3uiv) (GLuint  program, GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glProgramUniform3uivEXT) (GLuint  program, GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glProgramUniform4d) (GLuint  program, GLint  location, GLdouble  v0, GLdouble  v1, GLdouble  v2, GLdouble  v3) = NULL;
void (GLAPIENTRY *glProgramUniform4dEXT) (GLuint  program, GLint  location, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glProgramUniform4dv) (GLuint  program, GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniform4dvEXT) (GLuint  program, GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniform4f) (GLuint  program, GLint  location, GLfloat  v0, GLfloat  v1, GLfloat  v2, GLfloat  v3) = NULL;
void (GLAPIENTRY *glProgramUniform4fEXT) (GLuint  program, GLint  location, GLfloat  v0, GLfloat  v1, GLfloat  v2, GLfloat  v3) = NULL;
void (GLAPIENTRY *glProgramUniform4fv) (GLuint  program, GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniform4fvEXT) (GLuint  program, GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniform4i) (GLuint  program, GLint  location, GLint  v0, GLint  v1, GLint  v2, GLint  v3) = NULL;
void (GLAPIENTRY *glProgramUniform4i64ARB) (GLuint  program, GLint  location, GLint64  x, GLint64  y, GLint64  z, GLint64  w) = NULL;
void (GLAPIENTRY *glProgramUniform4i64NV) (GLuint  program, GLint  location, GLint64EXT  x, GLint64EXT  y, GLint64EXT  z, GLint64EXT  w) = NULL;
void (GLAPIENTRY *glProgramUniform4i64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLint64 * value) = NULL;
void (GLAPIENTRY *glProgramUniform4i64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramUniform4iEXT) (GLuint  program, GLint  location, GLint  v0, GLint  v1, GLint  v2, GLint  v3) = NULL;
void (GLAPIENTRY *glProgramUniform4iv) (GLuint  program, GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glProgramUniform4ivEXT) (GLuint  program, GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glProgramUniform4ui) (GLuint  program, GLint  location, GLuint  v0, GLuint  v1, GLuint  v2, GLuint  v3) = NULL;
void (GLAPIENTRY *glProgramUniform4ui64ARB) (GLuint  program, GLint  location, GLuint64  x, GLuint64  y, GLuint64  z, GLuint64  w) = NULL;
void (GLAPIENTRY *glProgramUniform4ui64NV) (GLuint  program, GLint  location, GLuint64EXT  x, GLuint64EXT  y, GLuint64EXT  z, GLuint64EXT  w) = NULL;
void (GLAPIENTRY *glProgramUniform4ui64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glProgramUniform4ui64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramUniform4uiEXT) (GLuint  program, GLint  location, GLuint  v0, GLuint  v1, GLuint  v2, GLuint  v3) = NULL;
void (GLAPIENTRY *glProgramUniform4uiv) (GLuint  program, GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glProgramUniform4uivEXT) (GLuint  program, GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glProgramUniformHandleui64ARB) (GLuint  program, GLint  location, GLuint64  value) = NULL;
void (GLAPIENTRY *glProgramUniformHandleui64NV) (GLuint  program, GLint  location, GLuint64  value) = NULL;
void (GLAPIENTRY *glProgramUniformHandleui64vARB) (GLuint  program, GLint  location, GLsizei  count, const GLuint64 * values) = NULL;
void (GLAPIENTRY *glProgramUniformHandleui64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLuint64 * values) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2x3dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2x3dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2x3fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2x3fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2x4dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2x4dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2x4fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix2x4fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3x2dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3x2dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3x2fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3x2fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3x4dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3x4dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3x4fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix3x4fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4x2dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4x2dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4x2fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4x2fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4x3dv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4x3dvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4x3fv) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformMatrix4x3fvEXT) (GLuint  program, GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glProgramUniformui64NV) (GLuint  program, GLint  location, GLuint64EXT  value) = NULL;
void (GLAPIENTRY *glProgramUniformui64vNV) (GLuint  program, GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glProgramVertexLimitNV) (GLenum  target, GLint  limit) = NULL;
void (GLAPIENTRY *glProvokingVertex) (GLenum  mode) = NULL;
void (GLAPIENTRY *glProvokingVertexEXT) (GLenum  mode) = NULL;
void (GLAPIENTRY *glPushAttrib) (GLbitfield  mask) = NULL;
void (GLAPIENTRY *glPushClientAttrib) (GLbitfield  mask) = NULL;
void (GLAPIENTRY *glPushClientAttribDefaultEXT) (GLbitfield  mask) = NULL;
void (GLAPIENTRY *glPushDebugGroup) (GLenum  source, GLuint  id, GLsizei  length, const GLchar * message) = NULL;
void (GLAPIENTRY *glPushDebugGroupKHR) (GLenum  source, GLuint  id, GLsizei  length, const GLchar * message) = NULL;
void (GLAPIENTRY *glPushGroupMarkerEXT) (GLsizei  length, const GLchar * marker) = NULL;
void (GLAPIENTRY *glPushMatrix) () = NULL;
void (GLAPIENTRY *glPushName) (GLuint  name) = NULL;
void (GLAPIENTRY *glQueryCounter) (GLuint  id, GLenum  target) = NULL;
void (GLAPIENTRY *glQueryObjectParameteruiAMD) (GLenum  target, GLuint  id, GLenum  pname, GLuint  param) = NULL;
GLint (GLAPIENTRY *glQueryResourceNV) (GLenum  queryType, GLint  tagId, GLuint  count, GLint * buffer) = NULL;
void (GLAPIENTRY *glQueryResourceTagNV) (GLint  tagId, const GLchar * tagString) = NULL;
void (GLAPIENTRY *glRasterPos2d) (GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glRasterPos2dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glRasterPos2f) (GLfloat  x, GLfloat  y) = NULL;
void (GLAPIENTRY *glRasterPos2fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glRasterPos2i) (GLint  x, GLint  y) = NULL;
void (GLAPIENTRY *glRasterPos2iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glRasterPos2s) (GLshort  x, GLshort  y) = NULL;
void (GLAPIENTRY *glRasterPos2sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glRasterPos3d) (GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glRasterPos3dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glRasterPos3f) (GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glRasterPos3fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glRasterPos3i) (GLint  x, GLint  y, GLint  z) = NULL;
void (GLAPIENTRY *glRasterPos3iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glRasterPos3s) (GLshort  x, GLshort  y, GLshort  z) = NULL;
void (GLAPIENTRY *glRasterPos3sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glRasterPos4d) (GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glRasterPos4dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glRasterPos4f) (GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glRasterPos4fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glRasterPos4i) (GLint  x, GLint  y, GLint  z, GLint  w) = NULL;
void (GLAPIENTRY *glRasterPos4iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glRasterPos4s) (GLshort  x, GLshort  y, GLshort  z, GLshort  w) = NULL;
void (GLAPIENTRY *glRasterPos4sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glRasterSamplesEXT) (GLuint  samples, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glReadBuffer) (GLenum  src) = NULL;
void (GLAPIENTRY *glReadPixels) (GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, void * pixels) = NULL;
void (GLAPIENTRY *glReadnPixels) (GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, GLsizei  bufSize, void * data) = NULL;
void (GLAPIENTRY *glReadnPixelsARB) (GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, GLsizei  bufSize, void * data) = NULL;
void (GLAPIENTRY *glReadnPixelsKHR) (GLint  x, GLint  y, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, GLsizei  bufSize, void * data) = NULL;
GLboolean (GLAPIENTRY *glReleaseKeyedMutexWin32EXT) (GLuint  memory, GLuint64  key) = NULL;
void (GLAPIENTRY *glRectd) (GLdouble  x1, GLdouble  y1, GLdouble  x2, GLdouble  y2) = NULL;
void (GLAPIENTRY *glRectdv) (const GLdouble * v1, const GLdouble * v2) = NULL;
void (GLAPIENTRY *glRectf) (GLfloat  x1, GLfloat  y1, GLfloat  x2, GLfloat  y2) = NULL;
void (GLAPIENTRY *glRectfv) (const GLfloat * v1, const GLfloat * v2) = NULL;
void (GLAPIENTRY *glRecti) (GLint  x1, GLint  y1, GLint  x2, GLint  y2) = NULL;
void (GLAPIENTRY *glRectiv) (const GLint * v1, const GLint * v2) = NULL;
void (GLAPIENTRY *glRects) (GLshort  x1, GLshort  y1, GLshort  x2, GLshort  y2) = NULL;
void (GLAPIENTRY *glRectsv) (const GLshort * v1, const GLshort * v2) = NULL;
void (GLAPIENTRY *glReleaseShaderCompiler) () = NULL;
void (GLAPIENTRY *glRenderGpuMaskNV) (GLbitfield  mask) = NULL;
GLint (GLAPIENTRY *glRenderMode) (GLenum  mode) = NULL;
void (GLAPIENTRY *glRenderbufferStorage) (GLenum  target, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glRenderbufferStorageEXT) (GLenum  target, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glRenderbufferStorageMultisample) (GLenum  target, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glRenderbufferStorageMultisampleAdvancedAMD) (GLenum  target, GLsizei  samples, GLsizei  storageSamples, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glRenderbufferStorageMultisampleCoverageNV) (GLenum  target, GLsizei  coverageSamples, GLsizei  colorSamples, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glRenderbufferStorageMultisampleEXT) (GLenum  target, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glRequestResidentProgramsNV) (GLsizei  n, const GLuint * programs) = NULL;
void (GLAPIENTRY *glResetHistogram) (GLenum  target) = NULL;
void (GLAPIENTRY *glResetHistogramEXT) (GLenum  target) = NULL;
void (GLAPIENTRY *glResetMemoryObjectParameterNV) (GLuint  memory, GLenum  pname) = NULL;
void (GLAPIENTRY *glResetMinmax) (GLenum  target) = NULL;
void (GLAPIENTRY *glResetMinmaxEXT) (GLenum  target) = NULL;
void (GLAPIENTRY *glResolveDepthValuesNV) () = NULL;
void (GLAPIENTRY *glResumeTransformFeedback) () = NULL;
void (GLAPIENTRY *glResumeTransformFeedbackNV) () = NULL;
void (GLAPIENTRY *glRotated) (GLdouble  angle, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glRotatef) (GLfloat  angle, GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glSampleCoverage) (GLfloat  value, GLboolean  invert) = NULL;
void (GLAPIENTRY *glSampleCoverageARB) (GLfloat  value, GLboolean  invert) = NULL;
void (GLAPIENTRY *glSampleMaskEXT) (GLclampf  value, GLboolean  invert) = NULL;
void (GLAPIENTRY *glSampleMaskIndexedNV) (GLuint  index, GLbitfield  mask) = NULL;
void (GLAPIENTRY *glSampleMaski) (GLuint  maskNumber, GLbitfield  mask) = NULL;
void (GLAPIENTRY *glSamplePatternEXT) (GLenum  pattern) = NULL;
void (GLAPIENTRY *glSamplerParameterIiv) (GLuint  sampler, GLenum  pname, const GLint * param) = NULL;
void (GLAPIENTRY *glSamplerParameterIuiv) (GLuint  sampler, GLenum  pname, const GLuint * param) = NULL;
void (GLAPIENTRY *glSamplerParameterf) (GLuint  sampler, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glSamplerParameterfv) (GLuint  sampler, GLenum  pname, const GLfloat * param) = NULL;
void (GLAPIENTRY *glSamplerParameteri) (GLuint  sampler, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glSamplerParameteriv) (GLuint  sampler, GLenum  pname, const GLint * param) = NULL;
void (GLAPIENTRY *glScaled) (GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glScalef) (GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glScissor) (GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glScissorArrayv) (GLuint  first, GLsizei  count, const GLint * v) = NULL;
void (GLAPIENTRY *glScissorExclusiveArrayvNV) (GLuint  first, GLsizei  count, const GLint * v) = NULL;
void (GLAPIENTRY *glScissorExclusiveNV) (GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glScissorIndexed) (GLuint  index, GLint  left, GLint  bottom, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glScissorIndexedv) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3b) (GLbyte  red, GLbyte  green, GLbyte  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3bEXT) (GLbyte  red, GLbyte  green, GLbyte  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3bv) (const GLbyte * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3bvEXT) (const GLbyte * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3d) (GLdouble  red, GLdouble  green, GLdouble  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3dEXT) (GLdouble  red, GLdouble  green, GLdouble  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3dvEXT) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3f) (GLfloat  red, GLfloat  green, GLfloat  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3fEXT) (GLfloat  red, GLfloat  green, GLfloat  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3fvEXT) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3hNV) (GLhalfNV  red, GLhalfNV  green, GLhalfNV  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3i) (GLint  red, GLint  green, GLint  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3iEXT) (GLint  red, GLint  green, GLint  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3ivEXT) (const GLint * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3s) (GLshort  red, GLshort  green, GLshort  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3sEXT) (GLshort  red, GLshort  green, GLshort  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3svEXT) (const GLshort * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3ub) (GLubyte  red, GLubyte  green, GLubyte  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3ubEXT) (GLubyte  red, GLubyte  green, GLubyte  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3ubv) (const GLubyte * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3ubvEXT) (const GLubyte * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3ui) (GLuint  red, GLuint  green, GLuint  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3uiEXT) (GLuint  red, GLuint  green, GLuint  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3uiv) (const GLuint * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3uivEXT) (const GLuint * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3us) (GLushort  red, GLushort  green, GLushort  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3usEXT) (GLushort  red, GLushort  green, GLushort  blue) = NULL;
void (GLAPIENTRY *glSecondaryColor3usv) (const GLushort * v) = NULL;
void (GLAPIENTRY *glSecondaryColor3usvEXT) (const GLushort * v) = NULL;
void (GLAPIENTRY *glSecondaryColorFormatNV) (GLint  size, GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glSecondaryColorP3ui) (GLenum  type, GLuint  color) = NULL;
void (GLAPIENTRY *glSecondaryColorP3uiv) (GLenum  type, const GLuint * color) = NULL;
void (GLAPIENTRY *glSecondaryColorPointer) (GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glSecondaryColorPointerEXT) (GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glSelectBuffer) (GLsizei  size, GLuint * buffer) = NULL;
void (GLAPIENTRY *glSelectPerfMonitorCountersAMD) (GLuint  monitor, GLboolean  enable, GLuint  group, GLint  numCounters, GLuint * counterList) = NULL;
void (GLAPIENTRY *glSemaphoreParameterui64vEXT) (GLuint  semaphore, GLenum  pname, const GLuint64 * params) = NULL;
void (GLAPIENTRY *glSeparableFilter2D) (GLenum  target, GLenum  internalformat, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * row, const void * column) = NULL;
void (GLAPIENTRY *glSeparableFilter2DEXT) (GLenum  target, GLenum  internalformat, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * row, const void * column) = NULL;
void (GLAPIENTRY *glSetFenceAPPLE) (GLuint  fence) = NULL;
void (GLAPIENTRY *glSetFenceNV) (GLuint  fence, GLenum  condition) = NULL;
void (GLAPIENTRY *glSetInvariantEXT) (GLuint  id, GLenum  type, const void * addr) = NULL;
void (GLAPIENTRY *glSetLocalConstantEXT) (GLuint  id, GLenum  type, const void * addr) = NULL;
void (GLAPIENTRY *glSetMultisamplefvAMD) (GLenum  pname, GLuint  index, const GLfloat * val) = NULL;
void (GLAPIENTRY *glShadeModel) (GLenum  mode) = NULL;
void (GLAPIENTRY *glShaderBinary) (GLsizei  count, const GLuint * shaders, GLenum  binaryformat, const void * binary, GLsizei  length) = NULL;
void (GLAPIENTRY *glShaderOp1EXT) (GLenum  op, GLuint  res, GLuint  arg1) = NULL;
void (GLAPIENTRY *glShaderOp2EXT) (GLenum  op, GLuint  res, GLuint  arg1, GLuint  arg2) = NULL;
void (GLAPIENTRY *glShaderOp3EXT) (GLenum  op, GLuint  res, GLuint  arg1, GLuint  arg2, GLuint  arg3) = NULL;
void (GLAPIENTRY *glShaderSource) (GLuint  shader, GLsizei  count, const GLchar *const* string, const GLint * length) = NULL;
void (GLAPIENTRY *glShaderSourceARB) (GLhandleARB  shaderObj, GLsizei  count, const GLcharARB ** string, const GLint * length) = NULL;
void (GLAPIENTRY *glShaderStorageBlockBinding) (GLuint  program, GLuint  storageBlockIndex, GLuint  storageBlockBinding) = NULL;
void (GLAPIENTRY *glShadingRateImageBarrierNV) (GLboolean  synchronize) = NULL;
void (GLAPIENTRY *glShadingRateImagePaletteNV) (GLuint  viewport, GLuint  first, GLsizei  count, const GLenum * rates) = NULL;
void (GLAPIENTRY *glShadingRateSampleOrderNV) (GLenum  order) = NULL;
void (GLAPIENTRY *glShadingRateSampleOrderCustomNV) (GLenum  rate, GLuint  samples, const GLint * locations) = NULL;
void (GLAPIENTRY *glSignalSemaphoreEXT) (GLuint  semaphore, GLuint  numBufferBarriers, const GLuint * buffers, GLuint  numTextureBarriers, const GLuint * textures, const GLenum * dstLayouts) = NULL;
void (GLAPIENTRY *glSpecializeShader) (GLuint  shader, const GLchar * pEntryPoint, GLuint  numSpecializationConstants, const GLuint * pConstantIndex, const GLuint * pConstantValue) = NULL;
void (GLAPIENTRY *glSpecializeShaderARB) (GLuint  shader, const GLchar * pEntryPoint, GLuint  numSpecializationConstants, const GLuint * pConstantIndex, const GLuint * pConstantValue) = NULL;
void (GLAPIENTRY *glStateCaptureNV) (GLuint  state, GLenum  mode) = NULL;
void (GLAPIENTRY *glStencilClearTagEXT) (GLsizei  stencilTagBits, GLuint  stencilClearTag) = NULL;
void (GLAPIENTRY *glStencilFillPathInstancedNV) (GLsizei  numPaths, GLenum  pathNameType, const void * paths, GLuint  pathBase, GLenum  fillMode, GLuint  mask, GLenum  transformType, const GLfloat * transformValues) = NULL;
void (GLAPIENTRY *glStencilFillPathNV) (GLuint  path, GLenum  fillMode, GLuint  mask) = NULL;
void (GLAPIENTRY *glStencilFunc) (GLenum  func, GLint  ref, GLuint  mask) = NULL;
void (GLAPIENTRY *glStencilFuncSeparate) (GLenum  face, GLenum  func, GLint  ref, GLuint  mask) = NULL;
void (GLAPIENTRY *glStencilMask) (GLuint  mask) = NULL;
void (GLAPIENTRY *glStencilMaskSeparate) (GLenum  face, GLuint  mask) = NULL;
void (GLAPIENTRY *glStencilOp) (GLenum  fail, GLenum  zfail, GLenum  zpass) = NULL;
void (GLAPIENTRY *glStencilOpSeparate) (GLenum  face, GLenum  sfail, GLenum  dpfail, GLenum  dppass) = NULL;
void (GLAPIENTRY *glStencilOpValueAMD) (GLenum  face, GLuint  value) = NULL;
void (GLAPIENTRY *glStencilStrokePathInstancedNV) (GLsizei  numPaths, GLenum  pathNameType, const void * paths, GLuint  pathBase, GLint  reference, GLuint  mask, GLenum  transformType, const GLfloat * transformValues) = NULL;
void (GLAPIENTRY *glStencilStrokePathNV) (GLuint  path, GLint  reference, GLuint  mask) = NULL;
void (GLAPIENTRY *glStencilThenCoverFillPathInstancedNV) (GLsizei  numPaths, GLenum  pathNameType, const void * paths, GLuint  pathBase, GLenum  fillMode, GLuint  mask, GLenum  coverMode, GLenum  transformType, const GLfloat * transformValues) = NULL;
void (GLAPIENTRY *glStencilThenCoverFillPathNV) (GLuint  path, GLenum  fillMode, GLuint  mask, GLenum  coverMode) = NULL;
void (GLAPIENTRY *glStencilThenCoverStrokePathInstancedNV) (GLsizei  numPaths, GLenum  pathNameType, const void * paths, GLuint  pathBase, GLint  reference, GLuint  mask, GLenum  coverMode, GLenum  transformType, const GLfloat * transformValues) = NULL;
void (GLAPIENTRY *glStencilThenCoverStrokePathNV) (GLuint  path, GLint  reference, GLuint  mask, GLenum  coverMode) = NULL;
void (GLAPIENTRY *glSubpixelPrecisionBiasNV) (GLuint  xbits, GLuint  ybits) = NULL;
void (GLAPIENTRY *glSwizzleEXT) (GLuint  res, GLuint  in, GLenum  outX, GLenum  outY, GLenum  outZ, GLenum  outW) = NULL;
void (GLAPIENTRY *glSyncTextureINTEL) (GLuint  texture) = NULL;
void (GLAPIENTRY *glTangent3bEXT) (GLbyte  tx, GLbyte  ty, GLbyte  tz) = NULL;
void (GLAPIENTRY *glTangent3bvEXT) (const GLbyte * v) = NULL;
void (GLAPIENTRY *glTangent3dEXT) (GLdouble  tx, GLdouble  ty, GLdouble  tz) = NULL;
void (GLAPIENTRY *glTangent3dvEXT) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glTangent3fEXT) (GLfloat  tx, GLfloat  ty, GLfloat  tz) = NULL;
void (GLAPIENTRY *glTangent3fvEXT) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glTangent3iEXT) (GLint  tx, GLint  ty, GLint  tz) = NULL;
void (GLAPIENTRY *glTangent3ivEXT) (const GLint * v) = NULL;
void (GLAPIENTRY *glTangent3sEXT) (GLshort  tx, GLshort  ty, GLshort  tz) = NULL;
void (GLAPIENTRY *glTangent3svEXT) (const GLshort * v) = NULL;
void (GLAPIENTRY *glTangentPointerEXT) (GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glTessellationFactorAMD) (GLfloat  factor) = NULL;
void (GLAPIENTRY *glTessellationModeAMD) (GLenum  mode) = NULL;
GLboolean (GLAPIENTRY *glTestFenceAPPLE) (GLuint  fence) = NULL;
GLboolean (GLAPIENTRY *glTestFenceNV) (GLuint  fence) = NULL;
GLboolean (GLAPIENTRY *glTestObjectAPPLE) (GLenum  object, GLuint  name) = NULL;
void (GLAPIENTRY *glTexAttachMemoryNV) (GLenum  target, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTexBuffer) (GLenum  target, GLenum  internalformat, GLuint  buffer) = NULL;
void (GLAPIENTRY *glTexBufferARB) (GLenum  target, GLenum  internalformat, GLuint  buffer) = NULL;
void (GLAPIENTRY *glTexBufferEXT) (GLenum  target, GLenum  internalformat, GLuint  buffer) = NULL;
void (GLAPIENTRY *glTexBufferRange) (GLenum  target, GLenum  internalformat, GLuint  buffer, GLintptr  offset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glTexCoord1d) (GLdouble  s) = NULL;
void (GLAPIENTRY *glTexCoord1dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glTexCoord1f) (GLfloat  s) = NULL;
void (GLAPIENTRY *glTexCoord1fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glTexCoord1hNV) (GLhalfNV  s) = NULL;
void (GLAPIENTRY *glTexCoord1hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glTexCoord1i) (GLint  s) = NULL;
void (GLAPIENTRY *glTexCoord1iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glTexCoord1s) (GLshort  s) = NULL;
void (GLAPIENTRY *glTexCoord1sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glTexCoord2d) (GLdouble  s, GLdouble  t) = NULL;
void (GLAPIENTRY *glTexCoord2dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glTexCoord2f) (GLfloat  s, GLfloat  t) = NULL;
void (GLAPIENTRY *glTexCoord2fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glTexCoord2hNV) (GLhalfNV  s, GLhalfNV  t) = NULL;
void (GLAPIENTRY *glTexCoord2hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glTexCoord2i) (GLint  s, GLint  t) = NULL;
void (GLAPIENTRY *glTexCoord2iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glTexCoord2s) (GLshort  s, GLshort  t) = NULL;
void (GLAPIENTRY *glTexCoord2sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glTexCoord3d) (GLdouble  s, GLdouble  t, GLdouble  r) = NULL;
void (GLAPIENTRY *glTexCoord3dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glTexCoord3f) (GLfloat  s, GLfloat  t, GLfloat  r) = NULL;
void (GLAPIENTRY *glTexCoord3fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glTexCoord3hNV) (GLhalfNV  s, GLhalfNV  t, GLhalfNV  r) = NULL;
void (GLAPIENTRY *glTexCoord3hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glTexCoord3i) (GLint  s, GLint  t, GLint  r) = NULL;
void (GLAPIENTRY *glTexCoord3iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glTexCoord3s) (GLshort  s, GLshort  t, GLshort  r) = NULL;
void (GLAPIENTRY *glTexCoord3sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glTexCoord4d) (GLdouble  s, GLdouble  t, GLdouble  r, GLdouble  q) = NULL;
void (GLAPIENTRY *glTexCoord4dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glTexCoord4f) (GLfloat  s, GLfloat  t, GLfloat  r, GLfloat  q) = NULL;
void (GLAPIENTRY *glTexCoord4fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glTexCoord4hNV) (GLhalfNV  s, GLhalfNV  t, GLhalfNV  r, GLhalfNV  q) = NULL;
void (GLAPIENTRY *glTexCoord4hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glTexCoord4i) (GLint  s, GLint  t, GLint  r, GLint  q) = NULL;
void (GLAPIENTRY *glTexCoord4iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glTexCoord4s) (GLshort  s, GLshort  t, GLshort  r, GLshort  q) = NULL;
void (GLAPIENTRY *glTexCoord4sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glTexCoordFormatNV) (GLint  size, GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glTexCoordP1ui) (GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glTexCoordP1uiv) (GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glTexCoordP2ui) (GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glTexCoordP2uiv) (GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glTexCoordP3ui) (GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glTexCoordP3uiv) (GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glTexCoordP4ui) (GLenum  type, GLuint  coords) = NULL;
void (GLAPIENTRY *glTexCoordP4uiv) (GLenum  type, const GLuint * coords) = NULL;
void (GLAPIENTRY *glTexCoordPointer) (GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glTexCoordPointerEXT) (GLint  size, GLenum  type, GLsizei  stride, GLsizei  count, const void * pointer) = NULL;
void (GLAPIENTRY *glTexCoordPointervINTEL) (GLint  size, GLenum  type, const void ** pointer) = NULL;
void (GLAPIENTRY *glTexEnvf) (GLenum  target, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glTexEnvfv) (GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glTexEnvi) (GLenum  target, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glTexEnviv) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glTexGend) (GLenum  coord, GLenum  pname, GLdouble  param) = NULL;
void (GLAPIENTRY *glTexGendv) (GLenum  coord, GLenum  pname, const GLdouble * params) = NULL;
void (GLAPIENTRY *glTexGenf) (GLenum  coord, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glTexGenfv) (GLenum  coord, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glTexGeni) (GLenum  coord, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glTexGeniv) (GLenum  coord, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glTexImage1D) (GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexImage2D) (GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLsizei  height, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexImage2DMultisample) (GLenum  target, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glTexImage2DMultisampleCoverageNV) (GLenum  target, GLsizei  coverageSamples, GLsizei  colorSamples, GLint  internalFormat, GLsizei  width, GLsizei  height, GLboolean  fixedSampleLocations) = NULL;
void (GLAPIENTRY *glTexImage3D) (GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexImage3DEXT) (GLenum  target, GLint  level, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexImage3DMultisample) (GLenum  target, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glTexImage3DMultisampleCoverageNV) (GLenum  target, GLsizei  coverageSamples, GLsizei  colorSamples, GLint  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedSampleLocations) = NULL;
void (GLAPIENTRY *glTexPageCommitmentARB) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  commit) = NULL;
void (GLAPIENTRY *glTexParameterIiv) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glTexParameterIivEXT) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glTexParameterIuiv) (GLenum  target, GLenum  pname, const GLuint * params) = NULL;
void (GLAPIENTRY *glTexParameterIuivEXT) (GLenum  target, GLenum  pname, const GLuint * params) = NULL;
void (GLAPIENTRY *glTexParameterf) (GLenum  target, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glTexParameterfv) (GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glTexParameteri) (GLenum  target, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glTexParameteriv) (GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glTexRenderbufferNV) (GLenum  target, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glTexStorage1D) (GLenum  target, GLsizei  levels, GLenum  internalformat, GLsizei  width) = NULL;
void (GLAPIENTRY *glTexStorage2D) (GLenum  target, GLsizei  levels, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glTexStorage2DMultisample) (GLenum  target, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glTexStorage3D) (GLenum  target, GLsizei  levels, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth) = NULL;
void (GLAPIENTRY *glTexStorage3DMultisample) (GLenum  target, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glTexStorageMem1DEXT) (GLenum  target, GLsizei  levels, GLenum  internalFormat, GLsizei  width, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTexStorageMem2DEXT) (GLenum  target, GLsizei  levels, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTexStorageMem2DMultisampleEXT) (GLenum  target, GLsizei  samples, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLboolean  fixedSampleLocations, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTexStorageMem3DEXT) (GLenum  target, GLsizei  levels, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTexStorageMem3DMultisampleEXT) (GLenum  target, GLsizei  samples, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedSampleLocations, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTexStorageSparseAMD) (GLenum  target, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLsizei  layers, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glTexSubImage1D) (GLenum  target, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexSubImage1DEXT) (GLenum  target, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexSubImage2D) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexSubImage2DEXT) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexSubImage3D) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTexSubImage3DEXT) (GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureAttachMemoryNV) (GLuint  texture, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTextureBarrier) () = NULL;
void (GLAPIENTRY *glTextureBarrierNV) () = NULL;
void (GLAPIENTRY *glTextureBuffer) (GLuint  texture, GLenum  internalformat, GLuint  buffer) = NULL;
void (GLAPIENTRY *glTextureBufferEXT) (GLuint  texture, GLenum  target, GLenum  internalformat, GLuint  buffer) = NULL;
void (GLAPIENTRY *glTextureBufferRange) (GLuint  texture, GLenum  internalformat, GLuint  buffer, GLintptr  offset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glTextureBufferRangeEXT) (GLuint  texture, GLenum  target, GLenum  internalformat, GLuint  buffer, GLintptr  offset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glTextureImage1DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureImage2DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLsizei  height, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureImage2DMultisampleCoverageNV) (GLuint  texture, GLenum  target, GLsizei  coverageSamples, GLsizei  colorSamples, GLint  internalFormat, GLsizei  width, GLsizei  height, GLboolean  fixedSampleLocations) = NULL;
void (GLAPIENTRY *glTextureImage2DMultisampleNV) (GLuint  texture, GLenum  target, GLsizei  samples, GLint  internalFormat, GLsizei  width, GLsizei  height, GLboolean  fixedSampleLocations) = NULL;
void (GLAPIENTRY *glTextureImage3DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLint  border, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureImage3DMultisampleCoverageNV) (GLuint  texture, GLenum  target, GLsizei  coverageSamples, GLsizei  colorSamples, GLint  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedSampleLocations) = NULL;
void (GLAPIENTRY *glTextureImage3DMultisampleNV) (GLuint  texture, GLenum  target, GLsizei  samples, GLint  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedSampleLocations) = NULL;
void (GLAPIENTRY *glTextureLightEXT) (GLenum  pname) = NULL;
void (GLAPIENTRY *glTextureMaterialEXT) (GLenum  face, GLenum  mode) = NULL;
void (GLAPIENTRY *glTextureNormalEXT) (GLenum  mode) = NULL;
void (GLAPIENTRY *glTexturePageCommitmentEXT) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  commit) = NULL;
void (GLAPIENTRY *glTextureParameterIiv) (GLuint  texture, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glTextureParameterIivEXT) (GLuint  texture, GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glTextureParameterIuiv) (GLuint  texture, GLenum  pname, const GLuint * params) = NULL;
void (GLAPIENTRY *glTextureParameterIuivEXT) (GLuint  texture, GLenum  target, GLenum  pname, const GLuint * params) = NULL;
void (GLAPIENTRY *glTextureParameterf) (GLuint  texture, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glTextureParameterfEXT) (GLuint  texture, GLenum  target, GLenum  pname, GLfloat  param) = NULL;
void (GLAPIENTRY *glTextureParameterfv) (GLuint  texture, GLenum  pname, const GLfloat * param) = NULL;
void (GLAPIENTRY *glTextureParameterfvEXT) (GLuint  texture, GLenum  target, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glTextureParameteri) (GLuint  texture, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glTextureParameteriEXT) (GLuint  texture, GLenum  target, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glTextureParameteriv) (GLuint  texture, GLenum  pname, const GLint * param) = NULL;
void (GLAPIENTRY *glTextureParameterivEXT) (GLuint  texture, GLenum  target, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glTextureRangeAPPLE) (GLenum  target, GLsizei  length, const void * pointer) = NULL;
void (GLAPIENTRY *glTextureRenderbufferEXT) (GLuint  texture, GLenum  target, GLuint  renderbuffer) = NULL;
void (GLAPIENTRY *glTextureStorage1D) (GLuint  texture, GLsizei  levels, GLenum  internalformat, GLsizei  width) = NULL;
void (GLAPIENTRY *glTextureStorage1DEXT) (GLuint  texture, GLenum  target, GLsizei  levels, GLenum  internalformat, GLsizei  width) = NULL;
void (GLAPIENTRY *glTextureStorage2D) (GLuint  texture, GLsizei  levels, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glTextureStorage2DEXT) (GLuint  texture, GLenum  target, GLsizei  levels, GLenum  internalformat, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glTextureStorage2DMultisample) (GLuint  texture, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glTextureStorage2DMultisampleEXT) (GLuint  texture, GLenum  target, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glTextureStorage3D) (GLuint  texture, GLsizei  levels, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth) = NULL;
void (GLAPIENTRY *glTextureStorage3DEXT) (GLuint  texture, GLenum  target, GLsizei  levels, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth) = NULL;
void (GLAPIENTRY *glTextureStorage3DMultisample) (GLuint  texture, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glTextureStorage3DMultisampleEXT) (GLuint  texture, GLenum  target, GLsizei  samples, GLenum  internalformat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedsamplelocations) = NULL;
void (GLAPIENTRY *glTextureStorageMem1DEXT) (GLuint  texture, GLsizei  levels, GLenum  internalFormat, GLsizei  width, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTextureStorageMem2DEXT) (GLuint  texture, GLsizei  levels, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTextureStorageMem2DMultisampleEXT) (GLuint  texture, GLsizei  samples, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLboolean  fixedSampleLocations, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTextureStorageMem3DEXT) (GLuint  texture, GLsizei  levels, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTextureStorageMem3DMultisampleEXT) (GLuint  texture, GLsizei  samples, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLboolean  fixedSampleLocations, GLuint  memory, GLuint64  offset) = NULL;
void (GLAPIENTRY *glTextureStorageSparseAMD) (GLuint  texture, GLenum  target, GLenum  internalFormat, GLsizei  width, GLsizei  height, GLsizei  depth, GLsizei  layers, GLbitfield  flags) = NULL;
void (GLAPIENTRY *glTextureSubImage1D) (GLuint  texture, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureSubImage1DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLsizei  width, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureSubImage2D) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureSubImage2DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLsizei  width, GLsizei  height, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureSubImage3D) (GLuint  texture, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureSubImage3DEXT) (GLuint  texture, GLenum  target, GLint  level, GLint  xoffset, GLint  yoffset, GLint  zoffset, GLsizei  width, GLsizei  height, GLsizei  depth, GLenum  format, GLenum  type, const void * pixels) = NULL;
void (GLAPIENTRY *glTextureView) (GLuint  texture, GLenum  target, GLuint  origtexture, GLenum  internalformat, GLuint  minlevel, GLuint  numlevels, GLuint  minlayer, GLuint  numlayers) = NULL;
void (GLAPIENTRY *glTrackMatrixNV) (GLenum  target, GLuint  address, GLenum  matrix, GLenum  transform) = NULL;
void (GLAPIENTRY *glTransformFeedbackAttribsNV) (GLsizei  count, const GLint * attribs, GLenum  bufferMode) = NULL;
void (GLAPIENTRY *glTransformFeedbackBufferBase) (GLuint  xfb, GLuint  index, GLuint  buffer) = NULL;
void (GLAPIENTRY *glTransformFeedbackBufferRange) (GLuint  xfb, GLuint  index, GLuint  buffer, GLintptr  offset, GLsizeiptr  size) = NULL;
void (GLAPIENTRY *glTransformFeedbackStreamAttribsNV) (GLsizei  count, const GLint * attribs, GLsizei  nbuffers, const GLint * bufstreams, GLenum  bufferMode) = NULL;
void (GLAPIENTRY *glTransformFeedbackVaryings) (GLuint  program, GLsizei  count, const GLchar *const* varyings, GLenum  bufferMode) = NULL;
void (GLAPIENTRY *glTransformFeedbackVaryingsEXT) (GLuint  program, GLsizei  count, const GLchar *const* varyings, GLenum  bufferMode) = NULL;
void (GLAPIENTRY *glTransformFeedbackVaryingsNV) (GLuint  program, GLsizei  count, const GLint * locations, GLenum  bufferMode) = NULL;
void (GLAPIENTRY *glTransformPathNV) (GLuint  resultPath, GLuint  srcPath, GLenum  transformType, const GLfloat * transformValues) = NULL;
void (GLAPIENTRY *glTranslated) (GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glTranslatef) (GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glUniform1d) (GLint  location, GLdouble  x) = NULL;
void (GLAPIENTRY *glUniform1dv) (GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniform1f) (GLint  location, GLfloat  v0) = NULL;
void (GLAPIENTRY *glUniform1fARB) (GLint  location, GLfloat  v0) = NULL;
void (GLAPIENTRY *glUniform1fv) (GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniform1fvARB) (GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniform1i) (GLint  location, GLint  v0) = NULL;
void (GLAPIENTRY *glUniform1i64ARB) (GLint  location, GLint64  x) = NULL;
void (GLAPIENTRY *glUniform1i64NV) (GLint  location, GLint64EXT  x) = NULL;
void (GLAPIENTRY *glUniform1i64vARB) (GLint  location, GLsizei  count, const GLint64 * value) = NULL;
void (GLAPIENTRY *glUniform1i64vNV) (GLint  location, GLsizei  count, const GLint64EXT * value) = NULL;
void (GLAPIENTRY *glUniform1iARB) (GLint  location, GLint  v0) = NULL;
void (GLAPIENTRY *glUniform1iv) (GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glUniform1ivARB) (GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glUniform1ui) (GLint  location, GLuint  v0) = NULL;
void (GLAPIENTRY *glUniform1ui64ARB) (GLint  location, GLuint64  x) = NULL;
void (GLAPIENTRY *glUniform1ui64NV) (GLint  location, GLuint64EXT  x) = NULL;
void (GLAPIENTRY *glUniform1ui64vARB) (GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glUniform1ui64vNV) (GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glUniform1uiEXT) (GLint  location, GLuint  v0) = NULL;
void (GLAPIENTRY *glUniform1uiv) (GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glUniform1uivEXT) (GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glUniform2d) (GLint  location, GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glUniform2dv) (GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniform2f) (GLint  location, GLfloat  v0, GLfloat  v1) = NULL;
void (GLAPIENTRY *glUniform2fARB) (GLint  location, GLfloat  v0, GLfloat  v1) = NULL;
void (GLAPIENTRY *glUniform2fv) (GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniform2fvARB) (GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniform2i) (GLint  location, GLint  v0, GLint  v1) = NULL;
void (GLAPIENTRY *glUniform2i64ARB) (GLint  location, GLint64  x, GLint64  y) = NULL;
void (GLAPIENTRY *glUniform2i64NV) (GLint  location, GLint64EXT  x, GLint64EXT  y) = NULL;
void (GLAPIENTRY *glUniform2i64vARB) (GLint  location, GLsizei  count, const GLint64 * value) = NULL;
void (GLAPIENTRY *glUniform2i64vNV) (GLint  location, GLsizei  count, const GLint64EXT * value) = NULL;
void (GLAPIENTRY *glUniform2iARB) (GLint  location, GLint  v0, GLint  v1) = NULL;
void (GLAPIENTRY *glUniform2iv) (GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glUniform2ivARB) (GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glUniform2ui) (GLint  location, GLuint  v0, GLuint  v1) = NULL;
void (GLAPIENTRY *glUniform2ui64ARB) (GLint  location, GLuint64  x, GLuint64  y) = NULL;
void (GLAPIENTRY *glUniform2ui64NV) (GLint  location, GLuint64EXT  x, GLuint64EXT  y) = NULL;
void (GLAPIENTRY *glUniform2ui64vARB) (GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glUniform2ui64vNV) (GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glUniform2uiEXT) (GLint  location, GLuint  v0, GLuint  v1) = NULL;
void (GLAPIENTRY *glUniform2uiv) (GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glUniform2uivEXT) (GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glUniform3d) (GLint  location, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glUniform3dv) (GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniform3f) (GLint  location, GLfloat  v0, GLfloat  v1, GLfloat  v2) = NULL;
void (GLAPIENTRY *glUniform3fARB) (GLint  location, GLfloat  v0, GLfloat  v1, GLfloat  v2) = NULL;
void (GLAPIENTRY *glUniform3fv) (GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniform3fvARB) (GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniform3i) (GLint  location, GLint  v0, GLint  v1, GLint  v2) = NULL;
void (GLAPIENTRY *glUniform3i64ARB) (GLint  location, GLint64  x, GLint64  y, GLint64  z) = NULL;
void (GLAPIENTRY *glUniform3i64NV) (GLint  location, GLint64EXT  x, GLint64EXT  y, GLint64EXT  z) = NULL;
void (GLAPIENTRY *glUniform3i64vARB) (GLint  location, GLsizei  count, const GLint64 * value) = NULL;
void (GLAPIENTRY *glUniform3i64vNV) (GLint  location, GLsizei  count, const GLint64EXT * value) = NULL;
void (GLAPIENTRY *glUniform3iARB) (GLint  location, GLint  v0, GLint  v1, GLint  v2) = NULL;
void (GLAPIENTRY *glUniform3iv) (GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glUniform3ivARB) (GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glUniform3ui) (GLint  location, GLuint  v0, GLuint  v1, GLuint  v2) = NULL;
void (GLAPIENTRY *glUniform3ui64ARB) (GLint  location, GLuint64  x, GLuint64  y, GLuint64  z) = NULL;
void (GLAPIENTRY *glUniform3ui64NV) (GLint  location, GLuint64EXT  x, GLuint64EXT  y, GLuint64EXT  z) = NULL;
void (GLAPIENTRY *glUniform3ui64vARB) (GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glUniform3ui64vNV) (GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glUniform3uiEXT) (GLint  location, GLuint  v0, GLuint  v1, GLuint  v2) = NULL;
void (GLAPIENTRY *glUniform3uiv) (GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glUniform3uivEXT) (GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glUniform4d) (GLint  location, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glUniform4dv) (GLint  location, GLsizei  count, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniform4f) (GLint  location, GLfloat  v0, GLfloat  v1, GLfloat  v2, GLfloat  v3) = NULL;
void (GLAPIENTRY *glUniform4fARB) (GLint  location, GLfloat  v0, GLfloat  v1, GLfloat  v2, GLfloat  v3) = NULL;
void (GLAPIENTRY *glUniform4fv) (GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniform4fvARB) (GLint  location, GLsizei  count, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniform4i) (GLint  location, GLint  v0, GLint  v1, GLint  v2, GLint  v3) = NULL;
void (GLAPIENTRY *glUniform4i64ARB) (GLint  location, GLint64  x, GLint64  y, GLint64  z, GLint64  w) = NULL;
void (GLAPIENTRY *glUniform4i64NV) (GLint  location, GLint64EXT  x, GLint64EXT  y, GLint64EXT  z, GLint64EXT  w) = NULL;
void (GLAPIENTRY *glUniform4i64vARB) (GLint  location, GLsizei  count, const GLint64 * value) = NULL;
void (GLAPIENTRY *glUniform4i64vNV) (GLint  location, GLsizei  count, const GLint64EXT * value) = NULL;
void (GLAPIENTRY *glUniform4iARB) (GLint  location, GLint  v0, GLint  v1, GLint  v2, GLint  v3) = NULL;
void (GLAPIENTRY *glUniform4iv) (GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glUniform4ivARB) (GLint  location, GLsizei  count, const GLint * value) = NULL;
void (GLAPIENTRY *glUniform4ui) (GLint  location, GLuint  v0, GLuint  v1, GLuint  v2, GLuint  v3) = NULL;
void (GLAPIENTRY *glUniform4ui64ARB) (GLint  location, GLuint64  x, GLuint64  y, GLuint64  z, GLuint64  w) = NULL;
void (GLAPIENTRY *glUniform4ui64NV) (GLint  location, GLuint64EXT  x, GLuint64EXT  y, GLuint64EXT  z, GLuint64EXT  w) = NULL;
void (GLAPIENTRY *glUniform4ui64vARB) (GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glUniform4ui64vNV) (GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glUniform4uiEXT) (GLint  location, GLuint  v0, GLuint  v1, GLuint  v2, GLuint  v3) = NULL;
void (GLAPIENTRY *glUniform4uiv) (GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glUniform4uivEXT) (GLint  location, GLsizei  count, const GLuint * value) = NULL;
void (GLAPIENTRY *glUniformBlockBinding) (GLuint  program, GLuint  uniformBlockIndex, GLuint  uniformBlockBinding) = NULL;
void (GLAPIENTRY *glUniformBufferEXT) (GLuint  program, GLint  location, GLuint  buffer) = NULL;
void (GLAPIENTRY *glUniformHandleui64ARB) (GLint  location, GLuint64  value) = NULL;
void (GLAPIENTRY *glUniformHandleui64NV) (GLint  location, GLuint64  value) = NULL;
void (GLAPIENTRY *glUniformHandleui64vARB) (GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glUniformHandleui64vNV) (GLint  location, GLsizei  count, const GLuint64 * value) = NULL;
void (GLAPIENTRY *glUniformMatrix2dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix2fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix2fvARB) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix2x3dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix2x3fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix2x4dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix2x4fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix3dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix3fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix3fvARB) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix3x2dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix3x2fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix3x4dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix3x4fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix4dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix4fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix4fvARB) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix4x2dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix4x2fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformMatrix4x3dv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLdouble * value) = NULL;
void (GLAPIENTRY *glUniformMatrix4x3fv) (GLint  location, GLsizei  count, GLboolean  transpose, const GLfloat * value) = NULL;
void (GLAPIENTRY *glUniformSubroutinesuiv) (GLenum  shadertype, GLsizei  count, const GLuint * indices) = NULL;
void (GLAPIENTRY *glUniformui64NV) (GLint  location, GLuint64EXT  value) = NULL;
void (GLAPIENTRY *glUniformui64vNV) (GLint  location, GLsizei  count, const GLuint64EXT * value) = NULL;
void (GLAPIENTRY *glUnlockArraysEXT) () = NULL;
GLboolean (GLAPIENTRY *glUnmapBuffer) (GLenum  target) = NULL;
GLboolean (GLAPIENTRY *glUnmapBufferARB) (GLenum  target) = NULL;
GLboolean (GLAPIENTRY *glUnmapNamedBuffer) (GLuint  buffer) = NULL;
GLboolean (GLAPIENTRY *glUnmapNamedBufferEXT) (GLuint  buffer) = NULL;
void (GLAPIENTRY *glUnmapTexture2DINTEL) (GLuint  texture, GLint  level) = NULL;
void (GLAPIENTRY *glUseProgram) (GLuint  program) = NULL;
void (GLAPIENTRY *glUseProgramObjectARB) (GLhandleARB  programObj) = NULL;
void (GLAPIENTRY *glUseProgramStages) (GLuint  pipeline, GLbitfield  stages, GLuint  program) = NULL;
void (GLAPIENTRY *glUseProgramStagesEXT) (GLuint  pipeline, GLbitfield  stages, GLuint  program) = NULL;
void (GLAPIENTRY *glUseShaderProgramEXT) (GLenum  type, GLuint  program) = NULL;
void (GLAPIENTRY *glVDPAUFiniNV) () = NULL;
void (GLAPIENTRY *glVDPAUGetSurfaceivNV) (GLvdpauSurfaceNV  surface, GLenum  pname, GLsizei  count, GLsizei * length, GLint * values) = NULL;
void (GLAPIENTRY *glVDPAUInitNV) (const void * vdpDevice, const void * getProcAddress) = NULL;
GLboolean (GLAPIENTRY *glVDPAUIsSurfaceNV) (GLvdpauSurfaceNV  surface) = NULL;
void (GLAPIENTRY *glVDPAUMapSurfacesNV) (GLsizei  numSurfaces, const GLvdpauSurfaceNV * surfaces) = NULL;
GLvdpauSurfaceNV (GLAPIENTRY *glVDPAURegisterOutputSurfaceNV) (const void * vdpSurface, GLenum  target, GLsizei  numTextureNames, const GLuint * textureNames) = NULL;
GLvdpauSurfaceNV (GLAPIENTRY *glVDPAURegisterVideoSurfaceNV) (const void * vdpSurface, GLenum  target, GLsizei  numTextureNames, const GLuint * textureNames) = NULL;
GLvdpauSurfaceNV (GLAPIENTRY *glVDPAURegisterVideoSurfaceWithPictureStructureNV) (const void * vdpSurface, GLenum  target, GLsizei  numTextureNames, const GLuint * textureNames, GLboolean  isFrameStructure) = NULL;
void (GLAPIENTRY *glVDPAUSurfaceAccessNV) (GLvdpauSurfaceNV  surface, GLenum  access) = NULL;
void (GLAPIENTRY *glVDPAUUnmapSurfacesNV) (GLsizei  numSurface, const GLvdpauSurfaceNV * surfaces) = NULL;
void (GLAPIENTRY *glVDPAUUnregisterSurfaceNV) (GLvdpauSurfaceNV  surface) = NULL;
void (GLAPIENTRY *glValidateProgram) (GLuint  program) = NULL;
void (GLAPIENTRY *glValidateProgramARB) (GLhandleARB  programObj) = NULL;
void (GLAPIENTRY *glValidateProgramPipeline) (GLuint  pipeline) = NULL;
void (GLAPIENTRY *glValidateProgramPipelineEXT) (GLuint  pipeline) = NULL;
void (GLAPIENTRY *glVariantPointerEXT) (GLuint  id, GLenum  type, GLuint  stride, const void * addr) = NULL;
void (GLAPIENTRY *glVariantbvEXT) (GLuint  id, const GLbyte * addr) = NULL;
void (GLAPIENTRY *glVariantdvEXT) (GLuint  id, const GLdouble * addr) = NULL;
void (GLAPIENTRY *glVariantfvEXT) (GLuint  id, const GLfloat * addr) = NULL;
void (GLAPIENTRY *glVariantivEXT) (GLuint  id, const GLint * addr) = NULL;
void (GLAPIENTRY *glVariantsvEXT) (GLuint  id, const GLshort * addr) = NULL;
void (GLAPIENTRY *glVariantubvEXT) (GLuint  id, const GLubyte * addr) = NULL;
void (GLAPIENTRY *glVariantuivEXT) (GLuint  id, const GLuint * addr) = NULL;
void (GLAPIENTRY *glVariantusvEXT) (GLuint  id, const GLushort * addr) = NULL;
void (GLAPIENTRY *glVertex2d) (GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glVertex2dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertex2f) (GLfloat  x, GLfloat  y) = NULL;
void (GLAPIENTRY *glVertex2fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertex2hNV) (GLhalfNV  x, GLhalfNV  y) = NULL;
void (GLAPIENTRY *glVertex2hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertex2i) (GLint  x, GLint  y) = NULL;
void (GLAPIENTRY *glVertex2iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glVertex2s) (GLshort  x, GLshort  y) = NULL;
void (GLAPIENTRY *glVertex2sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glVertex3d) (GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glVertex3dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertex3f) (GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glVertex3fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertex3hNV) (GLhalfNV  x, GLhalfNV  y, GLhalfNV  z) = NULL;
void (GLAPIENTRY *glVertex3hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertex3i) (GLint  x, GLint  y, GLint  z) = NULL;
void (GLAPIENTRY *glVertex3iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glVertex3s) (GLshort  x, GLshort  y, GLshort  z) = NULL;
void (GLAPIENTRY *glVertex3sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glVertex4d) (GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glVertex4dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertex4f) (GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glVertex4fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertex4hNV) (GLhalfNV  x, GLhalfNV  y, GLhalfNV  z, GLhalfNV  w) = NULL;
void (GLAPIENTRY *glVertex4hvNV) (const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertex4i) (GLint  x, GLint  y, GLint  z, GLint  w) = NULL;
void (GLAPIENTRY *glVertex4iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glVertex4s) (GLshort  x, GLshort  y, GLshort  z, GLshort  w) = NULL;
void (GLAPIENTRY *glVertex4sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexArrayAttribBinding) (GLuint  vaobj, GLuint  attribindex, GLuint  bindingindex) = NULL;
void (GLAPIENTRY *glVertexArrayAttribFormat) (GLuint  vaobj, GLuint  attribindex, GLint  size, GLenum  type, GLboolean  normalized, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexArrayAttribIFormat) (GLuint  vaobj, GLuint  attribindex, GLint  size, GLenum  type, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexArrayAttribLFormat) (GLuint  vaobj, GLuint  attribindex, GLint  size, GLenum  type, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexArrayBindVertexBufferEXT) (GLuint  vaobj, GLuint  bindingindex, GLuint  buffer, GLintptr  offset, GLsizei  stride) = NULL;
void (GLAPIENTRY *glVertexArrayBindingDivisor) (GLuint  vaobj, GLuint  bindingindex, GLuint  divisor) = NULL;
void (GLAPIENTRY *glVertexArrayColorOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLint  size, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayEdgeFlagOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayElementBuffer) (GLuint  vaobj, GLuint  buffer) = NULL;
void (GLAPIENTRY *glVertexArrayFogCoordOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayIndexOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayMultiTexCoordOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLenum  texunit, GLint  size, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayNormalOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayParameteriAPPLE) (GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glVertexArrayRangeAPPLE) (GLsizei  length, void * pointer) = NULL;
void (GLAPIENTRY *glVertexArrayRangeNV) (GLsizei  length, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexArraySecondaryColorOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLint  size, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayTexCoordOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLint  size, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayVertexAttribBindingEXT) (GLuint  vaobj, GLuint  attribindex, GLuint  bindingindex) = NULL;
void (GLAPIENTRY *glVertexArrayVertexAttribDivisorEXT) (GLuint  vaobj, GLuint  index, GLuint  divisor) = NULL;
void (GLAPIENTRY *glVertexArrayVertexAttribFormatEXT) (GLuint  vaobj, GLuint  attribindex, GLint  size, GLenum  type, GLboolean  normalized, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexArrayVertexAttribIFormatEXT) (GLuint  vaobj, GLuint  attribindex, GLint  size, GLenum  type, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexArrayVertexAttribIOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLuint  index, GLint  size, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayVertexAttribLFormatEXT) (GLuint  vaobj, GLuint  attribindex, GLint  size, GLenum  type, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexArrayVertexAttribLOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLuint  index, GLint  size, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayVertexAttribOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLuint  index, GLint  size, GLenum  type, GLboolean  normalized, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexArrayVertexBindingDivisorEXT) (GLuint  vaobj, GLuint  bindingindex, GLuint  divisor) = NULL;
void (GLAPIENTRY *glVertexArrayVertexBuffer) (GLuint  vaobj, GLuint  bindingindex, GLuint  buffer, GLintptr  offset, GLsizei  stride) = NULL;
void (GLAPIENTRY *glVertexArrayVertexBuffers) (GLuint  vaobj, GLuint  first, GLsizei  count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides) = NULL;
void (GLAPIENTRY *glVertexArrayVertexOffsetEXT) (GLuint  vaobj, GLuint  buffer, GLint  size, GLenum  type, GLsizei  stride, GLintptr  offset) = NULL;
void (GLAPIENTRY *glVertexAttrib1d) (GLuint  index, GLdouble  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1dARB) (GLuint  index, GLdouble  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1dNV) (GLuint  index, GLdouble  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1dv) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1dvARB) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1dvNV) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1f) (GLuint  index, GLfloat  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1fARB) (GLuint  index, GLfloat  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1fNV) (GLuint  index, GLfloat  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1fv) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1fvARB) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1fvNV) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1hNV) (GLuint  index, GLhalfNV  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1hvNV) (GLuint  index, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1s) (GLuint  index, GLshort  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1sARB) (GLuint  index, GLshort  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1sNV) (GLuint  index, GLshort  x) = NULL;
void (GLAPIENTRY *glVertexAttrib1sv) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1svARB) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib1svNV) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2d) (GLuint  index, GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2dARB) (GLuint  index, GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2dNV) (GLuint  index, GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2dv) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2dvARB) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2dvNV) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2f) (GLuint  index, GLfloat  x, GLfloat  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2fARB) (GLuint  index, GLfloat  x, GLfloat  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2fNV) (GLuint  index, GLfloat  x, GLfloat  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2fv) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2fvARB) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2fvNV) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2hNV) (GLuint  index, GLhalfNV  x, GLhalfNV  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2hvNV) (GLuint  index, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2s) (GLuint  index, GLshort  x, GLshort  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2sARB) (GLuint  index, GLshort  x, GLshort  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2sNV) (GLuint  index, GLshort  x, GLshort  y) = NULL;
void (GLAPIENTRY *glVertexAttrib2sv) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2svARB) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib2svNV) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3d) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3dARB) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3dNV) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3dv) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3dvARB) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3dvNV) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3f) (GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3fARB) (GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3fNV) (GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3fv) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3fvARB) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3fvNV) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3hNV) (GLuint  index, GLhalfNV  x, GLhalfNV  y, GLhalfNV  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3hvNV) (GLuint  index, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3s) (GLuint  index, GLshort  x, GLshort  y, GLshort  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3sARB) (GLuint  index, GLshort  x, GLshort  y, GLshort  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3sNV) (GLuint  index, GLshort  x, GLshort  y, GLshort  z) = NULL;
void (GLAPIENTRY *glVertexAttrib3sv) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3svARB) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib3svNV) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4Nbv) (GLuint  index, const GLbyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4NbvARB) (GLuint  index, const GLbyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4Niv) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4NivARB) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4Nsv) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4NsvARB) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4Nub) (GLuint  index, GLubyte  x, GLubyte  y, GLubyte  z, GLubyte  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4NubARB) (GLuint  index, GLubyte  x, GLubyte  y, GLubyte  z, GLubyte  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4Nubv) (GLuint  index, const GLubyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4NubvARB) (GLuint  index, const GLubyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4Nuiv) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4NuivARB) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4Nusv) (GLuint  index, const GLushort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4NusvARB) (GLuint  index, const GLushort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4bv) (GLuint  index, const GLbyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4bvARB) (GLuint  index, const GLbyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4d) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4dARB) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4dNV) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4dv) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4dvARB) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4dvNV) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4f) (GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4fARB) (GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4fNV) (GLuint  index, GLfloat  x, GLfloat  y, GLfloat  z, GLfloat  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4fv) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4fvARB) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4fvNV) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4hNV) (GLuint  index, GLhalfNV  x, GLhalfNV  y, GLhalfNV  z, GLhalfNV  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4hvNV) (GLuint  index, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4iv) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4ivARB) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4s) (GLuint  index, GLshort  x, GLshort  y, GLshort  z, GLshort  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4sARB) (GLuint  index, GLshort  x, GLshort  y, GLshort  z, GLshort  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4sNV) (GLuint  index, GLshort  x, GLshort  y, GLshort  z, GLshort  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4sv) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4svARB) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4svNV) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4ubNV) (GLuint  index, GLubyte  x, GLubyte  y, GLubyte  z, GLubyte  w) = NULL;
void (GLAPIENTRY *glVertexAttrib4ubv) (GLuint  index, const GLubyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4ubvARB) (GLuint  index, const GLubyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4ubvNV) (GLuint  index, const GLubyte * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4uiv) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4uivARB) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4usv) (GLuint  index, const GLushort * v) = NULL;
void (GLAPIENTRY *glVertexAttrib4usvARB) (GLuint  index, const GLushort * v) = NULL;
void (GLAPIENTRY *glVertexAttribBinding) (GLuint  attribindex, GLuint  bindingindex) = NULL;
void (GLAPIENTRY *glVertexAttribDivisor) (GLuint  index, GLuint  divisor) = NULL;
void (GLAPIENTRY *glVertexAttribDivisorARB) (GLuint  index, GLuint  divisor) = NULL;
void (GLAPIENTRY *glVertexAttribFormat) (GLuint  attribindex, GLint  size, GLenum  type, GLboolean  normalized, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexAttribFormatNV) (GLuint  index, GLint  size, GLenum  type, GLboolean  normalized, GLsizei  stride) = NULL;
void (GLAPIENTRY *glVertexAttribI1i) (GLuint  index, GLint  x) = NULL;
void (GLAPIENTRY *glVertexAttribI1iEXT) (GLuint  index, GLint  x) = NULL;
void (GLAPIENTRY *glVertexAttribI1iv) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI1ivEXT) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI1ui) (GLuint  index, GLuint  x) = NULL;
void (GLAPIENTRY *glVertexAttribI1uiEXT) (GLuint  index, GLuint  x) = NULL;
void (GLAPIENTRY *glVertexAttribI1uiv) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI1uivEXT) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI2i) (GLuint  index, GLint  x, GLint  y) = NULL;
void (GLAPIENTRY *glVertexAttribI2iEXT) (GLuint  index, GLint  x, GLint  y) = NULL;
void (GLAPIENTRY *glVertexAttribI2iv) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI2ivEXT) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI2ui) (GLuint  index, GLuint  x, GLuint  y) = NULL;
void (GLAPIENTRY *glVertexAttribI2uiEXT) (GLuint  index, GLuint  x, GLuint  y) = NULL;
void (GLAPIENTRY *glVertexAttribI2uiv) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI2uivEXT) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI3i) (GLuint  index, GLint  x, GLint  y, GLint  z) = NULL;
void (GLAPIENTRY *glVertexAttribI3iEXT) (GLuint  index, GLint  x, GLint  y, GLint  z) = NULL;
void (GLAPIENTRY *glVertexAttribI3iv) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI3ivEXT) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI3ui) (GLuint  index, GLuint  x, GLuint  y, GLuint  z) = NULL;
void (GLAPIENTRY *glVertexAttribI3uiEXT) (GLuint  index, GLuint  x, GLuint  y, GLuint  z) = NULL;
void (GLAPIENTRY *glVertexAttribI3uiv) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI3uivEXT) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4bv) (GLuint  index, const GLbyte * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4bvEXT) (GLuint  index, const GLbyte * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4i) (GLuint  index, GLint  x, GLint  y, GLint  z, GLint  w) = NULL;
void (GLAPIENTRY *glVertexAttribI4iEXT) (GLuint  index, GLint  x, GLint  y, GLint  z, GLint  w) = NULL;
void (GLAPIENTRY *glVertexAttribI4iv) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4ivEXT) (GLuint  index, const GLint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4sv) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4svEXT) (GLuint  index, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4ubv) (GLuint  index, const GLubyte * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4ubvEXT) (GLuint  index, const GLubyte * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4ui) (GLuint  index, GLuint  x, GLuint  y, GLuint  z, GLuint  w) = NULL;
void (GLAPIENTRY *glVertexAttribI4uiEXT) (GLuint  index, GLuint  x, GLuint  y, GLuint  z, GLuint  w) = NULL;
void (GLAPIENTRY *glVertexAttribI4uiv) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4uivEXT) (GLuint  index, const GLuint * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4usv) (GLuint  index, const GLushort * v) = NULL;
void (GLAPIENTRY *glVertexAttribI4usvEXT) (GLuint  index, const GLushort * v) = NULL;
void (GLAPIENTRY *glVertexAttribIFormat) (GLuint  attribindex, GLint  size, GLenum  type, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexAttribIFormatNV) (GLuint  index, GLint  size, GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glVertexAttribIPointer) (GLuint  index, GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexAttribIPointerEXT) (GLuint  index, GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexAttribL1d) (GLuint  index, GLdouble  x) = NULL;
void (GLAPIENTRY *glVertexAttribL1dEXT) (GLuint  index, GLdouble  x) = NULL;
void (GLAPIENTRY *glVertexAttribL1dv) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribL1dvEXT) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribL1i64NV) (GLuint  index, GLint64EXT  x) = NULL;
void (GLAPIENTRY *glVertexAttribL1i64vNV) (GLuint  index, const GLint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribL1ui64ARB) (GLuint  index, GLuint64EXT  x) = NULL;
void (GLAPIENTRY *glVertexAttribL1ui64NV) (GLuint  index, GLuint64EXT  x) = NULL;
void (GLAPIENTRY *glVertexAttribL1ui64vARB) (GLuint  index, const GLuint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribL1ui64vNV) (GLuint  index, const GLuint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribL2d) (GLuint  index, GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glVertexAttribL2dEXT) (GLuint  index, GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glVertexAttribL2dv) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribL2dvEXT) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribL2i64NV) (GLuint  index, GLint64EXT  x, GLint64EXT  y) = NULL;
void (GLAPIENTRY *glVertexAttribL2i64vNV) (GLuint  index, const GLint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribL2ui64NV) (GLuint  index, GLuint64EXT  x, GLuint64EXT  y) = NULL;
void (GLAPIENTRY *glVertexAttribL2ui64vNV) (GLuint  index, const GLuint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribL3d) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glVertexAttribL3dEXT) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glVertexAttribL3dv) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribL3dvEXT) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribL3i64NV) (GLuint  index, GLint64EXT  x, GLint64EXT  y, GLint64EXT  z) = NULL;
void (GLAPIENTRY *glVertexAttribL3i64vNV) (GLuint  index, const GLint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribL3ui64NV) (GLuint  index, GLuint64EXT  x, GLuint64EXT  y, GLuint64EXT  z) = NULL;
void (GLAPIENTRY *glVertexAttribL3ui64vNV) (GLuint  index, const GLuint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribL4d) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glVertexAttribL4dEXT) (GLuint  index, GLdouble  x, GLdouble  y, GLdouble  z, GLdouble  w) = NULL;
void (GLAPIENTRY *glVertexAttribL4dv) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribL4dvEXT) (GLuint  index, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribL4i64NV) (GLuint  index, GLint64EXT  x, GLint64EXT  y, GLint64EXT  z, GLint64EXT  w) = NULL;
void (GLAPIENTRY *glVertexAttribL4i64vNV) (GLuint  index, const GLint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribL4ui64NV) (GLuint  index, GLuint64EXT  x, GLuint64EXT  y, GLuint64EXT  z, GLuint64EXT  w) = NULL;
void (GLAPIENTRY *glVertexAttribL4ui64vNV) (GLuint  index, const GLuint64EXT * v) = NULL;
void (GLAPIENTRY *glVertexAttribLFormat) (GLuint  attribindex, GLint  size, GLenum  type, GLuint  relativeoffset) = NULL;
void (GLAPIENTRY *glVertexAttribLFormatNV) (GLuint  index, GLint  size, GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glVertexAttribLPointer) (GLuint  index, GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexAttribLPointerEXT) (GLuint  index, GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexAttribP1ui) (GLuint  index, GLenum  type, GLboolean  normalized, GLuint  value) = NULL;
void (GLAPIENTRY *glVertexAttribP1uiv) (GLuint  index, GLenum  type, GLboolean  normalized, const GLuint * value) = NULL;
void (GLAPIENTRY *glVertexAttribP2ui) (GLuint  index, GLenum  type, GLboolean  normalized, GLuint  value) = NULL;
void (GLAPIENTRY *glVertexAttribP2uiv) (GLuint  index, GLenum  type, GLboolean  normalized, const GLuint * value) = NULL;
void (GLAPIENTRY *glVertexAttribP3ui) (GLuint  index, GLenum  type, GLboolean  normalized, GLuint  value) = NULL;
void (GLAPIENTRY *glVertexAttribP3uiv) (GLuint  index, GLenum  type, GLboolean  normalized, const GLuint * value) = NULL;
void (GLAPIENTRY *glVertexAttribP4ui) (GLuint  index, GLenum  type, GLboolean  normalized, GLuint  value) = NULL;
void (GLAPIENTRY *glVertexAttribP4uiv) (GLuint  index, GLenum  type, GLboolean  normalized, const GLuint * value) = NULL;
void (GLAPIENTRY *glVertexAttribParameteriAMD) (GLuint  index, GLenum  pname, GLint  param) = NULL;
void (GLAPIENTRY *glVertexAttribPointer) (GLuint  index, GLint  size, GLenum  type, GLboolean  normalized, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexAttribPointerARB) (GLuint  index, GLint  size, GLenum  type, GLboolean  normalized, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexAttribPointerNV) (GLuint  index, GLint  fsize, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexAttribs1dvNV) (GLuint  index, GLsizei  count, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribs1fvNV) (GLuint  index, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttribs1hvNV) (GLuint  index, GLsizei  n, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertexAttribs1svNV) (GLuint  index, GLsizei  count, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttribs2dvNV) (GLuint  index, GLsizei  count, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribs2fvNV) (GLuint  index, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttribs2hvNV) (GLuint  index, GLsizei  n, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertexAttribs2svNV) (GLuint  index, GLsizei  count, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttribs3dvNV) (GLuint  index, GLsizei  count, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribs3fvNV) (GLuint  index, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttribs3hvNV) (GLuint  index, GLsizei  n, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertexAttribs3svNV) (GLuint  index, GLsizei  count, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttribs4dvNV) (GLuint  index, GLsizei  count, const GLdouble * v) = NULL;
void (GLAPIENTRY *glVertexAttribs4fvNV) (GLuint  index, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glVertexAttribs4hvNV) (GLuint  index, GLsizei  n, const GLhalfNV * v) = NULL;
void (GLAPIENTRY *glVertexAttribs4svNV) (GLuint  index, GLsizei  count, const GLshort * v) = NULL;
void (GLAPIENTRY *glVertexAttribs4ubvNV) (GLuint  index, GLsizei  count, const GLubyte * v) = NULL;
void (GLAPIENTRY *glVertexBindingDivisor) (GLuint  bindingindex, GLuint  divisor) = NULL;
void (GLAPIENTRY *glVertexBlendARB) (GLint  count) = NULL;
void (GLAPIENTRY *glVertexFormatNV) (GLint  size, GLenum  type, GLsizei  stride) = NULL;
void (GLAPIENTRY *glVertexP2ui) (GLenum  type, GLuint  value) = NULL;
void (GLAPIENTRY *glVertexP2uiv) (GLenum  type, const GLuint * value) = NULL;
void (GLAPIENTRY *glVertexP3ui) (GLenum  type, GLuint  value) = NULL;
void (GLAPIENTRY *glVertexP3uiv) (GLenum  type, const GLuint * value) = NULL;
void (GLAPIENTRY *glVertexP4ui) (GLenum  type, GLuint  value) = NULL;
void (GLAPIENTRY *glVertexP4uiv) (GLenum  type, const GLuint * value) = NULL;
void (GLAPIENTRY *glVertexPointer) (GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexPointerEXT) (GLint  size, GLenum  type, GLsizei  stride, GLsizei  count, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexPointervINTEL) (GLint  size, GLenum  type, const void ** pointer) = NULL;
void (GLAPIENTRY *glVertexWeightPointerEXT) (GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glVertexWeightfEXT) (GLfloat  weight) = NULL;
void (GLAPIENTRY *glVertexWeightfvEXT) (const GLfloat * weight) = NULL;
void (GLAPIENTRY *glVertexWeighthNV) (GLhalfNV  weight) = NULL;
void (GLAPIENTRY *glVertexWeighthvNV) (const GLhalfNV * weight) = NULL;
GLenum (GLAPIENTRY *glVideoCaptureNV) (GLuint  video_capture_slot, GLuint * sequence_num, GLuint64EXT * capture_time) = NULL;
void (GLAPIENTRY *glVideoCaptureStreamParameterdvNV) (GLuint  video_capture_slot, GLuint  stream, GLenum  pname, const GLdouble * params) = NULL;
void (GLAPIENTRY *glVideoCaptureStreamParameterfvNV) (GLuint  video_capture_slot, GLuint  stream, GLenum  pname, const GLfloat * params) = NULL;
void (GLAPIENTRY *glVideoCaptureStreamParameterivNV) (GLuint  video_capture_slot, GLuint  stream, GLenum  pname, const GLint * params) = NULL;
void (GLAPIENTRY *glViewport) (GLint  x, GLint  y, GLsizei  width, GLsizei  height) = NULL;
void (GLAPIENTRY *glViewportArrayv) (GLuint  first, GLsizei  count, const GLfloat * v) = NULL;
void (GLAPIENTRY *glViewportIndexedf) (GLuint  index, GLfloat  x, GLfloat  y, GLfloat  w, GLfloat  h) = NULL;
void (GLAPIENTRY *glViewportIndexedfv) (GLuint  index, const GLfloat * v) = NULL;
void (GLAPIENTRY *glViewportPositionWScaleNV) (GLuint  index, GLfloat  xcoeff, GLfloat  ycoeff) = NULL;
void (GLAPIENTRY *glViewportSwizzleNV) (GLuint  index, GLenum  swizzlex, GLenum  swizzley, GLenum  swizzlez, GLenum  swizzlew) = NULL;
void (GLAPIENTRY *glWaitSemaphoreEXT) (GLuint  semaphore, GLuint  numBufferBarriers, const GLuint * buffers, GLuint  numTextureBarriers, const GLuint * textures, const GLenum * srcLayouts) = NULL;
void (GLAPIENTRY *glWaitSync) (GLsync  sync, GLbitfield  flags, GLuint64  timeout) = NULL;
void (GLAPIENTRY *glWeightPathsNV) (GLuint  resultPath, GLsizei  numPaths, const GLuint * paths, const GLfloat * weights) = NULL;
void (GLAPIENTRY *glWeightPointerARB) (GLint  size, GLenum  type, GLsizei  stride, const void * pointer) = NULL;
void (GLAPIENTRY *glWeightbvARB) (GLint  size, const GLbyte * weights) = NULL;
void (GLAPIENTRY *glWeightdvARB) (GLint  size, const GLdouble * weights) = NULL;
void (GLAPIENTRY *glWeightfvARB) (GLint  size, const GLfloat * weights) = NULL;
void (GLAPIENTRY *glWeightivARB) (GLint  size, const GLint * weights) = NULL;
void (GLAPIENTRY *glWeightsvARB) (GLint  size, const GLshort * weights) = NULL;
void (GLAPIENTRY *glWeightubvARB) (GLint  size, const GLubyte * weights) = NULL;
void (GLAPIENTRY *glWeightuivARB) (GLint  size, const GLuint * weights) = NULL;
void (GLAPIENTRY *glWeightusvARB) (GLint  size, const GLushort * weights) = NULL;
void (GLAPIENTRY *glWindowPos2d) (GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glWindowPos2dARB) (GLdouble  x, GLdouble  y) = NULL;
void (GLAPIENTRY *glWindowPos2dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glWindowPos2dvARB) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glWindowPos2f) (GLfloat  x, GLfloat  y) = NULL;
void (GLAPIENTRY *glWindowPos2fARB) (GLfloat  x, GLfloat  y) = NULL;
void (GLAPIENTRY *glWindowPos2fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glWindowPos2fvARB) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glWindowPos2i) (GLint  x, GLint  y) = NULL;
void (GLAPIENTRY *glWindowPos2iARB) (GLint  x, GLint  y) = NULL;
void (GLAPIENTRY *glWindowPos2iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glWindowPos2ivARB) (const GLint * v) = NULL;
void (GLAPIENTRY *glWindowPos2s) (GLshort  x, GLshort  y) = NULL;
void (GLAPIENTRY *glWindowPos2sARB) (GLshort  x, GLshort  y) = NULL;
void (GLAPIENTRY *glWindowPos2sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glWindowPos2svARB) (const GLshort * v) = NULL;
void (GLAPIENTRY *glWindowPos3d) (GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glWindowPos3dARB) (GLdouble  x, GLdouble  y, GLdouble  z) = NULL;
void (GLAPIENTRY *glWindowPos3dv) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glWindowPos3dvARB) (const GLdouble * v) = NULL;
void (GLAPIENTRY *glWindowPos3f) (GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glWindowPos3fARB) (GLfloat  x, GLfloat  y, GLfloat  z) = NULL;
void (GLAPIENTRY *glWindowPos3fv) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glWindowPos3fvARB) (const GLfloat * v) = NULL;
void (GLAPIENTRY *glWindowPos3i) (GLint  x, GLint  y, GLint  z) = NULL;
void (GLAPIENTRY *glWindowPos3iARB) (GLint  x, GLint  y, GLint  z) = NULL;
void (GLAPIENTRY *glWindowPos3iv) (const GLint * v) = NULL;
void (GLAPIENTRY *glWindowPos3ivARB) (const GLint * v) = NULL;
void (GLAPIENTRY *glWindowPos3s) (GLshort  x, GLshort  y, GLshort  z) = NULL;
void (GLAPIENTRY *glWindowPos3sARB) (GLshort  x, GLshort  y, GLshort  z) = NULL;
void (GLAPIENTRY *glWindowPos3sv) (const GLshort * v) = NULL;
void (GLAPIENTRY *glWindowPos3svARB) (const GLshort * v) = NULL;
void (GLAPIENTRY *glWindowRectanglesEXT) (GLenum  mode, GLsizei  count, const GLint * box) = NULL;
void (GLAPIENTRY *glWriteMaskEXT) (GLuint  res, GLuint  in, GLenum  outX, GLenum  outY, GLenum  outZ, GLenum  outW) = NULL;
void (GLAPIENTRY *glDrawVkImageNV) (GLuint64  vkImage, GLuint  sampler, GLfloat  x0, GLfloat  y0, GLfloat  x1, GLfloat  y1, GLfloat  z, GLfloat  s0, GLfloat  t0, GLfloat  s1, GLfloat  t1) = NULL;
GLVULKANPROCNV (GLAPIENTRY *glGetVkProcAddrNV) (const GLchar * name) = NULL;
void (GLAPIENTRY *glWaitVkSemaphoreNV) (GLuint64  vkSemaphore) = NULL;
void (GLAPIENTRY *glSignalVkSemaphoreNV) (GLuint64  vkSemaphore) = NULL;
void (GLAPIENTRY *glSignalVkFenceNV) (GLuint64  vkFence) = NULL;



#ifdef _WIN32
    static HMODULE libGL;
#else
    static void* libGL = NULL;
#endif
#ifndef __APPLE__
    typedef void * (GLAPIENTRY * PFNGETPROCADDRESS)(const char*);
    PFNGETPROCADDRESS getProcAddress = NULL;
#endif

static bool loadLibrary()
{
#ifdef _WIN32
    libGL = LoadLibraryW(L"opengl32.dll");
#elif __APPLE__
    libGL = dlopen("/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL", RTLD_LAZY | RTLD_LOCAL);
#else
    libGL = dlopen("libGL.so.1", RTLD_LAZY | RTLD_LOCAL);
#endif
#ifndef __APPLE__
#ifdef _WIN32
    getProcAddress = (PFNGETPROCADDRESS) GetProcAddress(libGL, "wglGetProcAddress");
#else
    getProcAddress = (PFNGETPROCADDRESS) dlsym(libGL, "glXGetProcAddressARB");
#endif
#endif
    return true;
}

static void unloadLibrary(void)
{
    if(libGL != NULL)
    {
        #ifdef _WIN32
            FreeLibrary((HMODULE) libGL);
        #else
            dlclose(libGL);
        #endif
        libGL = NULL;
    }
}

static void* loadFunction(const char *name)
{
    void* result = NULL;
    assert(libGL != NULL);

#ifndef __APPLE__
    if(getProcAddress != NULL)
    {
        result = (void*)getProcAddress(name);
    }
#endif

    if(result == NULL)
    {
        #ifdef _WIN32
            result = (void*)GetProcAddress(libGL, name);
        #else
            result = dlsym(libGL, name);
        #endif
    }
    return result;
}

static bool hasExt(const char * ext,
                   const std::vector<const char *> & extensions)
{
    for (size_t i=0; i<extensions.size(); ++i) {
        if (strcmp(ext, extensions[i]) == 0) {
            return true;
        }
    }
    return false;
}

static bool loadSymbols()
{
    glGetIntegerv = (PFNGLGETINTEGERVPROC) loadFunction("glGetIntegerv");
    glGetString = (PFNGLGETSTRINGPROC) loadFunction("glGetString");
    glGetStringi = (PFNGLGETSTRINGIPROC) loadFunction("glGetStringi");

    GLint major = 0, minor = 0;

    // direct version query is supported only for versions 3.x and greater
    const char * versionStr = (const char *) glGetString(GL_VERSION);
    if (versionStr && versionStr[0] == '1' && versionStr[1] == '.') {
        major = 1;
        minor = versionStr[2] - '0';
    } else if (versionStr && versionStr[0] == '2' && versionStr[1] == '.') {
        major = 2;
        minor = versionStr[2] - '0';
    } else {
        glGetIntegerv(GL_MAJOR_VERSION, &major);
        glGetIntegerv(GL_MINOR_VERSION, &minor);
    }

    std::vector<const char *> extensions;
    std::vector<char> extensionsBuffer; // used when parsing extensions string

    // direct extension query is supported only for versions 3.x and greater
    if (major >= 3) {
        GLint numExtensions = 0;
        glGetIntegerv(GL_NUM_EXTENSIONS, &numExtensions);
        extensions.resize(numExtensions);
        for (size_t i=0; i<extensions.size(); ++i) {
           extensions[i] = (const char *) glGetStringi(GL_EXTENSIONS,(GLuint)i);
        }
    } else if (major > 0) {
        const char * extStr = (const char *) glGetString(GL_EXTENSIONS);
        const size_t extStrLen = strlen(extStr);

        // make a copy so that we can terminate substrings
        extensionsBuffer.assign(extStr, extStr+extStrLen+1);

        // identify and terminate substrings
        bool inSubstring = false;
        for (size_t i=0; i<extStrLen; ++i) {
            if (extensionsBuffer[i] == ' ') {
                extensionsBuffer[i] = '\0';
                inSubstring = false;
            } else if (!inSubstring) {
                extensions.push_back(&extensionsBuffer[i]);
                inSubstring = true;
            }
        }
    }

    GLAPILOADER_GL_VERSION_1_0 = (major == 1 && minor >= 0) || major > 1;
    GLAPILOADER_GL_VERSION_1_1 = (major == 1 && minor >= 1) || major > 1;
    GLAPILOADER_GL_VERSION_1_2 = (major == 1 && minor >= 2) || major > 1;
    GLAPILOADER_GL_VERSION_1_3 = (major == 1 && minor >= 3) || major > 1;
    GLAPILOADER_GL_VERSION_1_4 = (major == 1 && minor >= 4) || major > 1;
    GLAPILOADER_GL_VERSION_1_5 = (major == 1 && minor >= 5) || major > 1;
    GLAPILOADER_GL_VERSION_2_0 = (major == 2 && minor >= 0) || major > 2;
    GLAPILOADER_GL_VERSION_2_1 = (major == 2 && minor >= 1) || major > 2;
    GLAPILOADER_GL_VERSION_3_0 = (major == 3 && minor >= 0) || major > 3;
    GLAPILOADER_GL_VERSION_3_1 = (major == 3 && minor >= 1) || major > 3;
    GLAPILOADER_GL_VERSION_3_2 = (major == 3 && minor >= 2) || major > 3;
    GLAPILOADER_GL_VERSION_3_3 = (major == 3 && minor >= 3) || major > 3;
    GLAPILOADER_GL_VERSION_4_0 = (major == 4 && minor >= 0) || major > 4;
    GLAPILOADER_GL_VERSION_4_1 = (major == 4 && minor >= 1) || major > 4;
    GLAPILOADER_GL_VERSION_4_2 = (major == 4 && minor >= 2) || major > 4;
    GLAPILOADER_GL_VERSION_4_3 = (major == 4 && minor >= 3) || major > 4;
    GLAPILOADER_GL_VERSION_4_4 = (major == 4 && minor >= 4) || major > 4;
    GLAPILOADER_GL_VERSION_4_5 = (major == 4 && minor >= 5) || major > 4;
    GLAPILOADER_GL_VERSION_4_6 = (major == 4 && minor >= 6) || major > 4;

    GLAPILOADER_GL_AMD_blend_minmax_factor = hasExt("GL_AMD_blend_minmax_factor", extensions);
    GLAPILOADER_GL_AMD_conservative_depth = hasExt("GL_AMD_conservative_depth", extensions);
    GLAPILOADER_GL_AMD_debug_output = hasExt("GL_AMD_debug_output", extensions);
    GLAPILOADER_GL_AMD_depth_clamp_separate = hasExt("GL_AMD_depth_clamp_separate", extensions);
    GLAPILOADER_GL_AMD_draw_buffers_blend = hasExt("GL_AMD_draw_buffers_blend", extensions);
    GLAPILOADER_GL_AMD_framebuffer_multisample_advanced = hasExt("GL_AMD_framebuffer_multisample_advanced", extensions);
    GLAPILOADER_GL_AMD_framebuffer_sample_positions = hasExt("GL_AMD_framebuffer_sample_positions", extensions);
    GLAPILOADER_GL_AMD_gcn_shader = hasExt("GL_AMD_gcn_shader", extensions);
    GLAPILOADER_GL_AMD_gpu_shader_half_float = hasExt("GL_AMD_gpu_shader_half_float", extensions);
    GLAPILOADER_GL_AMD_gpu_shader_int16 = hasExt("GL_AMD_gpu_shader_int16", extensions);
    GLAPILOADER_GL_AMD_gpu_shader_int64 = hasExt("GL_AMD_gpu_shader_int64", extensions);
    GLAPILOADER_GL_AMD_interleaved_elements = hasExt("GL_AMD_interleaved_elements", extensions);
    GLAPILOADER_GL_AMD_multi_draw_indirect = hasExt("GL_AMD_multi_draw_indirect", extensions);
    GLAPILOADER_GL_AMD_name_gen_delete = hasExt("GL_AMD_name_gen_delete", extensions);
    GLAPILOADER_GL_AMD_occlusion_query_event = hasExt("GL_AMD_occlusion_query_event", extensions);
    GLAPILOADER_GL_AMD_performance_monitor = hasExt("GL_AMD_performance_monitor", extensions);
    GLAPILOADER_GL_AMD_pinned_memory = hasExt("GL_AMD_pinned_memory", extensions);
    GLAPILOADER_GL_AMD_query_buffer_object = hasExt("GL_AMD_query_buffer_object", extensions);
    GLAPILOADER_GL_AMD_sample_positions = hasExt("GL_AMD_sample_positions", extensions);
    GLAPILOADER_GL_AMD_seamless_cubemap_per_texture = hasExt("GL_AMD_seamless_cubemap_per_texture", extensions);
    GLAPILOADER_GL_AMD_shader_atomic_counter_ops = hasExt("GL_AMD_shader_atomic_counter_ops", extensions);
    GLAPILOADER_GL_AMD_shader_ballot = hasExt("GL_AMD_shader_ballot", extensions);
    GLAPILOADER_GL_AMD_shader_gpu_shader_half_float_fetch = hasExt("GL_AMD_shader_gpu_shader_half_float_fetch", extensions);
    GLAPILOADER_GL_AMD_shader_image_load_store_lod = hasExt("GL_AMD_shader_image_load_store_lod", extensions);
    GLAPILOADER_GL_AMD_shader_stencil_export = hasExt("GL_AMD_shader_stencil_export", extensions);
    GLAPILOADER_GL_AMD_shader_trinary_minmax = hasExt("GL_AMD_shader_trinary_minmax", extensions);
    GLAPILOADER_GL_AMD_shader_explicit_vertex_parameter = hasExt("GL_AMD_shader_explicit_vertex_parameter", extensions);
    GLAPILOADER_GL_AMD_sparse_texture = hasExt("GL_AMD_sparse_texture", extensions);
    GLAPILOADER_GL_AMD_stencil_operation_extended = hasExt("GL_AMD_stencil_operation_extended", extensions);
    GLAPILOADER_GL_AMD_texture_gather_bias_lod = hasExt("GL_AMD_texture_gather_bias_lod", extensions);
    GLAPILOADER_GL_AMD_texture_texture4 = hasExt("GL_AMD_texture_texture4", extensions);
    GLAPILOADER_GL_AMD_transform_feedback3_lines_triangles = hasExt("GL_AMD_transform_feedback3_lines_triangles", extensions);
    GLAPILOADER_GL_AMD_transform_feedback4 = hasExt("GL_AMD_transform_feedback4", extensions);
    GLAPILOADER_GL_AMD_vertex_shader_layer = hasExt("GL_AMD_vertex_shader_layer", extensions);
    GLAPILOADER_GL_AMD_vertex_shader_tessellator = hasExt("GL_AMD_vertex_shader_tessellator", extensions);
    GLAPILOADER_GL_AMD_vertex_shader_viewport_index = hasExt("GL_AMD_vertex_shader_viewport_index", extensions);
    GLAPILOADER_GL_APPLE_aux_depth_stencil = hasExt("GL_APPLE_aux_depth_stencil", extensions);
    GLAPILOADER_GL_APPLE_client_storage = hasExt("GL_APPLE_client_storage", extensions);
    GLAPILOADER_GL_APPLE_element_array = hasExt("GL_APPLE_element_array", extensions);
    GLAPILOADER_GL_APPLE_fence = hasExt("GL_APPLE_fence", extensions);
    GLAPILOADER_GL_APPLE_float_pixels = hasExt("GL_APPLE_float_pixels", extensions);
    GLAPILOADER_GL_APPLE_flush_buffer_range = hasExt("GL_APPLE_flush_buffer_range", extensions);
    GLAPILOADER_GL_APPLE_object_purgeable = hasExt("GL_APPLE_object_purgeable", extensions);
    GLAPILOADER_GL_APPLE_rgb_422 = hasExt("GL_APPLE_rgb_422", extensions);
    GLAPILOADER_GL_APPLE_row_bytes = hasExt("GL_APPLE_row_bytes", extensions);
    GLAPILOADER_GL_APPLE_specular_vector = hasExt("GL_APPLE_specular_vector", extensions);
    GLAPILOADER_GL_APPLE_texture_range = hasExt("GL_APPLE_texture_range", extensions);
    GLAPILOADER_GL_APPLE_transform_hint = hasExt("GL_APPLE_transform_hint", extensions);
    GLAPILOADER_GL_APPLE_vertex_array_object = hasExt("GL_APPLE_vertex_array_object", extensions);
    GLAPILOADER_GL_APPLE_vertex_array_range = hasExt("GL_APPLE_vertex_array_range", extensions);
    GLAPILOADER_GL_APPLE_vertex_program_evaluators = hasExt("GL_APPLE_vertex_program_evaluators", extensions);
    GLAPILOADER_GL_APPLE_ycbcr_422 = hasExt("GL_APPLE_ycbcr_422", extensions);
    GLAPILOADER_GL_ARB_ES2_compatibility = hasExt("GL_ARB_ES2_compatibility", extensions);
    GLAPILOADER_GL_ARB_ES3_1_compatibility = hasExt("GL_ARB_ES3_1_compatibility", extensions);
    GLAPILOADER_GL_ARB_ES3_2_compatibility = hasExt("GL_ARB_ES3_2_compatibility", extensions);
    GLAPILOADER_GL_ARB_ES3_compatibility = hasExt("GL_ARB_ES3_compatibility", extensions);
    GLAPILOADER_GL_ARB_arrays_of_arrays = hasExt("GL_ARB_arrays_of_arrays", extensions);
    GLAPILOADER_GL_ARB_base_instance = hasExt("GL_ARB_base_instance", extensions);
    GLAPILOADER_GL_ARB_bindless_texture = hasExt("GL_ARB_bindless_texture", extensions);
    GLAPILOADER_GL_ARB_blend_func_extended = hasExt("GL_ARB_blend_func_extended", extensions);
    GLAPILOADER_GL_ARB_buffer_storage = hasExt("GL_ARB_buffer_storage", extensions);
    GLAPILOADER_GL_ARB_cl_event = hasExt("GL_ARB_cl_event", extensions);
    GLAPILOADER_GL_ARB_clear_buffer_object = hasExt("GL_ARB_clear_buffer_object", extensions);
    GLAPILOADER_GL_ARB_clear_texture = hasExt("GL_ARB_clear_texture", extensions);
    GLAPILOADER_GL_ARB_clip_control = hasExt("GL_ARB_clip_control", extensions);
    GLAPILOADER_GL_ARB_color_buffer_float = hasExt("GL_ARB_color_buffer_float", extensions);
    GLAPILOADER_GL_ARB_compatibility = hasExt("GL_ARB_compatibility", extensions);
    GLAPILOADER_GL_ARB_compressed_texture_pixel_storage = hasExt("GL_ARB_compressed_texture_pixel_storage", extensions);
    GLAPILOADER_GL_ARB_compute_shader = hasExt("GL_ARB_compute_shader", extensions);
    GLAPILOADER_GL_ARB_compute_variable_group_size = hasExt("GL_ARB_compute_variable_group_size", extensions);
    GLAPILOADER_GL_ARB_conditional_render_inverted = hasExt("GL_ARB_conditional_render_inverted", extensions);
    GLAPILOADER_GL_ARB_conservative_depth = hasExt("GL_ARB_conservative_depth", extensions);
    GLAPILOADER_GL_ARB_copy_buffer = hasExt("GL_ARB_copy_buffer", extensions);
    GLAPILOADER_GL_ARB_copy_image = hasExt("GL_ARB_copy_image", extensions);
    GLAPILOADER_GL_ARB_cull_distance = hasExt("GL_ARB_cull_distance", extensions);
    GLAPILOADER_GL_ARB_debug_output = hasExt("GL_ARB_debug_output", extensions);
    GLAPILOADER_GL_ARB_depth_buffer_float = hasExt("GL_ARB_depth_buffer_float", extensions);
    GLAPILOADER_GL_ARB_depth_clamp = hasExt("GL_ARB_depth_clamp", extensions);
    GLAPILOADER_GL_ARB_depth_texture = hasExt("GL_ARB_depth_texture", extensions);
    GLAPILOADER_GL_ARB_derivative_control = hasExt("GL_ARB_derivative_control", extensions);
    GLAPILOADER_GL_ARB_direct_state_access = hasExt("GL_ARB_direct_state_access", extensions);
    GLAPILOADER_GL_ARB_draw_buffers = hasExt("GL_ARB_draw_buffers", extensions);
    GLAPILOADER_GL_ARB_draw_buffers_blend = hasExt("GL_ARB_draw_buffers_blend", extensions);
    GLAPILOADER_GL_ARB_draw_elements_base_vertex = hasExt("GL_ARB_draw_elements_base_vertex", extensions);
    GLAPILOADER_GL_ARB_draw_indirect = hasExt("GL_ARB_draw_indirect", extensions);
    GLAPILOADER_GL_ARB_draw_instanced = hasExt("GL_ARB_draw_instanced", extensions);
    GLAPILOADER_GL_ARB_enhanced_layouts = hasExt("GL_ARB_enhanced_layouts", extensions);
    GLAPILOADER_GL_ARB_explicit_attrib_location = hasExt("GL_ARB_explicit_attrib_location", extensions);
    GLAPILOADER_GL_ARB_explicit_uniform_location = hasExt("GL_ARB_explicit_uniform_location", extensions);
    GLAPILOADER_GL_ARB_fragment_coord_conventions = hasExt("GL_ARB_fragment_coord_conventions", extensions);
    GLAPILOADER_GL_ARB_fragment_layer_viewport = hasExt("GL_ARB_fragment_layer_viewport", extensions);
    GLAPILOADER_GL_ARB_fragment_program = hasExt("GL_ARB_fragment_program", extensions);
    GLAPILOADER_GL_ARB_fragment_program_shadow = hasExt("GL_ARB_fragment_program_shadow", extensions);
    GLAPILOADER_GL_ARB_fragment_shader = hasExt("GL_ARB_fragment_shader", extensions);
    GLAPILOADER_GL_ARB_fragment_shader_interlock = hasExt("GL_ARB_fragment_shader_interlock", extensions);
    GLAPILOADER_GL_ARB_framebuffer_no_attachments = hasExt("GL_ARB_framebuffer_no_attachments", extensions);
    GLAPILOADER_GL_ARB_framebuffer_object = hasExt("GL_ARB_framebuffer_object", extensions);
    GLAPILOADER_GL_ARB_framebuffer_sRGB = hasExt("GL_ARB_framebuffer_sRGB", extensions);
    GLAPILOADER_GL_ARB_geometry_shader4 = hasExt("GL_ARB_geometry_shader4", extensions);
    GLAPILOADER_GL_ARB_get_program_binary = hasExt("GL_ARB_get_program_binary", extensions);
    GLAPILOADER_GL_ARB_get_texture_sub_image = hasExt("GL_ARB_get_texture_sub_image", extensions);
    GLAPILOADER_GL_ARB_gl_spirv = hasExt("GL_ARB_gl_spirv", extensions);
    GLAPILOADER_GL_ARB_gpu_shader5 = hasExt("GL_ARB_gpu_shader5", extensions);
    GLAPILOADER_GL_ARB_gpu_shader_fp64 = hasExt("GL_ARB_gpu_shader_fp64", extensions);
    GLAPILOADER_GL_ARB_gpu_shader_int64 = hasExt("GL_ARB_gpu_shader_int64", extensions);
    GLAPILOADER_GL_ARB_half_float_pixel = hasExt("GL_ARB_half_float_pixel", extensions);
    GLAPILOADER_GL_ARB_half_float_vertex = hasExt("GL_ARB_half_float_vertex", extensions);
    GLAPILOADER_GL_ARB_imaging = hasExt("GL_ARB_imaging", extensions);
    GLAPILOADER_GL_ARB_indirect_parameters = hasExt("GL_ARB_indirect_parameters", extensions);
    GLAPILOADER_GL_ARB_instanced_arrays = hasExt("GL_ARB_instanced_arrays", extensions);
    GLAPILOADER_GL_ARB_internalformat_query = hasExt("GL_ARB_internalformat_query", extensions);
    GLAPILOADER_GL_ARB_internalformat_query2 = hasExt("GL_ARB_internalformat_query2", extensions);
    GLAPILOADER_GL_ARB_invalidate_subdata = hasExt("GL_ARB_invalidate_subdata", extensions);
    GLAPILOADER_GL_ARB_map_buffer_alignment = hasExt("GL_ARB_map_buffer_alignment", extensions);
    GLAPILOADER_GL_ARB_map_buffer_range = hasExt("GL_ARB_map_buffer_range", extensions);
    GLAPILOADER_GL_ARB_matrix_palette = hasExt("GL_ARB_matrix_palette", extensions);
    GLAPILOADER_GL_ARB_multi_bind = hasExt("GL_ARB_multi_bind", extensions);
    GLAPILOADER_GL_ARB_multi_draw_indirect = hasExt("GL_ARB_multi_draw_indirect", extensions);
    GLAPILOADER_GL_ARB_multisample = hasExt("GL_ARB_multisample", extensions);
    GLAPILOADER_GL_ARB_multitexture = hasExt("GL_ARB_multitexture", extensions);
    GLAPILOADER_GL_ARB_occlusion_query = hasExt("GL_ARB_occlusion_query", extensions);
    GLAPILOADER_GL_ARB_occlusion_query2 = hasExt("GL_ARB_occlusion_query2", extensions);
    GLAPILOADER_GL_ARB_parallel_shader_compile = hasExt("GL_ARB_parallel_shader_compile", extensions);
    GLAPILOADER_GL_ARB_pipeline_statistics_query = hasExt("GL_ARB_pipeline_statistics_query", extensions);
    GLAPILOADER_GL_ARB_pixel_buffer_object = hasExt("GL_ARB_pixel_buffer_object", extensions);
    GLAPILOADER_GL_ARB_point_parameters = hasExt("GL_ARB_point_parameters", extensions);
    GLAPILOADER_GL_ARB_point_sprite = hasExt("GL_ARB_point_sprite", extensions);
    GLAPILOADER_GL_ARB_polygon_offset_clamp = hasExt("GL_ARB_polygon_offset_clamp", extensions);
    GLAPILOADER_GL_ARB_post_depth_coverage = hasExt("GL_ARB_post_depth_coverage", extensions);
    GLAPILOADER_GL_ARB_program_interface_query = hasExt("GL_ARB_program_interface_query", extensions);
    GLAPILOADER_GL_ARB_provoking_vertex = hasExt("GL_ARB_provoking_vertex", extensions);
    GLAPILOADER_GL_ARB_query_buffer_object = hasExt("GL_ARB_query_buffer_object", extensions);
    GLAPILOADER_GL_ARB_robust_buffer_access_behavior = hasExt("GL_ARB_robust_buffer_access_behavior", extensions);
    GLAPILOADER_GL_ARB_robustness = hasExt("GL_ARB_robustness", extensions);
    GLAPILOADER_GL_ARB_robustness_isolation = hasExt("GL_ARB_robustness_isolation", extensions);
    GLAPILOADER_GL_ARB_sample_locations = hasExt("GL_ARB_sample_locations", extensions);
    GLAPILOADER_GL_ARB_sample_shading = hasExt("GL_ARB_sample_shading", extensions);
    GLAPILOADER_GL_ARB_sampler_objects = hasExt("GL_ARB_sampler_objects", extensions);
    GLAPILOADER_GL_ARB_seamless_cube_map = hasExt("GL_ARB_seamless_cube_map", extensions);
    GLAPILOADER_GL_ARB_seamless_cubemap_per_texture = hasExt("GL_ARB_seamless_cubemap_per_texture", extensions);
    GLAPILOADER_GL_ARB_separate_shader_objects = hasExt("GL_ARB_separate_shader_objects", extensions);
    GLAPILOADER_GL_ARB_shader_atomic_counter_ops = hasExt("GL_ARB_shader_atomic_counter_ops", extensions);
    GLAPILOADER_GL_ARB_shader_atomic_counters = hasExt("GL_ARB_shader_atomic_counters", extensions);
    GLAPILOADER_GL_ARB_shader_ballot = hasExt("GL_ARB_shader_ballot", extensions);
    GLAPILOADER_GL_ARB_shader_bit_encoding = hasExt("GL_ARB_shader_bit_encoding", extensions);
    GLAPILOADER_GL_ARB_shader_clock = hasExt("GL_ARB_shader_clock", extensions);
    GLAPILOADER_GL_ARB_shader_draw_parameters = hasExt("GL_ARB_shader_draw_parameters", extensions);
    GLAPILOADER_GL_ARB_shader_group_vote = hasExt("GL_ARB_shader_group_vote", extensions);
    GLAPILOADER_GL_ARB_shader_image_load_store = hasExt("GL_ARB_shader_image_load_store", extensions);
    GLAPILOADER_GL_ARB_shader_image_size = hasExt("GL_ARB_shader_image_size", extensions);
    GLAPILOADER_GL_ARB_shader_objects = hasExt("GL_ARB_shader_objects", extensions);
    GLAPILOADER_GL_ARB_shader_precision = hasExt("GL_ARB_shader_precision", extensions);
    GLAPILOADER_GL_ARB_shader_stencil_export = hasExt("GL_ARB_shader_stencil_export", extensions);
    GLAPILOADER_GL_ARB_shader_storage_buffer_object = hasExt("GL_ARB_shader_storage_buffer_object", extensions);
    GLAPILOADER_GL_ARB_shader_subroutine = hasExt("GL_ARB_shader_subroutine", extensions);
    GLAPILOADER_GL_ARB_shader_texture_image_samples = hasExt("GL_ARB_shader_texture_image_samples", extensions);
    GLAPILOADER_GL_ARB_shader_texture_lod = hasExt("GL_ARB_shader_texture_lod", extensions);
    GLAPILOADER_GL_ARB_shader_viewport_layer_array = hasExt("GL_ARB_shader_viewport_layer_array", extensions);
    GLAPILOADER_GL_ARB_shading_language_100 = hasExt("GL_ARB_shading_language_100", extensions);
    GLAPILOADER_GL_ARB_shading_language_420pack = hasExt("GL_ARB_shading_language_420pack", extensions);
    GLAPILOADER_GL_ARB_shading_language_include = hasExt("GL_ARB_shading_language_include", extensions);
    GLAPILOADER_GL_ARB_shading_language_packing = hasExt("GL_ARB_shading_language_packing", extensions);
    GLAPILOADER_GL_ARB_shadow = hasExt("GL_ARB_shadow", extensions);
    GLAPILOADER_GL_ARB_shadow_ambient = hasExt("GL_ARB_shadow_ambient", extensions);
    GLAPILOADER_GL_ARB_sparse_buffer = hasExt("GL_ARB_sparse_buffer", extensions);
    GLAPILOADER_GL_ARB_sparse_texture = hasExt("GL_ARB_sparse_texture", extensions);
    GLAPILOADER_GL_ARB_sparse_texture2 = hasExt("GL_ARB_sparse_texture2", extensions);
    GLAPILOADER_GL_ARB_sparse_texture_clamp = hasExt("GL_ARB_sparse_texture_clamp", extensions);
    GLAPILOADER_GL_ARB_spirv_extensions = hasExt("GL_ARB_spirv_extensions", extensions);
    GLAPILOADER_GL_ARB_stencil_texturing = hasExt("GL_ARB_stencil_texturing", extensions);
    GLAPILOADER_GL_ARB_sync = hasExt("GL_ARB_sync", extensions);
    GLAPILOADER_GL_ARB_tessellation_shader = hasExt("GL_ARB_tessellation_shader", extensions);
    GLAPILOADER_GL_ARB_texture_barrier = hasExt("GL_ARB_texture_barrier", extensions);
    GLAPILOADER_GL_ARB_texture_border_clamp = hasExt("GL_ARB_texture_border_clamp", extensions);
    GLAPILOADER_GL_ARB_texture_buffer_object = hasExt("GL_ARB_texture_buffer_object", extensions);
    GLAPILOADER_GL_ARB_texture_buffer_object_rgb32 = hasExt("GL_ARB_texture_buffer_object_rgb32", extensions);
    GLAPILOADER_GL_ARB_texture_buffer_range = hasExt("GL_ARB_texture_buffer_range", extensions);
    GLAPILOADER_GL_ARB_texture_compression = hasExt("GL_ARB_texture_compression", extensions);
    GLAPILOADER_GL_ARB_texture_compression_bptc = hasExt("GL_ARB_texture_compression_bptc", extensions);
    GLAPILOADER_GL_ARB_texture_compression_rgtc = hasExt("GL_ARB_texture_compression_rgtc", extensions);
    GLAPILOADER_GL_ARB_texture_cube_map = hasExt("GL_ARB_texture_cube_map", extensions);
    GLAPILOADER_GL_ARB_texture_cube_map_array = hasExt("GL_ARB_texture_cube_map_array", extensions);
    GLAPILOADER_GL_ARB_texture_env_add = hasExt("GL_ARB_texture_env_add", extensions);
    GLAPILOADER_GL_ARB_texture_env_combine = hasExt("GL_ARB_texture_env_combine", extensions);
    GLAPILOADER_GL_ARB_texture_env_crossbar = hasExt("GL_ARB_texture_env_crossbar", extensions);
    GLAPILOADER_GL_ARB_texture_env_dot3 = hasExt("GL_ARB_texture_env_dot3", extensions);
    GLAPILOADER_GL_ARB_texture_filter_anisotropic = hasExt("GL_ARB_texture_filter_anisotropic", extensions);
    GLAPILOADER_GL_ARB_texture_filter_minmax = hasExt("GL_ARB_texture_filter_minmax", extensions);
    GLAPILOADER_GL_ARB_texture_float = hasExt("GL_ARB_texture_float", extensions);
    GLAPILOADER_GL_ARB_texture_gather = hasExt("GL_ARB_texture_gather", extensions);
    GLAPILOADER_GL_ARB_texture_mirror_clamp_to_edge = hasExt("GL_ARB_texture_mirror_clamp_to_edge", extensions);
    GLAPILOADER_GL_ARB_texture_mirrored_repeat = hasExt("GL_ARB_texture_mirrored_repeat", extensions);
    GLAPILOADER_GL_ARB_texture_multisample = hasExt("GL_ARB_texture_multisample", extensions);
    GLAPILOADER_GL_ARB_texture_non_power_of_two = hasExt("GL_ARB_texture_non_power_of_two", extensions);
    GLAPILOADER_GL_ARB_texture_query_levels = hasExt("GL_ARB_texture_query_levels", extensions);
    GLAPILOADER_GL_ARB_texture_query_lod = hasExt("GL_ARB_texture_query_lod", extensions);
    GLAPILOADER_GL_ARB_texture_rectangle = hasExt("GL_ARB_texture_rectangle", extensions);
    GLAPILOADER_GL_ARB_texture_rg = hasExt("GL_ARB_texture_rg", extensions);
    GLAPILOADER_GL_ARB_texture_rgb10_a2ui = hasExt("GL_ARB_texture_rgb10_a2ui", extensions);
    GLAPILOADER_GL_ARB_texture_stencil8 = hasExt("GL_ARB_texture_stencil8", extensions);
    GLAPILOADER_GL_ARB_texture_storage = hasExt("GL_ARB_texture_storage", extensions);
    GLAPILOADER_GL_ARB_texture_storage_multisample = hasExt("GL_ARB_texture_storage_multisample", extensions);
    GLAPILOADER_GL_ARB_texture_swizzle = hasExt("GL_ARB_texture_swizzle", extensions);
    GLAPILOADER_GL_ARB_texture_view = hasExt("GL_ARB_texture_view", extensions);
    GLAPILOADER_GL_ARB_timer_query = hasExt("GL_ARB_timer_query", extensions);
    GLAPILOADER_GL_ARB_transform_feedback2 = hasExt("GL_ARB_transform_feedback2", extensions);
    GLAPILOADER_GL_ARB_transform_feedback3 = hasExt("GL_ARB_transform_feedback3", extensions);
    GLAPILOADER_GL_ARB_transform_feedback_instanced = hasExt("GL_ARB_transform_feedback_instanced", extensions);
    GLAPILOADER_GL_ARB_transform_feedback_overflow_query = hasExt("GL_ARB_transform_feedback_overflow_query", extensions);
    GLAPILOADER_GL_ARB_transpose_matrix = hasExt("GL_ARB_transpose_matrix", extensions);
    GLAPILOADER_GL_ARB_uniform_buffer_object = hasExt("GL_ARB_uniform_buffer_object", extensions);
    GLAPILOADER_GL_ARB_vertex_array_bgra = hasExt("GL_ARB_vertex_array_bgra", extensions);
    GLAPILOADER_GL_ARB_vertex_array_object = hasExt("GL_ARB_vertex_array_object", extensions);
    GLAPILOADER_GL_ARB_vertex_attrib_64bit = hasExt("GL_ARB_vertex_attrib_64bit", extensions);
    GLAPILOADER_GL_ARB_vertex_attrib_binding = hasExt("GL_ARB_vertex_attrib_binding", extensions);
    GLAPILOADER_GL_ARB_vertex_blend = hasExt("GL_ARB_vertex_blend", extensions);
    GLAPILOADER_GL_ARB_vertex_buffer_object = hasExt("GL_ARB_vertex_buffer_object", extensions);
    GLAPILOADER_GL_ARB_vertex_program = hasExt("GL_ARB_vertex_program", extensions);
    GLAPILOADER_GL_ARB_vertex_shader = hasExt("GL_ARB_vertex_shader", extensions);
    GLAPILOADER_GL_ARB_vertex_type_10f_11f_11f_rev = hasExt("GL_ARB_vertex_type_10f_11f_11f_rev", extensions);
    GLAPILOADER_GL_ARB_vertex_type_2_10_10_10_rev = hasExt("GL_ARB_vertex_type_2_10_10_10_rev", extensions);
    GLAPILOADER_GL_ARB_viewport_array = hasExt("GL_ARB_viewport_array", extensions);
    GLAPILOADER_GL_ARB_window_pos = hasExt("GL_ARB_window_pos", extensions);
    GLAPILOADER_GL_EXT_422_pixels = hasExt("GL_EXT_422_pixels", extensions);
    GLAPILOADER_GL_EXT_EGL_image_storage = hasExt("GL_EXT_EGL_image_storage", extensions);
    GLAPILOADER_GL_EXT_EGL_sync = hasExt("GL_EXT_EGL_sync", extensions);
    GLAPILOADER_GL_EXT_abgr = hasExt("GL_EXT_abgr", extensions);
    GLAPILOADER_GL_EXT_bgra = hasExt("GL_EXT_bgra", extensions);
    GLAPILOADER_GL_EXT_bindable_uniform = hasExt("GL_EXT_bindable_uniform", extensions);
    GLAPILOADER_GL_EXT_blend_color = hasExt("GL_EXT_blend_color", extensions);
    GLAPILOADER_GL_EXT_blend_equation_separate = hasExt("GL_EXT_blend_equation_separate", extensions);
    GLAPILOADER_GL_EXT_blend_func_separate = hasExt("GL_EXT_blend_func_separate", extensions);
    GLAPILOADER_GL_EXT_blend_logic_op = hasExt("GL_EXT_blend_logic_op", extensions);
    GLAPILOADER_GL_EXT_blend_minmax = hasExt("GL_EXT_blend_minmax", extensions);
    GLAPILOADER_GL_EXT_blend_subtract = hasExt("GL_EXT_blend_subtract", extensions);
    GLAPILOADER_GL_EXT_clip_volume_hint = hasExt("GL_EXT_clip_volume_hint", extensions);
    GLAPILOADER_GL_EXT_cmyka = hasExt("GL_EXT_cmyka", extensions);
    GLAPILOADER_GL_EXT_color_subtable = hasExt("GL_EXT_color_subtable", extensions);
    GLAPILOADER_GL_EXT_compiled_vertex_array = hasExt("GL_EXT_compiled_vertex_array", extensions);
    GLAPILOADER_GL_EXT_convolution = hasExt("GL_EXT_convolution", extensions);
    GLAPILOADER_GL_EXT_coordinate_frame = hasExt("GL_EXT_coordinate_frame", extensions);
    GLAPILOADER_GL_EXT_copy_texture = hasExt("GL_EXT_copy_texture", extensions);
    GLAPILOADER_GL_EXT_cull_vertex = hasExt("GL_EXT_cull_vertex", extensions);
    GLAPILOADER_GL_EXT_debug_label = hasExt("GL_EXT_debug_label", extensions);
    GLAPILOADER_GL_EXT_debug_marker = hasExt("GL_EXT_debug_marker", extensions);
    GLAPILOADER_GL_EXT_depth_bounds_test = hasExt("GL_EXT_depth_bounds_test", extensions);
    GLAPILOADER_GL_EXT_direct_state_access = hasExt("GL_EXT_direct_state_access", extensions);
    GLAPILOADER_GL_EXT_draw_buffers2 = hasExt("GL_EXT_draw_buffers2", extensions);
    GLAPILOADER_GL_EXT_draw_instanced = hasExt("GL_EXT_draw_instanced", extensions);
    GLAPILOADER_GL_EXT_draw_range_elements = hasExt("GL_EXT_draw_range_elements", extensions);
    GLAPILOADER_GL_EXT_external_buffer = hasExt("GL_EXT_external_buffer", extensions);
    GLAPILOADER_GL_EXT_fog_coord = hasExt("GL_EXT_fog_coord", extensions);
    GLAPILOADER_GL_EXT_framebuffer_blit = hasExt("GL_EXT_framebuffer_blit", extensions);
    GLAPILOADER_GL_EXT_framebuffer_multisample = hasExt("GL_EXT_framebuffer_multisample", extensions);
    GLAPILOADER_GL_EXT_framebuffer_multisample_blit_scaled = hasExt("GL_EXT_framebuffer_multisample_blit_scaled", extensions);
    GLAPILOADER_GL_EXT_framebuffer_object = hasExt("GL_EXT_framebuffer_object", extensions);
    GLAPILOADER_GL_EXT_framebuffer_sRGB = hasExt("GL_EXT_framebuffer_sRGB", extensions);
    GLAPILOADER_GL_EXT_geometry_shader4 = hasExt("GL_EXT_geometry_shader4", extensions);
    GLAPILOADER_GL_EXT_gpu_program_parameters = hasExt("GL_EXT_gpu_program_parameters", extensions);
    GLAPILOADER_GL_EXT_gpu_shader4 = hasExt("GL_EXT_gpu_shader4", extensions);
    GLAPILOADER_GL_EXT_histogram = hasExt("GL_EXT_histogram", extensions);
    GLAPILOADER_GL_EXT_index_array_formats = hasExt("GL_EXT_index_array_formats", extensions);
    GLAPILOADER_GL_EXT_index_func = hasExt("GL_EXT_index_func", extensions);
    GLAPILOADER_GL_EXT_index_material = hasExt("GL_EXT_index_material", extensions);
    GLAPILOADER_GL_EXT_index_texture = hasExt("GL_EXT_index_texture", extensions);
    GLAPILOADER_GL_EXT_light_texture = hasExt("GL_EXT_light_texture", extensions);
    GLAPILOADER_GL_EXT_memory_object = hasExt("GL_EXT_memory_object", extensions);
    GLAPILOADER_GL_EXT_memory_object_fd = hasExt("GL_EXT_memory_object_fd", extensions);
    GLAPILOADER_GL_EXT_memory_object_win32 = hasExt("GL_EXT_memory_object_win32", extensions);
    GLAPILOADER_GL_EXT_misc_attribute = hasExt("GL_EXT_misc_attribute", extensions);
    GLAPILOADER_GL_EXT_multi_draw_arrays = hasExt("GL_EXT_multi_draw_arrays", extensions);
    GLAPILOADER_GL_EXT_multisample = hasExt("GL_EXT_multisample", extensions);
    GLAPILOADER_GL_EXT_multiview_tessellation_geometry_shader = hasExt("GL_EXT_multiview_tessellation_geometry_shader", extensions);
    GLAPILOADER_GL_EXT_multiview_texture_multisample = hasExt("GL_EXT_multiview_texture_multisample", extensions);
    GLAPILOADER_GL_EXT_multiview_timer_query = hasExt("GL_EXT_multiview_timer_query", extensions);
    GLAPILOADER_GL_EXT_packed_depth_stencil = hasExt("GL_EXT_packed_depth_stencil", extensions);
    GLAPILOADER_GL_EXT_packed_float = hasExt("GL_EXT_packed_float", extensions);
    GLAPILOADER_GL_EXT_packed_pixels = hasExt("GL_EXT_packed_pixels", extensions);
    GLAPILOADER_GL_EXT_paletted_texture = hasExt("GL_EXT_paletted_texture", extensions);
    GLAPILOADER_GL_EXT_pixel_buffer_object = hasExt("GL_EXT_pixel_buffer_object", extensions);
    GLAPILOADER_GL_EXT_pixel_transform = hasExt("GL_EXT_pixel_transform", extensions);
    GLAPILOADER_GL_EXT_pixel_transform_color_table = hasExt("GL_EXT_pixel_transform_color_table", extensions);
    GLAPILOADER_GL_EXT_point_parameters = hasExt("GL_EXT_point_parameters", extensions);
    GLAPILOADER_GL_EXT_polygon_offset = hasExt("GL_EXT_polygon_offset", extensions);
    GLAPILOADER_GL_EXT_polygon_offset_clamp = hasExt("GL_EXT_polygon_offset_clamp", extensions);
    GLAPILOADER_GL_EXT_post_depth_coverage = hasExt("GL_EXT_post_depth_coverage", extensions);
    GLAPILOADER_GL_EXT_provoking_vertex = hasExt("GL_EXT_provoking_vertex", extensions);
    GLAPILOADER_GL_EXT_raster_multisample = hasExt("GL_EXT_raster_multisample", extensions);
    GLAPILOADER_GL_EXT_rescale_normal = hasExt("GL_EXT_rescale_normal", extensions);
    GLAPILOADER_GL_EXT_semaphore = hasExt("GL_EXT_semaphore", extensions);
    GLAPILOADER_GL_EXT_semaphore_fd = hasExt("GL_EXT_semaphore_fd", extensions);
    GLAPILOADER_GL_EXT_semaphore_win32 = hasExt("GL_EXT_semaphore_win32", extensions);
    GLAPILOADER_GL_EXT_secondary_color = hasExt("GL_EXT_secondary_color", extensions);
    GLAPILOADER_GL_EXT_separate_shader_objects = hasExt("GL_EXT_separate_shader_objects", extensions);
    GLAPILOADER_GL_EXT_separate_specular_color = hasExt("GL_EXT_separate_specular_color", extensions);
    GLAPILOADER_GL_EXT_shader_framebuffer_fetch = hasExt("GL_EXT_shader_framebuffer_fetch", extensions);
    GLAPILOADER_GL_EXT_shader_framebuffer_fetch_non_coherent = hasExt("GL_EXT_shader_framebuffer_fetch_non_coherent", extensions);
    GLAPILOADER_GL_EXT_shader_image_load_formatted = hasExt("GL_EXT_shader_image_load_formatted", extensions);
    GLAPILOADER_GL_EXT_shader_image_load_store = hasExt("GL_EXT_shader_image_load_store", extensions);
    GLAPILOADER_GL_EXT_shader_integer_mix = hasExt("GL_EXT_shader_integer_mix", extensions);
    GLAPILOADER_GL_EXT_shadow_funcs = hasExt("GL_EXT_shadow_funcs", extensions);
    GLAPILOADER_GL_EXT_shared_texture_palette = hasExt("GL_EXT_shared_texture_palette", extensions);
    GLAPILOADER_GL_EXT_sparse_texture2 = hasExt("GL_EXT_sparse_texture2", extensions);
    GLAPILOADER_GL_EXT_stencil_clear_tag = hasExt("GL_EXT_stencil_clear_tag", extensions);
    GLAPILOADER_GL_EXT_stencil_two_side = hasExt("GL_EXT_stencil_two_side", extensions);
    GLAPILOADER_GL_EXT_stencil_wrap = hasExt("GL_EXT_stencil_wrap", extensions);
    GLAPILOADER_GL_EXT_subtexture = hasExt("GL_EXT_subtexture", extensions);
    GLAPILOADER_GL_EXT_texture = hasExt("GL_EXT_texture", extensions);
    GLAPILOADER_GL_EXT_texture3D = hasExt("GL_EXT_texture3D", extensions);
    GLAPILOADER_GL_EXT_texture_array = hasExt("GL_EXT_texture_array", extensions);
    GLAPILOADER_GL_EXT_texture_buffer_object = hasExt("GL_EXT_texture_buffer_object", extensions);
    GLAPILOADER_GL_EXT_texture_compression_latc = hasExt("GL_EXT_texture_compression_latc", extensions);
    GLAPILOADER_GL_EXT_texture_compression_rgtc = hasExt("GL_EXT_texture_compression_rgtc", extensions);
    GLAPILOADER_GL_EXT_texture_compression_s3tc = hasExt("GL_EXT_texture_compression_s3tc", extensions);
    GLAPILOADER_GL_EXT_texture_cube_map = hasExt("GL_EXT_texture_cube_map", extensions);
    GLAPILOADER_GL_EXT_texture_env_add = hasExt("GL_EXT_texture_env_add", extensions);
    GLAPILOADER_GL_EXT_texture_env_combine = hasExt("GL_EXT_texture_env_combine", extensions);
    GLAPILOADER_GL_EXT_texture_env_dot3 = hasExt("GL_EXT_texture_env_dot3", extensions);
    GLAPILOADER_GL_EXT_texture_filter_anisotropic = hasExt("GL_EXT_texture_filter_anisotropic", extensions);
    GLAPILOADER_GL_EXT_texture_filter_minmax = hasExt("GL_EXT_texture_filter_minmax", extensions);
    GLAPILOADER_GL_EXT_texture_integer = hasExt("GL_EXT_texture_integer", extensions);
    GLAPILOADER_GL_EXT_texture_lod_bias = hasExt("GL_EXT_texture_lod_bias", extensions);
    GLAPILOADER_GL_EXT_texture_mirror_clamp = hasExt("GL_EXT_texture_mirror_clamp", extensions);
    GLAPILOADER_GL_EXT_texture_object = hasExt("GL_EXT_texture_object", extensions);
    GLAPILOADER_GL_EXT_texture_perturb_normal = hasExt("GL_EXT_texture_perturb_normal", extensions);
    GLAPILOADER_GL_EXT_texture_sRGB = hasExt("GL_EXT_texture_sRGB", extensions);
    GLAPILOADER_GL_EXT_texture_sRGB_R8 = hasExt("GL_EXT_texture_sRGB_R8", extensions);
    GLAPILOADER_GL_EXT_texture_sRGB_decode = hasExt("GL_EXT_texture_sRGB_decode", extensions);
    GLAPILOADER_GL_EXT_texture_shared_exponent = hasExt("GL_EXT_texture_shared_exponent", extensions);
    GLAPILOADER_GL_EXT_texture_snorm = hasExt("GL_EXT_texture_snorm", extensions);
    GLAPILOADER_GL_EXT_texture_swizzle = hasExt("GL_EXT_texture_swizzle", extensions);
    GLAPILOADER_GL_EXT_timer_query = hasExt("GL_EXT_timer_query", extensions);
    GLAPILOADER_GL_EXT_transform_feedback = hasExt("GL_EXT_transform_feedback", extensions);
    GLAPILOADER_GL_EXT_vertex_array = hasExt("GL_EXT_vertex_array", extensions);
    GLAPILOADER_GL_EXT_vertex_array_bgra = hasExt("GL_EXT_vertex_array_bgra", extensions);
    GLAPILOADER_GL_EXT_vertex_attrib_64bit = hasExt("GL_EXT_vertex_attrib_64bit", extensions);
    GLAPILOADER_GL_EXT_vertex_shader = hasExt("GL_EXT_vertex_shader", extensions);
    GLAPILOADER_GL_EXT_vertex_weighting = hasExt("GL_EXT_vertex_weighting", extensions);
    GLAPILOADER_GL_EXT_win32_keyed_mutex = hasExt("GL_EXT_win32_keyed_mutex", extensions);
    GLAPILOADER_GL_EXT_window_rectangles = hasExt("GL_EXT_window_rectangles", extensions);
    GLAPILOADER_GL_EXT_x11_sync_object = hasExt("GL_EXT_x11_sync_object", extensions);
    GLAPILOADER_GL_INTEL_conservative_rasterization = hasExt("GL_INTEL_conservative_rasterization", extensions);
    GLAPILOADER_GL_INTEL_fragment_shader_ordering = hasExt("GL_INTEL_fragment_shader_ordering", extensions);
    GLAPILOADER_GL_INTEL_framebuffer_CMAA = hasExt("GL_INTEL_framebuffer_CMAA", extensions);
    GLAPILOADER_GL_INTEL_map_texture = hasExt("GL_INTEL_map_texture", extensions);
    GLAPILOADER_GL_INTEL_blackhole_render = hasExt("GL_INTEL_blackhole_render", extensions);
    GLAPILOADER_GL_INTEL_parallel_arrays = hasExt("GL_INTEL_parallel_arrays", extensions);
    GLAPILOADER_GL_INTEL_performance_query = hasExt("GL_INTEL_performance_query", extensions);
    GLAPILOADER_GL_KHR_blend_equation_advanced = hasExt("GL_KHR_blend_equation_advanced", extensions);
    GLAPILOADER_GL_KHR_blend_equation_advanced_coherent = hasExt("GL_KHR_blend_equation_advanced_coherent", extensions);
    GLAPILOADER_GL_KHR_context_flush_control = hasExt("GL_KHR_context_flush_control", extensions);
    GLAPILOADER_GL_KHR_debug = hasExt("GL_KHR_debug", extensions);
    GLAPILOADER_GL_KHR_no_error = hasExt("GL_KHR_no_error", extensions);
    GLAPILOADER_GL_KHR_robust_buffer_access_behavior = hasExt("GL_KHR_robust_buffer_access_behavior", extensions);
    GLAPILOADER_GL_KHR_robustness = hasExt("GL_KHR_robustness", extensions);
    GLAPILOADER_GL_KHR_shader_subgroup = hasExt("GL_KHR_shader_subgroup", extensions);
    GLAPILOADER_GL_KHR_texture_compression_astc_hdr = hasExt("GL_KHR_texture_compression_astc_hdr", extensions);
    GLAPILOADER_GL_KHR_texture_compression_astc_ldr = hasExt("GL_KHR_texture_compression_astc_ldr", extensions);
    GLAPILOADER_GL_KHR_texture_compression_astc_sliced_3d = hasExt("GL_KHR_texture_compression_astc_sliced_3d", extensions);
    GLAPILOADER_GL_KHR_parallel_shader_compile = hasExt("GL_KHR_parallel_shader_compile", extensions);
    GLAPILOADER_GL_NV_alpha_to_coverage_dither_control = hasExt("GL_NV_alpha_to_coverage_dither_control", extensions);
    GLAPILOADER_GL_NV_bindless_multi_draw_indirect = hasExt("GL_NV_bindless_multi_draw_indirect", extensions);
    GLAPILOADER_GL_NV_bindless_multi_draw_indirect_count = hasExt("GL_NV_bindless_multi_draw_indirect_count", extensions);
    GLAPILOADER_GL_NV_bindless_texture = hasExt("GL_NV_bindless_texture", extensions);
    GLAPILOADER_GL_NV_blend_equation_advanced = hasExt("GL_NV_blend_equation_advanced", extensions);
    GLAPILOADER_GL_NV_blend_equation_advanced_coherent = hasExt("GL_NV_blend_equation_advanced_coherent", extensions);
    GLAPILOADER_GL_NV_blend_minmax_factor = hasExt("GL_NV_blend_minmax_factor", extensions);
    GLAPILOADER_GL_NV_blend_square = hasExt("GL_NV_blend_square", extensions);
    GLAPILOADER_GL_NV_clip_space_w_scaling = hasExt("GL_NV_clip_space_w_scaling", extensions);
    GLAPILOADER_GL_NV_command_list = hasExt("GL_NV_command_list", extensions);
    GLAPILOADER_GL_NV_compute_program5 = hasExt("GL_NV_compute_program5", extensions);
    GLAPILOADER_GL_NV_compute_shader_derivatives = hasExt("GL_NV_compute_shader_derivatives", extensions);
    GLAPILOADER_GL_NV_conditional_render = hasExt("GL_NV_conditional_render", extensions);
    GLAPILOADER_GL_NV_conservative_raster = hasExt("GL_NV_conservative_raster", extensions);
    GLAPILOADER_GL_NV_conservative_raster_dilate = hasExt("GL_NV_conservative_raster_dilate", extensions);
    GLAPILOADER_GL_NV_conservative_raster_pre_snap = hasExt("GL_NV_conservative_raster_pre_snap", extensions);
    GLAPILOADER_GL_NV_conservative_raster_pre_snap_triangles = hasExt("GL_NV_conservative_raster_pre_snap_triangles", extensions);
    GLAPILOADER_GL_NV_conservative_raster_underestimation = hasExt("GL_NV_conservative_raster_underestimation", extensions);
    GLAPILOADER_GL_NV_copy_depth_to_color = hasExt("GL_NV_copy_depth_to_color", extensions);
    GLAPILOADER_GL_NV_copy_image = hasExt("GL_NV_copy_image", extensions);
    GLAPILOADER_GL_NV_deep_texture3D = hasExt("GL_NV_deep_texture3D", extensions);
    GLAPILOADER_GL_NV_depth_buffer_float = hasExt("GL_NV_depth_buffer_float", extensions);
    GLAPILOADER_GL_NV_depth_clamp = hasExt("GL_NV_depth_clamp", extensions);
    GLAPILOADER_GL_NV_draw_texture = hasExt("GL_NV_draw_texture", extensions);
    GLAPILOADER_GL_NV_draw_vulkan_image = hasExt("GL_NV_draw_vulkan_image", extensions);
    GLAPILOADER_GL_NV_evaluators = hasExt("GL_NV_evaluators", extensions);
    GLAPILOADER_GL_NV_explicit_multisample = hasExt("GL_NV_explicit_multisample", extensions);
    GLAPILOADER_GL_NV_fence = hasExt("GL_NV_fence", extensions);
    GLAPILOADER_GL_NV_fill_rectangle = hasExt("GL_NV_fill_rectangle", extensions);
    GLAPILOADER_GL_NV_float_buffer = hasExt("GL_NV_float_buffer", extensions);
    GLAPILOADER_GL_NV_fog_distance = hasExt("GL_NV_fog_distance", extensions);
    GLAPILOADER_GL_NV_fragment_coverage_to_color = hasExt("GL_NV_fragment_coverage_to_color", extensions);
    GLAPILOADER_GL_NV_fragment_program = hasExt("GL_NV_fragment_program", extensions);
    GLAPILOADER_GL_NV_fragment_program2 = hasExt("GL_NV_fragment_program2", extensions);
    GLAPILOADER_GL_NV_fragment_program4 = hasExt("GL_NV_fragment_program4", extensions);
    GLAPILOADER_GL_NV_fragment_program_option = hasExt("GL_NV_fragment_program_option", extensions);
    GLAPILOADER_GL_NV_fragment_shader_barycentric = hasExt("GL_NV_fragment_shader_barycentric", extensions);
    GLAPILOADER_GL_NV_fragment_shader_interlock = hasExt("GL_NV_fragment_shader_interlock", extensions);
    GLAPILOADER_GL_NV_framebuffer_mixed_samples = hasExt("GL_NV_framebuffer_mixed_samples", extensions);
    GLAPILOADER_GL_NV_framebuffer_multisample_coverage = hasExt("GL_NV_framebuffer_multisample_coverage", extensions);
    GLAPILOADER_GL_NV_geometry_program4 = hasExt("GL_NV_geometry_program4", extensions);
    GLAPILOADER_GL_NV_geometry_shader4 = hasExt("GL_NV_geometry_shader4", extensions);
    GLAPILOADER_GL_NV_geometry_shader_passthrough = hasExt("GL_NV_geometry_shader_passthrough", extensions);
    GLAPILOADER_GL_NV_gpu_program4 = hasExt("GL_NV_gpu_program4", extensions);
    GLAPILOADER_GL_NV_gpu_program5 = hasExt("GL_NV_gpu_program5", extensions);
    GLAPILOADER_GL_NV_gpu_program5_mem_extended = hasExt("GL_NV_gpu_program5_mem_extended", extensions);
    GLAPILOADER_GL_NV_gpu_shader5 = hasExt("GL_NV_gpu_shader5", extensions);
    GLAPILOADER_GL_NV_half_float = hasExt("GL_NV_half_float", extensions);
    GLAPILOADER_GL_NV_internalformat_sample_query = hasExt("GL_NV_internalformat_sample_query", extensions);
    GLAPILOADER_GL_NV_light_max_exponent = hasExt("GL_NV_light_max_exponent", extensions);
    GLAPILOADER_GL_NV_gpu_multicast = hasExt("GL_NV_gpu_multicast", extensions);
    GLAPILOADER_GL_NV_memory_attachment = hasExt("GL_NV_memory_attachment", extensions);
    GLAPILOADER_GL_NV_mesh_shader = hasExt("GL_NV_mesh_shader", extensions);
    GLAPILOADER_GL_NV_multisample_coverage = hasExt("GL_NV_multisample_coverage", extensions);
    GLAPILOADER_GL_NV_multisample_filter_hint = hasExt("GL_NV_multisample_filter_hint", extensions);
    GLAPILOADER_GL_NV_occlusion_query = hasExt("GL_NV_occlusion_query", extensions);
    GLAPILOADER_GL_NV_packed_depth_stencil = hasExt("GL_NV_packed_depth_stencil", extensions);
    GLAPILOADER_GL_NV_parameter_buffer_object = hasExt("GL_NV_parameter_buffer_object", extensions);
    GLAPILOADER_GL_NV_parameter_buffer_object2 = hasExt("GL_NV_parameter_buffer_object2", extensions);
    GLAPILOADER_GL_NV_path_rendering = hasExt("GL_NV_path_rendering", extensions);
    GLAPILOADER_GL_NV_path_rendering_shared_edge = hasExt("GL_NV_path_rendering_shared_edge", extensions);
    GLAPILOADER_GL_NV_pixel_data_range = hasExt("GL_NV_pixel_data_range", extensions);
    GLAPILOADER_GL_NV_point_sprite = hasExt("GL_NV_point_sprite", extensions);
    GLAPILOADER_GL_NV_present_video = hasExt("GL_NV_present_video", extensions);
    GLAPILOADER_GL_NV_primitive_restart = hasExt("GL_NV_primitive_restart", extensions);
    GLAPILOADER_GL_NV_query_resource = hasExt("GL_NV_query_resource", extensions);
    GLAPILOADER_GL_NV_query_resource_tag = hasExt("GL_NV_query_resource_tag", extensions);
    GLAPILOADER_GL_NV_register_combiners = hasExt("GL_NV_register_combiners", extensions);
    GLAPILOADER_GL_NV_register_combiners2 = hasExt("GL_NV_register_combiners2", extensions);
    GLAPILOADER_GL_NV_representative_fragment_test = hasExt("GL_NV_representative_fragment_test", extensions);
    GLAPILOADER_GL_NV_robustness_video_memory_purge = hasExt("GL_NV_robustness_video_memory_purge", extensions);
    GLAPILOADER_GL_NV_sample_locations = hasExt("GL_NV_sample_locations", extensions);
    GLAPILOADER_GL_NV_sample_mask_override_coverage = hasExt("GL_NV_sample_mask_override_coverage", extensions);
    GLAPILOADER_GL_NV_scissor_exclusive = hasExt("GL_NV_scissor_exclusive", extensions);
    GLAPILOADER_GL_NV_shader_atomic_counters = hasExt("GL_NV_shader_atomic_counters", extensions);
    GLAPILOADER_GL_NV_shader_atomic_float = hasExt("GL_NV_shader_atomic_float", extensions);
    GLAPILOADER_GL_NV_shader_atomic_float64 = hasExt("GL_NV_shader_atomic_float64", extensions);
    GLAPILOADER_GL_NV_shader_atomic_fp16_vector = hasExt("GL_NV_shader_atomic_fp16_vector", extensions);
    GLAPILOADER_GL_NV_shader_atomic_int64 = hasExt("GL_NV_shader_atomic_int64", extensions);
    GLAPILOADER_GL_NV_shader_buffer_load = hasExt("GL_NV_shader_buffer_load", extensions);
    GLAPILOADER_GL_NV_shader_buffer_store = hasExt("GL_NV_shader_buffer_store", extensions);
    GLAPILOADER_GL_NV_shader_storage_buffer_object = hasExt("GL_NV_shader_storage_buffer_object", extensions);
    GLAPILOADER_GL_NV_shader_subgroup_partitioned = hasExt("GL_NV_shader_subgroup_partitioned", extensions);
    GLAPILOADER_GL_NV_shader_texture_footprint = hasExt("GL_NV_shader_texture_footprint", extensions);
    GLAPILOADER_GL_NV_shader_thread_group = hasExt("GL_NV_shader_thread_group", extensions);
    GLAPILOADER_GL_NV_shader_thread_shuffle = hasExt("GL_NV_shader_thread_shuffle", extensions);
    GLAPILOADER_GL_NV_shading_rate_image = hasExt("GL_NV_shading_rate_image", extensions);
    GLAPILOADER_GL_NV_stereo_view_rendering = hasExt("GL_NV_stereo_view_rendering", extensions);
    GLAPILOADER_GL_NV_tessellation_program5 = hasExt("GL_NV_tessellation_program5", extensions);
    GLAPILOADER_GL_NV_texgen_emboss = hasExt("GL_NV_texgen_emboss", extensions);
    GLAPILOADER_GL_NV_texgen_reflection = hasExt("GL_NV_texgen_reflection", extensions);
    GLAPILOADER_GL_NV_texture_barrier = hasExt("GL_NV_texture_barrier", extensions);
    GLAPILOADER_GL_NV_texture_compression_vtc = hasExt("GL_NV_texture_compression_vtc", extensions);
    GLAPILOADER_GL_NV_texture_env_combine4 = hasExt("GL_NV_texture_env_combine4", extensions);
    GLAPILOADER_GL_NV_texture_expand_normal = hasExt("GL_NV_texture_expand_normal", extensions);
    GLAPILOADER_GL_NV_texture_multisample = hasExt("GL_NV_texture_multisample", extensions);
    GLAPILOADER_GL_NV_texture_rectangle = hasExt("GL_NV_texture_rectangle", extensions);
    GLAPILOADER_GL_NV_texture_rectangle_compressed = hasExt("GL_NV_texture_rectangle_compressed", extensions);
    GLAPILOADER_GL_NV_texture_shader = hasExt("GL_NV_texture_shader", extensions);
    GLAPILOADER_GL_NV_texture_shader2 = hasExt("GL_NV_texture_shader2", extensions);
    GLAPILOADER_GL_NV_texture_shader3 = hasExt("GL_NV_texture_shader3", extensions);
    GLAPILOADER_GL_NV_transform_feedback = hasExt("GL_NV_transform_feedback", extensions);
    GLAPILOADER_GL_NV_transform_feedback2 = hasExt("GL_NV_transform_feedback2", extensions);
    GLAPILOADER_GL_NV_uniform_buffer_unified_memory = hasExt("GL_NV_uniform_buffer_unified_memory", extensions);
    GLAPILOADER_GL_NV_vdpau_interop = hasExt("GL_NV_vdpau_interop", extensions);
    GLAPILOADER_GL_NV_vdpau_interop2 = hasExt("GL_NV_vdpau_interop2", extensions);
    GLAPILOADER_GL_NV_vertex_array_range = hasExt("GL_NV_vertex_array_range", extensions);
    GLAPILOADER_GL_NV_vertex_array_range2 = hasExt("GL_NV_vertex_array_range2", extensions);
    GLAPILOADER_GL_NV_vertex_attrib_integer_64bit = hasExt("GL_NV_vertex_attrib_integer_64bit", extensions);
    GLAPILOADER_GL_NV_vertex_buffer_unified_memory = hasExt("GL_NV_vertex_buffer_unified_memory", extensions);
    GLAPILOADER_GL_NV_vertex_program = hasExt("GL_NV_vertex_program", extensions);
    GLAPILOADER_GL_NV_vertex_program1_1 = hasExt("GL_NV_vertex_program1_1", extensions);
    GLAPILOADER_GL_NV_vertex_program2 = hasExt("GL_NV_vertex_program2", extensions);
    GLAPILOADER_GL_NV_vertex_program2_option = hasExt("GL_NV_vertex_program2_option", extensions);
    GLAPILOADER_GL_NV_vertex_program3 = hasExt("GL_NV_vertex_program3", extensions);
    GLAPILOADER_GL_NV_vertex_program4 = hasExt("GL_NV_vertex_program4", extensions);
    GLAPILOADER_GL_NV_video_capture = hasExt("GL_NV_video_capture", extensions);
    GLAPILOADER_GL_NV_viewport_array2 = hasExt("GL_NV_viewport_array2", extensions);
    GLAPILOADER_GL_NV_viewport_swizzle = hasExt("GL_NV_viewport_swizzle", extensions);
    GLAPILOADER_GL_EXT_texture_shadow_lod = hasExt("GL_EXT_texture_shadow_lod", extensions);

    glAccum = (PFNGLACCUMPROC) loadFunction("glAccum");
    glActiveProgramEXT = (PFNGLACTIVEPROGRAMEXTPROC) loadFunction("glActiveProgramEXT");
    glActiveShaderProgram = (PFNGLACTIVESHADERPROGRAMPROC) loadFunction("glActiveShaderProgram");
    glActiveShaderProgramEXT = (PFNGLACTIVESHADERPROGRAMEXTPROC) loadFunction("glActiveShaderProgramEXT");
    glActiveStencilFaceEXT = (PFNGLACTIVESTENCILFACEEXTPROC) loadFunction("glActiveStencilFaceEXT");
    glActiveTexture = (PFNGLACTIVETEXTUREPROC) loadFunction("glActiveTexture");
    glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC) loadFunction("glActiveTextureARB");
    glActiveVaryingNV = (PFNGLACTIVEVARYINGNVPROC) loadFunction("glActiveVaryingNV");
    glAlphaFunc = (PFNGLALPHAFUNCPROC) loadFunction("glAlphaFunc");
    glAlphaToCoverageDitherControlNV = (PFNGLALPHATOCOVERAGEDITHERCONTROLNVPROC) loadFunction("glAlphaToCoverageDitherControlNV");
    glApplyFramebufferAttachmentCMAAINTEL = (PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC) loadFunction("glApplyFramebufferAttachmentCMAAINTEL");
    glApplyTextureEXT = (PFNGLAPPLYTEXTUREEXTPROC) loadFunction("glApplyTextureEXT");
    glAcquireKeyedMutexWin32EXT = (PFNGLACQUIREKEYEDMUTEXWIN32EXTPROC) loadFunction("glAcquireKeyedMutexWin32EXT");
    glAreProgramsResidentNV = (PFNGLAREPROGRAMSRESIDENTNVPROC) loadFunction("glAreProgramsResidentNV");
    glAreTexturesResident = (PFNGLARETEXTURESRESIDENTPROC) loadFunction("glAreTexturesResident");
    glAreTexturesResidentEXT = (PFNGLARETEXTURESRESIDENTEXTPROC) loadFunction("glAreTexturesResidentEXT");
    glArrayElement = (PFNGLARRAYELEMENTPROC) loadFunction("glArrayElement");
    glArrayElementEXT = (PFNGLARRAYELEMENTEXTPROC) loadFunction("glArrayElementEXT");
    glAttachObjectARB = (PFNGLATTACHOBJECTARBPROC) loadFunction("glAttachObjectARB");
    glAttachShader = (PFNGLATTACHSHADERPROC) loadFunction("glAttachShader");
    glBegin = (PFNGLBEGINPROC) loadFunction("glBegin");
    glBeginConditionalRender = (PFNGLBEGINCONDITIONALRENDERPROC) loadFunction("glBeginConditionalRender");
    glBeginConditionalRenderNV = (PFNGLBEGINCONDITIONALRENDERNVPROC) loadFunction("glBeginConditionalRenderNV");
    glBeginOcclusionQueryNV = (PFNGLBEGINOCCLUSIONQUERYNVPROC) loadFunction("glBeginOcclusionQueryNV");
    glBeginPerfMonitorAMD = (PFNGLBEGINPERFMONITORAMDPROC) loadFunction("glBeginPerfMonitorAMD");
    glBeginPerfQueryINTEL = (PFNGLBEGINPERFQUERYINTELPROC) loadFunction("glBeginPerfQueryINTEL");
    glBeginQuery = (PFNGLBEGINQUERYPROC) loadFunction("glBeginQuery");
    glBeginQueryARB = (PFNGLBEGINQUERYARBPROC) loadFunction("glBeginQueryARB");
    glBeginQueryIndexed = (PFNGLBEGINQUERYINDEXEDPROC) loadFunction("glBeginQueryIndexed");
    glBeginTransformFeedback = (PFNGLBEGINTRANSFORMFEEDBACKPROC) loadFunction("glBeginTransformFeedback");
    glBeginTransformFeedbackEXT = (PFNGLBEGINTRANSFORMFEEDBACKEXTPROC) loadFunction("glBeginTransformFeedbackEXT");
    glBeginTransformFeedbackNV = (PFNGLBEGINTRANSFORMFEEDBACKNVPROC) loadFunction("glBeginTransformFeedbackNV");
    glBeginVertexShaderEXT = (PFNGLBEGINVERTEXSHADEREXTPROC) loadFunction("glBeginVertexShaderEXT");
    glBeginVideoCaptureNV = (PFNGLBEGINVIDEOCAPTURENVPROC) loadFunction("glBeginVideoCaptureNV");
    glBindAttribLocation = (PFNGLBINDATTRIBLOCATIONPROC) loadFunction("glBindAttribLocation");
    glBindAttribLocationARB = (PFNGLBINDATTRIBLOCATIONARBPROC) loadFunction("glBindAttribLocationARB");
    glBindBuffer = (PFNGLBINDBUFFERPROC) loadFunction("glBindBuffer");
    glBindBufferARB = (PFNGLBINDBUFFERARBPROC) loadFunction("glBindBufferARB");
    glBindBufferBase = (PFNGLBINDBUFFERBASEPROC) loadFunction("glBindBufferBase");
    glBindBufferBaseEXT = (PFNGLBINDBUFFERBASEEXTPROC) loadFunction("glBindBufferBaseEXT");
    glBindBufferBaseNV = (PFNGLBINDBUFFERBASENVPROC) loadFunction("glBindBufferBaseNV");
    glBindBufferOffsetEXT = (PFNGLBINDBUFFEROFFSETEXTPROC) loadFunction("glBindBufferOffsetEXT");
    glBindBufferOffsetNV = (PFNGLBINDBUFFEROFFSETNVPROC) loadFunction("glBindBufferOffsetNV");
    glBindBufferRange = (PFNGLBINDBUFFERRANGEPROC) loadFunction("glBindBufferRange");
    glBindBufferRangeEXT = (PFNGLBINDBUFFERRANGEEXTPROC) loadFunction("glBindBufferRangeEXT");
    glBindBufferRangeNV = (PFNGLBINDBUFFERRANGENVPROC) loadFunction("glBindBufferRangeNV");
    glBindBuffersBase = (PFNGLBINDBUFFERSBASEPROC) loadFunction("glBindBuffersBase");
    glBindBuffersRange = (PFNGLBINDBUFFERSRANGEPROC) loadFunction("glBindBuffersRange");
    glBindFragDataLocation = (PFNGLBINDFRAGDATALOCATIONPROC) loadFunction("glBindFragDataLocation");
    glBindFragDataLocationEXT = (PFNGLBINDFRAGDATALOCATIONEXTPROC) loadFunction("glBindFragDataLocationEXT");
    glBindFragDataLocationIndexed = (PFNGLBINDFRAGDATALOCATIONINDEXEDPROC) loadFunction("glBindFragDataLocationIndexed");
    glBindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC) loadFunction("glBindFramebuffer");
    glBindFramebufferEXT = (PFNGLBINDFRAMEBUFFEREXTPROC) loadFunction("glBindFramebufferEXT");
    glBindImageTexture = (PFNGLBINDIMAGETEXTUREPROC) loadFunction("glBindImageTexture");
    glBindImageTextureEXT = (PFNGLBINDIMAGETEXTUREEXTPROC) loadFunction("glBindImageTextureEXT");
    glBindImageTextures = (PFNGLBINDIMAGETEXTURESPROC) loadFunction("glBindImageTextures");
    glBindLightParameterEXT = (PFNGLBINDLIGHTPARAMETEREXTPROC) loadFunction("glBindLightParameterEXT");
    glBindMaterialParameterEXT = (PFNGLBINDMATERIALPARAMETEREXTPROC) loadFunction("glBindMaterialParameterEXT");
    glBindMultiTextureEXT = (PFNGLBINDMULTITEXTUREEXTPROC) loadFunction("glBindMultiTextureEXT");
    glBindParameterEXT = (PFNGLBINDPARAMETEREXTPROC) loadFunction("glBindParameterEXT");
    glBindProgramARB = (PFNGLBINDPROGRAMARBPROC) loadFunction("glBindProgramARB");
    glBindProgramNV = (PFNGLBINDPROGRAMNVPROC) loadFunction("glBindProgramNV");
    glBindProgramPipeline = (PFNGLBINDPROGRAMPIPELINEPROC) loadFunction("glBindProgramPipeline");
    glBindProgramPipelineEXT = (PFNGLBINDPROGRAMPIPELINEEXTPROC) loadFunction("glBindProgramPipelineEXT");
    glBindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC) loadFunction("glBindRenderbuffer");
    glBindRenderbufferEXT = (PFNGLBINDRENDERBUFFEREXTPROC) loadFunction("glBindRenderbufferEXT");
    glBindSampler = (PFNGLBINDSAMPLERPROC) loadFunction("glBindSampler");
    glBindSamplers = (PFNGLBINDSAMPLERSPROC) loadFunction("glBindSamplers");
    glBindShadingRateImageNV = (PFNGLBINDSHADINGRATEIMAGENVPROC) loadFunction("glBindShadingRateImageNV");
    glBindTexGenParameterEXT = (PFNGLBINDTEXGENPARAMETEREXTPROC) loadFunction("glBindTexGenParameterEXT");
    glBindTexture = (PFNGLBINDTEXTUREPROC) loadFunction("glBindTexture");
    glBindTextureEXT = (PFNGLBINDTEXTUREEXTPROC) loadFunction("glBindTextureEXT");
    glBindTextureUnit = (PFNGLBINDTEXTUREUNITPROC) loadFunction("glBindTextureUnit");
    glBindTextureUnitParameterEXT = (PFNGLBINDTEXTUREUNITPARAMETEREXTPROC) loadFunction("glBindTextureUnitParameterEXT");
    glBindTextures = (PFNGLBINDTEXTURESPROC) loadFunction("glBindTextures");
    glBindTransformFeedback = (PFNGLBINDTRANSFORMFEEDBACKPROC) loadFunction("glBindTransformFeedback");
    glBindTransformFeedbackNV = (PFNGLBINDTRANSFORMFEEDBACKNVPROC) loadFunction("glBindTransformFeedbackNV");
    glBindVertexArray = (PFNGLBINDVERTEXARRAYPROC) loadFunction("glBindVertexArray");
    glBindVertexArrayAPPLE = (PFNGLBINDVERTEXARRAYAPPLEPROC) loadFunction("glBindVertexArrayAPPLE");
    glBindVertexBuffer = (PFNGLBINDVERTEXBUFFERPROC) loadFunction("glBindVertexBuffer");
    glBindVertexBuffers = (PFNGLBINDVERTEXBUFFERSPROC) loadFunction("glBindVertexBuffers");
    glBindVertexShaderEXT = (PFNGLBINDVERTEXSHADEREXTPROC) loadFunction("glBindVertexShaderEXT");
    glBindVideoCaptureStreamBufferNV = (PFNGLBINDVIDEOCAPTURESTREAMBUFFERNVPROC) loadFunction("glBindVideoCaptureStreamBufferNV");
    glBindVideoCaptureStreamTextureNV = (PFNGLBINDVIDEOCAPTURESTREAMTEXTURENVPROC) loadFunction("glBindVideoCaptureStreamTextureNV");
    glBinormal3bEXT = (PFNGLBINORMAL3BEXTPROC) loadFunction("glBinormal3bEXT");
    glBinormal3bvEXT = (PFNGLBINORMAL3BVEXTPROC) loadFunction("glBinormal3bvEXT");
    glBinormal3dEXT = (PFNGLBINORMAL3DEXTPROC) loadFunction("glBinormal3dEXT");
    glBinormal3dvEXT = (PFNGLBINORMAL3DVEXTPROC) loadFunction("glBinormal3dvEXT");
    glBinormal3fEXT = (PFNGLBINORMAL3FEXTPROC) loadFunction("glBinormal3fEXT");
    glBinormal3fvEXT = (PFNGLBINORMAL3FVEXTPROC) loadFunction("glBinormal3fvEXT");
    glBinormal3iEXT = (PFNGLBINORMAL3IEXTPROC) loadFunction("glBinormal3iEXT");
    glBinormal3ivEXT = (PFNGLBINORMAL3IVEXTPROC) loadFunction("glBinormal3ivEXT");
    glBinormal3sEXT = (PFNGLBINORMAL3SEXTPROC) loadFunction("glBinormal3sEXT");
    glBinormal3svEXT = (PFNGLBINORMAL3SVEXTPROC) loadFunction("glBinormal3svEXT");
    glBinormalPointerEXT = (PFNGLBINORMALPOINTEREXTPROC) loadFunction("glBinormalPointerEXT");
    glBitmap = (PFNGLBITMAPPROC) loadFunction("glBitmap");
    glBlendBarrierKHR = (PFNGLBLENDBARRIERKHRPROC) loadFunction("glBlendBarrierKHR");
    glBlendBarrierNV = (PFNGLBLENDBARRIERNVPROC) loadFunction("glBlendBarrierNV");
    glBlendColor = (PFNGLBLENDCOLORPROC) loadFunction("glBlendColor");
    glBlendColorEXT = (PFNGLBLENDCOLOREXTPROC) loadFunction("glBlendColorEXT");
    glBlendEquation = (PFNGLBLENDEQUATIONPROC) loadFunction("glBlendEquation");
    glBlendEquationEXT = (PFNGLBLENDEQUATIONEXTPROC) loadFunction("glBlendEquationEXT");
    glBlendEquationIndexedAMD = (PFNGLBLENDEQUATIONINDEXEDAMDPROC) loadFunction("glBlendEquationIndexedAMD");
    glBlendEquationSeparate = (PFNGLBLENDEQUATIONSEPARATEPROC) loadFunction("glBlendEquationSeparate");
    glBlendEquationSeparateEXT = (PFNGLBLENDEQUATIONSEPARATEEXTPROC) loadFunction("glBlendEquationSeparateEXT");
    glBlendEquationSeparateIndexedAMD = (PFNGLBLENDEQUATIONSEPARATEINDEXEDAMDPROC) loadFunction("glBlendEquationSeparateIndexedAMD");
    glBlendEquationSeparatei = (PFNGLBLENDEQUATIONSEPARATEIPROC) loadFunction("glBlendEquationSeparatei");
    glBlendEquationSeparateiARB = (PFNGLBLENDEQUATIONSEPARATEIARBPROC) loadFunction("glBlendEquationSeparateiARB");
    glBlendEquationi = (PFNGLBLENDEQUATIONIPROC) loadFunction("glBlendEquationi");
    glBlendEquationiARB = (PFNGLBLENDEQUATIONIARBPROC) loadFunction("glBlendEquationiARB");
    glBlendFunc = (PFNGLBLENDFUNCPROC) loadFunction("glBlendFunc");
    glBlendFuncIndexedAMD = (PFNGLBLENDFUNCINDEXEDAMDPROC) loadFunction("glBlendFuncIndexedAMD");
    glBlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC) loadFunction("glBlendFuncSeparate");
    glBlendFuncSeparateEXT = (PFNGLBLENDFUNCSEPARATEEXTPROC) loadFunction("glBlendFuncSeparateEXT");
    glBlendFuncSeparateIndexedAMD = (PFNGLBLENDFUNCSEPARATEINDEXEDAMDPROC) loadFunction("glBlendFuncSeparateIndexedAMD");
    glBlendFuncSeparatei = (PFNGLBLENDFUNCSEPARATEIPROC) loadFunction("glBlendFuncSeparatei");
    glBlendFuncSeparateiARB = (PFNGLBLENDFUNCSEPARATEIARBPROC) loadFunction("glBlendFuncSeparateiARB");
    glBlendFunci = (PFNGLBLENDFUNCIPROC) loadFunction("glBlendFunci");
    glBlendFunciARB = (PFNGLBLENDFUNCIARBPROC) loadFunction("glBlendFunciARB");
    glBlendParameteriNV = (PFNGLBLENDPARAMETERINVPROC) loadFunction("glBlendParameteriNV");
    glBlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC) loadFunction("glBlitFramebuffer");
    glBlitFramebufferEXT = (PFNGLBLITFRAMEBUFFEREXTPROC) loadFunction("glBlitFramebufferEXT");
    glBlitNamedFramebuffer = (PFNGLBLITNAMEDFRAMEBUFFERPROC) loadFunction("glBlitNamedFramebuffer");
    glBufferAddressRangeNV = (PFNGLBUFFERADDRESSRANGENVPROC) loadFunction("glBufferAddressRangeNV");
    glBufferAttachMemoryNV = (PFNGLBUFFERATTACHMEMORYNVPROC) loadFunction("glBufferAttachMemoryNV");
    glBufferData = (PFNGLBUFFERDATAPROC) loadFunction("glBufferData");
    glBufferDataARB = (PFNGLBUFFERDATAARBPROC) loadFunction("glBufferDataARB");
    glBufferPageCommitmentARB = (PFNGLBUFFERPAGECOMMITMENTARBPROC) loadFunction("glBufferPageCommitmentARB");
    glBufferParameteriAPPLE = (PFNGLBUFFERPARAMETERIAPPLEPROC) loadFunction("glBufferParameteriAPPLE");
    glBufferStorage = (PFNGLBUFFERSTORAGEPROC) loadFunction("glBufferStorage");
    glBufferStorageExternalEXT = (PFNGLBUFFERSTORAGEEXTERNALEXTPROC) loadFunction("glBufferStorageExternalEXT");
    glBufferStorageMemEXT = (PFNGLBUFFERSTORAGEMEMEXTPROC) loadFunction("glBufferStorageMemEXT");
    glBufferSubData = (PFNGLBUFFERSUBDATAPROC) loadFunction("glBufferSubData");
    glBufferSubDataARB = (PFNGLBUFFERSUBDATAARBPROC) loadFunction("glBufferSubDataARB");
    glCallCommandListNV = (PFNGLCALLCOMMANDLISTNVPROC) loadFunction("glCallCommandListNV");
    glCallList = (PFNGLCALLLISTPROC) loadFunction("glCallList");
    glCallLists = (PFNGLCALLLISTSPROC) loadFunction("glCallLists");
    glCheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC) loadFunction("glCheckFramebufferStatus");
    glCheckFramebufferStatusEXT = (PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC) loadFunction("glCheckFramebufferStatusEXT");
    glCheckNamedFramebufferStatus = (PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC) loadFunction("glCheckNamedFramebufferStatus");
    glCheckNamedFramebufferStatusEXT = (PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC) loadFunction("glCheckNamedFramebufferStatusEXT");
    glClampColor = (PFNGLCLAMPCOLORPROC) loadFunction("glClampColor");
    glClampColorARB = (PFNGLCLAMPCOLORARBPROC) loadFunction("glClampColorARB");
    glClear = (PFNGLCLEARPROC) loadFunction("glClear");
    glClearAccum = (PFNGLCLEARACCUMPROC) loadFunction("glClearAccum");
    glClearBufferData = (PFNGLCLEARBUFFERDATAPROC) loadFunction("glClearBufferData");
    glClearBufferSubData = (PFNGLCLEARBUFFERSUBDATAPROC) loadFunction("glClearBufferSubData");
    glClearBufferfi = (PFNGLCLEARBUFFERFIPROC) loadFunction("glClearBufferfi");
    glClearBufferfv = (PFNGLCLEARBUFFERFVPROC) loadFunction("glClearBufferfv");
    glClearBufferiv = (PFNGLCLEARBUFFERIVPROC) loadFunction("glClearBufferiv");
    glClearBufferuiv = (PFNGLCLEARBUFFERUIVPROC) loadFunction("glClearBufferuiv");
    glClearColor = (PFNGLCLEARCOLORPROC) loadFunction("glClearColor");
    glClearColorIiEXT = (PFNGLCLEARCOLORIIEXTPROC) loadFunction("glClearColorIiEXT");
    glClearColorIuiEXT = (PFNGLCLEARCOLORIUIEXTPROC) loadFunction("glClearColorIuiEXT");
    glClearDepth = (PFNGLCLEARDEPTHPROC) loadFunction("glClearDepth");
    glClearDepthdNV = (PFNGLCLEARDEPTHDNVPROC) loadFunction("glClearDepthdNV");
    glClearDepthf = (PFNGLCLEARDEPTHFPROC) loadFunction("glClearDepthf");
    glClearIndex = (PFNGLCLEARINDEXPROC) loadFunction("glClearIndex");
    glClearNamedBufferData = (PFNGLCLEARNAMEDBUFFERDATAPROC) loadFunction("glClearNamedBufferData");
    glClearNamedBufferDataEXT = (PFNGLCLEARNAMEDBUFFERDATAEXTPROC) loadFunction("glClearNamedBufferDataEXT");
    glClearNamedBufferSubData = (PFNGLCLEARNAMEDBUFFERSUBDATAPROC) loadFunction("glClearNamedBufferSubData");
    glClearNamedBufferSubDataEXT = (PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC) loadFunction("glClearNamedBufferSubDataEXT");
    glClearNamedFramebufferfi = (PFNGLCLEARNAMEDFRAMEBUFFERFIPROC) loadFunction("glClearNamedFramebufferfi");
    glClearNamedFramebufferfv = (PFNGLCLEARNAMEDFRAMEBUFFERFVPROC) loadFunction("glClearNamedFramebufferfv");
    glClearNamedFramebufferiv = (PFNGLCLEARNAMEDFRAMEBUFFERIVPROC) loadFunction("glClearNamedFramebufferiv");
    glClearNamedFramebufferuiv = (PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC) loadFunction("glClearNamedFramebufferuiv");
    glClearStencil = (PFNGLCLEARSTENCILPROC) loadFunction("glClearStencil");
    glClearTexImage = (PFNGLCLEARTEXIMAGEPROC) loadFunction("glClearTexImage");
    glClearTexSubImage = (PFNGLCLEARTEXSUBIMAGEPROC) loadFunction("glClearTexSubImage");
    glClientActiveTexture = (PFNGLCLIENTACTIVETEXTUREPROC) loadFunction("glClientActiveTexture");
    glClientActiveTextureARB = (PFNGLCLIENTACTIVETEXTUREARBPROC) loadFunction("glClientActiveTextureARB");
    glClientAttribDefaultEXT = (PFNGLCLIENTATTRIBDEFAULTEXTPROC) loadFunction("glClientAttribDefaultEXT");
    glClientWaitSync = (PFNGLCLIENTWAITSYNCPROC) loadFunction("glClientWaitSync");
    glClipControl = (PFNGLCLIPCONTROLPROC) loadFunction("glClipControl");
    glClipPlane = (PFNGLCLIPPLANEPROC) loadFunction("glClipPlane");
    glColor3b = (PFNGLCOLOR3BPROC) loadFunction("glColor3b");
    glColor3bv = (PFNGLCOLOR3BVPROC) loadFunction("glColor3bv");
    glColor3d = (PFNGLCOLOR3DPROC) loadFunction("glColor3d");
    glColor3dv = (PFNGLCOLOR3DVPROC) loadFunction("glColor3dv");
    glColor3f = (PFNGLCOLOR3FPROC) loadFunction("glColor3f");
    glColor3fv = (PFNGLCOLOR3FVPROC) loadFunction("glColor3fv");
    glColor3hNV = (PFNGLCOLOR3HNVPROC) loadFunction("glColor3hNV");
    glColor3hvNV = (PFNGLCOLOR3HVNVPROC) loadFunction("glColor3hvNV");
    glColor3i = (PFNGLCOLOR3IPROC) loadFunction("glColor3i");
    glColor3iv = (PFNGLCOLOR3IVPROC) loadFunction("glColor3iv");
    glColor3s = (PFNGLCOLOR3SPROC) loadFunction("glColor3s");
    glColor3sv = (PFNGLCOLOR3SVPROC) loadFunction("glColor3sv");
    glColor3ub = (PFNGLCOLOR3UBPROC) loadFunction("glColor3ub");
    glColor3ubv = (PFNGLCOLOR3UBVPROC) loadFunction("glColor3ubv");
    glColor3ui = (PFNGLCOLOR3UIPROC) loadFunction("glColor3ui");
    glColor3uiv = (PFNGLCOLOR3UIVPROC) loadFunction("glColor3uiv");
    glColor3us = (PFNGLCOLOR3USPROC) loadFunction("glColor3us");
    glColor3usv = (PFNGLCOLOR3USVPROC) loadFunction("glColor3usv");
    glColor4b = (PFNGLCOLOR4BPROC) loadFunction("glColor4b");
    glColor4bv = (PFNGLCOLOR4BVPROC) loadFunction("glColor4bv");
    glColor4d = (PFNGLCOLOR4DPROC) loadFunction("glColor4d");
    glColor4dv = (PFNGLCOLOR4DVPROC) loadFunction("glColor4dv");
    glColor4f = (PFNGLCOLOR4FPROC) loadFunction("glColor4f");
    glColor4fv = (PFNGLCOLOR4FVPROC) loadFunction("glColor4fv");
    glColor4hNV = (PFNGLCOLOR4HNVPROC) loadFunction("glColor4hNV");
    glColor4hvNV = (PFNGLCOLOR4HVNVPROC) loadFunction("glColor4hvNV");
    glColor4i = (PFNGLCOLOR4IPROC) loadFunction("glColor4i");
    glColor4iv = (PFNGLCOLOR4IVPROC) loadFunction("glColor4iv");
    glColor4s = (PFNGLCOLOR4SPROC) loadFunction("glColor4s");
    glColor4sv = (PFNGLCOLOR4SVPROC) loadFunction("glColor4sv");
    glColor4ub = (PFNGLCOLOR4UBPROC) loadFunction("glColor4ub");
    glColor4ubv = (PFNGLCOLOR4UBVPROC) loadFunction("glColor4ubv");
    glColor4ui = (PFNGLCOLOR4UIPROC) loadFunction("glColor4ui");
    glColor4uiv = (PFNGLCOLOR4UIVPROC) loadFunction("glColor4uiv");
    glColor4us = (PFNGLCOLOR4USPROC) loadFunction("glColor4us");
    glColor4usv = (PFNGLCOLOR4USVPROC) loadFunction("glColor4usv");
    glColorFormatNV = (PFNGLCOLORFORMATNVPROC) loadFunction("glColorFormatNV");
    glColorMask = (PFNGLCOLORMASKPROC) loadFunction("glColorMask");
    glColorMaskIndexedEXT = (PFNGLCOLORMASKINDEXEDEXTPROC) loadFunction("glColorMaskIndexedEXT");
    glColorMaski = (PFNGLCOLORMASKIPROC) loadFunction("glColorMaski");
    glColorMaterial = (PFNGLCOLORMATERIALPROC) loadFunction("glColorMaterial");
    glColorP3ui = (PFNGLCOLORP3UIPROC) loadFunction("glColorP3ui");
    glColorP3uiv = (PFNGLCOLORP3UIVPROC) loadFunction("glColorP3uiv");
    glColorP4ui = (PFNGLCOLORP4UIPROC) loadFunction("glColorP4ui");
    glColorP4uiv = (PFNGLCOLORP4UIVPROC) loadFunction("glColorP4uiv");
    glColorPointer = (PFNGLCOLORPOINTERPROC) loadFunction("glColorPointer");
    glColorPointerEXT = (PFNGLCOLORPOINTEREXTPROC) loadFunction("glColorPointerEXT");
    glColorPointervINTEL = (PFNGLCOLORPOINTERVINTELPROC) loadFunction("glColorPointervINTEL");
    glColorSubTable = (PFNGLCOLORSUBTABLEPROC) loadFunction("glColorSubTable");
    glColorSubTableEXT = (PFNGLCOLORSUBTABLEEXTPROC) loadFunction("glColorSubTableEXT");
    glColorTable = (PFNGLCOLORTABLEPROC) loadFunction("glColorTable");
    glColorTableEXT = (PFNGLCOLORTABLEEXTPROC) loadFunction("glColorTableEXT");
    glColorTableParameterfv = (PFNGLCOLORTABLEPARAMETERFVPROC) loadFunction("glColorTableParameterfv");
    glColorTableParameteriv = (PFNGLCOLORTABLEPARAMETERIVPROC) loadFunction("glColorTableParameteriv");
    glCombinerInputNV = (PFNGLCOMBINERINPUTNVPROC) loadFunction("glCombinerInputNV");
    glCombinerOutputNV = (PFNGLCOMBINEROUTPUTNVPROC) loadFunction("glCombinerOutputNV");
    glCombinerParameterfNV = (PFNGLCOMBINERPARAMETERFNVPROC) loadFunction("glCombinerParameterfNV");
    glCombinerParameterfvNV = (PFNGLCOMBINERPARAMETERFVNVPROC) loadFunction("glCombinerParameterfvNV");
    glCombinerParameteriNV = (PFNGLCOMBINERPARAMETERINVPROC) loadFunction("glCombinerParameteriNV");
    glCombinerParameterivNV = (PFNGLCOMBINERPARAMETERIVNVPROC) loadFunction("glCombinerParameterivNV");
    glCombinerStageParameterfvNV = (PFNGLCOMBINERSTAGEPARAMETERFVNVPROC) loadFunction("glCombinerStageParameterfvNV");
    glCommandListSegmentsNV = (PFNGLCOMMANDLISTSEGMENTSNVPROC) loadFunction("glCommandListSegmentsNV");
    glCompileCommandListNV = (PFNGLCOMPILECOMMANDLISTNVPROC) loadFunction("glCompileCommandListNV");
    glCompileShader = (PFNGLCOMPILESHADERPROC) loadFunction("glCompileShader");
    glCompileShaderARB = (PFNGLCOMPILESHADERARBPROC) loadFunction("glCompileShaderARB");
    glCompileShaderIncludeARB = (PFNGLCOMPILESHADERINCLUDEARBPROC) loadFunction("glCompileShaderIncludeARB");
    glCompressedMultiTexImage1DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC) loadFunction("glCompressedMultiTexImage1DEXT");
    glCompressedMultiTexImage2DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC) loadFunction("glCompressedMultiTexImage2DEXT");
    glCompressedMultiTexImage3DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC) loadFunction("glCompressedMultiTexImage3DEXT");
    glCompressedMultiTexSubImage1DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC) loadFunction("glCompressedMultiTexSubImage1DEXT");
    glCompressedMultiTexSubImage2DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC) loadFunction("glCompressedMultiTexSubImage2DEXT");
    glCompressedMultiTexSubImage3DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC) loadFunction("glCompressedMultiTexSubImage3DEXT");
    glCompressedTexImage1D = (PFNGLCOMPRESSEDTEXIMAGE1DPROC) loadFunction("glCompressedTexImage1D");
    glCompressedTexImage1DARB = (PFNGLCOMPRESSEDTEXIMAGE1DARBPROC) loadFunction("glCompressedTexImage1DARB");
    glCompressedTexImage2D = (PFNGLCOMPRESSEDTEXIMAGE2DPROC) loadFunction("glCompressedTexImage2D");
    glCompressedTexImage2DARB = (PFNGLCOMPRESSEDTEXIMAGE2DARBPROC) loadFunction("glCompressedTexImage2DARB");
    glCompressedTexImage3D = (PFNGLCOMPRESSEDTEXIMAGE3DPROC) loadFunction("glCompressedTexImage3D");
    glCompressedTexImage3DARB = (PFNGLCOMPRESSEDTEXIMAGE3DARBPROC) loadFunction("glCompressedTexImage3DARB");
    glCompressedTexSubImage1D = (PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC) loadFunction("glCompressedTexSubImage1D");
    glCompressedTexSubImage1DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC) loadFunction("glCompressedTexSubImage1DARB");
    glCompressedTexSubImage2D = (PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC) loadFunction("glCompressedTexSubImage2D");
    glCompressedTexSubImage2DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC) loadFunction("glCompressedTexSubImage2DARB");
    glCompressedTexSubImage3D = (PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC) loadFunction("glCompressedTexSubImage3D");
    glCompressedTexSubImage3DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC) loadFunction("glCompressedTexSubImage3DARB");
    glCompressedTextureImage1DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC) loadFunction("glCompressedTextureImage1DEXT");
    glCompressedTextureImage2DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC) loadFunction("glCompressedTextureImage2DEXT");
    glCompressedTextureImage3DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC) loadFunction("glCompressedTextureImage3DEXT");
    glCompressedTextureSubImage1D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC) loadFunction("glCompressedTextureSubImage1D");
    glCompressedTextureSubImage1DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC) loadFunction("glCompressedTextureSubImage1DEXT");
    glCompressedTextureSubImage2D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC) loadFunction("glCompressedTextureSubImage2D");
    glCompressedTextureSubImage2DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC) loadFunction("glCompressedTextureSubImage2DEXT");
    glCompressedTextureSubImage3D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC) loadFunction("glCompressedTextureSubImage3D");
    glCompressedTextureSubImage3DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC) loadFunction("glCompressedTextureSubImage3DEXT");
    glConservativeRasterParameterfNV = (PFNGLCONSERVATIVERASTERPARAMETERFNVPROC) loadFunction("glConservativeRasterParameterfNV");
    glConservativeRasterParameteriNV = (PFNGLCONSERVATIVERASTERPARAMETERINVPROC) loadFunction("glConservativeRasterParameteriNV");
    glConvolutionFilter1D = (PFNGLCONVOLUTIONFILTER1DPROC) loadFunction("glConvolutionFilter1D");
    glConvolutionFilter1DEXT = (PFNGLCONVOLUTIONFILTER1DEXTPROC) loadFunction("glConvolutionFilter1DEXT");
    glConvolutionFilter2D = (PFNGLCONVOLUTIONFILTER2DPROC) loadFunction("glConvolutionFilter2D");
    glConvolutionFilter2DEXT = (PFNGLCONVOLUTIONFILTER2DEXTPROC) loadFunction("glConvolutionFilter2DEXT");
    glConvolutionParameterf = (PFNGLCONVOLUTIONPARAMETERFPROC) loadFunction("glConvolutionParameterf");
    glConvolutionParameterfEXT = (PFNGLCONVOLUTIONPARAMETERFEXTPROC) loadFunction("glConvolutionParameterfEXT");
    glConvolutionParameterfv = (PFNGLCONVOLUTIONPARAMETERFVPROC) loadFunction("glConvolutionParameterfv");
    glConvolutionParameterfvEXT = (PFNGLCONVOLUTIONPARAMETERFVEXTPROC) loadFunction("glConvolutionParameterfvEXT");
    glConvolutionParameteri = (PFNGLCONVOLUTIONPARAMETERIPROC) loadFunction("glConvolutionParameteri");
    glConvolutionParameteriEXT = (PFNGLCONVOLUTIONPARAMETERIEXTPROC) loadFunction("glConvolutionParameteriEXT");
    glConvolutionParameteriv = (PFNGLCONVOLUTIONPARAMETERIVPROC) loadFunction("glConvolutionParameteriv");
    glConvolutionParameterivEXT = (PFNGLCONVOLUTIONPARAMETERIVEXTPROC) loadFunction("glConvolutionParameterivEXT");
    glCopyBufferSubData = (PFNGLCOPYBUFFERSUBDATAPROC) loadFunction("glCopyBufferSubData");
    glCopyColorSubTable = (PFNGLCOPYCOLORSUBTABLEPROC) loadFunction("glCopyColorSubTable");
    glCopyColorSubTableEXT = (PFNGLCOPYCOLORSUBTABLEEXTPROC) loadFunction("glCopyColorSubTableEXT");
    glCopyColorTable = (PFNGLCOPYCOLORTABLEPROC) loadFunction("glCopyColorTable");
    glCopyConvolutionFilter1D = (PFNGLCOPYCONVOLUTIONFILTER1DPROC) loadFunction("glCopyConvolutionFilter1D");
    glCopyConvolutionFilter1DEXT = (PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC) loadFunction("glCopyConvolutionFilter1DEXT");
    glCopyConvolutionFilter2D = (PFNGLCOPYCONVOLUTIONFILTER2DPROC) loadFunction("glCopyConvolutionFilter2D");
    glCopyConvolutionFilter2DEXT = (PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC) loadFunction("glCopyConvolutionFilter2DEXT");
    glCopyImageSubData = (PFNGLCOPYIMAGESUBDATAPROC) loadFunction("glCopyImageSubData");
    glCopyImageSubDataNV = (PFNGLCOPYIMAGESUBDATANVPROC) loadFunction("glCopyImageSubDataNV");
    glCopyMultiTexImage1DEXT = (PFNGLCOPYMULTITEXIMAGE1DEXTPROC) loadFunction("glCopyMultiTexImage1DEXT");
    glCopyMultiTexImage2DEXT = (PFNGLCOPYMULTITEXIMAGE2DEXTPROC) loadFunction("glCopyMultiTexImage2DEXT");
    glCopyMultiTexSubImage1DEXT = (PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC) loadFunction("glCopyMultiTexSubImage1DEXT");
    glCopyMultiTexSubImage2DEXT = (PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC) loadFunction("glCopyMultiTexSubImage2DEXT");
    glCopyMultiTexSubImage3DEXT = (PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC) loadFunction("glCopyMultiTexSubImage3DEXT");
    glCopyNamedBufferSubData = (PFNGLCOPYNAMEDBUFFERSUBDATAPROC) loadFunction("glCopyNamedBufferSubData");
    glCopyPathNV = (PFNGLCOPYPATHNVPROC) loadFunction("glCopyPathNV");
    glCopyPixels = (PFNGLCOPYPIXELSPROC) loadFunction("glCopyPixels");
    glCopyTexImage1D = (PFNGLCOPYTEXIMAGE1DPROC) loadFunction("glCopyTexImage1D");
    glCopyTexImage1DEXT = (PFNGLCOPYTEXIMAGE1DEXTPROC) loadFunction("glCopyTexImage1DEXT");
    glCopyTexImage2D = (PFNGLCOPYTEXIMAGE2DPROC) loadFunction("glCopyTexImage2D");
    glCopyTexImage2DEXT = (PFNGLCOPYTEXIMAGE2DEXTPROC) loadFunction("glCopyTexImage2DEXT");
    glCopyTexSubImage1D = (PFNGLCOPYTEXSUBIMAGE1DPROC) loadFunction("glCopyTexSubImage1D");
    glCopyTexSubImage1DEXT = (PFNGLCOPYTEXSUBIMAGE1DEXTPROC) loadFunction("glCopyTexSubImage1DEXT");
    glCopyTexSubImage2D = (PFNGLCOPYTEXSUBIMAGE2DPROC) loadFunction("glCopyTexSubImage2D");
    glCopyTexSubImage2DEXT = (PFNGLCOPYTEXSUBIMAGE2DEXTPROC) loadFunction("glCopyTexSubImage2DEXT");
    glCopyTexSubImage3D = (PFNGLCOPYTEXSUBIMAGE3DPROC) loadFunction("glCopyTexSubImage3D");
    glCopyTexSubImage3DEXT = (PFNGLCOPYTEXSUBIMAGE3DEXTPROC) loadFunction("glCopyTexSubImage3DEXT");
    glCopyTextureImage1DEXT = (PFNGLCOPYTEXTUREIMAGE1DEXTPROC) loadFunction("glCopyTextureImage1DEXT");
    glCopyTextureImage2DEXT = (PFNGLCOPYTEXTUREIMAGE2DEXTPROC) loadFunction("glCopyTextureImage2DEXT");
    glCopyTextureSubImage1D = (PFNGLCOPYTEXTURESUBIMAGE1DPROC) loadFunction("glCopyTextureSubImage1D");
    glCopyTextureSubImage1DEXT = (PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC) loadFunction("glCopyTextureSubImage1DEXT");
    glCopyTextureSubImage2D = (PFNGLCOPYTEXTURESUBIMAGE2DPROC) loadFunction("glCopyTextureSubImage2D");
    glCopyTextureSubImage2DEXT = (PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC) loadFunction("glCopyTextureSubImage2DEXT");
    glCopyTextureSubImage3D = (PFNGLCOPYTEXTURESUBIMAGE3DPROC) loadFunction("glCopyTextureSubImage3D");
    glCopyTextureSubImage3DEXT = (PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC) loadFunction("glCopyTextureSubImage3DEXT");
    glCoverFillPathInstancedNV = (PFNGLCOVERFILLPATHINSTANCEDNVPROC) loadFunction("glCoverFillPathInstancedNV");
    glCoverFillPathNV = (PFNGLCOVERFILLPATHNVPROC) loadFunction("glCoverFillPathNV");
    glCoverStrokePathInstancedNV = (PFNGLCOVERSTROKEPATHINSTANCEDNVPROC) loadFunction("glCoverStrokePathInstancedNV");
    glCoverStrokePathNV = (PFNGLCOVERSTROKEPATHNVPROC) loadFunction("glCoverStrokePathNV");
    glCoverageModulationNV = (PFNGLCOVERAGEMODULATIONNVPROC) loadFunction("glCoverageModulationNV");
    glCoverageModulationTableNV = (PFNGLCOVERAGEMODULATIONTABLENVPROC) loadFunction("glCoverageModulationTableNV");
    glCreateBuffers = (PFNGLCREATEBUFFERSPROC) loadFunction("glCreateBuffers");
    glCreateCommandListsNV = (PFNGLCREATECOMMANDLISTSNVPROC) loadFunction("glCreateCommandListsNV");
    glCreateFramebuffers = (PFNGLCREATEFRAMEBUFFERSPROC) loadFunction("glCreateFramebuffers");
    glCreateMemoryObjectsEXT = (PFNGLCREATEMEMORYOBJECTSEXTPROC) loadFunction("glCreateMemoryObjectsEXT");
    glCreatePerfQueryINTEL = (PFNGLCREATEPERFQUERYINTELPROC) loadFunction("glCreatePerfQueryINTEL");
    glCreateProgram = (PFNGLCREATEPROGRAMPROC) loadFunction("glCreateProgram");
    glCreateProgramObjectARB = (PFNGLCREATEPROGRAMOBJECTARBPROC) loadFunction("glCreateProgramObjectARB");
    glCreateProgramPipelines = (PFNGLCREATEPROGRAMPIPELINESPROC) loadFunction("glCreateProgramPipelines");
    glCreateQueries = (PFNGLCREATEQUERIESPROC) loadFunction("glCreateQueries");
    glCreateRenderbuffers = (PFNGLCREATERENDERBUFFERSPROC) loadFunction("glCreateRenderbuffers");
    glCreateSamplers = (PFNGLCREATESAMPLERSPROC) loadFunction("glCreateSamplers");
    glCreateShader = (PFNGLCREATESHADERPROC) loadFunction("glCreateShader");
    glCreateShaderObjectARB = (PFNGLCREATESHADEROBJECTARBPROC) loadFunction("glCreateShaderObjectARB");
    glCreateShaderProgramEXT = (PFNGLCREATESHADERPROGRAMEXTPROC) loadFunction("glCreateShaderProgramEXT");
    glCreateShaderProgramv = (PFNGLCREATESHADERPROGRAMVPROC) loadFunction("glCreateShaderProgramv");
    glCreateShaderProgramvEXT = (PFNGLCREATESHADERPROGRAMVEXTPROC) loadFunction("glCreateShaderProgramvEXT");
    glCreateStatesNV = (PFNGLCREATESTATESNVPROC) loadFunction("glCreateStatesNV");
    glCreateSyncFromCLeventARB = (PFNGLCREATESYNCFROMCLEVENTARBPROC) loadFunction("glCreateSyncFromCLeventARB");
    glCreateTextures = (PFNGLCREATETEXTURESPROC) loadFunction("glCreateTextures");
    glCreateTransformFeedbacks = (PFNGLCREATETRANSFORMFEEDBACKSPROC) loadFunction("glCreateTransformFeedbacks");
    glCreateVertexArrays = (PFNGLCREATEVERTEXARRAYSPROC) loadFunction("glCreateVertexArrays");
    glCullFace = (PFNGLCULLFACEPROC) loadFunction("glCullFace");
    glCullParameterdvEXT = (PFNGLCULLPARAMETERDVEXTPROC) loadFunction("glCullParameterdvEXT");
    glCullParameterfvEXT = (PFNGLCULLPARAMETERFVEXTPROC) loadFunction("glCullParameterfvEXT");
    glCurrentPaletteMatrixARB = (PFNGLCURRENTPALETTEMATRIXARBPROC) loadFunction("glCurrentPaletteMatrixARB");
    glDebugMessageCallback = (PFNGLDEBUGMESSAGECALLBACKPROC) loadFunction("glDebugMessageCallback");
    glDebugMessageCallbackAMD = (PFNGLDEBUGMESSAGECALLBACKAMDPROC) loadFunction("glDebugMessageCallbackAMD");
    glDebugMessageCallbackARB = (PFNGLDEBUGMESSAGECALLBACKARBPROC) loadFunction("glDebugMessageCallbackARB");
    glDebugMessageCallbackKHR = (PFNGLDEBUGMESSAGECALLBACKKHRPROC) loadFunction("glDebugMessageCallbackKHR");
    glDebugMessageControl = (PFNGLDEBUGMESSAGECONTROLPROC) loadFunction("glDebugMessageControl");
    glDebugMessageControlARB = (PFNGLDEBUGMESSAGECONTROLARBPROC) loadFunction("glDebugMessageControlARB");
    glDebugMessageControlKHR = (PFNGLDEBUGMESSAGECONTROLKHRPROC) loadFunction("glDebugMessageControlKHR");
    glDebugMessageEnableAMD = (PFNGLDEBUGMESSAGEENABLEAMDPROC) loadFunction("glDebugMessageEnableAMD");
    glDebugMessageInsert = (PFNGLDEBUGMESSAGEINSERTPROC) loadFunction("glDebugMessageInsert");
    glDebugMessageInsertAMD = (PFNGLDEBUGMESSAGEINSERTAMDPROC) loadFunction("glDebugMessageInsertAMD");
    glDebugMessageInsertARB = (PFNGLDEBUGMESSAGEINSERTARBPROC) loadFunction("glDebugMessageInsertARB");
    glDebugMessageInsertKHR = (PFNGLDEBUGMESSAGEINSERTKHRPROC) loadFunction("glDebugMessageInsertKHR");
    glDeleteBuffers = (PFNGLDELETEBUFFERSPROC) loadFunction("glDeleteBuffers");
    glDeleteBuffersARB = (PFNGLDELETEBUFFERSARBPROC) loadFunction("glDeleteBuffersARB");
    glDeleteCommandListsNV = (PFNGLDELETECOMMANDLISTSNVPROC) loadFunction("glDeleteCommandListsNV");
    glDeleteFencesAPPLE = (PFNGLDELETEFENCESAPPLEPROC) loadFunction("glDeleteFencesAPPLE");
    glDeleteFencesNV = (PFNGLDELETEFENCESNVPROC) loadFunction("glDeleteFencesNV");
    glDeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC) loadFunction("glDeleteFramebuffers");
    glDeleteFramebuffersEXT = (PFNGLDELETEFRAMEBUFFERSEXTPROC) loadFunction("glDeleteFramebuffersEXT");
    glDeleteLists = (PFNGLDELETELISTSPROC) loadFunction("glDeleteLists");
    glDeleteMemoryObjectsEXT = (PFNGLDELETEMEMORYOBJECTSEXTPROC) loadFunction("glDeleteMemoryObjectsEXT");
    glDeleteNamedStringARB = (PFNGLDELETENAMEDSTRINGARBPROC) loadFunction("glDeleteNamedStringARB");
    glDeleteNamesAMD = (PFNGLDELETENAMESAMDPROC) loadFunction("glDeleteNamesAMD");
    glDeleteObjectARB = (PFNGLDELETEOBJECTARBPROC) loadFunction("glDeleteObjectARB");
    glDeleteOcclusionQueriesNV = (PFNGLDELETEOCCLUSIONQUERIESNVPROC) loadFunction("glDeleteOcclusionQueriesNV");
    glDeletePathsNV = (PFNGLDELETEPATHSNVPROC) loadFunction("glDeletePathsNV");
    glDeletePerfMonitorsAMD = (PFNGLDELETEPERFMONITORSAMDPROC) loadFunction("glDeletePerfMonitorsAMD");
    glDeletePerfQueryINTEL = (PFNGLDELETEPERFQUERYINTELPROC) loadFunction("glDeletePerfQueryINTEL");
    glDeleteProgram = (PFNGLDELETEPROGRAMPROC) loadFunction("glDeleteProgram");
    glDeleteProgramPipelines = (PFNGLDELETEPROGRAMPIPELINESPROC) loadFunction("glDeleteProgramPipelines");
    glDeleteProgramPipelinesEXT = (PFNGLDELETEPROGRAMPIPELINESEXTPROC) loadFunction("glDeleteProgramPipelinesEXT");
    glDeleteProgramsARB = (PFNGLDELETEPROGRAMSARBPROC) loadFunction("glDeleteProgramsARB");
    glDeleteProgramsNV = (PFNGLDELETEPROGRAMSNVPROC) loadFunction("glDeleteProgramsNV");
    glDeleteQueries = (PFNGLDELETEQUERIESPROC) loadFunction("glDeleteQueries");
    glDeleteQueriesARB = (PFNGLDELETEQUERIESARBPROC) loadFunction("glDeleteQueriesARB");
    glDeleteQueryResourceTagNV = (PFNGLDELETEQUERYRESOURCETAGNVPROC) loadFunction("glDeleteQueryResourceTagNV");
    glDeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC) loadFunction("glDeleteRenderbuffers");
    glDeleteRenderbuffersEXT = (PFNGLDELETERENDERBUFFERSEXTPROC) loadFunction("glDeleteRenderbuffersEXT");
    glDeleteSamplers = (PFNGLDELETESAMPLERSPROC) loadFunction("glDeleteSamplers");
    glDeleteSemaphoresEXT = (PFNGLDELETESEMAPHORESEXTPROC) loadFunction("glDeleteSemaphoresEXT");
    glDeleteShader = (PFNGLDELETESHADERPROC) loadFunction("glDeleteShader");
    glDeleteStatesNV = (PFNGLDELETESTATESNVPROC) loadFunction("glDeleteStatesNV");
    glDeleteSync = (PFNGLDELETESYNCPROC) loadFunction("glDeleteSync");
    glDeleteTextures = (PFNGLDELETETEXTURESPROC) loadFunction("glDeleteTextures");
    glDeleteTexturesEXT = (PFNGLDELETETEXTURESEXTPROC) loadFunction("glDeleteTexturesEXT");
    glDeleteTransformFeedbacks = (PFNGLDELETETRANSFORMFEEDBACKSPROC) loadFunction("glDeleteTransformFeedbacks");
    glDeleteTransformFeedbacksNV = (PFNGLDELETETRANSFORMFEEDBACKSNVPROC) loadFunction("glDeleteTransformFeedbacksNV");
    glDeleteVertexArrays = (PFNGLDELETEVERTEXARRAYSPROC) loadFunction("glDeleteVertexArrays");
    glDeleteVertexArraysAPPLE = (PFNGLDELETEVERTEXARRAYSAPPLEPROC) loadFunction("glDeleteVertexArraysAPPLE");
    glDeleteVertexShaderEXT = (PFNGLDELETEVERTEXSHADEREXTPROC) loadFunction("glDeleteVertexShaderEXT");
    glDepthBoundsEXT = (PFNGLDEPTHBOUNDSEXTPROC) loadFunction("glDepthBoundsEXT");
    glDepthBoundsdNV = (PFNGLDEPTHBOUNDSDNVPROC) loadFunction("glDepthBoundsdNV");
    glDepthFunc = (PFNGLDEPTHFUNCPROC) loadFunction("glDepthFunc");
    glDepthMask = (PFNGLDEPTHMASKPROC) loadFunction("glDepthMask");
    glDepthRange = (PFNGLDEPTHRANGEPROC) loadFunction("glDepthRange");
    glDepthRangeArraydvNV = (PFNGLDEPTHRANGEARRAYDVNVPROC) loadFunction("glDepthRangeArraydvNV");
    glDepthRangeArrayv = (PFNGLDEPTHRANGEARRAYVPROC) loadFunction("glDepthRangeArrayv");
    glDepthRangeIndexed = (PFNGLDEPTHRANGEINDEXEDPROC) loadFunction("glDepthRangeIndexed");
    glDepthRangeIndexeddNV = (PFNGLDEPTHRANGEINDEXEDDNVPROC) loadFunction("glDepthRangeIndexeddNV");
    glDepthRangedNV = (PFNGLDEPTHRANGEDNVPROC) loadFunction("glDepthRangedNV");
    glDepthRangef = (PFNGLDEPTHRANGEFPROC) loadFunction("glDepthRangef");
    glDetachObjectARB = (PFNGLDETACHOBJECTARBPROC) loadFunction("glDetachObjectARB");
    glDetachShader = (PFNGLDETACHSHADERPROC) loadFunction("glDetachShader");
    glDisable = (PFNGLDISABLEPROC) loadFunction("glDisable");
    glDisableClientState = (PFNGLDISABLECLIENTSTATEPROC) loadFunction("glDisableClientState");
    glDisableClientStateIndexedEXT = (PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC) loadFunction("glDisableClientStateIndexedEXT");
    glDisableClientStateiEXT = (PFNGLDISABLECLIENTSTATEIEXTPROC) loadFunction("glDisableClientStateiEXT");
    glDisableIndexedEXT = (PFNGLDISABLEINDEXEDEXTPROC) loadFunction("glDisableIndexedEXT");
    glDisableVariantClientStateEXT = (PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC) loadFunction("glDisableVariantClientStateEXT");
    glDisableVertexArrayAttrib = (PFNGLDISABLEVERTEXARRAYATTRIBPROC) loadFunction("glDisableVertexArrayAttrib");
    glDisableVertexArrayAttribEXT = (PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC) loadFunction("glDisableVertexArrayAttribEXT");
    glDisableVertexArrayEXT = (PFNGLDISABLEVERTEXARRAYEXTPROC) loadFunction("glDisableVertexArrayEXT");
    glDisableVertexAttribAPPLE = (PFNGLDISABLEVERTEXATTRIBAPPLEPROC) loadFunction("glDisableVertexAttribAPPLE");
    glDisableVertexAttribArray = (PFNGLDISABLEVERTEXATTRIBARRAYPROC) loadFunction("glDisableVertexAttribArray");
    glDisableVertexAttribArrayARB = (PFNGLDISABLEVERTEXATTRIBARRAYARBPROC) loadFunction("glDisableVertexAttribArrayARB");
    glDisablei = (PFNGLDISABLEIPROC) loadFunction("glDisablei");
    glDispatchCompute = (PFNGLDISPATCHCOMPUTEPROC) loadFunction("glDispatchCompute");
    glDispatchComputeGroupSizeARB = (PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC) loadFunction("glDispatchComputeGroupSizeARB");
    glDispatchComputeIndirect = (PFNGLDISPATCHCOMPUTEINDIRECTPROC) loadFunction("glDispatchComputeIndirect");
    glDrawArrays = (PFNGLDRAWARRAYSPROC) loadFunction("glDrawArrays");
    glDrawArraysEXT = (PFNGLDRAWARRAYSEXTPROC) loadFunction("glDrawArraysEXT");
    glDrawArraysIndirect = (PFNGLDRAWARRAYSINDIRECTPROC) loadFunction("glDrawArraysIndirect");
    glDrawArraysInstanced = (PFNGLDRAWARRAYSINSTANCEDPROC) loadFunction("glDrawArraysInstanced");
    glDrawArraysInstancedARB = (PFNGLDRAWARRAYSINSTANCEDARBPROC) loadFunction("glDrawArraysInstancedARB");
    glDrawArraysInstancedBaseInstance = (PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC) loadFunction("glDrawArraysInstancedBaseInstance");
    glDrawArraysInstancedEXT = (PFNGLDRAWARRAYSINSTANCEDEXTPROC) loadFunction("glDrawArraysInstancedEXT");
    glDrawBuffer = (PFNGLDRAWBUFFERPROC) loadFunction("glDrawBuffer");
    glDrawBuffers = (PFNGLDRAWBUFFERSPROC) loadFunction("glDrawBuffers");
    glDrawBuffersARB = (PFNGLDRAWBUFFERSARBPROC) loadFunction("glDrawBuffersARB");
    glDrawCommandsAddressNV = (PFNGLDRAWCOMMANDSADDRESSNVPROC) loadFunction("glDrawCommandsAddressNV");
    glDrawCommandsNV = (PFNGLDRAWCOMMANDSNVPROC) loadFunction("glDrawCommandsNV");
    glDrawCommandsStatesAddressNV = (PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC) loadFunction("glDrawCommandsStatesAddressNV");
    glDrawCommandsStatesNV = (PFNGLDRAWCOMMANDSSTATESNVPROC) loadFunction("glDrawCommandsStatesNV");
    glDrawElementArrayAPPLE = (PFNGLDRAWELEMENTARRAYAPPLEPROC) loadFunction("glDrawElementArrayAPPLE");
    glDrawElements = (PFNGLDRAWELEMENTSPROC) loadFunction("glDrawElements");
    glDrawElementsBaseVertex = (PFNGLDRAWELEMENTSBASEVERTEXPROC) loadFunction("glDrawElementsBaseVertex");
    glDrawElementsIndirect = (PFNGLDRAWELEMENTSINDIRECTPROC) loadFunction("glDrawElementsIndirect");
    glDrawElementsInstanced = (PFNGLDRAWELEMENTSINSTANCEDPROC) loadFunction("glDrawElementsInstanced");
    glDrawElementsInstancedARB = (PFNGLDRAWELEMENTSINSTANCEDARBPROC) loadFunction("glDrawElementsInstancedARB");
    glDrawElementsInstancedBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC) loadFunction("glDrawElementsInstancedBaseInstance");
    glDrawElementsInstancedBaseVertex = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC) loadFunction("glDrawElementsInstancedBaseVertex");
    glDrawElementsInstancedBaseVertexBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC) loadFunction("glDrawElementsInstancedBaseVertexBaseInstance");
    glDrawElementsInstancedEXT = (PFNGLDRAWELEMENTSINSTANCEDEXTPROC) loadFunction("glDrawElementsInstancedEXT");
    glDrawMeshTasksNV = (PFNGLDRAWMESHTASKSNVPROC) loadFunction("glDrawMeshTasksNV");
    glDrawMeshTasksIndirectNV = (PFNGLDRAWMESHTASKSINDIRECTNVPROC) loadFunction("glDrawMeshTasksIndirectNV");
    glDrawPixels = (PFNGLDRAWPIXELSPROC) loadFunction("glDrawPixels");
    glDrawRangeElementArrayAPPLE = (PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC) loadFunction("glDrawRangeElementArrayAPPLE");
    glDrawRangeElements = (PFNGLDRAWRANGEELEMENTSPROC) loadFunction("glDrawRangeElements");
    glDrawRangeElementsBaseVertex = (PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC) loadFunction("glDrawRangeElementsBaseVertex");
    glDrawRangeElementsEXT = (PFNGLDRAWRANGEELEMENTSEXTPROC) loadFunction("glDrawRangeElementsEXT");
    glDrawTextureNV = (PFNGLDRAWTEXTURENVPROC) loadFunction("glDrawTextureNV");
    glDrawTransformFeedback = (PFNGLDRAWTRANSFORMFEEDBACKPROC) loadFunction("glDrawTransformFeedback");
    glDrawTransformFeedbackInstanced = (PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC) loadFunction("glDrawTransformFeedbackInstanced");
    glDrawTransformFeedbackNV = (PFNGLDRAWTRANSFORMFEEDBACKNVPROC) loadFunction("glDrawTransformFeedbackNV");
    glDrawTransformFeedbackStream = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC) loadFunction("glDrawTransformFeedbackStream");
    glDrawTransformFeedbackStreamInstanced = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC) loadFunction("glDrawTransformFeedbackStreamInstanced");
    glEGLImageTargetTexStorageEXT = (PFNGLEGLIMAGETARGETTEXSTORAGEEXTPROC) loadFunction("glEGLImageTargetTexStorageEXT");
    glEGLImageTargetTextureStorageEXT = (PFNGLEGLIMAGETARGETTEXTURESTORAGEEXTPROC) loadFunction("glEGLImageTargetTextureStorageEXT");
    glEdgeFlag = (PFNGLEDGEFLAGPROC) loadFunction("glEdgeFlag");
    glEdgeFlagFormatNV = (PFNGLEDGEFLAGFORMATNVPROC) loadFunction("glEdgeFlagFormatNV");
    glEdgeFlagPointer = (PFNGLEDGEFLAGPOINTERPROC) loadFunction("glEdgeFlagPointer");
    glEdgeFlagPointerEXT = (PFNGLEDGEFLAGPOINTEREXTPROC) loadFunction("glEdgeFlagPointerEXT");
    glEdgeFlagv = (PFNGLEDGEFLAGVPROC) loadFunction("glEdgeFlagv");
    glElementPointerAPPLE = (PFNGLELEMENTPOINTERAPPLEPROC) loadFunction("glElementPointerAPPLE");
    glEnable = (PFNGLENABLEPROC) loadFunction("glEnable");
    glEnableClientState = (PFNGLENABLECLIENTSTATEPROC) loadFunction("glEnableClientState");
    glEnableClientStateIndexedEXT = (PFNGLENABLECLIENTSTATEINDEXEDEXTPROC) loadFunction("glEnableClientStateIndexedEXT");
    glEnableClientStateiEXT = (PFNGLENABLECLIENTSTATEIEXTPROC) loadFunction("glEnableClientStateiEXT");
    glEnableIndexedEXT = (PFNGLENABLEINDEXEDEXTPROC) loadFunction("glEnableIndexedEXT");
    glEnableVariantClientStateEXT = (PFNGLENABLEVARIANTCLIENTSTATEEXTPROC) loadFunction("glEnableVariantClientStateEXT");
    glEnableVertexArrayAttrib = (PFNGLENABLEVERTEXARRAYATTRIBPROC) loadFunction("glEnableVertexArrayAttrib");
    glEnableVertexArrayAttribEXT = (PFNGLENABLEVERTEXARRAYATTRIBEXTPROC) loadFunction("glEnableVertexArrayAttribEXT");
    glEnableVertexArrayEXT = (PFNGLENABLEVERTEXARRAYEXTPROC) loadFunction("glEnableVertexArrayEXT");
    glEnableVertexAttribAPPLE = (PFNGLENABLEVERTEXATTRIBAPPLEPROC) loadFunction("glEnableVertexAttribAPPLE");
    glEnableVertexAttribArray = (PFNGLENABLEVERTEXATTRIBARRAYPROC) loadFunction("glEnableVertexAttribArray");
    glEnableVertexAttribArrayARB = (PFNGLENABLEVERTEXATTRIBARRAYARBPROC) loadFunction("glEnableVertexAttribArrayARB");
    glEnablei = (PFNGLENABLEIPROC) loadFunction("glEnablei");
    glEnd = (PFNGLENDPROC) loadFunction("glEnd");
    glEndConditionalRender = (PFNGLENDCONDITIONALRENDERPROC) loadFunction("glEndConditionalRender");
    glEndConditionalRenderNV = (PFNGLENDCONDITIONALRENDERNVPROC) loadFunction("glEndConditionalRenderNV");
    glEndList = (PFNGLENDLISTPROC) loadFunction("glEndList");
    glEndOcclusionQueryNV = (PFNGLENDOCCLUSIONQUERYNVPROC) loadFunction("glEndOcclusionQueryNV");
    glEndPerfMonitorAMD = (PFNGLENDPERFMONITORAMDPROC) loadFunction("glEndPerfMonitorAMD");
    glEndPerfQueryINTEL = (PFNGLENDPERFQUERYINTELPROC) loadFunction("glEndPerfQueryINTEL");
    glEndQuery = (PFNGLENDQUERYPROC) loadFunction("glEndQuery");
    glEndQueryARB = (PFNGLENDQUERYARBPROC) loadFunction("glEndQueryARB");
    glEndQueryIndexed = (PFNGLENDQUERYINDEXEDPROC) loadFunction("glEndQueryIndexed");
    glEndTransformFeedback = (PFNGLENDTRANSFORMFEEDBACKPROC) loadFunction("glEndTransformFeedback");
    glEndTransformFeedbackEXT = (PFNGLENDTRANSFORMFEEDBACKEXTPROC) loadFunction("glEndTransformFeedbackEXT");
    glEndTransformFeedbackNV = (PFNGLENDTRANSFORMFEEDBACKNVPROC) loadFunction("glEndTransformFeedbackNV");
    glEndVertexShaderEXT = (PFNGLENDVERTEXSHADEREXTPROC) loadFunction("glEndVertexShaderEXT");
    glEndVideoCaptureNV = (PFNGLENDVIDEOCAPTURENVPROC) loadFunction("glEndVideoCaptureNV");
    glEvalCoord1d = (PFNGLEVALCOORD1DPROC) loadFunction("glEvalCoord1d");
    glEvalCoord1dv = (PFNGLEVALCOORD1DVPROC) loadFunction("glEvalCoord1dv");
    glEvalCoord1f = (PFNGLEVALCOORD1FPROC) loadFunction("glEvalCoord1f");
    glEvalCoord1fv = (PFNGLEVALCOORD1FVPROC) loadFunction("glEvalCoord1fv");
    glEvalCoord2d = (PFNGLEVALCOORD2DPROC) loadFunction("glEvalCoord2d");
    glEvalCoord2dv = (PFNGLEVALCOORD2DVPROC) loadFunction("glEvalCoord2dv");
    glEvalCoord2f = (PFNGLEVALCOORD2FPROC) loadFunction("glEvalCoord2f");
    glEvalCoord2fv = (PFNGLEVALCOORD2FVPROC) loadFunction("glEvalCoord2fv");
    glEvalMapsNV = (PFNGLEVALMAPSNVPROC) loadFunction("glEvalMapsNV");
    glEvalMesh1 = (PFNGLEVALMESH1PROC) loadFunction("glEvalMesh1");
    glEvalMesh2 = (PFNGLEVALMESH2PROC) loadFunction("glEvalMesh2");
    glEvalPoint1 = (PFNGLEVALPOINT1PROC) loadFunction("glEvalPoint1");
    glEvalPoint2 = (PFNGLEVALPOINT2PROC) loadFunction("glEvalPoint2");
    glEvaluateDepthValuesARB = (PFNGLEVALUATEDEPTHVALUESARBPROC) loadFunction("glEvaluateDepthValuesARB");
    glExecuteProgramNV = (PFNGLEXECUTEPROGRAMNVPROC) loadFunction("glExecuteProgramNV");
    glExtractComponentEXT = (PFNGLEXTRACTCOMPONENTEXTPROC) loadFunction("glExtractComponentEXT");
    glFeedbackBuffer = (PFNGLFEEDBACKBUFFERPROC) loadFunction("glFeedbackBuffer");
    glFenceSync = (PFNGLFENCESYNCPROC) loadFunction("glFenceSync");
    glFinalCombinerInputNV = (PFNGLFINALCOMBINERINPUTNVPROC) loadFunction("glFinalCombinerInputNV");
    glFinish = (PFNGLFINISHPROC) loadFunction("glFinish");
    glFinishFenceAPPLE = (PFNGLFINISHFENCEAPPLEPROC) loadFunction("glFinishFenceAPPLE");
    glFinishFenceNV = (PFNGLFINISHFENCENVPROC) loadFunction("glFinishFenceNV");
    glFinishObjectAPPLE = (PFNGLFINISHOBJECTAPPLEPROC) loadFunction("glFinishObjectAPPLE");
    glFlush = (PFNGLFLUSHPROC) loadFunction("glFlush");
    glFlushMappedBufferRange = (PFNGLFLUSHMAPPEDBUFFERRANGEPROC) loadFunction("glFlushMappedBufferRange");
    glFlushMappedBufferRangeAPPLE = (PFNGLFLUSHMAPPEDBUFFERRANGEAPPLEPROC) loadFunction("glFlushMappedBufferRangeAPPLE");
    glFlushMappedNamedBufferRange = (PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC) loadFunction("glFlushMappedNamedBufferRange");
    glFlushMappedNamedBufferRangeEXT = (PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC) loadFunction("glFlushMappedNamedBufferRangeEXT");
    glFlushPixelDataRangeNV = (PFNGLFLUSHPIXELDATARANGENVPROC) loadFunction("glFlushPixelDataRangeNV");
    glFlushVertexArrayRangeAPPLE = (PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC) loadFunction("glFlushVertexArrayRangeAPPLE");
    glFlushVertexArrayRangeNV = (PFNGLFLUSHVERTEXARRAYRANGENVPROC) loadFunction("glFlushVertexArrayRangeNV");
    glFogCoordFormatNV = (PFNGLFOGCOORDFORMATNVPROC) loadFunction("glFogCoordFormatNV");
    glFogCoordPointer = (PFNGLFOGCOORDPOINTERPROC) loadFunction("glFogCoordPointer");
    glFogCoordPointerEXT = (PFNGLFOGCOORDPOINTEREXTPROC) loadFunction("glFogCoordPointerEXT");
    glFogCoordd = (PFNGLFOGCOORDDPROC) loadFunction("glFogCoordd");
    glFogCoorddEXT = (PFNGLFOGCOORDDEXTPROC) loadFunction("glFogCoorddEXT");
    glFogCoorddv = (PFNGLFOGCOORDDVPROC) loadFunction("glFogCoorddv");
    glFogCoorddvEXT = (PFNGLFOGCOORDDVEXTPROC) loadFunction("glFogCoorddvEXT");
    glFogCoordf = (PFNGLFOGCOORDFPROC) loadFunction("glFogCoordf");
    glFogCoordfEXT = (PFNGLFOGCOORDFEXTPROC) loadFunction("glFogCoordfEXT");
    glFogCoordfv = (PFNGLFOGCOORDFVPROC) loadFunction("glFogCoordfv");
    glFogCoordfvEXT = (PFNGLFOGCOORDFVEXTPROC) loadFunction("glFogCoordfvEXT");
    glFogCoordhNV = (PFNGLFOGCOORDHNVPROC) loadFunction("glFogCoordhNV");
    glFogCoordhvNV = (PFNGLFOGCOORDHVNVPROC) loadFunction("glFogCoordhvNV");
    glFogf = (PFNGLFOGFPROC) loadFunction("glFogf");
    glFogfv = (PFNGLFOGFVPROC) loadFunction("glFogfv");
    glFogi = (PFNGLFOGIPROC) loadFunction("glFogi");
    glFogiv = (PFNGLFOGIVPROC) loadFunction("glFogiv");
    glFragmentCoverageColorNV = (PFNGLFRAGMENTCOVERAGECOLORNVPROC) loadFunction("glFragmentCoverageColorNV");
    glFramebufferDrawBufferEXT = (PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC) loadFunction("glFramebufferDrawBufferEXT");
    glFramebufferDrawBuffersEXT = (PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC) loadFunction("glFramebufferDrawBuffersEXT");
    glFramebufferFetchBarrierEXT = (PFNGLFRAMEBUFFERFETCHBARRIEREXTPROC) loadFunction("glFramebufferFetchBarrierEXT");
    glFramebufferParameteri = (PFNGLFRAMEBUFFERPARAMETERIPROC) loadFunction("glFramebufferParameteri");
    glFramebufferReadBufferEXT = (PFNGLFRAMEBUFFERREADBUFFEREXTPROC) loadFunction("glFramebufferReadBufferEXT");
    glFramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC) loadFunction("glFramebufferRenderbuffer");
    glFramebufferRenderbufferEXT = (PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC) loadFunction("glFramebufferRenderbufferEXT");
    glFramebufferSampleLocationsfvARB = (PFNGLFRAMEBUFFERSAMPLELOCATIONSFVARBPROC) loadFunction("glFramebufferSampleLocationsfvARB");
    glFramebufferSampleLocationsfvNV = (PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC) loadFunction("glFramebufferSampleLocationsfvNV");
    glFramebufferSamplePositionsfvAMD = (PFNGLFRAMEBUFFERSAMPLEPOSITIONSFVAMDPROC) loadFunction("glFramebufferSamplePositionsfvAMD");
    glFramebufferTexture = (PFNGLFRAMEBUFFERTEXTUREPROC) loadFunction("glFramebufferTexture");
    glFramebufferTexture1D = (PFNGLFRAMEBUFFERTEXTURE1DPROC) loadFunction("glFramebufferTexture1D");
    glFramebufferTexture1DEXT = (PFNGLFRAMEBUFFERTEXTURE1DEXTPROC) loadFunction("glFramebufferTexture1DEXT");
    glFramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC) loadFunction("glFramebufferTexture2D");
    glFramebufferTexture2DEXT = (PFNGLFRAMEBUFFERTEXTURE2DEXTPROC) loadFunction("glFramebufferTexture2DEXT");
    glFramebufferTexture3D = (PFNGLFRAMEBUFFERTEXTURE3DPROC) loadFunction("glFramebufferTexture3D");
    glFramebufferTexture3DEXT = (PFNGLFRAMEBUFFERTEXTURE3DEXTPROC) loadFunction("glFramebufferTexture3DEXT");
    glFramebufferTextureARB = (PFNGLFRAMEBUFFERTEXTUREARBPROC) loadFunction("glFramebufferTextureARB");
    glFramebufferTextureEXT = (PFNGLFRAMEBUFFERTEXTUREEXTPROC) loadFunction("glFramebufferTextureEXT");
    glFramebufferTextureFaceARB = (PFNGLFRAMEBUFFERTEXTUREFACEARBPROC) loadFunction("glFramebufferTextureFaceARB");
    glFramebufferTextureFaceEXT = (PFNGLFRAMEBUFFERTEXTUREFACEEXTPROC) loadFunction("glFramebufferTextureFaceEXT");
    glFramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC) loadFunction("glFramebufferTextureLayer");
    glFramebufferTextureLayerARB = (PFNGLFRAMEBUFFERTEXTURELAYERARBPROC) loadFunction("glFramebufferTextureLayerARB");
    glFramebufferTextureLayerEXT = (PFNGLFRAMEBUFFERTEXTURELAYEREXTPROC) loadFunction("glFramebufferTextureLayerEXT");
    glFrontFace = (PFNGLFRONTFACEPROC) loadFunction("glFrontFace");
    glFrustum = (PFNGLFRUSTUMPROC) loadFunction("glFrustum");
    glGenBuffers = (PFNGLGENBUFFERSPROC) loadFunction("glGenBuffers");
    glGenBuffersARB = (PFNGLGENBUFFERSARBPROC) loadFunction("glGenBuffersARB");
    glGenFencesAPPLE = (PFNGLGENFENCESAPPLEPROC) loadFunction("glGenFencesAPPLE");
    glGenFencesNV = (PFNGLGENFENCESNVPROC) loadFunction("glGenFencesNV");
    glGenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC) loadFunction("glGenFramebuffers");
    glGenFramebuffersEXT = (PFNGLGENFRAMEBUFFERSEXTPROC) loadFunction("glGenFramebuffersEXT");
    glGenLists = (PFNGLGENLISTSPROC) loadFunction("glGenLists");
    glGenNamesAMD = (PFNGLGENNAMESAMDPROC) loadFunction("glGenNamesAMD");
    glGenOcclusionQueriesNV = (PFNGLGENOCCLUSIONQUERIESNVPROC) loadFunction("glGenOcclusionQueriesNV");
    glGenPathsNV = (PFNGLGENPATHSNVPROC) loadFunction("glGenPathsNV");
    glGenPerfMonitorsAMD = (PFNGLGENPERFMONITORSAMDPROC) loadFunction("glGenPerfMonitorsAMD");
    glGenProgramPipelines = (PFNGLGENPROGRAMPIPELINESPROC) loadFunction("glGenProgramPipelines");
    glGenProgramPipelinesEXT = (PFNGLGENPROGRAMPIPELINESEXTPROC) loadFunction("glGenProgramPipelinesEXT");
    glGenProgramsARB = (PFNGLGENPROGRAMSARBPROC) loadFunction("glGenProgramsARB");
    glGenProgramsNV = (PFNGLGENPROGRAMSNVPROC) loadFunction("glGenProgramsNV");
    glGenQueries = (PFNGLGENQUERIESPROC) loadFunction("glGenQueries");
    glGenQueriesARB = (PFNGLGENQUERIESARBPROC) loadFunction("glGenQueriesARB");
    glGenQueryResourceTagNV = (PFNGLGENQUERYRESOURCETAGNVPROC) loadFunction("glGenQueryResourceTagNV");
    glGenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC) loadFunction("glGenRenderbuffers");
    glGenRenderbuffersEXT = (PFNGLGENRENDERBUFFERSEXTPROC) loadFunction("glGenRenderbuffersEXT");
    glGenSamplers = (PFNGLGENSAMPLERSPROC) loadFunction("glGenSamplers");
    glGenSemaphoresEXT = (PFNGLGENSEMAPHORESEXTPROC) loadFunction("glGenSemaphoresEXT");
    glGenSymbolsEXT = (PFNGLGENSYMBOLSEXTPROC) loadFunction("glGenSymbolsEXT");
    glGenTextures = (PFNGLGENTEXTURESPROC) loadFunction("glGenTextures");
    glGenTexturesEXT = (PFNGLGENTEXTURESEXTPROC) loadFunction("glGenTexturesEXT");
    glGenTransformFeedbacks = (PFNGLGENTRANSFORMFEEDBACKSPROC) loadFunction("glGenTransformFeedbacks");
    glGenTransformFeedbacksNV = (PFNGLGENTRANSFORMFEEDBACKSNVPROC) loadFunction("glGenTransformFeedbacksNV");
    glGenVertexArrays = (PFNGLGENVERTEXARRAYSPROC) loadFunction("glGenVertexArrays");
    glGenVertexArraysAPPLE = (PFNGLGENVERTEXARRAYSAPPLEPROC) loadFunction("glGenVertexArraysAPPLE");
    glGenVertexShadersEXT = (PFNGLGENVERTEXSHADERSEXTPROC) loadFunction("glGenVertexShadersEXT");
    glGenerateMipmap = (PFNGLGENERATEMIPMAPPROC) loadFunction("glGenerateMipmap");
    glGenerateMipmapEXT = (PFNGLGENERATEMIPMAPEXTPROC) loadFunction("glGenerateMipmapEXT");
    glGenerateMultiTexMipmapEXT = (PFNGLGENERATEMULTITEXMIPMAPEXTPROC) loadFunction("glGenerateMultiTexMipmapEXT");
    glGenerateTextureMipmap = (PFNGLGENERATETEXTUREMIPMAPPROC) loadFunction("glGenerateTextureMipmap");
    glGenerateTextureMipmapEXT = (PFNGLGENERATETEXTUREMIPMAPEXTPROC) loadFunction("glGenerateTextureMipmapEXT");
    glGetActiveAtomicCounterBufferiv = (PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC) loadFunction("glGetActiveAtomicCounterBufferiv");
    glGetActiveAttrib = (PFNGLGETACTIVEATTRIBPROC) loadFunction("glGetActiveAttrib");
    glGetActiveAttribARB = (PFNGLGETACTIVEATTRIBARBPROC) loadFunction("glGetActiveAttribARB");
    glGetActiveSubroutineName = (PFNGLGETACTIVESUBROUTINENAMEPROC) loadFunction("glGetActiveSubroutineName");
    glGetActiveSubroutineUniformName = (PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC) loadFunction("glGetActiveSubroutineUniformName");
    glGetActiveSubroutineUniformiv = (PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC) loadFunction("glGetActiveSubroutineUniformiv");
    glGetActiveUniform = (PFNGLGETACTIVEUNIFORMPROC) loadFunction("glGetActiveUniform");
    glGetActiveUniformARB = (PFNGLGETACTIVEUNIFORMARBPROC) loadFunction("glGetActiveUniformARB");
    glGetActiveUniformBlockName = (PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC) loadFunction("glGetActiveUniformBlockName");
    glGetActiveUniformBlockiv = (PFNGLGETACTIVEUNIFORMBLOCKIVPROC) loadFunction("glGetActiveUniformBlockiv");
    glGetActiveUniformName = (PFNGLGETACTIVEUNIFORMNAMEPROC) loadFunction("glGetActiveUniformName");
    glGetActiveUniformsiv = (PFNGLGETACTIVEUNIFORMSIVPROC) loadFunction("glGetActiveUniformsiv");
    glGetActiveVaryingNV = (PFNGLGETACTIVEVARYINGNVPROC) loadFunction("glGetActiveVaryingNV");
    glGetAttachedObjectsARB = (PFNGLGETATTACHEDOBJECTSARBPROC) loadFunction("glGetAttachedObjectsARB");
    glGetAttachedShaders = (PFNGLGETATTACHEDSHADERSPROC) loadFunction("glGetAttachedShaders");
    glGetAttribLocation = (PFNGLGETATTRIBLOCATIONPROC) loadFunction("glGetAttribLocation");
    glGetAttribLocationARB = (PFNGLGETATTRIBLOCATIONARBPROC) loadFunction("glGetAttribLocationARB");
    glGetBooleanIndexedvEXT = (PFNGLGETBOOLEANINDEXEDVEXTPROC) loadFunction("glGetBooleanIndexedvEXT");
    glGetBooleani_v = (PFNGLGETBOOLEANI_VPROC) loadFunction("glGetBooleani_v");
    glGetBooleanv = (PFNGLGETBOOLEANVPROC) loadFunction("glGetBooleanv");
    glGetBufferParameteri64v = (PFNGLGETBUFFERPARAMETERI64VPROC) loadFunction("glGetBufferParameteri64v");
    glGetBufferParameteriv = (PFNGLGETBUFFERPARAMETERIVPROC) loadFunction("glGetBufferParameteriv");
    glGetBufferParameterivARB = (PFNGLGETBUFFERPARAMETERIVARBPROC) loadFunction("glGetBufferParameterivARB");
    glGetBufferParameterui64vNV = (PFNGLGETBUFFERPARAMETERUI64VNVPROC) loadFunction("glGetBufferParameterui64vNV");
    glGetBufferPointerv = (PFNGLGETBUFFERPOINTERVPROC) loadFunction("glGetBufferPointerv");
    glGetBufferPointervARB = (PFNGLGETBUFFERPOINTERVARBPROC) loadFunction("glGetBufferPointervARB");
    glGetBufferSubData = (PFNGLGETBUFFERSUBDATAPROC) loadFunction("glGetBufferSubData");
    glGetBufferSubDataARB = (PFNGLGETBUFFERSUBDATAARBPROC) loadFunction("glGetBufferSubDataARB");
    glGetClipPlane = (PFNGLGETCLIPPLANEPROC) loadFunction("glGetClipPlane");
    glGetColorTable = (PFNGLGETCOLORTABLEPROC) loadFunction("glGetColorTable");
    glGetColorTableEXT = (PFNGLGETCOLORTABLEEXTPROC) loadFunction("glGetColorTableEXT");
    glGetColorTableParameterfv = (PFNGLGETCOLORTABLEPARAMETERFVPROC) loadFunction("glGetColorTableParameterfv");
    glGetColorTableParameterfvEXT = (PFNGLGETCOLORTABLEPARAMETERFVEXTPROC) loadFunction("glGetColorTableParameterfvEXT");
    glGetColorTableParameteriv = (PFNGLGETCOLORTABLEPARAMETERIVPROC) loadFunction("glGetColorTableParameteriv");
    glGetColorTableParameterivEXT = (PFNGLGETCOLORTABLEPARAMETERIVEXTPROC) loadFunction("glGetColorTableParameterivEXT");
    glGetCombinerInputParameterfvNV = (PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC) loadFunction("glGetCombinerInputParameterfvNV");
    glGetCombinerInputParameterivNV = (PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC) loadFunction("glGetCombinerInputParameterivNV");
    glGetCombinerOutputParameterfvNV = (PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC) loadFunction("glGetCombinerOutputParameterfvNV");
    glGetCombinerOutputParameterivNV = (PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC) loadFunction("glGetCombinerOutputParameterivNV");
    glGetCombinerStageParameterfvNV = (PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC) loadFunction("glGetCombinerStageParameterfvNV");
    glGetCommandHeaderNV = (PFNGLGETCOMMANDHEADERNVPROC) loadFunction("glGetCommandHeaderNV");
    glGetCompressedMultiTexImageEXT = (PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC) loadFunction("glGetCompressedMultiTexImageEXT");
    glGetCompressedTexImage = (PFNGLGETCOMPRESSEDTEXIMAGEPROC) loadFunction("glGetCompressedTexImage");
    glGetCompressedTexImageARB = (PFNGLGETCOMPRESSEDTEXIMAGEARBPROC) loadFunction("glGetCompressedTexImageARB");
    glGetCompressedTextureImage = (PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC) loadFunction("glGetCompressedTextureImage");
    glGetCompressedTextureImageEXT = (PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC) loadFunction("glGetCompressedTextureImageEXT");
    glGetCompressedTextureSubImage = (PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC) loadFunction("glGetCompressedTextureSubImage");
    glGetConvolutionFilter = (PFNGLGETCONVOLUTIONFILTERPROC) loadFunction("glGetConvolutionFilter");
    glGetConvolutionFilterEXT = (PFNGLGETCONVOLUTIONFILTEREXTPROC) loadFunction("glGetConvolutionFilterEXT");
    glGetConvolutionParameterfv = (PFNGLGETCONVOLUTIONPARAMETERFVPROC) loadFunction("glGetConvolutionParameterfv");
    glGetConvolutionParameterfvEXT = (PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC) loadFunction("glGetConvolutionParameterfvEXT");
    glGetConvolutionParameteriv = (PFNGLGETCONVOLUTIONPARAMETERIVPROC) loadFunction("glGetConvolutionParameteriv");
    glGetConvolutionParameterivEXT = (PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC) loadFunction("glGetConvolutionParameterivEXT");
    glGetCoverageModulationTableNV = (PFNGLGETCOVERAGEMODULATIONTABLENVPROC) loadFunction("glGetCoverageModulationTableNV");
    glGetDebugMessageLog = (PFNGLGETDEBUGMESSAGELOGPROC) loadFunction("glGetDebugMessageLog");
    glGetDebugMessageLogAMD = (PFNGLGETDEBUGMESSAGELOGAMDPROC) loadFunction("glGetDebugMessageLogAMD");
    glGetDebugMessageLogARB = (PFNGLGETDEBUGMESSAGELOGARBPROC) loadFunction("glGetDebugMessageLogARB");
    glGetDebugMessageLogKHR = (PFNGLGETDEBUGMESSAGELOGKHRPROC) loadFunction("glGetDebugMessageLogKHR");
    glGetDoubleIndexedvEXT = (PFNGLGETDOUBLEINDEXEDVEXTPROC) loadFunction("glGetDoubleIndexedvEXT");
    glGetDoublei_v = (PFNGLGETDOUBLEI_VPROC) loadFunction("glGetDoublei_v");
    glGetDoublei_vEXT = (PFNGLGETDOUBLEI_VEXTPROC) loadFunction("glGetDoublei_vEXT");
    glGetDoublev = (PFNGLGETDOUBLEVPROC) loadFunction("glGetDoublev");
    glGetError = (PFNGLGETERRORPROC) loadFunction("glGetError");
    glGetFenceivNV = (PFNGLGETFENCEIVNVPROC) loadFunction("glGetFenceivNV");
    glGetFinalCombinerInputParameterfvNV = (PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC) loadFunction("glGetFinalCombinerInputParameterfvNV");
    glGetFinalCombinerInputParameterivNV = (PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC) loadFunction("glGetFinalCombinerInputParameterivNV");
    glGetFirstPerfQueryIdINTEL = (PFNGLGETFIRSTPERFQUERYIDINTELPROC) loadFunction("glGetFirstPerfQueryIdINTEL");
    glGetFloatIndexedvEXT = (PFNGLGETFLOATINDEXEDVEXTPROC) loadFunction("glGetFloatIndexedvEXT");
    glGetFloati_v = (PFNGLGETFLOATI_VPROC) loadFunction("glGetFloati_v");
    glGetFloati_vEXT = (PFNGLGETFLOATI_VEXTPROC) loadFunction("glGetFloati_vEXT");
    glGetFloatv = (PFNGLGETFLOATVPROC) loadFunction("glGetFloatv");
    glGetFragDataIndex = (PFNGLGETFRAGDATAINDEXPROC) loadFunction("glGetFragDataIndex");
    glGetFragDataLocation = (PFNGLGETFRAGDATALOCATIONPROC) loadFunction("glGetFragDataLocation");
    glGetFragDataLocationEXT = (PFNGLGETFRAGDATALOCATIONEXTPROC) loadFunction("glGetFragDataLocationEXT");
    glGetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC) loadFunction("glGetFramebufferAttachmentParameteriv");
    glGetFramebufferAttachmentParameterivEXT = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC) loadFunction("glGetFramebufferAttachmentParameterivEXT");
    glGetFramebufferParameterfvAMD = (PFNGLGETFRAMEBUFFERPARAMETERFVAMDPROC) loadFunction("glGetFramebufferParameterfvAMD");
    glGetFramebufferParameteriv = (PFNGLGETFRAMEBUFFERPARAMETERIVPROC) loadFunction("glGetFramebufferParameteriv");
    glGetFramebufferParameterivEXT = (PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC) loadFunction("glGetFramebufferParameterivEXT");
    glGetGraphicsResetStatus = (PFNGLGETGRAPHICSRESETSTATUSPROC) loadFunction("glGetGraphicsResetStatus");
    glGetGraphicsResetStatusARB = (PFNGLGETGRAPHICSRESETSTATUSARBPROC) loadFunction("glGetGraphicsResetStatusARB");
    glGetGraphicsResetStatusKHR = (PFNGLGETGRAPHICSRESETSTATUSKHRPROC) loadFunction("glGetGraphicsResetStatusKHR");
    glGetHandleARB = (PFNGLGETHANDLEARBPROC) loadFunction("glGetHandleARB");
    glGetHistogram = (PFNGLGETHISTOGRAMPROC) loadFunction("glGetHistogram");
    glGetHistogramEXT = (PFNGLGETHISTOGRAMEXTPROC) loadFunction("glGetHistogramEXT");
    glGetHistogramParameterfv = (PFNGLGETHISTOGRAMPARAMETERFVPROC) loadFunction("glGetHistogramParameterfv");
    glGetHistogramParameterfvEXT = (PFNGLGETHISTOGRAMPARAMETERFVEXTPROC) loadFunction("glGetHistogramParameterfvEXT");
    glGetHistogramParameteriv = (PFNGLGETHISTOGRAMPARAMETERIVPROC) loadFunction("glGetHistogramParameteriv");
    glGetHistogramParameterivEXT = (PFNGLGETHISTOGRAMPARAMETERIVEXTPROC) loadFunction("glGetHistogramParameterivEXT");
    glGetImageHandleARB = (PFNGLGETIMAGEHANDLEARBPROC) loadFunction("glGetImageHandleARB");
    glGetImageHandleNV = (PFNGLGETIMAGEHANDLENVPROC) loadFunction("glGetImageHandleNV");
    glGetInfoLogARB = (PFNGLGETINFOLOGARBPROC) loadFunction("glGetInfoLogARB");
    glGetInteger64i_v = (PFNGLGETINTEGER64I_VPROC) loadFunction("glGetInteger64i_v");
    glGetInteger64v = (PFNGLGETINTEGER64VPROC) loadFunction("glGetInteger64v");
    glGetIntegerIndexedvEXT = (PFNGLGETINTEGERINDEXEDVEXTPROC) loadFunction("glGetIntegerIndexedvEXT");
    glGetIntegeri_v = (PFNGLGETINTEGERI_VPROC) loadFunction("glGetIntegeri_v");
    glGetIntegerui64i_vNV = (PFNGLGETINTEGERUI64I_VNVPROC) loadFunction("glGetIntegerui64i_vNV");
    glGetIntegerui64vNV = (PFNGLGETINTEGERUI64VNVPROC) loadFunction("glGetIntegerui64vNV");
    glGetIntegerv = (PFNGLGETINTEGERVPROC) loadFunction("glGetIntegerv");
    glGetInternalformatSampleivNV = (PFNGLGETINTERNALFORMATSAMPLEIVNVPROC) loadFunction("glGetInternalformatSampleivNV");
    glGetInternalformati64v = (PFNGLGETINTERNALFORMATI64VPROC) loadFunction("glGetInternalformati64v");
    glGetInternalformativ = (PFNGLGETINTERNALFORMATIVPROC) loadFunction("glGetInternalformativ");
    glGetInvariantBooleanvEXT = (PFNGLGETINVARIANTBOOLEANVEXTPROC) loadFunction("glGetInvariantBooleanvEXT");
    glGetInvariantFloatvEXT = (PFNGLGETINVARIANTFLOATVEXTPROC) loadFunction("glGetInvariantFloatvEXT");
    glGetInvariantIntegervEXT = (PFNGLGETINVARIANTINTEGERVEXTPROC) loadFunction("glGetInvariantIntegervEXT");
    glGetLightfv = (PFNGLGETLIGHTFVPROC) loadFunction("glGetLightfv");
    glGetLightiv = (PFNGLGETLIGHTIVPROC) loadFunction("glGetLightiv");
    glGetLocalConstantBooleanvEXT = (PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC) loadFunction("glGetLocalConstantBooleanvEXT");
    glGetLocalConstantFloatvEXT = (PFNGLGETLOCALCONSTANTFLOATVEXTPROC) loadFunction("glGetLocalConstantFloatvEXT");
    glGetLocalConstantIntegervEXT = (PFNGLGETLOCALCONSTANTINTEGERVEXTPROC) loadFunction("glGetLocalConstantIntegervEXT");
    glGetMapAttribParameterfvNV = (PFNGLGETMAPATTRIBPARAMETERFVNVPROC) loadFunction("glGetMapAttribParameterfvNV");
    glGetMapAttribParameterivNV = (PFNGLGETMAPATTRIBPARAMETERIVNVPROC) loadFunction("glGetMapAttribParameterivNV");
    glGetMapControlPointsNV = (PFNGLGETMAPCONTROLPOINTSNVPROC) loadFunction("glGetMapControlPointsNV");
    glGetMapParameterfvNV = (PFNGLGETMAPPARAMETERFVNVPROC) loadFunction("glGetMapParameterfvNV");
    glGetMapParameterivNV = (PFNGLGETMAPPARAMETERIVNVPROC) loadFunction("glGetMapParameterivNV");
    glGetMapdv = (PFNGLGETMAPDVPROC) loadFunction("glGetMapdv");
    glGetMapfv = (PFNGLGETMAPFVPROC) loadFunction("glGetMapfv");
    glGetMapiv = (PFNGLGETMAPIVPROC) loadFunction("glGetMapiv");
    glGetMaterialfv = (PFNGLGETMATERIALFVPROC) loadFunction("glGetMaterialfv");
    glGetMaterialiv = (PFNGLGETMATERIALIVPROC) loadFunction("glGetMaterialiv");
    glGetMemoryObjectDetachedResourcesuivNV = (PFNGLGETMEMORYOBJECTDETACHEDRESOURCESUIVNVPROC) loadFunction("glGetMemoryObjectDetachedResourcesuivNV");
    glGetMemoryObjectParameterivEXT = (PFNGLGETMEMORYOBJECTPARAMETERIVEXTPROC) loadFunction("glGetMemoryObjectParameterivEXT");
    glGetMinmax = (PFNGLGETMINMAXPROC) loadFunction("glGetMinmax");
    glGetMinmaxEXT = (PFNGLGETMINMAXEXTPROC) loadFunction("glGetMinmaxEXT");
    glGetMinmaxParameterfv = (PFNGLGETMINMAXPARAMETERFVPROC) loadFunction("glGetMinmaxParameterfv");
    glGetMinmaxParameterfvEXT = (PFNGLGETMINMAXPARAMETERFVEXTPROC) loadFunction("glGetMinmaxParameterfvEXT");
    glGetMinmaxParameteriv = (PFNGLGETMINMAXPARAMETERIVPROC) loadFunction("glGetMinmaxParameteriv");
    glGetMinmaxParameterivEXT = (PFNGLGETMINMAXPARAMETERIVEXTPROC) loadFunction("glGetMinmaxParameterivEXT");
    glGetMultiTexEnvfvEXT = (PFNGLGETMULTITEXENVFVEXTPROC) loadFunction("glGetMultiTexEnvfvEXT");
    glGetMultiTexEnvivEXT = (PFNGLGETMULTITEXENVIVEXTPROC) loadFunction("glGetMultiTexEnvivEXT");
    glGetMultiTexGendvEXT = (PFNGLGETMULTITEXGENDVEXTPROC) loadFunction("glGetMultiTexGendvEXT");
    glGetMultiTexGenfvEXT = (PFNGLGETMULTITEXGENFVEXTPROC) loadFunction("glGetMultiTexGenfvEXT");
    glGetMultiTexGenivEXT = (PFNGLGETMULTITEXGENIVEXTPROC) loadFunction("glGetMultiTexGenivEXT");
    glGetMultiTexImageEXT = (PFNGLGETMULTITEXIMAGEEXTPROC) loadFunction("glGetMultiTexImageEXT");
    glGetMultiTexLevelParameterfvEXT = (PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC) loadFunction("glGetMultiTexLevelParameterfvEXT");
    glGetMultiTexLevelParameterivEXT = (PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC) loadFunction("glGetMultiTexLevelParameterivEXT");
    glGetMultiTexParameterIivEXT = (PFNGLGETMULTITEXPARAMETERIIVEXTPROC) loadFunction("glGetMultiTexParameterIivEXT");
    glGetMultiTexParameterIuivEXT = (PFNGLGETMULTITEXPARAMETERIUIVEXTPROC) loadFunction("glGetMultiTexParameterIuivEXT");
    glGetMultiTexParameterfvEXT = (PFNGLGETMULTITEXPARAMETERFVEXTPROC) loadFunction("glGetMultiTexParameterfvEXT");
    glGetMultiTexParameterivEXT = (PFNGLGETMULTITEXPARAMETERIVEXTPROC) loadFunction("glGetMultiTexParameterivEXT");
    glGetMultisamplefv = (PFNGLGETMULTISAMPLEFVPROC) loadFunction("glGetMultisamplefv");
    glGetMultisamplefvNV = (PFNGLGETMULTISAMPLEFVNVPROC) loadFunction("glGetMultisamplefvNV");
    glGetNamedBufferParameteri64v = (PFNGLGETNAMEDBUFFERPARAMETERI64VPROC) loadFunction("glGetNamedBufferParameteri64v");
    glGetNamedBufferParameteriv = (PFNGLGETNAMEDBUFFERPARAMETERIVPROC) loadFunction("glGetNamedBufferParameteriv");
    glGetNamedBufferParameterivEXT = (PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC) loadFunction("glGetNamedBufferParameterivEXT");
    glGetNamedBufferParameterui64vNV = (PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC) loadFunction("glGetNamedBufferParameterui64vNV");
    glGetNamedBufferPointerv = (PFNGLGETNAMEDBUFFERPOINTERVPROC) loadFunction("glGetNamedBufferPointerv");
    glGetNamedBufferPointervEXT = (PFNGLGETNAMEDBUFFERPOINTERVEXTPROC) loadFunction("glGetNamedBufferPointervEXT");
    glGetNamedBufferSubData = (PFNGLGETNAMEDBUFFERSUBDATAPROC) loadFunction("glGetNamedBufferSubData");
    glGetNamedBufferSubDataEXT = (PFNGLGETNAMEDBUFFERSUBDATAEXTPROC) loadFunction("glGetNamedBufferSubDataEXT");
    glGetNamedFramebufferParameterfvAMD = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERFVAMDPROC) loadFunction("glGetNamedFramebufferParameterfvAMD");
    glGetNamedFramebufferAttachmentParameteriv = (PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC) loadFunction("glGetNamedFramebufferAttachmentParameteriv");
    glGetNamedFramebufferAttachmentParameterivEXT = (PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC) loadFunction("glGetNamedFramebufferAttachmentParameterivEXT");
    glGetNamedFramebufferParameteriv = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC) loadFunction("glGetNamedFramebufferParameteriv");
    glGetNamedFramebufferParameterivEXT = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC) loadFunction("glGetNamedFramebufferParameterivEXT");
    glGetNamedProgramLocalParameterIivEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC) loadFunction("glGetNamedProgramLocalParameterIivEXT");
    glGetNamedProgramLocalParameterIuivEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC) loadFunction("glGetNamedProgramLocalParameterIuivEXT");
    glGetNamedProgramLocalParameterdvEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC) loadFunction("glGetNamedProgramLocalParameterdvEXT");
    glGetNamedProgramLocalParameterfvEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC) loadFunction("glGetNamedProgramLocalParameterfvEXT");
    glGetNamedProgramStringEXT = (PFNGLGETNAMEDPROGRAMSTRINGEXTPROC) loadFunction("glGetNamedProgramStringEXT");
    glGetNamedProgramivEXT = (PFNGLGETNAMEDPROGRAMIVEXTPROC) loadFunction("glGetNamedProgramivEXT");
    glGetNamedRenderbufferParameteriv = (PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC) loadFunction("glGetNamedRenderbufferParameteriv");
    glGetNamedRenderbufferParameterivEXT = (PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC) loadFunction("glGetNamedRenderbufferParameterivEXT");
    glGetNamedStringARB = (PFNGLGETNAMEDSTRINGARBPROC) loadFunction("glGetNamedStringARB");
    glGetNamedStringivARB = (PFNGLGETNAMEDSTRINGIVARBPROC) loadFunction("glGetNamedStringivARB");
    glGetNextPerfQueryIdINTEL = (PFNGLGETNEXTPERFQUERYIDINTELPROC) loadFunction("glGetNextPerfQueryIdINTEL");
    glGetObjectLabel = (PFNGLGETOBJECTLABELPROC) loadFunction("glGetObjectLabel");
    glGetObjectLabelEXT = (PFNGLGETOBJECTLABELEXTPROC) loadFunction("glGetObjectLabelEXT");
    glGetObjectLabelKHR = (PFNGLGETOBJECTLABELKHRPROC) loadFunction("glGetObjectLabelKHR");
    glGetObjectParameterfvARB = (PFNGLGETOBJECTPARAMETERFVARBPROC) loadFunction("glGetObjectParameterfvARB");
    glGetObjectParameterivAPPLE = (PFNGLGETOBJECTPARAMETERIVAPPLEPROC) loadFunction("glGetObjectParameterivAPPLE");
    glGetObjectParameterivARB = (PFNGLGETOBJECTPARAMETERIVARBPROC) loadFunction("glGetObjectParameterivARB");
    glGetObjectPtrLabel = (PFNGLGETOBJECTPTRLABELPROC) loadFunction("glGetObjectPtrLabel");
    glGetObjectPtrLabelKHR = (PFNGLGETOBJECTPTRLABELKHRPROC) loadFunction("glGetObjectPtrLabelKHR");
    glGetOcclusionQueryivNV = (PFNGLGETOCCLUSIONQUERYIVNVPROC) loadFunction("glGetOcclusionQueryivNV");
    glGetOcclusionQueryuivNV = (PFNGLGETOCCLUSIONQUERYUIVNVPROC) loadFunction("glGetOcclusionQueryuivNV");
    glGetPathColorGenfvNV = (PFNGLGETPATHCOLORGENFVNVPROC) loadFunction("glGetPathColorGenfvNV");
    glGetPathColorGenivNV = (PFNGLGETPATHCOLORGENIVNVPROC) loadFunction("glGetPathColorGenivNV");
    glGetPathCommandsNV = (PFNGLGETPATHCOMMANDSNVPROC) loadFunction("glGetPathCommandsNV");
    glGetPathCoordsNV = (PFNGLGETPATHCOORDSNVPROC) loadFunction("glGetPathCoordsNV");
    glGetPathDashArrayNV = (PFNGLGETPATHDASHARRAYNVPROC) loadFunction("glGetPathDashArrayNV");
    glGetPathLengthNV = (PFNGLGETPATHLENGTHNVPROC) loadFunction("glGetPathLengthNV");
    glGetPathMetricRangeNV = (PFNGLGETPATHMETRICRANGENVPROC) loadFunction("glGetPathMetricRangeNV");
    glGetPathMetricsNV = (PFNGLGETPATHMETRICSNVPROC) loadFunction("glGetPathMetricsNV");
    glGetPathParameterfvNV = (PFNGLGETPATHPARAMETERFVNVPROC) loadFunction("glGetPathParameterfvNV");
    glGetPathParameterivNV = (PFNGLGETPATHPARAMETERIVNVPROC) loadFunction("glGetPathParameterivNV");
    glGetPathSpacingNV = (PFNGLGETPATHSPACINGNVPROC) loadFunction("glGetPathSpacingNV");
    glGetPathTexGenfvNV = (PFNGLGETPATHTEXGENFVNVPROC) loadFunction("glGetPathTexGenfvNV");
    glGetPathTexGenivNV = (PFNGLGETPATHTEXGENIVNVPROC) loadFunction("glGetPathTexGenivNV");
    glGetPerfCounterInfoINTEL = (PFNGLGETPERFCOUNTERINFOINTELPROC) loadFunction("glGetPerfCounterInfoINTEL");
    glGetPerfMonitorCounterDataAMD = (PFNGLGETPERFMONITORCOUNTERDATAAMDPROC) loadFunction("glGetPerfMonitorCounterDataAMD");
    glGetPerfMonitorCounterInfoAMD = (PFNGLGETPERFMONITORCOUNTERINFOAMDPROC) loadFunction("glGetPerfMonitorCounterInfoAMD");
    glGetPerfMonitorCounterStringAMD = (PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC) loadFunction("glGetPerfMonitorCounterStringAMD");
    glGetPerfMonitorCountersAMD = (PFNGLGETPERFMONITORCOUNTERSAMDPROC) loadFunction("glGetPerfMonitorCountersAMD");
    glGetPerfMonitorGroupStringAMD = (PFNGLGETPERFMONITORGROUPSTRINGAMDPROC) loadFunction("glGetPerfMonitorGroupStringAMD");
    glGetPerfMonitorGroupsAMD = (PFNGLGETPERFMONITORGROUPSAMDPROC) loadFunction("glGetPerfMonitorGroupsAMD");
    glGetPerfQueryDataINTEL = (PFNGLGETPERFQUERYDATAINTELPROC) loadFunction("glGetPerfQueryDataINTEL");
    glGetPerfQueryIdByNameINTEL = (PFNGLGETPERFQUERYIDBYNAMEINTELPROC) loadFunction("glGetPerfQueryIdByNameINTEL");
    glGetPerfQueryInfoINTEL = (PFNGLGETPERFQUERYINFOINTELPROC) loadFunction("glGetPerfQueryInfoINTEL");
    glGetPixelMapfv = (PFNGLGETPIXELMAPFVPROC) loadFunction("glGetPixelMapfv");
    glGetPixelMapuiv = (PFNGLGETPIXELMAPUIVPROC) loadFunction("glGetPixelMapuiv");
    glGetPixelMapusv = (PFNGLGETPIXELMAPUSVPROC) loadFunction("glGetPixelMapusv");
    glGetPixelTransformParameterfvEXT = (PFNGLGETPIXELTRANSFORMPARAMETERFVEXTPROC) loadFunction("glGetPixelTransformParameterfvEXT");
    glGetPixelTransformParameterivEXT = (PFNGLGETPIXELTRANSFORMPARAMETERIVEXTPROC) loadFunction("glGetPixelTransformParameterivEXT");
    glGetPointerIndexedvEXT = (PFNGLGETPOINTERINDEXEDVEXTPROC) loadFunction("glGetPointerIndexedvEXT");
    glGetPointeri_vEXT = (PFNGLGETPOINTERI_VEXTPROC) loadFunction("glGetPointeri_vEXT");
    glGetPointerv = (PFNGLGETPOINTERVPROC) loadFunction("glGetPointerv");
    glGetPointervEXT = (PFNGLGETPOINTERVEXTPROC) loadFunction("glGetPointervEXT");
    glGetPointervKHR = (PFNGLGETPOINTERVKHRPROC) loadFunction("glGetPointervKHR");
    glGetPolygonStipple = (PFNGLGETPOLYGONSTIPPLEPROC) loadFunction("glGetPolygonStipple");
    glGetProgramBinary = (PFNGLGETPROGRAMBINARYPROC) loadFunction("glGetProgramBinary");
    glGetProgramEnvParameterIivNV = (PFNGLGETPROGRAMENVPARAMETERIIVNVPROC) loadFunction("glGetProgramEnvParameterIivNV");
    glGetProgramEnvParameterIuivNV = (PFNGLGETPROGRAMENVPARAMETERIUIVNVPROC) loadFunction("glGetProgramEnvParameterIuivNV");
    glGetProgramEnvParameterdvARB = (PFNGLGETPROGRAMENVPARAMETERDVARBPROC) loadFunction("glGetProgramEnvParameterdvARB");
    glGetProgramEnvParameterfvARB = (PFNGLGETPROGRAMENVPARAMETERFVARBPROC) loadFunction("glGetProgramEnvParameterfvARB");
    glGetProgramInfoLog = (PFNGLGETPROGRAMINFOLOGPROC) loadFunction("glGetProgramInfoLog");
    glGetProgramInterfaceiv = (PFNGLGETPROGRAMINTERFACEIVPROC) loadFunction("glGetProgramInterfaceiv");
    glGetProgramLocalParameterIivNV = (PFNGLGETPROGRAMLOCALPARAMETERIIVNVPROC) loadFunction("glGetProgramLocalParameterIivNV");
    glGetProgramLocalParameterIuivNV = (PFNGLGETPROGRAMLOCALPARAMETERIUIVNVPROC) loadFunction("glGetProgramLocalParameterIuivNV");
    glGetProgramLocalParameterdvARB = (PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC) loadFunction("glGetProgramLocalParameterdvARB");
    glGetProgramLocalParameterfvARB = (PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC) loadFunction("glGetProgramLocalParameterfvARB");
    glGetProgramNamedParameterdvNV = (PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC) loadFunction("glGetProgramNamedParameterdvNV");
    glGetProgramNamedParameterfvNV = (PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC) loadFunction("glGetProgramNamedParameterfvNV");
    glGetProgramParameterdvNV = (PFNGLGETPROGRAMPARAMETERDVNVPROC) loadFunction("glGetProgramParameterdvNV");
    glGetProgramParameterfvNV = (PFNGLGETPROGRAMPARAMETERFVNVPROC) loadFunction("glGetProgramParameterfvNV");
    glGetProgramPipelineInfoLog = (PFNGLGETPROGRAMPIPELINEINFOLOGPROC) loadFunction("glGetProgramPipelineInfoLog");
    glGetProgramPipelineInfoLogEXT = (PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC) loadFunction("glGetProgramPipelineInfoLogEXT");
    glGetProgramPipelineiv = (PFNGLGETPROGRAMPIPELINEIVPROC) loadFunction("glGetProgramPipelineiv");
    glGetProgramPipelineivEXT = (PFNGLGETPROGRAMPIPELINEIVEXTPROC) loadFunction("glGetProgramPipelineivEXT");
    glGetProgramResourceIndex = (PFNGLGETPROGRAMRESOURCEINDEXPROC) loadFunction("glGetProgramResourceIndex");
    glGetProgramResourceLocation = (PFNGLGETPROGRAMRESOURCELOCATIONPROC) loadFunction("glGetProgramResourceLocation");
    glGetProgramResourceLocationIndex = (PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC) loadFunction("glGetProgramResourceLocationIndex");
    glGetProgramResourceName = (PFNGLGETPROGRAMRESOURCENAMEPROC) loadFunction("glGetProgramResourceName");
    glGetProgramResourcefvNV = (PFNGLGETPROGRAMRESOURCEFVNVPROC) loadFunction("glGetProgramResourcefvNV");
    glGetProgramResourceiv = (PFNGLGETPROGRAMRESOURCEIVPROC) loadFunction("glGetProgramResourceiv");
    glGetProgramStageiv = (PFNGLGETPROGRAMSTAGEIVPROC) loadFunction("glGetProgramStageiv");
    glGetProgramStringARB = (PFNGLGETPROGRAMSTRINGARBPROC) loadFunction("glGetProgramStringARB");
    glGetProgramStringNV = (PFNGLGETPROGRAMSTRINGNVPROC) loadFunction("glGetProgramStringNV");
    glGetProgramSubroutineParameteruivNV = (PFNGLGETPROGRAMSUBROUTINEPARAMETERUIVNVPROC) loadFunction("glGetProgramSubroutineParameteruivNV");
    glGetProgramiv = (PFNGLGETPROGRAMIVPROC) loadFunction("glGetProgramiv");
    glGetProgramivARB = (PFNGLGETPROGRAMIVARBPROC) loadFunction("glGetProgramivARB");
    glGetProgramivNV = (PFNGLGETPROGRAMIVNVPROC) loadFunction("glGetProgramivNV");
    glGetQueryBufferObjecti64v = (PFNGLGETQUERYBUFFEROBJECTI64VPROC) loadFunction("glGetQueryBufferObjecti64v");
    glGetQueryBufferObjectiv = (PFNGLGETQUERYBUFFEROBJECTIVPROC) loadFunction("glGetQueryBufferObjectiv");
    glGetQueryBufferObjectui64v = (PFNGLGETQUERYBUFFEROBJECTUI64VPROC) loadFunction("glGetQueryBufferObjectui64v");
    glGetQueryBufferObjectuiv = (PFNGLGETQUERYBUFFEROBJECTUIVPROC) loadFunction("glGetQueryBufferObjectuiv");
    glGetQueryIndexediv = (PFNGLGETQUERYINDEXEDIVPROC) loadFunction("glGetQueryIndexediv");
    glGetQueryObjecti64v = (PFNGLGETQUERYOBJECTI64VPROC) loadFunction("glGetQueryObjecti64v");
    glGetQueryObjecti64vEXT = (PFNGLGETQUERYOBJECTI64VEXTPROC) loadFunction("glGetQueryObjecti64vEXT");
    glGetQueryObjectiv = (PFNGLGETQUERYOBJECTIVPROC) loadFunction("glGetQueryObjectiv");
    glGetQueryObjectivARB = (PFNGLGETQUERYOBJECTIVARBPROC) loadFunction("glGetQueryObjectivARB");
    glGetQueryObjectui64v = (PFNGLGETQUERYOBJECTUI64VPROC) loadFunction("glGetQueryObjectui64v");
    glGetQueryObjectui64vEXT = (PFNGLGETQUERYOBJECTUI64VEXTPROC) loadFunction("glGetQueryObjectui64vEXT");
    glGetQueryObjectuiv = (PFNGLGETQUERYOBJECTUIVPROC) loadFunction("glGetQueryObjectuiv");
    glGetQueryObjectuivARB = (PFNGLGETQUERYOBJECTUIVARBPROC) loadFunction("glGetQueryObjectuivARB");
    glGetQueryiv = (PFNGLGETQUERYIVPROC) loadFunction("glGetQueryiv");
    glGetQueryivARB = (PFNGLGETQUERYIVARBPROC) loadFunction("glGetQueryivARB");
    glGetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC) loadFunction("glGetRenderbufferParameteriv");
    glGetRenderbufferParameterivEXT = (PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC) loadFunction("glGetRenderbufferParameterivEXT");
    glGetSamplerParameterIiv = (PFNGLGETSAMPLERPARAMETERIIVPROC) loadFunction("glGetSamplerParameterIiv");
    glGetSamplerParameterIuiv = (PFNGLGETSAMPLERPARAMETERIUIVPROC) loadFunction("glGetSamplerParameterIuiv");
    glGetSamplerParameterfv = (PFNGLGETSAMPLERPARAMETERFVPROC) loadFunction("glGetSamplerParameterfv");
    glGetSamplerParameteriv = (PFNGLGETSAMPLERPARAMETERIVPROC) loadFunction("glGetSamplerParameteriv");
    glGetSemaphoreParameterui64vEXT = (PFNGLGETSEMAPHOREPARAMETERUI64VEXTPROC) loadFunction("glGetSemaphoreParameterui64vEXT");
    glGetSeparableFilter = (PFNGLGETSEPARABLEFILTERPROC) loadFunction("glGetSeparableFilter");
    glGetSeparableFilterEXT = (PFNGLGETSEPARABLEFILTEREXTPROC) loadFunction("glGetSeparableFilterEXT");
    glGetShaderInfoLog = (PFNGLGETSHADERINFOLOGPROC) loadFunction("glGetShaderInfoLog");
    glGetShaderPrecisionFormat = (PFNGLGETSHADERPRECISIONFORMATPROC) loadFunction("glGetShaderPrecisionFormat");
    glGetShaderSource = (PFNGLGETSHADERSOURCEPROC) loadFunction("glGetShaderSource");
    glGetShaderSourceARB = (PFNGLGETSHADERSOURCEARBPROC) loadFunction("glGetShaderSourceARB");
    glGetShaderiv = (PFNGLGETSHADERIVPROC) loadFunction("glGetShaderiv");
    glGetShadingRateImagePaletteNV = (PFNGLGETSHADINGRATEIMAGEPALETTENVPROC) loadFunction("glGetShadingRateImagePaletteNV");
    glGetShadingRateSampleLocationivNV = (PFNGLGETSHADINGRATESAMPLELOCATIONIVNVPROC) loadFunction("glGetShadingRateSampleLocationivNV");
    glGetStageIndexNV = (PFNGLGETSTAGEINDEXNVPROC) loadFunction("glGetStageIndexNV");
    glGetString = (PFNGLGETSTRINGPROC) loadFunction("glGetString");
    glGetStringi = (PFNGLGETSTRINGIPROC) loadFunction("glGetStringi");
    glGetSubroutineIndex = (PFNGLGETSUBROUTINEINDEXPROC) loadFunction("glGetSubroutineIndex");
    glGetSubroutineUniformLocation = (PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC) loadFunction("glGetSubroutineUniformLocation");
    glGetSynciv = (PFNGLGETSYNCIVPROC) loadFunction("glGetSynciv");
    glGetTexEnvfv = (PFNGLGETTEXENVFVPROC) loadFunction("glGetTexEnvfv");
    glGetTexEnviv = (PFNGLGETTEXENVIVPROC) loadFunction("glGetTexEnviv");
    glGetTexGendv = (PFNGLGETTEXGENDVPROC) loadFunction("glGetTexGendv");
    glGetTexGenfv = (PFNGLGETTEXGENFVPROC) loadFunction("glGetTexGenfv");
    glGetTexGeniv = (PFNGLGETTEXGENIVPROC) loadFunction("glGetTexGeniv");
    glGetTexImage = (PFNGLGETTEXIMAGEPROC) loadFunction("glGetTexImage");
    glGetTexLevelParameterfv = (PFNGLGETTEXLEVELPARAMETERFVPROC) loadFunction("glGetTexLevelParameterfv");
    glGetTexLevelParameteriv = (PFNGLGETTEXLEVELPARAMETERIVPROC) loadFunction("glGetTexLevelParameteriv");
    glGetTexParameterIiv = (PFNGLGETTEXPARAMETERIIVPROC) loadFunction("glGetTexParameterIiv");
    glGetTexParameterIivEXT = (PFNGLGETTEXPARAMETERIIVEXTPROC) loadFunction("glGetTexParameterIivEXT");
    glGetTexParameterIuiv = (PFNGLGETTEXPARAMETERIUIVPROC) loadFunction("glGetTexParameterIuiv");
    glGetTexParameterIuivEXT = (PFNGLGETTEXPARAMETERIUIVEXTPROC) loadFunction("glGetTexParameterIuivEXT");
    glGetTexParameterPointervAPPLE = (PFNGLGETTEXPARAMETERPOINTERVAPPLEPROC) loadFunction("glGetTexParameterPointervAPPLE");
    glGetTexParameterfv = (PFNGLGETTEXPARAMETERFVPROC) loadFunction("glGetTexParameterfv");
    glGetTexParameteriv = (PFNGLGETTEXPARAMETERIVPROC) loadFunction("glGetTexParameteriv");
    glGetTextureHandleARB = (PFNGLGETTEXTUREHANDLEARBPROC) loadFunction("glGetTextureHandleARB");
    glGetTextureHandleNV = (PFNGLGETTEXTUREHANDLENVPROC) loadFunction("glGetTextureHandleNV");
    glGetTextureImage = (PFNGLGETTEXTUREIMAGEPROC) loadFunction("glGetTextureImage");
    glGetTextureImageEXT = (PFNGLGETTEXTUREIMAGEEXTPROC) loadFunction("glGetTextureImageEXT");
    glGetTextureLevelParameterfv = (PFNGLGETTEXTURELEVELPARAMETERFVPROC) loadFunction("glGetTextureLevelParameterfv");
    glGetTextureLevelParameterfvEXT = (PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC) loadFunction("glGetTextureLevelParameterfvEXT");
    glGetTextureLevelParameteriv = (PFNGLGETTEXTURELEVELPARAMETERIVPROC) loadFunction("glGetTextureLevelParameteriv");
    glGetTextureLevelParameterivEXT = (PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC) loadFunction("glGetTextureLevelParameterivEXT");
    glGetTextureParameterIiv = (PFNGLGETTEXTUREPARAMETERIIVPROC) loadFunction("glGetTextureParameterIiv");
    glGetTextureParameterIivEXT = (PFNGLGETTEXTUREPARAMETERIIVEXTPROC) loadFunction("glGetTextureParameterIivEXT");
    glGetTextureParameterIuiv = (PFNGLGETTEXTUREPARAMETERIUIVPROC) loadFunction("glGetTextureParameterIuiv");
    glGetTextureParameterIuivEXT = (PFNGLGETTEXTUREPARAMETERIUIVEXTPROC) loadFunction("glGetTextureParameterIuivEXT");
    glGetTextureParameterfv = (PFNGLGETTEXTUREPARAMETERFVPROC) loadFunction("glGetTextureParameterfv");
    glGetTextureParameterfvEXT = (PFNGLGETTEXTUREPARAMETERFVEXTPROC) loadFunction("glGetTextureParameterfvEXT");
    glGetTextureParameteriv = (PFNGLGETTEXTUREPARAMETERIVPROC) loadFunction("glGetTextureParameteriv");
    glGetTextureParameterivEXT = (PFNGLGETTEXTUREPARAMETERIVEXTPROC) loadFunction("glGetTextureParameterivEXT");
    glGetTextureSamplerHandleARB = (PFNGLGETTEXTURESAMPLERHANDLEARBPROC) loadFunction("glGetTextureSamplerHandleARB");
    glGetTextureSamplerHandleNV = (PFNGLGETTEXTURESAMPLERHANDLENVPROC) loadFunction("glGetTextureSamplerHandleNV");
    glGetTextureSubImage = (PFNGLGETTEXTURESUBIMAGEPROC) loadFunction("glGetTextureSubImage");
    glGetTrackMatrixivNV = (PFNGLGETTRACKMATRIXIVNVPROC) loadFunction("glGetTrackMatrixivNV");
    glGetTransformFeedbackVarying = (PFNGLGETTRANSFORMFEEDBACKVARYINGPROC) loadFunction("glGetTransformFeedbackVarying");
    glGetTransformFeedbackVaryingEXT = (PFNGLGETTRANSFORMFEEDBACKVARYINGEXTPROC) loadFunction("glGetTransformFeedbackVaryingEXT");
    glGetTransformFeedbackVaryingNV = (PFNGLGETTRANSFORMFEEDBACKVARYINGNVPROC) loadFunction("glGetTransformFeedbackVaryingNV");
    glGetTransformFeedbacki64_v = (PFNGLGETTRANSFORMFEEDBACKI64_VPROC) loadFunction("glGetTransformFeedbacki64_v");
    glGetTransformFeedbacki_v = (PFNGLGETTRANSFORMFEEDBACKI_VPROC) loadFunction("glGetTransformFeedbacki_v");
    glGetTransformFeedbackiv = (PFNGLGETTRANSFORMFEEDBACKIVPROC) loadFunction("glGetTransformFeedbackiv");
    glGetUniformBlockIndex = (PFNGLGETUNIFORMBLOCKINDEXPROC) loadFunction("glGetUniformBlockIndex");
    glGetUniformBufferSizeEXT = (PFNGLGETUNIFORMBUFFERSIZEEXTPROC) loadFunction("glGetUniformBufferSizeEXT");
    glGetUniformIndices = (PFNGLGETUNIFORMINDICESPROC) loadFunction("glGetUniformIndices");
    glGetUniformLocation = (PFNGLGETUNIFORMLOCATIONPROC) loadFunction("glGetUniformLocation");
    glGetUniformLocationARB = (PFNGLGETUNIFORMLOCATIONARBPROC) loadFunction("glGetUniformLocationARB");
    glGetUniformOffsetEXT = (PFNGLGETUNIFORMOFFSETEXTPROC) loadFunction("glGetUniformOffsetEXT");
    glGetUniformSubroutineuiv = (PFNGLGETUNIFORMSUBROUTINEUIVPROC) loadFunction("glGetUniformSubroutineuiv");
    glGetUniformdv = (PFNGLGETUNIFORMDVPROC) loadFunction("glGetUniformdv");
    glGetUniformfv = (PFNGLGETUNIFORMFVPROC) loadFunction("glGetUniformfv");
    glGetUniformfvARB = (PFNGLGETUNIFORMFVARBPROC) loadFunction("glGetUniformfvARB");
    glGetUniformi64vARB = (PFNGLGETUNIFORMI64VARBPROC) loadFunction("glGetUniformi64vARB");
    glGetUniformi64vNV = (PFNGLGETUNIFORMI64VNVPROC) loadFunction("glGetUniformi64vNV");
    glGetUniformiv = (PFNGLGETUNIFORMIVPROC) loadFunction("glGetUniformiv");
    glGetUniformivARB = (PFNGLGETUNIFORMIVARBPROC) loadFunction("glGetUniformivARB");
    glGetUniformui64vARB = (PFNGLGETUNIFORMUI64VARBPROC) loadFunction("glGetUniformui64vARB");
    glGetUniformui64vNV = (PFNGLGETUNIFORMUI64VNVPROC) loadFunction("glGetUniformui64vNV");
    glGetUniformuiv = (PFNGLGETUNIFORMUIVPROC) loadFunction("glGetUniformuiv");
    glGetUniformuivEXT = (PFNGLGETUNIFORMUIVEXTPROC) loadFunction("glGetUniformuivEXT");
    glGetUnsignedBytevEXT = (PFNGLGETUNSIGNEDBYTEVEXTPROC) loadFunction("glGetUnsignedBytevEXT");
    glGetUnsignedBytei_vEXT = (PFNGLGETUNSIGNEDBYTEI_VEXTPROC) loadFunction("glGetUnsignedBytei_vEXT");
    glGetVariantBooleanvEXT = (PFNGLGETVARIANTBOOLEANVEXTPROC) loadFunction("glGetVariantBooleanvEXT");
    glGetVariantFloatvEXT = (PFNGLGETVARIANTFLOATVEXTPROC) loadFunction("glGetVariantFloatvEXT");
    glGetVariantIntegervEXT = (PFNGLGETVARIANTINTEGERVEXTPROC) loadFunction("glGetVariantIntegervEXT");
    glGetVariantPointervEXT = (PFNGLGETVARIANTPOINTERVEXTPROC) loadFunction("glGetVariantPointervEXT");
    glGetVaryingLocationNV = (PFNGLGETVARYINGLOCATIONNVPROC) loadFunction("glGetVaryingLocationNV");
    glGetVertexArrayIndexed64iv = (PFNGLGETVERTEXARRAYINDEXED64IVPROC) loadFunction("glGetVertexArrayIndexed64iv");
    glGetVertexArrayIndexediv = (PFNGLGETVERTEXARRAYINDEXEDIVPROC) loadFunction("glGetVertexArrayIndexediv");
    glGetVertexArrayIntegeri_vEXT = (PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC) loadFunction("glGetVertexArrayIntegeri_vEXT");
    glGetVertexArrayIntegervEXT = (PFNGLGETVERTEXARRAYINTEGERVEXTPROC) loadFunction("glGetVertexArrayIntegervEXT");
    glGetVertexArrayPointeri_vEXT = (PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC) loadFunction("glGetVertexArrayPointeri_vEXT");
    glGetVertexArrayPointervEXT = (PFNGLGETVERTEXARRAYPOINTERVEXTPROC) loadFunction("glGetVertexArrayPointervEXT");
    glGetVertexArrayiv = (PFNGLGETVERTEXARRAYIVPROC) loadFunction("glGetVertexArrayiv");
    glGetVertexAttribIiv = (PFNGLGETVERTEXATTRIBIIVPROC) loadFunction("glGetVertexAttribIiv");
    glGetVertexAttribIivEXT = (PFNGLGETVERTEXATTRIBIIVEXTPROC) loadFunction("glGetVertexAttribIivEXT");
    glGetVertexAttribIuiv = (PFNGLGETVERTEXATTRIBIUIVPROC) loadFunction("glGetVertexAttribIuiv");
    glGetVertexAttribIuivEXT = (PFNGLGETVERTEXATTRIBIUIVEXTPROC) loadFunction("glGetVertexAttribIuivEXT");
    glGetVertexAttribLdv = (PFNGLGETVERTEXATTRIBLDVPROC) loadFunction("glGetVertexAttribLdv");
    glGetVertexAttribLdvEXT = (PFNGLGETVERTEXATTRIBLDVEXTPROC) loadFunction("glGetVertexAttribLdvEXT");
    glGetVertexAttribLi64vNV = (PFNGLGETVERTEXATTRIBLI64VNVPROC) loadFunction("glGetVertexAttribLi64vNV");
    glGetVertexAttribLui64vARB = (PFNGLGETVERTEXATTRIBLUI64VARBPROC) loadFunction("glGetVertexAttribLui64vARB");
    glGetVertexAttribLui64vNV = (PFNGLGETVERTEXATTRIBLUI64VNVPROC) loadFunction("glGetVertexAttribLui64vNV");
    glGetVertexAttribPointerv = (PFNGLGETVERTEXATTRIBPOINTERVPROC) loadFunction("glGetVertexAttribPointerv");
    glGetVertexAttribPointervARB = (PFNGLGETVERTEXATTRIBPOINTERVARBPROC) loadFunction("glGetVertexAttribPointervARB");
    glGetVertexAttribPointervNV = (PFNGLGETVERTEXATTRIBPOINTERVNVPROC) loadFunction("glGetVertexAttribPointervNV");
    glGetVertexAttribdv = (PFNGLGETVERTEXATTRIBDVPROC) loadFunction("glGetVertexAttribdv");
    glGetVertexAttribdvARB = (PFNGLGETVERTEXATTRIBDVARBPROC) loadFunction("glGetVertexAttribdvARB");
    glGetVertexAttribdvNV = (PFNGLGETVERTEXATTRIBDVNVPROC) loadFunction("glGetVertexAttribdvNV");
    glGetVertexAttribfv = (PFNGLGETVERTEXATTRIBFVPROC) loadFunction("glGetVertexAttribfv");
    glGetVertexAttribfvARB = (PFNGLGETVERTEXATTRIBFVARBPROC) loadFunction("glGetVertexAttribfvARB");
    glGetVertexAttribfvNV = (PFNGLGETVERTEXATTRIBFVNVPROC) loadFunction("glGetVertexAttribfvNV");
    glGetVertexAttribiv = (PFNGLGETVERTEXATTRIBIVPROC) loadFunction("glGetVertexAttribiv");
    glGetVertexAttribivARB = (PFNGLGETVERTEXATTRIBIVARBPROC) loadFunction("glGetVertexAttribivARB");
    glGetVertexAttribivNV = (PFNGLGETVERTEXATTRIBIVNVPROC) loadFunction("glGetVertexAttribivNV");
    glGetVideoCaptureStreamdvNV = (PFNGLGETVIDEOCAPTURESTREAMDVNVPROC) loadFunction("glGetVideoCaptureStreamdvNV");
    glGetVideoCaptureStreamfvNV = (PFNGLGETVIDEOCAPTURESTREAMFVNVPROC) loadFunction("glGetVideoCaptureStreamfvNV");
    glGetVideoCaptureStreamivNV = (PFNGLGETVIDEOCAPTURESTREAMIVNVPROC) loadFunction("glGetVideoCaptureStreamivNV");
    glGetVideoCaptureivNV = (PFNGLGETVIDEOCAPTUREIVNVPROC) loadFunction("glGetVideoCaptureivNV");
    glGetVideoi64vNV = (PFNGLGETVIDEOI64VNVPROC) loadFunction("glGetVideoi64vNV");
    glGetVideoivNV = (PFNGLGETVIDEOIVNVPROC) loadFunction("glGetVideoivNV");
    glGetVideoui64vNV = (PFNGLGETVIDEOUI64VNVPROC) loadFunction("glGetVideoui64vNV");
    glGetVideouivNV = (PFNGLGETVIDEOUIVNVPROC) loadFunction("glGetVideouivNV");
    glGetnColorTable = (PFNGLGETNCOLORTABLEPROC) loadFunction("glGetnColorTable");
    glGetnColorTableARB = (PFNGLGETNCOLORTABLEARBPROC) loadFunction("glGetnColorTableARB");
    glGetnCompressedTexImage = (PFNGLGETNCOMPRESSEDTEXIMAGEPROC) loadFunction("glGetnCompressedTexImage");
    glGetnCompressedTexImageARB = (PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC) loadFunction("glGetnCompressedTexImageARB");
    glGetnConvolutionFilter = (PFNGLGETNCONVOLUTIONFILTERPROC) loadFunction("glGetnConvolutionFilter");
    glGetnConvolutionFilterARB = (PFNGLGETNCONVOLUTIONFILTERARBPROC) loadFunction("glGetnConvolutionFilterARB");
    glGetnHistogram = (PFNGLGETNHISTOGRAMPROC) loadFunction("glGetnHistogram");
    glGetnHistogramARB = (PFNGLGETNHISTOGRAMARBPROC) loadFunction("glGetnHistogramARB");
    glGetnMapdv = (PFNGLGETNMAPDVPROC) loadFunction("glGetnMapdv");
    glGetnMapdvARB = (PFNGLGETNMAPDVARBPROC) loadFunction("glGetnMapdvARB");
    glGetnMapfv = (PFNGLGETNMAPFVPROC) loadFunction("glGetnMapfv");
    glGetnMapfvARB = (PFNGLGETNMAPFVARBPROC) loadFunction("glGetnMapfvARB");
    glGetnMapiv = (PFNGLGETNMAPIVPROC) loadFunction("glGetnMapiv");
    glGetnMapivARB = (PFNGLGETNMAPIVARBPROC) loadFunction("glGetnMapivARB");
    glGetnMinmax = (PFNGLGETNMINMAXPROC) loadFunction("glGetnMinmax");
    glGetnMinmaxARB = (PFNGLGETNMINMAXARBPROC) loadFunction("glGetnMinmaxARB");
    glGetnPixelMapfv = (PFNGLGETNPIXELMAPFVPROC) loadFunction("glGetnPixelMapfv");
    glGetnPixelMapfvARB = (PFNGLGETNPIXELMAPFVARBPROC) loadFunction("glGetnPixelMapfvARB");
    glGetnPixelMapuiv = (PFNGLGETNPIXELMAPUIVPROC) loadFunction("glGetnPixelMapuiv");
    glGetnPixelMapuivARB = (PFNGLGETNPIXELMAPUIVARBPROC) loadFunction("glGetnPixelMapuivARB");
    glGetnPixelMapusv = (PFNGLGETNPIXELMAPUSVPROC) loadFunction("glGetnPixelMapusv");
    glGetnPixelMapusvARB = (PFNGLGETNPIXELMAPUSVARBPROC) loadFunction("glGetnPixelMapusvARB");
    glGetnPolygonStipple = (PFNGLGETNPOLYGONSTIPPLEPROC) loadFunction("glGetnPolygonStipple");
    glGetnPolygonStippleARB = (PFNGLGETNPOLYGONSTIPPLEARBPROC) loadFunction("glGetnPolygonStippleARB");
    glGetnSeparableFilter = (PFNGLGETNSEPARABLEFILTERPROC) loadFunction("glGetnSeparableFilter");
    glGetnSeparableFilterARB = (PFNGLGETNSEPARABLEFILTERARBPROC) loadFunction("glGetnSeparableFilterARB");
    glGetnTexImage = (PFNGLGETNTEXIMAGEPROC) loadFunction("glGetnTexImage");
    glGetnTexImageARB = (PFNGLGETNTEXIMAGEARBPROC) loadFunction("glGetnTexImageARB");
    glGetnUniformdv = (PFNGLGETNUNIFORMDVPROC) loadFunction("glGetnUniformdv");
    glGetnUniformdvARB = (PFNGLGETNUNIFORMDVARBPROC) loadFunction("glGetnUniformdvARB");
    glGetnUniformfv = (PFNGLGETNUNIFORMFVPROC) loadFunction("glGetnUniformfv");
    glGetnUniformfvARB = (PFNGLGETNUNIFORMFVARBPROC) loadFunction("glGetnUniformfvARB");
    glGetnUniformfvKHR = (PFNGLGETNUNIFORMFVKHRPROC) loadFunction("glGetnUniformfvKHR");
    glGetnUniformi64vARB = (PFNGLGETNUNIFORMI64VARBPROC) loadFunction("glGetnUniformi64vARB");
    glGetnUniformiv = (PFNGLGETNUNIFORMIVPROC) loadFunction("glGetnUniformiv");
    glGetnUniformivARB = (PFNGLGETNUNIFORMIVARBPROC) loadFunction("glGetnUniformivARB");
    glGetnUniformivKHR = (PFNGLGETNUNIFORMIVKHRPROC) loadFunction("glGetnUniformivKHR");
    glGetnUniformui64vARB = (PFNGLGETNUNIFORMUI64VARBPROC) loadFunction("glGetnUniformui64vARB");
    glGetnUniformuiv = (PFNGLGETNUNIFORMUIVPROC) loadFunction("glGetnUniformuiv");
    glGetnUniformuivARB = (PFNGLGETNUNIFORMUIVARBPROC) loadFunction("glGetnUniformuivARB");
    glGetnUniformuivKHR = (PFNGLGETNUNIFORMUIVKHRPROC) loadFunction("glGetnUniformuivKHR");
    glHint = (PFNGLHINTPROC) loadFunction("glHint");
    glHistogram = (PFNGLHISTOGRAMPROC) loadFunction("glHistogram");
    glHistogramEXT = (PFNGLHISTOGRAMEXTPROC) loadFunction("glHistogramEXT");
    glImportMemoryFdEXT = (PFNGLIMPORTMEMORYFDEXTPROC) loadFunction("glImportMemoryFdEXT");
    glImportMemoryWin32HandleEXT = (PFNGLIMPORTMEMORYWIN32HANDLEEXTPROC) loadFunction("glImportMemoryWin32HandleEXT");
    glImportMemoryWin32NameEXT = (PFNGLIMPORTMEMORYWIN32NAMEEXTPROC) loadFunction("glImportMemoryWin32NameEXT");
    glImportSemaphoreFdEXT = (PFNGLIMPORTSEMAPHOREFDEXTPROC) loadFunction("glImportSemaphoreFdEXT");
    glImportSemaphoreWin32HandleEXT = (PFNGLIMPORTSEMAPHOREWIN32HANDLEEXTPROC) loadFunction("glImportSemaphoreWin32HandleEXT");
    glImportSemaphoreWin32NameEXT = (PFNGLIMPORTSEMAPHOREWIN32NAMEEXTPROC) loadFunction("glImportSemaphoreWin32NameEXT");
    glImportSyncEXT = (PFNGLIMPORTSYNCEXTPROC) loadFunction("glImportSyncEXT");
    glIndexFormatNV = (PFNGLINDEXFORMATNVPROC) loadFunction("glIndexFormatNV");
    glIndexFuncEXT = (PFNGLINDEXFUNCEXTPROC) loadFunction("glIndexFuncEXT");
    glIndexMask = (PFNGLINDEXMASKPROC) loadFunction("glIndexMask");
    glIndexMaterialEXT = (PFNGLINDEXMATERIALEXTPROC) loadFunction("glIndexMaterialEXT");
    glIndexPointer = (PFNGLINDEXPOINTERPROC) loadFunction("glIndexPointer");
    glIndexPointerEXT = (PFNGLINDEXPOINTEREXTPROC) loadFunction("glIndexPointerEXT");
    glIndexd = (PFNGLINDEXDPROC) loadFunction("glIndexd");
    glIndexdv = (PFNGLINDEXDVPROC) loadFunction("glIndexdv");
    glIndexf = (PFNGLINDEXFPROC) loadFunction("glIndexf");
    glIndexfv = (PFNGLINDEXFVPROC) loadFunction("glIndexfv");
    glIndexi = (PFNGLINDEXIPROC) loadFunction("glIndexi");
    glIndexiv = (PFNGLINDEXIVPROC) loadFunction("glIndexiv");
    glIndexs = (PFNGLINDEXSPROC) loadFunction("glIndexs");
    glIndexsv = (PFNGLINDEXSVPROC) loadFunction("glIndexsv");
    glIndexub = (PFNGLINDEXUBPROC) loadFunction("glIndexub");
    glIndexubv = (PFNGLINDEXUBVPROC) loadFunction("glIndexubv");
    glInitNames = (PFNGLINITNAMESPROC) loadFunction("glInitNames");
    glInsertComponentEXT = (PFNGLINSERTCOMPONENTEXTPROC) loadFunction("glInsertComponentEXT");
    glInsertEventMarkerEXT = (PFNGLINSERTEVENTMARKEREXTPROC) loadFunction("glInsertEventMarkerEXT");
    glInterleavedArrays = (PFNGLINTERLEAVEDARRAYSPROC) loadFunction("glInterleavedArrays");
    glInterpolatePathsNV = (PFNGLINTERPOLATEPATHSNVPROC) loadFunction("glInterpolatePathsNV");
    glInvalidateBufferData = (PFNGLINVALIDATEBUFFERDATAPROC) loadFunction("glInvalidateBufferData");
    glInvalidateBufferSubData = (PFNGLINVALIDATEBUFFERSUBDATAPROC) loadFunction("glInvalidateBufferSubData");
    glInvalidateFramebuffer = (PFNGLINVALIDATEFRAMEBUFFERPROC) loadFunction("glInvalidateFramebuffer");
    glInvalidateNamedFramebufferData = (PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC) loadFunction("glInvalidateNamedFramebufferData");
    glInvalidateNamedFramebufferSubData = (PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC) loadFunction("glInvalidateNamedFramebufferSubData");
    glInvalidateSubFramebuffer = (PFNGLINVALIDATESUBFRAMEBUFFERPROC) loadFunction("glInvalidateSubFramebuffer");
    glInvalidateTexImage = (PFNGLINVALIDATETEXIMAGEPROC) loadFunction("glInvalidateTexImage");
    glInvalidateTexSubImage = (PFNGLINVALIDATETEXSUBIMAGEPROC) loadFunction("glInvalidateTexSubImage");
    glIsBuffer = (PFNGLISBUFFERPROC) loadFunction("glIsBuffer");
    glIsBufferARB = (PFNGLISBUFFERARBPROC) loadFunction("glIsBufferARB");
    glIsBufferResidentNV = (PFNGLISBUFFERRESIDENTNVPROC) loadFunction("glIsBufferResidentNV");
    glIsCommandListNV = (PFNGLISCOMMANDLISTNVPROC) loadFunction("glIsCommandListNV");
    glIsEnabled = (PFNGLISENABLEDPROC) loadFunction("glIsEnabled");
    glIsEnabledIndexedEXT = (PFNGLISENABLEDINDEXEDEXTPROC) loadFunction("glIsEnabledIndexedEXT");
    glIsEnabledi = (PFNGLISENABLEDIPROC) loadFunction("glIsEnabledi");
    glIsFenceAPPLE = (PFNGLISFENCEAPPLEPROC) loadFunction("glIsFenceAPPLE");
    glIsFenceNV = (PFNGLISFENCENVPROC) loadFunction("glIsFenceNV");
    glIsFramebuffer = (PFNGLISFRAMEBUFFERPROC) loadFunction("glIsFramebuffer");
    glIsFramebufferEXT = (PFNGLISFRAMEBUFFEREXTPROC) loadFunction("glIsFramebufferEXT");
    glIsImageHandleResidentARB = (PFNGLISIMAGEHANDLERESIDENTARBPROC) loadFunction("glIsImageHandleResidentARB");
    glIsImageHandleResidentNV = (PFNGLISIMAGEHANDLERESIDENTNVPROC) loadFunction("glIsImageHandleResidentNV");
    glIsList = (PFNGLISLISTPROC) loadFunction("glIsList");
    glIsMemoryObjectEXT = (PFNGLISMEMORYOBJECTEXTPROC) loadFunction("glIsMemoryObjectEXT");
    glIsNameAMD = (PFNGLISNAMEAMDPROC) loadFunction("glIsNameAMD");
    glIsNamedBufferResidentNV = (PFNGLISNAMEDBUFFERRESIDENTNVPROC) loadFunction("glIsNamedBufferResidentNV");
    glIsNamedStringARB = (PFNGLISNAMEDSTRINGARBPROC) loadFunction("glIsNamedStringARB");
    glIsOcclusionQueryNV = (PFNGLISOCCLUSIONQUERYNVPROC) loadFunction("glIsOcclusionQueryNV");
    glIsPathNV = (PFNGLISPATHNVPROC) loadFunction("glIsPathNV");
    glIsPointInFillPathNV = (PFNGLISPOINTINFILLPATHNVPROC) loadFunction("glIsPointInFillPathNV");
    glIsPointInStrokePathNV = (PFNGLISPOINTINSTROKEPATHNVPROC) loadFunction("glIsPointInStrokePathNV");
    glIsProgram = (PFNGLISPROGRAMPROC) loadFunction("glIsProgram");
    glIsProgramARB = (PFNGLISPROGRAMARBPROC) loadFunction("glIsProgramARB");
    glIsProgramNV = (PFNGLISPROGRAMNVPROC) loadFunction("glIsProgramNV");
    glIsProgramPipeline = (PFNGLISPROGRAMPIPELINEPROC) loadFunction("glIsProgramPipeline");
    glIsProgramPipelineEXT = (PFNGLISPROGRAMPIPELINEEXTPROC) loadFunction("glIsProgramPipelineEXT");
    glIsQuery = (PFNGLISQUERYPROC) loadFunction("glIsQuery");
    glIsQueryARB = (PFNGLISQUERYARBPROC) loadFunction("glIsQueryARB");
    glIsRenderbuffer = (PFNGLISRENDERBUFFERPROC) loadFunction("glIsRenderbuffer");
    glIsRenderbufferEXT = (PFNGLISRENDERBUFFEREXTPROC) loadFunction("glIsRenderbufferEXT");
    glIsSemaphoreEXT = (PFNGLISSEMAPHOREEXTPROC) loadFunction("glIsSemaphoreEXT");
    glIsSampler = (PFNGLISSAMPLERPROC) loadFunction("glIsSampler");
    glIsShader = (PFNGLISSHADERPROC) loadFunction("glIsShader");
    glIsStateNV = (PFNGLISSTATENVPROC) loadFunction("glIsStateNV");
    glIsSync = (PFNGLISSYNCPROC) loadFunction("glIsSync");
    glIsTexture = (PFNGLISTEXTUREPROC) loadFunction("glIsTexture");
    glIsTextureEXT = (PFNGLISTEXTUREEXTPROC) loadFunction("glIsTextureEXT");
    glIsTextureHandleResidentARB = (PFNGLISTEXTUREHANDLERESIDENTARBPROC) loadFunction("glIsTextureHandleResidentARB");
    glIsTextureHandleResidentNV = (PFNGLISTEXTUREHANDLERESIDENTNVPROC) loadFunction("glIsTextureHandleResidentNV");
    glIsTransformFeedback = (PFNGLISTRANSFORMFEEDBACKPROC) loadFunction("glIsTransformFeedback");
    glIsTransformFeedbackNV = (PFNGLISTRANSFORMFEEDBACKNVPROC) loadFunction("glIsTransformFeedbackNV");
    glIsVariantEnabledEXT = (PFNGLISVARIANTENABLEDEXTPROC) loadFunction("glIsVariantEnabledEXT");
    glIsVertexArray = (PFNGLISVERTEXARRAYPROC) loadFunction("glIsVertexArray");
    glIsVertexArrayAPPLE = (PFNGLISVERTEXARRAYAPPLEPROC) loadFunction("glIsVertexArrayAPPLE");
    glIsVertexAttribEnabledAPPLE = (PFNGLISVERTEXATTRIBENABLEDAPPLEPROC) loadFunction("glIsVertexAttribEnabledAPPLE");
    glLabelObjectEXT = (PFNGLLABELOBJECTEXTPROC) loadFunction("glLabelObjectEXT");
    glLightModelf = (PFNGLLIGHTMODELFPROC) loadFunction("glLightModelf");
    glLightModelfv = (PFNGLLIGHTMODELFVPROC) loadFunction("glLightModelfv");
    glLightModeli = (PFNGLLIGHTMODELIPROC) loadFunction("glLightModeli");
    glLightModeliv = (PFNGLLIGHTMODELIVPROC) loadFunction("glLightModeliv");
    glLightf = (PFNGLLIGHTFPROC) loadFunction("glLightf");
    glLightfv = (PFNGLLIGHTFVPROC) loadFunction("glLightfv");
    glLighti = (PFNGLLIGHTIPROC) loadFunction("glLighti");
    glLightiv = (PFNGLLIGHTIVPROC) loadFunction("glLightiv");
    glLineStipple = (PFNGLLINESTIPPLEPROC) loadFunction("glLineStipple");
    glLineWidth = (PFNGLLINEWIDTHPROC) loadFunction("glLineWidth");
    glLinkProgram = (PFNGLLINKPROGRAMPROC) loadFunction("glLinkProgram");
    glLinkProgramARB = (PFNGLLINKPROGRAMARBPROC) loadFunction("glLinkProgramARB");
    glListBase = (PFNGLLISTBASEPROC) loadFunction("glListBase");
    glListDrawCommandsStatesClientNV = (PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC) loadFunction("glListDrawCommandsStatesClientNV");
    glLoadIdentity = (PFNGLLOADIDENTITYPROC) loadFunction("glLoadIdentity");
    glLoadMatrixd = (PFNGLLOADMATRIXDPROC) loadFunction("glLoadMatrixd");
    glLoadMatrixf = (PFNGLLOADMATRIXFPROC) loadFunction("glLoadMatrixf");
    glLoadName = (PFNGLLOADNAMEPROC) loadFunction("glLoadName");
    glLoadProgramNV = (PFNGLLOADPROGRAMNVPROC) loadFunction("glLoadProgramNV");
    glLoadTransposeMatrixd = (PFNGLLOADTRANSPOSEMATRIXDPROC) loadFunction("glLoadTransposeMatrixd");
    glLoadTransposeMatrixdARB = (PFNGLLOADTRANSPOSEMATRIXDARBPROC) loadFunction("glLoadTransposeMatrixdARB");
    glLoadTransposeMatrixf = (PFNGLLOADTRANSPOSEMATRIXFPROC) loadFunction("glLoadTransposeMatrixf");
    glLoadTransposeMatrixfARB = (PFNGLLOADTRANSPOSEMATRIXFARBPROC) loadFunction("glLoadTransposeMatrixfARB");
    glLockArraysEXT = (PFNGLLOCKARRAYSEXTPROC) loadFunction("glLockArraysEXT");
    glLogicOp = (PFNGLLOGICOPPROC) loadFunction("glLogicOp");
    glMakeBufferNonResidentNV = (PFNGLMAKEBUFFERNONRESIDENTNVPROC) loadFunction("glMakeBufferNonResidentNV");
    glMakeBufferResidentNV = (PFNGLMAKEBUFFERRESIDENTNVPROC) loadFunction("glMakeBufferResidentNV");
    glMakeImageHandleNonResidentARB = (PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC) loadFunction("glMakeImageHandleNonResidentARB");
    glMakeImageHandleNonResidentNV = (PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC) loadFunction("glMakeImageHandleNonResidentNV");
    glMakeImageHandleResidentARB = (PFNGLMAKEIMAGEHANDLERESIDENTARBPROC) loadFunction("glMakeImageHandleResidentARB");
    glMakeImageHandleResidentNV = (PFNGLMAKEIMAGEHANDLERESIDENTNVPROC) loadFunction("glMakeImageHandleResidentNV");
    glMakeNamedBufferNonResidentNV = (PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC) loadFunction("glMakeNamedBufferNonResidentNV");
    glMakeNamedBufferResidentNV = (PFNGLMAKENAMEDBUFFERRESIDENTNVPROC) loadFunction("glMakeNamedBufferResidentNV");
    glMakeTextureHandleNonResidentARB = (PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC) loadFunction("glMakeTextureHandleNonResidentARB");
    glMakeTextureHandleNonResidentNV = (PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC) loadFunction("glMakeTextureHandleNonResidentNV");
    glMakeTextureHandleResidentARB = (PFNGLMAKETEXTUREHANDLERESIDENTARBPROC) loadFunction("glMakeTextureHandleResidentARB");
    glMakeTextureHandleResidentNV = (PFNGLMAKETEXTUREHANDLERESIDENTNVPROC) loadFunction("glMakeTextureHandleResidentNV");
    glMap1d = (PFNGLMAP1DPROC) loadFunction("glMap1d");
    glMap1f = (PFNGLMAP1FPROC) loadFunction("glMap1f");
    glMap2d = (PFNGLMAP2DPROC) loadFunction("glMap2d");
    glMap2f = (PFNGLMAP2FPROC) loadFunction("glMap2f");
    glMapBuffer = (PFNGLMAPBUFFERPROC) loadFunction("glMapBuffer");
    glMapBufferARB = (PFNGLMAPBUFFERARBPROC) loadFunction("glMapBufferARB");
    glMapBufferRange = (PFNGLMAPBUFFERRANGEPROC) loadFunction("glMapBufferRange");
    glMapControlPointsNV = (PFNGLMAPCONTROLPOINTSNVPROC) loadFunction("glMapControlPointsNV");
    glMapGrid1d = (PFNGLMAPGRID1DPROC) loadFunction("glMapGrid1d");
    glMapGrid1f = (PFNGLMAPGRID1FPROC) loadFunction("glMapGrid1f");
    glMapGrid2d = (PFNGLMAPGRID2DPROC) loadFunction("glMapGrid2d");
    glMapGrid2f = (PFNGLMAPGRID2FPROC) loadFunction("glMapGrid2f");
    glMapNamedBuffer = (PFNGLMAPNAMEDBUFFERPROC) loadFunction("glMapNamedBuffer");
    glMapNamedBufferEXT = (PFNGLMAPNAMEDBUFFEREXTPROC) loadFunction("glMapNamedBufferEXT");
    glMapNamedBufferRange = (PFNGLMAPNAMEDBUFFERRANGEPROC) loadFunction("glMapNamedBufferRange");
    glMapNamedBufferRangeEXT = (PFNGLMAPNAMEDBUFFERRANGEEXTPROC) loadFunction("glMapNamedBufferRangeEXT");
    glMapParameterfvNV = (PFNGLMAPPARAMETERFVNVPROC) loadFunction("glMapParameterfvNV");
    glMapParameterivNV = (PFNGLMAPPARAMETERIVNVPROC) loadFunction("glMapParameterivNV");
    glMapTexture2DINTEL = (PFNGLMAPTEXTURE2DINTELPROC) loadFunction("glMapTexture2DINTEL");
    glMapVertexAttrib1dAPPLE = (PFNGLMAPVERTEXATTRIB1DAPPLEPROC) loadFunction("glMapVertexAttrib1dAPPLE");
    glMapVertexAttrib1fAPPLE = (PFNGLMAPVERTEXATTRIB1FAPPLEPROC) loadFunction("glMapVertexAttrib1fAPPLE");
    glMapVertexAttrib2dAPPLE = (PFNGLMAPVERTEXATTRIB2DAPPLEPROC) loadFunction("glMapVertexAttrib2dAPPLE");
    glMapVertexAttrib2fAPPLE = (PFNGLMAPVERTEXATTRIB2FAPPLEPROC) loadFunction("glMapVertexAttrib2fAPPLE");
    glMaterialf = (PFNGLMATERIALFPROC) loadFunction("glMaterialf");
    glMaterialfv = (PFNGLMATERIALFVPROC) loadFunction("glMaterialfv");
    glMateriali = (PFNGLMATERIALIPROC) loadFunction("glMateriali");
    glMaterialiv = (PFNGLMATERIALIVPROC) loadFunction("glMaterialiv");
    glMatrixFrustumEXT = (PFNGLMATRIXFRUSTUMEXTPROC) loadFunction("glMatrixFrustumEXT");
    glMatrixIndexPointerARB = (PFNGLMATRIXINDEXPOINTERARBPROC) loadFunction("glMatrixIndexPointerARB");
    glMatrixIndexubvARB = (PFNGLMATRIXINDEXUBVARBPROC) loadFunction("glMatrixIndexubvARB");
    glMatrixIndexuivARB = (PFNGLMATRIXINDEXUIVARBPROC) loadFunction("glMatrixIndexuivARB");
    glMatrixIndexusvARB = (PFNGLMATRIXINDEXUSVARBPROC) loadFunction("glMatrixIndexusvARB");
    glMatrixLoad3x2fNV = (PFNGLMATRIXLOAD3X2FNVPROC) loadFunction("glMatrixLoad3x2fNV");
    glMatrixLoad3x3fNV = (PFNGLMATRIXLOAD3X3FNVPROC) loadFunction("glMatrixLoad3x3fNV");
    glMatrixLoadIdentityEXT = (PFNGLMATRIXLOADIDENTITYEXTPROC) loadFunction("glMatrixLoadIdentityEXT");
    glMatrixLoadTranspose3x3fNV = (PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC) loadFunction("glMatrixLoadTranspose3x3fNV");
    glMatrixLoadTransposedEXT = (PFNGLMATRIXLOADTRANSPOSEDEXTPROC) loadFunction("glMatrixLoadTransposedEXT");
    glMatrixLoadTransposefEXT = (PFNGLMATRIXLOADTRANSPOSEFEXTPROC) loadFunction("glMatrixLoadTransposefEXT");
    glMatrixLoaddEXT = (PFNGLMATRIXLOADDEXTPROC) loadFunction("glMatrixLoaddEXT");
    glMatrixLoadfEXT = (PFNGLMATRIXLOADFEXTPROC) loadFunction("glMatrixLoadfEXT");
    glMatrixMode = (PFNGLMATRIXMODEPROC) loadFunction("glMatrixMode");
    glMatrixMult3x2fNV = (PFNGLMATRIXMULT3X2FNVPROC) loadFunction("glMatrixMult3x2fNV");
    glMatrixMult3x3fNV = (PFNGLMATRIXMULT3X3FNVPROC) loadFunction("glMatrixMult3x3fNV");
    glMatrixMultTranspose3x3fNV = (PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC) loadFunction("glMatrixMultTranspose3x3fNV");
    glMatrixMultTransposedEXT = (PFNGLMATRIXMULTTRANSPOSEDEXTPROC) loadFunction("glMatrixMultTransposedEXT");
    glMatrixMultTransposefEXT = (PFNGLMATRIXMULTTRANSPOSEFEXTPROC) loadFunction("glMatrixMultTransposefEXT");
    glMatrixMultdEXT = (PFNGLMATRIXMULTDEXTPROC) loadFunction("glMatrixMultdEXT");
    glMatrixMultfEXT = (PFNGLMATRIXMULTFEXTPROC) loadFunction("glMatrixMultfEXT");
    glMatrixOrthoEXT = (PFNGLMATRIXORTHOEXTPROC) loadFunction("glMatrixOrthoEXT");
    glMatrixPopEXT = (PFNGLMATRIXPOPEXTPROC) loadFunction("glMatrixPopEXT");
    glMatrixPushEXT = (PFNGLMATRIXPUSHEXTPROC) loadFunction("glMatrixPushEXT");
    glMatrixRotatedEXT = (PFNGLMATRIXROTATEDEXTPROC) loadFunction("glMatrixRotatedEXT");
    glMatrixRotatefEXT = (PFNGLMATRIXROTATEFEXTPROC) loadFunction("glMatrixRotatefEXT");
    glMatrixScaledEXT = (PFNGLMATRIXSCALEDEXTPROC) loadFunction("glMatrixScaledEXT");
    glMatrixScalefEXT = (PFNGLMATRIXSCALEFEXTPROC) loadFunction("glMatrixScalefEXT");
    glMatrixTranslatedEXT = (PFNGLMATRIXTRANSLATEDEXTPROC) loadFunction("glMatrixTranslatedEXT");
    glMatrixTranslatefEXT = (PFNGLMATRIXTRANSLATEFEXTPROC) loadFunction("glMatrixTranslatefEXT");
    glMaxShaderCompilerThreadsKHR = (PFNGLMAXSHADERCOMPILERTHREADSKHRPROC) loadFunction("glMaxShaderCompilerThreadsKHR");
    glMaxShaderCompilerThreadsARB = (PFNGLMAXSHADERCOMPILERTHREADSARBPROC) loadFunction("glMaxShaderCompilerThreadsARB");
    glMemoryBarrier = (PFNGLMEMORYBARRIERPROC) loadFunction("glMemoryBarrier");
    glMemoryBarrierByRegion = (PFNGLMEMORYBARRIERBYREGIONPROC) loadFunction("glMemoryBarrierByRegion");
    glMemoryBarrierEXT = (PFNGLMEMORYBARRIEREXTPROC) loadFunction("glMemoryBarrierEXT");
    glMemoryObjectParameterivEXT = (PFNGLMEMORYOBJECTPARAMETERIVEXTPROC) loadFunction("glMemoryObjectParameterivEXT");
    glMinSampleShading = (PFNGLMINSAMPLESHADINGPROC) loadFunction("glMinSampleShading");
    glMinSampleShadingARB = (PFNGLMINSAMPLESHADINGARBPROC) loadFunction("glMinSampleShadingARB");
    glMinmax = (PFNGLMINMAXPROC) loadFunction("glMinmax");
    glMinmaxEXT = (PFNGLMINMAXEXTPROC) loadFunction("glMinmaxEXT");
    glMultMatrixd = (PFNGLMULTMATRIXDPROC) loadFunction("glMultMatrixd");
    glMultMatrixf = (PFNGLMULTMATRIXFPROC) loadFunction("glMultMatrixf");
    glMultTransposeMatrixd = (PFNGLMULTTRANSPOSEMATRIXDPROC) loadFunction("glMultTransposeMatrixd");
    glMultTransposeMatrixdARB = (PFNGLMULTTRANSPOSEMATRIXDARBPROC) loadFunction("glMultTransposeMatrixdARB");
    glMultTransposeMatrixf = (PFNGLMULTTRANSPOSEMATRIXFPROC) loadFunction("glMultTransposeMatrixf");
    glMultTransposeMatrixfARB = (PFNGLMULTTRANSPOSEMATRIXFARBPROC) loadFunction("glMultTransposeMatrixfARB");
    glMultiDrawArrays = (PFNGLMULTIDRAWARRAYSPROC) loadFunction("glMultiDrawArrays");
    glMultiDrawArraysEXT = (PFNGLMULTIDRAWARRAYSEXTPROC) loadFunction("glMultiDrawArraysEXT");
    glMultiDrawArraysIndirect = (PFNGLMULTIDRAWARRAYSINDIRECTPROC) loadFunction("glMultiDrawArraysIndirect");
    glMultiDrawArraysIndirectAMD = (PFNGLMULTIDRAWARRAYSINDIRECTAMDPROC) loadFunction("glMultiDrawArraysIndirectAMD");
    glMultiDrawArraysIndirectBindlessCountNV = (PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC) loadFunction("glMultiDrawArraysIndirectBindlessCountNV");
    glMultiDrawArraysIndirectBindlessNV = (PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC) loadFunction("glMultiDrawArraysIndirectBindlessNV");
    glMultiDrawArraysIndirectCount = (PFNGLMULTIDRAWARRAYSINDIRECTCOUNTPROC) loadFunction("glMultiDrawArraysIndirectCount");
    glMultiDrawArraysIndirectCountARB = (PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC) loadFunction("glMultiDrawArraysIndirectCountARB");
    glMultiDrawElementArrayAPPLE = (PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC) loadFunction("glMultiDrawElementArrayAPPLE");
    glMultiDrawElements = (PFNGLMULTIDRAWELEMENTSPROC) loadFunction("glMultiDrawElements");
    glMultiDrawElementsBaseVertex = (PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC) loadFunction("glMultiDrawElementsBaseVertex");
    glMultiDrawElementsEXT = (PFNGLMULTIDRAWELEMENTSEXTPROC) loadFunction("glMultiDrawElementsEXT");
    glMultiDrawElementsIndirect = (PFNGLMULTIDRAWELEMENTSINDIRECTPROC) loadFunction("glMultiDrawElementsIndirect");
    glMultiDrawElementsIndirectAMD = (PFNGLMULTIDRAWELEMENTSINDIRECTAMDPROC) loadFunction("glMultiDrawElementsIndirectAMD");
    glMultiDrawElementsIndirectBindlessCountNV = (PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC) loadFunction("glMultiDrawElementsIndirectBindlessCountNV");
    glMultiDrawElementsIndirectBindlessNV = (PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC) loadFunction("glMultiDrawElementsIndirectBindlessNV");
    glMultiDrawElementsIndirectCount = (PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTPROC) loadFunction("glMultiDrawElementsIndirectCount");
    glMultiDrawElementsIndirectCountARB = (PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC) loadFunction("glMultiDrawElementsIndirectCountARB");
    glMultiDrawMeshTasksIndirectNV = (PFNGLMULTIDRAWMESHTASKSINDIRECTNVPROC) loadFunction("glMultiDrawMeshTasksIndirectNV");
    glMultiDrawMeshTasksIndirectCountNV = (PFNGLMULTIDRAWMESHTASKSINDIRECTCOUNTNVPROC) loadFunction("glMultiDrawMeshTasksIndirectCountNV");
    glMultiDrawRangeElementArrayAPPLE = (PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC) loadFunction("glMultiDrawRangeElementArrayAPPLE");
    glMultiTexBufferEXT = (PFNGLMULTITEXBUFFEREXTPROC) loadFunction("glMultiTexBufferEXT");
    glMultiTexCoord1d = (PFNGLMULTITEXCOORD1DPROC) loadFunction("glMultiTexCoord1d");
    glMultiTexCoord1dARB = (PFNGLMULTITEXCOORD1DARBPROC) loadFunction("glMultiTexCoord1dARB");
    glMultiTexCoord1dv = (PFNGLMULTITEXCOORD1DVPROC) loadFunction("glMultiTexCoord1dv");
    glMultiTexCoord1dvARB = (PFNGLMULTITEXCOORD1DVARBPROC) loadFunction("glMultiTexCoord1dvARB");
    glMultiTexCoord1f = (PFNGLMULTITEXCOORD1FPROC) loadFunction("glMultiTexCoord1f");
    glMultiTexCoord1fARB = (PFNGLMULTITEXCOORD1FARBPROC) loadFunction("glMultiTexCoord1fARB");
    glMultiTexCoord1fv = (PFNGLMULTITEXCOORD1FVPROC) loadFunction("glMultiTexCoord1fv");
    glMultiTexCoord1fvARB = (PFNGLMULTITEXCOORD1FVARBPROC) loadFunction("glMultiTexCoord1fvARB");
    glMultiTexCoord1hNV = (PFNGLMULTITEXCOORD1HNVPROC) loadFunction("glMultiTexCoord1hNV");
    glMultiTexCoord1hvNV = (PFNGLMULTITEXCOORD1HVNVPROC) loadFunction("glMultiTexCoord1hvNV");
    glMultiTexCoord1i = (PFNGLMULTITEXCOORD1IPROC) loadFunction("glMultiTexCoord1i");
    glMultiTexCoord1iARB = (PFNGLMULTITEXCOORD1IARBPROC) loadFunction("glMultiTexCoord1iARB");
    glMultiTexCoord1iv = (PFNGLMULTITEXCOORD1IVPROC) loadFunction("glMultiTexCoord1iv");
    glMultiTexCoord1ivARB = (PFNGLMULTITEXCOORD1IVARBPROC) loadFunction("glMultiTexCoord1ivARB");
    glMultiTexCoord1s = (PFNGLMULTITEXCOORD1SPROC) loadFunction("glMultiTexCoord1s");
    glMultiTexCoord1sARB = (PFNGLMULTITEXCOORD1SARBPROC) loadFunction("glMultiTexCoord1sARB");
    glMultiTexCoord1sv = (PFNGLMULTITEXCOORD1SVPROC) loadFunction("glMultiTexCoord1sv");
    glMultiTexCoord1svARB = (PFNGLMULTITEXCOORD1SVARBPROC) loadFunction("glMultiTexCoord1svARB");
    glMultiTexCoord2d = (PFNGLMULTITEXCOORD2DPROC) loadFunction("glMultiTexCoord2d");
    glMultiTexCoord2dARB = (PFNGLMULTITEXCOORD2DARBPROC) loadFunction("glMultiTexCoord2dARB");
    glMultiTexCoord2dv = (PFNGLMULTITEXCOORD2DVPROC) loadFunction("glMultiTexCoord2dv");
    glMultiTexCoord2dvARB = (PFNGLMULTITEXCOORD2DVARBPROC) loadFunction("glMultiTexCoord2dvARB");
    glMultiTexCoord2f = (PFNGLMULTITEXCOORD2FPROC) loadFunction("glMultiTexCoord2f");
    glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC) loadFunction("glMultiTexCoord2fARB");
    glMultiTexCoord2fv = (PFNGLMULTITEXCOORD2FVPROC) loadFunction("glMultiTexCoord2fv");
    glMultiTexCoord2fvARB = (PFNGLMULTITEXCOORD2FVARBPROC) loadFunction("glMultiTexCoord2fvARB");
    glMultiTexCoord2hNV = (PFNGLMULTITEXCOORD2HNVPROC) loadFunction("glMultiTexCoord2hNV");
    glMultiTexCoord2hvNV = (PFNGLMULTITEXCOORD2HVNVPROC) loadFunction("glMultiTexCoord2hvNV");
    glMultiTexCoord2i = (PFNGLMULTITEXCOORD2IPROC) loadFunction("glMultiTexCoord2i");
    glMultiTexCoord2iARB = (PFNGLMULTITEXCOORD2IARBPROC) loadFunction("glMultiTexCoord2iARB");
    glMultiTexCoord2iv = (PFNGLMULTITEXCOORD2IVPROC) loadFunction("glMultiTexCoord2iv");
    glMultiTexCoord2ivARB = (PFNGLMULTITEXCOORD2IVARBPROC) loadFunction("glMultiTexCoord2ivARB");
    glMultiTexCoord2s = (PFNGLMULTITEXCOORD2SPROC) loadFunction("glMultiTexCoord2s");
    glMultiTexCoord2sARB = (PFNGLMULTITEXCOORD2SARBPROC) loadFunction("glMultiTexCoord2sARB");
    glMultiTexCoord2sv = (PFNGLMULTITEXCOORD2SVPROC) loadFunction("glMultiTexCoord2sv");
    glMultiTexCoord2svARB = (PFNGLMULTITEXCOORD2SVARBPROC) loadFunction("glMultiTexCoord2svARB");
    glMultiTexCoord3d = (PFNGLMULTITEXCOORD3DPROC) loadFunction("glMultiTexCoord3d");
    glMultiTexCoord3dARB = (PFNGLMULTITEXCOORD3DARBPROC) loadFunction("glMultiTexCoord3dARB");
    glMultiTexCoord3dv = (PFNGLMULTITEXCOORD3DVPROC) loadFunction("glMultiTexCoord3dv");
    glMultiTexCoord3dvARB = (PFNGLMULTITEXCOORD3DVARBPROC) loadFunction("glMultiTexCoord3dvARB");
    glMultiTexCoord3f = (PFNGLMULTITEXCOORD3FPROC) loadFunction("glMultiTexCoord3f");
    glMultiTexCoord3fARB = (PFNGLMULTITEXCOORD3FARBPROC) loadFunction("glMultiTexCoord3fARB");
    glMultiTexCoord3fv = (PFNGLMULTITEXCOORD3FVPROC) loadFunction("glMultiTexCoord3fv");
    glMultiTexCoord3fvARB = (PFNGLMULTITEXCOORD3FVARBPROC) loadFunction("glMultiTexCoord3fvARB");
    glMultiTexCoord3hNV = (PFNGLMULTITEXCOORD3HNVPROC) loadFunction("glMultiTexCoord3hNV");
    glMultiTexCoord3hvNV = (PFNGLMULTITEXCOORD3HVNVPROC) loadFunction("glMultiTexCoord3hvNV");
    glMultiTexCoord3i = (PFNGLMULTITEXCOORD3IPROC) loadFunction("glMultiTexCoord3i");
    glMultiTexCoord3iARB = (PFNGLMULTITEXCOORD3IARBPROC) loadFunction("glMultiTexCoord3iARB");
    glMultiTexCoord3iv = (PFNGLMULTITEXCOORD3IVPROC) loadFunction("glMultiTexCoord3iv");
    glMultiTexCoord3ivARB = (PFNGLMULTITEXCOORD3IVARBPROC) loadFunction("glMultiTexCoord3ivARB");
    glMultiTexCoord3s = (PFNGLMULTITEXCOORD3SPROC) loadFunction("glMultiTexCoord3s");
    glMultiTexCoord3sARB = (PFNGLMULTITEXCOORD3SARBPROC) loadFunction("glMultiTexCoord3sARB");
    glMultiTexCoord3sv = (PFNGLMULTITEXCOORD3SVPROC) loadFunction("glMultiTexCoord3sv");
    glMultiTexCoord3svARB = (PFNGLMULTITEXCOORD3SVARBPROC) loadFunction("glMultiTexCoord3svARB");
    glMultiTexCoord4d = (PFNGLMULTITEXCOORD4DPROC) loadFunction("glMultiTexCoord4d");
    glMultiTexCoord4dARB = (PFNGLMULTITEXCOORD4DARBPROC) loadFunction("glMultiTexCoord4dARB");
    glMultiTexCoord4dv = (PFNGLMULTITEXCOORD4DVPROC) loadFunction("glMultiTexCoord4dv");
    glMultiTexCoord4dvARB = (PFNGLMULTITEXCOORD4DVARBPROC) loadFunction("glMultiTexCoord4dvARB");
    glMultiTexCoord4f = (PFNGLMULTITEXCOORD4FPROC) loadFunction("glMultiTexCoord4f");
    glMultiTexCoord4fARB = (PFNGLMULTITEXCOORD4FARBPROC) loadFunction("glMultiTexCoord4fARB");
    glMultiTexCoord4fv = (PFNGLMULTITEXCOORD4FVPROC) loadFunction("glMultiTexCoord4fv");
    glMultiTexCoord4fvARB = (PFNGLMULTITEXCOORD4FVARBPROC) loadFunction("glMultiTexCoord4fvARB");
    glMultiTexCoord4hNV = (PFNGLMULTITEXCOORD4HNVPROC) loadFunction("glMultiTexCoord4hNV");
    glMultiTexCoord4hvNV = (PFNGLMULTITEXCOORD4HVNVPROC) loadFunction("glMultiTexCoord4hvNV");
    glMultiTexCoord4i = (PFNGLMULTITEXCOORD4IPROC) loadFunction("glMultiTexCoord4i");
    glMultiTexCoord4iARB = (PFNGLMULTITEXCOORD4IARBPROC) loadFunction("glMultiTexCoord4iARB");
    glMultiTexCoord4iv = (PFNGLMULTITEXCOORD4IVPROC) loadFunction("glMultiTexCoord4iv");
    glMultiTexCoord4ivARB = (PFNGLMULTITEXCOORD4IVARBPROC) loadFunction("glMultiTexCoord4ivARB");
    glMultiTexCoord4s = (PFNGLMULTITEXCOORD4SPROC) loadFunction("glMultiTexCoord4s");
    glMultiTexCoord4sARB = (PFNGLMULTITEXCOORD4SARBPROC) loadFunction("glMultiTexCoord4sARB");
    glMultiTexCoord4sv = (PFNGLMULTITEXCOORD4SVPROC) loadFunction("glMultiTexCoord4sv");
    glMultiTexCoord4svARB = (PFNGLMULTITEXCOORD4SVARBPROC) loadFunction("glMultiTexCoord4svARB");
    glMultiTexCoordP1ui = (PFNGLMULTITEXCOORDP1UIPROC) loadFunction("glMultiTexCoordP1ui");
    glMultiTexCoordP1uiv = (PFNGLMULTITEXCOORDP1UIVPROC) loadFunction("glMultiTexCoordP1uiv");
    glMultiTexCoordP2ui = (PFNGLMULTITEXCOORDP2UIPROC) loadFunction("glMultiTexCoordP2ui");
    glMultiTexCoordP2uiv = (PFNGLMULTITEXCOORDP2UIVPROC) loadFunction("glMultiTexCoordP2uiv");
    glMultiTexCoordP3ui = (PFNGLMULTITEXCOORDP3UIPROC) loadFunction("glMultiTexCoordP3ui");
    glMultiTexCoordP3uiv = (PFNGLMULTITEXCOORDP3UIVPROC) loadFunction("glMultiTexCoordP3uiv");
    glMultiTexCoordP4ui = (PFNGLMULTITEXCOORDP4UIPROC) loadFunction("glMultiTexCoordP4ui");
    glMultiTexCoordP4uiv = (PFNGLMULTITEXCOORDP4UIVPROC) loadFunction("glMultiTexCoordP4uiv");
    glMultiTexCoordPointerEXT = (PFNGLMULTITEXCOORDPOINTEREXTPROC) loadFunction("glMultiTexCoordPointerEXT");
    glMultiTexEnvfEXT = (PFNGLMULTITEXENVFEXTPROC) loadFunction("glMultiTexEnvfEXT");
    glMultiTexEnvfvEXT = (PFNGLMULTITEXENVFVEXTPROC) loadFunction("glMultiTexEnvfvEXT");
    glMultiTexEnviEXT = (PFNGLMULTITEXENVIEXTPROC) loadFunction("glMultiTexEnviEXT");
    glMultiTexEnvivEXT = (PFNGLMULTITEXENVIVEXTPROC) loadFunction("glMultiTexEnvivEXT");
    glMultiTexGendEXT = (PFNGLMULTITEXGENDEXTPROC) loadFunction("glMultiTexGendEXT");
    glMultiTexGendvEXT = (PFNGLMULTITEXGENDVEXTPROC) loadFunction("glMultiTexGendvEXT");
    glMultiTexGenfEXT = (PFNGLMULTITEXGENFEXTPROC) loadFunction("glMultiTexGenfEXT");
    glMultiTexGenfvEXT = (PFNGLMULTITEXGENFVEXTPROC) loadFunction("glMultiTexGenfvEXT");
    glMultiTexGeniEXT = (PFNGLMULTITEXGENIEXTPROC) loadFunction("glMultiTexGeniEXT");
    glMultiTexGenivEXT = (PFNGLMULTITEXGENIVEXTPROC) loadFunction("glMultiTexGenivEXT");
    glMultiTexImage1DEXT = (PFNGLMULTITEXIMAGE1DEXTPROC) loadFunction("glMultiTexImage1DEXT");
    glMultiTexImage2DEXT = (PFNGLMULTITEXIMAGE2DEXTPROC) loadFunction("glMultiTexImage2DEXT");
    glMultiTexImage3DEXT = (PFNGLMULTITEXIMAGE3DEXTPROC) loadFunction("glMultiTexImage3DEXT");
    glMultiTexParameterIivEXT = (PFNGLMULTITEXPARAMETERIIVEXTPROC) loadFunction("glMultiTexParameterIivEXT");
    glMultiTexParameterIuivEXT = (PFNGLMULTITEXPARAMETERIUIVEXTPROC) loadFunction("glMultiTexParameterIuivEXT");
    glMultiTexParameterfEXT = (PFNGLMULTITEXPARAMETERFEXTPROC) loadFunction("glMultiTexParameterfEXT");
    glMultiTexParameterfvEXT = (PFNGLMULTITEXPARAMETERFVEXTPROC) loadFunction("glMultiTexParameterfvEXT");
    glMultiTexParameteriEXT = (PFNGLMULTITEXPARAMETERIEXTPROC) loadFunction("glMultiTexParameteriEXT");
    glMultiTexParameterivEXT = (PFNGLMULTITEXPARAMETERIVEXTPROC) loadFunction("glMultiTexParameterivEXT");
    glMultiTexRenderbufferEXT = (PFNGLMULTITEXRENDERBUFFEREXTPROC) loadFunction("glMultiTexRenderbufferEXT");
    glMultiTexSubImage1DEXT = (PFNGLMULTITEXSUBIMAGE1DEXTPROC) loadFunction("glMultiTexSubImage1DEXT");
    glMultiTexSubImage2DEXT = (PFNGLMULTITEXSUBIMAGE2DEXTPROC) loadFunction("glMultiTexSubImage2DEXT");
    glMultiTexSubImage3DEXT = (PFNGLMULTITEXSUBIMAGE3DEXTPROC) loadFunction("glMultiTexSubImage3DEXT");
    glMulticastBarrierNV = (PFNGLMULTICASTBARRIERNVPROC) loadFunction("glMulticastBarrierNV");
    glMulticastBlitFramebufferNV = (PFNGLMULTICASTBLITFRAMEBUFFERNVPROC) loadFunction("glMulticastBlitFramebufferNV");
    glMulticastBufferSubDataNV = (PFNGLMULTICASTBUFFERSUBDATANVPROC) loadFunction("glMulticastBufferSubDataNV");
    glMulticastCopyBufferSubDataNV = (PFNGLMULTICASTCOPYBUFFERSUBDATANVPROC) loadFunction("glMulticastCopyBufferSubDataNV");
    glMulticastCopyImageSubDataNV = (PFNGLMULTICASTCOPYIMAGESUBDATANVPROC) loadFunction("glMulticastCopyImageSubDataNV");
    glMulticastFramebufferSampleLocationsfvNV = (PFNGLMULTICASTFRAMEBUFFERSAMPLELOCATIONSFVNVPROC) loadFunction("glMulticastFramebufferSampleLocationsfvNV");
    glMulticastGetQueryObjecti64vNV = (PFNGLMULTICASTGETQUERYOBJECTI64VNVPROC) loadFunction("glMulticastGetQueryObjecti64vNV");
    glMulticastGetQueryObjectivNV = (PFNGLMULTICASTGETQUERYOBJECTIVNVPROC) loadFunction("glMulticastGetQueryObjectivNV");
    glMulticastGetQueryObjectui64vNV = (PFNGLMULTICASTGETQUERYOBJECTUI64VNVPROC) loadFunction("glMulticastGetQueryObjectui64vNV");
    glMulticastGetQueryObjectuivNV = (PFNGLMULTICASTGETQUERYOBJECTUIVNVPROC) loadFunction("glMulticastGetQueryObjectuivNV");
    glMulticastWaitSyncNV = (PFNGLMULTICASTWAITSYNCNVPROC) loadFunction("glMulticastWaitSyncNV");
    glNamedBufferAttachMemoryNV = (PFNGLNAMEDBUFFERATTACHMEMORYNVPROC) loadFunction("glNamedBufferAttachMemoryNV");
    glNamedBufferData = (PFNGLNAMEDBUFFERDATAPROC) loadFunction("glNamedBufferData");
    glNamedBufferDataEXT = (PFNGLNAMEDBUFFERDATAEXTPROC) loadFunction("glNamedBufferDataEXT");
    glNamedBufferPageCommitmentARB = (PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC) loadFunction("glNamedBufferPageCommitmentARB");
    glNamedBufferPageCommitmentEXT = (PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC) loadFunction("glNamedBufferPageCommitmentEXT");
    glNamedBufferStorage = (PFNGLNAMEDBUFFERSTORAGEPROC) loadFunction("glNamedBufferStorage");
    glNamedBufferStorageExternalEXT = (PFNGLNAMEDBUFFERSTORAGEEXTERNALEXTPROC) loadFunction("glNamedBufferStorageExternalEXT");
    glNamedBufferStorageEXT = (PFNGLNAMEDBUFFERSTORAGEEXTPROC) loadFunction("glNamedBufferStorageEXT");
    glNamedBufferStorageMemEXT = (PFNGLNAMEDBUFFERSTORAGEMEMEXTPROC) loadFunction("glNamedBufferStorageMemEXT");
    glNamedBufferSubData = (PFNGLNAMEDBUFFERSUBDATAPROC) loadFunction("glNamedBufferSubData");
    glNamedBufferSubDataEXT = (PFNGLNAMEDBUFFERSUBDATAEXTPROC) loadFunction("glNamedBufferSubDataEXT");
    glNamedCopyBufferSubDataEXT = (PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC) loadFunction("glNamedCopyBufferSubDataEXT");
    glNamedFramebufferDrawBuffer = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC) loadFunction("glNamedFramebufferDrawBuffer");
    glNamedFramebufferDrawBuffers = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC) loadFunction("glNamedFramebufferDrawBuffers");
    glNamedFramebufferParameteri = (PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC) loadFunction("glNamedFramebufferParameteri");
    glNamedFramebufferParameteriEXT = (PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC) loadFunction("glNamedFramebufferParameteriEXT");
    glNamedFramebufferReadBuffer = (PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC) loadFunction("glNamedFramebufferReadBuffer");
    glNamedFramebufferRenderbuffer = (PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC) loadFunction("glNamedFramebufferRenderbuffer");
    glNamedFramebufferRenderbufferEXT = (PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC) loadFunction("glNamedFramebufferRenderbufferEXT");
    glNamedFramebufferSampleLocationsfvARB = (PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVARBPROC) loadFunction("glNamedFramebufferSampleLocationsfvARB");
    glNamedFramebufferSampleLocationsfvNV = (PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC) loadFunction("glNamedFramebufferSampleLocationsfvNV");
    glNamedFramebufferTexture = (PFNGLNAMEDFRAMEBUFFERTEXTUREPROC) loadFunction("glNamedFramebufferTexture");
    glNamedFramebufferSamplePositionsfvAMD = (PFNGLNAMEDFRAMEBUFFERSAMPLEPOSITIONSFVAMDPROC) loadFunction("glNamedFramebufferSamplePositionsfvAMD");
    glNamedFramebufferTexture1DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC) loadFunction("glNamedFramebufferTexture1DEXT");
    glNamedFramebufferTexture2DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC) loadFunction("glNamedFramebufferTexture2DEXT");
    glNamedFramebufferTexture3DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC) loadFunction("glNamedFramebufferTexture3DEXT");
    glNamedFramebufferTextureEXT = (PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC) loadFunction("glNamedFramebufferTextureEXT");
    glNamedFramebufferTextureFaceEXT = (PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC) loadFunction("glNamedFramebufferTextureFaceEXT");
    glNamedFramebufferTextureLayer = (PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC) loadFunction("glNamedFramebufferTextureLayer");
    glNamedFramebufferTextureLayerEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC) loadFunction("glNamedFramebufferTextureLayerEXT");
    glNamedProgramLocalParameter4dEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC) loadFunction("glNamedProgramLocalParameter4dEXT");
    glNamedProgramLocalParameter4dvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC) loadFunction("glNamedProgramLocalParameter4dvEXT");
    glNamedProgramLocalParameter4fEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC) loadFunction("glNamedProgramLocalParameter4fEXT");
    glNamedProgramLocalParameter4fvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC) loadFunction("glNamedProgramLocalParameter4fvEXT");
    glNamedProgramLocalParameterI4iEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC) loadFunction("glNamedProgramLocalParameterI4iEXT");
    glNamedProgramLocalParameterI4ivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC) loadFunction("glNamedProgramLocalParameterI4ivEXT");
    glNamedProgramLocalParameterI4uiEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC) loadFunction("glNamedProgramLocalParameterI4uiEXT");
    glNamedProgramLocalParameterI4uivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC) loadFunction("glNamedProgramLocalParameterI4uivEXT");
    glNamedProgramLocalParameters4fvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC) loadFunction("glNamedProgramLocalParameters4fvEXT");
    glNamedProgramLocalParametersI4ivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC) loadFunction("glNamedProgramLocalParametersI4ivEXT");
    glNamedProgramLocalParametersI4uivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC) loadFunction("glNamedProgramLocalParametersI4uivEXT");
    glNamedProgramStringEXT = (PFNGLNAMEDPROGRAMSTRINGEXTPROC) loadFunction("glNamedProgramStringEXT");
    glNamedRenderbufferStorage = (PFNGLNAMEDRENDERBUFFERSTORAGEPROC) loadFunction("glNamedRenderbufferStorage");
    glNamedRenderbufferStorageEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC) loadFunction("glNamedRenderbufferStorageEXT");
    glNamedRenderbufferStorageMultisample = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC) loadFunction("glNamedRenderbufferStorageMultisample");
    glNamedRenderbufferStorageMultisampleAdvancedAMD = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEADVANCEDAMDPROC) loadFunction("glNamedRenderbufferStorageMultisampleAdvancedAMD");
    glNamedRenderbufferStorageMultisampleCoverageEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC) loadFunction("glNamedRenderbufferStorageMultisampleCoverageEXT");
    glNamedRenderbufferStorageMultisampleEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC) loadFunction("glNamedRenderbufferStorageMultisampleEXT");
    glNamedStringARB = (PFNGLNAMEDSTRINGARBPROC) loadFunction("glNamedStringARB");
    glNewList = (PFNGLNEWLISTPROC) loadFunction("glNewList");
    glNormal3b = (PFNGLNORMAL3BPROC) loadFunction("glNormal3b");
    glNormal3bv = (PFNGLNORMAL3BVPROC) loadFunction("glNormal3bv");
    glNormal3d = (PFNGLNORMAL3DPROC) loadFunction("glNormal3d");
    glNormal3dv = (PFNGLNORMAL3DVPROC) loadFunction("glNormal3dv");
    glNormal3f = (PFNGLNORMAL3FPROC) loadFunction("glNormal3f");
    glNormal3fv = (PFNGLNORMAL3FVPROC) loadFunction("glNormal3fv");
    glNormal3hNV = (PFNGLNORMAL3HNVPROC) loadFunction("glNormal3hNV");
    glNormal3hvNV = (PFNGLNORMAL3HVNVPROC) loadFunction("glNormal3hvNV");
    glNormal3i = (PFNGLNORMAL3IPROC) loadFunction("glNormal3i");
    glNormal3iv = (PFNGLNORMAL3IVPROC) loadFunction("glNormal3iv");
    glNormal3s = (PFNGLNORMAL3SPROC) loadFunction("glNormal3s");
    glNormal3sv = (PFNGLNORMAL3SVPROC) loadFunction("glNormal3sv");
    glNormalFormatNV = (PFNGLNORMALFORMATNVPROC) loadFunction("glNormalFormatNV");
    glNormalP3ui = (PFNGLNORMALP3UIPROC) loadFunction("glNormalP3ui");
    glNormalP3uiv = (PFNGLNORMALP3UIVPROC) loadFunction("glNormalP3uiv");
    glNormalPointer = (PFNGLNORMALPOINTERPROC) loadFunction("glNormalPointer");
    glNormalPointerEXT = (PFNGLNORMALPOINTEREXTPROC) loadFunction("glNormalPointerEXT");
    glNormalPointervINTEL = (PFNGLNORMALPOINTERVINTELPROC) loadFunction("glNormalPointervINTEL");
    glObjectLabel = (PFNGLOBJECTLABELPROC) loadFunction("glObjectLabel");
    glObjectLabelKHR = (PFNGLOBJECTLABELKHRPROC) loadFunction("glObjectLabelKHR");
    glObjectPtrLabel = (PFNGLOBJECTPTRLABELPROC) loadFunction("glObjectPtrLabel");
    glObjectPtrLabelKHR = (PFNGLOBJECTPTRLABELKHRPROC) loadFunction("glObjectPtrLabelKHR");
    glObjectPurgeableAPPLE = (PFNGLOBJECTPURGEABLEAPPLEPROC) loadFunction("glObjectPurgeableAPPLE");
    glObjectUnpurgeableAPPLE = (PFNGLOBJECTUNPURGEABLEAPPLEPROC) loadFunction("glObjectUnpurgeableAPPLE");
    glOrtho = (PFNGLORTHOPROC) loadFunction("glOrtho");
    glPassThrough = (PFNGLPASSTHROUGHPROC) loadFunction("glPassThrough");
    glPatchParameterfv = (PFNGLPATCHPARAMETERFVPROC) loadFunction("glPatchParameterfv");
    glPatchParameteri = (PFNGLPATCHPARAMETERIPROC) loadFunction("glPatchParameteri");
    glPathColorGenNV = (PFNGLPATHCOLORGENNVPROC) loadFunction("glPathColorGenNV");
    glPathCommandsNV = (PFNGLPATHCOMMANDSNVPROC) loadFunction("glPathCommandsNV");
    glPathCoordsNV = (PFNGLPATHCOORDSNVPROC) loadFunction("glPathCoordsNV");
    glPathCoverDepthFuncNV = (PFNGLPATHCOVERDEPTHFUNCNVPROC) loadFunction("glPathCoverDepthFuncNV");
    glPathDashArrayNV = (PFNGLPATHDASHARRAYNVPROC) loadFunction("glPathDashArrayNV");
    glPathFogGenNV = (PFNGLPATHFOGGENNVPROC) loadFunction("glPathFogGenNV");
    glPathGlyphIndexArrayNV = (PFNGLPATHGLYPHINDEXARRAYNVPROC) loadFunction("glPathGlyphIndexArrayNV");
    glPathGlyphIndexRangeNV = (PFNGLPATHGLYPHINDEXRANGENVPROC) loadFunction("glPathGlyphIndexRangeNV");
    glPathGlyphRangeNV = (PFNGLPATHGLYPHRANGENVPROC) loadFunction("glPathGlyphRangeNV");
    glPathGlyphsNV = (PFNGLPATHGLYPHSNVPROC) loadFunction("glPathGlyphsNV");
    glPathMemoryGlyphIndexArrayNV = (PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC) loadFunction("glPathMemoryGlyphIndexArrayNV");
    glPathParameterfNV = (PFNGLPATHPARAMETERFNVPROC) loadFunction("glPathParameterfNV");
    glPathParameterfvNV = (PFNGLPATHPARAMETERFVNVPROC) loadFunction("glPathParameterfvNV");
    glPathParameteriNV = (PFNGLPATHPARAMETERINVPROC) loadFunction("glPathParameteriNV");
    glPathParameterivNV = (PFNGLPATHPARAMETERIVNVPROC) loadFunction("glPathParameterivNV");
    glPathStencilDepthOffsetNV = (PFNGLPATHSTENCILDEPTHOFFSETNVPROC) loadFunction("glPathStencilDepthOffsetNV");
    glPathStencilFuncNV = (PFNGLPATHSTENCILFUNCNVPROC) loadFunction("glPathStencilFuncNV");
    glPathStringNV = (PFNGLPATHSTRINGNVPROC) loadFunction("glPathStringNV");
    glPathSubCommandsNV = (PFNGLPATHSUBCOMMANDSNVPROC) loadFunction("glPathSubCommandsNV");
    glPathSubCoordsNV = (PFNGLPATHSUBCOORDSNVPROC) loadFunction("glPathSubCoordsNV");
    glPathTexGenNV = (PFNGLPATHTEXGENNVPROC) loadFunction("glPathTexGenNV");
    glPauseTransformFeedback = (PFNGLPAUSETRANSFORMFEEDBACKPROC) loadFunction("glPauseTransformFeedback");
    glPauseTransformFeedbackNV = (PFNGLPAUSETRANSFORMFEEDBACKNVPROC) loadFunction("glPauseTransformFeedbackNV");
    glPixelDataRangeNV = (PFNGLPIXELDATARANGENVPROC) loadFunction("glPixelDataRangeNV");
    glPixelMapfv = (PFNGLPIXELMAPFVPROC) loadFunction("glPixelMapfv");
    glPixelMapuiv = (PFNGLPIXELMAPUIVPROC) loadFunction("glPixelMapuiv");
    glPixelMapusv = (PFNGLPIXELMAPUSVPROC) loadFunction("glPixelMapusv");
    glPixelStoref = (PFNGLPIXELSTOREFPROC) loadFunction("glPixelStoref");
    glPixelStorei = (PFNGLPIXELSTOREIPROC) loadFunction("glPixelStorei");
    glPixelTransferf = (PFNGLPIXELTRANSFERFPROC) loadFunction("glPixelTransferf");
    glPixelTransferi = (PFNGLPIXELTRANSFERIPROC) loadFunction("glPixelTransferi");
    glPixelTransformParameterfEXT = (PFNGLPIXELTRANSFORMPARAMETERFEXTPROC) loadFunction("glPixelTransformParameterfEXT");
    glPixelTransformParameterfvEXT = (PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC) loadFunction("glPixelTransformParameterfvEXT");
    glPixelTransformParameteriEXT = (PFNGLPIXELTRANSFORMPARAMETERIEXTPROC) loadFunction("glPixelTransformParameteriEXT");
    glPixelTransformParameterivEXT = (PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC) loadFunction("glPixelTransformParameterivEXT");
    glPixelZoom = (PFNGLPIXELZOOMPROC) loadFunction("glPixelZoom");
    glPointAlongPathNV = (PFNGLPOINTALONGPATHNVPROC) loadFunction("glPointAlongPathNV");
    glPointParameterf = (PFNGLPOINTPARAMETERFPROC) loadFunction("glPointParameterf");
    glPointParameterfARB = (PFNGLPOINTPARAMETERFARBPROC) loadFunction("glPointParameterfARB");
    glPointParameterfEXT = (PFNGLPOINTPARAMETERFEXTPROC) loadFunction("glPointParameterfEXT");
    glPointParameterfv = (PFNGLPOINTPARAMETERFVPROC) loadFunction("glPointParameterfv");
    glPointParameterfvARB = (PFNGLPOINTPARAMETERFVARBPROC) loadFunction("glPointParameterfvARB");
    glPointParameterfvEXT = (PFNGLPOINTPARAMETERFVEXTPROC) loadFunction("glPointParameterfvEXT");
    glPointParameteri = (PFNGLPOINTPARAMETERIPROC) loadFunction("glPointParameteri");
    glPointParameteriNV = (PFNGLPOINTPARAMETERINVPROC) loadFunction("glPointParameteriNV");
    glPointParameteriv = (PFNGLPOINTPARAMETERIVPROC) loadFunction("glPointParameteriv");
    glPointParameterivNV = (PFNGLPOINTPARAMETERIVNVPROC) loadFunction("glPointParameterivNV");
    glPointSize = (PFNGLPOINTSIZEPROC) loadFunction("glPointSize");
    glPolygonMode = (PFNGLPOLYGONMODEPROC) loadFunction("glPolygonMode");
    glPolygonOffset = (PFNGLPOLYGONOFFSETPROC) loadFunction("glPolygonOffset");
    glPolygonOffsetClamp = (PFNGLPOLYGONOFFSETCLAMPPROC) loadFunction("glPolygonOffsetClamp");
    glPolygonOffsetClampEXT = (PFNGLPOLYGONOFFSETCLAMPEXTPROC) loadFunction("glPolygonOffsetClampEXT");
    glPolygonOffsetEXT = (PFNGLPOLYGONOFFSETEXTPROC) loadFunction("glPolygonOffsetEXT");
    glPolygonStipple = (PFNGLPOLYGONSTIPPLEPROC) loadFunction("glPolygonStipple");
    glPopAttrib = (PFNGLPOPATTRIBPROC) loadFunction("glPopAttrib");
    glPopClientAttrib = (PFNGLPOPCLIENTATTRIBPROC) loadFunction("glPopClientAttrib");
    glPopDebugGroup = (PFNGLPOPDEBUGGROUPPROC) loadFunction("glPopDebugGroup");
    glPopDebugGroupKHR = (PFNGLPOPDEBUGGROUPKHRPROC) loadFunction("glPopDebugGroupKHR");
    glPopGroupMarkerEXT = (PFNGLPOPGROUPMARKEREXTPROC) loadFunction("glPopGroupMarkerEXT");
    glPopMatrix = (PFNGLPOPMATRIXPROC) loadFunction("glPopMatrix");
    glPopName = (PFNGLPOPNAMEPROC) loadFunction("glPopName");
    glPresentFrameDualFillNV = (PFNGLPRESENTFRAMEDUALFILLNVPROC) loadFunction("glPresentFrameDualFillNV");
    glPresentFrameKeyedNV = (PFNGLPRESENTFRAMEKEYEDNVPROC) loadFunction("glPresentFrameKeyedNV");
    glPrimitiveBoundingBoxARB = (PFNGLPRIMITIVEBOUNDINGBOXARBPROC) loadFunction("glPrimitiveBoundingBoxARB");
    glPrimitiveRestartIndex = (PFNGLPRIMITIVERESTARTINDEXPROC) loadFunction("glPrimitiveRestartIndex");
    glPrimitiveRestartIndexNV = (PFNGLPRIMITIVERESTARTINDEXNVPROC) loadFunction("glPrimitiveRestartIndexNV");
    glPrimitiveRestartNV = (PFNGLPRIMITIVERESTARTNVPROC) loadFunction("glPrimitiveRestartNV");
    glPrioritizeTextures = (PFNGLPRIORITIZETEXTURESPROC) loadFunction("glPrioritizeTextures");
    glPrioritizeTexturesEXT = (PFNGLPRIORITIZETEXTURESEXTPROC) loadFunction("glPrioritizeTexturesEXT");
    glProgramBinary = (PFNGLPROGRAMBINARYPROC) loadFunction("glProgramBinary");
    glProgramBufferParametersIivNV = (PFNGLPROGRAMBUFFERPARAMETERSIIVNVPROC) loadFunction("glProgramBufferParametersIivNV");
    glProgramBufferParametersIuivNV = (PFNGLPROGRAMBUFFERPARAMETERSIUIVNVPROC) loadFunction("glProgramBufferParametersIuivNV");
    glProgramBufferParametersfvNV = (PFNGLPROGRAMBUFFERPARAMETERSFVNVPROC) loadFunction("glProgramBufferParametersfvNV");
    glProgramEnvParameter4dARB = (PFNGLPROGRAMENVPARAMETER4DARBPROC) loadFunction("glProgramEnvParameter4dARB");
    glProgramEnvParameter4dvARB = (PFNGLPROGRAMENVPARAMETER4DVARBPROC) loadFunction("glProgramEnvParameter4dvARB");
    glProgramEnvParameter4fARB = (PFNGLPROGRAMENVPARAMETER4FARBPROC) loadFunction("glProgramEnvParameter4fARB");
    glProgramEnvParameter4fvARB = (PFNGLPROGRAMENVPARAMETER4FVARBPROC) loadFunction("glProgramEnvParameter4fvARB");
    glProgramEnvParameterI4iNV = (PFNGLPROGRAMENVPARAMETERI4INVPROC) loadFunction("glProgramEnvParameterI4iNV");
    glProgramEnvParameterI4ivNV = (PFNGLPROGRAMENVPARAMETERI4IVNVPROC) loadFunction("glProgramEnvParameterI4ivNV");
    glProgramEnvParameterI4uiNV = (PFNGLPROGRAMENVPARAMETERI4UINVPROC) loadFunction("glProgramEnvParameterI4uiNV");
    glProgramEnvParameterI4uivNV = (PFNGLPROGRAMENVPARAMETERI4UIVNVPROC) loadFunction("glProgramEnvParameterI4uivNV");
    glProgramEnvParameters4fvEXT = (PFNGLPROGRAMENVPARAMETERS4FVEXTPROC) loadFunction("glProgramEnvParameters4fvEXT");
    glProgramEnvParametersI4ivNV = (PFNGLPROGRAMENVPARAMETERSI4IVNVPROC) loadFunction("glProgramEnvParametersI4ivNV");
    glProgramEnvParametersI4uivNV = (PFNGLPROGRAMENVPARAMETERSI4UIVNVPROC) loadFunction("glProgramEnvParametersI4uivNV");
    glProgramLocalParameter4dARB = (PFNGLPROGRAMLOCALPARAMETER4DARBPROC) loadFunction("glProgramLocalParameter4dARB");
    glProgramLocalParameter4dvARB = (PFNGLPROGRAMLOCALPARAMETER4DVARBPROC) loadFunction("glProgramLocalParameter4dvARB");
    glProgramLocalParameter4fARB = (PFNGLPROGRAMLOCALPARAMETER4FARBPROC) loadFunction("glProgramLocalParameter4fARB");
    glProgramLocalParameter4fvARB = (PFNGLPROGRAMLOCALPARAMETER4FVARBPROC) loadFunction("glProgramLocalParameter4fvARB");
    glProgramLocalParameterI4iNV = (PFNGLPROGRAMLOCALPARAMETERI4INVPROC) loadFunction("glProgramLocalParameterI4iNV");
    glProgramLocalParameterI4ivNV = (PFNGLPROGRAMLOCALPARAMETERI4IVNVPROC) loadFunction("glProgramLocalParameterI4ivNV");
    glProgramLocalParameterI4uiNV = (PFNGLPROGRAMLOCALPARAMETERI4UINVPROC) loadFunction("glProgramLocalParameterI4uiNV");
    glProgramLocalParameterI4uivNV = (PFNGLPROGRAMLOCALPARAMETERI4UIVNVPROC) loadFunction("glProgramLocalParameterI4uivNV");
    glProgramLocalParameters4fvEXT = (PFNGLPROGRAMLOCALPARAMETERS4FVEXTPROC) loadFunction("glProgramLocalParameters4fvEXT");
    glProgramLocalParametersI4ivNV = (PFNGLPROGRAMLOCALPARAMETERSI4IVNVPROC) loadFunction("glProgramLocalParametersI4ivNV");
    glProgramLocalParametersI4uivNV = (PFNGLPROGRAMLOCALPARAMETERSI4UIVNVPROC) loadFunction("glProgramLocalParametersI4uivNV");
    glProgramNamedParameter4dNV = (PFNGLPROGRAMNAMEDPARAMETER4DNVPROC) loadFunction("glProgramNamedParameter4dNV");
    glProgramNamedParameter4dvNV = (PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC) loadFunction("glProgramNamedParameter4dvNV");
    glProgramNamedParameter4fNV = (PFNGLPROGRAMNAMEDPARAMETER4FNVPROC) loadFunction("glProgramNamedParameter4fNV");
    glProgramNamedParameter4fvNV = (PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC) loadFunction("glProgramNamedParameter4fvNV");
    glProgramParameter4dNV = (PFNGLPROGRAMPARAMETER4DNVPROC) loadFunction("glProgramParameter4dNV");
    glProgramParameter4dvNV = (PFNGLPROGRAMPARAMETER4DVNVPROC) loadFunction("glProgramParameter4dvNV");
    glProgramParameter4fNV = (PFNGLPROGRAMPARAMETER4FNVPROC) loadFunction("glProgramParameter4fNV");
    glProgramParameter4fvNV = (PFNGLPROGRAMPARAMETER4FVNVPROC) loadFunction("glProgramParameter4fvNV");
    glProgramParameteri = (PFNGLPROGRAMPARAMETERIPROC) loadFunction("glProgramParameteri");
    glProgramParameteriARB = (PFNGLPROGRAMPARAMETERIARBPROC) loadFunction("glProgramParameteriARB");
    glProgramParameteriEXT = (PFNGLPROGRAMPARAMETERIEXTPROC) loadFunction("glProgramParameteriEXT");
    glProgramParameters4dvNV = (PFNGLPROGRAMPARAMETERS4DVNVPROC) loadFunction("glProgramParameters4dvNV");
    glProgramParameters4fvNV = (PFNGLPROGRAMPARAMETERS4FVNVPROC) loadFunction("glProgramParameters4fvNV");
    glProgramPathFragmentInputGenNV = (PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC) loadFunction("glProgramPathFragmentInputGenNV");
    glProgramStringARB = (PFNGLPROGRAMSTRINGARBPROC) loadFunction("glProgramStringARB");
    glProgramSubroutineParametersuivNV = (PFNGLPROGRAMSUBROUTINEPARAMETERSUIVNVPROC) loadFunction("glProgramSubroutineParametersuivNV");
    glProgramUniform1d = (PFNGLPROGRAMUNIFORM1DPROC) loadFunction("glProgramUniform1d");
    glProgramUniform1dEXT = (PFNGLPROGRAMUNIFORM1DEXTPROC) loadFunction("glProgramUniform1dEXT");
    glProgramUniform1dv = (PFNGLPROGRAMUNIFORM1DVPROC) loadFunction("glProgramUniform1dv");
    glProgramUniform1dvEXT = (PFNGLPROGRAMUNIFORM1DVEXTPROC) loadFunction("glProgramUniform1dvEXT");
    glProgramUniform1f = (PFNGLPROGRAMUNIFORM1FPROC) loadFunction("glProgramUniform1f");
    glProgramUniform1fEXT = (PFNGLPROGRAMUNIFORM1FEXTPROC) loadFunction("glProgramUniform1fEXT");
    glProgramUniform1fv = (PFNGLPROGRAMUNIFORM1FVPROC) loadFunction("glProgramUniform1fv");
    glProgramUniform1fvEXT = (PFNGLPROGRAMUNIFORM1FVEXTPROC) loadFunction("glProgramUniform1fvEXT");
    glProgramUniform1i = (PFNGLPROGRAMUNIFORM1IPROC) loadFunction("glProgramUniform1i");
    glProgramUniform1i64ARB = (PFNGLPROGRAMUNIFORM1I64ARBPROC) loadFunction("glProgramUniform1i64ARB");
    glProgramUniform1i64NV = (PFNGLPROGRAMUNIFORM1I64NVPROC) loadFunction("glProgramUniform1i64NV");
    glProgramUniform1i64vARB = (PFNGLPROGRAMUNIFORM1I64VARBPROC) loadFunction("glProgramUniform1i64vARB");
    glProgramUniform1i64vNV = (PFNGLPROGRAMUNIFORM1I64VNVPROC) loadFunction("glProgramUniform1i64vNV");
    glProgramUniform1iEXT = (PFNGLPROGRAMUNIFORM1IEXTPROC) loadFunction("glProgramUniform1iEXT");
    glProgramUniform1iv = (PFNGLPROGRAMUNIFORM1IVPROC) loadFunction("glProgramUniform1iv");
    glProgramUniform1ivEXT = (PFNGLPROGRAMUNIFORM1IVEXTPROC) loadFunction("glProgramUniform1ivEXT");
    glProgramUniform1ui = (PFNGLPROGRAMUNIFORM1UIPROC) loadFunction("glProgramUniform1ui");
    glProgramUniform1ui64ARB = (PFNGLPROGRAMUNIFORM1UI64ARBPROC) loadFunction("glProgramUniform1ui64ARB");
    glProgramUniform1ui64NV = (PFNGLPROGRAMUNIFORM1UI64NVPROC) loadFunction("glProgramUniform1ui64NV");
    glProgramUniform1ui64vARB = (PFNGLPROGRAMUNIFORM1UI64VARBPROC) loadFunction("glProgramUniform1ui64vARB");
    glProgramUniform1ui64vNV = (PFNGLPROGRAMUNIFORM1UI64VNVPROC) loadFunction("glProgramUniform1ui64vNV");
    glProgramUniform1uiEXT = (PFNGLPROGRAMUNIFORM1UIEXTPROC) loadFunction("glProgramUniform1uiEXT");
    glProgramUniform1uiv = (PFNGLPROGRAMUNIFORM1UIVPROC) loadFunction("glProgramUniform1uiv");
    glProgramUniform1uivEXT = (PFNGLPROGRAMUNIFORM1UIVEXTPROC) loadFunction("glProgramUniform1uivEXT");
    glProgramUniform2d = (PFNGLPROGRAMUNIFORM2DPROC) loadFunction("glProgramUniform2d");
    glProgramUniform2dEXT = (PFNGLPROGRAMUNIFORM2DEXTPROC) loadFunction("glProgramUniform2dEXT");
    glProgramUniform2dv = (PFNGLPROGRAMUNIFORM2DVPROC) loadFunction("glProgramUniform2dv");
    glProgramUniform2dvEXT = (PFNGLPROGRAMUNIFORM2DVEXTPROC) loadFunction("glProgramUniform2dvEXT");
    glProgramUniform2f = (PFNGLPROGRAMUNIFORM2FPROC) loadFunction("glProgramUniform2f");
    glProgramUniform2fEXT = (PFNGLPROGRAMUNIFORM2FEXTPROC) loadFunction("glProgramUniform2fEXT");
    glProgramUniform2fv = (PFNGLPROGRAMUNIFORM2FVPROC) loadFunction("glProgramUniform2fv");
    glProgramUniform2fvEXT = (PFNGLPROGRAMUNIFORM2FVEXTPROC) loadFunction("glProgramUniform2fvEXT");
    glProgramUniform2i = (PFNGLPROGRAMUNIFORM2IPROC) loadFunction("glProgramUniform2i");
    glProgramUniform2i64ARB = (PFNGLPROGRAMUNIFORM2I64ARBPROC) loadFunction("glProgramUniform2i64ARB");
    glProgramUniform2i64NV = (PFNGLPROGRAMUNIFORM2I64NVPROC) loadFunction("glProgramUniform2i64NV");
    glProgramUniform2i64vARB = (PFNGLPROGRAMUNIFORM2I64VARBPROC) loadFunction("glProgramUniform2i64vARB");
    glProgramUniform2i64vNV = (PFNGLPROGRAMUNIFORM2I64VNVPROC) loadFunction("glProgramUniform2i64vNV");
    glProgramUniform2iEXT = (PFNGLPROGRAMUNIFORM2IEXTPROC) loadFunction("glProgramUniform2iEXT");
    glProgramUniform2iv = (PFNGLPROGRAMUNIFORM2IVPROC) loadFunction("glProgramUniform2iv");
    glProgramUniform2ivEXT = (PFNGLPROGRAMUNIFORM2IVEXTPROC) loadFunction("glProgramUniform2ivEXT");
    glProgramUniform2ui = (PFNGLPROGRAMUNIFORM2UIPROC) loadFunction("glProgramUniform2ui");
    glProgramUniform2ui64ARB = (PFNGLPROGRAMUNIFORM2UI64ARBPROC) loadFunction("glProgramUniform2ui64ARB");
    glProgramUniform2ui64NV = (PFNGLPROGRAMUNIFORM2UI64NVPROC) loadFunction("glProgramUniform2ui64NV");
    glProgramUniform2ui64vARB = (PFNGLPROGRAMUNIFORM2UI64VARBPROC) loadFunction("glProgramUniform2ui64vARB");
    glProgramUniform2ui64vNV = (PFNGLPROGRAMUNIFORM2UI64VNVPROC) loadFunction("glProgramUniform2ui64vNV");
    glProgramUniform2uiEXT = (PFNGLPROGRAMUNIFORM2UIEXTPROC) loadFunction("glProgramUniform2uiEXT");
    glProgramUniform2uiv = (PFNGLPROGRAMUNIFORM2UIVPROC) loadFunction("glProgramUniform2uiv");
    glProgramUniform2uivEXT = (PFNGLPROGRAMUNIFORM2UIVEXTPROC) loadFunction("glProgramUniform2uivEXT");
    glProgramUniform3d = (PFNGLPROGRAMUNIFORM3DPROC) loadFunction("glProgramUniform3d");
    glProgramUniform3dEXT = (PFNGLPROGRAMUNIFORM3DEXTPROC) loadFunction("glProgramUniform3dEXT");
    glProgramUniform3dv = (PFNGLPROGRAMUNIFORM3DVPROC) loadFunction("glProgramUniform3dv");
    glProgramUniform3dvEXT = (PFNGLPROGRAMUNIFORM3DVEXTPROC) loadFunction("glProgramUniform3dvEXT");
    glProgramUniform3f = (PFNGLPROGRAMUNIFORM3FPROC) loadFunction("glProgramUniform3f");
    glProgramUniform3fEXT = (PFNGLPROGRAMUNIFORM3FEXTPROC) loadFunction("glProgramUniform3fEXT");
    glProgramUniform3fv = (PFNGLPROGRAMUNIFORM3FVPROC) loadFunction("glProgramUniform3fv");
    glProgramUniform3fvEXT = (PFNGLPROGRAMUNIFORM3FVEXTPROC) loadFunction("glProgramUniform3fvEXT");
    glProgramUniform3i = (PFNGLPROGRAMUNIFORM3IPROC) loadFunction("glProgramUniform3i");
    glProgramUniform3i64ARB = (PFNGLPROGRAMUNIFORM3I64ARBPROC) loadFunction("glProgramUniform3i64ARB");
    glProgramUniform3i64NV = (PFNGLPROGRAMUNIFORM3I64NVPROC) loadFunction("glProgramUniform3i64NV");
    glProgramUniform3i64vARB = (PFNGLPROGRAMUNIFORM3I64VARBPROC) loadFunction("glProgramUniform3i64vARB");
    glProgramUniform3i64vNV = (PFNGLPROGRAMUNIFORM3I64VNVPROC) loadFunction("glProgramUniform3i64vNV");
    glProgramUniform3iEXT = (PFNGLPROGRAMUNIFORM3IEXTPROC) loadFunction("glProgramUniform3iEXT");
    glProgramUniform3iv = (PFNGLPROGRAMUNIFORM3IVPROC) loadFunction("glProgramUniform3iv");
    glProgramUniform3ivEXT = (PFNGLPROGRAMUNIFORM3IVEXTPROC) loadFunction("glProgramUniform3ivEXT");
    glProgramUniform3ui = (PFNGLPROGRAMUNIFORM3UIPROC) loadFunction("glProgramUniform3ui");
    glProgramUniform3ui64ARB = (PFNGLPROGRAMUNIFORM3UI64ARBPROC) loadFunction("glProgramUniform3ui64ARB");
    glProgramUniform3ui64NV = (PFNGLPROGRAMUNIFORM3UI64NVPROC) loadFunction("glProgramUniform3ui64NV");
    glProgramUniform3ui64vARB = (PFNGLPROGRAMUNIFORM3UI64VARBPROC) loadFunction("glProgramUniform3ui64vARB");
    glProgramUniform3ui64vNV = (PFNGLPROGRAMUNIFORM3UI64VNVPROC) loadFunction("glProgramUniform3ui64vNV");
    glProgramUniform3uiEXT = (PFNGLPROGRAMUNIFORM3UIEXTPROC) loadFunction("glProgramUniform3uiEXT");
    glProgramUniform3uiv = (PFNGLPROGRAMUNIFORM3UIVPROC) loadFunction("glProgramUniform3uiv");
    glProgramUniform3uivEXT = (PFNGLPROGRAMUNIFORM3UIVEXTPROC) loadFunction("glProgramUniform3uivEXT");
    glProgramUniform4d = (PFNGLPROGRAMUNIFORM4DPROC) loadFunction("glProgramUniform4d");
    glProgramUniform4dEXT = (PFNGLPROGRAMUNIFORM4DEXTPROC) loadFunction("glProgramUniform4dEXT");
    glProgramUniform4dv = (PFNGLPROGRAMUNIFORM4DVPROC) loadFunction("glProgramUniform4dv");
    glProgramUniform4dvEXT = (PFNGLPROGRAMUNIFORM4DVEXTPROC) loadFunction("glProgramUniform4dvEXT");
    glProgramUniform4f = (PFNGLPROGRAMUNIFORM4FPROC) loadFunction("glProgramUniform4f");
    glProgramUniform4fEXT = (PFNGLPROGRAMUNIFORM4FEXTPROC) loadFunction("glProgramUniform4fEXT");
    glProgramUniform4fv = (PFNGLPROGRAMUNIFORM4FVPROC) loadFunction("glProgramUniform4fv");
    glProgramUniform4fvEXT = (PFNGLPROGRAMUNIFORM4FVEXTPROC) loadFunction("glProgramUniform4fvEXT");
    glProgramUniform4i = (PFNGLPROGRAMUNIFORM4IPROC) loadFunction("glProgramUniform4i");
    glProgramUniform4i64ARB = (PFNGLPROGRAMUNIFORM4I64ARBPROC) loadFunction("glProgramUniform4i64ARB");
    glProgramUniform4i64NV = (PFNGLPROGRAMUNIFORM4I64NVPROC) loadFunction("glProgramUniform4i64NV");
    glProgramUniform4i64vARB = (PFNGLPROGRAMUNIFORM4I64VARBPROC) loadFunction("glProgramUniform4i64vARB");
    glProgramUniform4i64vNV = (PFNGLPROGRAMUNIFORM4I64VNVPROC) loadFunction("glProgramUniform4i64vNV");
    glProgramUniform4iEXT = (PFNGLPROGRAMUNIFORM4IEXTPROC) loadFunction("glProgramUniform4iEXT");
    glProgramUniform4iv = (PFNGLPROGRAMUNIFORM4IVPROC) loadFunction("glProgramUniform4iv");
    glProgramUniform4ivEXT = (PFNGLPROGRAMUNIFORM4IVEXTPROC) loadFunction("glProgramUniform4ivEXT");
    glProgramUniform4ui = (PFNGLPROGRAMUNIFORM4UIPROC) loadFunction("glProgramUniform4ui");
    glProgramUniform4ui64ARB = (PFNGLPROGRAMUNIFORM4UI64ARBPROC) loadFunction("glProgramUniform4ui64ARB");
    glProgramUniform4ui64NV = (PFNGLPROGRAMUNIFORM4UI64NVPROC) loadFunction("glProgramUniform4ui64NV");
    glProgramUniform4ui64vARB = (PFNGLPROGRAMUNIFORM4UI64VARBPROC) loadFunction("glProgramUniform4ui64vARB");
    glProgramUniform4ui64vNV = (PFNGLPROGRAMUNIFORM4UI64VNVPROC) loadFunction("glProgramUniform4ui64vNV");
    glProgramUniform4uiEXT = (PFNGLPROGRAMUNIFORM4UIEXTPROC) loadFunction("glProgramUniform4uiEXT");
    glProgramUniform4uiv = (PFNGLPROGRAMUNIFORM4UIVPROC) loadFunction("glProgramUniform4uiv");
    glProgramUniform4uivEXT = (PFNGLPROGRAMUNIFORM4UIVEXTPROC) loadFunction("glProgramUniform4uivEXT");
    glProgramUniformHandleui64ARB = (PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC) loadFunction("glProgramUniformHandleui64ARB");
    glProgramUniformHandleui64NV = (PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC) loadFunction("glProgramUniformHandleui64NV");
    glProgramUniformHandleui64vARB = (PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC) loadFunction("glProgramUniformHandleui64vARB");
    glProgramUniformHandleui64vNV = (PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC) loadFunction("glProgramUniformHandleui64vNV");
    glProgramUniformMatrix2dv = (PFNGLPROGRAMUNIFORMMATRIX2DVPROC) loadFunction("glProgramUniformMatrix2dv");
    glProgramUniformMatrix2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC) loadFunction("glProgramUniformMatrix2dvEXT");
    glProgramUniformMatrix2fv = (PFNGLPROGRAMUNIFORMMATRIX2FVPROC) loadFunction("glProgramUniformMatrix2fv");
    glProgramUniformMatrix2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC) loadFunction("glProgramUniformMatrix2fvEXT");
    glProgramUniformMatrix2x3dv = (PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC) loadFunction("glProgramUniformMatrix2x3dv");
    glProgramUniformMatrix2x3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC) loadFunction("glProgramUniformMatrix2x3dvEXT");
    glProgramUniformMatrix2x3fv = (PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC) loadFunction("glProgramUniformMatrix2x3fv");
    glProgramUniformMatrix2x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC) loadFunction("glProgramUniformMatrix2x3fvEXT");
    glProgramUniformMatrix2x4dv = (PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC) loadFunction("glProgramUniformMatrix2x4dv");
    glProgramUniformMatrix2x4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC) loadFunction("glProgramUniformMatrix2x4dvEXT");
    glProgramUniformMatrix2x4fv = (PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC) loadFunction("glProgramUniformMatrix2x4fv");
    glProgramUniformMatrix2x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC) loadFunction("glProgramUniformMatrix2x4fvEXT");
    glProgramUniformMatrix3dv = (PFNGLPROGRAMUNIFORMMATRIX3DVPROC) loadFunction("glProgramUniformMatrix3dv");
    glProgramUniformMatrix3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC) loadFunction("glProgramUniformMatrix3dvEXT");
    glProgramUniformMatrix3fv = (PFNGLPROGRAMUNIFORMMATRIX3FVPROC) loadFunction("glProgramUniformMatrix3fv");
    glProgramUniformMatrix3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC) loadFunction("glProgramUniformMatrix3fvEXT");
    glProgramUniformMatrix3x2dv = (PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC) loadFunction("glProgramUniformMatrix3x2dv");
    glProgramUniformMatrix3x2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC) loadFunction("glProgramUniformMatrix3x2dvEXT");
    glProgramUniformMatrix3x2fv = (PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC) loadFunction("glProgramUniformMatrix3x2fv");
    glProgramUniformMatrix3x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC) loadFunction("glProgramUniformMatrix3x2fvEXT");
    glProgramUniformMatrix3x4dv = (PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC) loadFunction("glProgramUniformMatrix3x4dv");
    glProgramUniformMatrix3x4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC) loadFunction("glProgramUniformMatrix3x4dvEXT");
    glProgramUniformMatrix3x4fv = (PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC) loadFunction("glProgramUniformMatrix3x4fv");
    glProgramUniformMatrix3x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC) loadFunction("glProgramUniformMatrix3x4fvEXT");
    glProgramUniformMatrix4dv = (PFNGLPROGRAMUNIFORMMATRIX4DVPROC) loadFunction("glProgramUniformMatrix4dv");
    glProgramUniformMatrix4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC) loadFunction("glProgramUniformMatrix4dvEXT");
    glProgramUniformMatrix4fv = (PFNGLPROGRAMUNIFORMMATRIX4FVPROC) loadFunction("glProgramUniformMatrix4fv");
    glProgramUniformMatrix4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC) loadFunction("glProgramUniformMatrix4fvEXT");
    glProgramUniformMatrix4x2dv = (PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC) loadFunction("glProgramUniformMatrix4x2dv");
    glProgramUniformMatrix4x2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC) loadFunction("glProgramUniformMatrix4x2dvEXT");
    glProgramUniformMatrix4x2fv = (PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC) loadFunction("glProgramUniformMatrix4x2fv");
    glProgramUniformMatrix4x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC) loadFunction("glProgramUniformMatrix4x2fvEXT");
    glProgramUniformMatrix4x3dv = (PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC) loadFunction("glProgramUniformMatrix4x3dv");
    glProgramUniformMatrix4x3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC) loadFunction("glProgramUniformMatrix4x3dvEXT");
    glProgramUniformMatrix4x3fv = (PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC) loadFunction("glProgramUniformMatrix4x3fv");
    glProgramUniformMatrix4x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC) loadFunction("glProgramUniformMatrix4x3fvEXT");
    glProgramUniformui64NV = (PFNGLPROGRAMUNIFORMUI64NVPROC) loadFunction("glProgramUniformui64NV");
    glProgramUniformui64vNV = (PFNGLPROGRAMUNIFORMUI64VNVPROC) loadFunction("glProgramUniformui64vNV");
    glProgramVertexLimitNV = (PFNGLPROGRAMVERTEXLIMITNVPROC) loadFunction("glProgramVertexLimitNV");
    glProvokingVertex = (PFNGLPROVOKINGVERTEXPROC) loadFunction("glProvokingVertex");
    glProvokingVertexEXT = (PFNGLPROVOKINGVERTEXEXTPROC) loadFunction("glProvokingVertexEXT");
    glPushAttrib = (PFNGLPUSHATTRIBPROC) loadFunction("glPushAttrib");
    glPushClientAttrib = (PFNGLPUSHCLIENTATTRIBPROC) loadFunction("glPushClientAttrib");
    glPushClientAttribDefaultEXT = (PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC) loadFunction("glPushClientAttribDefaultEXT");
    glPushDebugGroup = (PFNGLPUSHDEBUGGROUPPROC) loadFunction("glPushDebugGroup");
    glPushDebugGroupKHR = (PFNGLPUSHDEBUGGROUPKHRPROC) loadFunction("glPushDebugGroupKHR");
    glPushGroupMarkerEXT = (PFNGLPUSHGROUPMARKEREXTPROC) loadFunction("glPushGroupMarkerEXT");
    glPushMatrix = (PFNGLPUSHMATRIXPROC) loadFunction("glPushMatrix");
    glPushName = (PFNGLPUSHNAMEPROC) loadFunction("glPushName");
    glQueryCounter = (PFNGLQUERYCOUNTERPROC) loadFunction("glQueryCounter");
    glQueryObjectParameteruiAMD = (PFNGLQUERYOBJECTPARAMETERUIAMDPROC) loadFunction("glQueryObjectParameteruiAMD");
    glQueryResourceNV = (PFNGLQUERYRESOURCENVPROC) loadFunction("glQueryResourceNV");
    glQueryResourceTagNV = (PFNGLQUERYRESOURCETAGNVPROC) loadFunction("glQueryResourceTagNV");
    glRasterPos2d = (PFNGLRASTERPOS2DPROC) loadFunction("glRasterPos2d");
    glRasterPos2dv = (PFNGLRASTERPOS2DVPROC) loadFunction("glRasterPos2dv");
    glRasterPos2f = (PFNGLRASTERPOS2FPROC) loadFunction("glRasterPos2f");
    glRasterPos2fv = (PFNGLRASTERPOS2FVPROC) loadFunction("glRasterPos2fv");
    glRasterPos2i = (PFNGLRASTERPOS2IPROC) loadFunction("glRasterPos2i");
    glRasterPos2iv = (PFNGLRASTERPOS2IVPROC) loadFunction("glRasterPos2iv");
    glRasterPos2s = (PFNGLRASTERPOS2SPROC) loadFunction("glRasterPos2s");
    glRasterPos2sv = (PFNGLRASTERPOS2SVPROC) loadFunction("glRasterPos2sv");
    glRasterPos3d = (PFNGLRASTERPOS3DPROC) loadFunction("glRasterPos3d");
    glRasterPos3dv = (PFNGLRASTERPOS3DVPROC) loadFunction("glRasterPos3dv");
    glRasterPos3f = (PFNGLRASTERPOS3FPROC) loadFunction("glRasterPos3f");
    glRasterPos3fv = (PFNGLRASTERPOS3FVPROC) loadFunction("glRasterPos3fv");
    glRasterPos3i = (PFNGLRASTERPOS3IPROC) loadFunction("glRasterPos3i");
    glRasterPos3iv = (PFNGLRASTERPOS3IVPROC) loadFunction("glRasterPos3iv");
    glRasterPos3s = (PFNGLRASTERPOS3SPROC) loadFunction("glRasterPos3s");
    glRasterPos3sv = (PFNGLRASTERPOS3SVPROC) loadFunction("glRasterPos3sv");
    glRasterPos4d = (PFNGLRASTERPOS4DPROC) loadFunction("glRasterPos4d");
    glRasterPos4dv = (PFNGLRASTERPOS4DVPROC) loadFunction("glRasterPos4dv");
    glRasterPos4f = (PFNGLRASTERPOS4FPROC) loadFunction("glRasterPos4f");
    glRasterPos4fv = (PFNGLRASTERPOS4FVPROC) loadFunction("glRasterPos4fv");
    glRasterPos4i = (PFNGLRASTERPOS4IPROC) loadFunction("glRasterPos4i");
    glRasterPos4iv = (PFNGLRASTERPOS4IVPROC) loadFunction("glRasterPos4iv");
    glRasterPos4s = (PFNGLRASTERPOS4SPROC) loadFunction("glRasterPos4s");
    glRasterPos4sv = (PFNGLRASTERPOS4SVPROC) loadFunction("glRasterPos4sv");
    glRasterSamplesEXT = (PFNGLRASTERSAMPLESEXTPROC) loadFunction("glRasterSamplesEXT");
    glReadBuffer = (PFNGLREADBUFFERPROC) loadFunction("glReadBuffer");
    glReadPixels = (PFNGLREADPIXELSPROC) loadFunction("glReadPixels");
    glReadnPixels = (PFNGLREADNPIXELSPROC) loadFunction("glReadnPixels");
    glReadnPixelsARB = (PFNGLREADNPIXELSARBPROC) loadFunction("glReadnPixelsARB");
    glReadnPixelsKHR = (PFNGLREADNPIXELSKHRPROC) loadFunction("glReadnPixelsKHR");
    glReleaseKeyedMutexWin32EXT = (PFNGLRELEASEKEYEDMUTEXWIN32EXTPROC) loadFunction("glReleaseKeyedMutexWin32EXT");
    glRectd = (PFNGLRECTDPROC) loadFunction("glRectd");
    glRectdv = (PFNGLRECTDVPROC) loadFunction("glRectdv");
    glRectf = (PFNGLRECTFPROC) loadFunction("glRectf");
    glRectfv = (PFNGLRECTFVPROC) loadFunction("glRectfv");
    glRecti = (PFNGLRECTIPROC) loadFunction("glRecti");
    glRectiv = (PFNGLRECTIVPROC) loadFunction("glRectiv");
    glRects = (PFNGLRECTSPROC) loadFunction("glRects");
    glRectsv = (PFNGLRECTSVPROC) loadFunction("glRectsv");
    glReleaseShaderCompiler = (PFNGLRELEASESHADERCOMPILERPROC) loadFunction("glReleaseShaderCompiler");
    glRenderGpuMaskNV = (PFNGLRENDERGPUMASKNVPROC) loadFunction("glRenderGpuMaskNV");
    glRenderMode = (PFNGLRENDERMODEPROC) loadFunction("glRenderMode");
    glRenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC) loadFunction("glRenderbufferStorage");
    glRenderbufferStorageEXT = (PFNGLRENDERBUFFERSTORAGEEXTPROC) loadFunction("glRenderbufferStorageEXT");
    glRenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC) loadFunction("glRenderbufferStorageMultisample");
    glRenderbufferStorageMultisampleAdvancedAMD = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEADVANCEDAMDPROC) loadFunction("glRenderbufferStorageMultisampleAdvancedAMD");
    glRenderbufferStorageMultisampleCoverageNV = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC) loadFunction("glRenderbufferStorageMultisampleCoverageNV");
    glRenderbufferStorageMultisampleEXT = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC) loadFunction("glRenderbufferStorageMultisampleEXT");
    glRequestResidentProgramsNV = (PFNGLREQUESTRESIDENTPROGRAMSNVPROC) loadFunction("glRequestResidentProgramsNV");
    glResetHistogram = (PFNGLRESETHISTOGRAMPROC) loadFunction("glResetHistogram");
    glResetHistogramEXT = (PFNGLRESETHISTOGRAMEXTPROC) loadFunction("glResetHistogramEXT");
    glResetMemoryObjectParameterNV = (PFNGLRESETMEMORYOBJECTPARAMETERNVPROC) loadFunction("glResetMemoryObjectParameterNV");
    glResetMinmax = (PFNGLRESETMINMAXPROC) loadFunction("glResetMinmax");
    glResetMinmaxEXT = (PFNGLRESETMINMAXEXTPROC) loadFunction("glResetMinmaxEXT");
    glResolveDepthValuesNV = (PFNGLRESOLVEDEPTHVALUESNVPROC) loadFunction("glResolveDepthValuesNV");
    glResumeTransformFeedback = (PFNGLRESUMETRANSFORMFEEDBACKPROC) loadFunction("glResumeTransformFeedback");
    glResumeTransformFeedbackNV = (PFNGLRESUMETRANSFORMFEEDBACKNVPROC) loadFunction("glResumeTransformFeedbackNV");
    glRotated = (PFNGLROTATEDPROC) loadFunction("glRotated");
    glRotatef = (PFNGLROTATEFPROC) loadFunction("glRotatef");
    glSampleCoverage = (PFNGLSAMPLECOVERAGEPROC) loadFunction("glSampleCoverage");
    glSampleCoverageARB = (PFNGLSAMPLECOVERAGEARBPROC) loadFunction("glSampleCoverageARB");
    glSampleMaskEXT = (PFNGLSAMPLEMASKEXTPROC) loadFunction("glSampleMaskEXT");
    glSampleMaskIndexedNV = (PFNGLSAMPLEMASKINDEXEDNVPROC) loadFunction("glSampleMaskIndexedNV");
    glSampleMaski = (PFNGLSAMPLEMASKIPROC) loadFunction("glSampleMaski");
    glSamplePatternEXT = (PFNGLSAMPLEPATTERNEXTPROC) loadFunction("glSamplePatternEXT");
    glSamplerParameterIiv = (PFNGLSAMPLERPARAMETERIIVPROC) loadFunction("glSamplerParameterIiv");
    glSamplerParameterIuiv = (PFNGLSAMPLERPARAMETERIUIVPROC) loadFunction("glSamplerParameterIuiv");
    glSamplerParameterf = (PFNGLSAMPLERPARAMETERFPROC) loadFunction("glSamplerParameterf");
    glSamplerParameterfv = (PFNGLSAMPLERPARAMETERFVPROC) loadFunction("glSamplerParameterfv");
    glSamplerParameteri = (PFNGLSAMPLERPARAMETERIPROC) loadFunction("glSamplerParameteri");
    glSamplerParameteriv = (PFNGLSAMPLERPARAMETERIVPROC) loadFunction("glSamplerParameteriv");
    glScaled = (PFNGLSCALEDPROC) loadFunction("glScaled");
    glScalef = (PFNGLSCALEFPROC) loadFunction("glScalef");
    glScissor = (PFNGLSCISSORPROC) loadFunction("glScissor");
    glScissorArrayv = (PFNGLSCISSORARRAYVPROC) loadFunction("glScissorArrayv");
    glScissorExclusiveArrayvNV = (PFNGLSCISSOREXCLUSIVEARRAYVNVPROC) loadFunction("glScissorExclusiveArrayvNV");
    glScissorExclusiveNV = (PFNGLSCISSOREXCLUSIVENVPROC) loadFunction("glScissorExclusiveNV");
    glScissorIndexed = (PFNGLSCISSORINDEXEDPROC) loadFunction("glScissorIndexed");
    glScissorIndexedv = (PFNGLSCISSORINDEXEDVPROC) loadFunction("glScissorIndexedv");
    glSecondaryColor3b = (PFNGLSECONDARYCOLOR3BPROC) loadFunction("glSecondaryColor3b");
    glSecondaryColor3bEXT = (PFNGLSECONDARYCOLOR3BEXTPROC) loadFunction("glSecondaryColor3bEXT");
    glSecondaryColor3bv = (PFNGLSECONDARYCOLOR3BVPROC) loadFunction("glSecondaryColor3bv");
    glSecondaryColor3bvEXT = (PFNGLSECONDARYCOLOR3BVEXTPROC) loadFunction("glSecondaryColor3bvEXT");
    glSecondaryColor3d = (PFNGLSECONDARYCOLOR3DPROC) loadFunction("glSecondaryColor3d");
    glSecondaryColor3dEXT = (PFNGLSECONDARYCOLOR3DEXTPROC) loadFunction("glSecondaryColor3dEXT");
    glSecondaryColor3dv = (PFNGLSECONDARYCOLOR3DVPROC) loadFunction("glSecondaryColor3dv");
    glSecondaryColor3dvEXT = (PFNGLSECONDARYCOLOR3DVEXTPROC) loadFunction("glSecondaryColor3dvEXT");
    glSecondaryColor3f = (PFNGLSECONDARYCOLOR3FPROC) loadFunction("glSecondaryColor3f");
    glSecondaryColor3fEXT = (PFNGLSECONDARYCOLOR3FEXTPROC) loadFunction("glSecondaryColor3fEXT");
    glSecondaryColor3fv = (PFNGLSECONDARYCOLOR3FVPROC) loadFunction("glSecondaryColor3fv");
    glSecondaryColor3fvEXT = (PFNGLSECONDARYCOLOR3FVEXTPROC) loadFunction("glSecondaryColor3fvEXT");
    glSecondaryColor3hNV = (PFNGLSECONDARYCOLOR3HNVPROC) loadFunction("glSecondaryColor3hNV");
    glSecondaryColor3hvNV = (PFNGLSECONDARYCOLOR3HVNVPROC) loadFunction("glSecondaryColor3hvNV");
    glSecondaryColor3i = (PFNGLSECONDARYCOLOR3IPROC) loadFunction("glSecondaryColor3i");
    glSecondaryColor3iEXT = (PFNGLSECONDARYCOLOR3IEXTPROC) loadFunction("glSecondaryColor3iEXT");
    glSecondaryColor3iv = (PFNGLSECONDARYCOLOR3IVPROC) loadFunction("glSecondaryColor3iv");
    glSecondaryColor3ivEXT = (PFNGLSECONDARYCOLOR3IVEXTPROC) loadFunction("glSecondaryColor3ivEXT");
    glSecondaryColor3s = (PFNGLSECONDARYCOLOR3SPROC) loadFunction("glSecondaryColor3s");
    glSecondaryColor3sEXT = (PFNGLSECONDARYCOLOR3SEXTPROC) loadFunction("glSecondaryColor3sEXT");
    glSecondaryColor3sv = (PFNGLSECONDARYCOLOR3SVPROC) loadFunction("glSecondaryColor3sv");
    glSecondaryColor3svEXT = (PFNGLSECONDARYCOLOR3SVEXTPROC) loadFunction("glSecondaryColor3svEXT");
    glSecondaryColor3ub = (PFNGLSECONDARYCOLOR3UBPROC) loadFunction("glSecondaryColor3ub");
    glSecondaryColor3ubEXT = (PFNGLSECONDARYCOLOR3UBEXTPROC) loadFunction("glSecondaryColor3ubEXT");
    glSecondaryColor3ubv = (PFNGLSECONDARYCOLOR3UBVPROC) loadFunction("glSecondaryColor3ubv");
    glSecondaryColor3ubvEXT = (PFNGLSECONDARYCOLOR3UBVEXTPROC) loadFunction("glSecondaryColor3ubvEXT");
    glSecondaryColor3ui = (PFNGLSECONDARYCOLOR3UIPROC) loadFunction("glSecondaryColor3ui");
    glSecondaryColor3uiEXT = (PFNGLSECONDARYCOLOR3UIEXTPROC) loadFunction("glSecondaryColor3uiEXT");
    glSecondaryColor3uiv = (PFNGLSECONDARYCOLOR3UIVPROC) loadFunction("glSecondaryColor3uiv");
    glSecondaryColor3uivEXT = (PFNGLSECONDARYCOLOR3UIVEXTPROC) loadFunction("glSecondaryColor3uivEXT");
    glSecondaryColor3us = (PFNGLSECONDARYCOLOR3USPROC) loadFunction("glSecondaryColor3us");
    glSecondaryColor3usEXT = (PFNGLSECONDARYCOLOR3USEXTPROC) loadFunction("glSecondaryColor3usEXT");
    glSecondaryColor3usv = (PFNGLSECONDARYCOLOR3USVPROC) loadFunction("glSecondaryColor3usv");
    glSecondaryColor3usvEXT = (PFNGLSECONDARYCOLOR3USVEXTPROC) loadFunction("glSecondaryColor3usvEXT");
    glSecondaryColorFormatNV = (PFNGLSECONDARYCOLORFORMATNVPROC) loadFunction("glSecondaryColorFormatNV");
    glSecondaryColorP3ui = (PFNGLSECONDARYCOLORP3UIPROC) loadFunction("glSecondaryColorP3ui");
    glSecondaryColorP3uiv = (PFNGLSECONDARYCOLORP3UIVPROC) loadFunction("glSecondaryColorP3uiv");
    glSecondaryColorPointer = (PFNGLSECONDARYCOLORPOINTERPROC) loadFunction("glSecondaryColorPointer");
    glSecondaryColorPointerEXT = (PFNGLSECONDARYCOLORPOINTEREXTPROC) loadFunction("glSecondaryColorPointerEXT");
    glSelectBuffer = (PFNGLSELECTBUFFERPROC) loadFunction("glSelectBuffer");
    glSelectPerfMonitorCountersAMD = (PFNGLSELECTPERFMONITORCOUNTERSAMDPROC) loadFunction("glSelectPerfMonitorCountersAMD");
    glSemaphoreParameterui64vEXT = (PFNGLSEMAPHOREPARAMETERUI64VEXTPROC) loadFunction("glSemaphoreParameterui64vEXT");
    glSeparableFilter2D = (PFNGLSEPARABLEFILTER2DPROC) loadFunction("glSeparableFilter2D");
    glSeparableFilter2DEXT = (PFNGLSEPARABLEFILTER2DEXTPROC) loadFunction("glSeparableFilter2DEXT");
    glSetFenceAPPLE = (PFNGLSETFENCEAPPLEPROC) loadFunction("glSetFenceAPPLE");
    glSetFenceNV = (PFNGLSETFENCENVPROC) loadFunction("glSetFenceNV");
    glSetInvariantEXT = (PFNGLSETINVARIANTEXTPROC) loadFunction("glSetInvariantEXT");
    glSetLocalConstantEXT = (PFNGLSETLOCALCONSTANTEXTPROC) loadFunction("glSetLocalConstantEXT");
    glSetMultisamplefvAMD = (PFNGLSETMULTISAMPLEFVAMDPROC) loadFunction("glSetMultisamplefvAMD");
    glShadeModel = (PFNGLSHADEMODELPROC) loadFunction("glShadeModel");
    glShaderBinary = (PFNGLSHADERBINARYPROC) loadFunction("glShaderBinary");
    glShaderOp1EXT = (PFNGLSHADEROP1EXTPROC) loadFunction("glShaderOp1EXT");
    glShaderOp2EXT = (PFNGLSHADEROP2EXTPROC) loadFunction("glShaderOp2EXT");
    glShaderOp3EXT = (PFNGLSHADEROP3EXTPROC) loadFunction("glShaderOp3EXT");
    glShaderSource = (PFNGLSHADERSOURCEPROC) loadFunction("glShaderSource");
    glShaderSourceARB = (PFNGLSHADERSOURCEARBPROC) loadFunction("glShaderSourceARB");
    glShaderStorageBlockBinding = (PFNGLSHADERSTORAGEBLOCKBINDINGPROC) loadFunction("glShaderStorageBlockBinding");
    glShadingRateImageBarrierNV = (PFNGLSHADINGRATEIMAGEBARRIERNVPROC) loadFunction("glShadingRateImageBarrierNV");
    glShadingRateImagePaletteNV = (PFNGLSHADINGRATEIMAGEPALETTENVPROC) loadFunction("glShadingRateImagePaletteNV");
    glShadingRateSampleOrderNV = (PFNGLSHADINGRATESAMPLEORDERNVPROC) loadFunction("glShadingRateSampleOrderNV");
    glShadingRateSampleOrderCustomNV = (PFNGLSHADINGRATESAMPLEORDERCUSTOMNVPROC) loadFunction("glShadingRateSampleOrderCustomNV");
    glSignalSemaphoreEXT = (PFNGLSIGNALSEMAPHOREEXTPROC) loadFunction("glSignalSemaphoreEXT");
    glSpecializeShader = (PFNGLSPECIALIZESHADERPROC) loadFunction("glSpecializeShader");
    glSpecializeShaderARB = (PFNGLSPECIALIZESHADERARBPROC) loadFunction("glSpecializeShaderARB");
    glStateCaptureNV = (PFNGLSTATECAPTURENVPROC) loadFunction("glStateCaptureNV");
    glStencilClearTagEXT = (PFNGLSTENCILCLEARTAGEXTPROC) loadFunction("glStencilClearTagEXT");
    glStencilFillPathInstancedNV = (PFNGLSTENCILFILLPATHINSTANCEDNVPROC) loadFunction("glStencilFillPathInstancedNV");
    glStencilFillPathNV = (PFNGLSTENCILFILLPATHNVPROC) loadFunction("glStencilFillPathNV");
    glStencilFunc = (PFNGLSTENCILFUNCPROC) loadFunction("glStencilFunc");
    glStencilFuncSeparate = (PFNGLSTENCILFUNCSEPARATEPROC) loadFunction("glStencilFuncSeparate");
    glStencilMask = (PFNGLSTENCILMASKPROC) loadFunction("glStencilMask");
    glStencilMaskSeparate = (PFNGLSTENCILMASKSEPARATEPROC) loadFunction("glStencilMaskSeparate");
    glStencilOp = (PFNGLSTENCILOPPROC) loadFunction("glStencilOp");
    glStencilOpSeparate = (PFNGLSTENCILOPSEPARATEPROC) loadFunction("glStencilOpSeparate");
    glStencilOpValueAMD = (PFNGLSTENCILOPVALUEAMDPROC) loadFunction("glStencilOpValueAMD");
    glStencilStrokePathInstancedNV = (PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC) loadFunction("glStencilStrokePathInstancedNV");
    glStencilStrokePathNV = (PFNGLSTENCILSTROKEPATHNVPROC) loadFunction("glStencilStrokePathNV");
    glStencilThenCoverFillPathInstancedNV = (PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC) loadFunction("glStencilThenCoverFillPathInstancedNV");
    glStencilThenCoverFillPathNV = (PFNGLSTENCILTHENCOVERFILLPATHNVPROC) loadFunction("glStencilThenCoverFillPathNV");
    glStencilThenCoverStrokePathInstancedNV = (PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC) loadFunction("glStencilThenCoverStrokePathInstancedNV");
    glStencilThenCoverStrokePathNV = (PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC) loadFunction("glStencilThenCoverStrokePathNV");
    glSubpixelPrecisionBiasNV = (PFNGLSUBPIXELPRECISIONBIASNVPROC) loadFunction("glSubpixelPrecisionBiasNV");
    glSwizzleEXT = (PFNGLSWIZZLEEXTPROC) loadFunction("glSwizzleEXT");
    glSyncTextureINTEL = (PFNGLSYNCTEXTUREINTELPROC) loadFunction("glSyncTextureINTEL");
    glTangent3bEXT = (PFNGLTANGENT3BEXTPROC) loadFunction("glTangent3bEXT");
    glTangent3bvEXT = (PFNGLTANGENT3BVEXTPROC) loadFunction("glTangent3bvEXT");
    glTangent3dEXT = (PFNGLTANGENT3DEXTPROC) loadFunction("glTangent3dEXT");
    glTangent3dvEXT = (PFNGLTANGENT3DVEXTPROC) loadFunction("glTangent3dvEXT");
    glTangent3fEXT = (PFNGLTANGENT3FEXTPROC) loadFunction("glTangent3fEXT");
    glTangent3fvEXT = (PFNGLTANGENT3FVEXTPROC) loadFunction("glTangent3fvEXT");
    glTangent3iEXT = (PFNGLTANGENT3IEXTPROC) loadFunction("glTangent3iEXT");
    glTangent3ivEXT = (PFNGLTANGENT3IVEXTPROC) loadFunction("glTangent3ivEXT");
    glTangent3sEXT = (PFNGLTANGENT3SEXTPROC) loadFunction("glTangent3sEXT");
    glTangent3svEXT = (PFNGLTANGENT3SVEXTPROC) loadFunction("glTangent3svEXT");
    glTangentPointerEXT = (PFNGLTANGENTPOINTEREXTPROC) loadFunction("glTangentPointerEXT");
    glTessellationFactorAMD = (PFNGLTESSELLATIONFACTORAMDPROC) loadFunction("glTessellationFactorAMD");
    glTessellationModeAMD = (PFNGLTESSELLATIONMODEAMDPROC) loadFunction("glTessellationModeAMD");
    glTestFenceAPPLE = (PFNGLTESTFENCEAPPLEPROC) loadFunction("glTestFenceAPPLE");
    glTestFenceNV = (PFNGLTESTFENCENVPROC) loadFunction("glTestFenceNV");
    glTestObjectAPPLE = (PFNGLTESTOBJECTAPPLEPROC) loadFunction("glTestObjectAPPLE");
    glTexAttachMemoryNV = (PFNGLTEXATTACHMEMORYNVPROC) loadFunction("glTexAttachMemoryNV");
    glTexBuffer = (PFNGLTEXBUFFERPROC) loadFunction("glTexBuffer");
    glTexBufferARB = (PFNGLTEXBUFFERARBPROC) loadFunction("glTexBufferARB");
    glTexBufferEXT = (PFNGLTEXBUFFEREXTPROC) loadFunction("glTexBufferEXT");
    glTexBufferRange = (PFNGLTEXBUFFERRANGEPROC) loadFunction("glTexBufferRange");
    glTexCoord1d = (PFNGLTEXCOORD1DPROC) loadFunction("glTexCoord1d");
    glTexCoord1dv = (PFNGLTEXCOORD1DVPROC) loadFunction("glTexCoord1dv");
    glTexCoord1f = (PFNGLTEXCOORD1FPROC) loadFunction("glTexCoord1f");
    glTexCoord1fv = (PFNGLTEXCOORD1FVPROC) loadFunction("glTexCoord1fv");
    glTexCoord1hNV = (PFNGLTEXCOORD1HNVPROC) loadFunction("glTexCoord1hNV");
    glTexCoord1hvNV = (PFNGLTEXCOORD1HVNVPROC) loadFunction("glTexCoord1hvNV");
    glTexCoord1i = (PFNGLTEXCOORD1IPROC) loadFunction("glTexCoord1i");
    glTexCoord1iv = (PFNGLTEXCOORD1IVPROC) loadFunction("glTexCoord1iv");
    glTexCoord1s = (PFNGLTEXCOORD1SPROC) loadFunction("glTexCoord1s");
    glTexCoord1sv = (PFNGLTEXCOORD1SVPROC) loadFunction("glTexCoord1sv");
    glTexCoord2d = (PFNGLTEXCOORD2DPROC) loadFunction("glTexCoord2d");
    glTexCoord2dv = (PFNGLTEXCOORD2DVPROC) loadFunction("glTexCoord2dv");
    glTexCoord2f = (PFNGLTEXCOORD2FPROC) loadFunction("glTexCoord2f");
    glTexCoord2fv = (PFNGLTEXCOORD2FVPROC) loadFunction("glTexCoord2fv");
    glTexCoord2hNV = (PFNGLTEXCOORD2HNVPROC) loadFunction("glTexCoord2hNV");
    glTexCoord2hvNV = (PFNGLTEXCOORD2HVNVPROC) loadFunction("glTexCoord2hvNV");
    glTexCoord2i = (PFNGLTEXCOORD2IPROC) loadFunction("glTexCoord2i");
    glTexCoord2iv = (PFNGLTEXCOORD2IVPROC) loadFunction("glTexCoord2iv");
    glTexCoord2s = (PFNGLTEXCOORD2SPROC) loadFunction("glTexCoord2s");
    glTexCoord2sv = (PFNGLTEXCOORD2SVPROC) loadFunction("glTexCoord2sv");
    glTexCoord3d = (PFNGLTEXCOORD3DPROC) loadFunction("glTexCoord3d");
    glTexCoord3dv = (PFNGLTEXCOORD3DVPROC) loadFunction("glTexCoord3dv");
    glTexCoord3f = (PFNGLTEXCOORD3FPROC) loadFunction("glTexCoord3f");
    glTexCoord3fv = (PFNGLTEXCOORD3FVPROC) loadFunction("glTexCoord3fv");
    glTexCoord3hNV = (PFNGLTEXCOORD3HNVPROC) loadFunction("glTexCoord3hNV");
    glTexCoord3hvNV = (PFNGLTEXCOORD3HVNVPROC) loadFunction("glTexCoord3hvNV");
    glTexCoord3i = (PFNGLTEXCOORD3IPROC) loadFunction("glTexCoord3i");
    glTexCoord3iv = (PFNGLTEXCOORD3IVPROC) loadFunction("glTexCoord3iv");
    glTexCoord3s = (PFNGLTEXCOORD3SPROC) loadFunction("glTexCoord3s");
    glTexCoord3sv = (PFNGLTEXCOORD3SVPROC) loadFunction("glTexCoord3sv");
    glTexCoord4d = (PFNGLTEXCOORD4DPROC) loadFunction("glTexCoord4d");
    glTexCoord4dv = (PFNGLTEXCOORD4DVPROC) loadFunction("glTexCoord4dv");
    glTexCoord4f = (PFNGLTEXCOORD4FPROC) loadFunction("glTexCoord4f");
    glTexCoord4fv = (PFNGLTEXCOORD4FVPROC) loadFunction("glTexCoord4fv");
    glTexCoord4hNV = (PFNGLTEXCOORD4HNVPROC) loadFunction("glTexCoord4hNV");
    glTexCoord4hvNV = (PFNGLTEXCOORD4HVNVPROC) loadFunction("glTexCoord4hvNV");
    glTexCoord4i = (PFNGLTEXCOORD4IPROC) loadFunction("glTexCoord4i");
    glTexCoord4iv = (PFNGLTEXCOORD4IVPROC) loadFunction("glTexCoord4iv");
    glTexCoord4s = (PFNGLTEXCOORD4SPROC) loadFunction("glTexCoord4s");
    glTexCoord4sv = (PFNGLTEXCOORD4SVPROC) loadFunction("glTexCoord4sv");
    glTexCoordFormatNV = (PFNGLTEXCOORDFORMATNVPROC) loadFunction("glTexCoordFormatNV");
    glTexCoordP1ui = (PFNGLTEXCOORDP1UIPROC) loadFunction("glTexCoordP1ui");
    glTexCoordP1uiv = (PFNGLTEXCOORDP1UIVPROC) loadFunction("glTexCoordP1uiv");
    glTexCoordP2ui = (PFNGLTEXCOORDP2UIPROC) loadFunction("glTexCoordP2ui");
    glTexCoordP2uiv = (PFNGLTEXCOORDP2UIVPROC) loadFunction("glTexCoordP2uiv");
    glTexCoordP3ui = (PFNGLTEXCOORDP3UIPROC) loadFunction("glTexCoordP3ui");
    glTexCoordP3uiv = (PFNGLTEXCOORDP3UIVPROC) loadFunction("glTexCoordP3uiv");
    glTexCoordP4ui = (PFNGLTEXCOORDP4UIPROC) loadFunction("glTexCoordP4ui");
    glTexCoordP4uiv = (PFNGLTEXCOORDP4UIVPROC) loadFunction("glTexCoordP4uiv");
    glTexCoordPointer = (PFNGLTEXCOORDPOINTERPROC) loadFunction("glTexCoordPointer");
    glTexCoordPointerEXT = (PFNGLTEXCOORDPOINTEREXTPROC) loadFunction("glTexCoordPointerEXT");
    glTexCoordPointervINTEL = (PFNGLTEXCOORDPOINTERVINTELPROC) loadFunction("glTexCoordPointervINTEL");
    glTexEnvf = (PFNGLTEXENVFPROC) loadFunction("glTexEnvf");
    glTexEnvfv = (PFNGLTEXENVFVPROC) loadFunction("glTexEnvfv");
    glTexEnvi = (PFNGLTEXENVIPROC) loadFunction("glTexEnvi");
    glTexEnviv = (PFNGLTEXENVIVPROC) loadFunction("glTexEnviv");
    glTexGend = (PFNGLTEXGENDPROC) loadFunction("glTexGend");
    glTexGendv = (PFNGLTEXGENDVPROC) loadFunction("glTexGendv");
    glTexGenf = (PFNGLTEXGENFPROC) loadFunction("glTexGenf");
    glTexGenfv = (PFNGLTEXGENFVPROC) loadFunction("glTexGenfv");
    glTexGeni = (PFNGLTEXGENIPROC) loadFunction("glTexGeni");
    glTexGeniv = (PFNGLTEXGENIVPROC) loadFunction("glTexGeniv");
    glTexImage1D = (PFNGLTEXIMAGE1DPROC) loadFunction("glTexImage1D");
    glTexImage2D = (PFNGLTEXIMAGE2DPROC) loadFunction("glTexImage2D");
    glTexImage2DMultisample = (PFNGLTEXIMAGE2DMULTISAMPLEPROC) loadFunction("glTexImage2DMultisample");
    glTexImage2DMultisampleCoverageNV = (PFNGLTEXIMAGE2DMULTISAMPLECOVERAGENVPROC) loadFunction("glTexImage2DMultisampleCoverageNV");
    glTexImage3D = (PFNGLTEXIMAGE3DPROC) loadFunction("glTexImage3D");
    glTexImage3DEXT = (PFNGLTEXIMAGE3DEXTPROC) loadFunction("glTexImage3DEXT");
    glTexImage3DMultisample = (PFNGLTEXIMAGE3DMULTISAMPLEPROC) loadFunction("glTexImage3DMultisample");
    glTexImage3DMultisampleCoverageNV = (PFNGLTEXIMAGE3DMULTISAMPLECOVERAGENVPROC) loadFunction("glTexImage3DMultisampleCoverageNV");
    glTexPageCommitmentARB = (PFNGLTEXPAGECOMMITMENTARBPROC) loadFunction("glTexPageCommitmentARB");
    glTexParameterIiv = (PFNGLTEXPARAMETERIIVPROC) loadFunction("glTexParameterIiv");
    glTexParameterIivEXT = (PFNGLTEXPARAMETERIIVEXTPROC) loadFunction("glTexParameterIivEXT");
    glTexParameterIuiv = (PFNGLTEXPARAMETERIUIVPROC) loadFunction("glTexParameterIuiv");
    glTexParameterIuivEXT = (PFNGLTEXPARAMETERIUIVEXTPROC) loadFunction("glTexParameterIuivEXT");
    glTexParameterf = (PFNGLTEXPARAMETERFPROC) loadFunction("glTexParameterf");
    glTexParameterfv = (PFNGLTEXPARAMETERFVPROC) loadFunction("glTexParameterfv");
    glTexParameteri = (PFNGLTEXPARAMETERIPROC) loadFunction("glTexParameteri");
    glTexParameteriv = (PFNGLTEXPARAMETERIVPROC) loadFunction("glTexParameteriv");
    glTexRenderbufferNV = (PFNGLTEXRENDERBUFFERNVPROC) loadFunction("glTexRenderbufferNV");
    glTexStorage1D = (PFNGLTEXSTORAGE1DPROC) loadFunction("glTexStorage1D");
    glTexStorage2D = (PFNGLTEXSTORAGE2DPROC) loadFunction("glTexStorage2D");
    glTexStorage2DMultisample = (PFNGLTEXSTORAGE2DMULTISAMPLEPROC) loadFunction("glTexStorage2DMultisample");
    glTexStorage3D = (PFNGLTEXSTORAGE3DPROC) loadFunction("glTexStorage3D");
    glTexStorage3DMultisample = (PFNGLTEXSTORAGE3DMULTISAMPLEPROC) loadFunction("glTexStorage3DMultisample");
    glTexStorageMem1DEXT = (PFNGLTEXSTORAGEMEM1DEXTPROC) loadFunction("glTexStorageMem1DEXT");
    glTexStorageMem2DEXT = (PFNGLTEXSTORAGEMEM2DEXTPROC) loadFunction("glTexStorageMem2DEXT");
    glTexStorageMem2DMultisampleEXT = (PFNGLTEXSTORAGEMEM2DMULTISAMPLEEXTPROC) loadFunction("glTexStorageMem2DMultisampleEXT");
    glTexStorageMem3DEXT = (PFNGLTEXSTORAGEMEM3DEXTPROC) loadFunction("glTexStorageMem3DEXT");
    glTexStorageMem3DMultisampleEXT = (PFNGLTEXSTORAGEMEM3DMULTISAMPLEEXTPROC) loadFunction("glTexStorageMem3DMultisampleEXT");
    glTexStorageSparseAMD = (PFNGLTEXSTORAGESPARSEAMDPROC) loadFunction("glTexStorageSparseAMD");
    glTexSubImage1D = (PFNGLTEXSUBIMAGE1DPROC) loadFunction("glTexSubImage1D");
    glTexSubImage1DEXT = (PFNGLTEXSUBIMAGE1DEXTPROC) loadFunction("glTexSubImage1DEXT");
    glTexSubImage2D = (PFNGLTEXSUBIMAGE2DPROC) loadFunction("glTexSubImage2D");
    glTexSubImage2DEXT = (PFNGLTEXSUBIMAGE2DEXTPROC) loadFunction("glTexSubImage2DEXT");
    glTexSubImage3D = (PFNGLTEXSUBIMAGE3DPROC) loadFunction("glTexSubImage3D");
    glTexSubImage3DEXT = (PFNGLTEXSUBIMAGE3DEXTPROC) loadFunction("glTexSubImage3DEXT");
    glTextureAttachMemoryNV = (PFNGLTEXTUREATTACHMEMORYNVPROC) loadFunction("glTextureAttachMemoryNV");
    glTextureBarrier = (PFNGLTEXTUREBARRIERPROC) loadFunction("glTextureBarrier");
    glTextureBarrierNV = (PFNGLTEXTUREBARRIERNVPROC) loadFunction("glTextureBarrierNV");
    glTextureBuffer = (PFNGLTEXTUREBUFFERPROC) loadFunction("glTextureBuffer");
    glTextureBufferEXT = (PFNGLTEXTUREBUFFEREXTPROC) loadFunction("glTextureBufferEXT");
    glTextureBufferRange = (PFNGLTEXTUREBUFFERRANGEPROC) loadFunction("glTextureBufferRange");
    glTextureBufferRangeEXT = (PFNGLTEXTUREBUFFERRANGEEXTPROC) loadFunction("glTextureBufferRangeEXT");
    glTextureImage1DEXT = (PFNGLTEXTUREIMAGE1DEXTPROC) loadFunction("glTextureImage1DEXT");
    glTextureImage2DEXT = (PFNGLTEXTUREIMAGE2DEXTPROC) loadFunction("glTextureImage2DEXT");
    glTextureImage2DMultisampleCoverageNV = (PFNGLTEXTUREIMAGE2DMULTISAMPLECOVERAGENVPROC) loadFunction("glTextureImage2DMultisampleCoverageNV");
    glTextureImage2DMultisampleNV = (PFNGLTEXTUREIMAGE2DMULTISAMPLENVPROC) loadFunction("glTextureImage2DMultisampleNV");
    glTextureImage3DEXT = (PFNGLTEXTUREIMAGE3DEXTPROC) loadFunction("glTextureImage3DEXT");
    glTextureImage3DMultisampleCoverageNV = (PFNGLTEXTUREIMAGE3DMULTISAMPLECOVERAGENVPROC) loadFunction("glTextureImage3DMultisampleCoverageNV");
    glTextureImage3DMultisampleNV = (PFNGLTEXTUREIMAGE3DMULTISAMPLENVPROC) loadFunction("glTextureImage3DMultisampleNV");
    glTextureLightEXT = (PFNGLTEXTURELIGHTEXTPROC) loadFunction("glTextureLightEXT");
    glTextureMaterialEXT = (PFNGLTEXTUREMATERIALEXTPROC) loadFunction("glTextureMaterialEXT");
    glTextureNormalEXT = (PFNGLTEXTURENORMALEXTPROC) loadFunction("glTextureNormalEXT");
    glTexturePageCommitmentEXT = (PFNGLTEXTUREPAGECOMMITMENTEXTPROC) loadFunction("glTexturePageCommitmentEXT");
    glTextureParameterIiv = (PFNGLTEXTUREPARAMETERIIVPROC) loadFunction("glTextureParameterIiv");
    glTextureParameterIivEXT = (PFNGLTEXTUREPARAMETERIIVEXTPROC) loadFunction("glTextureParameterIivEXT");
    glTextureParameterIuiv = (PFNGLTEXTUREPARAMETERIUIVPROC) loadFunction("glTextureParameterIuiv");
    glTextureParameterIuivEXT = (PFNGLTEXTUREPARAMETERIUIVEXTPROC) loadFunction("glTextureParameterIuivEXT");
    glTextureParameterf = (PFNGLTEXTUREPARAMETERFPROC) loadFunction("glTextureParameterf");
    glTextureParameterfEXT = (PFNGLTEXTUREPARAMETERFEXTPROC) loadFunction("glTextureParameterfEXT");
    glTextureParameterfv = (PFNGLTEXTUREPARAMETERFVPROC) loadFunction("glTextureParameterfv");
    glTextureParameterfvEXT = (PFNGLTEXTUREPARAMETERFVEXTPROC) loadFunction("glTextureParameterfvEXT");
    glTextureParameteri = (PFNGLTEXTUREPARAMETERIPROC) loadFunction("glTextureParameteri");
    glTextureParameteriEXT = (PFNGLTEXTUREPARAMETERIEXTPROC) loadFunction("glTextureParameteriEXT");
    glTextureParameteriv = (PFNGLTEXTUREPARAMETERIVPROC) loadFunction("glTextureParameteriv");
    glTextureParameterivEXT = (PFNGLTEXTUREPARAMETERIVEXTPROC) loadFunction("glTextureParameterivEXT");
    glTextureRangeAPPLE = (PFNGLTEXTURERANGEAPPLEPROC) loadFunction("glTextureRangeAPPLE");
    glTextureRenderbufferEXT = (PFNGLTEXTURERENDERBUFFEREXTPROC) loadFunction("glTextureRenderbufferEXT");
    glTextureStorage1D = (PFNGLTEXTURESTORAGE1DPROC) loadFunction("glTextureStorage1D");
    glTextureStorage1DEXT = (PFNGLTEXTURESTORAGE1DEXTPROC) loadFunction("glTextureStorage1DEXT");
    glTextureStorage2D = (PFNGLTEXTURESTORAGE2DPROC) loadFunction("glTextureStorage2D");
    glTextureStorage2DEXT = (PFNGLTEXTURESTORAGE2DEXTPROC) loadFunction("glTextureStorage2DEXT");
    glTextureStorage2DMultisample = (PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC) loadFunction("glTextureStorage2DMultisample");
    glTextureStorage2DMultisampleEXT = (PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC) loadFunction("glTextureStorage2DMultisampleEXT");
    glTextureStorage3D = (PFNGLTEXTURESTORAGE3DPROC) loadFunction("glTextureStorage3D");
    glTextureStorage3DEXT = (PFNGLTEXTURESTORAGE3DEXTPROC) loadFunction("glTextureStorage3DEXT");
    glTextureStorage3DMultisample = (PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC) loadFunction("glTextureStorage3DMultisample");
    glTextureStorage3DMultisampleEXT = (PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC) loadFunction("glTextureStorage3DMultisampleEXT");
    glTextureStorageMem1DEXT = (PFNGLTEXTURESTORAGEMEM1DEXTPROC) loadFunction("glTextureStorageMem1DEXT");
    glTextureStorageMem2DEXT = (PFNGLTEXTURESTORAGEMEM2DEXTPROC) loadFunction("glTextureStorageMem2DEXT");
    glTextureStorageMem2DMultisampleEXT = (PFNGLTEXTURESTORAGEMEM2DMULTISAMPLEEXTPROC) loadFunction("glTextureStorageMem2DMultisampleEXT");
    glTextureStorageMem3DEXT = (PFNGLTEXTURESTORAGEMEM3DEXTPROC) loadFunction("glTextureStorageMem3DEXT");
    glTextureStorageMem3DMultisampleEXT = (PFNGLTEXTURESTORAGEMEM3DMULTISAMPLEEXTPROC) loadFunction("glTextureStorageMem3DMultisampleEXT");
    glTextureStorageSparseAMD = (PFNGLTEXTURESTORAGESPARSEAMDPROC) loadFunction("glTextureStorageSparseAMD");
    glTextureSubImage1D = (PFNGLTEXTURESUBIMAGE1DPROC) loadFunction("glTextureSubImage1D");
    glTextureSubImage1DEXT = (PFNGLTEXTURESUBIMAGE1DEXTPROC) loadFunction("glTextureSubImage1DEXT");
    glTextureSubImage2D = (PFNGLTEXTURESUBIMAGE2DPROC) loadFunction("glTextureSubImage2D");
    glTextureSubImage2DEXT = (PFNGLTEXTURESUBIMAGE2DEXTPROC) loadFunction("glTextureSubImage2DEXT");
    glTextureSubImage3D = (PFNGLTEXTURESUBIMAGE3DPROC) loadFunction("glTextureSubImage3D");
    glTextureSubImage3DEXT = (PFNGLTEXTURESUBIMAGE3DEXTPROC) loadFunction("glTextureSubImage3DEXT");
    glTextureView = (PFNGLTEXTUREVIEWPROC) loadFunction("glTextureView");
    glTrackMatrixNV = (PFNGLTRACKMATRIXNVPROC) loadFunction("glTrackMatrixNV");
    glTransformFeedbackAttribsNV = (PFNGLTRANSFORMFEEDBACKATTRIBSNVPROC) loadFunction("glTransformFeedbackAttribsNV");
    glTransformFeedbackBufferBase = (PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC) loadFunction("glTransformFeedbackBufferBase");
    glTransformFeedbackBufferRange = (PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC) loadFunction("glTransformFeedbackBufferRange");
    glTransformFeedbackStreamAttribsNV = (PFNGLTRANSFORMFEEDBACKSTREAMATTRIBSNVPROC) loadFunction("glTransformFeedbackStreamAttribsNV");
    glTransformFeedbackVaryings = (PFNGLTRANSFORMFEEDBACKVARYINGSPROC) loadFunction("glTransformFeedbackVaryings");
    glTransformFeedbackVaryingsEXT = (PFNGLTRANSFORMFEEDBACKVARYINGSEXTPROC) loadFunction("glTransformFeedbackVaryingsEXT");
    glTransformFeedbackVaryingsNV = (PFNGLTRANSFORMFEEDBACKVARYINGSNVPROC) loadFunction("glTransformFeedbackVaryingsNV");
    glTransformPathNV = (PFNGLTRANSFORMPATHNVPROC) loadFunction("glTransformPathNV");
    glTranslated = (PFNGLTRANSLATEDPROC) loadFunction("glTranslated");
    glTranslatef = (PFNGLTRANSLATEFPROC) loadFunction("glTranslatef");
    glUniform1d = (PFNGLUNIFORM1DPROC) loadFunction("glUniform1d");
    glUniform1dv = (PFNGLUNIFORM1DVPROC) loadFunction("glUniform1dv");
    glUniform1f = (PFNGLUNIFORM1FPROC) loadFunction("glUniform1f");
    glUniform1fARB = (PFNGLUNIFORM1FARBPROC) loadFunction("glUniform1fARB");
    glUniform1fv = (PFNGLUNIFORM1FVPROC) loadFunction("glUniform1fv");
    glUniform1fvARB = (PFNGLUNIFORM1FVARBPROC) loadFunction("glUniform1fvARB");
    glUniform1i = (PFNGLUNIFORM1IPROC) loadFunction("glUniform1i");
    glUniform1i64ARB = (PFNGLUNIFORM1I64ARBPROC) loadFunction("glUniform1i64ARB");
    glUniform1i64NV = (PFNGLUNIFORM1I64NVPROC) loadFunction("glUniform1i64NV");
    glUniform1i64vARB = (PFNGLUNIFORM1I64VARBPROC) loadFunction("glUniform1i64vARB");
    glUniform1i64vNV = (PFNGLUNIFORM1I64VNVPROC) loadFunction("glUniform1i64vNV");
    glUniform1iARB = (PFNGLUNIFORM1IARBPROC) loadFunction("glUniform1iARB");
    glUniform1iv = (PFNGLUNIFORM1IVPROC) loadFunction("glUniform1iv");
    glUniform1ivARB = (PFNGLUNIFORM1IVARBPROC) loadFunction("glUniform1ivARB");
    glUniform1ui = (PFNGLUNIFORM1UIPROC) loadFunction("glUniform1ui");
    glUniform1ui64ARB = (PFNGLUNIFORM1UI64ARBPROC) loadFunction("glUniform1ui64ARB");
    glUniform1ui64NV = (PFNGLUNIFORM1UI64NVPROC) loadFunction("glUniform1ui64NV");
    glUniform1ui64vARB = (PFNGLUNIFORM1UI64VARBPROC) loadFunction("glUniform1ui64vARB");
    glUniform1ui64vNV = (PFNGLUNIFORM1UI64VNVPROC) loadFunction("glUniform1ui64vNV");
    glUniform1uiEXT = (PFNGLUNIFORM1UIEXTPROC) loadFunction("glUniform1uiEXT");
    glUniform1uiv = (PFNGLUNIFORM1UIVPROC) loadFunction("glUniform1uiv");
    glUniform1uivEXT = (PFNGLUNIFORM1UIVEXTPROC) loadFunction("glUniform1uivEXT");
    glUniform2d = (PFNGLUNIFORM2DPROC) loadFunction("glUniform2d");
    glUniform2dv = (PFNGLUNIFORM2DVPROC) loadFunction("glUniform2dv");
    glUniform2f = (PFNGLUNIFORM2FPROC) loadFunction("glUniform2f");
    glUniform2fARB = (PFNGLUNIFORM2FARBPROC) loadFunction("glUniform2fARB");
    glUniform2fv = (PFNGLUNIFORM2FVPROC) loadFunction("glUniform2fv");
    glUniform2fvARB = (PFNGLUNIFORM2FVARBPROC) loadFunction("glUniform2fvARB");
    glUniform2i = (PFNGLUNIFORM2IPROC) loadFunction("glUniform2i");
    glUniform2i64ARB = (PFNGLUNIFORM2I64ARBPROC) loadFunction("glUniform2i64ARB");
    glUniform2i64NV = (PFNGLUNIFORM2I64NVPROC) loadFunction("glUniform2i64NV");
    glUniform2i64vARB = (PFNGLUNIFORM2I64VARBPROC) loadFunction("glUniform2i64vARB");
    glUniform2i64vNV = (PFNGLUNIFORM2I64VNVPROC) loadFunction("glUniform2i64vNV");
    glUniform2iARB = (PFNGLUNIFORM2IARBPROC) loadFunction("glUniform2iARB");
    glUniform2iv = (PFNGLUNIFORM2IVPROC) loadFunction("glUniform2iv");
    glUniform2ivARB = (PFNGLUNIFORM2IVARBPROC) loadFunction("glUniform2ivARB");
    glUniform2ui = (PFNGLUNIFORM2UIPROC) loadFunction("glUniform2ui");
    glUniform2ui64ARB = (PFNGLUNIFORM2UI64ARBPROC) loadFunction("glUniform2ui64ARB");
    glUniform2ui64NV = (PFNGLUNIFORM2UI64NVPROC) loadFunction("glUniform2ui64NV");
    glUniform2ui64vARB = (PFNGLUNIFORM2UI64VARBPROC) loadFunction("glUniform2ui64vARB");
    glUniform2ui64vNV = (PFNGLUNIFORM2UI64VNVPROC) loadFunction("glUniform2ui64vNV");
    glUniform2uiEXT = (PFNGLUNIFORM2UIEXTPROC) loadFunction("glUniform2uiEXT");
    glUniform2uiv = (PFNGLUNIFORM2UIVPROC) loadFunction("glUniform2uiv");
    glUniform2uivEXT = (PFNGLUNIFORM2UIVEXTPROC) loadFunction("glUniform2uivEXT");
    glUniform3d = (PFNGLUNIFORM3DPROC) loadFunction("glUniform3d");
    glUniform3dv = (PFNGLUNIFORM3DVPROC) loadFunction("glUniform3dv");
    glUniform3f = (PFNGLUNIFORM3FPROC) loadFunction("glUniform3f");
    glUniform3fARB = (PFNGLUNIFORM3FARBPROC) loadFunction("glUniform3fARB");
    glUniform3fv = (PFNGLUNIFORM3FVPROC) loadFunction("glUniform3fv");
    glUniform3fvARB = (PFNGLUNIFORM3FVARBPROC) loadFunction("glUniform3fvARB");
    glUniform3i = (PFNGLUNIFORM3IPROC) loadFunction("glUniform3i");
    glUniform3i64ARB = (PFNGLUNIFORM3I64ARBPROC) loadFunction("glUniform3i64ARB");
    glUniform3i64NV = (PFNGLUNIFORM3I64NVPROC) loadFunction("glUniform3i64NV");
    glUniform3i64vARB = (PFNGLUNIFORM3I64VARBPROC) loadFunction("glUniform3i64vARB");
    glUniform3i64vNV = (PFNGLUNIFORM3I64VNVPROC) loadFunction("glUniform3i64vNV");
    glUniform3iARB = (PFNGLUNIFORM3IARBPROC) loadFunction("glUniform3iARB");
    glUniform3iv = (PFNGLUNIFORM3IVPROC) loadFunction("glUniform3iv");
    glUniform3ivARB = (PFNGLUNIFORM3IVARBPROC) loadFunction("glUniform3ivARB");
    glUniform3ui = (PFNGLUNIFORM3UIPROC) loadFunction("glUniform3ui");
    glUniform3ui64ARB = (PFNGLUNIFORM3UI64ARBPROC) loadFunction("glUniform3ui64ARB");
    glUniform3ui64NV = (PFNGLUNIFORM3UI64NVPROC) loadFunction("glUniform3ui64NV");
    glUniform3ui64vARB = (PFNGLUNIFORM3UI64VARBPROC) loadFunction("glUniform3ui64vARB");
    glUniform3ui64vNV = (PFNGLUNIFORM3UI64VNVPROC) loadFunction("glUniform3ui64vNV");
    glUniform3uiEXT = (PFNGLUNIFORM3UIEXTPROC) loadFunction("glUniform3uiEXT");
    glUniform3uiv = (PFNGLUNIFORM3UIVPROC) loadFunction("glUniform3uiv");
    glUniform3uivEXT = (PFNGLUNIFORM3UIVEXTPROC) loadFunction("glUniform3uivEXT");
    glUniform4d = (PFNGLUNIFORM4DPROC) loadFunction("glUniform4d");
    glUniform4dv = (PFNGLUNIFORM4DVPROC) loadFunction("glUniform4dv");
    glUniform4f = (PFNGLUNIFORM4FPROC) loadFunction("glUniform4f");
    glUniform4fARB = (PFNGLUNIFORM4FARBPROC) loadFunction("glUniform4fARB");
    glUniform4fv = (PFNGLUNIFORM4FVPROC) loadFunction("glUniform4fv");
    glUniform4fvARB = (PFNGLUNIFORM4FVARBPROC) loadFunction("glUniform4fvARB");
    glUniform4i = (PFNGLUNIFORM4IPROC) loadFunction("glUniform4i");
    glUniform4i64ARB = (PFNGLUNIFORM4I64ARBPROC) loadFunction("glUniform4i64ARB");
    glUniform4i64NV = (PFNGLUNIFORM4I64NVPROC) loadFunction("glUniform4i64NV");
    glUniform4i64vARB = (PFNGLUNIFORM4I64VARBPROC) loadFunction("glUniform4i64vARB");
    glUniform4i64vNV = (PFNGLUNIFORM4I64VNVPROC) loadFunction("glUniform4i64vNV");
    glUniform4iARB = (PFNGLUNIFORM4IARBPROC) loadFunction("glUniform4iARB");
    glUniform4iv = (PFNGLUNIFORM4IVPROC) loadFunction("glUniform4iv");
    glUniform4ivARB = (PFNGLUNIFORM4IVARBPROC) loadFunction("glUniform4ivARB");
    glUniform4ui = (PFNGLUNIFORM4UIPROC) loadFunction("glUniform4ui");
    glUniform4ui64ARB = (PFNGLUNIFORM4UI64ARBPROC) loadFunction("glUniform4ui64ARB");
    glUniform4ui64NV = (PFNGLUNIFORM4UI64NVPROC) loadFunction("glUniform4ui64NV");
    glUniform4ui64vARB = (PFNGLUNIFORM4UI64VARBPROC) loadFunction("glUniform4ui64vARB");
    glUniform4ui64vNV = (PFNGLUNIFORM4UI64VNVPROC) loadFunction("glUniform4ui64vNV");
    glUniform4uiEXT = (PFNGLUNIFORM4UIEXTPROC) loadFunction("glUniform4uiEXT");
    glUniform4uiv = (PFNGLUNIFORM4UIVPROC) loadFunction("glUniform4uiv");
    glUniform4uivEXT = (PFNGLUNIFORM4UIVEXTPROC) loadFunction("glUniform4uivEXT");
    glUniformBlockBinding = (PFNGLUNIFORMBLOCKBINDINGPROC) loadFunction("glUniformBlockBinding");
    glUniformBufferEXT = (PFNGLUNIFORMBUFFEREXTPROC) loadFunction("glUniformBufferEXT");
    glUniformHandleui64ARB = (PFNGLUNIFORMHANDLEUI64ARBPROC) loadFunction("glUniformHandleui64ARB");
    glUniformHandleui64NV = (PFNGLUNIFORMHANDLEUI64NVPROC) loadFunction("glUniformHandleui64NV");
    glUniformHandleui64vARB = (PFNGLUNIFORMHANDLEUI64VARBPROC) loadFunction("glUniformHandleui64vARB");
    glUniformHandleui64vNV = (PFNGLUNIFORMHANDLEUI64VNVPROC) loadFunction("glUniformHandleui64vNV");
    glUniformMatrix2dv = (PFNGLUNIFORMMATRIX2DVPROC) loadFunction("glUniformMatrix2dv");
    glUniformMatrix2fv = (PFNGLUNIFORMMATRIX2FVPROC) loadFunction("glUniformMatrix2fv");
    glUniformMatrix2fvARB = (PFNGLUNIFORMMATRIX2FVARBPROC) loadFunction("glUniformMatrix2fvARB");
    glUniformMatrix2x3dv = (PFNGLUNIFORMMATRIX2X3DVPROC) loadFunction("glUniformMatrix2x3dv");
    glUniformMatrix2x3fv = (PFNGLUNIFORMMATRIX2X3FVPROC) loadFunction("glUniformMatrix2x3fv");
    glUniformMatrix2x4dv = (PFNGLUNIFORMMATRIX2X4DVPROC) loadFunction("glUniformMatrix2x4dv");
    glUniformMatrix2x4fv = (PFNGLUNIFORMMATRIX2X4FVPROC) loadFunction("glUniformMatrix2x4fv");
    glUniformMatrix3dv = (PFNGLUNIFORMMATRIX3DVPROC) loadFunction("glUniformMatrix3dv");
    glUniformMatrix3fv = (PFNGLUNIFORMMATRIX3FVPROC) loadFunction("glUniformMatrix3fv");
    glUniformMatrix3fvARB = (PFNGLUNIFORMMATRIX3FVARBPROC) loadFunction("glUniformMatrix3fvARB");
    glUniformMatrix3x2dv = (PFNGLUNIFORMMATRIX3X2DVPROC) loadFunction("glUniformMatrix3x2dv");
    glUniformMatrix3x2fv = (PFNGLUNIFORMMATRIX3X2FVPROC) loadFunction("glUniformMatrix3x2fv");
    glUniformMatrix3x4dv = (PFNGLUNIFORMMATRIX3X4DVPROC) loadFunction("glUniformMatrix3x4dv");
    glUniformMatrix3x4fv = (PFNGLUNIFORMMATRIX3X4FVPROC) loadFunction("glUniformMatrix3x4fv");
    glUniformMatrix4dv = (PFNGLUNIFORMMATRIX4DVPROC) loadFunction("glUniformMatrix4dv");
    glUniformMatrix4fv = (PFNGLUNIFORMMATRIX4FVPROC) loadFunction("glUniformMatrix4fv");
    glUniformMatrix4fvARB = (PFNGLUNIFORMMATRIX4FVARBPROC) loadFunction("glUniformMatrix4fvARB");
    glUniformMatrix4x2dv = (PFNGLUNIFORMMATRIX4X2DVPROC) loadFunction("glUniformMatrix4x2dv");
    glUniformMatrix4x2fv = (PFNGLUNIFORMMATRIX4X2FVPROC) loadFunction("glUniformMatrix4x2fv");
    glUniformMatrix4x3dv = (PFNGLUNIFORMMATRIX4X3DVPROC) loadFunction("glUniformMatrix4x3dv");
    glUniformMatrix4x3fv = (PFNGLUNIFORMMATRIX4X3FVPROC) loadFunction("glUniformMatrix4x3fv");
    glUniformSubroutinesuiv = (PFNGLUNIFORMSUBROUTINESUIVPROC) loadFunction("glUniformSubroutinesuiv");
    glUniformui64NV = (PFNGLUNIFORMUI64NVPROC) loadFunction("glUniformui64NV");
    glUniformui64vNV = (PFNGLUNIFORMUI64VNVPROC) loadFunction("glUniformui64vNV");
    glUnlockArraysEXT = (PFNGLUNLOCKARRAYSEXTPROC) loadFunction("glUnlockArraysEXT");
    glUnmapBuffer = (PFNGLUNMAPBUFFERPROC) loadFunction("glUnmapBuffer");
    glUnmapBufferARB = (PFNGLUNMAPBUFFERARBPROC) loadFunction("glUnmapBufferARB");
    glUnmapNamedBuffer = (PFNGLUNMAPNAMEDBUFFERPROC) loadFunction("glUnmapNamedBuffer");
    glUnmapNamedBufferEXT = (PFNGLUNMAPNAMEDBUFFEREXTPROC) loadFunction("glUnmapNamedBufferEXT");
    glUnmapTexture2DINTEL = (PFNGLUNMAPTEXTURE2DINTELPROC) loadFunction("glUnmapTexture2DINTEL");
    glUseProgram = (PFNGLUSEPROGRAMPROC) loadFunction("glUseProgram");
    glUseProgramObjectARB = (PFNGLUSEPROGRAMOBJECTARBPROC) loadFunction("glUseProgramObjectARB");
    glUseProgramStages = (PFNGLUSEPROGRAMSTAGESPROC) loadFunction("glUseProgramStages");
    glUseProgramStagesEXT = (PFNGLUSEPROGRAMSTAGESEXTPROC) loadFunction("glUseProgramStagesEXT");
    glUseShaderProgramEXT = (PFNGLUSESHADERPROGRAMEXTPROC) loadFunction("glUseShaderProgramEXT");
    glVDPAUFiniNV = (PFNGLVDPAUFININVPROC) loadFunction("glVDPAUFiniNV");
    glVDPAUGetSurfaceivNV = (PFNGLVDPAUGETSURFACEIVNVPROC) loadFunction("glVDPAUGetSurfaceivNV");
    glVDPAUInitNV = (PFNGLVDPAUINITNVPROC) loadFunction("glVDPAUInitNV");
    glVDPAUIsSurfaceNV = (PFNGLVDPAUISSURFACENVPROC) loadFunction("glVDPAUIsSurfaceNV");
    glVDPAUMapSurfacesNV = (PFNGLVDPAUMAPSURFACESNVPROC) loadFunction("glVDPAUMapSurfacesNV");
    glVDPAURegisterOutputSurfaceNV = (PFNGLVDPAUREGISTEROUTPUTSURFACENVPROC) loadFunction("glVDPAURegisterOutputSurfaceNV");
    glVDPAURegisterVideoSurfaceNV = (PFNGLVDPAUREGISTERVIDEOSURFACENVPROC) loadFunction("glVDPAURegisterVideoSurfaceNV");
    glVDPAURegisterVideoSurfaceWithPictureStructureNV = (PFNGLVDPAUREGISTERVIDEOSURFACEWITHPICTURESTRUCTURENVPROC) loadFunction("glVDPAURegisterVideoSurfaceWithPictureStructureNV");
    glVDPAUSurfaceAccessNV = (PFNGLVDPAUSURFACEACCESSNVPROC) loadFunction("glVDPAUSurfaceAccessNV");
    glVDPAUUnmapSurfacesNV = (PFNGLVDPAUUNMAPSURFACESNVPROC) loadFunction("glVDPAUUnmapSurfacesNV");
    glVDPAUUnregisterSurfaceNV = (PFNGLVDPAUUNREGISTERSURFACENVPROC) loadFunction("glVDPAUUnregisterSurfaceNV");
    glValidateProgram = (PFNGLVALIDATEPROGRAMPROC) loadFunction("glValidateProgram");
    glValidateProgramARB = (PFNGLVALIDATEPROGRAMARBPROC) loadFunction("glValidateProgramARB");
    glValidateProgramPipeline = (PFNGLVALIDATEPROGRAMPIPELINEPROC) loadFunction("glValidateProgramPipeline");
    glValidateProgramPipelineEXT = (PFNGLVALIDATEPROGRAMPIPELINEEXTPROC) loadFunction("glValidateProgramPipelineEXT");
    glVariantPointerEXT = (PFNGLVARIANTPOINTEREXTPROC) loadFunction("glVariantPointerEXT");
    glVariantbvEXT = (PFNGLVARIANTBVEXTPROC) loadFunction("glVariantbvEXT");
    glVariantdvEXT = (PFNGLVARIANTDVEXTPROC) loadFunction("glVariantdvEXT");
    glVariantfvEXT = (PFNGLVARIANTFVEXTPROC) loadFunction("glVariantfvEXT");
    glVariantivEXT = (PFNGLVARIANTIVEXTPROC) loadFunction("glVariantivEXT");
    glVariantsvEXT = (PFNGLVARIANTSVEXTPROC) loadFunction("glVariantsvEXT");
    glVariantubvEXT = (PFNGLVARIANTUBVEXTPROC) loadFunction("glVariantubvEXT");
    glVariantuivEXT = (PFNGLVARIANTUIVEXTPROC) loadFunction("glVariantuivEXT");
    glVariantusvEXT = (PFNGLVARIANTUSVEXTPROC) loadFunction("glVariantusvEXT");
    glVertex2d = (PFNGLVERTEX2DPROC) loadFunction("glVertex2d");
    glVertex2dv = (PFNGLVERTEX2DVPROC) loadFunction("glVertex2dv");
    glVertex2f = (PFNGLVERTEX2FPROC) loadFunction("glVertex2f");
    glVertex2fv = (PFNGLVERTEX2FVPROC) loadFunction("glVertex2fv");
    glVertex2hNV = (PFNGLVERTEX2HNVPROC) loadFunction("glVertex2hNV");
    glVertex2hvNV = (PFNGLVERTEX2HVNVPROC) loadFunction("glVertex2hvNV");
    glVertex2i = (PFNGLVERTEX2IPROC) loadFunction("glVertex2i");
    glVertex2iv = (PFNGLVERTEX2IVPROC) loadFunction("glVertex2iv");
    glVertex2s = (PFNGLVERTEX2SPROC) loadFunction("glVertex2s");
    glVertex2sv = (PFNGLVERTEX2SVPROC) loadFunction("glVertex2sv");
    glVertex3d = (PFNGLVERTEX3DPROC) loadFunction("glVertex3d");
    glVertex3dv = (PFNGLVERTEX3DVPROC) loadFunction("glVertex3dv");
    glVertex3f = (PFNGLVERTEX3FPROC) loadFunction("glVertex3f");
    glVertex3fv = (PFNGLVERTEX3FVPROC) loadFunction("glVertex3fv");
    glVertex3hNV = (PFNGLVERTEX3HNVPROC) loadFunction("glVertex3hNV");
    glVertex3hvNV = (PFNGLVERTEX3HVNVPROC) loadFunction("glVertex3hvNV");
    glVertex3i = (PFNGLVERTEX3IPROC) loadFunction("glVertex3i");
    glVertex3iv = (PFNGLVERTEX3IVPROC) loadFunction("glVertex3iv");
    glVertex3s = (PFNGLVERTEX3SPROC) loadFunction("glVertex3s");
    glVertex3sv = (PFNGLVERTEX3SVPROC) loadFunction("glVertex3sv");
    glVertex4d = (PFNGLVERTEX4DPROC) loadFunction("glVertex4d");
    glVertex4dv = (PFNGLVERTEX4DVPROC) loadFunction("glVertex4dv");
    glVertex4f = (PFNGLVERTEX4FPROC) loadFunction("glVertex4f");
    glVertex4fv = (PFNGLVERTEX4FVPROC) loadFunction("glVertex4fv");
    glVertex4hNV = (PFNGLVERTEX4HNVPROC) loadFunction("glVertex4hNV");
    glVertex4hvNV = (PFNGLVERTEX4HVNVPROC) loadFunction("glVertex4hvNV");
    glVertex4i = (PFNGLVERTEX4IPROC) loadFunction("glVertex4i");
    glVertex4iv = (PFNGLVERTEX4IVPROC) loadFunction("glVertex4iv");
    glVertex4s = (PFNGLVERTEX4SPROC) loadFunction("glVertex4s");
    glVertex4sv = (PFNGLVERTEX4SVPROC) loadFunction("glVertex4sv");
    glVertexArrayAttribBinding = (PFNGLVERTEXARRAYATTRIBBINDINGPROC) loadFunction("glVertexArrayAttribBinding");
    glVertexArrayAttribFormat = (PFNGLVERTEXARRAYATTRIBFORMATPROC) loadFunction("glVertexArrayAttribFormat");
    glVertexArrayAttribIFormat = (PFNGLVERTEXARRAYATTRIBIFORMATPROC) loadFunction("glVertexArrayAttribIFormat");
    glVertexArrayAttribLFormat = (PFNGLVERTEXARRAYATTRIBLFORMATPROC) loadFunction("glVertexArrayAttribLFormat");
    glVertexArrayBindVertexBufferEXT = (PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC) loadFunction("glVertexArrayBindVertexBufferEXT");
    glVertexArrayBindingDivisor = (PFNGLVERTEXARRAYBINDINGDIVISORPROC) loadFunction("glVertexArrayBindingDivisor");
    glVertexArrayColorOffsetEXT = (PFNGLVERTEXARRAYCOLOROFFSETEXTPROC) loadFunction("glVertexArrayColorOffsetEXT");
    glVertexArrayEdgeFlagOffsetEXT = (PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC) loadFunction("glVertexArrayEdgeFlagOffsetEXT");
    glVertexArrayElementBuffer = (PFNGLVERTEXARRAYELEMENTBUFFERPROC) loadFunction("glVertexArrayElementBuffer");
    glVertexArrayFogCoordOffsetEXT = (PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC) loadFunction("glVertexArrayFogCoordOffsetEXT");
    glVertexArrayIndexOffsetEXT = (PFNGLVERTEXARRAYINDEXOFFSETEXTPROC) loadFunction("glVertexArrayIndexOffsetEXT");
    glVertexArrayMultiTexCoordOffsetEXT = (PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC) loadFunction("glVertexArrayMultiTexCoordOffsetEXT");
    glVertexArrayNormalOffsetEXT = (PFNGLVERTEXARRAYNORMALOFFSETEXTPROC) loadFunction("glVertexArrayNormalOffsetEXT");
    glVertexArrayParameteriAPPLE = (PFNGLVERTEXARRAYPARAMETERIAPPLEPROC) loadFunction("glVertexArrayParameteriAPPLE");
    glVertexArrayRangeAPPLE = (PFNGLVERTEXARRAYRANGEAPPLEPROC) loadFunction("glVertexArrayRangeAPPLE");
    glVertexArrayRangeNV = (PFNGLVERTEXARRAYRANGENVPROC) loadFunction("glVertexArrayRangeNV");
    glVertexArraySecondaryColorOffsetEXT = (PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC) loadFunction("glVertexArraySecondaryColorOffsetEXT");
    glVertexArrayTexCoordOffsetEXT = (PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC) loadFunction("glVertexArrayTexCoordOffsetEXT");
    glVertexArrayVertexAttribBindingEXT = (PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC) loadFunction("glVertexArrayVertexAttribBindingEXT");
    glVertexArrayVertexAttribDivisorEXT = (PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC) loadFunction("glVertexArrayVertexAttribDivisorEXT");
    glVertexArrayVertexAttribFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC) loadFunction("glVertexArrayVertexAttribFormatEXT");
    glVertexArrayVertexAttribIFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC) loadFunction("glVertexArrayVertexAttribIFormatEXT");
    glVertexArrayVertexAttribIOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC) loadFunction("glVertexArrayVertexAttribIOffsetEXT");
    glVertexArrayVertexAttribLFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC) loadFunction("glVertexArrayVertexAttribLFormatEXT");
    glVertexArrayVertexAttribLOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC) loadFunction("glVertexArrayVertexAttribLOffsetEXT");
    glVertexArrayVertexAttribOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC) loadFunction("glVertexArrayVertexAttribOffsetEXT");
    glVertexArrayVertexBindingDivisorEXT = (PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC) loadFunction("glVertexArrayVertexBindingDivisorEXT");
    glVertexArrayVertexBuffer = (PFNGLVERTEXARRAYVERTEXBUFFERPROC) loadFunction("glVertexArrayVertexBuffer");
    glVertexArrayVertexBuffers = (PFNGLVERTEXARRAYVERTEXBUFFERSPROC) loadFunction("glVertexArrayVertexBuffers");
    glVertexArrayVertexOffsetEXT = (PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC) loadFunction("glVertexArrayVertexOffsetEXT");
    glVertexAttrib1d = (PFNGLVERTEXATTRIB1DPROC) loadFunction("glVertexAttrib1d");
    glVertexAttrib1dARB = (PFNGLVERTEXATTRIB1DARBPROC) loadFunction("glVertexAttrib1dARB");
    glVertexAttrib1dNV = (PFNGLVERTEXATTRIB1DNVPROC) loadFunction("glVertexAttrib1dNV");
    glVertexAttrib1dv = (PFNGLVERTEXATTRIB1DVPROC) loadFunction("glVertexAttrib1dv");
    glVertexAttrib1dvARB = (PFNGLVERTEXATTRIB1DVARBPROC) loadFunction("glVertexAttrib1dvARB");
    glVertexAttrib1dvNV = (PFNGLVERTEXATTRIB1DVNVPROC) loadFunction("glVertexAttrib1dvNV");
    glVertexAttrib1f = (PFNGLVERTEXATTRIB1FPROC) loadFunction("glVertexAttrib1f");
    glVertexAttrib1fARB = (PFNGLVERTEXATTRIB1FARBPROC) loadFunction("glVertexAttrib1fARB");
    glVertexAttrib1fNV = (PFNGLVERTEXATTRIB1FNVPROC) loadFunction("glVertexAttrib1fNV");
    glVertexAttrib1fv = (PFNGLVERTEXATTRIB1FVPROC) loadFunction("glVertexAttrib1fv");
    glVertexAttrib1fvARB = (PFNGLVERTEXATTRIB1FVARBPROC) loadFunction("glVertexAttrib1fvARB");
    glVertexAttrib1fvNV = (PFNGLVERTEXATTRIB1FVNVPROC) loadFunction("glVertexAttrib1fvNV");
    glVertexAttrib1hNV = (PFNGLVERTEXATTRIB1HNVPROC) loadFunction("glVertexAttrib1hNV");
    glVertexAttrib1hvNV = (PFNGLVERTEXATTRIB1HVNVPROC) loadFunction("glVertexAttrib1hvNV");
    glVertexAttrib1s = (PFNGLVERTEXATTRIB1SPROC) loadFunction("glVertexAttrib1s");
    glVertexAttrib1sARB = (PFNGLVERTEXATTRIB1SARBPROC) loadFunction("glVertexAttrib1sARB");
    glVertexAttrib1sNV = (PFNGLVERTEXATTRIB1SNVPROC) loadFunction("glVertexAttrib1sNV");
    glVertexAttrib1sv = (PFNGLVERTEXATTRIB1SVPROC) loadFunction("glVertexAttrib1sv");
    glVertexAttrib1svARB = (PFNGLVERTEXATTRIB1SVARBPROC) loadFunction("glVertexAttrib1svARB");
    glVertexAttrib1svNV = (PFNGLVERTEXATTRIB1SVNVPROC) loadFunction("glVertexAttrib1svNV");
    glVertexAttrib2d = (PFNGLVERTEXATTRIB2DPROC) loadFunction("glVertexAttrib2d");
    glVertexAttrib2dARB = (PFNGLVERTEXATTRIB2DARBPROC) loadFunction("glVertexAttrib2dARB");
    glVertexAttrib2dNV = (PFNGLVERTEXATTRIB2DNVPROC) loadFunction("glVertexAttrib2dNV");
    glVertexAttrib2dv = (PFNGLVERTEXATTRIB2DVPROC) loadFunction("glVertexAttrib2dv");
    glVertexAttrib2dvARB = (PFNGLVERTEXATTRIB2DVARBPROC) loadFunction("glVertexAttrib2dvARB");
    glVertexAttrib2dvNV = (PFNGLVERTEXATTRIB2DVNVPROC) loadFunction("glVertexAttrib2dvNV");
    glVertexAttrib2f = (PFNGLVERTEXATTRIB2FPROC) loadFunction("glVertexAttrib2f");
    glVertexAttrib2fARB = (PFNGLVERTEXATTRIB2FARBPROC) loadFunction("glVertexAttrib2fARB");
    glVertexAttrib2fNV = (PFNGLVERTEXATTRIB2FNVPROC) loadFunction("glVertexAttrib2fNV");
    glVertexAttrib2fv = (PFNGLVERTEXATTRIB2FVPROC) loadFunction("glVertexAttrib2fv");
    glVertexAttrib2fvARB = (PFNGLVERTEXATTRIB2FVARBPROC) loadFunction("glVertexAttrib2fvARB");
    glVertexAttrib2fvNV = (PFNGLVERTEXATTRIB2FVNVPROC) loadFunction("glVertexAttrib2fvNV");
    glVertexAttrib2hNV = (PFNGLVERTEXATTRIB2HNVPROC) loadFunction("glVertexAttrib2hNV");
    glVertexAttrib2hvNV = (PFNGLVERTEXATTRIB2HVNVPROC) loadFunction("glVertexAttrib2hvNV");
    glVertexAttrib2s = (PFNGLVERTEXATTRIB2SPROC) loadFunction("glVertexAttrib2s");
    glVertexAttrib2sARB = (PFNGLVERTEXATTRIB2SARBPROC) loadFunction("glVertexAttrib2sARB");
    glVertexAttrib2sNV = (PFNGLVERTEXATTRIB2SNVPROC) loadFunction("glVertexAttrib2sNV");
    glVertexAttrib2sv = (PFNGLVERTEXATTRIB2SVPROC) loadFunction("glVertexAttrib2sv");
    glVertexAttrib2svARB = (PFNGLVERTEXATTRIB2SVARBPROC) loadFunction("glVertexAttrib2svARB");
    glVertexAttrib2svNV = (PFNGLVERTEXATTRIB2SVNVPROC) loadFunction("glVertexAttrib2svNV");
    glVertexAttrib3d = (PFNGLVERTEXATTRIB3DPROC) loadFunction("glVertexAttrib3d");
    glVertexAttrib3dARB = (PFNGLVERTEXATTRIB3DARBPROC) loadFunction("glVertexAttrib3dARB");
    glVertexAttrib3dNV = (PFNGLVERTEXATTRIB3DNVPROC) loadFunction("glVertexAttrib3dNV");
    glVertexAttrib3dv = (PFNGLVERTEXATTRIB3DVPROC) loadFunction("glVertexAttrib3dv");
    glVertexAttrib3dvARB = (PFNGLVERTEXATTRIB3DVARBPROC) loadFunction("glVertexAttrib3dvARB");
    glVertexAttrib3dvNV = (PFNGLVERTEXATTRIB3DVNVPROC) loadFunction("glVertexAttrib3dvNV");
    glVertexAttrib3f = (PFNGLVERTEXATTRIB3FPROC) loadFunction("glVertexAttrib3f");
    glVertexAttrib3fARB = (PFNGLVERTEXATTRIB3FARBPROC) loadFunction("glVertexAttrib3fARB");
    glVertexAttrib3fNV = (PFNGLVERTEXATTRIB3FNVPROC) loadFunction("glVertexAttrib3fNV");
    glVertexAttrib3fv = (PFNGLVERTEXATTRIB3FVPROC) loadFunction("glVertexAttrib3fv");
    glVertexAttrib3fvARB = (PFNGLVERTEXATTRIB3FVARBPROC) loadFunction("glVertexAttrib3fvARB");
    glVertexAttrib3fvNV = (PFNGLVERTEXATTRIB3FVNVPROC) loadFunction("glVertexAttrib3fvNV");
    glVertexAttrib3hNV = (PFNGLVERTEXATTRIB3HNVPROC) loadFunction("glVertexAttrib3hNV");
    glVertexAttrib3hvNV = (PFNGLVERTEXATTRIB3HVNVPROC) loadFunction("glVertexAttrib3hvNV");
    glVertexAttrib3s = (PFNGLVERTEXATTRIB3SPROC) loadFunction("glVertexAttrib3s");
    glVertexAttrib3sARB = (PFNGLVERTEXATTRIB3SARBPROC) loadFunction("glVertexAttrib3sARB");
    glVertexAttrib3sNV = (PFNGLVERTEXATTRIB3SNVPROC) loadFunction("glVertexAttrib3sNV");
    glVertexAttrib3sv = (PFNGLVERTEXATTRIB3SVPROC) loadFunction("glVertexAttrib3sv");
    glVertexAttrib3svARB = (PFNGLVERTEXATTRIB3SVARBPROC) loadFunction("glVertexAttrib3svARB");
    glVertexAttrib3svNV = (PFNGLVERTEXATTRIB3SVNVPROC) loadFunction("glVertexAttrib3svNV");
    glVertexAttrib4Nbv = (PFNGLVERTEXATTRIB4NBVPROC) loadFunction("glVertexAttrib4Nbv");
    glVertexAttrib4NbvARB = (PFNGLVERTEXATTRIB4NBVARBPROC) loadFunction("glVertexAttrib4NbvARB");
    glVertexAttrib4Niv = (PFNGLVERTEXATTRIB4NIVPROC) loadFunction("glVertexAttrib4Niv");
    glVertexAttrib4NivARB = (PFNGLVERTEXATTRIB4NIVARBPROC) loadFunction("glVertexAttrib4NivARB");
    glVertexAttrib4Nsv = (PFNGLVERTEXATTRIB4NSVPROC) loadFunction("glVertexAttrib4Nsv");
    glVertexAttrib4NsvARB = (PFNGLVERTEXATTRIB4NSVARBPROC) loadFunction("glVertexAttrib4NsvARB");
    glVertexAttrib4Nub = (PFNGLVERTEXATTRIB4NUBPROC) loadFunction("glVertexAttrib4Nub");
    glVertexAttrib4NubARB = (PFNGLVERTEXATTRIB4NUBARBPROC) loadFunction("glVertexAttrib4NubARB");
    glVertexAttrib4Nubv = (PFNGLVERTEXATTRIB4NUBVPROC) loadFunction("glVertexAttrib4Nubv");
    glVertexAttrib4NubvARB = (PFNGLVERTEXATTRIB4NUBVARBPROC) loadFunction("glVertexAttrib4NubvARB");
    glVertexAttrib4Nuiv = (PFNGLVERTEXATTRIB4NUIVPROC) loadFunction("glVertexAttrib4Nuiv");
    glVertexAttrib4NuivARB = (PFNGLVERTEXATTRIB4NUIVARBPROC) loadFunction("glVertexAttrib4NuivARB");
    glVertexAttrib4Nusv = (PFNGLVERTEXATTRIB4NUSVPROC) loadFunction("glVertexAttrib4Nusv");
    glVertexAttrib4NusvARB = (PFNGLVERTEXATTRIB4NUSVARBPROC) loadFunction("glVertexAttrib4NusvARB");
    glVertexAttrib4bv = (PFNGLVERTEXATTRIB4BVPROC) loadFunction("glVertexAttrib4bv");
    glVertexAttrib4bvARB = (PFNGLVERTEXATTRIB4BVARBPROC) loadFunction("glVertexAttrib4bvARB");
    glVertexAttrib4d = (PFNGLVERTEXATTRIB4DPROC) loadFunction("glVertexAttrib4d");
    glVertexAttrib4dARB = (PFNGLVERTEXATTRIB4DARBPROC) loadFunction("glVertexAttrib4dARB");
    glVertexAttrib4dNV = (PFNGLVERTEXATTRIB4DNVPROC) loadFunction("glVertexAttrib4dNV");
    glVertexAttrib4dv = (PFNGLVERTEXATTRIB4DVPROC) loadFunction("glVertexAttrib4dv");
    glVertexAttrib4dvARB = (PFNGLVERTEXATTRIB4DVARBPROC) loadFunction("glVertexAttrib4dvARB");
    glVertexAttrib4dvNV = (PFNGLVERTEXATTRIB4DVNVPROC) loadFunction("glVertexAttrib4dvNV");
    glVertexAttrib4f = (PFNGLVERTEXATTRIB4FPROC) loadFunction("glVertexAttrib4f");
    glVertexAttrib4fARB = (PFNGLVERTEXATTRIB4FARBPROC) loadFunction("glVertexAttrib4fARB");
    glVertexAttrib4fNV = (PFNGLVERTEXATTRIB4FNVPROC) loadFunction("glVertexAttrib4fNV");
    glVertexAttrib4fv = (PFNGLVERTEXATTRIB4FVPROC) loadFunction("glVertexAttrib4fv");
    glVertexAttrib4fvARB = (PFNGLVERTEXATTRIB4FVARBPROC) loadFunction("glVertexAttrib4fvARB");
    glVertexAttrib4fvNV = (PFNGLVERTEXATTRIB4FVNVPROC) loadFunction("glVertexAttrib4fvNV");
    glVertexAttrib4hNV = (PFNGLVERTEXATTRIB4HNVPROC) loadFunction("glVertexAttrib4hNV");
    glVertexAttrib4hvNV = (PFNGLVERTEXATTRIB4HVNVPROC) loadFunction("glVertexAttrib4hvNV");
    glVertexAttrib4iv = (PFNGLVERTEXATTRIB4IVPROC) loadFunction("glVertexAttrib4iv");
    glVertexAttrib4ivARB = (PFNGLVERTEXATTRIB4IVARBPROC) loadFunction("glVertexAttrib4ivARB");
    glVertexAttrib4s = (PFNGLVERTEXATTRIB4SPROC) loadFunction("glVertexAttrib4s");
    glVertexAttrib4sARB = (PFNGLVERTEXATTRIB4SARBPROC) loadFunction("glVertexAttrib4sARB");
    glVertexAttrib4sNV = (PFNGLVERTEXATTRIB4SNVPROC) loadFunction("glVertexAttrib4sNV");
    glVertexAttrib4sv = (PFNGLVERTEXATTRIB4SVPROC) loadFunction("glVertexAttrib4sv");
    glVertexAttrib4svARB = (PFNGLVERTEXATTRIB4SVARBPROC) loadFunction("glVertexAttrib4svARB");
    glVertexAttrib4svNV = (PFNGLVERTEXATTRIB4SVNVPROC) loadFunction("glVertexAttrib4svNV");
    glVertexAttrib4ubNV = (PFNGLVERTEXATTRIB4UBNVPROC) loadFunction("glVertexAttrib4ubNV");
    glVertexAttrib4ubv = (PFNGLVERTEXATTRIB4UBVPROC) loadFunction("glVertexAttrib4ubv");
    glVertexAttrib4ubvARB = (PFNGLVERTEXATTRIB4UBVARBPROC) loadFunction("glVertexAttrib4ubvARB");
    glVertexAttrib4ubvNV = (PFNGLVERTEXATTRIB4UBVNVPROC) loadFunction("glVertexAttrib4ubvNV");
    glVertexAttrib4uiv = (PFNGLVERTEXATTRIB4UIVPROC) loadFunction("glVertexAttrib4uiv");
    glVertexAttrib4uivARB = (PFNGLVERTEXATTRIB4UIVARBPROC) loadFunction("glVertexAttrib4uivARB");
    glVertexAttrib4usv = (PFNGLVERTEXATTRIB4USVPROC) loadFunction("glVertexAttrib4usv");
    glVertexAttrib4usvARB = (PFNGLVERTEXATTRIB4USVARBPROC) loadFunction("glVertexAttrib4usvARB");
    glVertexAttribBinding = (PFNGLVERTEXATTRIBBINDINGPROC) loadFunction("glVertexAttribBinding");
    glVertexAttribDivisor = (PFNGLVERTEXATTRIBDIVISORPROC) loadFunction("glVertexAttribDivisor");
    glVertexAttribDivisorARB = (PFNGLVERTEXATTRIBDIVISORARBPROC) loadFunction("glVertexAttribDivisorARB");
    glVertexAttribFormat = (PFNGLVERTEXATTRIBFORMATPROC) loadFunction("glVertexAttribFormat");
    glVertexAttribFormatNV = (PFNGLVERTEXATTRIBFORMATNVPROC) loadFunction("glVertexAttribFormatNV");
    glVertexAttribI1i = (PFNGLVERTEXATTRIBI1IPROC) loadFunction("glVertexAttribI1i");
    glVertexAttribI1iEXT = (PFNGLVERTEXATTRIBI1IEXTPROC) loadFunction("glVertexAttribI1iEXT");
    glVertexAttribI1iv = (PFNGLVERTEXATTRIBI1IVPROC) loadFunction("glVertexAttribI1iv");
    glVertexAttribI1ivEXT = (PFNGLVERTEXATTRIBI1IVEXTPROC) loadFunction("glVertexAttribI1ivEXT");
    glVertexAttribI1ui = (PFNGLVERTEXATTRIBI1UIPROC) loadFunction("glVertexAttribI1ui");
    glVertexAttribI1uiEXT = (PFNGLVERTEXATTRIBI1UIEXTPROC) loadFunction("glVertexAttribI1uiEXT");
    glVertexAttribI1uiv = (PFNGLVERTEXATTRIBI1UIVPROC) loadFunction("glVertexAttribI1uiv");
    glVertexAttribI1uivEXT = (PFNGLVERTEXATTRIBI1UIVEXTPROC) loadFunction("glVertexAttribI1uivEXT");
    glVertexAttribI2i = (PFNGLVERTEXATTRIBI2IPROC) loadFunction("glVertexAttribI2i");
    glVertexAttribI2iEXT = (PFNGLVERTEXATTRIBI2IEXTPROC) loadFunction("glVertexAttribI2iEXT");
    glVertexAttribI2iv = (PFNGLVERTEXATTRIBI2IVPROC) loadFunction("glVertexAttribI2iv");
    glVertexAttribI2ivEXT = (PFNGLVERTEXATTRIBI2IVEXTPROC) loadFunction("glVertexAttribI2ivEXT");
    glVertexAttribI2ui = (PFNGLVERTEXATTRIBI2UIPROC) loadFunction("glVertexAttribI2ui");
    glVertexAttribI2uiEXT = (PFNGLVERTEXATTRIBI2UIEXTPROC) loadFunction("glVertexAttribI2uiEXT");
    glVertexAttribI2uiv = (PFNGLVERTEXATTRIBI2UIVPROC) loadFunction("glVertexAttribI2uiv");
    glVertexAttribI2uivEXT = (PFNGLVERTEXATTRIBI2UIVEXTPROC) loadFunction("glVertexAttribI2uivEXT");
    glVertexAttribI3i = (PFNGLVERTEXATTRIBI3IPROC) loadFunction("glVertexAttribI3i");
    glVertexAttribI3iEXT = (PFNGLVERTEXATTRIBI3IEXTPROC) loadFunction("glVertexAttribI3iEXT");
    glVertexAttribI3iv = (PFNGLVERTEXATTRIBI3IVPROC) loadFunction("glVertexAttribI3iv");
    glVertexAttribI3ivEXT = (PFNGLVERTEXATTRIBI3IVEXTPROC) loadFunction("glVertexAttribI3ivEXT");
    glVertexAttribI3ui = (PFNGLVERTEXATTRIBI3UIPROC) loadFunction("glVertexAttribI3ui");
    glVertexAttribI3uiEXT = (PFNGLVERTEXATTRIBI3UIEXTPROC) loadFunction("glVertexAttribI3uiEXT");
    glVertexAttribI3uiv = (PFNGLVERTEXATTRIBI3UIVPROC) loadFunction("glVertexAttribI3uiv");
    glVertexAttribI3uivEXT = (PFNGLVERTEXATTRIBI3UIVEXTPROC) loadFunction("glVertexAttribI3uivEXT");
    glVertexAttribI4bv = (PFNGLVERTEXATTRIBI4BVPROC) loadFunction("glVertexAttribI4bv");
    glVertexAttribI4bvEXT = (PFNGLVERTEXATTRIBI4BVEXTPROC) loadFunction("glVertexAttribI4bvEXT");
    glVertexAttribI4i = (PFNGLVERTEXATTRIBI4IPROC) loadFunction("glVertexAttribI4i");
    glVertexAttribI4iEXT = (PFNGLVERTEXATTRIBI4IEXTPROC) loadFunction("glVertexAttribI4iEXT");
    glVertexAttribI4iv = (PFNGLVERTEXATTRIBI4IVPROC) loadFunction("glVertexAttribI4iv");
    glVertexAttribI4ivEXT = (PFNGLVERTEXATTRIBI4IVEXTPROC) loadFunction("glVertexAttribI4ivEXT");
    glVertexAttribI4sv = (PFNGLVERTEXATTRIBI4SVPROC) loadFunction("glVertexAttribI4sv");
    glVertexAttribI4svEXT = (PFNGLVERTEXATTRIBI4SVEXTPROC) loadFunction("glVertexAttribI4svEXT");
    glVertexAttribI4ubv = (PFNGLVERTEXATTRIBI4UBVPROC) loadFunction("glVertexAttribI4ubv");
    glVertexAttribI4ubvEXT = (PFNGLVERTEXATTRIBI4UBVEXTPROC) loadFunction("glVertexAttribI4ubvEXT");
    glVertexAttribI4ui = (PFNGLVERTEXATTRIBI4UIPROC) loadFunction("glVertexAttribI4ui");
    glVertexAttribI4uiEXT = (PFNGLVERTEXATTRIBI4UIEXTPROC) loadFunction("glVertexAttribI4uiEXT");
    glVertexAttribI4uiv = (PFNGLVERTEXATTRIBI4UIVPROC) loadFunction("glVertexAttribI4uiv");
    glVertexAttribI4uivEXT = (PFNGLVERTEXATTRIBI4UIVEXTPROC) loadFunction("glVertexAttribI4uivEXT");
    glVertexAttribI4usv = (PFNGLVERTEXATTRIBI4USVPROC) loadFunction("glVertexAttribI4usv");
    glVertexAttribI4usvEXT = (PFNGLVERTEXATTRIBI4USVEXTPROC) loadFunction("glVertexAttribI4usvEXT");
    glVertexAttribIFormat = (PFNGLVERTEXATTRIBIFORMATPROC) loadFunction("glVertexAttribIFormat");
    glVertexAttribIFormatNV = (PFNGLVERTEXATTRIBIFORMATNVPROC) loadFunction("glVertexAttribIFormatNV");
    glVertexAttribIPointer = (PFNGLVERTEXATTRIBIPOINTERPROC) loadFunction("glVertexAttribIPointer");
    glVertexAttribIPointerEXT = (PFNGLVERTEXATTRIBIPOINTEREXTPROC) loadFunction("glVertexAttribIPointerEXT");
    glVertexAttribL1d = (PFNGLVERTEXATTRIBL1DPROC) loadFunction("glVertexAttribL1d");
    glVertexAttribL1dEXT = (PFNGLVERTEXATTRIBL1DEXTPROC) loadFunction("glVertexAttribL1dEXT");
    glVertexAttribL1dv = (PFNGLVERTEXATTRIBL1DVPROC) loadFunction("glVertexAttribL1dv");
    glVertexAttribL1dvEXT = (PFNGLVERTEXATTRIBL1DVEXTPROC) loadFunction("glVertexAttribL1dvEXT");
    glVertexAttribL1i64NV = (PFNGLVERTEXATTRIBL1I64NVPROC) loadFunction("glVertexAttribL1i64NV");
    glVertexAttribL1i64vNV = (PFNGLVERTEXATTRIBL1I64VNVPROC) loadFunction("glVertexAttribL1i64vNV");
    glVertexAttribL1ui64ARB = (PFNGLVERTEXATTRIBL1UI64ARBPROC) loadFunction("glVertexAttribL1ui64ARB");
    glVertexAttribL1ui64NV = (PFNGLVERTEXATTRIBL1UI64NVPROC) loadFunction("glVertexAttribL1ui64NV");
    glVertexAttribL1ui64vARB = (PFNGLVERTEXATTRIBL1UI64VARBPROC) loadFunction("glVertexAttribL1ui64vARB");
    glVertexAttribL1ui64vNV = (PFNGLVERTEXATTRIBL1UI64VNVPROC) loadFunction("glVertexAttribL1ui64vNV");
    glVertexAttribL2d = (PFNGLVERTEXATTRIBL2DPROC) loadFunction("glVertexAttribL2d");
    glVertexAttribL2dEXT = (PFNGLVERTEXATTRIBL2DEXTPROC) loadFunction("glVertexAttribL2dEXT");
    glVertexAttribL2dv = (PFNGLVERTEXATTRIBL2DVPROC) loadFunction("glVertexAttribL2dv");
    glVertexAttribL2dvEXT = (PFNGLVERTEXATTRIBL2DVEXTPROC) loadFunction("glVertexAttribL2dvEXT");
    glVertexAttribL2i64NV = (PFNGLVERTEXATTRIBL2I64NVPROC) loadFunction("glVertexAttribL2i64NV");
    glVertexAttribL2i64vNV = (PFNGLVERTEXATTRIBL2I64VNVPROC) loadFunction("glVertexAttribL2i64vNV");
    glVertexAttribL2ui64NV = (PFNGLVERTEXATTRIBL2UI64NVPROC) loadFunction("glVertexAttribL2ui64NV");
    glVertexAttribL2ui64vNV = (PFNGLVERTEXATTRIBL2UI64VNVPROC) loadFunction("glVertexAttribL2ui64vNV");
    glVertexAttribL3d = (PFNGLVERTEXATTRIBL3DPROC) loadFunction("glVertexAttribL3d");
    glVertexAttribL3dEXT = (PFNGLVERTEXATTRIBL3DEXTPROC) loadFunction("glVertexAttribL3dEXT");
    glVertexAttribL3dv = (PFNGLVERTEXATTRIBL3DVPROC) loadFunction("glVertexAttribL3dv");
    glVertexAttribL3dvEXT = (PFNGLVERTEXATTRIBL3DVEXTPROC) loadFunction("glVertexAttribL3dvEXT");
    glVertexAttribL3i64NV = (PFNGLVERTEXATTRIBL3I64NVPROC) loadFunction("glVertexAttribL3i64NV");
    glVertexAttribL3i64vNV = (PFNGLVERTEXATTRIBL3I64VNVPROC) loadFunction("glVertexAttribL3i64vNV");
    glVertexAttribL3ui64NV = (PFNGLVERTEXATTRIBL3UI64NVPROC) loadFunction("glVertexAttribL3ui64NV");
    glVertexAttribL3ui64vNV = (PFNGLVERTEXATTRIBL3UI64VNVPROC) loadFunction("glVertexAttribL3ui64vNV");
    glVertexAttribL4d = (PFNGLVERTEXATTRIBL4DPROC) loadFunction("glVertexAttribL4d");
    glVertexAttribL4dEXT = (PFNGLVERTEXATTRIBL4DEXTPROC) loadFunction("glVertexAttribL4dEXT");
    glVertexAttribL4dv = (PFNGLVERTEXATTRIBL4DVPROC) loadFunction("glVertexAttribL4dv");
    glVertexAttribL4dvEXT = (PFNGLVERTEXATTRIBL4DVEXTPROC) loadFunction("glVertexAttribL4dvEXT");
    glVertexAttribL4i64NV = (PFNGLVERTEXATTRIBL4I64NVPROC) loadFunction("glVertexAttribL4i64NV");
    glVertexAttribL4i64vNV = (PFNGLVERTEXATTRIBL4I64VNVPROC) loadFunction("glVertexAttribL4i64vNV");
    glVertexAttribL4ui64NV = (PFNGLVERTEXATTRIBL4UI64NVPROC) loadFunction("glVertexAttribL4ui64NV");
    glVertexAttribL4ui64vNV = (PFNGLVERTEXATTRIBL4UI64VNVPROC) loadFunction("glVertexAttribL4ui64vNV");
    glVertexAttribLFormat = (PFNGLVERTEXATTRIBLFORMATPROC) loadFunction("glVertexAttribLFormat");
    glVertexAttribLFormatNV = (PFNGLVERTEXATTRIBLFORMATNVPROC) loadFunction("glVertexAttribLFormatNV");
    glVertexAttribLPointer = (PFNGLVERTEXATTRIBLPOINTERPROC) loadFunction("glVertexAttribLPointer");
    glVertexAttribLPointerEXT = (PFNGLVERTEXATTRIBLPOINTEREXTPROC) loadFunction("glVertexAttribLPointerEXT");
    glVertexAttribP1ui = (PFNGLVERTEXATTRIBP1UIPROC) loadFunction("glVertexAttribP1ui");
    glVertexAttribP1uiv = (PFNGLVERTEXATTRIBP1UIVPROC) loadFunction("glVertexAttribP1uiv");
    glVertexAttribP2ui = (PFNGLVERTEXATTRIBP2UIPROC) loadFunction("glVertexAttribP2ui");
    glVertexAttribP2uiv = (PFNGLVERTEXATTRIBP2UIVPROC) loadFunction("glVertexAttribP2uiv");
    glVertexAttribP3ui = (PFNGLVERTEXATTRIBP3UIPROC) loadFunction("glVertexAttribP3ui");
    glVertexAttribP3uiv = (PFNGLVERTEXATTRIBP3UIVPROC) loadFunction("glVertexAttribP3uiv");
    glVertexAttribP4ui = (PFNGLVERTEXATTRIBP4UIPROC) loadFunction("glVertexAttribP4ui");
    glVertexAttribP4uiv = (PFNGLVERTEXATTRIBP4UIVPROC) loadFunction("glVertexAttribP4uiv");
    glVertexAttribParameteriAMD = (PFNGLVERTEXATTRIBPARAMETERIAMDPROC) loadFunction("glVertexAttribParameteriAMD");
    glVertexAttribPointer = (PFNGLVERTEXATTRIBPOINTERPROC) loadFunction("glVertexAttribPointer");
    glVertexAttribPointerARB = (PFNGLVERTEXATTRIBPOINTERARBPROC) loadFunction("glVertexAttribPointerARB");
    glVertexAttribPointerNV = (PFNGLVERTEXATTRIBPOINTERNVPROC) loadFunction("glVertexAttribPointerNV");
    glVertexAttribs1dvNV = (PFNGLVERTEXATTRIBS1DVNVPROC) loadFunction("glVertexAttribs1dvNV");
    glVertexAttribs1fvNV = (PFNGLVERTEXATTRIBS1FVNVPROC) loadFunction("glVertexAttribs1fvNV");
    glVertexAttribs1hvNV = (PFNGLVERTEXATTRIBS1HVNVPROC) loadFunction("glVertexAttribs1hvNV");
    glVertexAttribs1svNV = (PFNGLVERTEXATTRIBS1SVNVPROC) loadFunction("glVertexAttribs1svNV");
    glVertexAttribs2dvNV = (PFNGLVERTEXATTRIBS2DVNVPROC) loadFunction("glVertexAttribs2dvNV");
    glVertexAttribs2fvNV = (PFNGLVERTEXATTRIBS2FVNVPROC) loadFunction("glVertexAttribs2fvNV");
    glVertexAttribs2hvNV = (PFNGLVERTEXATTRIBS2HVNVPROC) loadFunction("glVertexAttribs2hvNV");
    glVertexAttribs2svNV = (PFNGLVERTEXATTRIBS2SVNVPROC) loadFunction("glVertexAttribs2svNV");
    glVertexAttribs3dvNV = (PFNGLVERTEXATTRIBS3DVNVPROC) loadFunction("glVertexAttribs3dvNV");
    glVertexAttribs3fvNV = (PFNGLVERTEXATTRIBS3FVNVPROC) loadFunction("glVertexAttribs3fvNV");
    glVertexAttribs3hvNV = (PFNGLVERTEXATTRIBS3HVNVPROC) loadFunction("glVertexAttribs3hvNV");
    glVertexAttribs3svNV = (PFNGLVERTEXATTRIBS3SVNVPROC) loadFunction("glVertexAttribs3svNV");
    glVertexAttribs4dvNV = (PFNGLVERTEXATTRIBS4DVNVPROC) loadFunction("glVertexAttribs4dvNV");
    glVertexAttribs4fvNV = (PFNGLVERTEXATTRIBS4FVNVPROC) loadFunction("glVertexAttribs4fvNV");
    glVertexAttribs4hvNV = (PFNGLVERTEXATTRIBS4HVNVPROC) loadFunction("glVertexAttribs4hvNV");
    glVertexAttribs4svNV = (PFNGLVERTEXATTRIBS4SVNVPROC) loadFunction("glVertexAttribs4svNV");
    glVertexAttribs4ubvNV = (PFNGLVERTEXATTRIBS4UBVNVPROC) loadFunction("glVertexAttribs4ubvNV");
    glVertexBindingDivisor = (PFNGLVERTEXBINDINGDIVISORPROC) loadFunction("glVertexBindingDivisor");
    glVertexBlendARB = (PFNGLVERTEXBLENDARBPROC) loadFunction("glVertexBlendARB");
    glVertexFormatNV = (PFNGLVERTEXFORMATNVPROC) loadFunction("glVertexFormatNV");
    glVertexP2ui = (PFNGLVERTEXP2UIPROC) loadFunction("glVertexP2ui");
    glVertexP2uiv = (PFNGLVERTEXP2UIVPROC) loadFunction("glVertexP2uiv");
    glVertexP3ui = (PFNGLVERTEXP3UIPROC) loadFunction("glVertexP3ui");
    glVertexP3uiv = (PFNGLVERTEXP3UIVPROC) loadFunction("glVertexP3uiv");
    glVertexP4ui = (PFNGLVERTEXP4UIPROC) loadFunction("glVertexP4ui");
    glVertexP4uiv = (PFNGLVERTEXP4UIVPROC) loadFunction("glVertexP4uiv");
    glVertexPointer = (PFNGLVERTEXPOINTERPROC) loadFunction("glVertexPointer");
    glVertexPointerEXT = (PFNGLVERTEXPOINTEREXTPROC) loadFunction("glVertexPointerEXT");
    glVertexPointervINTEL = (PFNGLVERTEXPOINTERVINTELPROC) loadFunction("glVertexPointervINTEL");
    glVertexWeightPointerEXT = (PFNGLVERTEXWEIGHTPOINTEREXTPROC) loadFunction("glVertexWeightPointerEXT");
    glVertexWeightfEXT = (PFNGLVERTEXWEIGHTFEXTPROC) loadFunction("glVertexWeightfEXT");
    glVertexWeightfvEXT = (PFNGLVERTEXWEIGHTFVEXTPROC) loadFunction("glVertexWeightfvEXT");
    glVertexWeighthNV = (PFNGLVERTEXWEIGHTHNVPROC) loadFunction("glVertexWeighthNV");
    glVertexWeighthvNV = (PFNGLVERTEXWEIGHTHVNVPROC) loadFunction("glVertexWeighthvNV");
    glVideoCaptureNV = (PFNGLVIDEOCAPTURENVPROC) loadFunction("glVideoCaptureNV");
    glVideoCaptureStreamParameterdvNV = (PFNGLVIDEOCAPTURESTREAMPARAMETERDVNVPROC) loadFunction("glVideoCaptureStreamParameterdvNV");
    glVideoCaptureStreamParameterfvNV = (PFNGLVIDEOCAPTURESTREAMPARAMETERFVNVPROC) loadFunction("glVideoCaptureStreamParameterfvNV");
    glVideoCaptureStreamParameterivNV = (PFNGLVIDEOCAPTURESTREAMPARAMETERIVNVPROC) loadFunction("glVideoCaptureStreamParameterivNV");
    glViewport = (PFNGLVIEWPORTPROC) loadFunction("glViewport");
    glViewportArrayv = (PFNGLVIEWPORTARRAYVPROC) loadFunction("glViewportArrayv");
    glViewportIndexedf = (PFNGLVIEWPORTINDEXEDFPROC) loadFunction("glViewportIndexedf");
    glViewportIndexedfv = (PFNGLVIEWPORTINDEXEDFVPROC) loadFunction("glViewportIndexedfv");
    glViewportPositionWScaleNV = (PFNGLVIEWPORTPOSITIONWSCALENVPROC) loadFunction("glViewportPositionWScaleNV");
    glViewportSwizzleNV = (PFNGLVIEWPORTSWIZZLENVPROC) loadFunction("glViewportSwizzleNV");
    glWaitSemaphoreEXT = (PFNGLWAITSEMAPHOREEXTPROC) loadFunction("glWaitSemaphoreEXT");
    glWaitSync = (PFNGLWAITSYNCPROC) loadFunction("glWaitSync");
    glWeightPathsNV = (PFNGLWEIGHTPATHSNVPROC) loadFunction("glWeightPathsNV");
    glWeightPointerARB = (PFNGLWEIGHTPOINTERARBPROC) loadFunction("glWeightPointerARB");
    glWeightbvARB = (PFNGLWEIGHTBVARBPROC) loadFunction("glWeightbvARB");
    glWeightdvARB = (PFNGLWEIGHTDVARBPROC) loadFunction("glWeightdvARB");
    glWeightfvARB = (PFNGLWEIGHTFVARBPROC) loadFunction("glWeightfvARB");
    glWeightivARB = (PFNGLWEIGHTIVARBPROC) loadFunction("glWeightivARB");
    glWeightsvARB = (PFNGLWEIGHTSVARBPROC) loadFunction("glWeightsvARB");
    glWeightubvARB = (PFNGLWEIGHTUBVARBPROC) loadFunction("glWeightubvARB");
    glWeightuivARB = (PFNGLWEIGHTUIVARBPROC) loadFunction("glWeightuivARB");
    glWeightusvARB = (PFNGLWEIGHTUSVARBPROC) loadFunction("glWeightusvARB");
    glWindowPos2d = (PFNGLWINDOWPOS2DPROC) loadFunction("glWindowPos2d");
    glWindowPos2dARB = (PFNGLWINDOWPOS2DARBPROC) loadFunction("glWindowPos2dARB");
    glWindowPos2dv = (PFNGLWINDOWPOS2DVPROC) loadFunction("glWindowPos2dv");
    glWindowPos2dvARB = (PFNGLWINDOWPOS2DVARBPROC) loadFunction("glWindowPos2dvARB");
    glWindowPos2f = (PFNGLWINDOWPOS2FPROC) loadFunction("glWindowPos2f");
    glWindowPos2fARB = (PFNGLWINDOWPOS2FARBPROC) loadFunction("glWindowPos2fARB");
    glWindowPos2fv = (PFNGLWINDOWPOS2FVPROC) loadFunction("glWindowPos2fv");
    glWindowPos2fvARB = (PFNGLWINDOWPOS2FVARBPROC) loadFunction("glWindowPos2fvARB");
    glWindowPos2i = (PFNGLWINDOWPOS2IPROC) loadFunction("glWindowPos2i");
    glWindowPos2iARB = (PFNGLWINDOWPOS2IARBPROC) loadFunction("glWindowPos2iARB");
    glWindowPos2iv = (PFNGLWINDOWPOS2IVPROC) loadFunction("glWindowPos2iv");
    glWindowPos2ivARB = (PFNGLWINDOWPOS2IVARBPROC) loadFunction("glWindowPos2ivARB");
    glWindowPos2s = (PFNGLWINDOWPOS2SPROC) loadFunction("glWindowPos2s");
    glWindowPos2sARB = (PFNGLWINDOWPOS2SARBPROC) loadFunction("glWindowPos2sARB");
    glWindowPos2sv = (PFNGLWINDOWPOS2SVPROC) loadFunction("glWindowPos2sv");
    glWindowPos2svARB = (PFNGLWINDOWPOS2SVARBPROC) loadFunction("glWindowPos2svARB");
    glWindowPos3d = (PFNGLWINDOWPOS3DPROC) loadFunction("glWindowPos3d");
    glWindowPos3dARB = (PFNGLWINDOWPOS3DARBPROC) loadFunction("glWindowPos3dARB");
    glWindowPos3dv = (PFNGLWINDOWPOS3DVPROC) loadFunction("glWindowPos3dv");
    glWindowPos3dvARB = (PFNGLWINDOWPOS3DVARBPROC) loadFunction("glWindowPos3dvARB");
    glWindowPos3f = (PFNGLWINDOWPOS3FPROC) loadFunction("glWindowPos3f");
    glWindowPos3fARB = (PFNGLWINDOWPOS3FARBPROC) loadFunction("glWindowPos3fARB");
    glWindowPos3fv = (PFNGLWINDOWPOS3FVPROC) loadFunction("glWindowPos3fv");
    glWindowPos3fvARB = (PFNGLWINDOWPOS3FVARBPROC) loadFunction("glWindowPos3fvARB");
    glWindowPos3i = (PFNGLWINDOWPOS3IPROC) loadFunction("glWindowPos3i");
    glWindowPos3iARB = (PFNGLWINDOWPOS3IARBPROC) loadFunction("glWindowPos3iARB");
    glWindowPos3iv = (PFNGLWINDOWPOS3IVPROC) loadFunction("glWindowPos3iv");
    glWindowPos3ivARB = (PFNGLWINDOWPOS3IVARBPROC) loadFunction("glWindowPos3ivARB");
    glWindowPos3s = (PFNGLWINDOWPOS3SPROC) loadFunction("glWindowPos3s");
    glWindowPos3sARB = (PFNGLWINDOWPOS3SARBPROC) loadFunction("glWindowPos3sARB");
    glWindowPos3sv = (PFNGLWINDOWPOS3SVPROC) loadFunction("glWindowPos3sv");
    glWindowPos3svARB = (PFNGLWINDOWPOS3SVARBPROC) loadFunction("glWindowPos3svARB");
    glWindowRectanglesEXT = (PFNGLWINDOWRECTANGLESEXTPROC) loadFunction("glWindowRectanglesEXT");
    glWriteMaskEXT = (PFNGLWRITEMASKEXTPROC) loadFunction("glWriteMaskEXT");
    glDrawVkImageNV = (PFNGLDRAWVKIMAGENVPROC) loadFunction("glDrawVkImageNV");
    glGetVkProcAddrNV = (PFNGLGETVKPROCADDRNVPROC) loadFunction("glGetVkProcAddrNV");
    glWaitVkSemaphoreNV = (PFNGLWAITVKSEMAPHORENVPROC) loadFunction("glWaitVkSemaphoreNV");
    glSignalVkSemaphoreNV = (PFNGLSIGNALVKSEMAPHORENVPROC) loadFunction("glSignalVkSemaphoreNV");
    glSignalVkFenceNV = (PFNGLSIGNALVKFENCENVPROC) loadFunction("glSignalVkFenceNV");

    return true;
}

bool glApiLoad()
{
    static bool initialized = false;
    if (initialized) { return true; }
    initialized = true;

    return loadLibrary() && loadSymbols();
}

void glApiUnload(void)
{
    unloadLibrary();
}


}  // namespace GLApi
}  // namespace internal
}  // namespace OpenSubdiv
