# - Find freetype
# Find the native FREETYPE includes and library
#
#  FREETYPE_INCLUDE_DIR - where to find ft2build.h, etc.
#  FREETYPE_LIBRARIES   - List of libraries when using freetype.
#  FREETYPE_FOUND       - True if freetype found.

FIND_PACKAGE(ZLIB)

IF (FREETYPE_INCLUDE_DIR)
  # Already in cache, be silent
  SET(FREETYPE_FIND_QUIETLY TRUE)
ENDIF (FREETYPE_INCLUDE_DIR)

FIND_PATH(FREETYPE_INCLUDE_DIR ft2build.h
  /usr/local/include
  /usr/include
   $ENV{MINGDIR}/include
)

# need to append the freetype2 dir wherever ft2build is found
IF(FREETYPE_INCLUDE_DIR)
	IF(NOT FREETYPE_INCLUDE_DIR MATCHES "^.*freetype2")
		SET(FREETYPE_INCLUDE_DIR ${FREETYPE_INCLUDE_DIR}/freetype2)
	ENDIF(NOT FREETYPE_INCLUDE_DIR MATCHES "^.*freetype2")
ENDIF(FREETYPE_INCLUDE_DIR)

SET(FREETYPE_NAMES ft ftlib ftdll freetype freetypelib freetypedll)
FIND_LIBRARY(FREETYPE_LIBRARY
NAMES ${FREETYPE_NAMES}
PATHS /usr/lib /usr/local/lib $ENV{MINGDIR}/lib)

IF (FREETYPE_INCLUDE_DIR AND FREETYPE_LIBRARY)
   SET(FREETYPE_FOUND TRUE)
    SET( FREETYPE_LIBRARIES ${FREETYPE_LIBRARY} ${ZLIB_LIBRARIES})
ELSE (FREETYPE_INCLUDE_DIR AND FREETYPE_LIBRARY)
   SET(FREETYPE_FOUND FALSE)
   SET( FREETYPE_LIBRARIES )
ENDIF (FREETYPE_INCLUDE_DIR AND FREETYPE_LIBRARY)

IF (FREETYPE_FOUND)
   IF (NOT FREETYPE_FIND_QUIETLY)
      MESSAGE(STATUS "Found Freetype: ${FREETYPE_LIBRARY}")
   ENDIF (NOT FREETYPE_FIND_QUIETLY)
ELSE (FREETYPE_FOUND)
   IF (FREETYPE_FIND_REQUIRED)
      MESSAGE(STATUS "Looked for Freetype libraries named ${FREETYPE_NAMES}.")
      MESSAGE(FATAL_ERROR "Could NOT find Freetype library")
   ENDIF (FREETYPE_FIND_REQUIRED)
ENDIF (FREETYPE_FOUND)

#MARK_AS_ADVANCED(
#  FREETYPE_LIBRARY
#  FREETYPE_INCLUDE_DIR
#  )