/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.CacheDownloadOptions;
import org.apache.ivy.core.cache.CacheMetadataOptions;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager$1;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager$BackupResourceDownloader;
import org.apache.ivy.core.cache.DownloadListener;
import org.apache.ivy.core.cache.ModuleDescriptorMemoryCache;
import org.apache.ivy.core.cache.ModuleDescriptorProvider;
import org.apache.ivy.core.cache.ModuleDescriptorWriter;
import org.apache.ivy.core.cache.ParserSettingsMonitor;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.NoMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.repository.ArtifactResourceResolver;
import org.apache.ivy.plugins.repository.ResourceDownloader;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.PropertiesFile;
import scala.collection.mutable.GrowingBuilder;
import xsbt.boot.Update;
import xsbt.boot.UpdateResult;

public final class DefaultRepositoryCacheManager
implements RepositoryCacheManager,
IvySettingsAware {
    private IvySettings settings;
    private File basedir;
    private LockStrategy lockStrategy;
    private String name;
    private String ivyPattern;
    private String dataFilePattern = "[organisation]/[module](/[branch])/ivydata-[revision].properties";
    private String artifactPattern;
    private String changingPattern;
    private String changingMatcherName = "exactOrRegexp";
    private Boolean useOrigin;
    private ModuleRules ttlRules = new ModuleRules();
    private Long defaultTTL = null;
    private ModuleDescriptorMemoryCache memoryModuleDescrCache;
    private static final Pattern DURATION_PATTERN;

    public DefaultRepositoryCacheManager() {
    }

    public DefaultRepositoryCacheManager(String string, IvySettings ivySettings, File file2) {
        File file3;
        String string2;
        this.name = string2 = string;
        this.setSettings(ivySettings);
        this.basedir = file3 = file2;
    }

    public final void setSettings(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    private File getIvyFileInCache(ModuleRevisionId moduleRevisionId) {
        String string = IvyPatternHelper.substitute(this.getIvyPattern(), DefaultArtifact.newIvyArtifact(moduleRevisionId, null));
        return new File(this.getRepositoryCacheRoot(), string);
    }

    private String getIvyPattern() {
        if (this.ivyPattern == null) {
            if (this.settings != null) {
                this.ivyPattern = this.settings.getDefaultCacheIvyPattern();
            }
            if (this.ivyPattern == null) {
                this.ivyPattern = "[organisation]/[module](/[branch])/ivy-[revision].xml";
            }
        }
        return this.ivyPattern;
    }

    public final void setBasedir(File file2) {
        this.basedir = file2;
    }

    public final String getName() {
        return this.name;
    }

    public final void setChangingMatcher(String string) {
        this.changingMatcherName = string;
    }

    public final void setChangingPattern(String string) {
        this.changingPattern = string;
    }

    private ModuleDescriptorMemoryCache getMemoryCache() {
        if (this.memoryModuleDescrCache == null) {
            this.memoryModuleDescrCache = new ModuleDescriptorMemoryCache();
        }
        return this.memoryModuleDescrCache;
    }

    private static int getGroupIntValue(java.util.regex.Matcher matcher, int n) {
        String string = matcher.group(n);
        if (string == null || string.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public final void setUseOrigin$1385ff() {
        this.useOrigin = true;
    }

    private File getArchiveFileInCache(Artifact artifact, ArtifactOrigin artifactOrigin) {
        File file2;
        File file3 = new File(this.getRepositoryCacheRoot(), this.getArchivePathInCache(artifact, artifactOrigin));
        if (!file3.exists() && !ArtifactOrigin.isUnknown(artifactOrigin) && artifactOrigin.isLocal() && (file2 = Update.checkAbsolute(artifactOrigin.getLocation(), artifact + " origin location")).exists()) {
            return file2;
        }
        return file3;
    }

    private File getArchiveFileInCache(Artifact artifact, ArtifactOrigin artifactOrigin, boolean bl) {
        if (bl && !ArtifactOrigin.isUnknown(artifactOrigin) && artifactOrigin.isLocal()) {
            return Update.checkAbsolute(artifactOrigin.getLocation(), artifact + " origin location");
        }
        return new File(this.getRepositoryCacheRoot(), this.getArchivePathInCache(artifact, artifactOrigin));
    }

    private String getArchivePathInCache(Artifact artifact, ArtifactOrigin artifactOrigin) {
        Object object = artifact;
        if (object.isMetadata() && object.getType().endsWith(".original")) {
            return IvyPatternHelper.substitute(this.getIvyPattern() + ".original", artifact, artifactOrigin);
        }
        object = this;
        if (((DefaultRepositoryCacheManager)object).artifactPattern == null) {
            if (((DefaultRepositoryCacheManager)object).settings != null) {
                ((DefaultRepositoryCacheManager)object).artifactPattern = ((DefaultRepositoryCacheManager)object).settings.getDefaultCacheArtifactPattern();
            }
            if (((DefaultRepositoryCacheManager)object).artifactPattern == null) {
                ((DefaultRepositoryCacheManager)object).artifactPattern = "[organisation]/[module](/[branch])/[type]s/[artifact]-[revision](-[classifier])(.[ext])";
            }
        }
        return IvyPatternHelper.substitute(((DefaultRepositoryCacheManager)object).artifactPattern, artifact, artifactOrigin);
    }

    public final void saveResolvers(ModuleDescriptor moduleDescriptor, String string, String string2) {
        ModuleRevisionId moduleRevisionId = moduleDescriptor.getResolvedModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return;
        }
        try {
            PropertiesFile propertiesFile = this.getCachedDataFile(moduleDescriptor);
            propertiesFile.setProperty("resolver", string);
            propertiesFile.setProperty("artifact.resolver", string2);
            propertiesFile.save();
            return;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    private void saveArtifactOrigin(Artifact artifact, ArtifactOrigin artifactOrigin) {
        PropertiesFile propertiesFile = this.getCachedDataFile(artifact.getModuleRevisionId());
        propertiesFile.setProperty(DefaultRepositoryCacheManager.getIsLocalKey(artifact), String.valueOf(artifactOrigin.isLocal()));
        propertiesFile.setProperty(DefaultRepositoryCacheManager.getLocationKey(artifact), artifactOrigin.getLocation());
        if (artifactOrigin.getLastChecked() != null) {
            propertiesFile.setProperty(DefaultRepositoryCacheManager.getLastCheckedKey(artifact), artifactOrigin.getLastChecked().toString());
        }
        propertiesFile.setProperty(DefaultRepositoryCacheManager.getExistsKey(artifact), Boolean.toString(artifactOrigin.isExists()));
        propertiesFile.save();
    }

    private void removeSavedArtifactOrigin(Artifact artifact) {
        PropertiesFile propertiesFile = this.getCachedDataFile(artifact.getModuleRevisionId());
        propertiesFile.remove(DefaultRepositoryCacheManager.getLocationKey(artifact));
        propertiesFile.remove(DefaultRepositoryCacheManager.getIsLocalKey(artifact));
        propertiesFile.remove(DefaultRepositoryCacheManager.getLastCheckedKey(artifact));
        propertiesFile.save();
    }

    public final ArtifactOrigin getSavedArtifactOrigin(Artifact artifact) {
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return ArtifactOrigin.unkwnown(artifact);
        }
        try {
            PropertiesFile propertiesFile = this.getCachedDataFile(artifact.getModuleRevisionId());
            String string = propertiesFile.getProperty(DefaultRepositoryCacheManager.getLocationKey(artifact));
            String string2 = propertiesFile.getProperty(DefaultRepositoryCacheManager.getIsLocalKey(artifact));
            String string3 = propertiesFile.getProperty(DefaultRepositoryCacheManager.getLastCheckedKey(artifact));
            String string4 = propertiesFile.getProperty(DefaultRepositoryCacheManager.getExistsKey(artifact));
            boolean bl = Boolean.valueOf(string2);
            if (string == null) {
                ArtifactOrigin artifactOrigin = ArtifactOrigin.unkwnown(artifact);
                return artifactOrigin;
            }
            ArtifactOrigin artifactOrigin = new ArtifactOrigin(artifact, bl, string);
            if (string3 != null) {
                artifactOrigin.setLastChecked(Long.valueOf(string3));
            }
            if (string4 != null) {
                artifactOrigin.setExist(Boolean.valueOf(string4));
            }
            ArtifactOrigin artifactOrigin2 = artifactOrigin;
            return artifactOrigin2;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    private static String getPrefixKey(Artifact artifact) {
        int n = artifact.getId().hashCode();
        return "artifact:" + artifact.getName() + "#" + artifact.getType() + "#" + artifact.getExt() + "#" + n;
    }

    private static String getLocationKey(Artifact artifact) {
        String string = DefaultRepositoryCacheManager.getPrefixKey(artifact);
        return string + ".location";
    }

    private static String getIsLocalKey(Artifact artifact) {
        String string = DefaultRepositoryCacheManager.getPrefixKey(artifact);
        return string + ".is-local";
    }

    private static String getLastCheckedKey(Artifact artifact) {
        String string = DefaultRepositoryCacheManager.getPrefixKey(artifact);
        return string + ".lastchecked";
    }

    private static String getExistsKey(Artifact artifact) {
        String string = DefaultRepositoryCacheManager.getPrefixKey(artifact);
        return string + ".exists";
    }

    private PropertiesFile getCachedDataFile(ModuleDescriptor moduleDescriptor) {
        return this.getCachedDataFile(moduleDescriptor.getResolvedModuleRevisionId());
    }

    private PropertiesFile getCachedDataFile(ModuleRevisionId moduleRevisionId) {
        return new PropertiesFile(new File(this.getRepositoryCacheRoot(), IvyPatternHelper.substitute(this.dataFilePattern, moduleRevisionId)), "ivy cached data file for " + moduleRevisionId);
    }

    public final ResolvedModuleRevision findModuleInCache(DependencyDescriptor dependencyDescriptor, ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions, String string) {
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        if (this.isCheckmodified$5ea4f183(cacheMetadataOptions)) {
            Message.verbose("don't use cache for " + moduleRevisionId2 + ": checkModified=true");
            return null;
        }
        if (this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
            Message.verbose("don't use cache for " + moduleRevisionId2 + ": changing=true");
            return null;
        }
        return this.doFindModuleInCache(moduleRevisionId2, cacheMetadataOptions, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResolvedModuleRevision doFindModuleInCache(ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions, String string) {
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return null;
        }
        try {
            Object object;
            if (this.settings.getVersionMatcher().isDynamic(moduleRevisionId)) {
                object = this.getResolvedRevision(moduleRevisionId, cacheMetadataOptions);
                if (object == null) return null;
                Message.verbose("found resolved revision in cache: " + moduleRevisionId + " => " + (String)object);
                this.unlockMetadataArtifact(moduleRevisionId);
                moduleRevisionId = ModuleRevisionId.newInstance(moduleRevisionId, (String)object);
                if (!this.lockMetadataArtifact(moduleRevisionId)) {
                    Message.error("impossible to acquire lock for " + moduleRevisionId);
                    return null;
                }
            }
            if (((File)(object = this.getIvyFileInCache(moduleRevisionId))).exists()) {
                try {
                    DependencyResolver dependencyResolver;
                    XmlModuleDescriptorParser xmlModuleDescriptorParser = XmlModuleDescriptorParser.getInstance();
                    Object object2 = object;
                    Object object3 = cacheMetadataOptions;
                    Object object4 = xmlModuleDescriptorParser;
                    DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
                    ModuleDescriptorMemoryCache moduleDescriptorMemoryCache = defaultRepositoryCacheManager.getMemoryCache();
                    ModuleDescriptorProvider moduleDescriptorProvider = new ModuleDescriptorProvider((ModuleDescriptorParser)object4, defaultRepositoryCacheManager.settings);
                    ModuleDescriptor moduleDescriptor = moduleDescriptorMemoryCache.get((File)object2, defaultRepositoryCacheManager.settings, ((CacheMetadataOptions)object3).isValidate(), moduleDescriptorProvider);
                    object4 = moduleDescriptor;
                    String string2 = this.getCachedDataFile((ModuleDescriptor)object4).getProperty("resolver");
                    object4 = moduleDescriptor;
                    String string3 = this.getCachedDataFile((ModuleDescriptor)object4).getProperty("artifact.resolver");
                    DependencyResolver dependencyResolver2 = this.settings.getResolver(string2);
                    if (dependencyResolver2 == null) {
                        Message.debug("\tresolver not found: " + string2 + " => trying to use the one configured for " + moduleRevisionId);
                        dependencyResolver2 = this.settings.getResolver(moduleDescriptor.getResolvedModuleRevisionId());
                        if (dependencyResolver2 != null) {
                            Message.debug("\tconfigured resolver found for " + moduleDescriptor.getResolvedModuleRevisionId() + ": " + dependencyResolver2.getName() + ": saving this data");
                            object3 = dependencyResolver2.getName();
                            object4 = moduleDescriptor;
                            object2 = this.getCachedDataFile((ModuleDescriptor)object4);
                            ((Properties)object2).setProperty("resolver", (String)object3);
                            ((PropertiesFile)object2).save();
                        }
                    }
                    if ((dependencyResolver = this.settings.getResolver(string3)) == null) {
                        dependencyResolver = dependencyResolver2;
                    }
                    if (dependencyResolver2 != null) {
                        Message.debug("\tfound ivy file in cache for " + moduleRevisionId + " (resolved by " + dependencyResolver2.getName() + "): " + object);
                        if (string == null || string.equals(dependencyResolver2.getName())) {
                            MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
                            metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                            metadataArtifactDownloadReport.setSearched(false);
                            metadataArtifactDownloadReport.setLocalFile((File)object);
                            metadataArtifactDownloadReport.setSize(((File)object).length());
                            metadataArtifactDownloadReport.setArtifactOrigin(this.getSavedArtifactOrigin(moduleDescriptor.getMetadataArtifact()));
                            ResolvedModuleRevision resolvedModuleRevision = new ResolvedModuleRevision(dependencyResolver2, dependencyResolver, moduleDescriptor, metadataArtifactDownloadReport);
                            return resolvedModuleRevision;
                        }
                        Message.debug("found module in cache but with a different resolver: discarding: " + moduleRevisionId + "; expected resolver=" + string + "; resolver=" + dependencyResolver2.getName());
                        return null;
                    }
                    Message.debug("\tresolver not found: " + string2 + " => cannot use cached ivy file for " + moduleRevisionId);
                    return null;
                }
                catch (Exception exception) {
                    Message.debug("\tproblem while parsing cached ivy file for: " + moduleRevisionId + ": " + exception.getMessage());
                    return null;
                }
            }
            Message.debug("\tno ivy file in cache for " + moduleRevisionId + ": tried " + object);
            return null;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    private String getResolvedRevision(ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions) {
        String string;
        String string2;
        block19: {
            PropertiesFile propertiesFile;
            block18: {
                block17: {
                    if (!this.lockMetadataArtifact(moduleRevisionId)) {
                        Message.error("impossible to acquire lock for " + moduleRevisionId);
                        return null;
                    }
                    try {
                        if (!cacheMetadataOptions.isForce()) break block17;
                        Message.verbose("refresh mode: no check for cached resolved revision for " + moduleRevisionId);
                        this.unlockMetadataArtifact(moduleRevisionId);
                        return null;
                    }
                    catch (Throwable throwable) {
                        this.unlockMetadataArtifact(moduleRevisionId);
                        throw throwable;
                    }
                }
                propertiesFile = this.getCachedDataFile(moduleRevisionId);
                string2 = propertiesFile.getProperty("resolved.revision");
                if (string2 != null) break block18;
                Message.verbose(this.name + ": no cached resolved revision for " + moduleRevisionId);
                this.unlockMetadataArtifact(moduleRevisionId);
                return null;
            }
            string = propertiesFile.getProperty("resolved.time");
            if (string != null) break block19;
            Message.verbose(this.name + ": inconsistent or old cache: no cached resolved time for " + moduleRevisionId);
            this.saveResolvedRevision(moduleRevisionId, string2);
            String string3 = string2;
            this.unlockMetadataArtifact(moduleRevisionId);
            return string3;
        }
        if (cacheMetadataOptions.isCheckTTL()) {
            long l;
            long l2 = Long.parseLong(string);
            ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
            DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
            Long l3 = (Long)defaultRepositoryCacheManager.ttlRules.getRule(moduleRevisionId2);
            if (l3 == null) {
                DefaultRepositoryCacheManager defaultRepositoryCacheManager2 = defaultRepositoryCacheManager;
                if (defaultRepositoryCacheManager2.defaultTTL == null) {
                    long l4;
                    String string4 = defaultRepositoryCacheManager2.settings.getVariable("ivy.cache.ttl.default");
                    if (string4 == null) {
                        l4 = 0L;
                    } else if ("eternal".equals(string4)) {
                        l4 = Long.MAX_VALUE;
                    } else {
                        java.util.regex.Matcher matcher = DURATION_PATTERN.matcher(string4);
                        if (matcher.matches()) {
                            int n = DefaultRepositoryCacheManager.getGroupIntValue(matcher, 1);
                            int n2 = DefaultRepositoryCacheManager.getGroupIntValue(matcher, 2);
                            int n3 = DefaultRepositoryCacheManager.getGroupIntValue(matcher, 3);
                            int n4 = DefaultRepositoryCacheManager.getGroupIntValue(matcher, 4);
                            int n5 = DefaultRepositoryCacheManager.getGroupIntValue(matcher, 5);
                            l4 = n * 86400000 + n2 * 3600000 + n3 * 60000 + n4 * 1000 + n5;
                        } else {
                            throw new IllegalArgumentException("invalid duration '" + string4 + "': it must match " + DURATION_PATTERN.pattern() + " or 'eternal'");
                        }
                    }
                    defaultRepositoryCacheManager2.defaultTTL = new Long(l4);
                }
                l = defaultRepositoryCacheManager2.defaultTTL;
            } else {
                l = l3;
            }
            long l5 = l2 + l;
            if (l5 > 0L && System.currentTimeMillis() > l5) {
                Message.verbose(this.name + ": cached resolved revision expired for " + moduleRevisionId);
                this.unlockMetadataArtifact(moduleRevisionId);
                return null;
            }
        }
        String string5 = string2;
        this.unlockMetadataArtifact(moduleRevisionId);
        return string5;
    }

    public final void saveResolvedRevision(ModuleRevisionId moduleRevisionId, String string) {
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return;
        }
        try {
            PropertiesFile propertiesFile = this.getCachedDataFile(moduleRevisionId);
            propertiesFile.setProperty("resolved.time", String.valueOf(System.currentTimeMillis()));
            propertiesFile.setProperty("resolved.revision", string);
            propertiesFile.save();
            return;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    public final String toString() {
        return this.name;
    }

    private File getRepositoryCacheRoot() {
        DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
        if (defaultRepositoryCacheManager.basedir == null) {
            defaultRepositoryCacheManager.basedir = defaultRepositoryCacheManager.settings.getDefaultRepositoryCacheBasedir();
        }
        return defaultRepositoryCacheManager.basedir;
    }

    private LockStrategy getLockStrategy() {
        if (this.lockStrategy == null) {
            this.lockStrategy = this.settings.getDefaultLockStrategy();
        }
        return this.lockStrategy;
    }

    public final ArtifactDownloadReport download(Artifact artifact, ArtifactResourceResolver artifactResourceResolver, ResourceDownloader resourceDownloader, CacheDownloadOptions cacheDownloadOptions) {
        ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(artifact);
        DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
        boolean bl = defaultRepositoryCacheManager.useOrigin == null ? (defaultRepositoryCacheManager.settings != null ? defaultRepositoryCacheManager.settings.isDefaultUseOrigin() : false) : defaultRepositoryCacheManager.useOrigin;
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
            artifactDownloadReport.setDownloadDetails("impossible to get lock for " + moduleRevisionId);
            return artifactDownloadReport;
        }
        try {
            ArtifactOrigin artifactOrigin;
            File file2;
            DownloadListener downloadListener = cacheDownloadOptions.getListener();
            if (downloadListener != null) {
                downloadListener.needArtifact$2ad766ec(artifact);
            }
            if ((file2 = this.getArchiveFileInCache(artifact, artifactOrigin = this.getSavedArtifactOrigin(artifact), bl)).exists() && !cacheDownloadOptions.isForce()) {
                artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                artifactDownloadReport.setSize(file2.length());
                artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                artifactDownloadReport.setLocalFile(file2);
            } else {
                long l = System.currentTimeMillis();
                try {
                    ResolvedResource resolvedResource = artifactResourceResolver.resolve(artifact);
                    if (resolvedResource != null) {
                        artifactOrigin = new ArtifactOrigin(artifact, resolvedResource.getResource().isLocal(), resolvedResource.getResource().getName());
                        if (bl && resolvedResource.getResource().isLocal()) {
                            this.saveArtifactOrigin(artifact, artifactOrigin);
                            file2 = this.getArchiveFileInCache(artifact, artifactOrigin);
                            artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                            artifactDownloadReport.setSize(file2.length());
                            artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                            artifactDownloadReport.setLocalFile(file2);
                        } else {
                            file2 = this.getArchiveFileInCache(artifact, artifactOrigin, bl);
                            if (UpdateResult.equals(resolvedResource.getResource(), file2)) {
                                throw new IllegalStateException("invalid settings for '" + artifactResourceResolver + "': pointing repository to ivy cache is forbidden !");
                            }
                            if (downloadListener != null) {
                                downloadListener.startArtifactDownload$68cb4220(resolvedResource, artifact, artifactOrigin);
                            }
                            resourceDownloader.download(artifact, resolvedResource.getResource(), file2);
                            artifactDownloadReport.setSize(file2.length());
                            this.saveArtifactOrigin(artifact, artifactOrigin);
                            artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                            artifactDownloadReport.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                            artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                            artifactDownloadReport.setLocalFile(file2);
                        }
                    } else {
                        artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
                        artifactDownloadReport.setDownloadDetails("missing artifact");
                        artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                    }
                }
                catch (Exception exception) {
                    artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
                    artifactDownloadReport.setDownloadDetails(exception.getMessage());
                    artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                }
            }
            if (downloadListener != null) {
                downloadListener.endArtifactDownload$1b92244e(artifact, artifactDownloadReport, file2);
            }
            ArtifactDownloadReport artifactDownloadReport2 = artifactDownloadReport;
            return artifactDownloadReport2;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    public final void originalToCachedModuleDescriptor(DependencyResolver dependencyResolver, ResolvedResource resolvedResource, Artifact artifact, ResolvedModuleRevision resolvedModuleRevision, ModuleDescriptorWriter moduleDescriptorWriter) {
        ModuleDescriptor moduleDescriptor = resolvedModuleRevision.getDescriptor();
        Artifact artifact2 = DefaultRepositoryCacheManager.getOriginalMetadataArtifact(artifact);
        File file2 = this.getIvyFileInCache(moduleDescriptor.getResolvedModuleRevisionId());
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.warn("impossible to acquire lock for: " + moduleRevisionId);
            return;
        }
        try {
            Artifact artifact3 = artifact2;
            DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
            ArtifactOrigin artifactOrigin = defaultRepositoryCacheManager.getSavedArtifactOrigin(artifact3);
            File file3 = defaultRepositoryCacheManager.getArchiveFileInCache(artifact3, artifactOrigin);
            moduleDescriptorWriter.write(resolvedResource, moduleDescriptor, file3, file2);
            this.getMemoryCache().putInCache(file2, new ParserSettingsMonitor(this.settings), true, moduleDescriptor);
            this.saveResolvers(moduleDescriptor, dependencyResolver.getName(), dependencyResolver.getName());
            if (!moduleDescriptor.isDefault()) {
                resolvedModuleRevision.getReport().setOriginalLocalFile(file3);
            }
            resolvedModuleRevision.getReport().setLocalFile(file2);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            Message.warn("impossible to put metadata file in cache: " + (resolvedResource == null ? String.valueOf(moduleDescriptor.getResolvedModuleRevisionId()) : String.valueOf(resolvedResource)) + ". " + exception.getClass().getName() + ": " + exception.getMessage());
            return;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    public final ResolvedModuleRevision cacheModuleDescriptor(DependencyResolver dependencyResolver, ResolvedResource resolvedResource, DependencyDescriptor dependencyDescriptor, Artifact artifact, ResourceDownloader resourceDownloader, CacheMetadataOptions cacheMetadataOptions) {
        Date date = null;
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return null;
        }
        DefaultRepositoryCacheManager$BackupResourceDownloader defaultRepositoryCacheManager$BackupResourceDownloader = new DefaultRepositoryCacheManager$BackupResourceDownloader(this, resourceDownloader);
        try {
            Object object;
            Object object2;
            if (!artifact.isMetadata()) {
                if (this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
                    ArtifactOrigin artifactOrigin;
                    long l = resolvedResource.getLastModified();
                    Artifact artifact2 = GrowingBuilder.transform(artifact, cacheMetadataOptions.getNamespace().getToSystemTransformer());
                    File file2 = this.getArchiveFileInCache(artifact2, artifactOrigin = this.getSavedArtifactOrigin(artifact2), false);
                    if (file2.exists() && l > file2.lastModified()) {
                        Message.verbose(moduleRevisionId + " has changed: deleting old artifacts");
                        Message.debug("deleting " + file2);
                        if (!file2.delete()) {
                            Message.error("Couldn't delete outdated artifact from cache: " + file2);
                            return null;
                        }
                        this.removeSavedArtifactOrigin(artifact2);
                    }
                }
                return null;
            }
            ResolvedModuleRevision resolvedModuleRevision = this.doFindModuleInCache(moduleRevisionId, cacheMetadataOptions, null);
            if (resolvedModuleRevision != null) {
                if (resolvedModuleRevision.getDescriptor().isDefault() && resolvedModuleRevision.getResolver() != dependencyResolver) {
                    Message.verbose("\t" + this.name + ": found revision in cache: " + moduleRevisionId + " (resolved by " + resolvedModuleRevision.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else {
                    if (!this.isCheckmodified$5ea4f183(cacheMetadataOptions) && !this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
                        Message.verbose("\t" + this.name + ": revision in cache: " + moduleRevisionId);
                        resolvedModuleRevision.getReport().setSearched(true);
                        ResolvedModuleRevision resolvedModuleRevision2 = resolvedModuleRevision;
                        return resolvedModuleRevision2;
                    }
                    long l = resolvedResource.getLastModified();
                    long l2 = resolvedModuleRevision.getDescriptor().getLastModified();
                    if (!resolvedModuleRevision.getDescriptor().isDefault() && l <= l2) {
                        Message.verbose("\t" + this.name + ": revision in cache (not updated): " + moduleRevisionId);
                        resolvedModuleRevision.getReport().setSearched(true);
                        ResolvedModuleRevision resolvedModuleRevision3 = resolvedModuleRevision;
                        return resolvedModuleRevision3;
                    }
                    Message.verbose("\t" + this.name + ": revision in cache is not up to date: " + moduleRevisionId);
                    if (this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
                        date = resolvedModuleRevision.getDescriptor().getResolvedPublicationDate();
                    }
                }
            }
            Artifact artifact3 = DefaultRepositoryCacheManager.getOriginalMetadataArtifact(artifact);
            ArtifactDownloadReport artifactDownloadReport = this.download(artifact3, new DefaultRepositoryCacheManager$1(resolvedResource), defaultRepositoryCacheManager$BackupResourceDownloader, new CacheDownloadOptions().setListener(cacheMetadataOptions.getListener()).setForce(true));
            Message.verbose("\t" + artifactDownloadReport);
            if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
                Message.warn("problem while downloading module descriptor: " + resolvedResource.getResource() + ": " + artifactDownloadReport.getDownloadDetails() + " (" + artifactDownloadReport.getDownloadTimeMillis() + "ms)");
                return null;
            }
            ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(resolvedResource.getResource());
            ParserSettings parserSettings = this.settings;
            if (dependencyResolver instanceof AbstractResolver) {
                parserSettings = ((AbstractResolver)dependencyResolver).getParserSettings();
            }
            ParserSettings parserSettings2 = parserSettings;
            File file3 = artifactDownloadReport.getLocalFile();
            CacheMetadataOptions cacheMetadataOptions2 = cacheMetadataOptions;
            ModuleDescriptorParser moduleDescriptorParser2 = moduleDescriptorParser;
            DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
            ModuleDescriptorMemoryCache moduleDescriptorMemoryCache = defaultRepositoryCacheManager.getMemoryCache();
            ModuleDescriptorProvider moduleDescriptorProvider = new ModuleDescriptorProvider(moduleDescriptorParser2, parserSettings2);
            ModuleDescriptor moduleDescriptor = moduleDescriptorMemoryCache.getStale(file3, defaultRepositoryCacheManager.settings, cacheMetadataOptions2.isValidate(), moduleDescriptorProvider);
            if (moduleDescriptor == null) {
                throw new IllegalStateException("module descriptor parser returned a null module descriptor, which is not allowed. parser=" + moduleDescriptorParser + "; parser class=" + moduleDescriptorParser.getClass().getName() + "; module descriptor resource=" + resolvedResource.getResource());
            }
            Message.debug("\t" + this.name + ": parsed downloaded md file for " + moduleRevisionId + "; parsed=" + moduleDescriptor.getModuleRevisionId());
            boolean bl = false;
            if (date != null && !date.equals(moduleDescriptor.getResolvedPublicationDate())) {
                Message.verbose(moduleRevisionId + " has changed: deleting old artifacts");
                bl = true;
            }
            if (bl) {
                object2 = moduleDescriptor.getConfigurationsNames();
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    object = moduleDescriptor.getArtifacts(object2[i]);
                    for (int j = 0; j < ((Artifact[])object).length; ++j) {
                        ArtifactOrigin artifactOrigin;
                        Artifact artifact4 = GrowingBuilder.transform(object[j], cacheMetadataOptions.getNamespace().getToSystemTransformer());
                        File file4 = this.getArchiveFileInCache(artifact4, artifactOrigin = this.getSavedArtifactOrigin(artifact4), false);
                        if (file4.exists()) {
                            Message.debug("deleting " + file4);
                            if (!file4.delete()) {
                                defaultRepositoryCacheManager$BackupResourceDownloader.restore();
                                Message.error("Couldn't delete outdated artifact from cache: " + file4);
                                return null;
                            }
                        }
                        this.removeSavedArtifactOrigin(artifact4);
                    }
                }
            } else if (this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
                Message.verbose(moduleRevisionId + " is changing, but has not changed: will trust cached artifacts if any");
            }
            object2 = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
            ((MetadataArtifactDownloadReport)object2).setSearched(true);
            ((ArtifactDownloadReport)object2).setDownloadStatus(artifactDownloadReport.getDownloadStatus());
            ((ArtifactDownloadReport)object2).setDownloadDetails(artifactDownloadReport.getDownloadDetails());
            ((ArtifactDownloadReport)object2).setArtifactOrigin(artifactDownloadReport.getArtifactOrigin());
            ((ArtifactDownloadReport)object2).setDownloadTimeMillis(artifactDownloadReport.getDownloadTimeMillis());
            ((MetadataArtifactDownloadReport)object2).setOriginalLocalFile(artifactDownloadReport.getLocalFile());
            ((ArtifactDownloadReport)object2).setSize(artifactDownloadReport.getSize());
            Artifact artifact5 = GrowingBuilder.transform(moduleDescriptor.getMetadataArtifact(), cacheMetadataOptions.getNamespace().getToSystemTransformer());
            this.saveArtifactOrigin(artifact5, artifactDownloadReport.getArtifactOrigin());
            object = new ResolvedModuleRevision(dependencyResolver, dependencyResolver, moduleDescriptor, (MetadataArtifactDownloadReport)object2);
            return object;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
            defaultRepositoryCacheManager$BackupResourceDownloader.cleanUp();
        }
    }

    private boolean lockMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        Artifact artifact = DefaultRepositoryCacheManager.getDefaultMetadataArtifact(moduleRevisionId);
        try {
            return this.getLockStrategy().lockArtifact$1e31ddd9(this.getArchiveFileInCache(artifact, this.getDefaultMetadataArtifactOrigin(moduleRevisionId)));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("operation interrupted");
        }
    }

    private void unlockMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        Artifact artifact = DefaultRepositoryCacheManager.getDefaultMetadataArtifact(moduleRevisionId);
        this.getLockStrategy().unlockArtifact$1e31ddd5(this.getArchiveFileInCache(artifact, this.getDefaultMetadataArtifactOrigin(moduleRevisionId)));
    }

    private ArtifactOrigin getDefaultMetadataArtifactOrigin(ModuleRevisionId moduleRevisionId) {
        return new ArtifactOrigin(DefaultArtifact.newIvyArtifact(moduleRevisionId, null), false, this.getIvyFileInCache(moduleRevisionId).getPath());
    }

    private static Artifact getDefaultMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        return new DefaultArtifact(moduleRevisionId, new Date(), "metadata", "metadata", "ivy");
    }

    private static Artifact getOriginalMetadataArtifact(Artifact artifact) {
        String string = artifact.getType() + ".original";
        Artifact artifact2 = artifact;
        String string2 = artifact2.getExt();
        String string3 = string;
        Artifact artifact3 = artifact2;
        return new DefaultArtifact(ArtifactRevisionId.newInstance(artifact3.getModuleRevisionId(), artifact3.getName(), string3, string2, artifact3.getQualifiedExtraAttributes()), artifact3.getPublicationDate(), artifact3.getUrl(), artifact3.isMetadata());
    }

    private boolean isChanging(DependencyDescriptor dependencyDescriptor, ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions) {
        block7: {
            block6: {
                Matcher matcher;
                if (dependencyDescriptor.isChanging()) break block6;
                CacheMetadataOptions cacheMetadataOptions2 = cacheMetadataOptions;
                DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
                String string = cacheMetadataOptions2.getChangingPattern() != null ? cacheMetadataOptions2.getChangingPattern() : defaultRepositoryCacheManager.changingPattern;
                if (string == null) {
                    matcher = NoMatcher.INSTANCE;
                } else {
                    String string2 = cacheMetadataOptions2.getChangingMatcherName() != null ? cacheMetadataOptions2.getChangingMatcherName() : defaultRepositoryCacheManager.changingMatcherName;
                    PatternMatcher patternMatcher = defaultRepositoryCacheManager.settings.getMatcher(string2);
                    if (patternMatcher == null) {
                        throw new IllegalStateException("unknown matcher '" + string2 + "'. It is set as changing matcher in " + defaultRepositoryCacheManager);
                    }
                    matcher = patternMatcher.getMatcher(string);
                }
                if (!matcher.matches(moduleRevisionId.getRevision())) break block7;
            }
            return true;
        }
        return false;
    }

    private boolean isCheckmodified$5ea4f183(CacheMetadataOptions cacheMetadataOptions) {
        if (cacheMetadataOptions.isCheckmodified() != null) {
            return cacheMetadataOptions.isCheckmodified();
        }
        DefaultRepositoryCacheManager defaultRepositoryCacheManager = this;
        if (defaultRepositoryCacheManager.settings != null) {
            String string = defaultRepositoryCacheManager.settings.getVariable("ivy.resolver.default.check.modified");
            if (string != null) {
                return Boolean.valueOf(string);
            }
            return false;
        }
        return false;
    }

    static {
        try {
            MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("The SHA1 algorithm is not available in your classpath", noSuchAlgorithmException);
        }
        DURATION_PATTERN = Pattern.compile("(?:(\\d+)d)? ?(?:(\\d+)h)? ?(?:(\\d+)m)? ?(?:(\\d+)s)? ?(?:(\\d+)ms)?");
    }
}

