/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;

public class Interest
extends ResourceObject {
    public static final String COMMONNAME = "http://purl.org/dc/elements/1.1/:title";
    public static final String DESCRIPTION = "http://purl.org/dc/elements/1.1/:description";
    public static final String URLCONTEXT = "http://purl.oclc.org/NET/cmcs/schema/:url";
    public static final String FREQUENCY = "http://purl.oclc.org/NET/cmcs/schema/:frequency";
    public static final String EVENTTYPE = "http://purl.oclc.org/NET/cmcs/schema/:eventtype";
    public static final String PRODUCER = "http://purl.oclc.org/NET/cmcs/schema/:producer";
    public static final String RECIPIENTS = "http://purl.oclc.org/NET/cmcs/schema/:recipient";
    public static final String INCLUDE_CHILDREN = "http://purl.oclc.org/NET/cmcs/schema/:include_children";
    public static final String GENERALSEARCHFIELD = "http://purl.oclc.org/NET/cmcs/internal/schema/:generalsearchfield";
    public static final String SPECIESNAME = "http://purl.oclc.org/NET/cmcs/schema/:speciesname";
    public static final String CHEMPROPERTIES = "http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty";
    public static final String KEYWORDS = "http://purl.org/dc/elements/1.1/:subject";
    public static final String CREATOR = "http://purl.org/dc/elements/1.1/:creator";
    public static final String MESSAGE = "http://purl.oclc.org/NET/cmcs/schema/:message";

    public Interest() {
        this.setAttributeTypes();
        try {
            this.add("http://purl.org/dc/elements/1.1/:type", this.getClass().getName());
        }
        catch (Exception dsme) {
            this.mLog.severe("Exception creating Interest class: " + dsme.toString());
        }
    }

    private void setAttributeTypes() {
        this.mAttributeTypes.put(INCLUDE_CHILDREN, String.class);
        this.mAttributeTypes.put(COMMONNAME, String.class);
        this.mAttributeTypes.put(DESCRIPTION, String.class);
        this.mAttributeTypes.put(URLCONTEXT, String[].class);
        this.mAttributeTypes.put(FREQUENCY, String.class);
        this.mAttributeTypes.put(EVENTTYPE, String[].class);
        this.mAttributeTypes.put(PRODUCER, String[].class);
        this.mAttributeTypes.put(RECIPIENTS, String[].class);
        this.mAttributeTypes.put(GENERALSEARCHFIELD, String[].class);
        this.mAttributeTypes.put(SPECIESNAME, String[].class);
        this.mAttributeTypes.put(CHEMPROPERTIES, String[].class);
        this.mAttributeTypes.put(KEYWORDS, String[].class);
        this.mAttributeTypes.put(CREATOR, String[].class);
    }

    public boolean getIncludeChildren() {
        String includeChildren = (String)this.mResourceEntry.get(INCLUDE_CHILDREN);
        return "true".equals(includeChildren);
    }

    public String getCommonName() {
        Object commonName = this.mResourceEntry.get(COMMONNAME);
        return (String)commonName;
    }

    public String getDescription() {
        Object description = this.mResourceEntry.get(DESCRIPTION);
        return (String)description;
    }

    public String[] getUrlContext() {
        return this.getAsStringArray(URLCONTEXT);
    }

    public String getFrequency() {
        Object frequency = this.mResourceEntry.get(FREQUENCY);
        return (String)frequency;
    }

    public String[] getEventType() {
        return this.getAsStringArray(EVENTTYPE);
    }

    public String[] getProducer() {
        return this.getAsStringArray(PRODUCER);
    }

    public String[] getRecipients() {
        return this.getAsStringArray(RECIPIENTS);
    }

    public String[] getGeneralSearchField() {
        return this.getAsStringArray(GENERALSEARCHFIELD);
    }

    public String[] getSpeciesName() {
        return this.getAsStringArray(SPECIESNAME);
    }

    public String[] getChemProperties() {
        return this.getAsStringArray(CHEMPROPERTIES);
    }

    public String[] getKeywords() {
        return this.getAsStringArray(KEYWORDS);
    }

    public String[] getCreators() {
        return this.getAsStringArray(CREATOR);
    }

    public void setIncludeChildren(String include) {
        String value = include;
        if (value == null) {
            value = "false";
        }
        this.mResourceEntry.put(INCLUDE_CHILDREN, value);
    }

    public void setCommonName(String commonName) {
        this.mResourceEntry.put(COMMONNAME, commonName);
    }

    public void setDescription(String description) {
        this.mResourceEntry.put(DESCRIPTION, description);
    }

    public void setUrlContext(String[] urlContext) {
        this.mResourceEntry.put(URLCONTEXT, urlContext);
    }

    public void setFrequency(String frequency) {
        this.mResourceEntry.put(FREQUENCY, frequency);
    }

    public void setEventType(String[] eventType) {
        this.mResourceEntry.put(EVENTTYPE, eventType);
    }

    public void setProducer(String[] producer) {
        this.mResourceEntry.put(PRODUCER, producer);
    }

    public void setRecipients(String[] recipients) {
        this.mResourceEntry.put(RECIPIENTS, recipients);
    }

    public void setGeneralSearchField(String[] generalSearchField) {
        this.mResourceEntry.put(GENERALSEARCHFIELD, generalSearchField);
    }

    public void setSpeciesName(String[] speciesName) {
        this.mResourceEntry.put(SPECIESNAME, speciesName);
    }

    public void setChemProperties(String[] chemProperties) {
        this.mResourceEntry.put(CHEMPROPERTIES, chemProperties);
    }

    public void setKeywords(String[] keywords) {
        this.mResourceEntry.put(KEYWORDS, keywords);
    }

    public void setCreators(String[] creators) {
        this.mResourceEntry.put(CREATOR, creators);
    }
}

