/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.webdav.lib.BaseProperty;

public class TestMGet {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Does a mget");
            System.err.println("Usage: MGet <url>");
            System.exit(-1);
        }
        String url = args[0];
        String propName = "";
        Vector<NSProperty> properties = null;
        if (args.length >= 2) {
            propName = args[1];
            properties = new Vector<NSProperty>();
            NSProperty property = new NSProperty(propName);
            properties.add(property);
        }
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url, dal);
        try {
            Enumeration props = dsi.queryMetaTriples(properties);
            if (props != null) {
                while (props.hasMoreElements()) {
                    BaseProperty prop = (BaseProperty)props.nextElement();
                    String propVal = prop.getPropertyAsString();
                    if (propVal != null && propVal.trim().length() == 0) {
                        propVal = prop.getPropertyAsXMLString(true);
                    }
                    System.out.println(prop.getName() + "=" + propVal.trim());
                }
            } else {
                System.out.println("MGet is null");
            }
        }
        catch (StatusException ex) {
            System.out.println(ex.getMessage());
            System.out.println(LoggerUtils.getStackTrace(ex));
        }
        System.exit(0);
    }
}

