/* NVTV 3dfx TV-I2C header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: tv_tdfx.h,v 1.8 2003/10/10 16:16:57 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Routines to control the TV and the I2C bus on a 3dfx (Voodoo) card.
 *
 */

#ifndef _TV_TDFX_H
#define _TV_TDFX_H

#include "tdfx_type.h"

CARD8 readCrtTdfx (TDFXPtr hwp, CARD8 index);
void writeCrtTdfx (TDFXPtr hwp, CARD8 index, CARD8 value);

Bool TDFXTvBusInit (TDFXPtr pTdfx);
void TDFXTvBusConfig (TDFXPtr pTdfx);

void TDFXUpdateTvState (TDFXPtr pTdfx);

void TDFXSetTvDevice (TDFXPtr pTdfx, I2CChainPtr chain, Bool init);
void TDFXDestroyDevices (TDFXPtr pTdfx);
void TDFXDestroyBusses (TDFXPtr pTdfx);
void TDFXProbeTvDevices (TDFXPtr pTdfx);

void TDFXSetTestImage (TDFXPtr pTdfx, TVEncoderRegs *r);
void TDFXSetTvMode (TDFXPtr pTdfx, TVRegs *r);

long TDFXGetTvStatus (TDFXPtr pTdfx, int index);
TVConnect TDFXGetTvConnect (TDFXPtr pTdfx);

int TDFXGetDevFlags (TDFXPtr pTdfx);

void TDFXSetCrtRegs (TDFXPtr pTdfx, TVTdfxRegs *r);
void TDFXGetCrtRegs (TDFXPtr pTdfx, TVTdfxRegs *r);

void TDFXSetAllRegs (TDFXPtr pTdfx, TVRegs *r);
void TDFXGetAllRegs (TDFXPtr pTdfx, TVRegs *r);

#endif /* _TV_TDFX_H */
