/* NVTV i810_type -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * Extends the TDFXRec type from tdfx.h and introduces new types, and should
 * eventually be merged with the original XFree file.  
 * 
 */

#ifndef _TDFX_TYPE_H
#define _TDFX_TYPE_H

#include "xf86i2c.h"
#include "debug.h"
#include "tv_common.h"

#define I810_MAXBUS 3

typedef struct _I810Rec *I810Ptr;

typedef struct {
  int heads; /* Number of heads (= pipes) */
  int major; /* Major architecture, 0x10 for I810, 0x30 for I830 */
} IntelArch;

typedef struct _I810Rec {
   unsigned char *MMIOBase;
   unsigned char *FbBase;
  /* ... */
  int                 Chipset;  /* FIXME Unused, instead in ScreenInfoRec ? */
  /* ... */
  /* new members: */
  IntelArch	      arch;
  TVEncoderObj	      tvEncoder;
  I2CChainPtr         TvChain; /* chain of devices on all busses */
  I2CBusPtr           TvBusses[I810_MAXBUS];
  int                 TvMaxBus;
  I2CDevPtr           TvDev;
} I810Rec;

#define I810PTR(p) ((I810Ptr)((p)->driverPrivate))

#endif /* _TDFX_TYPE_H */
