/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <glib.h>
#include <string.h>

#include "nb_attachment.h"
#include "nb_attachment_list.h"

/* create and free object */
AttachmentList *
nb_attachment_list_new (void)
{
	return g_ptr_array_new ();
}

void
nb_attachment_list_free (AttachmentList * self)
{
	g_ptr_array_free (self, TRUE);
}

gboolean
nb_attachment_list_add (AttachmentList * self, Attachment * a)
{
	gint i;
	Attachment * tmp;

	/* check if the attachment is not already present */
	for ( i = 0 ; i < self->len ; i++ )
	{
		tmp = g_ptr_array_index (self, i);

		if ( strcmp (a->uri, tmp->uri) == 0 )
			return FALSE;
	}

	g_ptr_array_add (self, a);

	return TRUE;
}

gboolean
nb_attachment_list_remove (AttachmentList * self, Attachment * a)
{
	return g_ptr_array_remove (self, a);
}

gint
nb_attachment_list_get_nb (AttachmentList * self)
{
	return self->len;
}

void
nb_attachment_list_check (AttachmentList * self)
{
	gint i;
	Attachment * a;
	
	for ( i = 0 ; i < self->len ; i++ )
	{
		a = g_ptr_array_index (self, i);
		if ( !nb_attachment_check (a))
			nb_attachment_list_remove (self, a);
	}
}
