/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Natural logarithm of `2π`.
*
* @module @stdlib/constants/float64/ln-two-pi
* @type {number}
*
* @example
* var LN_TWO_PI = require( '@stdlib/constants/float64/ln-two-pi' );
* // returns 1.8378770664093456
*/


// MAIN //

/**
* Natural logarithm of `2π`.
*
* ```tex
* \ln 2\pi
* ```
*
* @constant
* @type {number}
* @default 1.8378770664093456
*/
var LN_TWO_PI = 1.837877066409345483560659472811235279722794947275566825634;


// EXPORTS //

module.exports = LN_TWO_PI;
