%#  mffm Time Code
%#  Time Code for multimedia systems
%#
%#  Copyright (C) 2000, 2001 Matt R. Flax <flatmax@ieee.org>
%#  
%#  This library is free software; you can redistribute it and/or
%#  modify it under the terms of the GNU Lesser General Public
%#  License as published by the Free Software Foundation; either
%#  version 2.1 of the License, or (at your option) any later version.
%#  
%#  This library is distributed in the hope that it will be useful,
%#  but WITHOUT ANY WARRANTY; without even the implied warranty of
%#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%#  Lesser General Public License for more details.
%#  
%#  You have received a copy of the GNU Lesser General Public License
%#  along with this library.
function [a,b]=BPDesign(k,cf,Q3dB,fs)
  %# deisgns a BP filter centred at cf and of width Q3dB with gain k
  %# For the purpose of neural systems, it is probably best to have as
  %# little ripple in the pass band as possible.
  %#
  %# input : k    = gain at the freq. peak of the filter
  %#         cf   = Center frreq. (Hz)
  %#         Q3dB = cf/(high3dB-low3dB)
  %#         fs   = sample freq.
  %#
  %# output: a = denominator of the discrete transfer function (poles)
  %#         b = numerator of the discrete transfer function (zeros)
  BW=cf/Q3dB
  lowFreq=(cf-BW/2)*2/fs %# normalised
  highFreq=(cf+BW/2)*2/fs %# normalised

  n=2;
  [b, a] = butter(n, [lowFreq, highFreq]);
  b*=k; %# scale by the gain
endfunction