# Configure libLAS package
#
# It defines the following variables
#  libLAS_FOUND = LIBLAS_FOUND - TRUE
#  libLAS_INCLUDE_DIRS - include directories for libLAS
#  libLAS_LIBRARY_DIRS - library directory
#  libLAS_LIBRARIES    - all the libraries of the components requested
#                                if no components specified then all found
#  libLAS_VERSION      - libLAS library version

message (STATUS "Reading ${CMAKE_CURRENT_LIST_FILE}")
set (libLAS_VERSION "")
message (STATUS "libLAS configuration, version "
  ${libLAS_VERSION})

# Tell the user project where to find our headers and libraries
get_filename_component (_DIR ${CMAKE_CURRENT_LIST_FILE} PATH)
get_filename_component (PROJECT_ROOT_DIR "${_DIR}/../../.." ABSOLUTE)
set (libLAS_INCLUDE_DIRS "${PROJECT_ROOT_DIR}/include")
set (libLAS_LIBRARY_DIRS "${PROJECT_ROOT_DIR}/lib")

include ("${_DIR}/liblas-depends.cmake")
if(WIN32)
  set (libLAS_LIBRARIES liblas liblas_c)
else()
  set (libLAS_LIBRARIES las las_c)
endif()

set (LIBLAS_FOUND TRUE)
