/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tst_context.h"

#include "../../src/context.h"

#include <QtTest/QtTest>

void
TestContext::setIdentifier()
{
    Ubuntu::HUD::Context ctx;

    QSignalSpy spy(&ctx, SIGNAL(identifierChanged(QString)));

    QVERIFY(ctx.identifier() == "");

    ctx.setIdentifier("MyContext");
    QVERIFY(ctx.identifier() == "MyContext");
    QCOMPARE(spy.count(), 1);

    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toString() == "MyContext");

    spy.clear();
    ctx.setIdentifier("MyContext");
    QCOMPARE(spy.count(), 0);
}

void
TestContext::actionOperations()
{
    Ubuntu::HUD::Context ctx;

    Ubuntu::HUD::Action *action1;
    Ubuntu::HUD::Action *action2;
    Ubuntu::HUD::Action *action3;

    action1 = new Ubuntu::HUD::Action(&ctx);
    action1->setIdentifier("Action1");
    action2 = new Ubuntu::HUD::Action(&ctx);
    action2->setIdentifier("Action2");
    action3 = new Ubuntu::HUD::Action(&ctx);
    action3->setIdentifier("Action3");

    QSignalSpy actions_spy(&ctx, SIGNAL(actionsChanged()));
    QSignalSpy added_spy(&ctx, SIGNAL(actionAdded(Action*)));
    QSignalSpy removed_spy(&ctx, SIGNAL(actionRemoved(Action*)));

    QList<Ubuntu::HUD::Action *> actions;
    actions = ctx.actions();
    QVERIFY(actions.isEmpty());

    ctx.addAction(action1);
    QCOMPARE(actions_spy.count(), 1);
    QCOMPARE(added_spy.count(), 1);
    QVERIFY(ctx.actions().contains(action1));

    ctx.addAction(action2);
    ctx.addAction(action3);
    QCOMPARE(ctx.actions().count(), 3);
    QCOMPARE(added_spy.count(), 3);

    QSignalSpy trigger_spy(action2, SIGNAL(triggered()));
    ctx.invokeAction(action2->identifier());
    QCOMPARE(trigger_spy.count(), 1);

    ctx.removeAction(action2);
    ctx.invokeAction(action2->identifier());
    QCOMPARE(trigger_spy.count(), 1);
    QCOMPARE(removed_spy.count(), 1);
    QCOMPARE(actions_spy.count(), 4);

    // injectRecentActions
}
