/*
 * @(#)DefaultTestInfoUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.testserver;

import net.sourceforge.groboutils.autodoc.v1.*;

import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the DefaultTestInfo class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 27, 2002
 * @version   $Date: 2003/02/10 22:52:17 $
 */
public class DefaultTestInfoUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = DefaultTestInfoUTest.class;
    
    public DefaultTestInfoUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        TestInfo ti = new DefaultTestInfo();
        assertNull(
            "did not return null suite.",
            ti.getSuite() );
        assertNull(
            "did not return null method.",
            ti.getMethod() );
    }
    
    
    public void testConstructor2()
    {
        TestInfo ti = new DefaultTestInfo( "a", "b" );
        assertEquals(
            "did not return correct suite.",
            "a",
            ti.getSuite() );
        assertEquals(
            "did not return correct method.",
            "b",
            ti.getMethod() );
    }
    
    
    public void testEquals1()
    {
        TestInfo ti1 = new DefaultTestInfo( "a", "b" );
        TestInfo ti2 = new DefaultTestInfo( "a", "b" );
        assertTrue(
            "did not think same data is equal.",
            ti1.equals( ti2 ) );
    }
    
    
    public void testEquals2()
    {
        TestInfo ti1 = new DefaultTestInfo( "a", "b" );
        TestInfo ti2 = new DefaultTestInfo( "a", "c" );
        assertTrue(
            "did not think different method is not equal.",
            ! ti1.equals( ti2 ) );
    }
    
    
    public void testEquals3()
    {
        TestInfo ti1 = new DefaultTestInfo( "a", "b" );
        TestInfo ti2 = new DefaultTestInfo( "c", "b" );
        assertTrue(
            "did not think different suite is not equal.",
            ! ti1.equals( ti2 ) );
    }
    
    
    public void testEquals4()
    {
        TestInfo ti1 = new DefaultTestInfo( "a", "b" );
        TestInfo ti2 = new DefaultTestInfo( "d", "c" );
        assertTrue(
            "did not think different method and suite is not equal.",
            ! ti1.equals( ti2 ) );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = TestInfoUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new DefaultTestInfo();
            }
        } );
        suite.addFactory( new CxFactory( "B" ) {
            public Object createImplObject() {
                return new DefaultTestInfo( "a", null );
            }
        } );
        suite.addFactory( new CxFactory( "C" ) {
            public Object createImplObject() {
                return new DefaultTestInfo( null, "a" );
            }
        } );
        suite.addFactory( new CxFactory( "D" ) {
            public Object createImplObject() {
                return new DefaultTestInfo( "a", "b" );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

