// CONSTRAINT.CPP

// Copyright (C) 2006 Donald Curtis, Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#include "libghemicalconfig2.h"
#include "constraint.h"

/*################################################################################################*/

constraint_dst::constraint_dst(atom * p1, atom * p2)
{
	atmr[0] = p1;
	atmr[1] = p2;
	
	tp = constraint_dst::Disabled;
	skip_MM_nb = false;
	
	mindist = 0.0;
	minFC = 0.0;
	
	maxdist = 0.0;
	maxFC = 0.0;
}

constraint_dst::~constraint_dst(void)
{
}

bool constraint_dst::operator==(const constraint_dst & p1) const
{
	// compare objects so that if the atoms match (no matter what
	// the order is), then the objects are equal. this way one can
	// use for example the STL find() method for search etc...
	
	if (atmr[0] == p1.atmr[0] && atmr[1] == p1.atmr[1]) return true;
	if (atmr[0] == p1.atmr[1] && atmr[1] == p1.atmr[0]) return true;
	
	return false;
}

void constraint_dst::SetType(type p1)
{
	tp = p1;
}

void constraint_dst::SetSkipMMnb(bool p1)
{
	skip_MM_nb = p1;
}

void constraint_dst::SetMinDist(float p1)
{
	mindist = p1;
}

void constraint_dst::SetMinFC(float p1)
{
	minFC = p1;
}

void constraint_dst::SetMaxDist(float p1)
{
	maxdist = p1;
}

void constraint_dst::SetMaxFC(float p1)
{
	maxFC = p1;
}

constraint_dst::type constraint_dst::GetType(void) const
{
	return tp;
}

bool constraint_dst::GetSkipMMnb(void) const
{
	return skip_MM_nb;
}

float constraint_dst::GetMinDist(void) const
{
	return mindist;
}

float constraint_dst::GetMinFC(void) const
{
	return minFC;
}

float constraint_dst::GetMaxDist(void) const
{
	return maxdist;
}

float constraint_dst::GetMaxFC(void) const
{
	return maxFC;
}

/*################################################################################################*/

// eof
