------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2003-2012, AdaCore                     --
--                                                                          --
--  This library is free software;  you can redistribute it and/or modify   --
--  it under terms of the  GNU General Public License  as published by the  --
--  Free Software  Foundation;  either version 3,  or (at your  option) any --
--  later version. This library is distributed in the hope that it will be  --
--  useful, but WITHOUT ANY WARRANTY;  without even the implied warranty of --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--  You should have received a copy of the GNU General Public License and   --
--  a copy of the GCC Runtime Library Exception along with this program;    --
--  see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see   --
--  <http://www.gnu.org/licenses/>.                                         --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings.Unbounded;

with SOAP.Name_Space;

package SOAP.WSDL.Parameters is

   use Ada.Strings.Unbounded;

   type Kind is (K_Record, K_Array, K_Derived, K_Simple, K_Enumeration);
   subtype Compound_Type is Kind range K_Record .. K_Array;

   --  Enumeration values

   type E_Node;
   type E_Node_Access is access E_Node;

   type E_Node is record
      Value : Unbounded_String;
      Next  : E_Node_Access;
   end record;

   --  Parameter

   type Parameter;
   type P_Set is access Parameter;

   type Parameter (Mode : Kind) is record
      Name : Unbounded_String;
      NS   : Name_Space.Object;
      Next : P_Set;

      case Mode is
         when K_Simple =>
            P_Type : Parameter_Type;

         when K_Derived =>
            Parent_Type : Parameter_Type;   -- Parent type
            D_Name      : Unbounded_String; -- Derived type name

         when K_Array | K_Record =>
            T_Name : Unbounded_String; -- Type name
            E_Type : Unbounded_String; -- Array element's type
            Length : Natural;          -- Number of items (0 = unbounded)
            P      : P_Set;

         when K_Enumeration =>
            E_Name : Unbounded_String; -- Enumeration type name
            E_Def  : E_Node_Access;
      end case;
   end record;

   function Type_Name (P : WSDL.Parameters.P_Set) return String;
   --  Returns the type name for the given parameter

   procedure Append (P : in out P_Set; Param : Parameter);
   --  Add Param at the end of P

   function Length (P : P_Set) return Natural;
   --  Returns the number of items in P

   procedure Output (P : P_Set);
   --  Output parameter set, this is to be used for debugging purpose

   procedure Release (P : in out P_Set);
   --  Release memory associated the the parameter set

end SOAP.WSDL.Parameters;
