; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='default<O2>' -opaque-pointers -S | FileCheck %s

; Same test as coro-retcon.ll, but with opaque pointers enabled.

define ptr @f(ptr %buffer, i32 %n) {
; CHECK-LABEL: @f(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[BUFFER:%.*]], align 4
; CHECK-NEXT:    tail call void @print(i32 [[N]])
; CHECK-NEXT:    ret ptr @f.resume.0
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 8, i32 4, ptr %buffer, ptr @prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:                                             ; preds = %resume, %entry
  %n.val = phi i32 [ %n, %entry ], [ %inc, %resume ]
  call void @print(i32 %n.val)
  %unwind0 = call i1 (...) @llvm.coro.suspend.retcon.i1()
  br i1 %unwind0, label %cleanup, label %resume

resume:                                           ; preds = %loop
  %inc = add i32 %n.val, 1
  br label %loop

cleanup:                                          ; preds = %loop
  %0 = call i1 @llvm.coro.end(ptr %hdl, i1 false)
  unreachable
}

define i32 @main() {
; CHECK-LABEL: @main(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @print(i32 4)
; CHECK-NEXT:    call void @print(i32 5), !noalias !0
; CHECK-NEXT:    call void @print(i32 6), !noalias !3
; CHECK-NEXT:    ret i32 0
;
entry:
  %0 = alloca [8 x i8], align 4
  %prepare = call ptr @llvm.coro.prepare.retcon(ptr @f)
  %cont0 = call ptr %prepare(ptr %0, i32 4)
  %cont1 = call ptr %cont0(ptr %0, i1 zeroext false)
  %cont2 = call ptr %cont1(ptr %0, i1 zeroext false)
  %1 = call ptr %cont2(ptr %0, i1 zeroext true)
  ret i32 0
}

define hidden { ptr, ptr } @g(ptr %buffer, ptr %ptr) {
; CHECK-LABEL: @g(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call ptr @allocate(i32 8)
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[BUFFER:%.*]], align 8
; CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[TMP0]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue { ptr, ptr } { ptr @g.resume.0, ptr undef }, ptr [[PTR]], 1
; CHECK-NEXT:    ret { ptr, ptr } [[TMP1]]
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 8, i32 4, ptr %buffer, ptr @g_prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:                                             ; preds = %resume, %entry
  %unwind0 = call i1 (...) @llvm.coro.suspend.retcon.i1(ptr %ptr)
  br i1 %unwind0, label %cleanup, label %resume

resume:                                           ; preds = %loop
  br label %loop

cleanup:                                          ; preds = %loop
  %0 = call i1 @llvm.coro.end(ptr %hdl, i1 false)
  unreachable
}

declare token @llvm.coro.id.retcon(i32, i32, i8*, i8*, i8*, i8*)
declare i8* @llvm.coro.begin(token, i8*)
declare i1 @llvm.coro.suspend.retcon.i1(...)
declare i1 @llvm.coro.end(i8*, i1)
declare i8* @llvm.coro.prepare.retcon(i8*)

declare i8* @prototype(i8*, i1 zeroext)
declare {i8*,i8*} @g_prototype(i8*, i1 zeroext)

declare noalias i8* @allocate(i32 %size)
declare void @deallocate(i8* %ptr)

declare void @print(i32)
