; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Verify that an excessive size to strncmp() isn't truncated to an in-bounds
; value that results in the call being incorrectly folded (as might happen
; when LLVM is compiled in ILP32 mode).

declare i32 @strncmp(i8*, i8*, i64)

@ax = external global [0 x i8]
@bx = external global [0 x i8]

@a12345 = constant [5 x i8] c"\01\02\03\04\05"
@a123456 = constant [6 x i8] c"\01\02\03\04\05\06"


; Do not fold strncmp(ax, bx, UINT_MAX + (size_t)1) to 0.

define i32 @call_strncmp_ax_bx_uimax_p1() {
; CHECK-LABEL: @call_strncmp_ax_bx_uimax_p1(
; CHECK-NEXT:    [[RES:%.*]] = call i32 @strncmp(i8* noundef nonnull dereferenceable(1) getelementptr inbounds ([0 x i8], [0 x i8]* @ax, i64 0, i64 0), i8* noundef nonnull dereferenceable(1) getelementptr inbounds ([0 x i8], [0 x i8]* @bx, i64 0, i64 0), i64 4294967296)
; CHECK-NEXT:    ret i32 [[RES]]
;

  %p1 = getelementptr [0 x i8], [0 x i8]* @ax, i32 0, i32 0
  %p2 = getelementptr [0 x i8], [0 x i8]* @bx, i32 0, i32 0
  %res = call i32 @strncmp(i8* %p1, i8* %p2, i64 4294967296)
  ret i32 %res
}


; Do not fold strncmp(ax, bx, UINT_MAX + (size_t)2) to *ax - *bx.

define i32 @call_strncmp_ax_bx_uimax_p2() {
; CHECK-LABEL: @call_strncmp_ax_bx_uimax_p2(
; CHECK-NEXT:    [[RES:%.*]] = call i32 @strncmp(i8* noundef nonnull dereferenceable(1) getelementptr inbounds ([0 x i8], [0 x i8]* @ax, i64 0, i64 0), i8* noundef nonnull dereferenceable(1) getelementptr inbounds ([0 x i8], [0 x i8]* @bx, i64 0, i64 0), i64 4294967296)
; CHECK-NEXT:    ret i32 [[RES]]
;

  %p1 = getelementptr [0 x i8], [0 x i8]* @ax, i32 0, i32 0
  %p2 = getelementptr [0 x i8], [0 x i8]* @bx, i32 0, i32 0
  %res = call i32 @strncmp(i8* %p1, i8* %p2, i64 4294967296)
  ret i32 %res
}


; Fold strncmp(a12345, a123456, UINT_MAX + (size_t)2) to -1 (and not to 0).

define i32 @fold_strncmp_a12345_2_uimax_p2() {
; CHECK-LABEL: @fold_strncmp_a12345_2_uimax_p2(
; CHECK-NEXT:    ret i32 -1
;

  %p1 = getelementptr [5 x i8], [5 x i8]* @a12345, i32 0, i32 0
  %p2 = getelementptr [6 x i8], [6 x i8]* @a123456, i32 0, i32 0
  %res = call i32 @strncmp(i8* %p1, i8* %p2, i64 4294967297)
  ret i32 %res
}


; Fold strncmp(a123456, a12345, UINT_MAX + (size_t)3) to +1 (and not to 0).

define i32 @fold_strncmp_a12345_2_uimax_p3() {
; CHECK-LABEL: @fold_strncmp_a12345_2_uimax_p3(
; CHECK-NEXT:    ret i32 1
;

  %p1 = getelementptr [6 x i8], [6 x i8]* @a123456, i32 0, i32 0
  %p2 = getelementptr [5 x i8], [5 x i8]* @a12345, i32 0, i32 0
  %res = call i32 @strncmp(i8* %p1, i8* %p2, i64 4294967298)
  ret i32 %res
}
