package tests::UIBoolWidgetTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;

use Curses::UI;

use Lire::Test::CursesUIDriver;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );


    my $spec = new Lire::Config::ConfigSpec( 'name' => 'lire' );
    $spec->add( new Lire::Config::BooleanSpec( 'name' => 'test' ) );
    $self->{'bool_value'} = $spec->get( 'test' )->instance( 'value' => 1 );
    $self->{'spec'} = $spec;

    return;
}


sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $win = $self->{'window'};
    $self->assert_dies( qr{missing 'value' parameter},
                        sub { my $widget = $win->add( 'test_widget',
                                                      'Lire::UI::BoolWidget' ) });
    $self->assert_dies( qr{'value' parameter should be a 'Lire::Config::Scalar' instance, not 'HASH},
                        sub { my $widget = $win->add( 'test_widget',
                                                      'Lire::UI::BoolWidget',
                                                      'Value' => {} ) });

    my $widget = $win->add( 'test_widget', 'Lire::UI::BoolWidget',
                            'value' => $self->{'bool_value'} );
    $self->assert_isa( 'Lire::UI::BoolWidget', $widget );
    $self->assert_str_equals( \&Lire::UI::BoolWidget::_on_change_cb,
                              $widget->{'-onchange'} );
    $self->assert_deep_equals( [ 'yes', 'no' ], $widget->{'-values'} );
    $self->assert_str_equals( 0, $widget->{'-selected'} );

    return;
}


sub test_refresh_view {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'test_widget', 'Lire::UI::BoolWidget',
                                         'value' => $self->{'bool_value'} );
    $self->{'bool_value'}->set( 'false' );
    $widget->refresh_view();
    $self->assert_num_equals( 1, $widget->{'-selected'} );
    $self->{'bool_value'}->set( 'true' );
    $widget->refresh_view();
    $self->assert_num_equals( 0, $widget->{'-selected'} );
}

sub test_on_change_cb {
    my $self = $_[0];

    my $called = 'onvaluechanged not called';
    my $win = $self->{'window'};
    my $widget = $win->add( 'test_widget', 'Lire::UI::BoolWidget',
                            'value' => $self->{'bool_value'},
                            'onvaluechanged' => sub { $called = 'called' } );
    $widget->{'-selected'} = 1;
    Lire::UI::BoolWidget::_on_change_cb( $widget );
    $self->assert( ! $self->{'bool_value'}->as_value(), "! as_value()" );
    $widget->{'-selected'} = 0;
    Lire::UI::BoolWidget::_on_change_cb( $widget );
    $self->assert( $self->{'bool_value'}->as_value(), "as_value()" );
    $self->assert_str_equals( 'called', $called );
}

1;
