
# CMake script file to process a text file by wrapping every line in double quotes.
# Input file must not abuse quotes, staying with single quotes is probably best.

set( lines "" )
file( STRINGS ${inputFile} lines )

file( WRITE ${outputFile} "// Do not edit this file, it is autogenerated by CMake from an HTML file\n" )

foreach( line ${lines} )
    STRING(REGEX REPLACE "\"" "\\\\\"" linem ${line})
    file( APPEND ${outputFile} "\"" ${linem} "\\n\"\n" )
endforeach( line ${lines} )
