#***************************************************************************
# *   Copyright (C) 2003 by abdulhaq                                        *
# *   aalynch@users.sourceforge.net                                        *
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License version 2 as published by  *
# *   the Free Software Foundation;                                         *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
# ***************************************************************************/

from PyQt4 import QtGui, QtCore

import logging
l = logging.getLogger(__name__)

class ComboEdit(QtGui.QComboBox):
    def __init__(self,*args):
        QtGui.QComboBox.__init__(self,*args)
        self.setEditable(True)

    def keyPressEvent(self,event):
        if event.key() == Qt.Key_Return and len(self.currentText()) > 0:
            event.ignore()
            l.debug( "key pressed")
            self.emit(PYSIGNAL("returnPressed"),())
        else:
            event.accept()
        QtGui.QComboBox.keyPressEvent(self,event)

    def addFunc(self,func):
        text = self.currentText()
        text += func + "()"
        self.setCurrentText(text)
