#***************************************************************************
# *   Copyright (C) 2003 by A Lynch                                  *
# *   aalynch@users.sourceforge.net                                        *
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License version 2 as published by  *
# *   the Free Software Foundation;                                         *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
# ***************************************************************************/

import os, sys

from PyQt4 import QtGui, QtCore

from qt4gui import calcwindow
from qt4gui import equationdraw
from qt4gui import equationtable
from qt4gui import notebook
from qt4gui import comboedit
from qt4gui import plotimpl
from qt4gui import graphlabel
from qt4gui import nodedebuggerimpl
import equation
import node

from icons import getIcon

import constants
from configuration import config

import logging
l = logging.getLogger(__name__)

class CalcMainWindow(QtGui.QMainWindow):
    def __init__(self, *params):
        QtGui.QMainWindow.__init__(self, *params)

    def closeEvent(self, *params):
        return self.closing(*params)

class CalcWindowImpl(CalcMainWindow):
    def __init__(self, parent, control):
        CalcMainWindow.__init__(self, parent)

        try:
            l.debug("setup ui")
            self.ui = calcwindow.Ui_CalcWindow()
            self.ui.setupUi(self)
            l.debug("completed setup ui")
            
            self.control = control

            self.currentObjIndex = None
            
            self.debugwin = None
            if config["shownodedebugger"]:
                self.debugwin = nodedebuggerimpl.NodeDebuggerImpl(None)
                self.debugwin.show()
                
            self.updateActionIcons()

            notebookLayout = QtGui.QHBoxLayout(self.ui.tabNotebook)
            notebookScrollArea = QtGui.QScrollArea(self.ui.tabNotebook)
            notebookScrollArea.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOn)
            #notebookScrollArea.setWidgetResizable(True)
            self.notebook = notebook.Notebook(control, self, notebookScrollArea)
            notebookLayout.addWidget(notebookScrollArea)
            notebookScrollArea.setWidget(self.notebook)
            notebookLayout.addWidget(notebookScrollArea)
            self.verticalScrollBar = notebookScrollArea.verticalScrollBar()
            self.notebook.show()

            self.ui.lbInput.setFocus()
            self.ui.lbInput.setSizeAdjustPolicy(QtGui.QComboBox.AdjustToMinimumContentsLength)

            l.debug("add examples")
            # prime the list box with demo commands
            self.ui.lbInput.addItem("sum(f(i),i,0,m) * sum(g(j),j,0,n)")
            self.ui.lbInput.addItem("for a:-3 thru 26 step 7 do display(a)")
            self.ui.lbInput.addItem("limit( (2*x+1)/(3*x+2),  x,inf )")
            self.ui.lbInput.addItem("limit( sin(3*x)/x,  x,0)")
            self.ui.lbInput.addItem("block([FPPREC:100],bfloat(%pi))")
            self.ui.lbInput.addItem("block([FPPREC:100],sin(bfloat(%pi)))")
            self.ui.lbInput.addItem("solve([x+y+z=5,3*x-5*y=10,y+2*z=3],[x,y,z])")
            self.ui.lbInput.addItem("solve(x^2-5*x+6 =0,x)")
            self.ui.lbInput.addItem("factor(x^6-1)")
            self.ui.lbInput.addItem("A:matrix([1,2],[3,4])")
            self.ui.lbInput.addItem("B:matrix([1,1],[1,1])")
            self.ui.lbInput.addItem("A + B")
            self.ui.lbInput.addItem("A . B")
            self.ui.lbInput.addItem("A^^-1")
            self.ui.lbInput.addItem("determinant(matrix([a,b],[c,d]))")
            self.ui.lbInput.addItem("matrix([integrate(1/(1+x^2),x, 0, inf), diff(x^2,x)],[%PI,%E])")
            self.ui.lbInput.addItem("diff(exp(f(x)),x,5)")
            self.ui.lbInput.addItem("f(x):=x+2 ")
            self.ui.lbInput.addItem("f(3)")
            self.ui.lbInput.addItem("g(x):=block([u:x+3,w], u:u^2, w:(y+2)^2, u+w)")
            self.ui.lbInput.addItem("h(x):=block([u:x+3,w], u:u^2, if (u<3) then  w:(y+2)^2 else w:(Y+2)^2+1,u+w)")
            self.ui.lbInput.addItem("(x+1)^(3*Y^Y)")
            self.ui.lbInput.addItem("atan(-x^2+y^3/4)")
            self.ui.lbInput.addItem("integrate(1/(1+x^2),x, 0, inf)")
            self.ui.lbInput.addItem("integrate(1/(1+x^3),x)")
            self.ui.lbInput.addItem("integrate(1/(x^5 + a^2 +1),x)")
            self.ui.lbInput.addItem("sin(%PI*(x^2 + y^2))/(%PI*(x^2 + y^2))")
            self.ui.lbInput.addItem("[(2/3),4,(x+y)/(Y^Y^Y)]/sqrt(x)")
            self.ui.lbInput.addItem("1/SQRT(x)-(y/x^(3/2)+1/SQRT(x))/2")
            self.ui.lbInput.addItem("moebius: [cos(x)*(3+y*cos(x/2)),sin(x)*(3+y*cos(x/2)),y*sin(x/2)]")
            self.ui.lbInput.addItem("klein: [5*cos(x)*(cos(x/2)*cos(y)+sin(x/2)*sin(2*y)+3.0)-10.0,-5*sin(x)*(cos(x/2)*cos(y)+sin(x/2)*sin(2*y)+3.0),5*(-sin(x/2)*cos(y)+cos(x/2)*sin(2*y))]")
            self.ui.lbInput.addItem("integrate(cos(%ETA),%ETA)")
            self.ui.lbInput.addItem("ode2('diff(y,x)+3*x*y = sin(x)/x,y,x)")
            self.ui.lbInput.addItem("ode2('diff(y,x) -y = 1, y,x)")
            self.ui.lbInput.addItem("ode2('diff(y,x,2) - y = 1, y,x)")
            self.ui.lbInput.addItem("a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+y+z")
            self.ui.lbInput.addItem("expand((x+y+z)^10)")
            self.ui.lbInput.addItem("expand((%ALPHA + %BETA + %GAMMA + %DELTA + %EPSILON)^3)")
            self.ui.lbInput.clearEditText()
            #self.ui.lbInput.setMaximumWidth(400)
            self.ui.lbInput.installEventFilter(self)
            
            self.ui.pbFont.setText("Font (%s)" % config["tablefont"])

            self.connect(self.ui.pbEvaluate,QtCore.SIGNAL("clicked()"),self.processUserEquation)
            self.connect(self.ui.actionIntegrate,QtCore.SIGNAL("triggered()"),self.integrate)
            self.connect(self.ui.actionDifferentiate,QtCore.SIGNAL("triggered()"),self.differentiate)
            self.connect(self.ui.actionExpand,QtCore.SIGNAL("triggered()"),self.expand)
            self.connect(self.ui.actionFactor,QtCore.SIGNAL("triggered()"),self.factor)
            self.connect(self.ui.actionPlot,QtCore.SIGNAL("triggered()"),self.control.plot)
            self.connect(self.ui.actionExit,QtCore.SIGNAL("triggered()"),self.exit)
            self.connect(self.ui.actionSave_As_PDF,QtCore.SIGNAL("triggered()"),self.saveAsPDF)
            self.connect(self.ui.actionPreferences,QtCore.SIGNAL("triggered()"),self.viewPreferences)
            self.connect(self.ui.pbFont,QtCore.SIGNAL("clicked()"),self.chooseFont)
            #self.connect(self.ui.tbMainView,QtCore.SIGNAL("currentChanged(QWidget *)"),self.tabChanged)
            
            l.debug("create plot window")
            self.dlgPlot = plotimpl.PlotImpl(self)

            #self.tableContextMenu.insertItem( "Copy &Text Formula", self.control.plot, QtGui.CTRL+Qt.Key_T )
            #self.tableContextMenu.insertItem( "Copy &Bitmap", self.control.plot, QtGui.CTRL+Qt.Key_B )
            #self.tableContextMenu.insertItem( "Delete &Row", self.deleteCurrentRow )

            self.currentTabIndex = 1
        except:
            l.exception("creating calcwindow")
            
    def updateActionIcons(self):
        self.setWindowIcon(getIcon("kayali"))
        self.ui.actionIntegrate.setIcon(getIcon("integrate"))
        self.ui.actionDifferentiate.setIcon(getIcon("differentiate"))
        self.ui.actionExpand.setIcon(getIcon("expand"))
        self.ui.actionFactor.setIcon(getIcon("factor"))
        self.ui.actionSaveScript.setIcon(getIcon("filesave"))
        self.ui.actionPlayScript.setIcon(getIcon("fileopen"))
        self.ui.actionC_ut.setIcon(getIcon("editcut"))
        self.ui.action_Copy.setIcon(getIcon("editcopy"))
        self.ui.action_Paste.setIcon(getIcon("editpaste"))
        self.ui.actionExit.setIcon(getIcon("exit"))
        self.ui.actionPlot.setIcon(getIcon("plot"))
        self.ui.actionSave_As_PDF.setIcon(getIcon("acroread"))
        self.ui.actionPreferences.setIcon(getIcon("preferences"))

    def exit(self):
        sys.exit(0)

    def closing(self, *params):
        l.debug("closing")
        if self.debugwin:
            self.debugwin.close()
        try:
            self.control.processInput("quit(1)")
        except:
            pass
            
    def chooseFont(self):
        selectedFont, ok = QtGui.QFontDialog.getFont(QtGui.QFont(self.font(), self))
        if ok:
            config["tablefont"] = selectedFont.family()
            config["tablefontsize"] = selectedFont.pointSize()
            self.ui.pbFont.setText("Font (%s)" % config["tablefont"])
            
    def eventFilter(self, object, event):
        #l.debug("event")
        if event.type() == QtCore.QEvent.KeyPress and event.key() == QtCore.Qt.Key_Return and len(self.ui.lbInput.currentText()) > 0:
            l.debug( "return key pressed")
            self.processUserEquation()
        return False
            
    def eqCellClicked(self, row):
        if self.debugwin:
            selectedNode = equation.DrawObject.drawobjects[row].node
            self.debugwin.setRootNode(selectedNode)
        
    def eqCellDoubleClicked(self, row):
        selectedText = equation.DrawObject.drawobjects[row].text
        self.ui.lbInput.setEditText(selectedText)
            
    def postInitialise(self):
        pass
    
    def processUserEquation(self):
        input = str(self.ui.lbInput.currentText())
        self.control.processInput(input)

    def insertInputListbox(self,input):
        self.ui.lbInput.addItem(self.ui.lbInput.currentText())

    def clearInput(self):
        self.ui.lbInput.clearEditText()

    def setOutput(self,output):
        pass

    def addRow(self,index,id,io):
        self.notebook.addRow(index,id,io)
        if io == "o":
            self.verticalScrollBar.setValue(self.verticalScrollBar.maximum())
        
    def getTableColumnWidth(self):
        return self.notebook.width()

    def clearDlgPlot(self):
        self.dlgPlot.clear()

    def showDlgPlotVars(self, vars):
        self.dlgPlot.showVars(vars)

    def setDlgPlotContents(self, contents):
        pass
        #self.dlgPlot.equation.setContents(contents)

    def doDlgPlot(self):
        if self.dlgPlot.exec_() == QtGui.QDialog.Accepted:
            return constants.DLG_ACCEPTED
        else:
            return constants.DLG_CANCELLED

    def addPlotView(self):
        # set up new tab
        pxLabel = graphlabel.GraphLabel(self)
        pxLabel.setScaledContents(True)
        pxLabel.tab = self.ui.tbMainView
        self.ui.tbMainView.addTab(pxLabel,"Plot")
        self.ui.tbMainView.setCurrentWidget(pxLabel)
        pxLabel.resize(self.ui.tbMainView.size())
        return pxLabel

    def getPlotOptions(self):
        return self.dlgPlot.getPlotOptions()

    def getPlotCommand(self,equationtext, vars, options, showGnuplot,x, y, filename):
        return self.dlgPlot.getPlotCommand(equationtext, vars, options, showGnuplot, x, y, filename)

    def makePixmapsOf(self, psfilename):
        outputPng = os.path.join(config["tempdir"],"gplot.png")
        outputThumbPng = os.path.join(config["tempdir"],"gplotthumb.png")
        os.system("convert -rotate 90 -resize 600x600 %s %s" % (psfilename, outputPng))
        myPlot = QtGui.QPixmap()
        myPlot.load(outputPng)
        os.system("convert -rotate 90 -resize 300x300 %s %s" % (psfilename, outputThumbPng))
        myPlotThumbnail = QtGui.QPixmap()
        myPlotThumbnail.load(outputThumbPng)
        return (myPlot, myPlotThumbnail)

    def setPlotPixmap(self,plotWidget,pixmap):
        plotWidget.setPixmap(pixmap)

    def getCurrentEquation(self):
        if self.ui.lbInput.hasFocus():
            currentEquation = str(self.ui.lbInput.currentText())
        else:
            currentEquation = equation.DrawObject.drawobjects[int(self.currentObjIndex)].text
        return currentEquation

    def cos(self):
        self.ui.lbInput.addFunc("cos")
    def sin(self):
        self.ui.lbInput.addFunc("sin")
    def factor(self):
        self.ui.lbInput.addFunc("factor")
    def expand(self):
        self.ui.lbInput.addFunc("expand")

    def integrate(self):
        l.debug("integrate")
        equation = self.getCurrentEquation()
        self.control.integrate(equation)

    def differentiate(self):
        equation = self.getCurrentEquation()
        self.control.differentiate(equation)
        
    def saveAsPDF(self):
        l.debug("save as PDF")
        fileName = QtGui.QFileDialog.getSaveFileName(self,"Choose a filename to save under",config["homedir"],"PDF (*.pdf)")
        if fileName:
            self.control.saveAsPDF(fileName)
            
    def viewPreferences(self):
        pass
            

               
